MODULE xsort;
(* Odd-Even Transposition Sorting (parallel bubble-sort) *)
(* With X Window Visualization, Braunl, 1992             *)
FROM Graphics IMPORT OpenWindow, CloseWindow, SetgLineZ, window;

CONST n    = 128;
      zoom =   2;
CONFIGURATION list [1..n];
CONNECTION left: list[i] <-> list [i-1] :right;

VAR step    : INTEGER;
    win     : window;
    a       : ARRAY[1..n] OF INTEGER;
    ch      : CHAR;
    val,comp: list OF INTEGER;
    lhs     : list OF BOOLEAN;

BEGIN
  val := RandomInt(list) MOD 256;  (* random init [0..255] *)
  win := OpenWindow("xsort", zoom*n, zoom*n); 
  lhs := ODD(ID(list));  (* PE is left-hand-side of a comparison *)
  SetgLineZ(val,0, 0,zoom);
  FOR step:=1 TO n DO
    IF lhs THEN comp := RECEIVE.left (val)
           ELSE comp := RECEIVE.right(val)
    END;
    IF lhs = (comp<val) THEN val:=comp END;
    lhs := NOT lhs;
    SetgLineZ(val,zoom*step, 0,zoom);
  END;

  WriteString("Press RETURN for termination"); WriteLn;
  Read(ch);
  CloseWindow(win);
END xsort.

