MODULE xsortc;
(* Odd-Even Transposition Sorting (parallel bubble-sort) *)
(* With X Window Visualization, Braunl, 1992             *)
FROM Graphics IMPORT OpenWindow, CloseWindow, SetLineZ, window;
FROM ImageIO  IMPORT color, gray;
FROM Trans    IMPORT gray2rainbow;

CONST n    = 128;
      zoom =   2;
CONFIGURATION list [1..n];
CONNECTION left: list[i] <-> list [i-1] :right;

VAR step      : INTEGER;
    win       : window;
    a         : ARRAY[1..n] OF INTEGER;
    ch        : CHAR;
    lhs       : list OF BOOLEAN;
    entry,comp: list OF RECORD
                         val: INTEGER;
                         col: color;
                        END;

BEGIN
  win := OpenWindow("xsort", zoom*n, zoom*n); 
  entry.val := RandomInt(list) MOD 256;  (* random init [0..255] *)
  entry.col := gray2rainbow(entry.val);
  lhs := ODD(ID(list));  (* PE is left-hand-side of a comparison *)
  SetLineZ(entry.col,0, 0,zoom);
  FOR step:=1 TO n DO
    IF lhs THEN comp := RECEIVE.left (entry)
           ELSE comp := RECEIVE.right(entry)
    END;
    IF lhs = (comp.val < entry.val) THEN entry:=comp END;
    lhs := NOT lhs;
    SetLineZ(entry.col,zoom*step, 0,zoom);
  END;

  WriteString("Press RETURN for termination"); WriteLn;
  Read(ch);
  CloseWindow(win);
END xsortc.

