static char _sccsid[] = "Parallaxis Version: @(#)calc.c	2.13  2/28/92 15:09:54";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : calc.c                                                            */
/*                                                                           */
/* Funktionen, die konstante Ausdruecke ermitteln und berechnen              */
/*                                                                           */
/* ************************************************************************* */


#include "pass2.h"
#include "scope.h"

#ifdef PC
#define HUGE 3.4e38
# ifdef MAC
extern int errno;
# endif
#else
# ifdef HP
#  undef HUGE
#  define HUGE MAXFLOAT
# endif
#endif
extern long int_potenz();
extern float real_int_potenz();
extern float real_potenz();
extern int LINE1, LINE2, COL1, COL2;
extern int fp_error;
int calc_verbindungen = 0;



/* ************************************************************************* */
/* vergleiche zwei konstante Strukturen auf Gelichheit                       */
/*                                                                           */
/* Ergebnis : 0 bei ungleich; sonst 1                                        */
/*                                                                           */
/* Parameter : 1. Liste der Konstanten                                       */
/*             2. Liste der Konstanten                                       */
/*                                                                           */
/* ************************************************************************* */

int record_const_vergleichen(c1,c2)
ST_CONST * c1 , * c2;
{ ST_CONST * c;
  while (c1 && c2)
  { if (c = eval_binexpr('=',c1,c2))
    { if (c->wert.range.val == 0)
      { my_free(c);
        return 0;
      }
      else
      { my_free(c); }
    }
    else
    { return 0; }
    c1 = c1->link;
    c2 = c2->link;
  }
  if ((c1 == NULL) && (c2 == NULL))
    return 1;
  return 0;
}


/* ************************************************************************* */
/* ermittelt eine Konstante aus einer Strukturkonstanten                     */
/*                                                                           */
/* Ergebnis : Konstante                                                      */
/*                                                                           */
/* Parameter : Strukturkonstante                                             */
/*             Typ der Strukturkonstanten                                    */
/*             Auswahlbeschreibung                                           */
/*             Typ des Ergebnisses                                           */
/*                                                                           */
/* ************************************************************************* */

ST_CONST * hole_Constkomp(Const,typ,design,erg_typ)
ST_CONST * Const;
ST_TYPE * typ, ** erg_typ;
T_DESIGNREST * design;
{ if (design != NULL)
  { if (design->link != NULL)
    { Const = hole_Constkomp(Const,typ,design->link,erg_typ);
      typ = *erg_typ;
    }
    if ((design->select == D_RECORD) && (typ != NULL))
    { if ((typ->Art == ST_TRECORD) || (typ->Art == ST_TRECORDREST))
      { Eintrag * rueck;
        rueck = suche_Eintrag(design->design.ident->wert.ident_nr,typ->info.record.symtab,
                              LOCAL,akt_timestamp);
        if (rueck != NULL)
        { int nr, i, c;
          ST_CONST * con;
          MEMBERS * m = typ->info.record.mem;
          nr = rueck->param.komp.reladr;
          c = 0;
          suche_komponente(nr,0,m,&c);
          if ((Const != NULL) && (Const->Art == ST_CREC))
          { Const = Const->wert.recConst;
            for (i = 0; i < c; i++)
            { Const = Const->link; }
            GET_MEM(con,1,ST_CONST);
            *con = *Const;
            con->link = NULL;
            Const = con;
            typ = rueck->param.komp.type;
          }
        }
        else
        { SEMERROR(design->design.ident->Zeile,design->design.ident->Posit,0,0,
                   text[178]);
          interpreter = 1;
          typ = NULL;
        }
      }
      else
      { SEMERROR(design->design.ident->Zeile,design->design.ident->Posit,0,0,
                 text[179]);
        interpreter = 1;
        typ = NULL;
      }
    }
    else
    { if (typ != NULL)
      { T_EXPR * ex = design->design.exprlist;
        while (ex->link != NULL)
        { ex = ex->link; }
        SEMERROR(ex->Zeile,ex->Posit,0,0,
                 text[180]);
        interpreter = 1;
        typ = NULL;
      }
    }
  }
  * erg_typ = typ;
  return Const;
}

/* ************************************************************************* */
/* berechnet konstanten Ausdruck von zwei Operanden                          */
/*                                                                           */
/* Ergebnis : Konstante                                                      */
/*                                                                           */
/* Parameter : Operationsnummer                                              */
/*             Operand 1                                                     */
/*             Operand 2                                                     */
/*                                                                           */
/* ************************************************************************* */

ST_CONST * eval_binexpr(op,c1,c2)
int op;
ST_CONST * c1, * c2;
{ int a1,a2;
  long i1,i2;
  int e1, b1,b2;
  unsigned * z1, *z2;
  float r1, r2;
  ST_CONST * c;
  GET_MEM(c,1,ST_CONST);
  c->gueltig = c1->gueltig * c2->gueltig;
  switch(a1 = c1->Art)
  { case ST_CINT :
      i1 = c1->wert.i;
      break;
    case ST_CREAL :
      r1 = c1->wert.r;
      break;
    case ST_CSTRING :
      i1 = * c1->wert.s.string;
      break;
    case ST_CBOOL :
      b1 = c1->wert.range.val;
      break;
    case ST_CSET :
      z1 = c1->wert.set.set;
      break;
    case ST_CENUM :
      i1 = c1->wert.range.val - c1->wert.range.von;
      a1 = ST_TINT;
      break;
    case ST_CEOL :
      i1 = '\0';
      a1 = ST_CSTRING;
      break;
    case ST_CPI :
      a1 = ST_CREAL;
      r1 = C_PI;
      break;
    case ST_CREC :
    case ST_CNIL :
     break;
    default :
      c->gueltig = 0;
      break;
  }
  switch(a2 = c2->Art)
  { case ST_CINT :
      i2 = c2->wert.i;
      break;
    case ST_CREAL :
      r2 = c2->wert.r;
      break;
    case ST_CSTRING :
      i2 = * c2->wert.s.string;
      break;
    case ST_CBOOL :
      b2 = c2->wert.range.val;
      break;
    case ST_CSET :
      z2 = c2->wert.set.set;
      break;
    case ST_CENUM :
      i2 = c2->wert.range.val - c2->wert.range.von;
      a2 = ST_TINT;
      break;
    case ST_CEOL :
      i2 = '\0';
      a2 = ST_CSTRING;
      break;
    case ST_CPI :
      a2 = ST_CREAL;
      r2 = C_PI;
      break;
    case ST_CREC :
    case ST_CNIL :
     break;
    default :
      c->gueltig = 0;
      break;
  }
  if (a1 != a2)
  { if ((a1 == ST_CREAL) || (a2 == ST_CREAL))
    { if (a1 == ST_CINT)
      { a1 = ST_CREAL;
        r1 = i1;
      }
      if (a2 == ST_CINT)
      { a2 = ST_CREAL;
        r2 = i2;
      }
    }
  }
  switch (a1)
  { case ST_CINT :
      switch (op)
      { case '+' :
          i1 = i1 + i2;
          e1 = ST_CINT;
          break;
        case '-' :
          i1 = i1 - i2;
          e1 = ST_CINT;
          break;
        case '*' :
          i1 = i1 * i2;
          e1 = ST_CINT;
          break;
        case POWER :
          if (i2 >= 0)
          { if ((i1 == 0) && (i2 == 0))
            { if (calc_verbindungen == 0)
              { SEMERROR(LINE1,COL1,LINE2,COL2,
                         text[321]);
                interpreter = 1;
                i1 = 0;
                c->gueltig = 0;
              }
              else
              { i1 = 1; }
            }
            else
            { i1 = int_potenz(i1,i2); }
          }
          else
          { if (calc_verbindungen == 0)
            { SEMERROR(LINE2,COL2,0,0,
                       text[322]);
              interpreter = 1;
              i1 = 0;
              c->gueltig = 0;
            }
            else
            { i1 = 0; }
          }
          e1 = ST_CINT;
          break;
        case '/' :
          e1 = ST_CREAL;
          if (i2 != 0)
          { r1 = i1 / i2;
            if (fp_error == JA)
            { fp_error = NEIN;
              if (c->gueltig)
                SEMERROR(LINE1,COL1,LINE2,COL2,
                         text[323]);
              interpreter = 1;
              r1 = HUGE;
              c->gueltig = 0;
            }
          }
          else
          { if (calc_verbindungen == 0)
            { if (c->gueltig)
                SEMERROR(LINE2,COL2,0,0,text[77]);
              r1 = 0;
              c->gueltig = 0;
              interpreter = 1;
            }
            else
            { r1 = 1.0; }
          }
          break;
        case _DIV :
          e1 = ST_CINT;
          if (i2 != 0)
          { i1 = i1 / i2;  }
          else
          { if (calc_verbindungen == 0)
            { if (c->gueltig)
                SEMERROR(LINE2,COL2,0,0,text[77]);
              i1 = 0;
              c->gueltig = 0;
              interpreter = 1;
            }
            else
            { i1 = 1; }
          }
          break;
        case _MOD :
          e1 = ST_CINT;
          if (i2 != 0)
          { i1 = i1 % i2;
            i1 = (i1 < 0) ? i1 + i2 : i1;
          }
          else
          { if (calc_verbindungen == 0)
            { if (c->gueltig)
                SEMERROR(LINE2,COL2,0,0,text[77]);
              i1 = 0;
              c->gueltig = 0;
              interpreter = 1;
            }
            else
            { i1 = 1; }
          }
          break;
        case '=' :
          b1 = (i1 == i2) ? 1 : 0;
          e1 = ST_CBOOL;
          break;
        case UNEQ :
          b1 = (i1 != i2) ? 1 : 0;
          e1 = ST_CBOOL;
          break;
        case '<' :
          b1 = (i1 < i2) ? 1 : 0;
          e1 = ST_CBOOL;
          break;
        case '>' :
          b1 = (i1 > i2) ? 1 : 0;
          e1 = ST_CBOOL;
          break;
        case GREQ :
          b1 = (i1 >= i2) ? 1 : 0;
          e1 = ST_CBOOL;
          break;
        case LEEQ :
          b1 = (i1 <= i2) ? 1 : 0;
          e1 = ST_CBOOL;
          break;
        case _IN :
          if (z2 != NULL)
          { i2 = z2[i1 / (sizeof(int) * 8)];
            b1 = ((i2 & (1 << (i1 % (sizeof(int) * 8)))) == 0) ? 0 : 1;
          }
          else
          { b1 = 0; }
          e1 = ST_CBOOL;
          break;
        default :
          c->gueltig = 0;
          break;
      }
      break;
    case ST_CREAL :
      switch (op)
      { case '+' :
          e1 = ST_CREAL;
          r1 = r1 + r2;
          if (fp_error == JA)
          { fp_error = NEIN;
            if (c->gueltig)
              SEMERROR(LINE1,COL1,LINE2,COL2,
                       text[323]);
            r1 = HUGE;
            c->gueltig = 0;
            interpreter = 1;
          }
          break;
        case '-' :
          e1 = ST_CREAL;
          r1 = r1 - r2;
          if (fp_error == JA)
          { fp_error = NEIN;
            if (c->gueltig)
              SEMERROR(LINE1,COL1,LINE2,COL2,
                       text[323]);
            r1 = HUGE;
            c->gueltig = 0;
            interpreter = 1;
          }
          break;
        case '*' :
          e1 = ST_CREAL;
          r1 = r1 * r2;
          if (fp_error == JA)
          { fp_error = NEIN;
            if (c->gueltig)
              SEMERROR(LINE1,COL1,LINE2,COL2,
                       text[323]);
            r1 = HUGE;
            c->gueltig = 0;
            interpreter = 1;
          }
          break;
        case POWER :
          e1 = ST_CREAL;
          if (a2 == ST_CREAL)
          { if (r1 > 0)
            { r1 = real_potenz(r1, r2);
              if (fp_error == JA)
              { fp_error = NEIN;
                if (c->gueltig)
                  SEMERROR(LINE1,COL1,LINE2,COL2,
                           text[323]);
                r1 = HUGE;
                c->gueltig = 0;
                interpreter = 1;
              }
            }
            else
            { if ((r1 == 0) && (r2 > 0))
              { r1 = 0; }
              else
              { if (r1 < 0)
                { if (calc_verbindungen == 0)
                  { if (c->gueltig)
                      SEMERROR(LINE1,COL1,0,0,
                               text[325]);
                    c->gueltig = 0;
                  }
                  r1 = 0;
                }
                else
                { if (calc_verbindungen == 0)
                  { if (c->gueltig)
                      SEMERROR(LINE1,COL1,LINE2,COL2,
                               text[326]);
                    c->gueltig = 0;
                  }
                  r1 = 0;
                }
                interpreter = 1;
              }
            }
          }
          else
          { if (r1 != 0)
            { r1 = real_int_potenz(r1, i2);
              if (fp_error == JA)
              { fp_error = NEIN;
                if (c->gueltig)
                  SEMERROR(LINE1,COL1,LINE2,COL2,
                           text[323]);
                r1 = HUGE;
                c->gueltig = 0;
                interpreter = 1;
              }
            }
            else
            { if (i2 > 0)
              { r1 = 0; }
              else
              { if (calc_verbindungen == 0)
                { if (c->gueltig)
                    SEMERROR(LINE1,COL1,LINE2,COL2,
                             text[326]);
                  c->gueltig = 0;
                  interpreter = 1;
                }
                r1 = 0;
              }
            }
          }
          break;
        case '/' :
          e1 = ST_CREAL;
          if (r2 != 0)
          { r1 = r1 / r2;
            if (fp_error == JA)
            { fp_error = NEIN;
              if (c->gueltig)
                SEMERROR(LINE1,COL1,LINE2,COL2,
                         text[323]);
              r1 = HUGE;
              c->gueltig = 0;
              interpreter = 1;
            }
          }
          else
          { if (calc_verbindungen == 0)
            { if (c->gueltig)
                SEMERROR(LINE2,COL2,0,0,text[77]);
              c->gueltig = 0;
              interpreter = 1;
            }
            r1 = 0;
          }
          break;
        case '=' :
          b1 = (r1 == r2) ? 1 : 0;
          e1 = ST_CBOOL;
          break;
        case UNEQ :
          b1 = (r1 != r2) ? 1 : 0;
          e1 = ST_CBOOL;
          break;
        case '<' :
          b1 = (r1 < r2) ? 1 : 0;
          e1 = ST_CBOOL;
          break;
        case '>' :
          b1 = (r1 > r2) ? 1 : 0;
          e1 = ST_CBOOL;
          break;
        case GREQ :
          b1 = (r1 >= r2) ? 1 : 0;
          e1 = ST_CBOOL;
          break;
        case LEEQ :
          b1 = (r1 <= r2) ? 1 : 0;
          e1 = ST_CBOOL;
          break;
        default :
          c->gueltig = 0;
          break;
      }
      break;
    case ST_CBOOL :
      e1 = ST_CBOOL;
      switch (op)
      { case _AND :
          b1 *= b2;
          break;
        case _OR :
          b1 |= b2;
          break;
        case '=' :
          b1 = (b1 == b2) ? 1 : 0;
          break;
        case UNEQ :
          b1 = (b1 != b2) ? 1 : 0;
          break;
        case '<' :
          b1 = (b1 < b2) ? 1 : 0;
          break;
        case '>' :
          b1 = (b1 > b2) ? 1 : 0;
          break;
        case GREQ :
          b1 = (b1 >= b2) ? 1 : 0;
          break;
        case LEEQ :
          b1 = (b1 <= b2) ? 1 : 0;
          break;
        case _IN :
          if (z2 != NULL)
          { b1 = ((*z2 & (1 << b1)) == 0) ? 0 : 1; }
          else
          { b1 = 0; }
          e1 = ST_CBOOL;
          break;
        default :
          c->gueltig = 0;
          break;
      }
      break;
    case ST_CSTRING :
      e1 = ST_CBOOL;
      switch (op)
      { case '=' :
          b1 = (i1 == i2) ? 1 : 0;
          break;
        case UNEQ :
          b1 = (i1 != i2) ? 1 : 0;
          break;
        case '<' :
          b1 = (i1 < i2) ? 1 : 0;
          break;
        case '>' :
          b1 = (i1 > i2) ? 1 : 0;
          break;
        case GREQ :
          b1 = (i1 >= i2) ? 1 : 0;
          break;
        case LEEQ :
          b1 = (i1 <= i2) ? 1 : 0;
          break;
        case _IN :
          if (z2 != NULL)
          { i2 = z2[i1 / (sizeof(int) * 8)];
            b1 = ((i2 & (1 << (i1 % (sizeof(int) * 8)))) == 0) ? 0 : 1;
          }
          else
          { b1 = 0; }
          e1 = ST_CBOOL;
          break;
        default :
          c->gueltig = 0;
          break;
      }
      break;
    case ST_CSET :
      switch (op)
      { case '+' :
          e1 = ST_CSET;
          { unsigned * z;
            int i, mem = 0;
            int len = (c1->type->info.range.bis - c1->type->info.range.von +
                       sizeof(unsigned) * 8) / (sizeof(unsigned) * 8);
            GET_MEM(z,len,unsigned);
            c->wert.set.set = z;
            for (i = 0; i < len; i++)
            { mem |= *z++ = *z1++ | *z2++; }
            c->wert.set.count = (mem == 0) ? 0 : 1;
            c->type = c1->type;
          }
          break;
        case '-' :
          e1 = ST_CSET;
          { unsigned * z;
            int i, mem = 0;
            int len = (c1->type->info.range.bis - c1->type->info.range.von +
                       sizeof(unsigned) * 8) / (sizeof(unsigned) * 8);
            GET_MEM(z,len,unsigned);
            c->wert.set.set = z;
            for (i = 0; i < len; i++)
            { mem |= *z++ = *z1++ & ~(*z2++); }
            c->wert.set.count = (mem == 0) ? 0 : 1;
            c->type = c1->type;
          }
          break;
        case '*' :
          e1 = ST_CSET;
          { unsigned * z;
            int i, mem = 0;
            int len = (c1->type->info.range.bis - c1->type->info.range.von +
                       sizeof(unsigned) * 8) / (sizeof(unsigned) * 8);
            GET_MEM(z,len,unsigned);
            c->wert.set.set = z;
            for (i = 0; i < len; i++)
            { mem |= *z++ = *z1++ & *z2++; }
            c->type = c1->type;
            c->wert.set.count = (mem == 0) ? 0 : 1;
          }
          break;
        case '/' :
          e1 = ST_CSET;
          { unsigned * z;
            int i, mem = 0;
            int len = (c1->type->info.range.bis - c1->type->info.range.von +
                       sizeof(unsigned) * 8) / (sizeof(unsigned) * 8);
            GET_MEM(z,len,unsigned);
            c->wert.set.set = z;
            for (i = 0; i < len; i++)
            { mem |= *z++ = *z1++ ^ *z2++; }
            c->type = c1->type;
            c->wert.set.count = (mem == 0) ? 0 : 1;
          }
          break;
        case GREQ :
          { unsigned * h1;    /* in LEEQ umwandeln durch vertauschen */
            h1 = z1;
            z1 = z2;
            z2 = h1;
            c1 = c2;
          }
        case LEEQ :
          e1 = ST_CBOOL;
          if (z1 == NULL)
          { b1 = 1; }
          else
          { if (z2 == NULL)
            { b1 = 0; }
            else
            { int i;
              int len = (c1->type->info.range.bis - c1->type->info.range.von +
                         sizeof(int) * 8) / (sizeof(int) * 8);
              b1 = 1;
              for (i = 0; i < len; i++)
              { if (z1[i] != z1[i] & z2[i])
                  b1 = 0;
              }
            }
          }
          break;
        case UNEQ :
          e1 = ST_CBOOL;
          if (z1 == NULL)
          { if (z2 == NULL)
              b1 = 0;
            else
              b1 = 1;
          }
          else
          { if (z2 == NULL)
            { b1 = 1; }
            else
            { int i;
              int len = (c1->type->info.range.bis - c1->type->info.range.von +
                         sizeof(int) * 8) / (sizeof(int) * 8);
              b1 = 0;
              for (i = 0; i < len; i++)
              { if (z1[i] != z2[i])
                  b1 = 1;
              }
            }
          }
          break;
        case '=' :
          e1 = ST_CBOOL;
          if (z1 == NULL)
          { if (z2 == NULL)
              b1 = 1;
            else
              b1 = 0;
          }
          else
          { if (z2 == NULL)
            { b1 = 0; }
            else
            { int i;
              int len = (c1->type->info.range.bis - c1->type->info.range.von +
                         sizeof(int) * 8) / (sizeof(int) * 8);
              b1 = 1;
              for (i = 0; i < len; i++)
              { if (z1[i] != z2[i])
                  b1 = 0;
              }
            }
          }
          break;
      }
      break;
    case ST_CNIL:
      switch (op)
      { case '=' :
          b1 = 1;
          e1 = ST_CBOOL;
          break; 
        case UNEQ :
          b1 = 0;
          e1 = ST_CBOOL;
          break;
      }
      break;
    case ST_CREC:
      b1 = record_const_vergleichen(c1->wert.recConst,c2->wert.recConst);
      e1 = ST_CBOOL;
      switch (op)
      { case UNEQ :
          b1 = !b1;
          break;
      }
      break;
    default :
      bug("eval_binexpr Auswahl");
      break;
  }
  c->Art = e1;
  switch (e1)
  { case ST_CINT :
      c->wert.i = i1;
      c->type = typ_int;
      break;
    case ST_CREAL :
      c->wert.r = r1;
      c->type = typ_real;
      break;
    case ST_CBOOL :
      c->wert.range.val = b1 ;
      c->wert.range.von = 0;
      c->wert.range.bis = 1;
      c->type = typ_bool;
      break;
    case ST_CSET :
      break;
    default :
      return NULL;
  }
  return c;
}

/* ************************************************************************* */
/* berechnet Integerzahl ^ Integerzahl                                       */
/*                                                                           */
/* Ergebnis : Integerzahl                                                    */
/*                                                                           */
/* Parameter : Basiszahl                                                     */
/*             Exponentenzahl                                                */
/*                                                                           */
/* ************************************************************************* */

long int_potenz(b,e)
long b,e;
{ long erg;
  erg = 1;
  while (e > 0)
  { if (e & 1) erg *= b;
    b *= b;
    e = e >> 1;
  }
  return erg;
}

/* ************************************************************************* */
/* berechnet Fliesskommazahl ^ Integerzahl                                   */
/*                                                                           */
/* Ergebnis : Fliesskommazahl                                                */
/*                                                                           */
/* Parameter : Basiszahl                                                     */
/*             Exponentenzahl                                                */
/*                                                                           */
/* ************************************************************************* */

float real_int_potenz(b,e)
float b;
long e;
{ float erg;
  erg = 1;
  while (e > 0)
  {if (e & 1)  erg *= b;
    b *= b;
    if (fp_error == JA)
      return 0.0;
    e = e >> 1;
  }
  return erg;
}

/* ************************************************************************* */
/* berechnet Fliesskommazahl ^ Fliesskommazahl                               */
/*                                                                           */
/* Ergebnis : Fliesskommazahl                                                */
/*                                                                           */
/* Parameter : Basiszahl                                                     */
/*             Exponentenzahl                                                */
/*                                                                           */
/* ************************************************************************* */

float real_potenz(b,e)
float b,e;
{ float h;
  errno = 0;
  if (b < 0)
  { SEMERROR(0,0,0,0,text[325]);
    interpreter = 1;
     return 0.0;
  }
  h = exp(log(b) * e);
  if (h && ((EDOM == errno) || (ERANGE == errno)))
  { fp_error = JA;
    return 0.0;
  }
  return h;
}

suche_komponente(nr,i,m,c)
int nr, i, *c;
MEMBERS * m;
{ while ((nr > i) && m)
  { if (m->inh.typ->Art == ST_TVARIANT)
    { suche_komponente(nr,i,m->inh.typ->info.record.mem,c); }
    else
    { if (m->inh.typ->Art == ST_TRECORDREST)
      { suche_komponente(nr,i,m->inh.typ->info.record.mem,c); }
      else
        *c += 1;
    }
    i += m->inh.typ->used[ALL];
    m = m->link;
  }
}
    
  
