static char _sccsid[] = "Parallaxis Version: @(#)code.c	2.13  2/28/92 15:09:55";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : code.c                                                            */
/*                                                                           */
/* Funktionen, die die Zwischencoderepraesentation des PARZ-Codes erzeugen   */
/*                                                                           */
/* ************************************************************************* */


#include "pass2.h"
#include "scope.h"

extern char * getstring();
/* in typ.c */
extern int ist_gleich_null();

extern C_CONF * akt_conf;
extern int proz_anz;
extern ST_TYPE * record_typ;
MEMBERS * record_mem;
extern int divisionstest;
extern int LINE1, LINE2, COL1, COL2;
int record_off;

/* ************************************************************************* */
/* Negation eines Ausdrucks                                                  */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Ausdruck                                                      */
/*                                                                           */
/* ************************************************************************* */

expr_negation(expr)
T_EXPR * expr;
{ T_EXPR * ex;
  ZWCODE * zw;
  if (interpreter)
    return;
  ex = expr->factors.binop.expr2;
  mache_Constexpr(ex,ex->erg_typ,0);
  GET_MEM(zw,1,ZWCODE);
  expr->code = zw;
  free_hvar(ex->hv);
  zw->com.unop.erg = neue_hv(expr);
  zw->art = CO_UNOP;
  zw->com.unop.op = '-';
  expr->zeilen = 1 + ex->zeilen;
  zw->com.unop.op1 = ex->hv;
  zw->com.unop.ex1 = ex->code;
}

/* ************************************************************************* */
/* logische Negation eines Ausdruck                                          */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Ausdruck                                                      */
/*                                                                           */
/* ************************************************************************* */

expr_not(expr)
T_EXPR * expr;
{ T_EXPR * ex;
  ZWCODE * zw;
  if (interpreter)
    return;
  ex = expr->factors.notexpr;
  mache_Constexpr(ex,ex->erg_typ,0);
  GET_MEM(zw,1,ZWCODE);
  zw->art = CO_UNOP;
  zw->com.unop.op = _NOT;
  expr->code = zw;
  free_hvar(ex->hv);
  zw->com.unop.erg = neue_hv(expr);
  expr->zeilen = 1 + ex->zeilen;
  zw->com.unop.op1 = ex->hv;
  zw->com.unop.ex1 = ex->code;
}

/* ************************************************************************* */
/* binaerer Ausdruck mit AND oder OR                                         */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Ausdruck                                                      */
/*             Hilfsvariable                                                 */
/*                                                                           */
/* ************************************************************************* */

and_or_expr(expr,hbvar)
T_EXPR * expr;
VARNODE * hbvar;
{ T_EXPR * ex1, *ex2;
  ZWCODE * zw;
  ex1 = expr->factors.binop.expr1;
  ex2 = expr->factors.binop.expr2;
  mache_Constexpr(ex1,typ_bool,0);
  mache_Constexpr(ex2,typ_bool,0);
  free_hvar(hbvar);
  free_hvar(ex1->hv);
  free_hvar(ex2->hv);
  GET_MEM(zw,1,ZWCODE);
  zw->art = CO_ANDOR;
  zw->com.andor.op = ((expr->factors.binop.operator->Art == _AND) ? 16 : 0) +
                     ((expr->scavec) ? 1 : 0);
  if (ex1->erg_art == ERG_CONST)
    zw->com.andor.op |= 2 + ((ex1->erg.Const->wert.range.val) ? 8 : 0); 
  if (ex2->erg_art == ERG_CONST)
    zw->com.andor.op |= 4 + ((ex2->erg.Const->wert.range.val) ? 8 : 0); 
  zw->com.andor.hbv = hbvar;
  zw->com.andor.op1 = ex1->hv;
  zw->com.andor.op2 = ex2->hv;
  expr->erg_typ = typ_bool;
  expr->erg_art = ERG_VAR;
  zw->com.andor.erg = neue_hv(expr);
  zw->com.andor.ex1 = ex1->code;
  zw->com.andor.ex2 = ex2->code;
  zw->com.andor.zeilen = ex2->zeilen;
  expr->code = zw;
  expr->zeilen += (expr->scavec * 7) + 3 + ex1->zeilen + ex2->zeilen +
                  ((expr->hv->ein == hbvar->ein) ? 0 : 1);
}

/* ************************************************************************* */
/* verbundener relationaler Ausdruck (z.B. x < y < z )                       */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Ausdruck                                                      */
/*             Hilfsvariable                                                 */
/*                                                                           */
/* ************************************************************************* */

expr_relopconn(expr,hbvar)
T_EXPR * expr;
VARNODE * hbvar;
{ T_EXPR * ex1, *ex2, *ex3;
  ZWCODE * zw;
  VARNODE * var1;
  if (interpreter)
    return;
  ex1 = expr->factors.binop.expr1;
  ex2 = ex1->factors.binop.expr2;
  ex3 = expr->factors.binop.expr2;
  mache_Constexpr(ex1,typ_bool,0);
  mache_Constexpr(ex3,ex3->erg_typ,0);
  free_hvar(ex2->hv);
  if ((expr->factors.binop.twice & EX_SPEC) == 0)
    free_hvar(ex3->hv);
  ex2->code = NULL;
  ex2->zeilen = 0;
  expr->factors.binop.expr1 = ex2;
  var1 = expr->hv;
  expr->hv = NULL;
  if (((ex2->erg_art == ERG_CONST) && (ex2->erg.Const->Art != ST_CTYPDESC)) &&
      ((ex3->erg_art == ERG_CONST) && (ex3->erg.Const->Art != ST_CTYPDESC)))
  { LINE1 = ex2->Zeile;
    COL1 = ex2->Posit;
    LINE2 = ex3->Zeile;
    COL2 = ex3->Posit;
    expr->erg.Const = eval_binexpr(expr->factors.binop.operator->Art,
                                   ex2->erg.Const,ex3->erg.Const);
    expr->code = NULL;
    expr->erg_art = ERG_CONST;
  }
  else
  { expr->scavec = ex2->scavec | ex3->scavec;
    if ((ex2->erg_art == ERG_CONST) && (ex3->erg_art == ERG_CONST))
    { if (ex2->erg.Const->Art == ST_CTYPDESC)
      { mache_Constexpr(ex2,typ_int,1); }
      else
      { mache_Constexpr(ex3,typ_int,1); }
    }
    expr_binop(expr);
    expr->erg_art = ERG_VAR;
    free_hvar(expr->hv);
  }
  mache_Constexpr(expr,typ_bool,0);
  free_hvar(hbvar);
  GET_MEM(zw,1,ZWCODE);
  zw->art = CO_ANDOR;
  zw->com.andor.op = 16 + ((expr->scavec) ? 1 : 0);
  if (ex1->erg_art == ERG_CONST)
    zw->com.andor.op |= 2 + ((ex1->erg.Const->wert.range.val) ? 8 : 0); 
  if (expr->erg_art == ERG_CONST)
    zw->com.andor.op |= 4 + ((expr->erg.Const->wert.range.val) ? 8 : 0); 
  zw->com.andor.hbv = hbvar;
  zw->com.andor.op1 = ex1->hv;
  zw->com.andor.op2 = expr->hv;
  expr->hv = var1;
  expr->erg_typ = typ_bool;
  expr->erg_art = ERG_VAR;
  zw->com.andor.erg = neue_hv(expr);
  zw->com.andor.ex1 = ex1->code;
  zw->com.andor.ex2 = expr->code;
  zw->com.andor.zeilen = expr->zeilen;
  expr->code = zw;
  expr->zeilen += (expr->scavec * 7) + 3 + ex1->zeilen +
                  ((expr->hv->ein == hbvar->ein) ? 0 : 1);
  free_hvar(ex1->hv);
}

/* ************************************************************************* */
/* Binaerer Ausdruck                                                         */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Ausdruck                                                      */
/*                                                                           */
/* ************************************************************************* */

expr_binop(expr)
T_EXPR * expr;
{ T_EXPR * ex1, *ex2;
  ZWCODE * zw1;
  ZWCODE * zw;
  int mode = 0;
  ex1 = expr->factors.binop.expr1;
  ex2 = expr->factors.binop.expr2;
  if (interpreter)
    return;
  if (expr->factors.binop.operator->Art != _IN)
  { if ((ex1->erg_typ == typ_string) || (ex1->erg_typ->Art == ST_TSARRAY))
    { mache_Constexpr(ex1,ex2->erg_typ,0); }
    else
    { if (ex1->erg_art == ERG_CONST)
        mode = 1;
      mache_Constexpr(ex1,ex1->erg_typ,0);
      if (ex1->erg_art == ERG_CONST)
        mode = 0;
    }
  }
  else
  { if (ex1->erg_art == ERG_CONST)
    { ex1->code = check_ranges(ex1,ex2->erg_typ); }
    else
    { mache_Constexpr(ex1,ex1->erg_typ,0); }
  }
  if ((ex2->erg_typ == typ_string) || (ex2->erg_typ->Art == ST_TSARRAY))
  { mache_Constexpr(ex2,ex1->erg_typ,0); }
  else
  { if (expr->factors.binop.operator->Art != _IN)
      mache_Constexpr(ex2,ex2->erg_typ,0);
    else
    { if (ex2->erg_art == ERG_CONST)
      { ex2->scavec = ex1->scavec; }
      mache_Constexpr(ex2,ex2->erg_typ,0);
      if (ex2->scavec < ex1->scavec)
      { ZWCODE * zw;
        VARNODE * var;
        GET_MEM(zw,1,ZWCODE);
        zw->art = CO_BLOCKASS;
        zw->com.blockass.ex1 = ex2->code;
        free_hvar(zw->com.blockass.wert = ex2->hv);
        GET_MEM(var,1,VARNODE);
        var->lk = VARi;
        VARi = var;
        var->free = 1;
        var->dir_indir = DIRECT;
        var->ein = get_hvar(zw->com.blockass.typ = ex2->erg_typ,var->scavec = 1);
        var->firstelem = BOOLEAN;
        ex2->hv = zw->com.blockass.erg = var;
        ex2->zeilen++;
        ex2->code = zw;
      }
    }
  }
  if ((ex2->erg_typ->Art == ST_TSET) && (hilfs_var(ex2->hv) == JA) &&
      (ex2->hv->dir_indir == INDIRECT))
  { if ((ex1->erg_typ->Art == ST_TSET) && (hilfs_var(ex1->hv) == JA) &&
        (ex1->hv->dir_indir == INDIRECT))
    { }
    else
      free_hvar(ex1->hv);
  }
  else
  { if ((ex1->erg_typ->Art == ST_TSET) && (hilfs_var(ex1->hv) == JA) &&
        (ex1->hv->dir_indir == INDIRECT))
    { }
    else
      free_hvar(ex1->hv);
    if ((expr->factors.binop.twice & EX_SPEC) == 0)
      free_hvar(ex2->hv);
  }
  GET_MEM(zw,1,ZWCODE);
  switch (expr->erg_typ->Art)
  { case ST_TINT :
    case ST_TCHAR :
    case ST_TREAL :
    case ST_TDIM :
    case ST_TID_NO :
    case ST_TSUBRANGE :
      zw->art = CO_BINOP;
      if (ex1->erg_art == ERG_CONST)
      { ST_CONST * c;
        c = ex1->erg.Const;
        if (((c->Art == ST_CINT) && (c->wert.i < 0)) ||
            ((c->Art == ST_CREAL) && (c->wert.r < 0)))
        { GET_MEM(zw1,1,ZWCODE);
          zw1->art = CO_CONSTASS;
          zw1->com.Constass.erg = zw->com.binop.op1 = neue_hv(ex1);
          zw1->com.Constass.charst = 0;
          zw1->com.Constass.wert = c;
          expr->zeilen += 1;
          mode = 1;
          zw->com.binop.ex2 = zw1;
        }
        else
        { zw->art = CO_CONSTBINOP;
          zw->com.Constbinop.op1 = c;
        }
      }
      else
      { zw->com.binop.op1 = ex1->hv;
        if (mode)
          zw->com.binop.ex2 = ex1->code;
        else
          zw->com.binop.ex1 = ex1->code;
      }
      expr->zeilen += ex1->zeilen;
      if (ex2->erg_art == ERG_CONST)
      { ST_CONST * c;
        int ist_null;
        c = ex2->erg.Const;
        if (((c->Art == ST_CINT) && (c->wert.i < 0)) ||
            ((c->Art == ST_CREAL) && (c->wert.r < 0)))
        { GET_MEM(zw1,1,ZWCODE);
          zw1->art = CO_CONSTASS;
          zw1->com.Constass.erg = zw->com.binop.op2 = neue_hv(ex2);
          zw1->com.Constass.charst = 0;
          zw1->com.Constass.wert = c;
          expr->zeilen += 1;
          zw->com.binop.ex2 = zw1;
        }
        else
        { zw->art = CO_BINOPCONST;
          zw->com.binopConst.op2 = c;
        }
        ist_null = 0;
        switch( zw->com.binop.op = expr->factors.binop.operator->Art)
        { case '/' :
            ist_null = (c->wert.r == 0);
            break;
          case _MOD :
          case _DIV :
            ist_null = (c->wert.i == 0);
            break;
        }
        if (ist_null)
        { SEMERROR(ex2->Zeile,ex2->Posit,0,0,text[77]);
          expr->error = interpreter = 1;
        }
      }
      else
      { int ist_null = 0;
        switch( zw->com.binop.op = expr->factors.binop.operator->Art)
        { case '/' :
            ist_null = divisionstest;
            break;
          case _MOD :
          case _DIV :
            ist_null = ist_gleich_null(ex2->erg_typ) * divisionstest;
            break;
        }
        zw->com.binop.op2 = ex2->hv;
        if (mode)
          zw->com.binop.ex1 = ex2->code;
        else
          zw->com.binop.ex2 = ex2->code;
        if (ist_null)
        { ZWCODE * zw1, *zw2;
          GET_MEM(zw1,1,ZWCODE);
          error_div = 1;
          zw1->art = CO_NTEST;
          zw1->com.ntest.var = ex2->hv;
          zw1->com.ntest.typ = ex2->erg_typ;
          if (mode)
            zw2 = zw->com.binop.ex1;
          else
            zw2 = zw->com.binop.ex2;
          if (zw2)
          { while (zw2->link)
            { zw2 = zw2->link; }
            zw2->link = zw1;
          }
          else
          { if (mode)
              zw->com.binop.ex1 = zw1;
            else
              zw->com.binop.ex2 = zw1;
          }
          expr->zeilen++;
        }          
      }
      expr->zeilen += ex2->zeilen;
      zw->com.binop.erg = neue_hv(expr);
      zw->com.binop.op = expr->factors.binop.operator->Art;
      expr->zeilen += 1;
      expr->code = zw;
      break;
    case ST_TBOOL :
      if ((ex1->erg_typ->used[ALL] > 1) && (ex2->erg_typ->used[ALL] > 1))
      { T_EXPR * exe1 = ex1;
        T_EXPR * exe2 = ex2;
        zw->art = CO_UNEQUAL;
        switch (expr->factors.binop.operator->Art)
        { case '=' : 
            zw->art = CO_EQUAL;
          case UNEQ :
            zw->com.vergl.ex1 = ex1->code;
            zw->com.vergl.ex2 = ex2->code;
            zw->com.vergl.op1 = ex1->hv;
            zw->com.vergl.op2 = ex2->hv;
            zw->com.vergl.erg = neue_hv(expr);
            zw->com.vergl.typ = ex1->erg_typ;
            zw->com.vergl.scavec = expr->scavec;
            expr->zeilen += 2 + ex1->zeilen + ex2->zeilen + ((zw->art == CO_EQUAL) ? 0 : 1);
            break;
          case GREQ :
            { ex1 = exe2;
              ex2 = exe1;
            }
          case LEEQ :
            { VARNODE * var1, * var2, * var4, * var5;
              GET_MEM(var5,1,VARNODE);
              var5->lk = VARi;
              VARi = var5;
              var5->free = 1;
              var5->ein = get_hvar(typ_bool,var5->scavec = expr->scavec);
              var5->dir_indir = DIRECT;
              var5->firstelem = BOOLEAN;
              zw->com.setop.bhelp1 = var5;
              free_hvar(var5);
              zw->art = CO_SETINCL;
              GET_MEM(var1,1,VARNODE);
              var1->lk = VARi;
              VARi = var1;
              var1->free = 1;
              var1->ein = get_hvar(typ_int,var1->scavec = ex1->scavec);
              var1->dir_indir = DIRECT;
              var1->firstelem = BOOLEAN;
              zw->com.setop.help1 = var1;
              GET_MEM(var2,1,VARNODE);
              var2->lk = VARi;
              VARi = var2;
              var2->free = 1;
              var2->ein = get_hvar(typ_int,var2->scavec = ex2->scavec);
              var2->dir_indir = DIRECT;
              var2->firstelem = BOOLEAN;
              zw->com.setop.help2 = var2;
              GET_MEM(var4,1,VARNODE);
              var4->lk = VARi;
              VARi = var4;
              var4->free = 1;
              var4->ein = get_hvar(typ_int,var4->scavec = 0);
              var4->dir_indir = DIRECT;
              var4->firstelem = INTEGER;
              zw->com.setop.count = var4;
              zw->com.setop.anz = ex1->erg_typ->info.range.bis -
                                  ex1->erg_typ->info.range.von + 1;
              zw->com.setop.erg = neue_hv(expr);
              zw->com.setop.op1 = ex1->hv;
              zw->com.setop.ex1 = exe1->code;
              zw->com.setop.op2 = ex2->hv;
              zw->com.setop.ex2 = exe2->code;
              free_hvar(var1);
              free_hvar(var2);
              free_hvar(var4);
              free_hvar(exe1->hv);
              if ((expr->factors.binop.twice & EX_SPEC) == 0)
                free_hvar(exe2->hv);
              expr->zeilen += 9 + ex1->zeilen + ex2->zeilen;
              expr->code = zw;
            }
            break;
          default :
            bug("expr_binop multi %d",expr->factors.binop.operator);
            break;
         }
      }
      else
      { switch (expr->factors.binop.operator->Art)
        { case '<' :
          case '>' :
          case GREQ :
          case LEEQ :
          case '=' :
          case UNEQ :
            zw->art = CO_BINOP;
            if (ex1->erg_art == ERG_CONST)
            { ST_CONST * c;
              c = ex1->erg.Const;
              if (((c->Art == ST_CINT) && (c->wert.i < 0)) ||
                  ((c->Art == ST_CREAL) && (c->wert.r < 0)))
              { GET_MEM(zw1,1,ZWCODE);
                zw1->art = CO_CONSTASS;
                zw1->com.Constass.erg = zw->com.binop.op1 = neue_hv(ex1);
                zw1->com.Constass.charst = 0;
                zw1->com.Constass.wert = c;
                expr->zeilen += 1;
                zw->com.binop.ex1 = zw1;
              }
              else
              { zw->art = CO_CONSTBINOP;
                zw->com.Constbinop.op1 = c;
              }
            }
            else
            { zw->com.binop.op1 = ex1->hv;
              if (mode)
                zw->com.binop.ex2 = ex1->code;
              else
                zw->com.binop.ex1 = ex1->code;
            }
            expr->zeilen += ex1->zeilen;
            if (ex2->erg_art == ERG_CONST)
            { ST_CONST * c;
              c = ex2->erg.Const;
              if (((c->Art == ST_CINT) && (c->wert.i < 0)) ||
                  ((c->Art == ST_CREAL) && (c->wert.r < 0)))
              { GET_MEM(zw1,1,ZWCODE);
                zw1->art = CO_CONSTASS;
                zw1->com.Constass.erg = zw->com.binop.op2 = neue_hv(ex2);
                zw1->com.Constass.wert = c;
                zw1->com.Constass.charst = 0;
                expr->zeilen += 1;
                zw->com.binop.ex2 = zw1;
              }
              else
              { zw->art = CO_BINOPCONST;
                zw->com.binopConst.op2 = c;
              }
            }
            else
            { zw->com.binop.op2 = ex2->hv;
              if (mode)
                zw->com.binop.ex1 = ex2->code;
              else
                zw->com.binop.ex2 = ex2->code;
            }
            expr->zeilen += ex2->zeilen;
            zw->com.binop.erg = neue_hv(expr);
            zw->com.binop.op = expr->factors.binop.operator->Art;
            expr->zeilen += 1;
            break;
          case _IN :
            { VARNODE * var, * bhvar;
              zw->art = CO_IN;
              zw->com.setin.ex1 = ex1->code;
              zw->com.setin.op1 = ex1->hv;
              zw->com.setin.ex2 = ex2->code;
              zw->com.setin.op2 = ex2->hv;
              zw->com.setin.von = ex2->erg_typ->info.range.von;
              zw->com.setin.bis = ex2->erg_typ->info.range.bis -
                                  ex2->erg_typ->info.range.von;
              zw->com.setin.erg = neue_hv(expr);
              if (ex1->scavec)
              { GET_MEM(bhvar,1,VARNODE);
                bhvar->lk = VARi;
                VARi = bhvar;
                bhvar->free = 1;
                bhvar->ein = get_hvar(typ_bool,bhvar->scavec = 1);
                bhvar->dir_indir = DIRECT;
                bhvar->firstelem = BOOLEAN;
                zw->com.setin.boolhelp = bhvar;
                expr->zeilen += 7;
              }
              else
                bhvar = NULL;
              if (ex1->erg_art == ERG_CONST)
              { ST_CONST * c = ex1->erg.Const;
                switch (c->Art)
                { case ST_CINT :
                    zw->com.setin.nummer = c->wert.i - zw->com.setin.von;
                    break;
                  case ST_CSTRING :
                    zw->com.setin.nummer = *(c->wert.s.string) - zw->com.setin.von;
                    break;
                  case ST_CELEM :
                  case ST_CENUM :
                  case ST_CBOOL :
                    zw->com.setin.nummer = c->wert.range.val - zw->com.setin.von;
                    break;
                  case ST_CEOL :
                    zw->com.setin.nummer = '\n' - zw->com.setin.von;
                    break;
                }
                if (zw->com.setin.nummer == 0)
                { expr->zeilen -= 2;
                  var = NULL;
                  zw->com.setin.help = ex2->hv;
                }
                else
                { GET_MEM(var,1,VARNODE);
                  var->lk = VARi;
                  VARi = var;
                  var->free = 1;
                  var->ein = get_hvar(typ_int,var->scavec = expr->scavec);
                  var->dir_indir = DIRECT;
                  var->firstelem = BOOLEAN;
                  zw->com.setin.help = var;
                }
              }
              else
              { if ((ex1->erg_typ->Art == ST_TRANGE) ||
                    (match_typen(typ_int,ex1->erg_typ,0) == JA))
                  zw->com.setin.mode = 0;
                else
                  expr->zeilen += zw->com.setin.mode = 1;
                expr->zeilen += 5;
                if (zw->com.setin.von == 0)
                { expr->zeilen--; }
                GET_MEM(var,1,VARNODE);
                var->lk = VARi;
                VARi = var;
                var->free = 1;
                var->ein = get_hvar(typ_int,var->scavec = expr->scavec);
                var->dir_indir = DIRECT;
                var->firstelem = BOOLEAN;
                zw->com.setin.help = var;
             }
             if (bhvar)
               free_hvar(bhvar);
              free_hvar(var);
              expr->zeilen += 3 + ex1->zeilen + ex2->zeilen;
              if ((expr->factors.binop.twice & EX_SPEC) == 0)
                free_hvar(ex2->hv);
              expr->code = zw;
            }
            break;
          default :
            bug("expr_binop  BOOL : % d",expr->factors.binop.operator->Art);
            break;
        }
      }
      expr->code = zw;
      break;
    case ST_TARRAY :
    case ST_TRECORD :
    case ST_TSARRAY :
      break;
    case ST_TSET :
      { VARNODE * var1, * var2, * var3, * var4, * var5;
        switch (expr->factors.binop.operator->Art)
        { case '+' :
            zw->com.setop.op = '+';
            break;
          case '-' :
            zw->com.setop.op = '-';
            GET_MEM(var5,1,VARNODE);
            var5->lk = VARi;
            VARi = var5;
            var5->free = 1;
            var5->ein = get_hvar(typ_bool,var5->scavec = expr->scavec);
            var5->dir_indir = DIRECT;
            var5->firstelem = BOOLEAN;
            zw->com.setop.bhelp1 = var5;
            free_hvar(var5);
            expr->zeilen += 1;
            break;
          case '*' :
            zw->com.setop.op = '*';
            break;
          case '/' :
            zw->com.setop.op = '/';
            break;
          default :
            bug("expr_binop  ST_TSET  : %d",expr->factors.binop.operator->Art);
            break;
        }
        zw->art = CO_SETOP;
        GET_MEM(var1,1,VARNODE);
        var1->lk = VARi;
        VARi = var1;
        var1->free = 1;
        var1->ein = get_hvar(typ_int,var1->scavec = ex1->scavec);
        var1->dir_indir = DIRECT;
        var1->firstelem = BOOLEAN;
        zw->com.setop.help1 = var1;
        GET_MEM(var2,1,VARNODE);
        var2->lk = VARi;
        VARi = var2;
        var2->free = 1;
        var2->ein = get_hvar(typ_int,var2->scavec = ex2->scavec);
        var2->dir_indir = DIRECT;
        var2->firstelem = BOOLEAN;
        zw->com.setop.help2 = var2;
        GET_MEM(var3,1,VARNODE);
        var3->lk = VARi;
        VARi = var3;
        var3->free = 1;
        var3->ein = get_hvar(typ_int,var3->scavec = expr->scavec);
        var3->dir_indir = DIRECT;
        var3->firstelem = BOOLEAN;
        zw->com.setop.helpe = var3;
        GET_MEM(var4,1,VARNODE);
        var4->lk = VARi;
        VARi = var4;
        var4->free = 1;
        var4->ein = get_hvar(typ_int,var4->scavec = 0);
        var4->dir_indir = DIRECT;
        var4->firstelem = INTEGER;
        zw->com.setop.count = var4;
        zw->com.setop.anz = expr->erg_typ->info.range.bis -
                            expr->erg_typ->info.range.von + 1;
        zw->com.setop.erg = neue_hv(expr);
        zw->com.setop.op1 = ex1->hv;
        zw->com.setop.ex1 = ex1->code;
        zw->com.setop.op2 = ex2->hv;
        zw->com.setop.ex2 = ex2->code;
        free_hvar(var1);
        free_hvar(var2);
        free_hvar(var3);
        free_hvar(var4);
        free_hvar(ex1->hv);
        if ((expr->factors.binop.twice & EX_SPEC) == 0)
          free_hvar(ex2->hv);
        expr->zeilen += 7 + ex1->zeilen + ex2->zeilen;
      }
      expr->code = zw;
      break;
    default :
      bug("expr_binop  : %d",expr->erg_typ->Art);
      break;
  }
}

/* ************************************************************************* */
/* ueberprueft die Grenzen bei Unterbereichstypen                            */
/*                                                                           */
/* Ergebnis : Zwischencode fuer die Ueberpruefung                            */
/*                                                                           */
/* Parameter : Ausdruck                                                      */
/*             Datentyp des erwarteten Ergebnisses                           */
/*                                                                           */
/* ************************************************************************* */

ZWCODE * check_ranges(expr,ptyp)
T_EXPR * expr;
ST_TYPE * ptyp;
{ if ((expr == NULL) || (ptyp == NULL) || expr->error || (expr->erg_typ == ptyp))
    return NULL;
  if ((ptyp->Art == ST_TSUBRANGE) ||
      ((ptyp->Art == ST_TSET) && (expr->erg_typ->Art != ST_TSET)))
  { if (expr->erg_art != ERG_CONST)
    { ST_TYPE * t = expr->erg_typ;
      if (t == NULL)
        return NULL;
      switch (t->Art)
      { /*case ST_TCHAR :
          if ((ptyp->info.range.von == 0) && (ptyp->info.range.bis == MAXCHAR))
            return NULL;
          break;*/
        case ST_TBOOL :
          if ((ptyp->info.range.von == 0) && (ptyp->info.range.bis == 1))
            return NULL; 
          break;
        case ST_TRANGE :
        case ST_TSUBRANGE :
          if ((ptyp->info.range.von <= t->info.range.von) &&
              (ptyp->info.range.bis >= t->info.range.bis))
            return NULL;
          break;
        case ST_TID_NO :
          if ((ptyp->info.range.von <= 1) &&
              (ptyp->info.range.bis >= proz_anz))
            return NULL;
          break;
        case ST_TDIM :
          { int i;
            char * x = getstring(expr->erg.eintr->name_nr);
            sscanf(&x[3],"%d",&i);
            if (akt_conf)
            { if ((ptyp->info.range.von <= akt_conf->wert_von[i-1]) &&
                  (ptyp->info.range.bis >= akt_conf->wert_bis[i-1]))
                return NULL;
            }
            else
              return NULL;
          }
          break;
      }
      if (range_test && (interpreter == 0))
      { ZWCODE * zw;
        GET_MEM(zw,1,ZWCODE);
        error_range = 1;
        zw->art = CO_RNTEST;
        if (ptyp->info.range.bis < 0)
        { zw->art = CO_RNNTEST;
          expr->zeilen++;
        }
        if (ptyp->info.range.von < 0)
        { VARNODE * var;
          expr->zeilen += 2;
          if (ptyp->info.range.bis < MAXINTEGER)
            expr->zeilen++;
          GET_MEM(var,1,VARNODE);
          var->lk = VARi;
          VARi = var;
          var->ein = get_hvar(typ_int,var->scavec = expr->scavec);
          var->free = 1;
          var->firstelem = INTEGER;
          var->dir_indir = DIRECT;
          free_hvar(var);
          zw->com.rtest.hvar = var;
        }
        else
        { zw->art = CO_RTEST;
          zw->com.rtest.hvar = NULL;
          expr->zeilen += 1;
          if (ptyp->info.range.bis < MAXINTEGER)
            expr->zeilen++;
        }
        zw->com.rtest.var = expr->hv;
        zw->com.rtest.typ = ptyp;
        if (expr->code != NULL)
        { ZWCODE * hzw = expr->code;
          while (hzw->link != NULL)
          { hzw = hzw->link; }
          hzw->link = zw;
        }
        else
          expr->code = zw;
        return zw;
      }
      return NULL;
    }
    else
    { ST_CONST * c;
      switch ((c = expr->erg.Const)->Art)
      { case ST_CINT :
          if ((ptyp->info.range.von <= c->wert.i) && (ptyp->info.range.bis >= c->wert.i))
            return NULL;
          break;
        case ST_CELEM :
        case ST_CENUM :
        case ST_CBOOL :
          if ((ptyp->info.range.von <= c->wert.range.val) &&
              (ptyp->info.range.bis >= c->wert.range.val))
            return NULL;
          break;
        case ST_CSTRING :
          if ((ptyp->info.range.von <= *c->wert.s.string) &&
              (ptyp->info.range.bis >= *c->wert.s.string))
            return NULL;
          break;
        case ST_CEOL :
          if ((ptyp->info.range.von <= '\n') &&
              (ptyp->info.range.bis >= '\n'))
            return NULL;
          break;
        default :
          return NULL;
      }
      SEMERROR(expr->Zeile,expr->Posit,0,0,text[273]);
    }
  }
  return NULL;
}

/* ************************************************************************* */
/* Bereichsueberpruefung veranlassen und Konstanten an Hilfsvariablen        */
/* zuweisen                                                                  */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Ausdruck                                                      */
/*             Datentyp des erwarteten Ergebnisses                           */
/*             Modus : 0  normale Zuweisung                                  */
/*                     1  immer zuweisen                                     */
/*                                                                           */
/* ************************************************************************* */

mache_Constexpr(expr,ptyp,mode)
T_EXPR * expr;
ST_TYPE * ptyp;
int mode;
{ VARNODE * erg = expr->hv;
  ZWCODE * zw =  check_ranges(expr,ptyp);
  if (ptyp == typ_string)
  { ptyp = typ_char; }
  if ((expr->erg_art == ERG_CONST) && (interpreter == 0))
  { ST_CONST * c = expr->erg.Const;
    if (c->Art != ST_CNIL)
      expr->zeilen = 0;
    switch (c->Art)
    { case ST_CINT :
        if ((c->wert.i < 0) || (expr->hv != NULL) || (mode == 1))
        { ZWCODE * zw;
          GET_MEM(zw,1,ZWCODE);
          expr->erg_typ = ptyp;
          zw->com.Constass.erg = erg = neue_hv(expr);
          zw->art = CO_CONSTASS;
          zw->com.Constass.charst = 0;
          zw->com.Constass.wert = c;
          expr->erg_art = ERG_VAR;
          expr->code = zw;
          expr->zeilen = 1;
        }
        break;
      case ST_CREAL :
      case ST_CPI :
        if ((c->wert.r < 0) || (expr->hv != NULL) || (mode == 1))
        { ZWCODE * zw;
          GET_MEM(zw,1,ZWCODE);
          expr->erg_typ = ptyp;
          zw->com.Constass.erg = erg = neue_hv(expr);
          zw->art = CO_CONSTASS;
          zw->com.Constass.wert = c;
          zw->com.Constass.charst = 0;
          expr->erg_art = ERG_VAR;
          expr->code = zw;
          expr->zeilen = 1;
        }
        break;
      case ST_CREC :
        Const_record_assign(expr,c,ptyp,neue_hv(expr));
        expr->erg_art = ERG_VAR;
        break;
      case ST_CSTRING :
        if ((ptyp->Art == ST_TARRAY) || (ptyp->Art == ST_TSARRAY) || (expr->hv != NULL) || (mode == 1))
        { ZWCODE * zw;
          GET_MEM(zw,1,ZWCODE);
          expr->erg_typ = ptyp;
          zw->com.Constass.erg = erg = neue_hv(expr);
          if ((ptyp->Art == ST_TARRAY) || (ptyp->Art == ST_TSARRAY))
            zw->com.Constass.charst = 1;
          else
            zw->com.Constass.charst = 0;
          zw->art = CO_CONSTASS;
          zw->com.Constass.wert = c;
          expr->erg_art = ERG_VAR;
          expr->code = zw;
          expr->zeilen = 1;
        }
        break;
      case ST_CBOOL :
      case ST_CENUM :
      case ST_CELEM :
      case ST_CEOL :
      case ST_CTYPDESC :
      case ST_CNIL :
        if ((expr->hv != NULL) || (mode == 1))
        { ZWCODE * zw;
          GET_MEM(zw,1,ZWCODE);
          expr->erg_typ = ptyp;
          zw->com.Constass.erg = erg = neue_hv(expr);
          zw->com.Constass.charst = 0;
          zw->art = CO_CONSTASS;
          zw->com.Constass.wert = c;
          expr->erg_art = ERG_VAR;
          expr->code = zw;
          expr->zeilen = 1;
        }
      break;
      case ST_CSET :
        { ZWCODE * zw;
          VARNODE * var1, * var2;
          GET_MEM(zw,1,ZWCODE);
          zw->art = CO_SETASS;
          zw->com.setass.erg = erg = neue_hv(expr);
          zw->com.setass.anz = ptyp->used[ALL];
          zw->com.setass.set = c->wert.set.set;
          expr->zeilen += 1;
/*          if ((c->wert.set.count == 0) && (ptyp->used[ALL] > 3))
          { GET_MEM(zw,1,ZWCODE);
            zw->art = CO_CLEARSET;
            zw->com.clearset.erg = erg = neue_hv(expr);
            GET_MEM(var1,1,VARNODE);
            var1->lk = VARi;
            VARi = var1;
            var1->free = 1;
            var1->scavec = expr->scavec;
            var1->dir_indir = INDIRECT;
            var1->firstelem = BOOLEAN;
            var1->ein = get_hvar(typ_int,expr->scavec);
            GET_MEM(var2,1,VARNODE);
            var2->lk = VARi;
            VARi = var2;
            var2->free = 1;
            var2->scavec = expr->scavec;
            var2->dir_indir = INDIRECT;
            var2->firstelem = BOOLEAN;
            var2->ein = get_hvar(typ_int,0);
            free_hvar(var1);
            free_hvar(var2);
            zw->com.clearset.help1 = var1;
            zw->com.clearset.help2 = var2;
            zw->com.clearset.anz = ptyp->used[ALL];
            expr->zeilen += 5;
          }
          else
          { GET_MEM(zw,1,ZWCODE);
            zw->art = CO_SETASS;
            zw->com.setass.erg = erg = neue_hv(expr);
            if ((zw->com.setass.anz = ptyp->used[ALL]) > 1)
            { GET_MEM(var1,1,VARNODE);
              var1->lk = VARi;
              VARi = var1;
              var1->free = 1;
              var1->scavec = expr->scavec;
              var1->dir_indir = INDIRECT;
              var1->firstelem = BOOLEAN;
              var1->ein = get_hvar(typ_int,expr->scavec);
              free_hvar(var1);
              zw->com.setass.help = var1;
            }
            zw->com.setass.set = c->wert.set.set;
            expr->zeilen += 2 * zw->com.setass.anz - 1;
          }*/
          expr->code = zw;
          expr->erg_art = ERG_VAR;
        }
        break;
    }
  }
  if ((expr->erg_art == ERG_PROC) && (interpreter == 0))
  { if (expr->code->art == CO_REDUCE)
    { expr->code->com.reduce.erg = erg = neue_hv(expr); }
    else
    { if(expr->code->art == CO_CONNECT)
      { expr->code->com.connect.erg = erg = neue_hv(expr); }
      else
      { if ((expr->scavec == 0) && (expr->hv && (expr->hv->scavec == 1)))
        { VARNODE * var = expr->hv;
          ZWCODE * zw;
          GET_MEM(zw,1,ZWCODE);
          expr->hv = NULL;
          expr->code->com.funccall.erg = erg = neue_hv(expr);
          if (expr->erg_typ->used[ALL] == 1)
          { zw->art = CO_ASSIGN;
            zw->com.assign.erg = var;
            zw->com.assign.wert = erg;
            zw->com.assign.ex1 = expr->code;
          }
          else
          { zw->art = CO_BLOCKASS;
            zw->com.blockass.erg = var;
            zw->com.blockass.wert = erg;
            zw->com.blockass.typ = expr->erg_typ;
            zw->com.blockass.ex1 = expr->code;
          }
          expr->code = zw;
          expr->zeilen += 1;
        }
        else
          expr->code->com.funccall.erg = erg = neue_hv(expr);
      }
    }
    expr->erg_art = ERG_VAR;
  }
  if ((expr->erg_art == ERG_RAND) && (interpreter == 0))
  { ZWCODE * zw;
    GET_MEM(zw,1,ZWCODE);
    zw->art = CO_RANDOM;
    zw->com.rand.erg = expr->code;
    expr->zeilen++;
    expr->code = zw;
    zw->com.rand.random = erg = neue_hv(expr);
    expr->erg_art = ERG_VAR;
  }
  if ((expr->erg_art == ERG_REC) && (interpreter == 0))
  { expr->zeilen = 0;
    Zuweisung(expr,neue_hv(expr));
    expr->erg_art = ERG_VAR;
  }
  if (zw != NULL)
  { zw->com.rtest.var = erg; }   
  if (mode && (expr->erg_art == ERG_CONST))
    expr->erg_art = ERG_VAR;
}

/* ************************************************************************* */
/* Zuweisung einer Struktur an eine Strukturvariable                         */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Struktur                                                      */
/*             Strukturvariable                                              */
/*                                                                           */
/* ************************************************************************* */

Zuweisung(expr,var)
T_EXPR * expr;
VARNODE * var;
{ VARNODE * hv = NULL;
  if (expr->factors.funccall.exprlist->count > 1)
  { GET_MEM(hv,1,VARNODE);
    hv->lk = VARi;
    VARi = hv;
    hv->free = 1;
    hv->dir_indir = INDIRECT;
    hv->ein = get_hvar(typ_int,hv->scavec = var->scavec);
  }
  record_typ = expr->erg_typ;
  if (record_typ->Art == ST_TRECORD)
  { record_mem = record_typ->info.record.mem; }
  record_off = 0;
  exlist_zuweisen(expr->factors.funccall.exprlist,var,hv,expr,record_typ);
  free_hvar(hv);
}

/* ************************************************************************* */
/* Zuweisung einzelner Komponenten einer Struktur an eine Strukturvariable   */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Komponententeilliste                                          */
/*             Strukturvariable                                              */
/*             Hilfsvariable                                                 */
/*             ganze Komponentenliste                                        */
/*             Datentyp der Struktur                                         */
/*                                                                           */
/* ************************************************************************* */

exlist_zuweisen(expr,bas,hv,ex,typ)
T_EXPR * expr, *ex;
VARNODE * bas, * hv;
ST_TYPE * typ;
{ ZWCODE * zw1, *zw2;
  ST_TYPE * t;
  if (expr->link != NULL)
    exlist_zuweisen(expr->link,bas,hv,ex,typ);
  if (ex->code == NULL)
    zw1 = NULL;
  else
  { zw1 = ex->code;
    while (zw1->link != NULL)
      zw1 = zw1->link;
  }
  if (typ->Art == ST_TARRAY)
  { t = typ->info.array.typ;
    while (t && (t->Art == ST_TARRAY) && (t->info.array.top == 0))
      t = t->info.array.typ;
  }
  else
  { t = record_mem->inh.typ; }
  if (record_off != 0)
  { if (typ->Art == ST_TARRAY)
    { GET_MEM(zw2,1,ZWCODE)
      zw1->link = zw2;
      zw1 = zw2;
      ex->zeilen += 1;
      zw1->art = CO_ARROFFSET;
      zw1->com.arroff.basis = bas;
      zw1->com.arroff.var = hv;
      zw1->com.arroff.typ = t;
      zw1->com.arroff.firstelem = t->firstelem;
      if (record_off == t->used[ALL])
        zw1->com.arroff.erst = 1;
    }
    else
    { GET_MEM(zw2,1,ZWCODE)
      zw1->link = zw2;
      zw1 = zw2;
      ex->zeilen += 1;
      zw1->art = CO_RECOFFSET;
      zw1->com.recoff.basis = bas;
      zw1->com.recoff.var = hv;
      zw1->com.recoff.typ = typ;
      zw1->com.recoff.offset = record_off;
      zw1->com.recoff.firstelem = expr->erg_typ->firstelem;
    }
  }
  switch(expr->erg_art)
  { case ERG_VAR :
    case ERG_SPEC :
      mache_Constexpr(expr,t,0);
      ex->zeilen += expr->zeilen + 1;
      if (zw1 != NULL)
        zw1->link = expr->code;
      else
        ex->code = zw1 = expr->code;
      if (zw1 != NULL)
        while (zw1->link != NULL)
          zw1 = zw1->link;
      GET_MEM(zw2,1,ZWCODE);
      if (zw1 != NULL)
        zw1->link = zw2;
      else
        ex->code = zw1 = zw2;
      zw1 = zw2;
      if (t->used[ALL] != 1)
      { zw1->art = CO_BLOCKASS;
        zw1->com.blockass.wert = expr->hv;
        zw1->com.blockass.erg = (record_off == 0) ? bas : hv;
        zw1->com.blockass.typ = t;
      }
      else
      { zw1->art = CO_ASSIGN;
        zw1->com.assign.wert = expr->hv;
        zw1->com.assign.erg = (record_off == 0) ? bas : hv;
      }
      break;
    case ERG_RAND :
    case ERG_CONST :
    case ERG_PROC :
      expr->hv = (record_off == 0) ? bas : hv;
      mache_Constexpr(expr,t,0);
      ex->zeilen += expr->zeilen;
      if (zw1 != NULL)
        zw1->link = expr->code;
      else
        ex->code = zw1 = expr->code;
      break;
    case ERG_REC :
      { ST_TYPE * rt = record_typ;
        MEMBERS * rm = record_mem;
        int ro = record_off;
        expr->zeilen = 0;
        Zuweisung(expr,(record_off == 0) ? bas : hv);
        record_typ = rt;
        record_mem = rm;
        record_off = ro;
        ex->zeilen += expr->zeilen;
        if (zw1 != NULL)
          zw1->link = expr->code;
        else
          ex->code = zw1 = expr->code;
      }
      break;
    default :
      bug("exlist_zuweisen %d",expr->erg_art);
      break;
  }
  record_off += expr->erg_typ->used[ALL];
  if ((typ->Art != ST_TARRAY) && (record_mem->link != NULL))
  { record_mem = record_mem->link; }
}

/* ************************************************************************* */
/* Zuweisung einer konstanten Struktur an eine Strukturvariable              */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Strukturvariablenausdruck                                     */
/*             konstante Struktur                                            */
/*             Datentyp der Struktur                                         */
/*             Strukturvariable                                              */
/*                                                                           */
/* ************************************************************************* */

Const_record_assign(expr,Const,rectyp,feld)
T_EXPR * expr;
ST_CONST * Const;
ST_TYPE * rectyp;
VARNODE * feld;
{ int anz, kompnr = 0;
  ST_TYPE * t,* t1 = rectyp;
  T_EXPR ex;
  ZWCODE * zw = NULL;
  VARNODE * hv = NULL;
  if (rectyp->Art == ST_TARRAY)
  { int erst = 1;
    anz = elementezahl(rectyp->info.array.bereich) + 1;
    t = rectyp->info.array.typ;
    while (t && (t->Art == ST_TARRAY) && (t->info.array.top == 0))
    { anz *= (elementezahl(t->info.array.bereich) + 1);
      t = t->info.array.typ;
    }
    Const = Const->wert.recConst;
    while (anz > 0)
    { ex.erg_art = ERG_CONST;
      ex.erg_typ = t;
      ex.erg.Const = Const;
      ex.zeilen = 0;
      ex.hv = (hv == NULL) ? feld : hv;
      mache_Constexpr(&ex,t,0);
      if (zw == NULL)
      { expr->code = zw = ex.code;
        while (zw->link != NULL)
          zw = zw->link;
      }
      else
      { zw->link = ex.code;
        zw = ex.code;
        while (zw->link != NULL)
          zw = zw->link;
      }
      expr->zeilen += ex.zeilen;
      kompnr += t->used[ALL];
      anz--;
      Const = Const->link;
      if (anz)
      { ZWCODE * zw1;
        if (hv == NULL)
        { GET_MEM(hv,1,VARNODE);
          hv->lk = VARi;
          VARi = hv;
          hv->free = 1;
          hv->dir_indir = INDIRECT;
          hv->ein = get_hvar(typ_int,hv->scavec = feld->scavec);
        }
        GET_MEM(zw1,1,ZWCODE);
        zw1->art = CO_ARROFFSET;
        zw1->com.arroff.basis = feld;
        zw1->com.arroff.var = hv;
        zw1->com.arroff.typ = t;
        zw1->com.arroff.erst = erst;
        erst = 0;
        zw->link = zw1;
        zw = zw1;
        expr->zeilen++;
        zw1->com.arroff.firstelem = t->firstelem;
      }
    }
  }
  else
  { MEMBERS * m;
    m = t1->info.record.mem;
    Const = Const->wert.recConst;
    while (m)
    { t = m->inh.typ;
      ex.erg_art = ERG_CONST;
      ex.erg_typ = t;
      ex.erg.Const = Const;
      ex.zeilen = 0;
      ex.hv = (hv == NULL) ? feld : hv;
      mache_Constexpr(&ex,t,0);
      if (zw == NULL)
      { expr->code = zw = ex.code;
        while (zw->link != NULL)
          zw = zw->link;
      }
      else
      { zw->link = ex.code;
        zw = ex.code;
        while (zw->link != NULL)
          zw = zw->link;
      }
      expr->zeilen += ex.zeilen;
      kompnr += t->used[ALL];
      anz--;
      Const = Const->link;
      if (m->link && (m->flag == 0))
      { ZWCODE * zw1;
        if (hv == NULL)
        { GET_MEM(hv,1,VARNODE);
          hv->lk = VARi;
          VARi = hv;
          hv->free = 1;
          hv->dir_indir = INDIRECT;
          hv->ein = get_hvar(typ_int,hv->scavec = feld->scavec);
        }
        GET_MEM(zw1,1,ZWCODE);
        zw1->art = CO_RECOFFSET;
        zw1->com.recoff.basis = feld;
        zw1->com.recoff.var = hv;
        zw1->com.recoff.typ = rectyp;
        zw1->com.recoff.offset = kompnr;
        zw->link = zw1;
        zw = zw1;
        expr->zeilen++;
        m = m->link;
        t = m->inh.typ;
        zw1->com.recoff.firstelem = t->firstelem;
      }
      else
        m = NULL;
    }
  }
  free_hvar(hv);
}
