/* Parallaxis Version: @(#)code.h	2.13  2/28/92 14:36:39  */
/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : code.h                                                            */
/*                                                                           */
/* Strukturen zur internen Repraesentation des PARZ-Kodes                    */
/*                                                                           */
/* ************************************************************************* */


/* Struktur zur Vergabe der Variablennummern an die WITH-Komponenten */
typedef struct with_comp {
        struct with_comp *      link;   /* Verkettung */
        Eintrag *               komp;   /* Komponenteneintrag in der ST */
        Eintrag *               hvar;   /* Hilfsvariableneintrag */
} WITH_COMP;


/* Feldzugriffsstruktur */
typedef struct ar_comp {
        struct ar_comp *        link;
        int                     art;    /* 0 : Array, 1 : Record, 2 : Pointer */
        union {
                struct {
                VARNODE *       erg;    /* Ausdrucksergebnis */
                VARNODE *       var;    /* Produktvariable */
                struct zwcode * code;   /* Ausdruck berechnen */
                int             zeilen; /* Anzahl der Zwischencodezeilen */
                int             offset; /* untere Grenze */
                int             scavec; /* Ergebnis skalar oder vektoriell */
                ST_TYPE *       typ;    /* Typ der Elemente */
                } array;
                struct {
                ST_TYPE *       typ;    /* Recordtyp */
                int             comp;   /* Nummer der Komponente */
                } record;
                struct {
                int             mode;   /* folgen noch weitere Reste */
                VARNODE *       erg;    /* Ausdrucksergebnis */
                VARNODE *       var;    /* Produktvariable */
                struct zwcode * rest;  /* der Rest */
                } pointer;
        } ar;
} AR_COMP;

/* Zwischencodestruktur intern */
typedef struct zwcode {
        struct zwcode * link;
        int             art;
        union {
                /* Test der Schranken mit posisitiven Werten */
#define CO_RTEST        1
                /* Test der Schranken mit negativer unteren Schranke */
#define CO_RNTEST       2
                /* Test der Schranken mit nur negativen Schranken */
#define CO_RNNTEST      3
                struct {
                VARNODE *       var;    /* zu testende Variable */
                VARNODE *       hvar;   /* Hilfsvariable */
                ST_TYPE *       typ;    /* Schranken */
                } rtest;
                /* Test von CARDINAL-Variablen */
#define CO_CTEST        4
                struct {
                VARNODE *       var;    /* zu testende Variable */
                } ctest;
                /* Test auf 0 */
#define CO_NTEST        5
                struct {
                VARNODE *       var;    /* zu testende Variable */
                ST_TYPE *       typ;    /* Typ */
                } ntest;
                /* unaere Operation */
#define CO_UNOP         6
                struct {
                int             op;     /* Nummer der Operation */
                VARNODE *       erg;    /* Ergebnisvariable */
                VARNODE *       op1;    /* Operand 1 */
                struct zwcode * ziel;   /* Code fuer Berechnung des Zieles */
                struct zwcode * ex1;    /* Code fuer Berechnung des Ausdrucks */
                } unop;
                /* binaere normale Operation */
#define CO_BINOP        7
                struct {
                int             op;     /* Nummer der Operation */
                VARNODE *       erg;    /* Ergebnisvariable */
                VARNODE *       op1;    /* Operand 1 */
                VARNODE *       op2;    /* Operand 2 */
                struct zwcode * ziel;   /* Code fuer Berechnung des Zieles */
                struct zwcode * ex1;    /* Code fuer Berechnung des Ausdrucks */
                struct zwcode * ex2;    /* Code fuer Berechnung des Ausdrucks */
                } binop;
                /* binaere normale Operation Const op var*/
#define CO_CONSTBINOP   8
                struct {
                int             op;     /* Nummer der Operation */
                VARNODE *       erg;    /* Ergebnisvariable */
                ST_CONST *      op1;    /* Operand 1 */
                VARNODE *       op2;    /* Operand 2 */
                struct zwcode * ziel;   /* Code fuer Berechnung des Zieles */
                struct zwcode * ex1;    /* Code fuer Berechnung des Ausdrucks */
                struct zwcode * ex2;    /* Code fuer Berechnung des Ausdrucks */
                } Constbinop;
                /* binaere normale Operation */
#define CO_BINOPCONST   9
                struct {
                int             op;     /* Nummer der Operation */
                VARNODE *       erg;    /* Ergebnisvariable */
                VARNODE *       op1;    /* Operand 1 */
                ST_CONST *      op2;    /* Operand 2 */
                struct zwcode * ziel;   /* Code fuer Berechnung des Zieles */
                struct zwcode * ex1;    /* Code fuer Berechnung des Ausdrucks */
                struct zwcode * ex2;    /* Code fuer Berechnung des Ausdrucks */
                } binopConst;
                /* Zuweisung */
#define CO_ASSIGN       10
                struct {
                VARNODE *       erg;    /* Ergebnisvariable */
                VARNODE *       wert;   /* zuzuweisender Wert */
                struct zwcode * ziel;   /* Code fuer Berechnung des Zieles */
                struct zwcode * ex1;    /* Code fuer Berechnung des Ausdrucks */
                } assign;
                /* Zuweisung mit Konstanten */
#define CO_CONSTASS     11
                struct {
                VARNODE *       erg;    /* Ergebnisvariable */
                int             charst; /* Charakter oder Stringzuweisung */
                ST_CONST *      wert;   /* zuzuweisender Wert */
                struct zwcode * ziel;   /* Code fuer Berechnung des Zieles */
                } Constass;
                /* Zuweisung von Array, Record und Set */
#define CO_BLOCKASS     12
                struct {
                VARNODE *       erg;    /* Ergebnisvariable */
                VARNODE *       wert;   /* zuzuweisender Wert */
                ST_TYPE *       typ;    /* Declarationsinformation */
                struct zwcode * ziel;   /* Code fuer Berechnung des Zieles */
                struct zwcode * ex1;    /* Code fuer Berechnung des Ausdrucks */
                } blockass;
                /* Zuweisung eines konstanten Bereichs an eine Menge */
#define CO_SETASS       13
                struct {
                struct zwcode * ziel;   /* Code fuer Berechnung des Zieles */
                VARNODE *       erg;    /* Ergebnisvariable */
                VARNODE *       help;   /* Elementzeiger */
                unsigned *      set;    /* Menge der  untere Grenze */
                int             anz;    /* Groesse der Menge */
                } setass;
                /* Loesche Menge */
#define CO_CLEARSET     14
                struct {
                struct zwcode * ziel;   /* Code fuer Berechnung des Zieles */
                VARNODE *       erg;    /* Ergebnisvariable */
                VARNODE *       help1;  /* Elementzeiger */
                VARNODE *       help2;  /* Elementzaehler */
                int             anz;    /* Groesse der Menge */
                } clearset;
                /* binaere Operation auf Sets */
#define CO_SETOP        15
#define CO_SETINCL      16
                struct {
                int             op;     /* Nummer der Operation */
                struct zwcode * ziel;   /* Code fuer Berechnung des Zieles */
                struct zwcode * ex1;    /* Code fuer Berechnung des 1. Ausdrucks */
                struct zwcode * ex2;    /* Code fuer Berechnung des 2. Ausdrucks */
                VARNODE *       erg;    /* Ergebnisvariable */
                VARNODE *       helpe;  /* Elementzeiger */
                VARNODE *       op1;    /* Operand 1 */
                VARNODE *       help1;  /* Elementzeiger Operand 1 */
                VARNODE *       op2;    /* Operand 2 */
                VARNODE *       help2;  /* Elementzeiger Operand 2 */
                VARNODE *       count;  /* Zaehler */
                VARNODE *       bhelp1; /* Booleanvariable */
                VARNODE *       bhelp2; /* Booleanvariable */
                int             anz;    /* Groesse der Menge */
                } setop;
                /* Vergleich (=) von Array, Record und Set */
#define CO_EQUAL        17
                /* Vergleich (<>) von Array, Record und Set */
#define CO_UNEQUAL      18
                struct {
                VARNODE *       erg;    /* Ergebnisvariable */
                VARNODE *       op1;    /* Operand 1 */
                VARNODE *       op2;    /* Operand 2 */
                int             scavec; /* skalar oder vektoriell */
                ST_TYPE *       typ;    /* Declarationsinformation */
                struct zwcode * ziel;   /* Code fuer Berechnung des Zieles */
                struct zwcode * ex1;    /* Code fuer Berechnung des Ausdrucks */
                struct zwcode * ex2;    /* Code fuer Berechnung des Ausdrucks */
                } vergl;
                /* AND und OR */
#define CO_ANDOR        19
                struct {
                int             op;     /* Nummer der Operation */
                VARNODE *       erg;    /* Ergebnisvariable */
                VARNODE *       hbv;    /* Hilfsvaraibale */
                VARNODE *       op1;    /* Operand 1 */
                VARNODE *       op2;    /* Operand 1 */
                struct zwcode * ex1;    /* Code fuer Berechnung des 1. Ausdrucks */
                struct zwcode * ex2;    /* Code fuer Berechnung des 2. Ausdrucks */
                int             zeilen; /* Zahl der Zeilen von ex2 */
                } andor;
                /* Parameter popen */
#define CO_POP          20
                struct {
                VARNODE *       erg;    /* Ergebnisvariable */
                int             scavec; /* skalar oder vektoriell */
                } pop;
                /* Parameter-Struktur popen */
#define CO_POPBLOCK     21
                struct {
                VARNODE *       temp;   /* Hilfsvariable */
                ST_TYPE *       typ;    /* Typbeschreibung */
                VARNODE *       erg;    /* Ergebnisvariable */
                int             scavec; /* skalar oder vektoriell */
                } popblock;
                /* Parameter pushen */
#define CO_PARAM        22
#define CO_PARAMCO      23
                struct {
                struct zwcode * link;   /* naechster Parameter */
                struct zwcode * code;   /* Code fuer diesen Parameter */
                VARNODE *       par;    /* Parameter selbst */
                VARNODE *       tpar;   /* tempor"arer Parameter */
                ST_TYPE *       ttyp;   /* Datentyp */
                ST_CONST *      Const;  /* Konstante */
                int             scavec; /* skalar oder vektoriell pushen */
                int             mode;   /* VAR-Parameter */
                } param;
                /* Portnummer */
#define CO_PORT         24
                struct {
                struct zwcode * ex;     /* Ausdruck auswerten */
                VARNODE *       port;   /* Offsetvariable */
                int             low;    /* untere erlaubte Grenze */
                int             high;   /* obere erlaubte Grenze */
                int             pnr;    /* Basisnummer */
                VARNODE *       nach;   /* Portvariable */
                } port;
#define CO_CONSTSEL     25
                struct {
                char *          string;
                struct c_conf * conf;   /* Konfiguration */
                } Constsel;
                /* Funktionsaufruf */
#define CO_FUNCCALL     26
                struct {
                struct zwcode * param;  /* Pushoperationen fuer Parameter */
                int             scavec; /* Ergebnis ist skalar oder vektoriell */
                int             complex;/* Ergebnis als Zeieger */
                VARNODE *       erg;    /* Ergebnisvariable */
                Eintrag *       proc;   /* Procedureintrag */
                struct zwcode * nach;   /* Rangetests bei VAR-Parameter */
                } funccall;
                /* ABS-Standardfunktion */
#define CO_ABS          27
                /* CHR-Standardfunktion */
#define CO_CHR          28
                /* ORD-Standardfunktion */
#define CO_ORD          29
                /* TRUNC-Standardfunktion */
#define CO_TRUNC        30
                /* FLOAT-Standardfunktion */
#define CO_FLOAT        31
                struct {
                struct zwcode * ziel;   /* Code fuer Berechnung des Zieles */
                struct zwcode * expr;   /* Auswerten des Ausdrucks */
                VARNODE *       var;    /* Variable */
                VARNODE *       erg;    /* Ergebnis */
                } abs;
                /* EVEN-Standardfunktion */
#define CO_EVEN         32
                /* ODD-Standardfunktion */
#define CO_ODD          33
                struct {
                struct zwcode * ziel;   /* Code fuer Berechnung des Zieles */
                struct zwcode * expr;   /* Auswerten des Ausdrucks */
                VARNODE *       var;    /* Variable */
                VARNODE *       temp;   /* Hilfsvariable */
                VARNODE *       erg;    /* Ergebnis */
                } oddeven;
                /* CAP */
#define CO_CAP          34
                struct {
                struct zwcode * ziel;   /* Code fuer Berechnung des Zieles */
                struct zwcode * expr;   /* Ausdruck auswerten */
                VARNODE *       hilf1;  /* Boolean-Hilfsvariable */
                VARNODE *       hilf2;  /* Integer-Hilfsvariable */
                VARNODE *       hilf3;  /* Integer-Hilfsvariable */
                VARNODE *       var;    /* Ausdruck */
                VARNODE *       erg;    /* Ergebnis */
                } cap;
                /* RANDOM */
#define CO_RANDOM       35
                struct {
                struct zwcode * erg;    /* Erg.Variable brerechnen */
                VARNODE *       random; /* Variable */
                } rand;
#define CO_REDUCE       36
                struct {
                struct zwcode * expr;   /* Ausdruck berechnen */
                struct zwcode * ziel;   /* Code fuer Berechnung des Zieles */
                struct zwcode * sel;    /* Code fuer Selektion */
                struct zwcode * select; /* konstante Auswahl */
                struct Eintr *  pna;    /* Funktion */
                VARNODE *       var;    /* Ausdruck */
                VARNODE *       erg;    /* Ergebnis */
                int             spez;   /* AND oder OR */
                int             lines;  /* Zahl der Zeilen insgesamt */
                int             prozanz;/* Zahl der maximal aktiven Prozessoren */
                int             true;   /* bool := TRUE wurde bereits ausgegeben */
                VARNODE *       bool;   /* Variable um Fehler festzustellen */
                struct scope *  scop;   /* Geltungsbereich */
                } reduce;
                /* Auswahl dynamisch */
#define CO_DYN          37
                struct {
                struct zwcode * select; /* Ausdruck auswerten */
                struct zwcode * next;   /* naechste Dimension */
                VARNODE *       var;    /* Auswahlvariable */
                struct zwcode * red;    /* Reduce-Code */
                T_STATEMENT *   stat;   /* Anweisungen */
                } dyn;
                /* Record und Array Zugriff */
#define CO_ZUGRIFF      38
                struct {
                AR_COMP *       comp;   /* Code fuer die Komponenten */
                VARNODE *       basis;  /* Basisvariable fuer den Zugriff */
                VARNODE *       var;    /* Hilfsvariable fuer den Zugriff */
                VARNODE *       erg;    /* Ergebnisvariable */
                int             dir_indir; /* direkter oder indirekter Zugriff */
                int             pos;    /* positiver Offset */
                int             neg;    /* negativer Offset */
                int             arr;    /* Feldzugriffskomponente */
                } zugriff;
                /* bilde den Offset bei Strukturkomponenten */
#define CO_RECOFFSET    39
                struct {
                struct zwcode * code;   /* Vorherige Zuweisungen */
                VARNODE *       basis;  /* Basisvariable */
                VARNODE *       var;    /* Hilfsvariable fuer den Zugriff */
                ST_TYPE *       typ;    /* Recordtyp */
                int             offset; /* relative Adresse */
                int             firstelem; /* Art der folgenden Komponente */
                } recoff;
                /* bilde den Offset bei Strukturkomponenten */
#define CO_ARROFFSET    44
                struct {
                struct zwcode * code;   /* Vorherige Zuweisungen */
                VARNODE *       basis;  /* Basisvariable */
                VARNODE *       var;    /* Hilfsvariable fuer den Zugriff */
                ST_TYPE *       typ;    /* Komponententyp */
                int             firstelem; /* Art der folgenden Komponente */
                int             erst;   /* ist ADRESS noetig */
                } arroff;
                /* IN Operation */
#define CO_IN           40
                struct {
                int             mode;   /* Integer oder anderer 1.Operand */
                struct zwcode * ex1;    /* Auswertung 1. Ausdruck */
                struct zwcode * ex2;    /* Auswertung 2. Ausdruck */
                VARNODE *       op1;    /* 1. Operand */
                VARNODE *       op2;    /* 2. Operand */
                int             nummer; /* 1. Operand ist Konstante */
                int             von;    /* unterer Rand */
                int             bis;    /* oberer Rand */
                VARNODE *       erg;    /* Ergebnisvariable */
                VARNODE *       help;   /* Hilfsvariable */
                VARNODE *       boolhelp;/* Hilfsvariable bei vektor Zugriff */
                } setin;
                /* Stringsvergleichen */
#define CO_STRCMP       41
                struct {
                struct zwcode * ex1;    /* Auswertung 1. Ausdruck */
                struct zwcode * ex2;    /* Auswertung 2. Ausdruck */
                VARNODE *       op1;    /* 1. Operand */
                VARNODE *       op2;    /* 2. Operand */
                VARNODE *       erg;    /* Ergebnisvariable */
                VARNODE *       help;   /* Hilfsvariable */
                } strcmp;
                /* Include und Exclude Funktion fuer Mengen */
#define CO_SETEXCL      42
                struct {
                int             mode;   /* Bit 0 : INCL oder EXCL; Bit 1 : Int oder nicht */
                struct zwcode * ex1;    /* Auswertung 1. Ausdruck */
                struct zwcode * ex2;    /* Auswertung 2. Ausdruck */
                VARNODE *       set;    /* 1. Operand */
                VARNODE *       wert;   /* 2. Operand */
                VARNODE *       help;   /* Hilfsvariable */
                int             off;    /* Offset */
                } setexcl;
                /* Selection mit zwei Integerwerten */
#define CO_DIMSEL       43
                struct {
                struct zwcode * ex1;    /* Auswertung 1. Ausdruck */
                struct zwcode * ex2;    /* Auswertung 2. Ausdruck */
                VARNODE *       von;    /* 1. Operand */
                VARNODE *       bis;    /* 2. Operand */
                VARNODE *       dim;    /* Dimensionsvariable */
                VARNODE *       hv1;    /* 1. Hilfsvariable */
                VARNODE *       hv2;    /* 2. Hilfsvariable */
                ST_CONST *      co1;    /* 1. Konstante */
                ST_CONST *      co2;    /* 2. Konstante */
                } dimsel;
                /* trigonometrische und logarithmische Funktionen */
#define CO_MATH         45
                struct {
                int             ftyp;   /* Art der Funktion */
                struct zwcode * ziel;   /* Code fuer Berechnung des Zieles */
                struct zwcode * expr;   /* Auswerten des Ausdrucks */
                VARNODE *       var;    /* Variable */
                VARNODE *       help;   /* Hilfsvariable */
                VARNODE *       erg;    /* Ergebnis */
                } math;
                /* arctan2 */
#define CO_ARCTAN2      46
                struct {
                struct zwcode * ziel;   /* Code fuer Berechnung des Zieles */
                struct zwcode * expr1;  /* Auswerten des 1. Ausdrucks */
                struct zwcode * expr2;  /* Auswerten des 2. Ausdrucks */
                VARNODE *       var1;   /* Variable des 1. Ausdrucks */
                VARNODE *       var2;   /* Variable des 2. Ausdrucks */
                ST_CONST *      con;    /* Konstante */
                VARNODE *       erg;    /* Ergebnis */
                } arctan2;
                /* Zuweisungsanweisung */
#define CO_ZUWEIS       100
                struct {
                struct zwcode * erg;    /* Ergebnisvariable berechnen */
                struct zwcode * op;     /* Befehle */
                } zuweis;
                /* Prozeduraufruf */
#define CO_PROCCALL     101
                struct {
                struct zwcode * param;  /* Pushoperationen fuer Parameter */
                Eintrag *       proc;   /* Procedureintrag */
                struct zwcode * nach;   /* Rangetests bei VAR-Parameter */
                } proc;
                /* if-then-Anweisung */
#define CO_IFTHEN       102
                struct {
                int             scavec; /* skalar oder vektoriell */
                int             size;   /* Groesse der folgenden Anweisungen */
                int             cont;   /* Fortsetzung elsif bzw. else */
                int             plus;   /* main := FALSE einfuegen */
                VARNODE *       main;   /* Prozessor hat bereits gearbeitet */
                VARNODE *       last;   /* letzte Auswahl */
                struct zwcode * expr;   /* Code fuer die Auswahl */
                VARNODE *       bool;   /* Auswahlvariable */
                T_STATEMENT *   stat;   /* Anweisungsteil */
                struct zwcode * elsif;  /* ELSIF-Teil */
                T_STATEMENT *   elsest; /* else-Anweisungen */
                } ifthen;
                /* while-do-Anweisung */
#define CO_WHILE        103
                struct {
                int             scavec; /* skalar oder vektoriell */
                VARNODE *       bool;   /* Auswahlvariable */
                VARNODE *       sbool;  /* skalare Hilfsvariable bei vektoriell */
                struct zwcode * expr;   /* Code fuer Auswahl */
                T_STATEMENT *   stat;   /* Anweisungsteil */
                } whiledo;
                /* case-of-Anweisung */
#define CO_CASE         104
                struct {
                VARNODE *       erg;    /* Ergebnis der Ausdrucksauswertung */
                VARNODE *       var;    /* Hilfsvariable fuer Vektor*/
                struct zwcode * next;   /* naechste Auswahl */
                struct zwcode * expr;   /* Ausdruck auswerten */
                struct zwcode * sel;    /* Auswahlcode */
                int             first;  /* erste Case-Anweisung bei vektor-Auswahl */
                int             zeilen; /* folgende Zeilen */
                int             all;    /* zu ueberspringende Zeilen */
                T_STATEMENT *   stat;   /* Anweisungen */
                } cases;
                /* case-of-Anweisung */
#define CO_CASELABEL    99
                struct {
                ST_CONST *      unten;  /* untere Grenze */
                struct zwcode * lowex;  /* Zuweisung untere Grenze */
                VARNODE *       lowb;   /* untere Grenze */
                ST_CONST *      oben;   /* obere Grenze */
                struct zwcode * upex;   /* Zuweisung obere Grenze */
                VARNODE *       upb;    /* obere Grenze */
                VARNODE *       erg;    /* Ergebnis der Ausdrucksauswertung */
                VARNODE *       var;    /* Hilfsvariable fuer mehrfache Caselabels */
                VARNODE *       hvar1;  /* 1. Hilfsvariable */
                VARNODE *       hvar2;  /* 2. Hilfsvariable */
                struct zwcode * next;   /* naechste Auswahl */
                } caselabel;
                /* repeat-until-Anweisung */
#define CO_REPEAT       105
                struct {
                int             scavec; /* skalar oder vektoriell */
                VARNODE *       bool;   /* Auswahlvariable */
                VARNODE *       sbool;  /* skalare Hilfsvariable bei vektoriell */
                struct zwcode * expr;   /* Code fuer Auswahl */
                int             lines;  /* Anzahl der Codezeilen fuer Auswahl */
                T_STATEMENT *   stat;   /* Anweisungsteil */
                int             untilex;/* Position der UNTIL-expr */
                } repeat;
                /* loop-Anweisung */
#define CO_LOOP         106
                T_STATEMENT *   loop;   /* loop-Anweisungen */
                /* for-to-do-Anweisung */
#define CO_FOR          107
                struct {
                int             mode;   /* skalar/vektoriell, Konstante/Variable */
                struct zwcode * ex1;    /* Ausdruck von */
                struct zwcode * ex2;    /* Ausdruck bis */
                VARNODE *       lauf;   /* Laufvariable */
                VARNODE *       temp;   /* Incrementvariable */
                T_STATEMENT *   stat;   /* Anweisungen */
                int             inc;    /* Incrementierungswert */
                VARNODE *       vbool;  /* Bedingungsvariable vektoriell */
                VARNODE *       sbool;  /* Bedingungsvariable skalar */
                VARNODE *       bis;    /* Variable als Obergrenze */
                ST_CONST *      bisc;   /* Konstante als Obergrenze */
                } forto;
                /* with-do-Anweisung */
#define CO_WITH         108
                struct {
                struct zwcode * prev;   /* andere Komponente */
                VARNODE *       var;    /* Ergebnis von WITH-Ausdruck */
                VARNODE *       nach;   /* Hilfsvariable */
                int             adres;  /* ADRESS oder DIRECT */
                int             nummer; /* Komponentennummer */
                ST_TYPE *       typ;    /* Strukturtyp */
                T_STATEMENT *   stat;   /* Anweisungen */
                } with;
                /* exit-Anweisung */
#define CO_EXIT         109
                /* return-Anweisung */
#define CO_RETURN       110
                struct zwcode * retcode;/* Zuweisungscode fuer Ergebnis */
                /* parallel-Anweisung */
#define CO_PARALLEL     111
                struct {
                struct zwcode * select; /* statischer Auswahlcode */
                struct zwcode * var;    /* dynamischer Auswahlcode */
                int             prozanz;/* Zahl der aktiven Prozessoren */
                T_STATEMENT *   stat;   /* Anweisungen */
                int             lines;  /* Anzahl der Zeilen fuer die Anweisung */
                int             Zeile2; /* Zeilennummer von ENDPARALLEL */
                } paral;
                /* propagate-Anweisung */
#define CO_PROPAGATE    112
                struct {
                int             mode;   /* Art der PROPAGATE-Anweisung */
                union {
                VARNODE *       port;   /* Ausgabeportvariable */
                int             pnr;    /* Ausgabeportnummer */
                } out;
                int ebene;              /* Ebene der auto-index-Variablen */
                union {
                VARNODE *       port;   /* Eingabeportvariable */
                int             pnr;    /* Eingabeportnummer */
                } in;
                struct zwcode * code;   /* Portadresse ermitteln */
                union {
                VARNODE *       var;    /* Anzahlvariable */
                int             anz;    /* Anzahl */
                } anz;
                struct zwcode * vonex;  /* von-Ausdruck berechnen */
                struct zwcode * nachex; /* nach-Ausdruck berechnen */
                struct zwcode * test;   /* Range-Test */
                VARNODE *       von;    /* Variable von */
                VARNODE *       nach;   /* Variable nach */
                VARNODE *       temp;   /* Zaehlvariable */
                } prop;
                /* propagate-Anweisung mit REDUCE */
#define CO_PROPAGATERE  113
#define CO_SEND         114
#define CO_RECEIVE      115
                struct {
                int             mode;   /* Art der PROPAGATE-Anweisung */
                union {
                VARNODE *       port;   /* Ausgabeportvariable */
                int             pnr;    /* Ausgabeportnummer */
                } out;
                int ebene;              /* Ebene der auto-index-Variablen */
                union {
                VARNODE *       port;   /* Eingabeportvariable */
                int             pnr;    /* Eingabeportnummer */
                } in;
                struct zwcode * code;   /* Portadresse ermitteln */
                struct zwcode * vonex;  /* von-Ausdruck berechnen */
                struct zwcode * nachex; /* nach-Ausdruck berechnen */
                struct zwcode * test;   /* Range-Test */
                VARNODE *       von;    /* Variable von */
                VARNODE *       nach;   /* Variable nach */
                struct Eintr *  pna;    /* Funktion */
                } propre;
                /* load-Anweisung */
#define CO_LOAD         116
                /* store-Anweisung */
#define CO_STORE        117
                struct {
                struct zwcode * select; /* Auswahlcode */
                struct zwcode * var;    /* Auswahlvariable */
                struct zwcode * vekex;  /* Vektorvariable berechnen */
                struct zwcode * skaex;  /* Skalarvariable berechnen */
                struct zwcode * lenex;  /* Laengenvariable berechnen */
                ST_TYPE *       typ;    /* Datentyp */
                int             prozanz;/* Zahl der aktiven Prozessoren */
                VARNODE *       vek;    /* Vektorvariable */
                VARNODE *       ska;    /* Skalarvariable */
                VARNODE *       len;    /* Lanegenvariable */
                VARNODE *       testvar;/* LOAD/STORE mit 0 Prozessoren ? */
                int             lines;  /* Anzahl der Zeilen fuer die Anweisung */
                int             tests;  /* Flag um den O Prozessorentest auszugeben */
                } load;
                /* debug-Anweisung */
#define CO_DEBUG        118
                /* trace-Anweisung */
#define CO_TRACE        119
                /* notrace-Anweisung */
#define CO_NOTRACE      120
                struct {
                struct zwcode * rest;   /* Zwischencode fuer andere Debug-Anweisungen */
                struct zwcode * ex;     /* Ausdruck berechnen */
                VARNODE *       var;    /* Variable */
                ST_CONST *      con;    /* String */
                ST_TYPE *       typ;    /* Typ */
                } debtr;
                /* halt-Anweisung */
#define CO_HALT         121
                /* Standardprozeduren */
                /* DEC */
#define CO_DEC          200
                /* DEC */
#define CO_INC          201
                struct {
                struct zwcode * expr1;  /* Ausdruck von In-Dec.variable berechnen */
                struct zwcode * expr2;  /* Ausdruck von In-Dec.variable berechnen */
                struct zwcode * test;   /* Grenzen testen */
                VARNODE *       erg;    /* Ergebnis */
                VARNODE *       temp;   /* Hilfsvariable */
                VARNODE *       var;    /* In-/Decrementvariable */
                int             wert;   /* In-/Decrementwert */
                } incdec;
                /* WRITELN */
#define CO_WRITELN      210
                /* WRITE */
#define CO_WRITE        211
                /* WRITESTRING */
#define CO_WRITESTRING  212
                /* WRITEBOOL */
#define CO_WRITEBOOL    213
                /* WRITEINT */
#define CO_WRITEINT     214
                /* WRITEREAL */
#define CO_WRITEREAL    215
                /* WRITEFIXPT */
#define CO_WRITEFIXPT   216
                struct {
                struct zwcode * expr1;  /* 1-ten Ausdruck berechnen */
                struct zwcode * expr2;  /* 2-ten Ausdruck berechnen */
                struct zwcode * expr3;  /* 3-ten Ausdruck berechnen */
                ST_CONST *      Const1; /* 1. Konstante */
                int             Const2; /* 2. Konstante */
                int             Const3; /* 3. Konstante */
                VARNODE *       var1;   /* 1. Variable */
                VARNODE *       var2;   /* 2. Variable */
                VARNODE *       var3;   /* 3. Variable */
                } write;
                /* Lese-Befehle */
#define CO_READ         217
                struct {
                struct zwcode * expr;   /* Ausdruck auswerten */
                VARNODE *       var;    /* Variable */
                int             mode;   /* = 1 bei READSTRING */
                int             len;    /* Laege bei READSTRING */
                struct zwcode * test;   /* Bereichsueberpruefung */
                } read;
                /* Oeffnen von Files */
#define CO_OPENINPUT    218
#define CO_OPENOUTPUT   219
                struct {
                struct zwcode * expr;   /* Ausdruck berechnen */
                ST_CONST *      Const;  /* Konstante */
                VARNODE *       var;    /* Variable */
                } open;
                /* Schliessen von Files */
#define CO_CLOSEINPUT   220
#define CO_CLOSEOUTPUT  221
#define CO_CONNECT      222
                struct {
                VARNODE *       erg;    /* Ergebnisvariable */
                int             mode;   /* Art des Tests */
                union {
                VARNODE *       port;   /* Ausgabeportvariable */
                int             pnr;    /* Ausgabeportnummer */
                } p1;
                struct zwcode * code1;  /* Portadresse ermitteln */
                union {
                VARNODE *       port;   /* Eingabeportvariable */
                int             pnr;    /* Eingabeportnummer */
                } p2;
                struct zwcode * code2;  /* Portadresse ermitteln */
                } connect;
#define CO_NEW          223
#define CO_DISPOSE      224
                struct {
                struct zwcode * expr;   /* Ausdruck auswerten */
                VARNODE *       var;    /* Variable */
                ST_TYPE *       type;   /* Datentyp */
                } new;
#define CO_CONNECTION   300
                struct {
                struct c_conf * conf;   /* Quellconfiguration */
                struct c_conf * dconf;   /* Zielconfiguration */
                struct c_group * group; /* Quellgruppe */
                struct zwcode * bexpr;  /* Discriminant */
                VARNODE *       bvar;   /* Discr. Variable */
                int             constants; /* wieviele konstante Quellen */
                VARNODE *       b1var;  /* konstante Quelle ? HV 1 */
                VARNODE *       b2var;  /* konstante Quelle ? HV 2 */
                VARNODE *       ihv;    /* konstante Quelle ? Integer HV */
                int *           source; /* konstante Quellen */
                int             czeilen; /* Zahl der Zeilen mit discexpr */
                struct zwcode * rest;   /*  der Rest  */
                int             von, bis; /* Portnummern */
                int             mode;   /* BIconnect ? */
                int             max_dim; /* Zahl der Dimensionen ? */
                int             zeilen; /* Zahl der Zeilen */
                int             has_range; /* enth"alt Bereiche */
                } connection;
#define CO_CONN         301
                struct {
                struct zwcode * next;   /* weitere Bereiche */
                int             mode;   /* Modus */
                int             offset; /* Konstante */
                int             off;    /* 1. PE */
                struct zwcode * expr;   /* Berechnungscode */
                VARNODE *       exprvar; /* Variable der expr */
                VARNODE *       hvar;   /*  Variable mit der PE-Nr */
                int             fak;    /* Multiplikator */
                int             top;    /* Bereichspruefungstyp */
                } conn;
#define CO_CORANGE      302
                struct {
                struct zwcode * next;   /* weitere Bereiche */
                int             bas;    /* Basis */
                int             bis;    /* Obere Grenze */
                int             add;    /* Offset */
                int             line;   /* Nummer der Sprungzeile */
                VARNODE *       var1;   /* Speicher */
                VARNODE *       var2;   /* Zaehler */
                VARNODE *       var3;   /* Zaehler */
                } corange;
#define CO_OPENWINDOW   303
#define CO_OPENABSWINDOW   318
#define CO_GETPIXEL     304
#define CO_SETPIXEL     305
#define CO_MOVETO       317
                struct {
                struct zwcode * ziel;   /* Code fuer Berechnung des Zieles */
                struct zwcode * expr1;  /* Auswerten des 1. Ausdrucks */
                struct zwcode * expr2;  /* Auswerten des 2. Ausdrucks */
                int             mode;   /* Konstanten ? */
                struct {
                    VARNODE *   var;    /* Variable des 1. Ausdrucks */
                    ST_CONST *  con;    /* oder Konstante */
                    }           one;
                struct {
                    VARNODE *   var;    /* Variable des21. Ausdrucks */
                    ST_CONST *  con;    /* oder Konstante */
                    }           two;
                VARNODE *       erg;    /* Ergebnis */
                } open_get;
#define CO_LINETO       306
                struct {
                struct zwcode * expr1;  /* Auswerten des 1. Ausdrucks */
                struct zwcode * expr2;  /* Auswerten des 2. Ausdrucks */
                struct zwcode * expr3;  /* Auswerten des 3. Ausdrucks */
                struct zwcode * expr4;  /* Auswerten des 4. Ausdrucks */
                int             mode;   /* Konstanten ? */
                struct {
                    VARNODE *   var;    /* Variable des 1. Ausdrucks */
                    ST_CONST *  con;    /* oder Konstante */
                    }           one;
                struct {
                    VARNODE *   var;    /* Variable des21. Ausdrucks */
                    ST_CONST *  con;    /* oder Konstante */
                    }           two;
                struct {
                    VARNODE *   var;    /* Variable des 1. Ausdrucks */
                    ST_CONST *  con;    /* oder Konstante */
                    }           three;
                struct {
                    VARNODE *   var;    /* Variable des21. Ausdrucks */
                    ST_CONST *  con;    /* oder Konstante */
                    }           four;
                } lineto;
#define CO_SELECTWINDOW 307
#define CO_CLOSEWINDOW  308
#define CO_SETCOLOR     309
                struct {
                struct zwcode * expr;   /* Auswerten des 1. Ausdrucks */
                int             mode;   /* Konstanten ? */
                struct {
                    VARNODE *   var;    /* Variable des 1. Ausdrucks */
                    ST_CONST *  con;    /* oder Konstante */
                    }           one;
                } select_set;
#define CO_WINDOWSIZE   310
                struct {
                struct zwcode * expr1;  /* Auswerten des 1. Ausdrucks */
                struct zwcode * expr2;  /* Auswerten des 2. Ausdrucks */
                struct zwcode * expr3;  /* Auswerten des 3. Ausdrucks */
                struct zwcode * expr4;  /* Auswerten des 4. Ausdrucks */
                VARNODE *       var1;   /* Variable des 1. Ausdrucks */
                VARNODE *       var2;   /* Variable des 2. Ausdrucks */
                } windowsize;
                /* WRITE */
#define CO_DRAW        311
                /* DRAWSTRING */
#define CO_DRAWSTRING  312
                /* DRAWBOOL */
#define CO_DRAWBOOL    313
                /* DRAWINT */
#define CO_DRAWINT     314
                /* DRAWREAL */
#define CO_DRAWREAL    315
                /* DRAWFIXPT */
#define CO_DRAWFIXPT   316
                struct {
                struct zwcode * expr1;  /* 1-ten Ausdruck berechnen */
                struct zwcode * expr2;  /* 2-ten Ausdruck berechnen */
                struct zwcode * expr3;  /* 3-ten Ausdruck berechnen */
                ST_CONST *      Const1; /* 1. Konstante */
                int             Const2; /* 2. Konstante */
                int             Const3; /* 3. Konstante */
                VARNODE *       var1;   /* 1. Variable */
                VARNODE *       var2;   /* 2. Variable */
                VARNODE *       var3;   /* 3. Variable */
                } draw;
/*#define CO_MOVETO       317*/
        } com;
} ZWCODE;

/* unerreichbaren Kode vermerken */
typedef struct unreached {
        struct unreached *      link;
        int                     von, bis;        /* Zeilennummer in PARZ */
        } UNREACHED;

/* max.:    318 */

