static char _sccsid[] = "Parallaxis Version: @(#)code_out.c	2.13  2/28/92 15:09:55";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : code_out.c                                                        */
/*                                                                           */
/* Funktionen, die den PARZ-Code ausgeben                                    */
/*                                                                           */
/* ************************************************************************* */


#include "outputx.h"
#include "conf.h"

extern char * getstring();

/* ************************************************************************* */
/* Ausgabe der Zwischenrepraesentation als PARZ-Kode                         */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Zwischencodeknoten                                            */
/*                                                                           */
/* ************************************************************************* */


code_ausgeben(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ while (zw != NULL)
  { switch (zw->art)
    { case CO_RTEST :
        out_rtest(err,zw);
        break;
      case CO_RNTEST :
        out_rntest(err,zw);
        break;       
      case CO_RNNTEST :
        out_rnntest(err,zw);
        break;       
      case CO_NTEST :
        out_ntest(err,zw);
        break;
      case CO_CTEST :
        out_ctest(err,zw);
        break;
      case CO_UNOP :
        out_unop(err,zw);
        break;
      case CO_BINOP :
        out_binop(err,zw);
        break;
      case CO_CONSTBINOP :
        out_constbinop(err,zw);
        break;
      case CO_BINOPCONST :
        out_binopconst(err,zw);
        break;
      case CO_ASSIGN :
        out_assign(err,zw);
        break;
      case CO_CONSTASS :
        out_constass(err,zw);
        break;
      case CO_BLOCKASS :
        out_blockass(err,zw);
        break;
      case CO_SETASS :
        out_setass(err,zw);
        break;
      case CO_CLEARSET :
        out_clearset(err,zw);
        break;
      case CO_SETOP :
        out_setop(err,zw);
        break;
      case CO_SETINCL :
        out_setincl(err,zw);
        break;
      case CO_EQUAL :
        out_equal(err,zw);
        break;
      case CO_UNEQUAL :
        out_unequal(err,zw);
        break;
      case CO_ANDOR :
        out_andor(err,zw);
        break;        
      case CO_POP :
        out_pop(err,zw);
        break;
      case CO_POPBLOCK :
        out_popblock(err,zw);
        break;
      case CO_FUNCCALL :
        out_funccall(err,zw);
        break;
      case CO_ABS :
        out_abs(err,zw);
        break;
      case CO_CHR :
      case CO_ORD :
      case CO_TRUNC :
      case CO_FLOAT :
        out_float(err,zw);
        break;
      case CO_EVEN :
        out_even(err,zw);
        break;
      case CO_ODD :
        out_odd(err,zw);
        break;
      case CO_CAP :
        out_cap(err,zw);
        break;
      case CO_RANDOM :
        out_random(err,zw);
        break;
      case CO_REDUCE :
        out_reduce(err,zw);
        break;
      case CO_DYN :
        out_dyn(err,zw);
        break;
      case CO_ZUGRIFF :
        out_zugriff(err,zw);
        break;
      case CO_RECOFFSET :
        out_recoffset(err,zw);
        break;
      case CO_ARROFFSET :
        out_arroffset(err,zw);
        break;
      case CO_IN :
        out_in(err,zw);
        break;
      case CO_STRCMP :
        out_strcmp(err,zw);
        break;          
      case CO_SETEXCL :
        out_setexcl(err,zw);
        break;
      case CO_DIMSEL :
        out_dimsel(err,zw);
        break;
      case CO_MATH :
        out_math(err,zw);
        break;
      case CO_ARCTAN2 :
        out_arctan2(err,zw);
        break;       
      case CO_ZUWEIS :
        out_zuweis(err,zw);
        break;
      case CO_PARAM :
        out_param(err,zw);
        break;
      case CO_PARAMCO :
        out_paramco(err,zw);
        break;
      case CO_CONSTSEL :
        out_constsel(err,zw);
        break;        
      case CO_PROCCALL :
        out_proccall(err,zw);
        break;
      case CO_IFTHEN :
        out_ifthen(err,zw);
        break;
      case CO_WHILE :
        out_while(err,zw);
        break;
      case CO_REPEAT :
        out_repeat(err,zw);
        break;
      case CO_LOOP :
        out_loop(err,zw);
        break;
      case CO_FOR :
        out_for(err,zw);
        break;
      case CO_CASE :
        out_case(err,zw);
        break;
      case CO_CASELABEL :
        out_caselabel(err,zw);
        break;
      case CO_WITH :
        out_with(err,zw);
        break;
      case CO_EXIT :
        out_exit(err);
        break;
      case CO_RETURN :
        out_return(err,zw);
        break;
      case CO_PARALLEL :
        out_parallel(err,zw);
        break;
      case CO_PROPAGATE :
        out_propagate(err,zw);
        break;
      case CO_PROPAGATERE :
        out_propagatere(err,zw,0);
        break;
      case CO_SEND :
        out_propagatere(err,zw,1);
        break;
      case CO_RECEIVE :
        out_propagatere(err,zw,2);
        break;
      case CO_LOAD :
      case CO_STORE :
        out_store(err,zw);
        break;
      case CO_DEBUG :
      case CO_TRACE :
      case CO_NOTRACE :
        out_notrace(err,zw);
        break;
      case CO_HALT :
        out_halt(err);
        break;
      case CO_PORT :
        out_port(err,zw);
        break;
      case CO_DEC :
      case CO_INC :
        out_inc(err,zw);
        break;
      case CO_WRITELN :
        out_writeln(err);
        break;
      case CO_WRITE :
        char_string = 0;
      case CO_WRITEBOOL :
        out_writebool(err,zw);
        break;
      case CO_WRITEINT :
      case CO_WRITEREAL :
        out_writereal(err,zw);
        break;
      case CO_WRITESTRING :
        out_writestring(err,zw);
        break;
      case CO_WRITEFIXPT :
        out_writefixpt(err,zw);
        break;
      case CO_DRAW :
        char_string = 0;
      case CO_DRAWBOOL :
        out_drawbool(err,zw);
        break;
      case CO_DRAWINT :
      case CO_DRAWREAL :
        out_drawreal(err,zw);
        break;
      case CO_DRAWSTRING :
        out_drawstring(err,zw);
        break;
      case CO_DRAWFIXPT :
        out_drawfixpt(err,zw);
        break;
      case CO_READ :
        out_read(err,zw);
        break;
      case CO_OPENINPUT :
        out_openinput(err,zw);
        break;
      case CO_OPENOUTPUT :
        out_openoutput(err,zw);
        break;
      case CO_CLOSEINPUT :
        out_closeinput(err);
        break;
      case CO_CLOSEOUTPUT :
        out_closeoutput(err);
        break;
      case CO_CONNECT :
        out_connect(err,zw);
        break;
      case CO_NEW :
        out_new(err,zw);
        break;
      case CO_DISPOSE :
        out_dispose(err,zw);
        break;
      case CO_CONNECTION :
        out_connection(zw);
        break;
      case CO_CONN :
        out_conn(zw);
        break;
      case CO_CORANGE :
        out_corange(zw);
        break;
      case CO_OPENWINDOW :
        out_open_get(zw,0,err);
        break;
      case CO_OPENABSWINDOW :
        out_open_get(zw,2,err);
        break;
      case CO_GETPIXEL :
        out_open_get(zw,1,err);
        break;
      case CO_SETPIXEL :
        out_setpixel(zw,err);
        break;
      case CO_LINETO :
        out_lineto(zw,err);
        break;
      case CO_WINDOWSIZE :
        out_windowsize(zw,err);
        break;
      case CO_SELECTWINDOW :
        out_select_set(zw,0,err);
        break;
      case CO_SETCOLOR :
        out_select_set(zw,1,err);
        break;
      case CO_CLOSEWINDOW :
	out_select_set(zw,2,err);
	break;
      case CO_MOVETO :
        out_moveto(zw,err);
        break;
    }
    zw = zw->link;
  }
}


