static char _sccsid[] = "Parallaxis Version: @(#)debug.c	2.13  2/28/92 15:09:57";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : debug.c                                                           */
/*                                                                           */
/* Funktionen, die die XRF-Informationen generieren                          */
/*                                                                           */
/* ************************************************************************* */


#include "outputx.h"
extern char the_filename[];

LINENR * all_lines;      /* Liste aller Zeileninfos */

FILE * debug_file;
extern char * debug_name;
int konstanten = 0;

debug_out()
{ int typs, eintraege, scopes, linecount, member;
  if (verbose_flag)
  { fprintf(stderr,text[49]); }
  if (debug_file = fopen(debug_name,"w"))
  {
  }
  else
  { fprintf(stderr,text[32],debug_name);
    return;
  }
  typs = debug_typen_vorbereiten();
  eintraege = debug_symbols_vorbereiten();
  scopes = debug_scopes_vorbereiten();
  linecount = debug_lines_count(all_lines);
  member = debug_member_count();
  fprintf(debug_file,"423310825\n");
  if (*the_filename)
    fprintf(debug_file,"\nQ %s\n",the_filename);
  writedict(debug_file);
  fprintf(debug_file,"\nS %d\n",eintraege);
  symbols_ausgeben();
  fprintf(debug_file,"\nG %d\n",scopes);
  scopes_ausgeben();
  fprintf(debug_file,"\nZ %d\n",linecount);
  lines_ausgeben();
  fprintf(debug_file,"\nT %d\n",typs);
  typen_ausgeben();
  fprintf(debug_file,"\nM %d\n",member);
  members_ausgeben();
  fprintf(debug_file,"\nC %d\n",konstanten);
  konstanten_ausgeben();
  fprintf(debug_file,"\nE\n");
  fclose(debug_file);
#ifdef MAC
  { int vref;
    char name[256];
    FInfo fdinfo;
    if (GetVol(name,&vref) != noErr)
    { fprintf(stderr,"Error in GetVol !\n");
      return;
    }
    strcpy(name,debug_name);
    CtoPstr(name);
    if (GetFInfo(name,vref,&fdinfo) != noErr)
    { fprintf(stderr,"Error in GetFInfo !\n");
      return;
    }
    fdinfo.fdCreator = 'PARZ';
    if (SetFInfo(name,vref,&fdinfo) != noErr)
    { fprintf(stderr,"Error in SetFInfo !\n");
      return;
    }    
  }
#endif
}

debug_lines_count(l)
LINENR * l;
{ int z = 0;
  while (l)
  { l = l->link;
    z++;
  }
  return z;
}

int debug_typen_vorbereiten()
{ ST_TYPE * t1 = typen_liste;
  int nummer = 0;
  while (t1)
  { if (t1->gueltig)
      t1->nummer = ++nummer;
    t1 = t1->liste;
  }
  return nummer;
}

int debug_scopes_vorbereiten()
{ SCOPE * s = all_scopes;
  int nummer = 0;
  while (s)
  { s->nummer = ++nummer;
    s = s->link;
  }
  return nummer;
}

int debug_symbols_vorbereiten()
{ Eintrag * ein;
  int i, nr = 1;
  ST * s = all_tables;
  while (s)
  { s->startnr = nr;
    for (i = 0; i < TABELLENGROESSE; i++)
    { ein = s->Eintraege[i];
      while (ein)
      { nr++;
        if (ein->gueltig && (ein->Art == N_CONSTANT))
        { switch (ein->param.Const->Art)
          { case ST_CSTRING :
              if ((ein->param.Const->type != typ_string) &&
                  (ein->param.Const->type != typ_char))
                constant_check(ein->param.Const,1);
              break;
            case ST_CREAL :
            case ST_CPI :
            case ST_CNIL :
            case ST_CSET :
            case ST_CREC :
              constant_check(ein->param.Const,1);
              break;
          }
        }
        ein = ein->next;
      }
    }
    s->anz = nr - s->startnr;
    s = s->link;
  }
  return nr-1;
}

constant_check(c,m)
ST_CONST * c;
int m;
{ switch (c->Art)
  { case ST_CINT :
    case ST_CREAL :
    case ST_CSTRING :
    case ST_CPI :
    case ST_CNIL :
    case ST_CELEM :
    case ST_CENUM :
    case ST_CBOOL :
    case ST_CEOL :
      ++konstanten;
      if (m)
        c->nr = konstanten;
      break;
    case ST_CSET :
      ++konstanten;
      if (m)
        c->nr = konstanten;
/*      konstanten += c->type->used[ALL] / 50;*/
      break;
    case ST_CREC :
      if (m)
        c->nr = konstanten + 1;
      c = c->wert.recConst;
      while (c)
      { constant_check(c,0);
        c = c->link;
      }
      break;
  }
}

konstanten_ausgeben()
{ Eintrag * ein;
  int i;
  ST * s = all_tables;
  while (s)
  { for (i = 0; i < TABELLENGROESSE; i++)
    { ein = s->Eintraege[i];
      while (ein)
      { if (ein->gueltig && (ein->Art == N_CONSTANT) && ein->param.Const->nr)
        { switch (ein->param.Const->Art)
          { case ST_CSTRING :
              if ((ein->param.Const->type != typ_string) &&
                  (ein->param.Const->type != typ_char))
                constant_ausgeben(ein->param.Const,1);
              break;
            case ST_CREAL :
            case ST_CPI :
            case ST_CNIL :
            case ST_CSET :
            case ST_CREC :
              constant_ausgeben(ein->param.Const,1);
              break;
          }
        }
        ein = ein->next;
      }
    }
    s = s->link;
  }
}

constant_ausgeben(c,m)
ST_CONST * c;
int m;
{ switch (c->Art)
  { case ST_CINT :
      fprintf(debug_file,"%d \"",m);
      fprintf(debug_file,"%d",c->wert.i);
      break;
    case ST_CELEM :
    case ST_CENUM :
      fprintf(debug_file,"%d \"",m);
      fprintf(debug_file,"%d",c->wert.range.val);
      break;
    case ST_CBOOL :
      fprintf(debug_file,"%d \"",m);
      fprintf(debug_file,"%d",c->wert.range.val);
      break;
    case ST_CEOL :
      fprintf(debug_file,"%d \"",m);
      fprintf(debug_file,"%d",'\n');
      break;
    case ST_CREAL :
    case ST_CPI :
      fprintf(debug_file,"%d \"",m);
#ifdef SUN
      if (c->wert.r != 0.0)
        fprintf(debug_file,"%#g",c->wert.r);
      else
        fprintf(debug_file,"0.0");
#else
        fprintf(debug_file,"%#g",c->wert.r);
#endif
      break;
    case ST_CSTRING :
      if (match_typen(c->type,typ_char,0))
      { fprintf(debug_file,"%d \"",m);
        fprintf(debug_file,"%d",*c->wert.s.string);
      }
      else
      { fprintf(debug_file,"%d \"",m+2);
        fprintf(debug_file,"%s",c->wert.s.string);
      }
      break;
    case ST_CSET :
      { int i;
        int t = c->type->used[ALL];
        int j = sizeof(unsigned) * 8;
        int l = 1;
        unsigned k, *z = c->wert.set.set;
        k = 1;
        fprintf(debug_file,"%d \"",m);
        for (i = 0; i < t;i++)
        { fprintf(debug_file,"%c",(*z & k) ? '1' : '0');
          k = k << 1;
          if ((l++ % j) == 0)
          { k = 1;
            z = &z[1];
          }
          if (((i % 50) == 49) && (l < t))
            fprintf(debug_file,"\n");
        }
      }
      break;
    case ST_CNIL :
      fprintf(debug_file,"%d \"",m);
      fprintf(debug_file,"NIL");
      break;
    case ST_CREC :
      c = c->wert.recConst;
      while (c)
      { if (c->link)
          constant_ausgeben(c,0);
        else
          constant_ausgeben(c,m);
        c = c->link;
      }
      return;
  }
  fprintf(debug_file,"\"\n");
}

int debug_member_count()
{ int c = 0;
  MEMBERS * m = all_members;
  while (m)
  { m->nummer = ++c;
    m = m->link;
  }
  return c;
}

symbols_ausgeben()
{ ST * s = all_tables;
  Eintrag * ein;
  int i;
  while (s)
  { for (i = 0; i < TABELLENGROESSE; i++)
    { ein = s->Eintraege[i];
      while (ein)
      { switch(ein->Art)
        { case N_SYSTEM :
            fprintf(debug_file,"1 %ld\n",ein->name_nr);
            break;
          case N_CONSTANT :
            if ((ein->param.Const->type != typ_string) &&
                (ein->param.Const->type != typ_char))
              fprintf(debug_file,"2 %ld %d ",ein->name_nr,ein->param.Const->type->nummer);
            else
              fprintf(debug_file,"2 %ld %d ",ein->name_nr,typ_char->nummer);
            { ST_CONST * c = ein->param.Const;
              switch (c->Art)
              { case ST_CINT :
                  fprintf(debug_file,"%d",c->wert.i);
                  break;
                case ST_CREAL :
                case ST_CPI :
                  fprintf(debug_file,"%d",c->nr);
                  break;
                case ST_CREC :
                  fprintf(debug_file,"%d",c->nr);
                  break;
                case ST_CSTRING :
                  fprintf(debug_file,"%d",((c->type != typ_string) &&
                                           (c->type != typ_char)) ? c->nr
                                                                  : c->wert.s.string[0]);
                  break;
                case ST_CELEM :
                case ST_CENUM :
                case ST_CBOOL :
                  fprintf(debug_file,"%d",c->wert.range.val);
                  break;
                case ST_CEOL :
                  fprintf(debug_file,"%d",'\n');
                  break;
                case ST_CSET :
                  fprintf(debug_file,"%d",c->nr);
                  break;
                case ST_CTYPDESC :
                  fprintf(debug_file,"TYPEDESC");
                  break;
                case ST_CNIL :
                  fprintf(debug_file,"%d",c->nr);
                  break;
              }
              fprintf(debug_file,"\n");
            }
            break;
          case N_TYPE :
            fprintf(debug_file,"3 %ld %d\n",ein->name_nr,ein->param.type->nummer);
            break;
          case N_CONFIGURATION :
            fprintf(debug_file,"4 %ld %d %d\n",ein->name_nr,ein->param.config.typ->nummer,
                                ein->param.config.first_PE);
            break;
          case N_SCALAR :
            fprintf(debug_file,"%ld %ld %d %d\n",5l + 64l * (long) ein->param.var.ebene,
                                ein->name_nr,ein->param.var.type->nummer,
                                ein->param.var.nummer);
            break;
          case N_VECTOR :
            fprintf(debug_file,"%ld %ld %d %d\n",6l + 64l * (long) ein->param.var.ebene,
                                ein->name_nr,ein->param.var.type->nummer,
                                ein->param.var.nummer);
            break;
          case N_SCALAR | N_VAR :
            fprintf(debug_file,"%ld %ld %d %d\n",37l + 64l * (long) ein->param.var.ebene,
                                ein->name_nr,ein->param.var.type->nummer,
                                ein->param.var.nummer);
            break;
          case N_VECTOR | N_VAR :
            fprintf(debug_file,"%ld %ld %d %d\n",38l + 64l * (long) ein->param.var.ebene,
                                ein->name_nr,ein->param.var.type->nummer,
                                ein->param.var.nummer);
            break;
          case N_PROCEDURE :
            if (s->Ebene >= 0)
              fprintf(debug_file,"7 %ld %d\n",
                                 ein->name_nr,ein->param.proz.scop->nummer);
            else
              fprintf(debug_file,"12 %ld\n",ein->name_nr);
            break;
          case N_IO :
            fprintf(debug_file,"8 %ld %d %d\n",ein->name_nr,
                                               ein->param.inout.port_typ->nummer,
                                               ein->param.inout.portnr);
            break;
          case N_INPUT :
            fprintf(debug_file,"9 %ld %d %d\n",ein->name_nr,
                                               ein->param.inout.port_typ->nummer,
                                               ein->param.inout.portnr);
            break;
          case N_OUTPUT :
            fprintf(debug_file,"10 %ld %d %d\n",ein->name_nr,
                                               ein->param.inout.port_typ->nummer,
                                               ein->param.inout.portnr);
            break;
          case N_IOK :
            fprintf(debug_file,"8 %ld %d %d\n",ein->name_nr,
                                           ein->param.inout.port_typ->nummer,
                                           ein->param.inout.portnr);
            break;
          case N_INPUTK :
            fprintf(debug_file,"9 %ld %d %d\n",ein->name_nr,
                                           ein->param.inout.port_typ->nummer,
                                           ein->param.inout.portnr);
            break;
          case N_OUTPUTK :
            fprintf(debug_file,"10 %ld %d %d\n",ein->name_nr,
                                           ein->param.inout.port_typ->nummer,
                                           ein->param.inout.portnr);
            break;
          case N_SPEZIAL_SKA :
            fprintf(debug_file,"13 %ld\n",ein->name_nr);
            break;
          case N_SPEZIAL_VEK :
            if (s->Ebene >= 0)
              fprintf(debug_file,"%ld %ld %d %d\n",6l + 64l * (long) ein->param.var.ebene,
                                ein->name_nr,typ_int->nummer,
                                ein->param.var.nummer);
            else
              fprintf(debug_file,"13 %ld\n",ein->name_nr);
            break;
          case N_STDFUNC :
            fprintf(debug_file,"11 %ld\n",ein->name_nr);
            break;
          default :
            fprintf(debug_file,"0 %ld\n",ein->name_nr);
            break;
        }   
        ein = ein->next;
      }
    }
    s = s->link;
  }
}

scopes_ausgeben()
{ SCOPE * s = all_scopes;
  while (s)
  { fprintf(debug_file,"%d %d %d %d %ld %d %d %d %d\n",
            s->st->startnr,s->st->anz,((s->super) ? s->super->nummer : 0),
            s->st->Ebene,((s->ein) ? s->ein->name_nr : 0l),s->parallel,s->von,
            s->entry,s->bis);
    s = s->link;
  }
}


lines_ausgeben()
{ LINENR * l = all_lines;
  while (l)
  { fprintf(debug_file,"%d %d %d\n",l->source,l->drain,l->next);
    l = l->link;
  }
}

typen_ausgeben()
{ ST_TYPE * t1 = typen_liste;
  while (t1)
  { if (t1->gueltig)
    { switch (t1->Art)
      { case ST_TUNDEF :
          fprintf(debug_file,"0 %ld\n",t1->name);
          break;
        case ST_TINT :
          fprintf(debug_file,"3 %ld\n",t1->name);
          break;
        case ST_TCHAR :
          fprintf(debug_file,"2 %ld\n",t1->name);
          break;
        case ST_TBOOL :
          fprintf(debug_file,"1 %ld\n",t1->name);
          break;
        case ST_TREAL :
          fprintf(debug_file,"4 %ld\n",t1->name);
          break;
        case ST_TARRAY :
          fprintf(debug_file,"6 %ld %d %d\n",t1->name,t1->info.array.bereich->nummer,
                             (t1->info.array.typ) ? t1->info.array.typ->nummer : 0);
          break;
        case ST_TRECORD :
        case ST_TRECORDREST :
          fprintf(debug_file,"7 %ld %d\n",t1->name,t1->info.record.mem->nummer);
          break;
        case ST_TSET :
          fprintf(debug_file,"9 %ld %d %d %d\n",t1->name,t1->info.range.super->nummer,
                                            t1->info.range.von,t1->info.range.bis);
          break;
        case ST_TRANGE :
          fprintf(debug_file,"12 %ld %d\n",t1->name,t1->info.range.mem->nummer);
          break;
        case ST_TSUBRANGE :
          fprintf(debug_file,"11 %ld %d %d %d\n",t1->name,t1->info.range.super->nummer,
                                             t1->info.range.von,t1->info.range.bis);
          break;
        case ST_TSARRAY :
          fprintf(debug_file,"5 %ld %d\n",t1->name,t1->info.array.bereich->nummer);
          break;
        case ST_TRANDOM :
          fprintf(debug_file,"0 %ld\n",t1->name);
          break;
        case ST_TID_NO :
          fprintf(debug_file,"3 %ld\n",t1->name);
          break;
        case ST_TDIM :
          fprintf(debug_file,"3 %ld\n",t1->name);
          break;
        case ST_TVARIANT :
          fprintf(debug_file,"8 %ld %d\n",t1->name,t1->info.record.mem->nummer);
          break;
        case ST_TPOINTER :
          fprintf(debug_file,"10 %ld %d\n",t1->name,t1->info.pointer.type->nummer);
          break;
        case ST_TNIL :
          fprintf(debug_file,"10 %ld 0\n",t1->name);
          break;
        case ST_TPORT :
          fprintf(debug_file,"13 0 %ld\n",t1->info.port.key);
          break;
        case ST_TPORTTYPE :
          fprintf(debug_file,"14 0 %ld %d %d\n",t1->info.port.key,
                                             t1->info.port.von,t1->info.port.bis);
          break;
      }
    }
    t1 = t1->liste;
  }
}


members_ausgeben()
{ MEMBERS * m = all_members;
  while (m)
  { fprintf(debug_file,"%ld %d %d\n",((m->ein) ? m->ein->name_nr : 0),
                                     ((m->art == 0) ? m->inh.wert : m->inh.typ->nummer),
                                     m->flag);
    m = m->link;
  }
}

