static char _sccsid[] = "Parallaxis Version: @(#)first.c	2.13  2/28/92 15:09:57";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : first.c                                                           */
/*                                                                           */
/* Funktionen, die den ersten Teil der semantischen Analyse ausf"uhren       */
/*                                                                           */
/* ************************************************************************* */


#include "pass2.h"
#include "procs.h"

extern int proz_anz;
extern int proc_mode, moment_group;
int conn_conf = 0;
int connect_err = 0;
int akt_mode;

semantics_analysis(s)
T_SYSTEM * s;
{ akt_mode = proc_mode;
  anal_first_pass(s->decl);
  pointer_adjust(typen_liste);
  portnummernvergabe(conf_groups);
}

pointer_adjust(t)
ST_TYPE * t;
{ while (t)
  { if (t->Art == ST_TPOINTER)
    { if (t->info.pointer.type == NULL)
        t->info.pointer.type = t->info.pointer.forw->param.type;
      if (t->info.pointer.type)
        t->gueltig = t->info.pointer.type->gueltig;
    }    
    t = t->liste;
  }
}
      

anal_first_pass(d)
T_DECLARATIONS * d;
{ if (d)
  { anal_first_pass(d->link);
    switch(d->select)
    { case N_CONFIGURATION :
        { int anz;
          do_config_anal(d->art.conf);
          anz = proz_zaehlen(conf_groups);
          proz_anz = (anz > proz_anz) ? anz : proz_anz;
          conn_conf = 1;
        }
        break;
      case N_INPUT :
        connect_pre_anal(d->art.conn);
        break;
      case N_CONSTANT :
        const_anal(d->art.Const);
        break;
      case N_TYPE :
        typ_anal(d->art.Type);
        break;
      case N_SCALAR :
        trage_varlist_ein(d->art.ska_var);
        break;
      case N_VECTOR :
        if ((akt_mode & CONF_DIR) && !conn_conf)
        { SEMERROR(d->Zeile,d->Posit,0,0,text[165]); /* neuer Text*/
        }
        trage_varlist_ein(d->art.vek_var);
        break;
      case N_PROCEDURE :
        proc_first(d->art.procs);
        break;
    }
  }
}

connect_pre_anal(c)
T_CONN * c;
{ if (conn_conf)
    trans_pre_anal(c->trans);
  else
  { SEMERROR(c->Zeile,c->Posit,0,0,text[166]); }
}

Eintrag * port_einhaengen(liste,ein)
Eintrag * liste, * ein;
{ Eintrag * e = liste;
  while (liste)
  { if (liste == ein)
      return e;
    if (liste->link)
      liste = liste->link;
    else
    { liste->link = ein;
      ein->link = NULL;
      return e;
    }
  }
  ein->link = NULL;
  return ein;
}

Eintrag * io_ident_anal(i)
T_IO_IDENT * i;
{ Eintrag * ein;
  int nr;
  if (i == NULL) return;
  ein = suche_Eintrag(i->ident->wert.ident_nr,vector_ST,GLOBAL,i->timestamp);
  if (i->Const)
  { if (i->Const->Art == INTCONSTANT)
      nr = i->Const->wert.i;
    else
    { Eintrag * e = suche_Eintrag(i->Const->wert.ident_nr,vector_ST,GLOBAL,i->timestamp);
      if (e)
      { if ((e->Art == N_CONSTANT) && e->param.Const &&
            (e->param.Const->Art == ST_CINT) && e->param.Const->gueltig)
        { nr = e->param.Const->wert.i;
        }
        else
        { SEMERROR(i->Const->Zeile,i->Const->Posit,e->Zeile,e->Posit, text[170]);
          connect_err = 1;
        }
      }
      else
      { SEMERROR(i->Const->Zeile,i->Const->Posit,0,0, text[171]);
        connect_err = 1;
      }
    }
    if (ein)
      switch (ein->Art)
      { case N_INPUTK :
        case N_OUTPUTK :
        case N_IOK :
          if (ein->param.inout.von > ein->param.inout.bis)
            ein->param.inout.von = ein->param.inout.bis = nr;
          else
          { if (nr > ein->param.inout.bis)
              ein->param.inout.bis = nr;
            if (nr < ein->param.inout.von)
              ein->param.inout.von = nr;
          }
          break;
        default :
          ein = NULL;
          connect_err = 1;
      }
  }
  else
    if (ein)
      switch (ein->Art)
      { case N_INPUT :
        case N_OUTPUT :
        case N_IO :
          break;
        default :
          ein = NULL;
          connect_err = 1;
      }
  if (ein)
  { switch (ein->Art)
    { case N_OUTPUT :
      case N_OUTPUTK :
        vector_ST->output = port_einhaengen(vector_ST->output,ein);
        break;
      case N_INPUT :
      case N_INPUTK :
        vector_ST->input = port_einhaengen(vector_ST->input,ein);
        break;
      case N_IO :
      case N_IOK :
        vector_ST->io = port_einhaengen(vector_ST->io,ein);
        break;
    }
  }
  return ein;
}

int configuration(e,i,a)
Eintrag * e;
SCAN_ELEM * i;
int a;
{ int ret = 0;
  Eintrag * ein = suche_Eintrag(i->wert.ident_nr,vector_ST,GLOBAL,0);
  if (ein)
  { switch (ein->Art)
    { case N_CONFIGURATION :
        if (a != ein->param.config.dim_anz)
        { if (a < ein->param.config.dim_anz)
          { SEMERROR(i->Zeile,i->Posit,0,0,text[274]);
            connect_err = 1;
          }
          else
          { SEMERROR(i->Zeile,i->Posit,0,0,text[275]);
            connect_err = 1;
          }
        }
        if (e)
        { if (e->param.inout.conf_nr > 0)
          { if (e->param.inout.conf_nr != ein->param.config.conf_nr)
            { SEMERROR(e->Zeile,e->Posit,i->Zeile,i->Posit,text[167]);
              connect_err = 1;
            }
            ret = e->param.inout.conf_nr;
          }
          else
          { ret = e->param.inout.conf_nr = ein->param.config.conf_nr;
            e->param.inout.conf_group = moment_group;
          }
        }
        break;
      case N_UNDEF :
      default :
        SEMERROR(i->Zeile,i->Posit,ein->Zeile,ein->Posit,text[124]);
        connect_err = 1;
    }
  }
  else
  { SEMERROR(i->Zeile,i->Posit,0,0,text[124]);
    connect_err = 1;
  }
  return ret;
}

trans_pre_anal(t)
T_TRANSFER * t;
{ if (t)
  { int i;
    Eintrag * e;
    trans_pre_anal(t->link);
    connect_err = 0;
    i = configuration(e = io_ident_anal(t->out_ident),t->conf_ident,
                 (t->sources) ? t->sources->count : 0);
    t->error = connect_err;
    if (dest_pre_anal(t->destinations,i))
      if (e)
        e->param.inout.intext = 1;
    
  }
}

int dest_pre_anal(d,m)
T_DESTINATION * d;
int m;
{ if (d)
  { int r,i,ce = connect_err;
    Eintrag * e;
    r = dest_pre_anal(d->link,m);
    connect_err = 0;
    i = configuration(e = io_ident_anal(d->in_ident),d->conf_ident,
                  (d->exprlist) ? d->exprlist->count : 0);    
    if (i != m)
    { if (e)
        e->param.inout.intext = 1;
      r = 1;
    }
    d->error = connect_err;
    connect_err = ce;
    return r;
  }
  return 0;
}


proc_first(p)
T_PROCEDECL * p;
{ Eintrag * prozname;
  ST * st = akt_ST;
  ST * vector = vector_ST;
  C_GROUP * g = conf_groups;
  VARNODE * var;
  int a_mode = akt_mode;
  int c_conf = conn_conf;
  info_proc = 0;
  akt_mode = p->proc_mode;
  conn_conf = 0;
  conf_groups = p->confs;
  if (prozname = suche_Eintrag(p->ident->wert.ident_nr,vector_ST,GLOBAL,0))
  { ST * t;
    vector_ST = akt_ST = p->ST;
    t = akt_ST->Obertabelle;
    if (t && t->is_vector)
    { t = t->Obertabelle->others;
      akt_ST->Obertabelle = t;
    }
    hvarsvect = akt_ST->hvarsvect;
    hvarsscal = akt_ST->hvarsscal;
    setze_parameter(prozname,p->paramseq);
    prozname->param.proz.info = info_proc;
    akt_ST->hvarsvect = hvarsvect;
    akt_ST->hvarsscal = hvarsscal;
  }
  else
  { ST * t;
    vector_ST = akt_ST = p->ST;
    t = akt_ST->Obertabelle;
    if (t && t->is_vector)
    { t = t->Obertabelle->others;
      akt_ST->Obertabelle = t;
    }
    hvarsvect = akt_ST->hvarsvect;
    hvarsscal = akt_ST->hvarsscal;
    trage_param_ein(p->paramseq);
    akt_ST->hvarsvect = hvarsvect;
    akt_ST->hvarsscal = hvarsscal;
  }
  if (p->type)
  { set_typlist(p->type,FREE);
    if (p->type != NULL)
    { int hi;
      Eintrag * ein;
      if (prozname)
      { prozname->param.proz.scavec = (p->scavec->Art == _SCALAR) ? 0 : 1;
        prozname->param.proz.info |= (p->scavec->Art == _SCALAR) ? 0 : 16;
        prozname->param.proz.complex =
        p->complex = ((ist_einfacher_typ(prozname->param.proz.result =
                                         p->type->erg_typ) == JA) &&
                      (prozname->param.proz.scavec != 0)) ? 0 : 1;
        GET_MEM(var,1,VARNODE);
        
        var->ein = ein = suche_Eintrag(0l,vector_ST,GLOBAL,0);
	var->scavec = (p->scavec->Art == _SCALAR) ? 0 : 1;
     	if (ein && p->complex)
	  ein->Art |= N_VAR;
      }
      else
      { p->complex = (ist_einfacher_typ(prozname->param.proz.result =
                                         p->type->erg_typ) == JA) ? 0 : 1;
        GET_MEM(var,1,VARNODE);
        
        var->ein = ein = mache_Eintrag(0l,&dummy,
                          ((p->complex) ? N_VAR : 0) |
                          (((var->scavec = ((p->scavec->Art == _SCALAR) ? 0 : 1)) == 0)
                                         ? N_SCALAR
                                         : N_VECTOR));
      }

      var->link = p->hv;
      ein->param.var.type = p->type->erg_typ;
      ein->param.var.used = 1;
      ein->param.var.art = hi = var->firstelem = p->type->erg_typ->firstelem;
      hi = (p->complex) ? INTEGER : hi;
      switch (var->scavec)
      { case 0 :
          ein->param.var.nummer = ++(akt_ST->ControlVarAnz[hi]);
          akt_ST->ControlVarAnz[ALL]++;
          ein->param.var.dir_indir = INDIRECT;
          break;
        default :
          ein->param.var.nummer = ++(akt_ST->LocalVarAnz[hi]);
          akt_ST->LocalVarAnz[ALL]++;
          ein->param.var.dir_indir = (p->complex) ? INDIRECT : DIRECT;
          break;
      }
      ein->gueltig = p->type->erg_typ->gueltig;
      if (prozname)
        prozname->gueltig = 1;
      p->hv = var;
      p->zeilen++;
    }
    else
    { if (prozname)
        prozname->param.proz.result = NULL;
      p->complex = 1;
    }
  }
  else
  { if (prozname)
      prozname->param.proz.result = NULL;
    p->complex = 1;
  }
  anal_first_pass(p->decls);
  portnummernvergabe(conf_groups);
  akt_ST = st;
  vector_ST = vector;
  conf_groups = g;
  akt_mode = a_mode;
  conn_conf = c_conf;
}

ST_CONST * set_Constlist();

const_anal(c)
T_CONSTDECL * c;
{ Eintrag * rueck;
  SCAN_ELEM * name;

  if (c)
  { const_anal(c->link);
    if ((name = c->ident) != NULL)
    { rueck = suche_Eintrag(name->wert.ident_nr,vector_ST,GLOBAL,0);
      if (rueck->Art == N_CONSTANT)
      { /* Konstantendefinition ermitteln und eintragen */
        if (rueck->param.Const = set_Constlist(c->Constant))
        { rueck->gueltig = rueck->ST_CGUELT;
          rueck->param.Const->name = rueck->name_nr;
        }
      }
    }
  }
}

/* ************************************************************************* */
/* erzeuge konstante Struktur aus einer Liste von Ausdruecken                */
/*                                                                           */
/* Ergebnis : konstante Struktur                                             */
/*                                                                           */
/* Parameter : Liste von Ausdruecken                                         */
/*                                                                           */
/* ************************************************************************* */

ST_CONST * set_Constlist(coz)
T_EXPR * coz;
{ ST_CONST * Const, * succ, * c;
  if (coz != NULL)
  { if (coz->link != NULL)
    { succ = set_Constlist(coz->link); }
    else
    { succ = NULL; }
    expr_auswerten(coz,1);
    if ((coz->erg_art == ERG_CONST) && (coz->erg.Const->Art != ST_CTYPDESC))
    { Const = coz->erg.Const; }
    else
    { if (coz->error == 0)
      { SEMERROR(coz->Zeile,coz->Posit,0,0,text[206]);
        interpreter = coz->error =1;
      }
      Const = NULL;
    }
    if (Const == NULL)
    { return succ; }
    GET_MEM(c,1,ST_CONST);
    *c = *Const;
    c->link = succ;
    c->type = coz->erg_typ;
    if (succ != NULL)
    { c->gueltig *= succ->gueltig; }
    return c;
  }
  return NULL;
}


