static char _sccsid[] = "Parallaxis Version: @(#)main.c	2.13  2/28/92 15:09:59";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : main.c                                                            */
/*                                                                           */
/* Steuer- und Verwaltungsteil des Compilers                                 */
/*                                                                           */
/* ************************************************************************* */

#include "defines.h"
#include "typen.h"
#include "y_tab.h"
#include "symbols.h"
#include "makro2.h"
extern int yylineno;

extern T_SYSTEM * programm;

extern ST * all_tables;

T_RECDEF * silly;     /* wird fuer leere Strukturen als Beschreibung verwendet */

/* jeweils oberste Symboltabelle */
ST * akt_ST, * vector_ST;

/* Zeiger auf ausgezeichnete Eintraege */
Eintrag * integer_eintr,
        * cardinal_eintr,
        * bitset_eintr;

                    
int MAXINTEGER;
float C_PI;
extern double acos();

ST_TYPE * typ_error, * typ_int, * typ_char, * typ_real, * typ_bool,
        * typ_card, * typ_string, * typ_bitset,
        * typ_dim, * typ_nil;

ST_CONST * Const_false;

FILE * ausDatei;
char * d_name;       /* Name der Ausgabedatei */
char * debug_name;   /* Name der Cross-Reference-Datei */
extern FILE *yyin;
int listingausgeben = 0;
int error_max_count = 0;
int warn_max_count = -1;
int range_test = 1;
#ifdef DEVELOP
int verbose_flag = 1;
#else
int verbose_flag = 0;
#endif
int debug_trace_flag = 1;
int uppercase_flag = 1;
int reusevar = 1;
int pipeline = 0;
#ifdef MAC
int debugging = 1;
#else
int debugging = 0;
#endif

long max_nr, min_nr;
int divisionstest = 1;
int nil_pointertest = 1;
#ifdef DEBUG
int no_internal = 0;
#endif
char * listname = NULL;
char * infile = NULL;
FILE * listfile = NULL;
char the_filename[270];

ST_TYPE * typen_liste;

extern char *getenv();
extern FILE * popen();


/* ************************************************************************* */
/* ermittle den Namen des zu uebersetztenden Parallaxisprogramms             */
/*                                                                           */
/* Ergebnis : Dateideskriptor                                                */
/*                                                                           */
/* Parameter : eingegebener Name                                             */
/*                                                                           */
/* ************************************************************************* */

FILE * parallaxistry(fn)
char *fn;
{ register FILE *erg;
  char * hfn;
  strcpy(the_filename, fn);
  if (strcmp(hfn = fn + my_strlen(fn) - 2, ".p") == 0)
  { *hfn = '\0'; }
  else
  { if (strcmp(hfn = fn + my_strlen(fn) - 5, ".para") == 0)
    { *hfn = '\0'; }
    else
    { if (strcmp(hfn = fn + my_strlen(fn) - 4, ".pre") == 0)
      { *hfn = '\0';
      }
      else
      { *the_filename = '\0'; }
    }
  }
  if (*the_filename == '\0')
  { strcpy(the_filename, fn);
    strcat(the_filename, ".p");
    if (!(erg = fopen(the_filename, "r")))
    { strcpy(the_filename, fn);
      strcat(the_filename, ".para");
      if (!(erg = fopen(the_filename, "r")))
      { strcpy(the_filename, fn);
        strcat(the_filename, ".pre");
        if (!(erg = fopen(the_filename, "r")))
        { strcpy(the_filename, fn);
          erg = fopen(the_filename, "r");
        }
      }
    }
  }
  else
  { erg = fopen(the_filename, "r"); }
  if (erg) fclose(erg);
  return erg;
}

/* ************************************************************************* */
/* zeige die Verwendungshinweise des Compilers an                            */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter :                                                               */
/*                                                                           */
/* ************************************************************************* */

hilfe_anzeigen()
{ fprintf(stderr,"\n%s",text[97]);
  fprintf(stderr,text[0]);
  fprintf(stderr,text[1]);
  fprintf(stderr,text[2]);
  fprintf(stderr,text[5]);
  fprintf(stderr,text[6]);
  fprintf(stderr,text[7]);
  fprintf(stderr,text[8]);
  fprintf(stderr,text[9]);
  fprintf(stderr,text[10]);
  fprintf(stderr,text[11]);
  fprintf(stderr,text[12]);
  fprintf(stderr,text[13]);
  fprintf(stderr,text[14]);
  fprintf(stderr,text[15]);
  fprintf(stderr,text[16]);
  fprintf(stderr,text[17]);
  fprintf(stderr,text[18]);
}

/* ************************************************************************* */
/* Analysiere die Argumente des Compileraufrufs                              */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Anzahl der Parameter                                          */
/*             Feld der Parameterstrings                                     */
/*                                                                           */
/* ************************************************************************* */

arg_anal(argc,argv)
int argc;
char ** argv;
{ int arg_fehler = 0;
  if (argc-- > 1)
  { argv++;
    while (argc && (argv[0][0] == '-'))
    { arg_fehler |= do_options(&argv[0][1]);
      argv++; argc--;
    }
    if (argc-- > 0)
    { infile = argv[0];
      argv++;  
      if ((argc == 2) && (argv[0][0] == '-') &&
          ((argv[0][1] == 'o') || (argv[0][1] == 'O')) &&
          (argv[0][2] == '\0'))
      { d_name = argv[1]; }
      else
      { if (argc > 0)
        { fprintf(stderr,text[25],argv[0]);
          arg_fehler = 1;
        }
      }
    }
  }
  else
  { hilfe_anzeigen();
    my_exit(1);
  }
  if (pipeline)
  { if (infile != NULL)
    { fprintf(stderr,text[25],infile);
      hilfe_anzeigen();
      my_exit(1);
    }
    if (listname == NULL)
      listingausgeben = 0;
  }
  else
  { if (infile == NULL)
    { fprintf(stderr,text[26]);
      hilfe_anzeigen();
      my_exit(1);
    }
  }
  if (arg_fehler)
  { fprintf(stderr,text[27]);
    hilfe_anzeigen();
    my_exit(1);
  }
  if (error_max_count <= 0)
  { error_max_count = ERROR_MAX_COUNT; }
  if (warn_max_count < 0)
  { warn_max_count = WARN_MAX_COUNT; }
}

/* ************************************************************************* */
/* Analysiere einen Argumentestring                                          */
/*                                                                           */
/* Ergebnis : 0 kein Fehler ist aufgetreten, 1 Argumentfehler                */
/*                                                                           */
/* Parameter : Argumentestring                                               */
/*                                                                           */
/* ************************************************************************* */

int do_options(s)
char * s;
{ int arg_fehler = 0;
  if (*s == '\0')
  { fprintf(stderr,text[28]);
    arg_fehler = 1;
  }
  while (*s != '\0')
  { switch (*s++)
    { case 'd' :
      case 'D' :
        debug_trace_flag = 0;
        break;
      case 'e' :
      case 'E' :
        { char c = *s;
          if ((c < '0') || (c > '9'))
          { arg_fehler = 1; }
          else
          { error_max_count = c - '0';
            c = *(++s);
            while ((c >= '0') && (c <= '9'))
            { error_max_count *= 10;
              error_max_count += c -'0';
              c = *(++s);
            }
          }
        }
        break;
      case 'l' :
      case 'L' :
        listingausgeben = 1;
        break;
      case 'h' :
      case 'H' :
        reusevar = 0;
        break;
      case 'm' :
      case 'M' :
        divisionstest = 0;
        break;
      case 'n' :
      case 'N' :
        nil_pointertest = 0;
        break;
      case 'p' :
      case 'P' :
        pipeline = 1;
        break;
      case 'r' :
      case 'R' :
        range_test = 0;
        break;
      case 'u' :
      case 'U' :
        uppercase_flag = 0;
        break;
      case 'v' :
      case 'V' :
#ifdef DEVELOP
        verbose_flag = 0;
#else
        verbose_flag = 1;
#endif
        break;
      case 'w' :
      case 'W' :
        { char c = *s;
          if ((c < '0') || (c > '9'))
          { arg_fehler = 1; }
          else
          {warn_max_count = c - '0';
            c = *(++s);
            while ((c >= '0') && (c <= '9'))
            { warn_max_count *= 10;
              warn_max_count += c -'0';
              c = *(++s);
            }
          }
        }
        break;
      case 'x' :
      case 'X' :
#ifdef MAC
        debugging = 0;
#else
        debugging = 1;
#endif
        break;
#ifdef DEBUG  
      case 'i' :
      case 'I' :
        no_internal = 1;
        break;
#endif
      default :
        fprintf(stderr,text[29],s[-1]);
        arg_fehler = 1;
    }
  }
  return arg_fehler;
}

/* ************************************************************************* */
/* Programmeinstieg                                                          */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Anzahl der Parameter                                          */
/*             Feld der Parameterstrings                                     */
/*                                                                           */
/* ************************************************************************* */

#ifdef MAC
#include <setjmp.h>
jmp_buf env;
main2(argc,argv)
#else
main(argc,argv)
#endif
int argc;
char *argv[];
{ int fehler_warn = 0;
  ST * haupt;

#ifdef MAC
  int exit_code;
  if (exit_code = setjmp(env))
    goto exitmain;
#endif
  arg_anal(argc,argv);
  if (verbose_flag)
    fprintf(stderr,text[40]);
      /* Definition der groessten positiven Zahl (fuer Cardinal) */
#ifndef CRAY
  MAXINTEGER = (sizeof(int) == 2) ? 0x7fff : 0x7fffffff;
#else
  MAXINTEGER = 0x7fffffffffffffff;
#endif
  C_PI = 2.0 * acos(0.0);
  if (pipeline)
  { yyin = stdin;
    if (debugging)
      debug_name = "$xrf";
  }
  else
  { if (parallaxistry(infile))
    { if (verbose_flag)
        fprintf(stderr,text[47],the_filename);
    }
    else
    { fprintf(stderr,text[30],infile);
      my_exit(2);
    }
    if (d_name == NULL)
    { GET_MEM(d_name,my_strlen(infile) + 3,char);
      strcpy(d_name,infile);
      d_name = strcat(d_name,".z");
    }
    if (verbose_flag)
      fprintf(stderr,text[48],d_name);
    if (debugging)
    { int  l;
      l = my_strlen(d_name);
      GET_MEM(debug_name,l + 5,char);
      if ((d_name[l-2] == '.') && (d_name[l-1] == 'z'))
      { strcpy(debug_name,d_name);
        strcpy(&debug_name[l-1],"xrf");
      }
      else
      { strcpy(debug_name,d_name);
        strcpy(&debug_name[l],".xrf");
      }
      if (verbose_flag)
        fprintf(stderr,"xrf-File : %s\n",debug_name);
    }
  }
  if (!pipeline)
    yyin = fopen(the_filename,"r");
  all_tables = NULL;
  vector_ST = akt_ST = neue_ST(NULL,-1);
  keywords();
  init_ST();
  haupt = vector_ST = akt_ST = neue_ST(akt_ST,1);
  GET_MEM(silly,1,T_RECDEF);
  if (verbose_flag)
    fprintf(stderr,text[41]);
  yyparse();
  if ((programm != NULL) && (no_char_read == 0))
  { if (verbose_flag)
      fprintf(stderr,text[45]);
    semantics_analysis(programm);
    if (verbose_flag)
      fprintf(stderr,text[42]);
    pass2(programm,haupt);
  }
  else
  { fprintf(stderr,text[31]);
    if (no_char_read)
      yywarning = yynerrs = 0;
    no_char_read = 1;
  }
  if ((yynerrs == 0) &&  debugging)
    debug_out();

  if (yynerrs > 0)
  { fprintf(stderr,text[33]);
    if (yynerrs == 1)
      fprintf(stderr,text[38]);
    else
      fprintf(stderr,text[35],yynerrs);
    fehler_warn = 1;
  }
  if (yywarning > 0)
  { if (fehler_warn)
    { fprintf(stderr,text[36]); }
    else
    { fprintf(stderr,text[33]); }
    if (yywarning == 1)
      fprintf(stderr,text[37]);
    else
      fprintf(stderr,text[34],yywarning);
    fehler_warn = 1;
  }
  if (fehler_warn)
    fprintf(stderr,".\n");
  if ((no_char_read == 0) && (listingausgeben /*|| (yynerrs && (pipeline == 0))*/) &&
      verbose_flag)
    fprintf(stderr,text[44]);
  listing(d_name,listname/*,yynerrs*/);
#ifdef DEBUG
  if (no_internal)
    ausgeben(haupt);
#endif
  if (no_char_read || yynerrs)
    my_exit(1);
  my_exit(0);
exitmain: ;
}
#ifdef MAC
my_exit(i)
int i;
{ longjmp(env,i+1); }
#endif

/* ************************************************************************* */
/* trage alle vordefinierten Namen in die Basissymboltabelle ein             */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter :                                                               */
/*                                                                           */
/* ************************************************************************* */

init_ST()
{ int dummy;
  Eintrag * rueck;
  ST_PARAM * par1, * par2;
  long nr;
  int art;
  ST_CONST * c;


  /* Standarddatentypen */
  art = IDENT; enterstring("INTEGER",&nr,&art);
  integer_eintr = rueck = mache_Eintrag(nr, &dummy, N_TYPE);
  GET_MEM(typ_int, 1,ST_TYPE);
  typ_int->liste = typen_liste;
  typen_liste = typ_int;
  rueck->param.type = typ_int;
  typ_int->name = nr;
  rueck->ST_TSEL = ST_TINT;
  rueck->ST_TUSED(INTEGER) = rueck->ST_TUSED(ALL) = 1;
  rueck->ST_TFIRST = INTEGER;
  rueck->gueltig = rueck->ST_TGUELT = 1;

  art = IDENT; enterstring("BOOLEAN",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_TYPE);
  GET_MEM(typ_bool, 1,ST_TYPE);
  typ_bool->liste = typen_liste;
  typen_liste = typ_bool;
  typ_bool->name = nr;
  rueck->param.type = typ_bool;
  rueck->ST_TSEL = ST_TBOOL;
  rueck->ST_TUSED(BOOLEAN) = rueck->ST_TUSED(ALL) = 1;
  rueck->gueltig = rueck->ST_TGUELT = 1;
  rueck->ST_TFIRST = BOOLEAN;
  rueck->ST_TRVON = rueck->ST_TRBASIS = 0;
  rueck->ST_TRBIS = 1;

  art = IDENT; enterstring("CHAR",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_TYPE);
  GET_MEM(typ_char, 1,ST_TYPE);
  typ_char->liste = typen_liste;
  typen_liste = typ_char;
  typ_char->name = nr;
  rueck->param.type = typ_char;
  rueck->ST_TSEL = ST_TCHAR;
  rueck->ST_TUSED(CHAR) = rueck->ST_TUSED(ALL) = 1;
  rueck->gueltig = rueck->ST_TGUELT = 1;
  rueck->ST_TFIRST = CHAR;

  art = IDENT; enterstring("CARDINAL",&nr,&art);
  cardinal_eintr = rueck = mache_Eintrag(nr, &dummy, N_TYPE);
  GET_MEM(typ_card, 1,ST_TYPE);
  typ_card->liste = typen_liste;
  typen_liste = typ_card;
  typ_card->name = nr;
  rueck->param.type = typ_card;
  rueck->ST_TSEL = ST_TSUBRANGE;
  rueck->ST_TRVON = rueck->ST_TRBASIS = 0;
  rueck->ST_TRBIS = MAXINTEGER;
  rueck->ST_TUSED(INTEGER) = rueck->ST_TUSED(ALL) = 1;
  rueck->gueltig = rueck->ST_TGUELT = 1;
  rueck->ST_TFIRST = INTEGER;
  rueck->ST_TRSUPER = typ_int;

  art = IDENT; enterstring("REAL",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_TYPE);
  GET_MEM(typ_real, 1,ST_TYPE);
  typ_real->liste = typen_liste;
  typen_liste = typ_real;
  typ_real->name = nr;
  rueck->param.type = typ_real;
  rueck->ST_TSEL = ST_TREAL;
  rueck->ST_TUSED(REAL) = rueck->ST_TUSED(ALL) = 1;
  rueck->gueltig = rueck->ST_TGUELT = 1;
  rueck->ST_TFIRST = REAL;

  GET_MEM(typ_string, 1,ST_TYPE);
/*  typ_string->liste = typen_liste;
  typen_liste = typ_string;*/
  typ_string->Art = ST_TARRAY;
  typ_string->used[CHAR] = typ_string->used[ALL] = 2;
  typ_string->firstelem = CHAR;
  typ_string->gueltig = 1;
/*  GET_MEM(typ_dim, 1,ST_TYPE);
  typ_dim->liste = typen_liste;
  typen_liste = typ_dim;
  typ_dim->Art = ST_TSUBRANGE;
  typ_dim->info.range.von = 0;
  typ_dim->info.range.bis = 1;
  typ_dim->used[ALL] = typ_dim->used[INTEGER] = 1;
  typ_dim->gueltig = 1;
  typ_dim->firstelem = INTEGER;
  typ_dim->info.range.super = typ_int;
  typ_string->info.array.bereich = typ_dim;*/
  typ_string->info.array.bereich = typ_card;
  typ_string->info.array.typ = typ_char;
  
  GET_MEM(typ_dim, 1,ST_TYPE);
  typ_dim->Art = ST_TDIM;
  typ_dim->used[INTEGER] = typ_dim->used[ALL] = 1;
  typ_dim->firstelem = INTEGER;
  typ_dim->gueltig = 1;

  art = IDENT; enterstring("BITSET",&nr,&art);
  bitset_eintr = rueck = mache_Eintrag(nr, &dummy, N_TYPE);
  GET_MEM(typ_bitset, 1,ST_TYPE);
  typ_bitset->liste = typen_liste;
  typen_liste = typ_bitset;
  typ_bitset->name = nr;
  rueck->param.type = typ_bitset;
  rueck->ST_TSEL = ST_TSET;
  rueck->ST_TRVON = rueck->ST_TRBASIS = 0;
  rueck->ST_TRBIS = BITSET_MAXIMUM - 1;
  rueck->ST_TUSED(BOOLEAN) = rueck->ST_TUSED(ALL) = BITSET_MAXIMUM;
  rueck->ST_TFIRST = BOOLEAN;
  GET_MEM(typ_error, 1,ST_TYPE);
  typ_error->liste = typen_liste;
  typen_liste = typ_error;
  typ_error->Art = ST_TSUBRANGE;
  typ_error->info.range.von = 0;
  typ_error->info.range.bis = BITSET_MAXIMUM -1;
  typ_error->used[INTEGER] = typ_error->used[ALL] = 1;
  typ_error->gueltig = 1;
  typ_error->firstelem = INTEGER;
  typ_error->info.range.super = typ_int;
  rueck->ST_TRSUPER = typ_error;
  rueck->gueltig = rueck->ST_TGUELT = 1;

  GET_MEM(typ_error, 1,ST_TYPE);
  typ_error->liste = typen_liste;
  typen_liste = typ_error;
  typ_error->Art = ST_TUNDEF;
  typ_error->gueltig = 0;

  /* Standardfunktionen */

  art = IDENT; enterstring("ABS",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_ABS;
  rueck->gueltig = 1;

  art = IDENT; enterstring("CAP",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_CAP;
  rueck->gueltig = 1;

  art = IDENT; enterstring("CHR",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_CHR;
  rueck->gueltig = 1;

  art = IDENT; enterstring("EVEN",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_EVEN;
  rueck->gueltig = 1;

  art = IDENT; enterstring("FLOAT",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_FLOAT;
  rueck->gueltig = 1;

  art = IDENT; enterstring("MAX",&max_nr,&art);
  rueck = mache_Eintrag(max_nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_MAX;
  rueck->gueltig = 1;

  art = IDENT; enterstring("MIN",&min_nr,&art);
  rueck = mache_Eintrag(min_nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_MIN;
  rueck->gueltig = 1;

  art = IDENT; enterstring("ODD",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_ODD;
  rueck->gueltig = 1;

  art = IDENT; enterstring("ORD",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_ORD;
  rueck->gueltig = 1;

  art = IDENT; enterstring("SIZE",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_SIZE;
  rueck->gueltig = 1;

  art = IDENT; enterstring("TRUNC",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_TRUNC;
  rueck->gueltig = 1;

  art = IDENT; enterstring("VAL",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_VAL;
  rueck->gueltig = 1;

  art = IDENT; enterstring("STRCMP",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_STRCMP;
  rueck->gueltig = 1;

  art = IDENT; enterstring("STREQ",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_STREQ;
  rueck->gueltig = 1;

  art = IDENT; enterstring("SIRandom",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_SIRANDOM;
  rueck->gueltig = 1;

  art = IDENT; enterstring("SRRandom",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_SRRANDOM;
  rueck->gueltig = 1;

  art = IDENT; enterstring("SCRandom",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_SCRANDOM;
  rueck->gueltig = 1;

  art = IDENT; enterstring("SBRandom",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_SBRANDOM;
  rueck->gueltig = 1;

  art = IDENT; enterstring("VIRandom",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_VIRANDOM;
  rueck->gueltig = 1;

  art = IDENT; enterstring("VRRandom",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_VRRANDOM;
  rueck->gueltig = 1;

  art = IDENT; enterstring("VCRandom",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_VCRANDOM;
  rueck->gueltig = 1;

  art = IDENT; enterstring("VBRandom",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_VBRANDOM;
  rueck->gueltig = 1;

  art = IDENT; enterstring("IN_Connected",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_INCONN;
  rueck->gueltig = 1;

  art = IDENT; enterstring("OUT_Connected",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_OUTCONN;
  rueck->gueltig = 1;

  art = IDENT; enterstring("IN_Lineconnected",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_INLINECON;
  rueck->gueltig = 1;

  art = IDENT; enterstring("OUT_Lineconnected",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_OUTLINECON;
  rueck->gueltig = 1;

  art = IDENT; enterstring("ArcCos",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_ARCCOS;
  rueck->gueltig = 1;

  art = IDENT; enterstring("ArcSin",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_ARCSIN;
  rueck->gueltig = 1;

  art = IDENT; enterstring("ArcTan",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_ARCTAN;
  rueck->gueltig = 1;

  art = IDENT; enterstring("ArcTan2",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_ARCTAN2;
  rueck->gueltig = 1;

  art = IDENT; enterstring("Cos",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_COS;
  rueck->gueltig = 1;

  art = IDENT; enterstring("Exp",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_EXP;
  rueck->gueltig = 1;

  art = IDENT; enterstring("Ln",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_LN;
  rueck->gueltig = 1;

  art = IDENT; enterstring("Sin",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_SIN;
  rueck->gueltig = 1;

  art = IDENT; enterstring("Sqrt",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_SQRT;
  rueck->gueltig = 1;

  art = IDENT; enterstring("Tan",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_TAN;
  rueck->gueltig = 1;

  art = IDENT; enterstring("OpenWindow",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_OPENWINDOW;
  rueck->gueltig = 1;

  art = IDENT; enterstring("OpenAbsWindow",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_OPENABSWINDOW;
  rueck->gueltig = 1;

  art = IDENT; enterstring("GetPixel",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_GETPIXEL;
  rueck->gueltig = 1;


  /* Standardkonstanten */

  art = IDENT; enterstring("id_no",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_SPEZIAL_VEK);
  akt_ST->dim = NULL;
  GET_MEM(rueck->param.var.type,1,ST_TYPE);
/*  rueck->param.var.type->liste = typen_liste;
  typen_liste = rueck->param.var.type;*/
  rueck->param.var.type->Art = ST_TID_NO;
  rueck->param.var.type->link = NULL;
  rueck->param.var.type->used[INTEGER] = rueck->param.var.type->used[ALL] = 1;
  rueck->gueltig = rueck->param.var.type->gueltig = 1;
  rueck->param.var.type->firstelem = INTEGER;
  rueck->param.var.nummer = -1;
  rueck->param.var.dir_indir = DIRECT;
  rueck->param.var.art = INTEGER;

  art = IDENT; enterstring("termCH",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_SPEZIAL_SKA);
  rueck->param.var.type = typ_char;
  rueck->gueltig = 1;
  rueck->param.var.dir_indir = DIRECT;
  rueck->param.var.art = CHAR;

  art = IDENT; enterstring("Done",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_SPEZIAL_SKA);
  rueck->param.var.type = typ_bool;
  rueck->gueltig = 1;
  rueck->param.var.dir_indir = DIRECT;
  rueck->param.var.art = BOOLEAN;

  art = IDENT; enterstring("TRUE",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_CONSTANT);
  GET_MEM(rueck->param.Const,1,ST_CONST);
  rueck->ST_CSEL = ST_CBOOL;
  rueck->ST_CTYP = typ_bool;
  rueck->ST_CLINK = NULL;
  rueck->ST_CRVON = 0;
  rueck->ST_CRVAL = rueck->ST_CRBIS = 1;
  rueck->gueltig = rueck->ST_CGUELT = 1;

  art = IDENT; enterstring("FALSE",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_CONSTANT);
  GET_MEM(Const_false,1,ST_CONST);
  rueck->param.Const= Const_false;
  rueck->ST_CSEL = ST_CBOOL;
  rueck->ST_CTYP = typ_bool;
  rueck->ST_CLINK = NULL;
  rueck->ST_CRVAL = rueck->ST_CRVON = 0;
  rueck->ST_CRBIS = 1;
  rueck->gueltig = rueck->ST_CGUELT = 1;

  art = IDENT; enterstring("EOL",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_CONSTANT);
  GET_MEM(rueck->param.Const,1,ST_CONST);
  rueck->ST_CSEL = ST_CEOL;
  rueck->ST_CTYP = typ_char;
  rueck->ST_CLINK = NULL;
  rueck->gueltig = rueck->ST_CGUELT = 1;

  art = IDENT; enterstring("PI",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_CONSTANT);
  GET_MEM(rueck->param.Const,1,ST_CONST);
  rueck->ST_CSEL = ST_CPI;
  rueck->ST_CTYP = typ_real;
  rueck->ST_CLINK = NULL;
  rueck->gueltig = rueck->ST_CGUELT = 1;
  rueck->ST_CGREAL = C_PI;

  art = IDENT; enterstring("NIL",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_CONSTANT);
  GET_MEM(typ_nil,1,ST_TYPE);
  typ_nil->liste = typen_liste;
  typen_liste = typ_nil;
  typ_nil->name = nr;
  typ_nil->Art = ST_TNIL;
  typ_nil->link = NULL;
  typ_nil->used[INTEGER] = typ_nil->used[ALL] = 1;
  GET_MEM(c,1,ST_CONST);
  rueck->param.Const = c;
  c->Art = ST_CNIL;
  c->type = typ_nil;
  rueck->ST_CLINK = NULL;
  rueck->gueltig = typ_nil->gueltig = c->gueltig = 1;


  /* Standard-REDUCE-Funktionen */

  art = IDENT; enterstring("FIRST",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_FIRST;
  rueck->gueltig = 1;

  art = IDENT; enterstring("LAST",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_LAST;
  rueck->gueltig = 1;

  art = IDENT; enterstring("SUM",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->param.proz.posnr = PROC_SUM;
  rueck->gueltig = 1;

  art = IDENT; enterstring("PRODUCT",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_STDFUNC);
  rueck->gueltig = 1;
  rueck->param.proz.posnr = PROC_PRODUCT;

  /* Standardprozeduren */

  art = IDENT; enterstring("DEC",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_DEC;
  rueck->gueltig = 1;

  art = IDENT; enterstring("DISPOSE",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_DISPOSE;
  rueck->gueltig = 1;

  art = IDENT; enterstring("EXCL",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_EXCL;
  rueck->gueltig = 1;

  art = IDENT; enterstring("INC",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_INC;
  rueck->gueltig = 1;

  art = IDENT; enterstring("INCL",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_INCL;
  rueck->gueltig = 1;

  art = IDENT; enterstring("NEW",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_NEW;
  rueck->gueltig = 1;

  art = IDENT; enterstring("Write",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_WRITE;
  rueck->param.proz.result = NULL;
  GET_MEM(par1,1,ST_PARAM);
  par1->mode = N_SCALAR;
  par1->anzahl = 1;
  par1->type = typ_char;
  rueck->param.proz.param = par1;
  rueck->gueltig = 1;

  art = IDENT; enterstring("WriteString",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_WRITESTRING;
  rueck->param.proz.result = NULL;
  GET_MEM(par1,1,ST_PARAM);
  par1->mode = N_SCALAR;
  par1->anzahl = 1;
  par1->type = typ_string;
  rueck->param.proz.param = par1;
  rueck->gueltig = 1;

  art = IDENT; enterstring("WriteBool",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_WRITEBOOL;
  rueck->param.proz.result = NULL;
  GET_MEM(par1,1,ST_PARAM);
  par1->mode = N_SCALAR;
  par1->anzahl = 1;
  par1->type = typ_bool;
  rueck->param.proz.param = par1;
  rueck->gueltig = 1;

  art = IDENT; enterstring("WriteInt",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_WRITEINT;
  rueck->param.proz.result = NULL;
  GET_MEM(par2,1,ST_PARAM);
  par2->mode = N_SCALAR;
  par2->anzahl = 1;
  par2->type = typ_card;
  GET_MEM(par1,1,ST_PARAM);
  par1->link = par2;
  par1->mode = N_SCALAR;
  par1->anzahl = 1;
  par1->type = typ_int;
  rueck->param.proz.param = par1;
  rueck->gueltig = 1;

  art = IDENT; enterstring("WriteCard",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_WRITECARD;
  rueck->param.proz.result = NULL;
  GET_MEM(par1,1,ST_PARAM);
  par1->mode = N_SCALAR;
  par1->anzahl = 2;
  par1->type = typ_card;
  rueck->param.proz.param = par1;
  rueck->gueltig = 1;

  art = IDENT; enterstring("WriteReal",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_WRITEREAL;
  rueck->param.proz.result = NULL;
  GET_MEM(par2,1,ST_PARAM);
  par2->mode = N_SCALAR;
  par2->anzahl = 1;
  par2->type = typ_card;
  GET_MEM(par1,1,ST_PARAM);
  par1->link = par2;
  par1->mode = N_SCALAR;
  par1->anzahl = 1;
  par1->type = typ_char;
  rueck->param.proz.param = par1;
  rueck->gueltig = 1;

  art = IDENT; enterstring("WriteFixPt",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_WRITEFIXPT;
  rueck->param.proz.result = NULL;
  GET_MEM(par2,1,ST_PARAM);
  par2->mode = N_SCALAR;
  par2->anzahl = 2;
  par2->type = typ_card;
  GET_MEM(par1,1,ST_PARAM);
  par1->link = par2;
  par1->mode = N_SCALAR;
  par1->anzahl = 1;
  par1->type = typ_real;
  rueck->param.proz.param = par1;
  rueck->gueltig = 1;

  art = IDENT; enterstring("Draw",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_DRAW;
  rueck->param.proz.result = NULL;
  GET_MEM(par1,1,ST_PARAM);
  par1->mode = N_SCALAR;
  par1->anzahl = 1;
  par1->type = typ_char;
  rueck->param.proz.param = par1;
  rueck->gueltig = 1;

  art = IDENT; enterstring("DrawString",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_DRAWSTRING;
  rueck->param.proz.result = NULL;
  GET_MEM(par1,1,ST_PARAM);
  par1->mode = N_SCALAR;
  par1->anzahl = 1;
  par1->type = typ_string;
  rueck->param.proz.param = par1;
  rueck->gueltig = 1;

  art = IDENT; enterstring("DrawBool",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_DRAWBOOL;
  rueck->param.proz.result = NULL;
  GET_MEM(par1,1,ST_PARAM);
  par1->mode = N_SCALAR;
  par1->anzahl = 1;
  par1->type = typ_bool;
  rueck->param.proz.param = par1;
  rueck->gueltig = 1;

  art = IDENT; enterstring("DrawInt",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_DRAWINT;
  rueck->param.proz.result = NULL;
  GET_MEM(par2,1,ST_PARAM);
  par2->mode = N_SCALAR;
  par2->anzahl = 1;
  par2->type = typ_card;
  GET_MEM(par1,1,ST_PARAM);
  par1->link = par2;
  par1->mode = N_SCALAR;
  par1->anzahl = 1;
  par1->type = typ_int;
  rueck->param.proz.param = par1;
  rueck->gueltig = 1;

  art = IDENT; enterstring("DrawCard",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_DRAWCARD;
  rueck->param.proz.result = NULL;
  GET_MEM(par1,1,ST_PARAM);
  par1->mode = N_SCALAR;
  par1->anzahl = 2;
  par1->type = typ_card;
  rueck->param.proz.param = par1;
  rueck->gueltig = 1;

  art = IDENT; enterstring("DrawReal",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_DRAWREAL;
  rueck->param.proz.result = NULL;
  GET_MEM(par2,1,ST_PARAM);
  par2->mode = N_SCALAR;
  par2->anzahl = 1;
  par2->type = typ_card;
  GET_MEM(par1,1,ST_PARAM);
  par1->link = par2;
  par1->mode = N_SCALAR;
  par1->anzahl = 1;
  par1->type = typ_char;
  rueck->param.proz.param = par1;
  rueck->gueltig = 1;

  art = IDENT; enterstring("DrawFixPt",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_DRAWFIXPT;
  rueck->param.proz.result = NULL;
  GET_MEM(par2,1,ST_PARAM);
  par2->mode = N_SCALAR;
  par2->anzahl = 2;
  par2->type = typ_card;
  GET_MEM(par1,1,ST_PARAM);
  par1->link = par2;
  par1->mode = N_SCALAR;
  par1->anzahl = 1;
  par1->type = typ_real;
  rueck->param.proz.param = par1;
  rueck->gueltig = 1;

  art = IDENT; enterstring("WriteLn",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_WRITELN;
  rueck->param.proz.param = NULL;
  rueck->gueltig = 1;

  art = IDENT; enterstring("Read",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_READ;
  rueck->param.proz.result = NULL;
  GET_MEM(par1,1,ST_PARAM);
  par1->mode = N_SCALAR | N_VAR;
  par1->anzahl = 1;
  par1->type = typ_char;
  rueck->param.proz.param = par1;
  rueck->gueltig = 1;

  art = IDENT; enterstring("ReadString",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_READSTRING;
  rueck->param.proz.result = NULL;
  GET_MEM(par1,1,ST_PARAM);
  par1->mode = N_SCALAR | N_VAR;
  par1->anzahl = 1;
  par1->type = typ_string;
  rueck->param.proz.param = par1;
  rueck->gueltig = 1;

  art = IDENT; enterstring("ReadBool",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_READBOOL;
  rueck->param.proz.result = NULL;
  GET_MEM(par1,1,ST_PARAM);
  par1->mode = N_SCALAR | N_VAR;
  par1->anzahl = 1;
  par1->type = typ_bool;
  rueck->param.proz.param = par1;
  rueck->gueltig = 1;

  art = IDENT; enterstring("ReadInt",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_READINT;
  rueck->param.proz.result = NULL;
  GET_MEM(par1,1,ST_PARAM);
  par1->mode = N_SCALAR | N_VAR;
  par1->anzahl = 1;
  par1->type = typ_int;
  rueck->param.proz.param = par1;
  rueck->gueltig = 1;

  art = IDENT; enterstring("ReadCard",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_READCARD;
  rueck->param.proz.result = NULL;
  GET_MEM(par1,1,ST_PARAM);
  par1->mode = N_SCALAR | N_VAR;
  par1->anzahl = 1;
  par1->type = typ_card;
  rueck->param.proz.param = par1;
  rueck->gueltig = 1;

  art = IDENT; enterstring("ReadReal",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_READREAL;
  rueck->param.proz.result = NULL;
  GET_MEM(par1,1,ST_PARAM);
  par1->mode = N_SCALAR | N_VAR;
  par1->anzahl = 1;
  par1->type = typ_real;
  rueck->param.proz.param = par1;
  rueck->gueltig = 1;

  art = IDENT; enterstring("OpenInput",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_OPENINPUT;
  rueck->param.proz.result = NULL;
  GET_MEM(par1,1,ST_PARAM);
  par1->mode = N_SCALAR;
  par1->anzahl = 1;
  par1->type = typ_string;
  rueck->param.proz.param = par1;
  rueck->gueltig = 1;

  art = IDENT; enterstring("OpenOutput",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_OPENOUTPUT;
  rueck->param.proz.result = NULL;
  GET_MEM(par1,1,ST_PARAM);
  par1->mode = N_SCALAR;
  par1->anzahl = 1;
  par1->type = typ_string;
  rueck->param.proz.param = par1;
  rueck->gueltig = 1;

  art = IDENT; enterstring("CloseInput",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_CLOSEINPUT;
  rueck->gueltig = 1;

  art = IDENT; enterstring("CloseOutput",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_CLOSEOUTPUT;
  rueck->gueltig = 1;

  art = IDENT; enterstring("DEBUG",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_DEBUG;
  rueck->gueltig = 1;

  art = IDENT; enterstring("TRACE",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_TRACE;
  rueck->gueltig = 1;

  art = IDENT; enterstring("NOTRACE",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_NOTRACE;
  rueck->gueltig = 1;

  art = IDENT; enterstring("SelectWindow",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_SELECTWINDOW;
  rueck->gueltig = 1;

  art = IDENT; enterstring("SetColor",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_SETCOLOR;
  rueck->gueltig = 1;

  art = IDENT; enterstring("SetPixel",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_SETPIXEL;
  rueck->gueltig = 1;

  art = IDENT; enterstring("CloseWindow",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_CLOSEWINDOW;
  rueck->gueltig = 1;

  art = IDENT; enterstring("Line",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_LINE;
  rueck->gueltig = 1;

  art = IDENT; enterstring("WindowSize",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_WINDOWSIZE;
  rueck->gueltig = 1;

  art = IDENT; enterstring("MoveTo",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_MOVETO;
  rueck->gueltig = 1;

  art = IDENT; enterstring("HALT",&nr,&art);
  rueck = mache_Eintrag(nr, &dummy, N_PROCEDURE);
  rueck->param.proz.posnr = PROC_HALT;
  rueck->gueltig = 1;
  
  color_init();
}


  
