static char _sccsid[] = "Parallaxis Version: @(#)makro.c	2.13  2/28/92 15:10:00";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : makro.c                                                           */
/*                                                                           */
/* Funktionen, die semantische Aktionen im Parser ausf"uhren                 */
/*                                                                           */
/* ************************************************************************* */


# include "defines.h"
# include "typen.h"
# include "makro.h"
# include "parallax.h"
# include "symbols.h"
# include "y_tab.h"
# include "procs.h"
extern int Zeile, Posit;
extern int leeres_statement, fieldlistident;
extern int yychar;
extern char * perrortext[];  /* 'erwartet wird' Fehlermeldungstexte */
extern int parseerror[];
extern struct c_group * conf_groups;
extern T_SYSTEM * programm;
extern int proc_mode;
extern int selecting_poss;
extern long mom_ident_nr;

build_system(id1,de,bl,id2)
SCAN_ELEM * id1, * id2;
T_DECLARATIONS * de;
T_STATEMENT * bl;
{ GET_MEM(programm,1,T_SYSTEM);
  programm->decl = de;
  programm->statements = bl;
  programm->confs = conf_groups;
  if (id1)
  { if (id2)
      if (id1->wert.ident_nr != id2->wert.ident_nr)
        SEMERROR(id1->Zeile, id1->Posit, id2->Zeile, id2->Posit,text[105]);
    programm->sys_ident = id1;
  }
  else
  { if (id2)
      ident_eintragen(id2,N_SYSTEM);
    programm->sys_ident = id2;
  }
}

MAKE_CONFIG(e,a1,a2)
T_CONFIG ** e;
SCAN_ELEM * a1;
T_SUBRANGE * a2;
{ GET_MEM((*e),1,T_CONFIG);
  (*e)->ident = a1;
  (*e)->ranges = a2;
}

MAKE_SUBRANGE(e,a1,a2)
T_SUBRANGE ** e;
T_EXPR * a1, * a2;
{ GET_MEM((*e),1,T_SUBRANGE);
  (*e)->von = a1;
  (*e)->bis = a2;
  (*e)->count = 1;
}

MAKE_CONSTDECL(e,a1,a2)
T_CONSTDECL ** e;
SCAN_ELEM * a1;
T_EXPR * a2;
{ GET_MEM((*e),1,T_CONSTDECL);
  (*e)->link = NULL;
  (*e)->ident = a1;
  (*e)->Constant = a2;
}
                                   
MAKE_TYPEDECL(e,a1,a2)  
T_TYPEDECL ** e;
SCAN_ELEM * a1;
T_TYPE * a2;
{ GET_MEM((*e),1,T_TYPEDECL);
  (*e)->link = NULL;
  (*e)->ident = a1;
  (*e)->type = a2;
}

MAKE_IDENTLIST1(e,a1,a2)
T_IDENTLIST ** e, * a1;
SCAN_ELEM * a2;
{ GET_MEM((*e),1,T_IDENTLIST);
  (*e)->link = a1;
  (*e)->ident = a2;
  if (a1 == NULL)
  { (*e)->count = 1; }
  else
  { (*e)->count = a1->count + 1; }
}
                       
MAKE_IDENTLIST2(e,a1)  
T_IDENTLIST ** e;
SCAN_ELEM * a1;
{ GET_MEM((*e),1,T_IDENTLIST);
  (*e)->link = NULL;
  (*e)->ident = a1;
  (*e)->count = 1;
}

MAKE_PROCEDECL(e,a1,a2,a3)
T_PROCEDECL ** e;
T_PARAM * a1;
SCAN_ELEM * a2;
T_TYPE * a3;
{ GET_MEM((*e),1,T_PROCEDECL);
  (*e)->paramseq = a1;
  (*e)->scavec = a2;
  (*e)->type = a3;
  (*e)->confs = conf_groups;
  (*e)->proc_mode = proc_mode;
  proc_mode = skalar_vektor_anal(a2,a1);
  conf_groups = NULL;
}

MAKE_PARAM(e,a1)       
T_PARAM ** e;
int a1;
{ GET_MEM((*e),1,T_PARAM);
  (*e)->skavecvar = a1;
}

MAKE_STATEMENT(e,a1)   
T_STATEMENT ** e;
int a1;
{ GET_MEM((*e),1,T_STATEMENT);
  (*e)->select = a1;
  (*e)->link = NULL;
}

SET_ASSIGN(e,a1,a2)    
T_STATEMENT ** e;
T_EXPR * a1, * a2;
{ MAKE_STATEMENT(e,S_ASSIGN);
  (*e)->st.assign.design = a1;
  (*e)->Zeile = a1->Zeile;
  (*e)->Posit = a1->Posit;
  (*e)->st.assign.expr = a2;
}

SET_PROC(e,a1,a2)
T_STATEMENT ** e;
SCAN_ELEM * a1;
T_EXPR * a2;
{ MAKE_STATEMENT(e,S_PROCCALL);
  (*e)->st.proc.procident = a1;
  (*e)->Zeile = a1->Zeile;
  (*e)->Posit = a1->Posit;
  (*e)->st.proc.exprlist = a2;
}

SET_IF_SEL(e,a1,a2)
T_STATEMENT ** e;
SCAN_ELEM * a1;
T_EXPR * a2;
{ MAKE_STATEMENT(e,S_IF);
  (*e)->st.ifthen.expr = a2;
  (*e)->Zeile = a1->Zeile;
  (*e)->Posit = a1->Posit;
}

SET_IF(e,a1,a2,a3,a4)
T_STATEMENT ** e, * a1, * a2, * a4;
T_ELSIF * a3;
{ *e = a1;
  (*e)->st.ifthen.statements = a2;
  (*e)->st.ifthen.elsifselect = a3;
  (*e)->st.ifthen.elseselect = a4;
}

SET_CASE(e,a1,a2,a3)
T_STATEMENT ** e;
T_EXPR * a1;
T_CASES * a2;
T_STATEMENT * a3;
{ MAKE_STATEMENT(e,S_CASE);
  (*e)->st.caseof.expr = a1;
  (*e)->st.caseof.cases = a2;
  (*e)->st.caseof.elseselect = a3;
}

SET_WHILE(e,a1)
T_STATEMENT ** e;
T_EXPR * a1;
{ MAKE_STATEMENT(e,S_WHILE);
  (*e)->st.whiledo.expr = a1;
}

SET_REPEAT(e,a1,a2)
T_STATEMENT ** e, * a1;
T_EXPR * a2;
{ MAKE_STATEMENT(e,S_REPEAT);
  (*e)->st.repeat.statements = a1;
  (*e)->st.repeat.expr = a2;
}

SET_LOOP(e,a1)
T_STATEMENT ** e, * a1;
{ MAKE_STATEMENT(e,S_LOOP);
  (*e)->st.doloop.statements = a1;
}

SET_FOR(e,a1,a2,a3,a4)
T_STATEMENT ** e, * a4, * a1;
T_EXPR * a2, * a3;
{ MAKE_STATEMENT(e,S_FOR);
  (*e)->st.forto.st_fo_assign = a1;
  (*e)->st.forto.toexpr = a2;
  (*e)->st.forto.byexpr = a3;
  (*e)->st.forto.statements = a4;
}

SET_WITH(e,a1,a2)
T_STATEMENT ** e, * a2;
T_EXPR * a1;
{ MAKE_STATEMENT(e,S_WITH);
  (*e)->st.with.design = a1;
  (*e)->st.with.statements = a2;
  (*e)->st.with.ST = NULL;
}

SET_RETURN(e,a1)
T_STATEMENT ** e;
T_EXPR * a1;
{ MAKE_STATEMENT(e,S_RETURN);
  (*e)->st.ret.expr = a1;
}

SET_PARALLEL(e,a1,a2,a3)
T_STATEMENT ** e, * a3;
SCAN_ELEM * a1;
T_SELECT * a2;
{ MAKE_STATEMENT(e,S_PARALLEL);
  (*e)->st.parallel.parpos = a1;
  (*e)->st.parallel.selection = a2;
  (*e)->st.parallel.statements = a3;
}

SET_PROPAGATE(e,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11)
T_STATEMENT ** e;
SCAN_ELEM * a1, * a2, * a3;
T_EXPR * a4;
SCAN_ELEM * a5, * a6, * a7;
T_EXPR * a8, * a9, * a10;
SCAN_ELEM * a11;
{ MAKE_STATEMENT(e,S_PROPAGATE);
  (*e)->st.propagate.proppos = a1;
  MAKE_SENDIR(&(*e)->st.propagate.senddir,a2,a3,a4);
  (*e)->st.propagate.senddir->anzahl = a5;
  if (a7)
    MAKE_SENDIR(&(*e)->st.propagate.receivedir,a6,a7,a8);
  (*e)->st.propagate.vonident = a9;
  (*e)->st.propagate.nachident = a10;
  (*e)->st.propagate.reduce_ident = a11;
}

SET_LOAD(e,a1,a2,a3,a4,a5)
T_STATEMENT ** e;
SCAN_ELEM * a1;
T_SELECT * a2;
T_EXPR * a3, * a4, * a5;
{ MAKE_STATEMENT(e,S_LOAD);
  (*e)->st.load.loadpos = a1;
  (*e)->st.load.selection = a2;
  (*e)->st.load.vecident = a3;
  (*e)->st.load.scalident = a4;
  (*e)->st.load.lengident = a5;
}

SET_STORE(e,a1,a2,a3,a4,a5)
T_STATEMENT ** e;
SCAN_ELEM * a1;
T_SELECT * a2;
T_EXPR * a3, * a4, * a5;
{ MAKE_STATEMENT(e,S_STORE);
  (*e)->st.load.loadpos = a1;
  (*e)->st.load.selection = a2;
  (*e)->st.load.vecident = a3;
  (*e)->st.load.scalident = a4;
  (*e)->st.load.lengident = a5;
}

MAKE_SELECT(e,a1,a2)
T_SELECT ** e, * a2;
int a1;
{ GET_MEM((*e),1,T_SELECT);
  (*e)->link = a2;
  (*e)->art = a1;
}

SET_SE_SUBRANGE(e,a1,a2)
T_SELECT ** e, * a1;
T_SUBRANGE * a2;
{ MAKE_SELECT(e,SE_SUBRANGE,a1);
  (*e)->ranges = a2;
}

MAKE_SENDIR(e,a1,a2,a3)
T_SENDDIR ** e;
SCAN_ELEM * a1, * a2;
T_EXPR * a3;
{ GET_MEM((*e),1,T_SENDDIR);
  (*e)->ident = a1;
  (*e)->send = a2;
  (*e)->expr = a3;
}

MAKE_DESIGN(e,a1,a2)
T_EXPR ** e;
SCAN_ELEM * a1;
T_DESIGNREST * a2;
{ MAKE_EXPR(e,E_DESIGN);
  (*e)->factors.designator.ident = a1;
  (*e)->factors.designator.selector = a2;
  (*e)->Zeile = a1->Zeile;
  (*e)->Posit = a1->Posit;
}

MAKE_DESIGNREST(e,a1,a2)
T_DESIGNREST ** e, * a2;
int a1;
{ GET_MEM((*e),1,T_DESIGNREST);
  (*e)->select = a1;
  (*e)->link = a2;
}

MAKE_DESIGNREST_ARRAY(e,a1,a2)
T_DESIGNREST ** e, * a1;
T_EXPR * a2;
{ MAKE_DESIGNREST(e,D_ARRAY,a1);
  (*e)->design.exprlist = a2;
}

MAKE_DESIGNREST_RECORD(e,a1,a2)
T_DESIGNREST ** e, * a1;
SCAN_ELEM * a2;
{ MAKE_DESIGNREST(e,D_RECORD,a1);
  (*e)->Zeile = Zeile;
  (*e)->Posit = Posit;
  (*e)->design.ident = a2;
}
                                               
MAKE_DESIGNREST_DEREF(e,a1,a2)
T_DESIGNREST ** e, * a1;
SCAN_ELEM * a2;
{ MAKE_DESIGNREST(e,D_DEREF,a1);
  (*e)->Zeile = Zeile;
  (*e)->Posit = Posit;
  (*e)->design.deref = a2;
}
                                               
MAKE_TYPE(e,a1,a2,a3)
T_TYPE ** e;
int a1,a2,a3;
{ GET_MEM((*e),1,T_TYPE);
  (*e)->Zeile = a1;
  (*e)->Posit = a2;
  (*e)->art = a3;
  (*e)->link = NULL;
}

MAKE_ARRAY(e,a1,a2,a3,a4)
T_TYPE ** e;
int a1,a2;
T_TYPE * a3, * a4;
{ MAKE_TYPE(e,a1,a2,TY_ARRAY);
  (*e)->typ.array.dimen = a3;
  (*e)->typ.array.type = a4;
}

MAKE_RECORD(e,a1,a2,a3)
T_TYPE ** e;
int a1, a2;
T_RECDEF * a3;
{ MAKE_TYPE(e,a1,a2,TY_RECORD);
  if (a3 == NULL)
  { SEMERROR(a1,a2,0,0,text[154]);
    a3 = silly;
  };
  (*e)->typ.record.fieldlist = a3;
}

MAKE_VARIANT(e,a1,a2)
T_VARIANT ** e;
T_CASELABEL * a1;
T_RECDEF * a2;
{ GET_MEM((*e),1,T_VARIANT);
  (*e)->caselist = a1;
  (*e)->fieldlist = a2;
}

MAKE_RECDEF_NORM(e,a1)
T_RECDEF ** e;
T_VARDEF * a1;
{ T_RECDEF * h;
  GET_MEM(h,1,T_RECDEF);
  h->select = REC_NORM;
  h->art.norm = a1;
  *e = h;
}

MAKE_RECDEF_CASE(e,a1,a2,a3,a4)
T_RECDEF ** e;
T_IDENTLIST * a1;
T_TYPE * a2;
T_VARIANT * a3;
T_RECDEF * a4;
{ T_RECDEF * h;
  GET_MEM(h,1,T_RECDEF);
  h->select = REC_CASE;
  h->art.selected.ident = a1;
  h->art.selected.typ = a2;
  h->art.selected.vari = a3;
  h->art.selected.elseteil = a4;
  *e = h;
}

MAKE_SET(e,a1,a2,a3)
T_TYPE ** e, * a3;
int a1,a2;
{ MAKE_TYPE(e,a1,a2,TY_SET);
  (*e)->typ.settyp = a3;
}

MAKE_POINTER(e,a1,a2,a3)
T_TYPE ** e, * a3;
int a1,a2;
{ MAKE_TYPE(e,a1,a2,TY_POINTER);
  (*e)->typ.settyp = a3;
}

MAKE_NAME(e,a1)
T_TYPE ** e;
SCAN_ELEM * a1;
{ MAKE_TYPE(e,a1->Zeile,a1->Posit,TY_NAME);
  (*e)->typ.ident = a1;
}

MAKE_ENUM(e,a1,a2,a3)
T_TYPE ** e;
int a1,a2;
T_IDENTLIST * a3;
{ MAKE_TYPE(e,a1,a2,TY_ENUM);
  (*e)->typ.identlist = a3;
}

MAKE_RANGE(e,a3)
T_TYPE ** e;
T_SUBRANGE * a3;
{ MAKE_TYPE(e,0,0,TY_RANGE);
  (*e)->typ.range = a3;
}

MAKE_EXPR(e,a1)
T_EXPR ** e;
int a1;
{ GET_MEM((*e),1,T_EXPR);
  (*e)->select = a1;
}

MAKE_BINOP(e,a1,a2,a3)
T_EXPR ** e, * a1;
SCAN_ELEM * a2;
T_EXPR * a3;
{ MAKE_EXPR(e,E_BINOP);
  (*e)->factors.binop.twice = EX_EINF;
  (*e)->factors.binop.expr1 = a1;
  (*e)->factors.binop.operator = a2;
  (*e)->factors.binop.expr2 = a3;
  (*e)->Zeile = a1->Zeile;
  (*e)->Posit = a1->Posit;
}

MAKE_SINOP(e,a1,a2)
T_EXPR ** e;
SCAN_ELEM * a1;
T_EXPR * a2;
{ MAKE_EXPR(e,E_SINOP);
  (*e)->factors.binop.expr1 = NULL;
  (*e)->factors.binop.operator = a1;
  (*e)->factors.binop.expr2 = a2;
  (*e)->Zeile = a1->Zeile;
  (*e)->Posit = a1->Posit;
}

MAKE_FUNC(e,a1,a2)
T_EXPR ** e;
SCAN_ELEM * a1;
T_EXPR * a2;
{ MAKE_EXPR(e,E_FUNC);
  (*e)->factors.funccall.funcident = a1;
  (*e)->factors.funccall.exprlist = a2;
  (*e)->Zeile = a1->Zeile;
  (*e)->Posit = a1->Posit;
}
                             
MAKE_E_SET(e,a1,a2,a3,a4)
T_EXPR ** e;
SCAN_ELEM * a1;
T_SUBRANGE * a2;
int a3, a4;
{ MAKE_EXPR(e,E_SET);
  (*e)->factors.sets.setident = a1;
  (*e)->factors.sets.elements = a2;
  (*e)->Zeile = a3;
  (*e)->Posit = a4;
}

MAKE_KLEXPR(e,a1)
T_EXPR ** e, * a1;
{ MAKE_EXPR(e,E_KLEXPR);
  (*e)->factors.klexpr = a1;
  (*e)->Zeile = Zeile;
  (*e)->Posit = Posit;
}

MAKE_NOTEXPR(e,a1)
T_EXPR ** e, * a1;
{ MAKE_EXPR(e,E_NOTEXPR);
  (*e)->factors.notexpr = a1;
  (*e)->Zeile = Zeile;
  (*e)->Posit = Posit;
}
                                                       
MAKE_REDUCE(e,a1,a2,a3)
T_EXPR ** e;
SCAN_ELEM * a1;
T_SELECT * a2;
T_EXPR * a3;
{ MAKE_EXPR(e,E_REDUCE);
  (*e)->factors.reduce.redident = a1;
  (*e)->factors.reduce.select = a2;
  (*e)->factors.reduce.expr = a3;
  (*e)->Zeile = Zeile;
  (*e)->Posit = Posit;
}

MAKE_CONST(e,a1)
T_EXPR ** e;
SCAN_ELEM * a1;
{ MAKE_EXPR(e,E_CONST);
  (*e)->factors.Const = a1;
  (*e)->Zeile = a1->Zeile;
  (*e)->Posit = a1->Posit;
}

MAKE_CONSTANT(e,a1)
T_CONSTANT ** e;
int a1;
{ GET_MEM((*e),1,T_CONSTANT);
  (*e)->art = a1;
}

MAKE_TRANSFER(e,a1,a2,a3,a4,a5)
T_TRANSFER ** e;
T_IO_IDENT * a1;
SCAN_ELEM * a2;
T_SOURCE * a3;
SCAN_ELEM * a4;
T_DESTINATION * a5;
{ GET_MEM((*e),1,T_TRANSFER);
  (*e)->link = NULL;
  (*e)->count = 0;
  (*e)->out_ident = a1;
  (*e)->conf_ident = a2;
  (*e)->sources = a3;
  (*e)->arrow = a4->wert.i;
  (*e)->destinations = a5;
}

MAKE_IO_IDENT(e,a1,a2)
T_IO_IDENT ** e;
SCAN_ELEM * a1, * a2;
{ GET_MEM((*e),1,T_IO_IDENT);
  (*e)->ident = a1;
  (*e)->Const = a2;
}

fill_propagate(res,prop,send,anz,reduce)
T_STATEMENT * res;
SCAN_ELEM * prop, * send, * anz, * reduce;
{ res->st.propagate.proppos = prop;
  res->st.propagate.senddir->send = send;
  res->st.propagate.senddir->anzahl = anz;
  res->st.propagate.reduce_ident = reduce;
  res->Zeile = prop->Zeile;
  res->Posit = prop->Posit;
}


extern int yynerrs; /* Fehleranzahl */

/* ************************************************************************* */
/* trage den Namen in die Symboltabelle ein                                  */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Namen                                                         */
/*             Namensart                                                     */
/*                                                                           */
/* ************************************************************************* */

ident_eintragen(ident, art)
SCAN_ELEM * ident;
int art;
{ Eintrag * ein;
  int ex;
  if (ident != NULL)
  { ein = mache_Eintrag(ident->wert.ident_nr,&ex,art);
    if (ex == JA)
    { SEMERROR(ein->Zeile,ein->Posit,ident->Zeile, ident->Posit,
               text[113]);
      ein->Art = (ein->Art == art) ? N_UNDEF : ein->Art;
    }
    else
    { ein->Zeile = ident->Zeile;
      ein->Posit = ident->Posit;
    }
  }
}

/* ************************************************************************* */
/* stelle fest, ob ein vektorieller Parameter existiert                      */
/*                                                                           */
/* Ergebnis : 0 oder P_VECTOR                                                */
/*                                                                           */
/* Parameter : Parameterlisten                                               */
/*                                                                           */
/* ************************************************************************* */

int analysiere_param(z)
T_PARAM * z;
{ if (z->skavecvar & P_VECTOR)
  { return P_VECTOR;
  }
  if (z->link != NULL)
    return analysiere_param(z->link);
  return 0;
}    

/* ************************************************************************* */
/* gebe Syntaxfehlermeldung mit "erwartet wird" aus                          */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Parserzustand                                                 */
/*                                                                           */
/* ************************************************************************* */

meldung(state)
int state;
{ parsestate = state;
  if (parsestate >= 0 && parseerror[parsestate])
    yyerror(NULL,perrortext[parseerror[parsestate]]);
}

#ifdef YYDEBUG
extern int yydebug;
#endif

/* ************************************************************************* */
/* rufe den Scanner auf                                                      */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter :                                                               */
/*                                                                           */
/* ************************************************************************* */

extern int memo;
extern int key_nr;
extern int ende;
extern int parallel, new_parallel;
static int end_fehlt = 0;
yyyylex(state)
{ parsestate = state;
  if (yychar < 0)
  { if ((memo < 0) && ((memo = yychar = yylex()) < 0))
      yychar = 0;
    switch(memo)
    { case _CONFIGURATION :
      case _CONNECTION :
      case _CONST :
      case _PROCEDURE :
      case _SCALAR :
      case _TYPE :
      case _VECTOR :
        if (key_nr == 0)
          yychar = ENDSYSTEM;
        if (key_nr > 0)
        { yychar = memo;
          memo = -1;
        }
        break;
      case _BEGIN :
        if (key_nr == 0)
          yychar = ENDSYSTEM;
        if (key_nr == 1)
          yychar = ENDCONST;
        if (key_nr >= 2)
        { yychar = memo;
          memo = -1;
        }
        break;
      case _END :
        if ((ende < 0) || (ende == 2))
        { memo = -1;
          yychar = _END;
        }
        else
          yychar = ENDEND;
        break;
      case _ENDPARALLEL :
        if ((parallel == new_parallel) && (parallel > 0))
        { if ((ende < 0) || (ende == 2))
          { if (end_fehlt)
            { yychar = _END; }
            else
            { yychar = ENDEND;
              end_fehlt = 1;
            }
          }
          else
            yychar = ENDEND;
        }
        else
        { memo = -1;
          yychar = _ENDPARALLEL;
          new_parallel--;
        }
        break;
      case IDENT :
        if (selecting_poss)
        { Eintrag * ein;
          if (ein = suche_Eintrag(mom_ident_nr,vector_ST,GLOBAL,0))
          { if (ein->Art == N_CONFIGURATION)
            { yychar = DOLLAR; }
            else
              memo = -1;
          }
          else
            memo = -1;
          selecting_poss = 0;
        }
        else
        { if (yychar < 0)
            yychar = memo;
          memo = -1;
        }
        break;
      case 0 :
        switch (key_nr)
        { case 0 :
            yychar = ENDSYSTEM;
            break;
          case 1 :
            yychar = ENDCONST;
            break;
          case 2 :
            yychar = ENDBEGIN;
            break;
          case 3 :
            yychar = ENDOFFILE;
            break;
          default :
            yychar = memo;
            memo = -1;
            break;
        }
        break;
      default :
        memo = -1;
    }
#ifdef YYDEBUG
    if (yydebug)
      printf("[yydebug] Eingabe   memo : %d  yychar : %d\n",memo,yychar);
#endif
  }
}

int skalar_vektor_anal(s,p)
SCAN_ELEM * s;
T_PARAM * p;
{ int erg = 0;
  if (s && (s->Art == _VECTOR))
    erg |= VECTOR_ARGS;
  while (p)
  { if (p->skavecvar & P_VECTOR)
      erg |= VECTOR_ARGS;
    if (p->skavecvar & P_VAR)
      erg |= VAR_ARGS;
    p = p->link;
  }
  return erg;
}

/* Ende */

