static char _sccsid[] = "Parallaxis Version: @(#)output.c	2.13  2/28/92 15:00:02";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : output.c                                                          */
/*                                                                           */
/* Ausgabe des Zwischencodes                                                 */
/*                                                                           */
/* ************************************************************************* */


#include "defines.h"
#include "parallax.h"
#include "typen.h"
#include "symbols.h"
#include "makro.h"
#include "y_tab.h"
#include "hilfsvar.h"
#include "code.h"
#include "conf.h"
#include "scope.h"

extern int akt_conf_group; /* Nummer der Topologiegruppe */
extern char * getstring();
extern ZEILE * list_anf;  /* erste Zeile im Listing */
extern ZEILE * list_end;  /* letzte Zeile im Listing */

extern int prozedur_zeilen;  /* Anzahl der Zeilen fuer die Prozeduren */
extern int akt_conf_nr;  /* Anzahl der Konfigurationen */
extern ST_TYPE * typ_s;
extern FILE * ausDatei;
extern int proz_anz, yynerrs, yywarning;
extern ST_TYPE * typ_error, * typ_int, * typ_char, * typ_real,
               * typ_bool, * typ_string, * typ_bitset;
extern int MAXINTEGER;
extern int portnr;
int proc_ebene = 0;           /* derzeitige Ebene */
extern int parseerror[];
extern char * perrortext[];
extern int divisionstest;
extern ST_CONST * erzeuge_string();
extern C_GROUP * all_groups;
extern int pointer_check;

char letter[4] = { 'B', 'C', 'I', 'R'}; 
int neues_statement = 0;        /* setze Flag vor ein PARZ-Zeile */
int zeilenfuellung = 0;
int char_string;        /* Soll ein Charakter oder ein String ausgegeben werden */
int loop_exit;          /* Ziel bei EXIT */
int proc_return;        /* Ziel bei RETURN */
int selection_exit;     /* Ziel bei dyn. Selektion */
int port_variable = 0;
UNREACHED * UnReached, * AllUnReached;
int linenr = 1;
/* static */ int protokolliere = 0;
/* static */ char text1[MAX_EXPR_LENGTH + 1] = { '\0' };
/* static */ char text2[MAX_EXPR_LENGTH + 1] = { '\0' };
/* static */ char text3[MAX_EXPR_LENGTH + 1] = { '\0' };
/* static */ char * comment1 = text1;
/* static */ char * comment2 = text2;
/* static */ int aktuelle_zeile = 0; /* Parallaxiszeilennummer einer Anweisung */
/* static */ char * indent_tab;
int bereich_fehler;   /* Zeilennummer der Fehlermeldung bei Bereichsueberschreitung */
int divisions_fehler; /* Zeilennummer der Fehlermeldung bei Division durch 0 */
int keine_prozessoren; /* Zeilennummer der Fehlermeldung bei LOAD/STORE ohne Prozessoren */
int normal_basis;     /* Zeilennummernoffset fuer die Prozeduren */
int check_pointer;
int error_div = 0;
int error_range = 0;  /* koennen Fehler auftreten ? */
int null_prozessoren = 0;
int next_linenr = 0;
int first_line;
SCOPE * with_scope;

/* ************************************************************************* */
/* Ausgabe des Funktionsnamens von trigonometrischen und logarithmischen     */
/* Funktionen                                                                */
/*                                                                           */
/* Ergebnis : Namensstring                                                   */
/*                                                                           */
/* Parameter : Funktionsnummer                                               */
/*                                                                           */
/* ************************************************************************* */

char * funktionsname(nr)
int nr;
{ switch (nr)
  { case PROC_COS :
      return "COS";
    case PROC_SIN :
      return "SIN";
    case PROC_TAN :
      return "TAN";
    case PROC_ARCTAN :
      return "ARCTAN";
    case PROC_ARCCOS :
      return "ARCCOS";
    case PROC_ARCSIN :
      return "ARCSIN";
    case PROC_SQRT :
      return "SQRT";
    case PROC_EXP :
      return "EXP";
    case PROC_LN :
      return "LN";
    default :
      return "%%%%%%";
  }
}


/* ************************************************************************* */
/* Ausgabe der PARZ-Befehle (Initialisierung)                                */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter :                                                               */
/*                                                                           */
/* ************************************************************************* */

program_head(d)
T_DECLARATIONS * d;
{ int gl;
  next_linenr = linenr + error_range + error_div + null_prozessoren + pointer_check +
                akt_conf_nr + prozedur_zeilen + (gl = group_lines(all_groups));
  if (next_linenr != linenr)
  { zeilennummer(0);
    fprintf(ausDatei,"GOTO %d;",first_line = ++next_linenr);
#ifdef DEVELOP
fprintf(ausDatei,"range %d div %d null %d conf %d proc %d group %d",
              error_range,error_div,null_prozessoren,akt_conf_nr,prozedur_zeilen,gl);
#endif
  }
  else
  { first_line = linenr; }
  if (gl)
  { zeilennummer(0);
    fprintf(ausDatei,"PROC 1 VECTOR I1;");
    nozeilennummer();
    fprintf(ausDatei,"POPV VI1:1;");
    nozeilennummer();
    fprintf(ausDatei,"VI[VI1:1] := 0;");
    nozeilennummer();
    fprintf(ausDatei,"PUSHV VI1:1;");
    nozeilennummer();
    fprintf(ausDatei,"RETURN;");
  }
  bereich_fehler = linenr;
  if (error_range)
  { zeilennummer(0);
    fprintf(ausDatei,"PROC 1;");
    nozeilennummer();
    fprintf(ausDatei,"ERROR \"%s\";",text[76]);
    nozeilennummer();
    fprintf(ausDatei,"RETURN;");
  }
  divisions_fehler = linenr;
  if (error_div)
  { zeilennummer(0);
    fprintf(ausDatei,"PROC 1;");
    nozeilennummer();
    fprintf(ausDatei,"ERROR \"%s\";",text[77]);
    nozeilennummer();
    fprintf(ausDatei,"RETURN;");
  }
  keine_prozessoren = linenr;
  if (null_prozessoren)
  { zeilennummer(0);
    fprintf(ausDatei,"PROC 1;");
    nozeilennummer();
    fprintf(ausDatei,"ERROR \"%s\";",text[104]);
    nozeilennummer();
    fprintf(ausDatei,"RETURN;");
  }
  check_pointer = linenr;
  if (pointer_check)
  { zeilennummer(0);
    fprintf(ausDatei,"PROC 1;");
    nozeilennummer();
    fprintf(ausDatei,"ERROR \"%s\";",text[111]);
    nozeilennummer();
    fprintf(ausDatei,"RETURN;");
  }
  group_prepare(conf_groups);
  decl_prepare(d);
  normal_basis = linenr;
}

/* ************************************************************************* */
/* n"achste Zeile ohne Zeilennummer                                          */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter :                                                               */
/*                                                                           */
/* ************************************************************************* */

nozeilennummer()
{ fprintf(ausDatei,"\n\t\t"); }

/* ************************************************************************* */
/* Ausgabe des Kommentars, der Zeilennummer und Flags des PARZ-Kodes         */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter :                                                               */
/*                                                                           */
/* ************************************************************************* */

zeilennummer(err)
int err;
{ char t[10];
  char * com;
  *t = '\0';
  if (err)
  { if (UnReached == NULL)
    { GET_MEM(UnReached,1,UNREACHED);
      UnReached->link = AllUnReached;
      AllUnReached = UnReached;
      UnReached->von = linenr;
    }
    UnReached->bis = linenr;
  }
  else
  { UnReached = NULL; }
  if (neues_statement)
    sprintf(t,"!%d",aktuelle_zeile);
  fprintf(ausDatei,"%s\n%5d%s%c :\t",comment1,linenr++,t,(protokolliere) ? 'r' : ' ');
  com = comment2;
  comment2 = comment1;
  comment1 = com;
  *comment2 = '\0';
  neues_statement = 0;
}

/* ************************************************************************* */
/* Ausgabe einer PARZ-Variablen                                              */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Variablenknoten                                               */
/*             Zugriffsart                                                   */
/*                                                                           */
/* ************************************************************************* */

variable_ausgeben(var,dir_indir)
VARNODE * var;
int dir_indir;
{ Eintrag * ein;
  int art, mem = 1;
  ein = var->ein;
  art = ein->Art;
  if (dir_indir == ADRESS)
  { if (((art & ~N_VAR) == N_SCALAR) || ((art & ~N_VAR) == N_VECTOR))
    { if ((ein->param.var.dir_indir == INDIRECT) || (var->dir_indir == INDIRECT))
      { dir_indir = DIRECT;
        mem = 0;
      }
      else
      { fprintf(ausDatei,"ADDR "); }
    }
  }
  if ((dir_indir == INDIRECT) || ((dir_indir == DIRECT) &&
                                  (ein->param.var.dir_indir == INDIRECT) && mem))
  { if (var->scavec == 0)
    { fprintf(ausDatei,"S"); }
    else
    { fprintf(ausDatei,"V"); }
    fprintf(ausDatei,"%c[",letter[var->firstelem]);
    if ((ein->Art & (N_VAR - 1)) == N_SCALAR)
    { fprintf(ausDatei,"SI"); }
    else
    { fprintf(ausDatei,"VI"); }
    fprintf(ausDatei,"%d:%d]",ein->param.var.ebene,ein->param.var.nummer);
  }
  else
  { switch(ein->Art & ~N_VAR)
    { case N_SPEZIAL_VEK :
        if (ein->param.var.type->Art == ST_TID_NO)
        { fprintf(ausDatei,"ID");
          return;
        };
      case N_VECTOR :
        if (ein->param.var.dir_indir == DIRECT)
        { fprintf(ausDatei,"V%c%d:%d",letter[ein->param.var.type->firstelem],
                                      ein->param.var.ebene,ein->param.var.nummer);
        }
        else
        { fprintf(ausDatei,"VI%d:%d",ein->param.var.ebene,ein->param.var.nummer); }
        break;
      case N_SCALAR :
        if (ein->param.var.dir_indir == DIRECT)
        { fprintf(ausDatei,"S%c%d:%d",letter[ein->param.var.type->firstelem],
                                      ein->param.var.ebene,
                                      ein->param.var.nummer);
        }
        else
        { fprintf(ausDatei,"SI%d:%d",ein->param.var.ebene,ein->param.var.nummer); }
        break;
      case N_SPEZIAL_SKA :
        if (ein->param.var.type == typ_bool)
        { fprintf(ausDatei,"Done");
          return;
        }
        if (ein->param.var.type == typ_char)
        { fprintf(ausDatei,"termCH");
          return;
        }
        break;
      default :
        bug("variable_ausgeben %d",ein->Art);
        break;
    }
  }
}

/* ************************************************************************* */
/* PARZ-Code fuer die Einschaltung aller Prozessoren                         */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : erreichbar ?                                                  */
/*             Konfigurationsnummer                                          */
/*                                                                           */
/* ************************************************************************* */

parallel_ausgeben(g)
C_GROUP * g;
{ int i, nl = 0;
  fprintf(ausDatei,"PARALLEL\t");
  for (i = 0; i < g->first_proz; i++)
  { if (nl == 50)
    { fprintf(ausDatei,"\n\t\t\t\t");
      nl = 0;
    }
    fprintf(ausDatei,"0");
    nl++;
  }
  for (i = 0; i < g->proz_anz; i++)
  { if (nl == 50)
    { fprintf(ausDatei,"\n\t\t\t\t");
      nl = 0;
    }
    fprintf(ausDatei,"1");
    nl++;
  }
  for (i = g->first_proz + g->proz_anz; i < proz_anz; i++)
  { if (nl == 50)
    { fprintf(ausDatei,"\n\t\t\t\t");
      nl = 0;
    }
    fprintf(ausDatei,"0");
    nl++;
  }
  fprintf(ausDatei,";");
}

alle_parallel_ausgeben()
{ int i, nl = 0;
  nozeilennummer();
  fprintf(ausDatei,"PARALLEL\t");
  for (i = 0; i < proz_anz; i++)
  { if (nl == 50)
    { fprintf(ausDatei,"\n\t\t\t\t");
      nl = 0;
    }
    fprintf(ausDatei,"1");
    nl++;
  }
  fprintf(ausDatei,";");
}

/* ************************************************************************* */
/* Ausgabe einer PARZ-Konstanten                                             */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Konstante                                                     */
/*                                                                           */
/* ************************************************************************* */

konstante_ausgeben(c)
ST_CONST * c;
{ switch(c->Art)
  { case ST_CINT :
      fprintf(ausDatei,"%d",c->wert.i);
      break;
    case ST_CPI :
    case ST_CREAL :
#ifdef SUN
      if (c->wert.r != 0.0)
        fprintf(ausDatei,"%#g",c->wert.r);
      else
        fprintf(ausDatei,"0.0");
#else
      fprintf(ausDatei,"%#g",c->wert.r);
#endif
      break;
    case ST_CSTRING :
      if (char_string == 0)
      { unsigned char ch;
        if ((ch = (unsigned char) *c->wert.s.string) == '\0')
        { fprintf(ausDatei,"termS"); }
        else
        { if (ch == '\n')
            fprintf(ausDatei,"EOL");
          else
          { if ((ch < MINIMAL_PRINT_CHAR) || (ch > MAXIMAL_PRINT_CHAR))
            { fprintf(ausDatei,"CHR(%d)",ch); }
            else
            { fprintf(ausDatei,"'%c'",ch);
              if (ch == '\'')
                fprintf(ausDatei,"'");
            }
          }
        }
      }
      else
      { int i;
        char ch;
        fprintf(ausDatei,"\"");
        for(i = 0; i < c->wert.s.len; i++)
        { fprintf(ausDatei,"%c",ch = c->wert.s.string[i]);
          if (ch == '\"')
            fprintf(ausDatei,"\"");
        }
        fprintf(ausDatei,"\"");
      }
      break;
    case ST_CELEM :
    case ST_CENUM :
      if (match_typen(typ_char,c->type,0) == JA)
      { int ch;
        if (ch = c->wert.range.val)
        { if (ch == '\n')
            fprintf(ausDatei,"EOL");
          else
          { if ((ch < MINIMAL_PRINT_CHAR) || (ch > MAXIMAL_PRINT_CHAR))
            { fprintf(ausDatei,"CHR(%d)",ch); }
            else
            { fprintf(ausDatei,"'%c'",ch);
              if (ch == '\'')
              { fprintf(ausDatei,"'"); }
            }
          }
        }
        else
          fprintf(ausDatei,"termS");
      }
      else
      { if (match_typen(typ_bool,c->type,0) == JA)
        { if (c->wert.range.val == 0)
            fprintf(ausDatei,"FALSE");
          else
            fprintf(ausDatei,"TRUE");
        }
        else
          fprintf(ausDatei,"%d",c->wert.range.val);
      }
      break;
    case ST_CBOOL :
      if (c->wert.range.val == 0)
        fprintf(ausDatei,"FALSE");
      else
        fprintf(ausDatei,"TRUE");
      break;
    case ST_CEOL :
      fprintf(ausDatei,"EOL");
      break;
    case ST_CTYPDESC :
      fprintf(ausDatei,"SIZE(");
      indent_tab = "\t\t\t";
      zeilenfuellung = 1;
      typdef_ausgeben(ausDatei,c->type,(long)c->wert.i);
      fprintf(ausDatei," )");
      break;
    case ST_CNIL :
      fprintf(ausDatei,"%s",NIL);
      break;
    default :
      bug("konstante_ausgeben %d",c->Art);
      break;
  }
}

/* ************************************************************************* */
/* Ausgabe der Bereichsgrenzen als PARZ-Konstante                            */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Wert                                                          */
/*             Datentyp                                                      */
/*                                                                           */
/* ************************************************************************* */

bereichsgrenze(wert,typ)
int wert;
ST_TYPE * typ;
{ if (match_typen(typ_char,typ,0) == JA)
  { switch (wert)
    { case '\'' :
        fprintf(ausDatei,"''''");
        break;
      case '\0' :
        fprintf(ausDatei,"termS");
        break;
      case '\n' :
        fprintf(ausDatei,"EOL");
        break;
      default :
        if ((wert < MINIMAL_PRINT_CHAR) || (wert > MAXIMAL_PRINT_CHAR))
          fprintf(ausDatei,"CHR(%d)",wert);
        else
          fprintf(ausDatei,"'%c'",wert);
    }
  }
  else
  if (match_typen(typ_bool,typ,0) == JA)
  { fprintf(ausDatei,"%s",(wert == 0) ? "FALSE" : "TRUE"); }
  else
  { fprintf(ausDatei,"%d",wert); }
}

/* ************************************************************************* */
/* Ausgabe eines PARZ-Programms                                              */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Programmzeiger                                                */
/*             protokolliere oder nicht                                      */
/*                                                                           */
/* ************************************************************************* */

programm_ausgeben(p,part)
T_SYSTEM * p;
int part;
{ int neue_zeile, flag, flag1;
  ST * a_st;
  C_GROUP * conf;
  adjusting(p->confs);
  p->protokollart = part;
  if (verbose_flag)
    fprintf(stderr,text[46]);
  if (pipeline)
  { ausDatei = stdout; }
  else
  { if (ausDatei = fopen(d_name,"w"))
    {
    }
    else
    { fprintf(stderr,text[32],d_name);
      return;
    }
  }
  fprintf(ausDatei,"START\n");
  fprintf(ausDatei,"%d PE\n",proz_anz);
  fprintf(ausDatei,"%d PORTS\n",portnr);
  indent_tab = "\t";
  fprintf(ausDatei,"SCALAR\t");
  zeilenfuellung = 2;
  if (p->port_variables > 0)
  { fprintf(ausDatei," I%d",p->port_variables); }
  else
  { zeilenfuellung = 1; }
  if (akt_ST->is_vector)
  { a_st = akt_ST->Obertabelle; }
  else
  { a_st = akt_ST; }
  definition_ausgeben(a_st->scalar, akt_ST->hvarsscal,0);
  if (zeilenfuellung)
  { fprintf(ausDatei,"\n");
    zeilenfuellung = 0;
  }
  fprintf(ausDatei,"VECTOR\t");
  zeilenfuellung = 1;
  definition_ausgeben(akt_ST->vector,/* akt_ST->hvarsvect */NULL,0);
  vector_definition_ausgeben(p->confs);
  if (p->confs)
  { conf = conf_groups = p->confs; }
  else
  { conf = conf_groups = NULL; }
  program_head(p->decl);
  if (p->confs)
  { conf_groups = p->confs; }
  declaration_ausgeben(p->decl);
  p->scop->entry = p->scop->von = 1;
  p->start = linenr;
  proc_ebene = 0;
  protokolliere = part;
  neue_zeile = 1;
  flag = flag1 = 0;
  if (first_line != linenr)
  { fprintf(ausDatei,"\n");
    firstline_error(first_line,linenr);
  }   
  while (conf)
  { if (conf->zeilen)
    { if (flag || (conf->proz_anz != proz_anz))
      { if (neue_zeile)
          zeilennummer(neue_zeile = 0);
        else
          nozeilennummer();
        parallel_ausgeben(conf);
      }
      if (neue_zeile)
        zeilennummer(neue_zeile = 0);
      else
        nozeilennummer();
      fprintf(ausDatei,"CALL %d;\tconnections",conf->initport);
      if (conf->proz_anz != proz_anz)
      { flag = 1; }
      flag1 = 1;
    }
    conf = conf->link;
  }
  if (flag)
    alle_parallel_ausgeben();
  statements_ausgeben(p->statements);
  p->scop->bis = p->end = linenr;
  zeilennummer(0);
  if (flag1)
  { fprintf(ausDatei,"DISCONNECT;");
    nozeilennummer();
  }
  fprintf(ausDatei,"END;\t%s\n",getstring(p->sys_ident->wert.ident_nr));
  fprintf(ausDatei,"STOP\n");
  fclose(ausDatei);
#ifdef MAC
  { int vref;
    char name[256];
    FInfo fdinfo;
    if (GetVol(name,&vref) != noErr)
    { fprintf(stderr,"Error in GetVol !\n");
      return;
    }
    strcpy(name,d_name);
    CtoPstr(name);
    if (GetFInfo(name,vref,&fdinfo) != noErr)
    { fprintf(stderr,"Error in GetFInfo !\n");
      return;
    }
    fdinfo.fdCreator = 'PARZ';
    if (SetFInfo(name,vref,&fdinfo) != noErr)
    { fprintf(stderr,"Error in SetFInfo !\n");
      return;
    }    
  }
#endif
}

/* ************************************************************************* */
/* Ausgabe einer Anweisung (Anweisungskette) als PARZ-Kode                   */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Anweisung                                                     */
/*                                                                           */
/* ************************************************************************* */

statements_ausgeben(s)
T_STATEMENT * s;
{ if (s != NULL)
  { int start;
    int p_start;
    LINENR * l;
    statements_ausgeben(s->link);
    p_start = linenr;
    neues_statement = 1;
    switch (s->select)
    { case S_WITH :
        with_scope = s->st.with.scop;
        if (with_scope)
          with_scope->entry = with_scope->von = linenr;
        break;
      case S_PARALLEL :
        with_scope = s->st.parallel.scop;
        if (with_scope)
          with_scope->entry = with_scope->von = linenr;
        break;
      case S_LOAD :
      case S_STORE :
        with_scope = s->st.load.scop;
        if (with_scope)
          with_scope->entry = with_scope->von = linenr;
        break;
    }
    GET_MEM(l,1,LINENR);
    l->link = all_lines;
    all_lines = l;
    l->source = s->Zeile;
    l->drain = linenr;
    if (s->Zeile != 0)
    { int i;
      aktuelle_zeile = s->Zeile;
#ifdef DEVELOP
      sprintf(text3,text[80],s->Zeile,/*s->Posit just for debugging */s->zeilen);
#else
      sprintf(text3,text[80],s->Zeile,s->Posit);
#endif
      if ((MAX_EXPR_LENGTH - (i = my_strlen(comment2)) - 1) > my_strlen(text3))
#ifdef DEVELOP
        sprintf(&comment2[i],text[80],s->Zeile,/*s->Posit just for debugging */s->zeilen);
#else
        sprintf(&comment2[i],text[80],s->Zeile,s->Posit);
#endif
      else
        if (i < (MAX_EXPR_LENGTH - 2))
          sprintf(&comment2[i],".");
    }      
    start = linenr;
    code_ausgeben(s->unreached,s->code);
    if ((start == linenr) && (l == all_lines))
    { all_lines = l->link;
      my_free(l);
    }
    else
    { l->next = linenr; }
    switch (s->select)
    { case S_WITH :
        if (s->st.with.scop)
          s->st.with.scop->bis = linenr;
        break;
      case S_PARALLEL :
        if (s->st.parallel.scop)
          s->st.parallel.scop->bis = linenr;
        break;
      case S_LOAD :
      case S_STORE :
        if (s->st.load.scop)
          s->st.load.scop->bis = linenr;
        break;
    }
    if (linenr-p_start != s->zeilen)
    { fprintf(ausDatei,"\n");
      output_error(s->Zeile,s->zeilen,p_start,linenr-1);
    }
  }
}

vector_definition_ausgeben(g)
C_GROUP * g;
{ if (g)
  { if (g->link)
    { if (zeilenfuellung != 1)
        fprintf(ausDatei,"\n\t\t\t");
      zeilenfuellung = 2;
      fprintf(ausDatei," U(");
      vector_table(g);
      fprintf(ausDatei, " )");
      zeilenfuellung++;
    }
    else
    { vector_table(g); }
  }
}

vector_table(g)
C_GROUP * g;
{ if (g)
  { if (g->link)
    { vector_table(g->link);
      fprintf(ausDatei," ,\n\t\t\t");
    }
    fprintf(ausDatei," I%d",g->dims);
    zeilenfuellung++;
    definition_ausgeben(g->vectors->vector, g->vectors->hvarsvect,0);
  }
}    

adjusting(g)
C_GROUP * g;
{ if (g)
  { if (g->link)
    { int i;
      C_GROUP * g1 = g->link;
      adjusting(g1);
      for (i = BOOLEAN; i < ALL; i++)
        g->vectors->ControlVarAnz[i] = g1->vectors->ControlVarAnz[i] + 
                                       g1->vectors->LocalVarAnz[i];
      adjust_vector_vars(g->vectors->vector,g->vectors);
      adjust_vector_vars(g->vectors->dim,g->vectors);
      adjust_vector_hvars(g->vectors->hvarsvect,g->vectors);
    }
  }
}

adjust_vector_vars(var,st)
Eintrag * var;
ST * st;
{ if (var)
  { adjust_vector_vars(var->link,st);
    var->param.var.nummer += st->ControlVarAnz[var->param.var.art];
  }
}

adjust_vector_hvars(var,st)
HVARS * var;
ST * st;
{ if (var)
  { adjust_vector_hvars(var->link,st);
    adjust_vector_vars(var->ein,st);
  }
}

declaration_ausgeben(d)
T_DECLARATIONS * d;
{ if (d)
  { declaration_ausgeben(d->link);
    if (d->select == N_PROCEDURE)
      proceduren_ausgeben(d->art.procs);
  }
}

/* ************************************************************************* */
/* Ausgabeeiner Parallaxis-Prozedur/Funktion als PARZ-Kode                   */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Prozedurzeiger                                                */
/*                                                                           */
/* ************************************************************************* */

proceduren_ausgeben(p)
T_PROCEDECL * p;
{ T_PARAM * pa;
  if (p != NULL)
  { int start, flag, flag1;
    LINENR * l, * l1;
    C_GROUP * conf = NULL;
    start = linenr;
    p->scop->von = linenr;
    adjusting(p->confs);
    if (p->confs)
    { conf = conf_groups = p->confs; }
    declaration_ausgeben(p->decls);
    p->scop->entry = linenr;
    protokolliere = p->protokollart;
    p->start = linenr;
    p->end = linenr + p->zeilen - 1;
    proc_return = p->end - 1 + p->complex -
                  ((p->reference->param.proz.debug && debug_trace_flag) ?
                   ((p->type) ? 2 : 1) : 0);
    zeilennummer(0);            
    fprintf(ausDatei,"PROC %d ",proc_ebene = (akt_ST = p->ST)->Ebene);
    zeilenfuellung = 1;
    indent_tab = "\t\t\t";
    if ((akt_ST->scalar != NULL) || (akt_ST->hvarsscal != NULL) || p->port_variables)
    { fprintf(ausDatei,"\n");
      zeilenfuellung = 0;
      fprintf(ausDatei,"\t\tSCALAR\t");
      zeilenfuellung = 2;
      if (p->port_variables > 0)
      { fprintf(ausDatei," I%d",p->port_variables); }
      else
      { zeilenfuellung = 1; }
      definition_ausgeben(akt_ST->scalar, akt_ST->hvarsscal,0);
    }
    if ((p->confs != NULL) || (akt_ST->vector != NULL) || (akt_ST->hvarsvect != NULL))
    { if (zeilenfuellung)
      { fprintf(ausDatei,"\n");
        zeilenfuellung = 0;
      }
      fprintf(ausDatei,"\t\tVECTOR\t");
      zeilenfuellung = 1;
      definition_ausgeben(akt_ST->vector, akt_ST->hvarsvect,0);
      vector_definition_ausgeben(p->confs);
    }
    fprintf(ausDatei,"\t;     %s",getstring(p->ident->wert.ident_nr));
#ifdef DEVELOP
fprintf(ausDatei," %d",p->zeilen);
#endif
    flag = flag1 = 0;
    while (conf)
    { if (conf->zeilen)
      { if (flag || (conf->proz_anz != proz_anz))
        { nozeilennummer();
          parallel_ausgeben(conf);
        }
        nozeilennummer();
        fprintf(ausDatei,"CALL %d;\tconnections",conf->initport);
        if (conf->proz_anz != proz_anz)
        { flag = 1; }
	flag1 = 1;
      }
      conf = conf->link;
    }
    if (flag)
      alle_parallel_ausgeben();
    neues_statement = 1;
    GET_MEM(l,1,LINENR);
    l->link = all_lines;
    all_lines = l;
    l->source = p->Zeile;
    l->drain = p->start;
    aktuelle_zeile = p->Zeile;
    if (p->reference->param.proz.debug && debug_trace_flag)
    { zeilennummer(0);
      fprintf(ausDatei,"WRITELN \"%s '%s'\";",text[(p->type == NULL) ? 333 : 331],
                       getstring(p->ident->wert.ident_nr));
    }
    if ((p->complex) && (p->type != NULL))
    { char sv;
      Eintrag * ein = p->hv->ein;
      zeilennummer(0);
      sv = (p->scavec->Art == _SCALAR) ? 'S' : 'V';
      fprintf(ausDatei,"POP%c %cI%d:%d;",sv,sv,ein->param.var.ebene,
                                           ein->param.var.nummer);
    }
    pa = p->paramseq;
    while (pa != NULL)
    { code_ausgeben(0,pa->code);
      pa = pa->link;
    }
    statements_ausgeben(p->statements);
    aktuelle_zeile = p->endzeile;
    neues_statement = 1;
    GET_MEM(l1,1,LINENR);
    l1->link = all_lines;
    all_lines = l1;
    l1->source = p->Zeile2;
    l1->drain = linenr;
    if ((p->hv != NULL) && (p->complex == 0))
    { Eintrag * ein = p->hv->ein;
      zeilennummer(0);
      fprintf(ausDatei,"PUSHV V%c%d:%d;",letter[ein->param.var.type->firstelem],
                                        ein->param.var.ebene,
                                        ein->param.var.nummer);
    }
    if (p->reference->param.proz.debug && debug_trace_flag)
    { if (p->type)
      { zeilennummer(0);
        fprintf(ausDatei,"DEBUG ");
        variable_ausgeben(p->hv,p->hv->dir_indir);
        fprintf(ausDatei," \"%s\" AS",text[335]);
        zeilenfuellung = 1;
        indent_tab = "\t\t\t";
        typdef_ausgeben(ausDatei,p->type->erg_typ,1l);
        fprintf(ausDatei,";");
      }
      zeilennummer(0);
      fprintf(ausDatei,"WRITELN \"%s '%s'\";",text[(p->type == NULL) ? 334 : 332],
                       getstring(p->ident->wert.ident_nr));
    }
    zeilennummer(0);
    if (flag1)
    { fprintf(ausDatei,"DISCONNECT;");
      nozeilennummer();
    }
    fprintf(ausDatei,"RETURN;     %s",getstring(p->ident->wert.ident_nr));
    p->scop->bis = l->next = l1->next = linenr;
    if ((p->end + 1) != linenr)
    { fprintf(ausDatei,"\n");
      procfirstline_error(p->ident->wert.ident_nr,p->end,linenr-1);
    }   
  }
}     

/* ************************************************************************* */
/* Ausgabe der Variablendefinition im PARZ-Kode                              */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Variablenkette                                                */
/*             Hilfsvariablenkette                                           */
/*             Summenanzahl zur Komprimierung gleicher PARZ-Typangaben       */
/*                                                                           */
/* ************************************************************************* */

definition_ausgeben(ein,z,anz)
Eintrag * ein;
HVARS * z;
int anz;
{ ST_TYPE * t1;
  if (ein != NULL)
  { t1 = ein->param.var.type;
    if (ein->link != NULL)
    { if ((match_typen(t1,ein->link->param.var.type,1) == JA) &&
          (ein->param.var.dir_indir == ein->link->param.var.dir_indir))
      { definition_ausgeben(ein->link,NULL,anz + 1); }
      else
      { definition_ausgeben(ein->link,NULL,0);
        if (ein->param.var.dir_indir != DIRECT)
        { typdef_ausgeben(ausDatei,typ_int,(long) anz + 1); }
        else
          typdef_ausgeben(ausDatei,t1,(long) anz + 1);
      }
    }
    else
    { if (ein->param.var.dir_indir != DIRECT)
      { typdef_ausgeben(ausDatei,typ_int,(long) anz + 1); }
      else
        typdef_ausgeben(ausDatei,t1,(long) anz + 1);
    }
  }
  while (z != NULL)
  { if (z->anz > 0)
    { if (z->typ == typ_s)
      { Eintrag * ein;
        ein = z->ein;
        while (ein != NULL)
        { typdef_ausgeben(ausDatei,ein->param.var.type,1l);
          ein = ein->link;
        }
      }
      else
      { typdef_ausgeben(ausDatei,z->typ,(long) z->anz); }
    }
    z = z->link;
  }
}

/* ************************************************************************* */
/* Ausgabe des Offsets bei Strukturzugriffen                                 */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Strukturtyp                                                   */
/*             Komponentennummer                                             */
/*                                                                           */
/* ************************************************************************* */

record_offset(typ,bis)
ST_TYPE * typ;
int bis;
{ int count = 0;
  ST_TYPE * t1;
  MEMBERS * m = typ->info.record.mem;
  while (m != NULL)
  { t1 = m->inh.typ;
    if (bis < (t1->used[ALL] + count))
    { if (bis > count)
      { if (t1->Art == ST_TVARIANT)
        { m = t1->info.record.mem;
          t1 = m->inh.typ;
          bis -= count;
          while (m && (t1->used[ALL] <= bis))
          { bis -= t1->used[ALL];
            if (m->flag)
            { m = NULL; }
            else
            { m = m->link;
              t1 = m->inh.typ;
            }
          }
          record_offset(t1,bis);
        }
        else
          record_offset(t1,bis-count);
      }
      return;
    }
    else
    { zeilenfuellung = 1;
      indent_tab = "\t\t\t";
      typdef_ausgeben(ausDatei,t1,1l);
      count += t1->used[ALL];
      if (m->flag)
      { m = NULL; }
      else
      { m = m->link; }
    }
  }
}

/* ************************************************************************* */
/* Ausgabe einer PARZ-Typdefinition                                          */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Ausgabedatei                                                  */
/*             Datentyp                                                      */
/*             Anzahl der Variablen von diesem Typ                           */
/*                                                                           */
/* ************************************************************************* */

typdef_ausgeben(datei,t,anz)
FILE * datei;
ST_TYPE * t;
long anz;
{ if (t->used[ALL] > 1)
  { if (zeilenfuellung >= (MAX_EXPR_LENGTH - 4))
    { fprintf(datei,"\n");
      zeilenfuellung = 0;
    }
    if (zeilenfuellung == 0)
    { fprintf(datei,"%s",indent_tab);
      zeilenfuellung++;
    }
    if (anz > 1)
    { fprintf(datei," %ld(",anz);
      zeilenfuellung++;
    }
    switch (t->Art)
    { case ST_TARRAY :
        if (t->info.array.bereich == typ_char)
        { typdef_ausgeben(datei,t->info.array.typ,(long)MAXCHAR + 1); }
        else
        { typdef_ausgeben(datei,t->info.array.typ,(long) elementezahl(t->info.array.bereich) + 1); }
        break;
      case ST_TRECORD :
      case ST_TRECORDREST :
        { MEMBERS * m = t->info.record.mem;
          long z = 1;
          while (m)
          { if ((m->link) && !m->flag)
            { if  (match_typen(m->inh.typ,m->link->inh.typ,0) == JA)
              { z++; }
              else
              { typdef_ausgeben(datei,m->inh.typ,z);
                z = 1;
              }
            }
            else
            { typdef_ausgeben(datei,m->inh.typ,z);
              z = 1;
            }
            if (m->flag)
            { m = NULL; }
            else
            { m = m->link; }
          }
        }
        break;
      case ST_TSET :
        fprintf(datei," B%d",t->used[ALL]);
        zeilenfuellung++;
        break;
      case ST_TVARIANT :
        { MEMBERS * m = t->info.record.mem;
          int f = 1;
          while (m)
          { if (f)
            { if (m->link)
              { fprintf(datei," U(");
                zeilenfuellung++;
                f = 0;
              }
            }
            else
            { fprintf(datei," ,");
              zeilenfuellung++;
            }
            typdef_ausgeben(datei,m->inh.typ,1l);
            if (m->flag)
            { m = NULL; }
            else
            { m = m->link; }
          }
          if (!f)
          { fprintf(datei," )");
            zeilenfuellung++;
          }
        }
        break;
      default :
        bug("typdef_ausgeben ohne Struktur");
        break;
    }
    if (zeilenfuellung == 0)
    { fprintf(datei,"%s",indent_tab);
      zeilenfuellung++;
    }
    if (anz > 1)
    { fprintf(datei," )");
      zeilenfuellung++;
    }
  }
  else
  { if (zeilenfuellung == 0)
    { fprintf(datei,"%s",indent_tab);
      zeilenfuellung++;
    }
    if (t->used[ALL] == 1)
    { switch (t->firstelem)
      { case BOOLEAN :
          fprintf(datei," B%ld",anz);
          break;
        case CHAR :
          fprintf(datei," C%ld",anz);
          break;
        case INTEGER :
          fprintf(datei," I%ld",anz);
          break;
        case REAL :
          fprintf(datei," R%ld",anz);
          break;
        default :
          break;
      }
      zeilenfuellung++;
    }
    else
    { bug("Datentyp mit 0 Elementen sollte nicht auftreten\n"); }
  }
  if (zeilenfuellung >= MAX_ZEILENBREITE)
  { fprintf(datei,"\n");
    zeilenfuellung = 0;
  }
}

/* ************************************************************************* */
/* Ausgabe der Pointer-Dereferenzierung                                      */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Feld-/Komponentenbeschreibung                                 */
/*                                                                           */
/* ************************************************************************* */

pointer_offset(ar,err,basis)
AR_COMP * ar;
int err;
VARNODE ** basis;
{ if (ar != NULL)
  { if ((ar->art == 2) && ar->ar.pointer.mode)
    { ZWCODE * zw = ar->ar.pointer.rest;
      if (pointer_check)
      { zeilennummer(err);
        fprintf(ausDatei,"IF ");
        if (*basis)
        { variable_ausgeben(*basis,(((*basis)->dir_indir == INDIRECT) ||
                                    ((*basis)->ein->param.var.dir_indir == INDIRECT)) ?
                                    ADRESS : DIRECT); }
        else
          variable_ausgeben(zw->com.zugriff.basis,DIRECT);
        fprintf(ausDatei," = NIL CALL %d;",check_pointer);
      }
      zeilennummer(err);
      variable_ausgeben(zw->com.zugriff.var, DIRECT);
      fprintf(ausDatei," := ");
      if (*basis)
      { int f = (*basis)->firstelem;
        (*basis)->firstelem = INTEGER;
        variable_ausgeben(*basis,DIRECT);
        (*basis)->firstelem = f;
	*basis = NULL;
      }
      else
      { int f = zw->com.zugriff.basis->firstelem;
        zw->com.zugriff.basis->firstelem = INTEGER;
        variable_ausgeben(zw->com.zugriff.basis,INDIRECT);
        zw->com.zugriff.basis->firstelem = f;
      }
      fprintf(ausDatei,";");
      ar->ar.pointer.mode = 0;
      code_ausgeben(err,zw);
    }
  }
}

/* ************************************************************************* */
/* Ausgabe der negativen Offsetteile eines Feld-/Strukturzugriffs            */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Feld-/Komponentenbeschreibung                                 */
/*                                                                           */
/* ************************************************************************* */

neg_offset(ar,m)
AR_COMP * ar;
int m;
{ if (ar != NULL)
  { if (m || ar->art != 2)
    { neg_offset(ar->link,0);
      if (ar->art == 0)
      { if (ar->ar.array.offset < 0)
          typdef_ausgeben(ausDatei,ar->ar.array.typ,(long) - ar->ar.array.offset);
      }
    }
  }
}

/* ************************************************************************* */
/* Ausgabe der positiven Offsetteile eines Feld-/Strukturzugriffs            */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Feld-/Komponentenbeschreibung                                 */
/*                                                                           */
/* ************************************************************************* */

pos_offset(ar,m)
AR_COMP * ar;
int m;
{ if (ar != NULL)
  { if (m || ar->art != 2)
    { pos_offset(ar->link,0);
      if (ar->art == 0)
      { if (ar->ar.array.offset > 0)
          typdef_ausgeben(ausDatei,ar->ar.array.typ,(long) ar->ar.array.offset);
      }
      else
      { if ((ar->art == 1) && (ar->ar.record.comp != 0))
          record_offset(ar->ar.record.typ,ar->ar.record.comp);
      }
    }
  }
}

/* ************************************************************************* */
/* Ausgabe der dynamischen Offsetteile eines Feld-/Strukturzugriffs          */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Feld-/Komponentenbeschreibung                                 */
/*             Hilfsvariable fuer den Zugriff                                */
/*             Basisvariable fuer den Zugriff                                */
/*             wurde Basisvariable bereits verwendet                         */
/*                                                                           */
/* ************************************************************************* */

expr_offset(err,ar,v,b,bas)
int err;
AR_COMP * ar;
VARNODE * v, * b;
int * bas;
{ int m = 0;
  while (ar != NULL)
  { if (m && (ar->art == 2))
      return;
    m = 1;
    if (ar->art == 0)
    { if (ar->ar.array.erg != NULL)
      { zeilennummer(err);
        variable_ausgeben(ar->ar.array.var,DIRECT);
        fprintf(ausDatei," := ");
        variable_ausgeben(ar->ar.array.erg,ar->ar.array.erg->dir_indir);
        fprintf(ausDatei," * SIZE(");
        zeilenfuellung = 1;
        indent_tab = "\t\t\t";
        typdef_ausgeben(ausDatei,ar->ar.array.typ,1l);
        fprintf(ausDatei," );");
        zeilennummer(err);
        variable_ausgeben(v,DIRECT);
        fprintf(ausDatei," := ");
        if (*bas)
          variable_ausgeben(v,DIRECT);
        else
          variable_ausgeben(b,ADRESS);
        *bas = 1;
        fprintf(ausDatei," + ");
        variable_ausgeben(ar->ar.array.var,DIRECT);
        fprintf(ausDatei,";");
      }
    }
    ar = ar->link;
  }
}

/* ************************************************************************* */
/* Ausgabe des Kodes zur Berechnung der Indexausdruecke                      */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Feld-/Komponentenbeschreibung                                 */
/*                                                                           */
/* ************************************************************************* */

expr_berechnen(err,ar)
int err;
AR_COMP * ar;
{ if (ar != NULL)
  { expr_berechnen(err,ar->link);
    if (ar->art == 0)
    { if (ar->ar.array.erg != NULL)
      { code_ausgeben(err,ar->ar.array.code);
        ar->ar.array.code = NULL;
      }
    }
  }
}

decl_prepare(d)
T_DECLARATIONS * d;
{ if (d)
  { decl_prepare(d->link);
    if (d->select == N_PROCEDURE)
    { group_prepare(d->art.procs->confs);
      decl_prepare(d->art.procs->decls);
    }
  }
}

group_prepare(g)
C_GROUP * g;
{ if (g)
  { group_prepare(g->link);
    do_ports(g);
    conf_prepare(g->conf,g);
  }
}

do_ports(g)
C_GROUP * g;
{ SINGLE_CON * e = g->einzel;
  int i, port_var = g->port_variable;
  if (port_var)
  { g->port_variable = linenr;
    zeilennummer(0);
    fprintf(ausDatei,"PROC %d",g->vectors->Ebene + 1);
    fprintf(ausDatei,"; group number %d", g->group_nr);
    for (i = 0; i < port_var; i++)
    { nozeilennummer();
      fprintf(ausDatei,"SI%d:%d := %d;",g->vectors->Ebene,i+1,e[i].epnr);
    }
    nozeilennummer();
    fprintf(ausDatei,"RETURN;\tgroup number : %d",g->group_nr);
  }
  if (g->zeilen)
  { g->initport = linenr;
    zeilennummer(0);
    fprintf(ausDatei,"PROC %d\n",g->vectors->Ebene + 1);
    if (g->temp)
    { fprintf(ausDatei,"\t\tSCALAR\t");
      zeilenfuellung = 1;
      definition_ausgeben(g->temp->scalar, g->temp->hvarsscal,0);
      if (zeilenfuellung)
      { fprintf(ausDatei,"\n");
        zeilenfuellung = 0;
      }
      fprintf(ausDatei,"\t\tVECTOR\t");
      zeilenfuellung = 1;
      definition_ausgeben(g->temp->vector, g->temp->hvarsvect,0);
    }
    fprintf(ausDatei,"; group number %d", g->group_nr);
    if (g->code)
    { nozeilennummer();
      fprintf(ausDatei,"PUSHV ADDR VI%d:%d;",g->vectors->Ebene + 1,g->max_dim + 1);
    }
    proc_ebene = ++g->vectors->Ebene;
    code_ausgeben(0,g->code);
    proc_ebene = --g->vectors->Ebene;
    if (g->code)
    { zeilennummer(0);
      fprintf(ausDatei,"POPV VI%d:%d;",g->vectors->Ebene + 1,g->max_dim + 1);
    }
    zeilennummer(0);
    fprintf(ausDatei,"RETURN;\tgroup number : %d",g->group_nr);
  }
}

conf_prepare(c,g)
C_CONF * c;
C_GROUP * g;
{ if (c)
  { conf_prepare(c->link,g);
    c->initdim = linenr;
    zeilennummer(0);
    fprintf(ausDatei,"PROC %d;\tconfiguration : %s",g->vectors->Ebene + 1,
                     getstring(c->name->name_nr));
    if (g->first_proz || g->proz_anz != proz_anz)
    { nozeilennummer();
      parallel_ausgeben(g);
    }
    if (g->port_variable)
    { nozeilennummer();
      fprintf(ausDatei,"CALL %d;\tconnections",g->port_variable);
    }
    dimis_berechnen(g,c,g->vectors->Ebene,g->vectors->ControlVarAnz[INTEGER],0);
    nozeilennummer();
    fprintf(ausDatei,"RETURN;\tconfiguration : %s",getstring(c->name->name_nr));
  }
}

dimis_berechnen(g,c,e,o1,m)
C_GROUP * g;
C_CONF * c;
int e, o1,m;
{ int i,o;
  o = o1 + 1;
  if (m)
    zeilennummer(1);
  else
    nozeilennummer();
  fprintf(ausDatei,"VI%d:%d := ID - %d; for %s %s",e,o,g->first_proz+1,
                   getstring(c->name->name_nr),text[75]);
  for (i = c->dims ; i > 1; i--)
  { nozeilennummer();
    fprintf(ausDatei,"VI%d:%d := VI%d:%d MOD %d;",e,i+o1,e,o,c->wert_faktoren[i-1]);
    if (c->wert_von[i-1] > 0)
    { nozeilennummer();
      fprintf(ausDatei,"VI%d:%d := VI%d:%d + %d;      DIM%d",e,i+o1,e,i+o1,c->wert_von[i-1],i);
    }
    else
    { if (c->wert_von[i-1] < 0)
      { nozeilennummer();
        fprintf(ausDatei,"VI%d:%d := VI%d:%d - %d;      DIM%d",e,i+o1,e,i+o1,-c->wert_von[i-1],i);
      }
      else
      { fprintf(ausDatei,"      DIM%d",i); }
    }
    nozeilennummer();
    fprintf(ausDatei,"VI%d:%d := VI%d:%d / %d;",e,o,e,o,c->wert_faktoren[i-1]);
  }
  if (c->wert_von[0] > 0)
  { nozeilennummer();
    fprintf(ausDatei,"VI%d:%d := VI%d:%d + %d;      DIM1",e,o,e,o,c->wert_von[0]);
  }
  else
  { if (c->wert_von[0] < 0)
    { nozeilennummer();
      fprintf(ausDatei,"VI%d:%d := VI%d:%d - %d;      DIM1",e,o,e,o,-c->wert_von[0]);
    }
    else
    { fprintf(ausDatei,"      DIM1"); }
  }
}

int group_lines(g)
C_GROUP * g;
{ int i = 0;
  while (g)
  { if (g->code)
    { if (i == 0)
      { i = 1; }
      i += g->zeilen + 3;
    }
    if (g->port_variable)
      i++;
    g = g->next;
  }
  return i;
}
