static char _sccsid[] = "Parallaxis Version: @(#)strings.c.c	2.13  15:10:05";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : strings.c                                                         */
/*                                                                           */
/* DEBUG- und TRACE-Texte erstellen                                          */
/*                                                                           */
/* ************************************************************************* */


#include "defines.h"
#include "parallax.h"
#include "typen.h"
#include "symbols.h"
#include "y_tab.h"
#include "makro.h"

extern char * getstring();
int zahl;           /* wieviele Zeichen koennen noch aufgenommen werden */
char * string_erg;  /* Zeiger auf den Text */

static char zahlen[20];   /* Platz zum Umwandeln von Zahlen */

/* ************************************************************************* */
/* erzeuge den String fuer DEBUG und TRACE Anweisungen                       */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Ausdruck                                                      */
/*                                                                           */
/* ************************************************************************* */

ST_CONST * erzeuge_string(ex)
T_EXPR * ex;
{ ST_CONST * c;
  T_EXPR * mem = ex->link;
  ex->link = NULL;
  GET_MEM(string_erg,MAX_EXPR_LENGTH + 1,char);
  zahl = MAX_EXPR_LENGTH;
  s_expr_ausgeben(ex);
  GET_MEM(c,1,ST_CONST);
  c->Art = ST_CSTRING;
  c->wert.s.string = (unsigned char *) string_erg;
  c->wert.s.len = my_strlen(string_erg);
  ex->link = mem;
  return c;
}

/* ************************************************************************* */
/* gehe an das Ende des Strings                                              */
/*                                                                           */
/* Ergebnis : Zeiger auf das Stringende                                      */
/*                                                                           */
/* Parameter : String                                                        */
/*                                                                           */
/* ************************************************************************* */

char * string_ende(s)
char * s;
{ register char * h = s;
  while (*h)
  { h++; }
  return h;
}

/* ************************************************************************* */
/* mache String aus Subrangebeschreibung                                     */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Subrangebeschreibung                                          */
/*                                                                           */
/* ************************************************************************* */

s_subrange_ausgeben(z)
T_SUBRANGE * z;
{ if (z != NULL)
  { if (z->link != NULL)
    { s_subrange_ausgeben(z->link);
      if (zahl > 0)
      { sprintf(string_ende(string_erg),",");
        zahl -= 1;
      }
    }
    if (z->von != NULL)
        /* von .. bis Bereich */
    { s_expr_ausgeben(z->von);
      if (zahl > 1)
      { sprintf(string_ende(string_erg),"..");
        zahl -= 2;
      }
    }
    s_expr_ausgeben(z->bis);
  }
}

/* ************************************************************************* */
/* mache String aus Selektionsbeschreibung                                   */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Selektionsbeschreibung                                        */
/*                                                                           */
/* ************************************************************************* */

s_select_ausgeben(z)
T_SELECT * z;
{ if (z != NULL)
  { if (z->ident)
    { if (zahl > 0)
        ident_ausgeben(z->ident->wert.ident_nr);
    }
    if (z->link != NULL)
    { s_select_ausgeben(z->link); }
    if (z->art == SE_NONE)
      return;
    if (zahl > 0)
    { sprintf(string_ende(string_erg),"[");
      zahl -= 1;
    }
    else
    { zahl = 0;
      return;
    }
    switch (z->art)
    { case SE_SUBRANGE :
        s_subrange_ausgeben(z->ranges);
        break;
      case SE_ALL :
        if (zahl > 0)
        { sprintf(string_ende(string_erg),"*");
          zahl -= 1;
        }
        else
        { zahl = 0;
          return;
        }
        break;
    }
    if (zahl > 0)
    { sprintf(string_ende(string_erg),"]");
      zahl -= 1;
    }
    else
    { zahl = 0;
      return;
    }
  }
}


/* ************************************************************************* */
/* mache String aus Ausdrucksbeschreibung                                    */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Ausdrucksbeschreibung                                         */
/*                                                                           */
/* ************************************************************************* */

s_expr_ausgeben(z)
T_EXPR * z;
{ if (z != NULL)
  { if (z->link != NULL)
    { s_expr_ausgeben(z->link);
      if (zahl > 0)
      { sprintf(string_ende(string_erg),",");
        zahl -= 1;
      }
      else
      { zahl = 0; 
        return;
      }
    }
    switch (z->select)
    { case E_BINOP :
        s_expr_ausgeben(z->factors.binop.expr1);
        switch (z->factors.binop.operator->Art)
        { case '=' :
          case '<' :
          case '>' :
          case '+' :
          case '-' :
          case '*' :
          case '/' :
            if (zahl > 0)
            { sprintf(string_ende(string_erg),"%c",z->factors.binop.operator->Art);
              zahl -= 1;
            }
            else
            { zahl = 0; 
              return;
            }
            break;
          case POWER :
            if (zahl > 1)
            { sprintf(string_ende(string_erg),"**");
              zahl -= 2;
            }
            else
            { zahl = 0; 
              return;
            }
            break;
          case UNEQ :
            if (zahl > 1)
            { sprintf(string_ende(string_erg),"<>");
              zahl -= 2;
            }
            else
            { zahl = 0; 
              return;
            }
            break;
          case LEEQ :
            if (zahl > 1)
            { sprintf(string_ende(string_erg),"<=");
              zahl -= 2;
            }
            else
            { zahl = 0; 
              return;
            }
            break;
          case GREQ :
            if (zahl > 1)
            { sprintf(string_ende(string_erg),">=");
              zahl -= 2;
            }
            else
            { zahl = 0; 
              return;
            }
            break;
          case _IN :
            if (zahl > 3)
            { sprintf(string_ende(string_erg)," IN ");
              zahl -= 4;
            }
            else
            { zahl = 0; 
              return;
            }
            break;
          case _MOD :
            if (zahl > 4)
            { sprintf(string_ende(string_erg)," MOD ");
              zahl -= 5;
            }
            else
            { zahl = 0; 
              return;
            }
            break;
          case _DIV :
            if (zahl > 4)
            { sprintf(string_ende(string_erg)," DIV ");
              zahl -= 5;
            }
            else
            { zahl = 0; 
              return;
            }
            break;
          case _AND :
            if (zahl > 4)
            { sprintf(string_ende(string_erg)," AND ");
              zahl -= 5;
            }
            else
            { zahl = 0; 
              return;
            }
            break;
          case _OR :
            if (zahl > 3)
            { sprintf(string_ende(string_erg)," OR ");
              zahl -= 4;
            }
            else
            { zahl = 0; 
              return;
            }
            break;
        }
        s_expr_ausgeben(z->factors.binop.expr2);
        break;

      case E_FUNC :
        ident_ausgeben(z->factors.funccall.funcident->wert.ident_nr);
        if (zahl > 0)
        { sprintf(string_ende(string_erg),"(");
          zahl--;
        }
        else
        { zahl = 0;
          return;
        }
        s_expr_ausgeben(z->factors.funccall.exprlist);
        if (zahl > 0)
        { sprintf(string_ende(string_erg),")");
          zahl--;
        }
        else
        { zahl = 0;
          return;
        }
        break;

      case E_DESIGN :
      case E_DESIGNAT :
        ident_ausgeben(z->factors.designator.ident->wert.ident_nr);
        s_designrest_ausgeben(z->factors.designator.selector);
        break;

      case E_SET :
        if (z->factors.sets.setident != NULL)
          ident_ausgeben(z->factors.sets.setident->wert.ident_nr);
        if (zahl > 0)
        { zahl--;
          sprintf(string_ende(string_erg),"{");
        }
        else
        { zahl = 0;
          return;
        }
        s_subrange_ausgeben(z->factors.sets.elements);
        if (zahl > 0)
        { zahl--;
          sprintf(string_ende(string_erg),"}");
        }
        else
        { zahl = 0;
          return;
        }
        break;

      case E_KLEXPR :
        if (zahl > 0)
        { zahl--;
          sprintf(string_ende(string_erg),"(");
        }
        else
        { zahl = 0;
          return;
        }
        s_expr_ausgeben(z->factors.klexpr);
        if (zahl > 0)
        { zahl--;
          sprintf(string_ende(string_erg),")");
        }
        else
        { zahl = 0;
          return;
        }
        break;

      case E_NOTEXPR :
        if (zahl > 3)
        { zahl -= 4;
          sprintf(string_ende(string_erg),"NOT ");
        }
        else
        { zahl = 0;
          return;
        }
        s_expr_ausgeben(z->factors.notexpr);
        break;

      case E_REDUCE :
        if (zahl > 6)
        { zahl -= 7;
          sprintf(string_ende(string_erg),"REDUCE.");
        }
        else
        { zahl = 0;
          return;
        }
        switch (z->factors.reduce.redident->Art)
        { case _AND :
            if (zahl > 3)
            { zahl -= 4;
              sprintf(string_ende(string_erg),"AND ");
            }
            else
            { zahl = 0;
              return;
            }
            break;
          case _OR :
            if (zahl > 3)
            { zahl -= 4;
              sprintf(string_ende(string_erg),"OR ");
            }
            else
            { zahl = 0;
              return;
            }
            break;
          case IDENT :
            ident_ausgeben(z->factors.reduce.redident->wert.ident_nr);
            break;
        }
        s_select_ausgeben(z->factors.reduce.select);
        if (zahl > 0)
        { zahl--;
          sprintf(string_ende(string_erg),"(");
        }
        else
        { zahl = 0;
          return;
        }
        s_expr_ausgeben(z->factors.reduce.expr);
        if (zahl > 0)
        { zahl--;
          sprintf(string_ende(string_erg),")");
        }
        else
        { zahl = 0;
          return;
        }
        break;

      case E_CONST :
        switch (z->factors.Const->Art)
        { case INTCONSTANT :
            sprintf(zahlen,"%d",z->factors.Const->wert.i);
            ident_ausdrucken(zahlen);
            break;
          case CHARCONSTANT :
            if (z->factors.Const->wert.c != '\"')
              sprintf(zahlen,"%c",z->factors.Const->wert.c);
            else
              sprintf(zahlen,"\"\"");
            ident_ausdrucken(zahlen);
            break;
          case REALCONSTANT :
            sprintf(zahlen,"%f",z->factors.Const->wert.r);
            ident_ausdrucken(zahlen);
            break;
          case STRINGCONSTANT :
            if (strchr(z->factors.Const->wert.s,'"') == NULL)
            { if (zahl > 1)
              { zahl -= 2;
                sprintf(string_ende(string_erg),"\"\"");
                ident_ausdrucken(z->factors.Const->wert.s);
                if (zahl > 1)
                { zahl -= 2;
                  sprintf(string_ende(string_erg),"\"\"");
                }
                else
                { zahl = 0;
                  return;
                }
              }
            }
            else
            { if (zahl > 0)
              { char *s = z->factors.Const->wert.s;
                zahl--;
                sprintf(string_ende(string_erg),"'");
                while ((zahl > 0) && (*s != '\0'))
                { if (*s == '\"')
                  { if (zahl > 1)
                    { sprintf(string_ende(string_erg),"\"\"");
                      zahl--;
                    }
                  }
                  else
                    sprintf(string_ende(string_erg),"%c",*s);
                  zahl--;
                  s++;
                }
              }
            }
        }
        break;

      case E_SINOP :
        if (zahl > 0)
        { zahl--;
          sprintf(string_ende(string_erg),"%c",z->factors.binop.operator->Art);
        }
        else
        { zahl = 0;
          return;
        }
        s_expr_ausgeben(z->factors.binop.expr2);
        break;
    }
  }
}

/* ************************************************************************* */
/* mache String aus Zugriffsbeschreibung                                     */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Zugriffsbeschreibung                                          */
/*                                                                           */
/* ************************************************************************* */

s_designrest_ausgeben(z)
T_DESIGNREST * z;
{ if (z != NULL)
  { if (z->link != NULL)
    { s_designrest_ausgeben(z->link); }
    if (z->select == D_ARRAY)
    { if (zahl > 0)
      { zahl--;
        sprintf(string_ende(string_erg),"[");
      }
      else
      { zahl = 0;
        return;
      }
      s_expr_ausgeben(z->design.exprlist);
      if (zahl > 0)
      { zahl--;
        sprintf(string_ende(string_erg),"]");
      }
      else
      { zahl = 0;
        return;
      }
    }
    else
    { if (z->select == D_RECORD)
      { if (zahl >0)
        { zahl--;
          sprintf(string_ende(string_erg),".");
        }
        ident_ausgeben(z->design.ident->wert.ident_nr);
      }
      else
      { if (zahl >0)
        { zahl--;
          sprintf(string_ende(string_erg),"^");
        }
      }
    }
  }
}

/* ************************************************************************* */
/* trage Namen in den String ein                                             */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Name                                                          */
/*                                                                           */
/* ************************************************************************* */

ident_ausgeben(inr)
long inr;
/*char * i;*/
{ char * i = getstring(inr);
  ident_ausdrucken(i);
}

ident_ausdrucken(i)
char * i;
{ int l;
  char s[5];
  if (zahl >= (l = my_strlen(i)))
  { sprintf(string_ende(string_erg),"%s",i);
    zahl -= l;
    return;
  }
  if (zahl <= 0) return;
  sprintf(s,"%%%ds",zahl);
  sprintf(string_ende(string_erg),s,i);
  zahl = 0;
}
