%{
static char _sccsid[] = "Parallaxis Version: @(#)v2.y	2.13  2/28/92 14:20:47";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Der Parser von Parallaxis                                                 */
/*                                                                           */
/* ************************************************************************* */


# include "defines.h"
# include "typen.h"
# include "makro.h"
# include "parallax.h"
# include "symbols.h"
# include "conf.h"
# include "procs.h"

extern char * perrortext[];  /* 'erwartet wird' Fehlermeldungstexte */
extern int parseerror[];
extern ST_TYPE * typ_int;

#define EBENENOFFSET 1       /* Symboltabellenoffset */
int selecting_poss = 0;      /* ist Selktion moeglich */
int parallel = 0;            /* innerhalb eines PARALLEL-Blocks ? */
int new_parallel = 0;        /* Vergleich f"ur ENDPARALLEL-Erzeugung */
int fieldlistident = 1;      /* Parser ist ausserhalb einer Fieldlist */
int key_nr = 0;              /* welche ENDkeywords muessen erzeugt werden ? */
int ende = -1;               /* wird ein END erwartet ? */
int nur_int_zahl = 0;        /* num. als num und . und nicht als realnum */
int leeres_statement = 0;    /* leere Anweisung reduziert ? */
T_SYSTEM * programm;         /* die Wurzel des Programms */
int yytyp;                   /* Typ von Namen bei Symboltabelleneintraegen */
int Zeile, Posit;            /* Positionsangaben bei Fehlermeldungen */
extern int  yylineno2, sp_pos2; /* Positionsangaben bei Fehlermeldungen */
char dim_name[12];           /* String um DIM1, DIM2 etc. zu erzeugen */
int proc_info = 0;           /* Procedure enthaelt syntaktische Information darueber, ob
                                die Procedure skalar oder vektoriell ist */
int no_proz;                  /* Procedure oder nicht */
int proc_info_zeile, proc_info_posit; /* Positionsangabe dazu */
int proc_mode = 0;            /* Informationen "uber die Proceduren */
int proc_parall;              /* Parallelblock ist begonnen */
int proc_parall_zeile, proc_parall_posit; /* Positionsangabe dazu */
int proc_parall_count;        /* Zaehler fuer fehlerhafte Parallelbloecke */
int statement_error; /* vermerken, ob eine Fehlermeldung erfolgt ist */
int parsestate = 0;           /* Parserzustand fuer die Fehlermeldung */
int memo = -1;                /* Speicher f"ur Spezialtoken */
int akt_conf_group = 0;       /* Nummer der Konfigurationsgruppe */
extern C_GROUP * all_groups;  /* alle Konfigurationsgruppen */
C_GROUP * conf_groups = NULL; /* Liste der Konfigurationen */
extern ST * all_tables;

%}

%union {
    SCAN_ELEM * t_scan_elem;
    T_SYSTEM * t_system;
    T_DECLARATIONS * t_Declarations;
    T_CONSTDECL * t_Constdecl;
    T_TYPEDECL * t_Typedecl;
    T_CONFIG * t_config;
    T_TRANSFER * t_transfer;
    T_CONN * t_conn;
    T_VARDEF * t_vardef;
    T_PROCEDECL * t_procedecl;
    T_STATEMENT * t_statement;
    T_TYPE * t_type;
    T_SUBRANGE * t_subrange;
    T_SOURCE * t_source;
    T_DESTINATION * t_destination;
    T_IDENTLIST * t_identlist;
    T_EXPR * t_expr;
    T_DESIGNREST * t_designrest;
    T_PARAM * t_param;
    T_SELECT * t_select;
    T_ELSIF * t_elsif;
    T_SENDDIR * t_senddir;
    T_IO_IDENT * t_io_ident;
    T_CASES * t_cases;
    T_CASELABEL * t_caselabel;
    T_RECDEF * t_recdef;
    T_VARIANT * t_variant;
       }

%token  <t_scan_elem> '(' ')' '*' '+' ',' '-' '.' '/' ':' ';' '<' '=' '>' '@' '[' ']' '^'
%token  <t_scan_elem> '{' '|' '}' '&' '~' '#'
%token  <t_scan_elem> _AND               
%token  <t_scan_elem> _ARRAY             
%token  <t_scan_elem> _BEGIN             
%token  <t_scan_elem> _BY                
%token  <t_scan_elem> _CASE              
%token  <t_scan_elem> _CONFIGURATION     
%token  <t_scan_elem> _CONNECTION        
%token  <t_scan_elem> _CONST             
%token  <t_scan_elem> _DIV               
%token  <t_scan_elem> _DO                
%token  <t_scan_elem> _ELSE  
%token  <t_scan_elem> _ELSIF            
%token  <t_scan_elem> _END               
%token  <t_scan_elem> _ENDPARALLEL        
%token  <t_scan_elem> _EXIT              
%token  <t_scan_elem> _FOR
%token  <t_scan_elem> _FROM
%token  <t_scan_elem> _IF                
%token  <t_scan_elem> _IN                
%token  <t_scan_elem> _LOAD              
%token  <t_scan_elem> _LOOP              
%token  <t_scan_elem> _MOD               
%token  <t_scan_elem> _NOT               
%token  <t_scan_elem> _OF                
%token  <t_scan_elem> _OR                
%token  <t_scan_elem> _PARALLEL          
%token  <t_scan_elem> _POINTER
%token  <t_scan_elem> _PROCEDURE         
%token  <t_scan_elem> _PROPAGATE         
%token  <t_scan_elem> _RECEIVE
%token  <t_scan_elem> _RECORD          
%token  <t_scan_elem> _REDUCE
%token  <t_scan_elem> _REPEAT            
%token  <t_scan_elem> _RETURN            
%token  <t_scan_elem> _SCALAR            
%token  <t_scan_elem> _SEND               
%token  <t_scan_elem> _SET               
%token  <t_scan_elem> _STORE          
%token  <t_scan_elem> _SYSTEM            
%token  <t_scan_elem> _THEN              
%token  <t_scan_elem> _TO                
%token  <t_scan_elem> _TYPE              
%token  <t_scan_elem> _UNTIL             
%token  <t_scan_elem> _VAR               
%token  <t_scan_elem> _VECTOR            
%token  <t_scan_elem> _WHILE             
%token  <t_scan_elem> _WITH              
%token  <t_scan_elem> GREQ            /* >= */
%token  <t_scan_elem> IS              /* := */
%token  <t_scan_elem> LEEQ            /* <= */
%token  <t_scan_elem> PP              /* .. */
%token  <t_scan_elem> ARROW           /* -> */
%token  <t_scan_elem> ARROW2          /* <-> */
%token  <t_scan_elem> UNEQ            /* <> */
%token  <t_scan_elem> POWER           /* ** */
%token  <t_scan_elem> IDENT
%token  <t_scan_elem> INTCONSTANT
%token  <t_scan_elem> REALCONSTANT
%token  <t_scan_elem> CHARCONSTANT
%token  <t_scan_elem> STRINGCONSTANT
%token  COMMENT         /* Kommentarendezeichen */
%token  ENDOFFILE       /* DateiEnde erreicht */
%token  ENDBEGIN
%token  ENDCONST
%token  ENDSYSTEM
%token  ENDEND
%token  DOLLAR

%type <t_scan_elem> system sys_ident Identsemi Name_point intvarConst
%type <t_scan_elem> relation AddOperator sign MulOperator arrow
%type <t_scan_elem> OperatorIdent parallel propagate paraende
%type <t_scan_elem> load store reduce send receive p_reduce
%type <t_system> System
%type <t_Declarations> Declarations VariableDecls
%type <t_Constdecl> ConstantDecls ConstantDefs ConstantDef
%type <t_Typedecl> TypeDecls TypeDefs TypeDef
%type <t_config> ConfigDefs ConfigDef ConfigDecls
%type <t_transfer> TransferFuncs TransferFunc TransferFuncts
%type <t_conn>  ConnectDecls
%type <t_vardef> VarDefs VarDef
%type <t_recdef> FieldListSeq FieldList ElseVariant
%type <t_variant> Variants Variant
%type <t_procedecl> ProcedureDecl ProcedureDef procedurehead FormalParams
%type <t_statement> hauptblock block StatementSeq statement ElseSelect assignment if_select while_select
%type <t_statement> proprest1 proprest2
%type <t_type> type SimpleType SimpleTypes
%type <t_subrange> destranges ranges range subrange subranges
%type <t_cases> cases case
%type <t_caselabel> caselabellist caselabel
%type <t_source> sources source
%type <t_destination> destinations destination
%type <t_identlist> opt_ident IdentList
%type <t_expr> discriminant elsif_selection Increm SimpleExpr
%type <t_expr> term power factor set ExprList expr
%type <t_designrest> designator_rest
%type <t_expr> designator ZusatzIdent klammerexpr
%type <t_param> parameters Paramseqs Paramseq _scalar_var _vector_var
%type <t_select> selection selections
%type <t_elsif> ElsIfSelect
%type <t_io_ident> in_ident out_ident
%type <t_scan_elem> _scalar _vector scalar_vector

%%

System
                :   system
                        { key_nr = 1; proc_info = proc_info_zeile = 0; }
                    Declarations
                        { key_nr = 2; }
                    hauptblock
                        { key_nr = 3; }
                    Name_point
                        { build_system($1,$3,$5,$7); }
                ;
Declarations
                :   Declarations ConstantDecls
                        { if ($2 != NULL)
                          { T_DECLARATIONS * hi;
                            GET_MEM(hi,1,T_DECLARATIONS);
                            hi->select = N_CONSTANT;
                            hi->art.Const = $2;
                            hi->link = $1;
                            $$ = hi;
                          }
                          else
                            $$ = $1;
                        }
                |   Declarations TypeDecls
                        { if ($2 != NULL)
                          { T_DECLARATIONS * hi;
                            GET_MEM(hi,1,T_DECLARATIONS);
                            hi->select = N_TYPE;
                            hi->art.Type = $2;
                            hi->link = $1;
                            $$ = hi;
                          }
                          else
                            $$ = $1;
                        }
                |   Declarations ConfigDecls
                        { if ($2 != NULL)
                          { T_DECLARATIONS * hi;
                            GET_MEM(hi,1,T_DECLARATIONS);
                            hi->select = N_CONFIGURATION;
                            hi->art.conf = $2;
                            hi->link = $1;
                            $$ = hi;
                          }
                          else
                            $$ = $1;
                        }
                |   Declarations ConnectDecls
                        { if ($2 != NULL)
                          { T_DECLARATIONS * hi;
                            GET_MEM(hi,1,T_DECLARATIONS);
                            hi->select = N_INPUT;
                            hi->art.conn = $2;
                            hi->link = $1;
                            $$ = hi;
                          }
                          else
                            $$ = $1;
                        }
                |   Declarations VariableDecls
                        { if ($2 != NULL)
                          { $2->link = $1;
                            $$ = $2;
                          }
                          else
                            $$ = $1;
                        }
                |   Declarations ProcedureDecl
                        { if ($2 != NULL)
                          { T_DECLARATIONS * hi;
                            GET_MEM(hi,1,T_DECLARATIONS);
                            hi->select = N_PROCEDURE;
                            hi->art.procs = $2;
                            hi->link = $1;
                            $$ = hi;
                          }
                          else
                            $$ = $1;
                        }
                |   ConstantDecls
                        { if ($1 != NULL)
                          { T_DECLARATIONS * hi;
                            GET_MEM(hi,1,T_DECLARATIONS);
                            hi->select = N_CONSTANT;
                            hi->art.Const = $1;
                            hi->link = NULL;
                            $$ = hi;
                          }
                          else
                            $$ = NULL;
                        }
                |   TypeDecls
                        { if ($1 != NULL)
                          { T_DECLARATIONS * hi;
                            GET_MEM(hi,1,T_DECLARATIONS);
                            hi->select = N_TYPE;
                            hi->art.Type = $1;
                            hi->link = NULL;
                            $$ = hi;
                          }
                          else
                            $$ = NULL;
                        }
                |   ConfigDecls
                        { if ($1 != NULL)
                          { T_DECLARATIONS * hi;
                            GET_MEM(hi,1,T_DECLARATIONS);
                            hi->select = N_CONFIGURATION;
                            hi->art.conf = $1;
                            hi->link = NULL;
                            $$ = hi;
                          }
                          else
                            $$ = NULL;
                        }
                |   ConnectDecls
                        { if ($1 != NULL)
                          { T_DECLARATIONS * hi;
                            GET_MEM(hi,1,T_DECLARATIONS);
                            hi->select = N_INPUT;
                            hi->art.conn = $1;
                            hi->link = NULL;
                            $$ = hi;
                          }
                          else
                            $$ = NULL;
                        }
                |   VariableDecls
                        { $$ = $1; }
                |   ProcedureDecl
                        { if ($1 != NULL)
                          { T_DECLARATIONS * hi;
                            GET_MEM(hi,1,T_DECLARATIONS);
                            hi->select = N_PROCEDURE;
                            hi->art.procs = $1;
                            hi->link = NULL;
                            $$ = hi;
                          }
                          else
                            $$ = NULL;
                        }
                ;

hauptblock
                :   _begin StatementSeq ENDEND { ende = 2; } _END
                        { ende = -1;
                          parallel = new_parallel = 0;
                          yyerrok;
                          $$ = $2;
                        }
                |   _begin StatementSeq accENDBEGIN
                        { SYNERROR;
                          fehler(text[106]); ende  = -1;
                          $$ = $2;
                          parallel = new_parallel = 0;
                        }
                |   error accENDBEGIN
                        { fehler(text[107]);
                          $$ = NULL;
                          parallel = new_parallel = 0;
                        }
                ;
                          
_begin
                :   _BEGIN
                        { ende = 0; }
                ;

system
                :   error ENDSYSTEM
                        { fehler(text[108]);
                          $$ = NULL;
                        }
                |   error _SYSTEM fehler1
                    sys_ident ENDSYSTEM
                        { $$ = $4;
                        }
                |   error _SYSTEM fehler1 error ENDSYSTEM
                        { $$ = NULL;
                        }
                |   _SYSTEM sys_ident ENDSYSTEM
                        { $$ = $2;
                        }
                |   _SYSTEM sys_ident error ENDSYSTEM
                        { fehler("");
                          $$ = $2;
                        }
                |   _SYSTEM ENDSYSTEM
                        { fehler(text[109]);
                          $$ = NULL;
                        }
                ;

fehler1
                :   { fehler(text[110]); }
                ;

sys_ident
                :   IDENT ';' 
                        { $$ = $1;
                          ident_eintragen($1,N_SYSTEM);
                        }
                |   error ';'
                        { fehler(text[109]);
                          $$ = NULL;
                        }
                |   IDENT error ';'
                        { fehler(text[112]);
                          $$ = $1;
                          ident_eintragen($1,N_SYSTEM);
                        }                  
                |   IDENT error ENDSYSTEM
                        { fehler("");
                          $$ = $1;
                          ident_eintragen($1,N_SYSTEM);
                        }
                ;

ConstantDecls
                :   _CONST 
                        { key_nr = 0;
                        }
                    ConstantDefs ENDSYSTEM
                        { $$ = $3;
                          key_nr = 1;
                          Const_eintragen($$);
                        }
                |   ENDSYSTEM
                        { $$ = NULL; key_nr = 1; }
                |   error ENDSYSTEM
                        { fehler("");
                          $$ = NULL; key_nr = 1; 
                        }
                |   ENDCONST
                        { $$ = NULL; key_nr = 2; }
                |   error ENDCONST
                        { fehler("");
                          $$ = NULL; key_nr = 2; 
                        }
                ;

TypeDecls
                :   _TYPE
                        { key_nr = 0;
                        }
                    TypeDefs ENDSYSTEM
                        { $$ = $3;
                          key_nr = 1;
                          Type_eintragen($$);
                        }
                ;

ConfigDecls
                :   _CONFIGURATION
                        { key_nr = 0;
                          if (akt_ST->confselect > 1)
                          { SEMERROR($1->Zeile,$1->Posit,0,0,
                                     text[163]); /* neuer Text */
                            akt_ST->confselect = 1;
                          }
                          else if (!akt_ST->confselect)
                          { ST * t = akt_ST->Obertabelle;
                            akt_ST->confselect = 1;
                            while (t && (t->confselect == 0))
                            { t->confselect = 2;
                              t = t->Obertabelle;
                            }
                            if (t)
                            { if (t->confselect == 1)
                              { SEMERROR($1->Zeile,$1->Posit,0,0,
                                         text[164]); /* neuer Text */
                              }
                            }
                          }
                          proc_info |= PI_SCALAR;
                          if (proc_info_zeile == 0)
                          { proc_info_zeile = $1->Zeile;
                            proc_info_posit = $1->Posit;
                          }
                        }
                    ConfigDefs ENDSYSTEM
                        { C_GROUP * gr;
                          ST * vst = vector_ST;
                          $$ = $3;
                          key_nr = 1;
                          GET_MEM(vector_ST,1,ST);
                          vst->others = vector_ST;
                          GET_MEM(gr,1,C_GROUP);
                          vector_ST->Ebene = akt_ST->Ebene;
                          vector_ST->is_vector = 1;
                          if ($3)
                          { int i,j, art, dummy;
                            T_CONFIG * c = $3;
                            long nr;
                            Eintrag * rueck;
                            j = 0;
                            while (c)
                            { if (c->ranges)
                                j = (j > c->ranges->count) ? j : c->ranges->count;
                              c = c->link;
                            }
                            for (i = 1; i <= j; i++)
                            { sprintf(dim_name,"DIM%d",i);
                              art = IDENT; enterstring(dim_name,&nr,&art);
                              vector_ST->Obertabelle = akt_ST;
                              if (rueck = suche_Eintrag(nr,akt_ST,LOCAL,0))
                              { if ((rueck->Art != N_SPEZIAL_VEK) && (rueck->Art != N_UNDEF))
                                { SEMERROR(rueck->Zeile,rueck->Posit,
                                           $$->ident->Zeile,$$->ident->Posit,text[113]);
                                  rueck->Art = N_UNDEF;
                                }
                              }
                              vector_ST->Obertabelle = NULL;
                              vector_ST->is_vector = 0;
                              rueck = mache_Eintrag(nr,&dummy,N_SPEZIAL_VEK);
                              if (dummy != JA)
                              { rueck->param.var.dir_indir = DIRECT;
                                rueck->param.var.art = INTEGER;
                                rueck->param.var.type = typ_int;
                                rueck->param.var.used = 1;
                                rueck->param.var.nummer = ++(vector_ST->LocalVarAnz[ALL]);
                                rueck->param.var.ebene = vector_ST->Ebene;
                                vector_ST->LocalVarAnz[INTEGER] = vector_ST->LocalVarAnz[ALL];
                              }
                              
                            }
                          }
                          vector_ST->is_vector = 1;
                          vector_ST->Obertabelle = akt_ST;
                          vector_ST->link = all_tables;
                          all_tables = vector_ST;
                          gr->next = all_groups;
                          all_groups = gr;
                          gr->link = conf_groups;
                          gr->vectors = vector_ST;
                          gr->temp = neue_ST(vector_ST,1);
                          all_tables = all_tables->link;
                          conf_groups = gr;
                          gr->group_nr = ++akt_conf_group;
                          Config_eintragen($$);
                        }
                ;

ConnectDecls
                :   _CONNECTION
                        { key_nr = 0;
                        }
                    TransferFuncts ENDSYSTEM
                        { key_nr = 1;
                          Transfer_eintragen($3);
                          GET_MEM($$,1,T_CONN);
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                          $$->trans = $3;
                          $$->timestamp = timestamp;
                        }
                ;

VariableDecls
                :   _SCALAR
                        { key_nr = 0;
                        }
                    VarDefs ENDSYSTEM
                        { if ($3 != NULL)
                          { T_DECLARATIONS * hi;
                            GET_MEM(hi,1,T_DECLARATIONS);
                            hi->select = N_SCALAR;
                            hi->Zeile = $1->Zeile;
                            hi->Posit = $1->Posit;
                            hi->art.ska_var = $3;
                            hi->link = NULL;
                            $$ = hi;
                          }
                          else
                            $$ = NULL;
                          Vardef_eintragen($3,N_SCALAR);
                          key_nr = 1;
                        }
                |   _VECTOR
                        { key_nr = 0;
                          proc_mode |= VECTOR_VARS;
                        }
                    VarDefs ENDSYSTEM
                        { if ($3 != NULL)
                          { T_DECLARATIONS * hi;
                            GET_MEM(hi,1,T_DECLARATIONS);
                            hi->select = N_VECTOR;
                            hi->Zeile = $1->Zeile;
                            hi->Posit = $1->Posit;
                            hi->art.vek_var = $3;
                            hi->link = NULL;
                            $$ = hi;
                          }
                          else
                            $$ = NULL;
                          Vardef_eintragen($3,N_VECTOR);
                          key_nr = 1;
                        }
                ;


ProcedureDecl
                :   ProcedureDef ENDSYSTEM
                        { $$ = $1;
                          key_nr = 1;
                        }
                ;

ConfigDefs
                :   ConfigDefs ConfigDef
                        { if ($2)
                          { $2->link = $1;
                            $$ = $2;
                          }
                          else
                          { $$ = $1; }
                        }
                |   ConfigDef
                        { $$ = $1; }
                ;

ConfigDef
                :   IDENT ranges tsemicolon
                        { MAKE_CONFIG(&$$,$1,$2);
                          proc_mode |= CONF_DIR;
                        }
                |   error
                        { fehler(text[115]); }
                ;

ProcedureDef
                :   _PROCEDURE
                        { key_nr = 0; }
                    procedurehead
                        { key_nr = 1; }
                    Declarations
                        { key_nr = 2; }
                    block
                    Identsemi
                        { struct c_group * g;
                          int p_mode = $3->proc_mode;
                          key_nr = 0;
                          $$ = $3;
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                          $$->decls = $5;
                          $$->statements = $7;
                          g = $$->confs;
                          $$->confs = conf_groups;
                          conf_groups = g;
                          if (((proc_info & PI_SCALAR) == 0) && (proc_info & PI_VECTORVAR))
                            proc_info |= PI_VECTOR;
                          $$->proc_mode = proc_mode | proc_mode_anal($5);
                          proc_mode = p_mode;
                          p_mode = $$->proc_info;
                          $$->proc_info = proc_info;
                          proc_info = p_mode;
                          proc_info_zeile = proc_parall = proc_parall_count = 0;
                          vector_ST = $$->ST;
                          akt_ST = ($$->ST = akt_ST)->Obertabelle;
                          if ($8)
                            $$->Zeile2 = $8->Zeile;
                          if ($$->ident == NULL)
                          { $$->ident = $8;
                            ident_eintragen($8,N_PROCEDURE);
                          }
                          else
                          { if ($8 != NULL)
                            { $$->endzeile = $8->Zeile;
                              if ($$->ident->wert.ident_nr != $8->wert.ident_nr)
                              { SEMERROR($$->ident->Zeile, $$->ident->Posit, $8->Zeile, $8->Posit,
                                         text[118]);
                              }
                            }
                          }
                          $$->last_index = timestamp;
                        }                                       
                ;

procedurehead
                :   IDENT FormalParams ';'
                        { $$ = $2;
                          Procedure_eintragen($1,$$);
                          $$->proc_info = proc_info;
                          proc_info = 0;
                        }
                |   error
                        { fehler(text[119]); }
                    FormalParams ';'
                        { $$ = $3;
                          Procedure_eintragen(NULL,$$);
                          $$->proc_info = proc_info;
                          proc_info = 0;
                        }
                |   IDENT FormalParams error
                        { fehler("");
                          $$ = $2;
                          Procedure_eintragen($1,$$);
                          $$->proc_info = proc_info;
                          proc_info = 0;
                        }
                |   error
                        { fehler(text[120]);
                          GET_MEM($$,1,T_PROCEDECL);
                          $$->ident = NULL;
                          $$->paramseq = NULL;
                          $$->type = NULL;
                          $$->ST = vector_ST;
                          vector_ST = akt_ST = neue_ST(akt_ST,EBENENOFFSET);
                          $$->proc_info = proc_info;
                          $$->proc_mode = proc_mode;
                          proc_mode = proc_info = 0;
                        }
                ;

Identsemi
                :   IDENT ';' Identsemiende
                        { $$ = $1; }
                |   IDENT error ';' Identsemiende
                        { fehler(text[121]);
                          $$ = $1;
                        }
                |   IDENT error Identsemiende
                        { fehler("");
                          $$ = $1;
                        }
                |   error Identsemiende
                        { fehler(text[119]);
                          $$ = NULL;
                        }
                |   Identsemiende
                        { SYNERROR;
                          fehler(text[119]);
                          $$ = NULL;
                        }
                ;

Identsemiende
                :   ENDSYSTEM
                |   ENDEND
                        { ende = 2; }
                ;

Name_point
                :   IDENT '.' read_to_end accENDOFFILE
                        { $$ = $1; }
                |   IDENT error read_end accENDOFFILE
                        { fehler("");
                          $$ = $1;
                        }
                |   error '.' read_to_end accENDOFFILE
                        { fehler(text[122]);
                          $$ = NULL;
                        }
                |   error read_end accENDOFFILE
                        { fehler(text[122]);
                          $$ = NULL;
                        }
                |   accENDOFFILE
                        { SYNERROR;
                          fehler(text[122]);
                          $$ = NULL;
                        }
                ;

read_to_end
                :   /* nichts */
                |   error
                        { ende = 2;
                          fehler(text[123]);
                        }
                ;

read_end
                :   /* nichts */
                |   read_end ENDEND { ende = 2; } error
                        { fehler(text[123]); }
                ;

TransferFuncts
                :   ';' ENDSYSTEM
                        { $$ = NULL; }
                |   ';' error ENDSYSTEM
                        { fehler("");
                          $$ = NULL;
                        }
                |   TransferFuncs ENDSYSTEM
                        { $$ = $1; }
                ;

TransferFuncs
                :   TransferFuncs TransferFunc
                        { if ($2 == NULL)
                          { $$ = $1; }
                          else
                          { $$ = $2;
                            $$->link = $1;
                          }
                        }
                |   TransferFunc
                        { $$ = $1;
                        }
                |   TransferFuncs error
                        { fehler(text[125]);
                          $$ = $1;
                        }
                |   error
                        { fehler(text[125]);
                          $$ = NULL;
                        }
                ;

tsemicolon
                :   ';'
                        { yyerrok; }
                |   ENDSYSTEM
                        { SYNERROR;
                          fehler("expected: ';'");
                        }
                ;

TransferFunc
                :   out_ident ':' IDENT '[' sources ']' arrow destinations tsemicolon
                        { MAKE_TRANSFER(&$$,$1,$3,$5,$7,$8); }
                ;

arrow
                :   ARROW
                        { $$ = $1; }
                |   ARROW2
                        { $$ = $1; }
                ;

out_ident
                :   IDENT
                        { MAKE_IO_IDENT(&$$,$1,NULL); }
                |   IDENT '(' intvarConst ')'
                        { MAKE_IO_IDENT(&$$,$1,$3); }
                ;

intvarConst
                :   INTCONSTANT
                        { $$ = $1; }
                |   IDENT
                        { $$ = $1; }
                ;

block
                :   _Begin StatementSeq ENDEND
                        { ende = 2; }
                    _END
                        { yyerrok; ende = -1;
                          $$ = $2;
                          parallel = new_parallel = 0;
                        }
                |   _Begin StatementSeq ENDSYSTEM
                        { SYNERROR;
                          fehler(text[156]);
                          $$ = $2;
                          parallel = new_parallel = 0;
                        }
                |   error ENDSYSTEM
                        { fehler(text[126]);
                          $$ = NULL;
                          parallel = new_parallel = 0;
                        }
                ;

_Begin
                :   _BEGIN
                        { yyerrok;
                          key_nr = 0;
                          ende = 0;
                        }
                ;
  
destranges
                :   destranges ',' subrange
                        { if ($3 == NULL)
                          { $$ = $1; }
                          else
                          { $$ = $3;
                            if ($1 != NULL)
                              $$->count = $1->count + 1;
                            else
                              $$->count = 1;
                            $$->link = $1;
                          }
                        }
                |   subrange
                        { $$ = $1;
                          if ($$ != NULL)
                            $$->count = 1;
                        }
                |   destranges ',' error
                        { fehler(text[127]);
                          $$ = $1;
                        }
                |   destranges error
                        { fehler(""); }
                    subrange
                        { $$ = $1; }
                |   error
                        { fehler(text[127]);
                          $$ = NULL;
                        }
                ;

ranges
                :   ranges ',' range
                        { if ($3 == NULL)
                          { $$ = $1; }
                          else
                          { $$ = $3;
                            if ($1 != NULL)
                              $$->count = $1->count + 1;
                            else
                              $$->count = 1;
                            $$->link = $1;
                          }
                        }
                |   range
                        { $$ = $1;
                          if ($$ != NULL)
                            $$->count = 1;
                        }
                |   ranges ',' error
                        { fehler(text[127]);
                          $$ = $1;
                        }
                |   ranges error
                        { fehler(""); }
                    range
                        { $$ = $1; }
                |   error
                        { fehler(text[127]);
                          $$ = NULL;
                        }
                ;

range
                :   '[' subrange rb
                        { $$ = $2; }
                |   '[' error
                        { fehler(text[127]);
                          $$ = NULL;
                        }
                ;

subrange
                :   expr
                        { MAKE_SUBRANGE(&$$,NULL,$1); }
                |   expr PP expr
                        { MAKE_SUBRANGE(&$$,$1,$3); }
                ;

sources
                :   sources ',' source
                        { $$ = $3;
                          $$->link = $1;
                          if ($1 != NULL)
                            $$->count = $1->count + 1;
                          else
                            $$->count = 1;
                        }
                |   sources error source
                        { fehler("");
                          $$ = $3;
                          $$->link = $1;
                          if ($1 != NULL)
                            $$->count = $1->count + 1;
                          else
                            $$->count = 1;
                        }
                |   sources error
                        { fehler("");
                          $$ = $1;
                        }
                |   sources ',' error
                        { fehler(text[129]);
                          $$ = $1;
                        }
                |   source 
                        { $$ = $1; }
                |   error
                        { fehler(text[129]);
                          $$ = NULL;
                        }
                ;

source
                :   IDENT
                        { GET_MEM($$,1,T_SOURCE);
                          $$->link = NULL;
                          $$->count = 1;
                          $$->wert = $1;
                        }
                |   INTCONSTANT
                        { GET_MEM($$,1,T_SOURCE);
                          $$->link = NULL;
                          $$->count = 1;
                          $$->wert = $1;
                        }
                ;

destinations
                :   destinations ',' destination
                        { $$ = $3;
                          $$->link = $1;
                        }
                |   destinations error
                        { fehler(""); }
                    destination
                        { $$ = $4;
                          $$->link = $1;
                        }
                |   destinations error
                        { fehler("");
                          $$ = $1;
                        }
                |   destinations ',' error
                        { fehler(text[130]);
                          $$ = $1;
                        }
                |   destination 
                          { $$ = $1; }
                |   error
                        { fehler(text[130]);
                          $$ = NULL;
                        }
                ;

destination
                :   discriminant IDENT '[' destranges ']' '.' in_ident
                        { GET_MEM($$,1,T_DESTINATION);
                          $$->link = NULL;
                          $$->discexpr = $1;
                          $$->conf_ident = $2;
                          $$->in_ident = $7;
                          $$->exprlist = $4;
                        }
                ;

rb
                :   ']'
                       { yyerrok; }
                |   error
                        { fehler(""); }
                ;

semicolon
                :   ';'
                        { yyerrok; }
                |   error
                        { fehler(""); }
                ;

in_ident        :   IDENT
                        { MAKE_IO_IDENT(&$$,$1,NULL); }
                |   IDENT '(' intvarConst ')'
                        { MAKE_IO_IDENT(&$$,$1,$3); }
                |   error
                        { fehler(text[131]);
                          $$ = NULL;
                        }
                ;

discriminant
                :   '{' expr '}'
                        { $$ = $2; }
                |   '{' expr 
                        { SYNERROR;
                          fehler(text[159]);
                          $$ = $2;
                        }
                |   '{' error
                        { fehler(text[132]); }
                    '}'
                        { yyerrok;
                          $$ = NULL;
                        }
                |   /* nichts */
                        { $$ = NULL; }
                ;

ConstantDefs
                :   ConstantDefs ConstantDef
                        { if ($2 == NULL)
                          { $$ = $1; }
                          else
                          { $$ = $2;
                            $$->link = $1;
                          }
                        }
                |   /* nichts */  { $$ = NULL; }
                ;
 
ConstantDef
                :   IDENT '=' expr semicolon
                        { MAKE_CONSTDECL(&$$,$1,$3); }
                |   error
                        { fehler(text[133]);
                          $$ = NULL;
                        }
                ;

TypeDefs
                :   TypeDefs TypeDef
                        { if ($2 == NULL)
                          { $$ = $1; }
                          else
                          { $$ = $2;
                            $$->link = $1;
                          }
                        }
                |   /* nichts */  { $$ = NULL; }
                ;

TypeDef
                :   IDENT '=' type semicolon
                        { MAKE_TYPEDECL(&$$,$1,$3); }
                |   error
                        { fehler(text[134]);
                          $$ = NULL;
                        }
                ;

VarDefs
                :   VarDefs VarDef ';'
                        { $$ = $2;
                          $$->link = $1;
                        }
                |   VarDefs VarDef error
                        { fehler("");
                          $$ = $2;
                          $$->link = $1;
                        }
                |   VarDefs error
                        { fehler(text[135]);
                          $$ = $1;
                        }
                |   /* nichts */
                        { $$ = NULL; }
                ;

VarDef
                :   IdentList ':' type
                        { GET_MEM($$,1,T_VARDEF);
                          $$->link = NULL;
                          $$->ident_list = $1;
                          $$->type = $3;
                        }
                ;

IdentList
                :   IdentList ',' IDENT
                        { MAKE_IDENTLIST1(&$$,$1,$3); }
                |   IDENT
                        { MAKE_IDENTLIST2(&$$,$1); }
                ;

parameters
                :   _scalar_var VarDef
                        { $$ = $1;
                          $$->vardef = $2;
                        }
                |   _scalar_var error
                        { fehler(text[135]);
                          $$ = $1;
                          $$->vardef = NULL;
                        }
                |   _vector_var VarDef
                        { $$ = $1;
                          $$->vardef = $2;
                        }
                |   _vector_var error
                        { fehler(text[135]);
                          $$ = $1;
                          $$->vardef = NULL;
                        }
                ;

FormalParams
                :   '(' Paramseqs ')' ':' scalar_vector type
                        { MAKE_PROCEDECL(&$$,$2,$5,$6); }
                |   '(' Paramseqs ')'
                        { MAKE_PROCEDECL(&$$,$2,NULL,NULL); }
                |   '(' Paramseqs error ':'
                        { fehler(""); }
                    scalar_vector type
                        { MAKE_PROCEDECL(&$$,$2,$6,$7); }
                |   '(' Paramseqs error
                        { fehler("");
                          MAKE_PROCEDECL(&$$,$2,NULL,NULL);
                        }
                |   /* nichts */
                        { MAKE_PROCEDECL(&$$,NULL,NULL,NULL); }
                ;

Paramseqs
                :   Paramseq
                        { $$ = $1; }
                |   /* nichts */
                        { $$ = NULL; }
                ;

Paramseq
                :   Paramseq ';' parameters
                        { if ($3 == NULL)
                          { $$ = $1; }
                          else
                          { $$ = $3;
                            $$->link = $1;
                          }
                        }
                |   parameters
                        { $$ = $1; }
                ;

scalar_vector
                :   _scalar
                        { $$ = $1; }
                |   _vector
                        { $$ = $1; }
                ;

scalar_or_vector             
                :   ENDSYSTEM
                        { key_nr = 1; }
                ;

_scalar
                :   scalar_or_vector _SCALAR
                        { $$ = $2;
                          $$->Art = _SCALAR;
                          yyerrok;
                          key_nr = 0;
                        }
                ;

_vector
                :   scalar_or_vector _VECTOR
                        { $$ = $2;
                          $$->Art = _VECTOR;
                          yyerrok;
                          key_nr = 0;
                        }
                ;

_scalar_var
                :   _scalar _VAR
                        { MAKE_PARAM(&$$, P_SCALAR | P_VAR);
                          yytyp = N_SCALAR + N_VAR;
                        }
                |   _scalar
                        { MAKE_PARAM(&$$, P_SCALAR);
                          yytyp = N_SCALAR;
                        }
                ;

_vector_var
                :   _vector _VAR
                        { MAKE_PARAM(&$$, P_VECTOR | P_VAR);
                          yytyp = N_VECTOR + N_VAR;
                        }
                |   _vector
                        { MAKE_PARAM(&$$, P_VECTOR);
                          yytyp = N_VECTOR;
                        }
                ;

StatementSeq
                :   StatementSeq ';' statement
                        { if ($3 == NULL)
                          { $$ = $1; }
                          else
                          { $$ = $3;
                            $$->link = $1;  
                          }
                          selecting_poss = 0;
                        }
                |   statement
                        { $$ = $1;
                          nur_int_zahl = 0;
                          selecting_poss = 0;
                        }
                |   StatementSeq error
                        { int spez = 0;
                          nur_int_zahl = 0;
                          if (leeres_statement == 0)
                          { fehler(text[136]);
                          }
                          else
                            fehler("");
                          while((yychk[yyact[yychar + yypact[yystate]]] != yychar) && spez)
                          {
#ifdef DEBUG
                            if (yydebug) printf("werfe das Zeichen %d weg\n",yychar);
#endif
                            yychar = -1;
                            yyyylex(yystate);
                            if ((yychar >= ENDOFFILE) && (yychar <= ENDEND)) spez = 0;
                          }
                        }
                    statement
                        { if ($4 == NULL)
                          { $$ = $1; }
                          else
                          { $$ = $4;
                            $$->link = $1;  
                          }
                          selecting_poss = 0;
                        }
                |   StatementSeq ';' error
                        { fehler(text[136]);
                          $$ = $1;
                          nur_int_zahl = 0;
                          selecting_poss = 0;
                        }
                |   error
                        { fehler(text[136]);
                          $$ = NULL;
                          nur_int_zahl = 0;
                          selecting_poss = 0;
                        }  
                ;

if_select
                :   _IF expr _THEN
                        { SET_IF_SEL(&$$,$1,$2); }
                |   _IF error _THEN
                        { fehler(text[137]);
                          SET_IF_SEL(&$$,$1,NULL);
                        }
                |   _IF error
                        { fehler(text[138]);
                          SET_IF_SEL(&$$,$1,NULL);
                        }
                |   _IF expr error
                        { fehler("");
                          SET_IF_SEL(&$$,$1,$2);
                        }
                ;

while_select
                :   _WHILE expr _DO
                        { SET_WHILE(&$$,$2);
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                        }
                |   _WHILE error _DO
                        { fehler(text[137]);
                          SET_WHILE(&$$,NULL);
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                        }
                |   _WHILE error
                        { fehler(text[140]);
                          SET_WHILE(&$$,NULL);
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                        }
                |   _WHILE expr error
                        { fehler("");
                          SET_WHILE(&$$,$2);
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                        }
                ;

assignment
                :   IDENT IS expr
                        { T_EXPR * des;
                          MAKE_DESIGN(&des,$1,NULL);
                          leeres_statement = 1;
                          SET_ASSIGN(&$$,des,$3);
                        }
                |   IDENT '='
                        { SYNERROR;
                          fehler(text[141]);
                        }
                    expr
                        { T_EXPR * des;
                          MAKE_DESIGN(&des,$1,NULL);
                          leeres_statement = 1;
                          SET_ASSIGN(&$$,des,$4);
                        }
                ;

statement
                :   designator IS expr
                        { leeres_statement = 1;
                          SET_ASSIGN(&$$,$1,$3);
                        }
                |   designator '='
                        { SYNERROR;
                          fehler(text[141]);
                        }
                    expr
                        { leeres_statement = 1;
                          SET_ASSIGN(&$$,$1,$4);
                        }
                |   IDENT
                        { leeres_statement = 1;
                          SET_PROC(&$$,$1,NULL);
                        }
                |   IDENT '(' ExprList klammer_zu
                        { SET_PROC(&$$,$1,$3);
                          leeres_statement = 1;
                        }
                |   if_select StatementSeq ElsIfSelect ElseSelect stateende
                        { if ($4 && $4->select == S_NICHTS)
                            $4 = NULL;
                          SET_IF(&$$,$1,$2,$3,$4);
                          leeres_statement = 1;
                        }
                |   _CASE expr _OF cases ElseSelect stateende
                        { SET_CASE(&$$,$2,$4,$5);
                          leeres_statement = 1;
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                        }
                |   while_select StatementSeq stateende
                        { $$ = $1;
                          $$->st.whiledo.statements = $2;
                          leeres_statement = 1;
                        }
                |   _REPEAT StatementSeq _UNTIL expr
                        { leeres_statement = 1;
                          SET_REPEAT(&$$,$2,$4);
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                        }
                |   _REPEAT StatementSeq _UNTIL error
                        { fehler(text[137]);
                          leeres_statement = 1;
                          SET_REPEAT(&$$,$2,NULL);
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                        }
                |   _REPEAT StatementSeq Flag
                        { SYNERROR;
                          fehler(text[142]); 
                          leeres_statement = 1;
                          SET_REPEAT(&$$,$2,NULL);
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                        }
                |   _REPEAT StatementSeq ENDEND
                        { SYNERROR;
                          fehler(text[142]); 
                          leeres_statement = 1;
                          SET_REPEAT(&$$,$2,NULL);
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                        }
                |   _LOOP StatementSeq stateende
                        { SET_LOOP(&$$,$2);
                          leeres_statement = 1;
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                        }
                |   _FOR assignment _TO expr Increm _DO StatementSeq stateende
                        { SET_FOR(&$$,$2,$4,$5,$7);
                          leeres_statement = 1;
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                        }
                |   _FOR assignment _TO expr Increm error
                        { fehler("");
                        }
                    StatementSeq stateende
                        { SET_FOR(&$$,$2,$4,$5,$8);
                          leeres_statement = 1;
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                        }
                |   _WITH designator _DO StatementSeq stateende
                        { SET_WITH(&$$,$2,$4);
                          leeres_statement = 1;
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                        }
                |   _WITH designator error
                        { fehler("");
                        }
                    StatementSeq stateende
                        { SET_WITH(&$$,$2,$5);
                          leeres_statement = 1;
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                        }
                |   _EXIT
                        { leeres_statement = 1;
                          MAKE_STATEMENT(&$$,S_EXIT);
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                        }
                |   _RETURN expr
                        { leeres_statement = 1;
                          SET_RETURN(&$$,$2);
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                        }
                |   _RETURN
                        { leeres_statement = 1;
                          SET_RETURN(&$$,NULL);
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                        }
                |   parallel selection StatementSeq ENDEND { --parallel; } paraende
                        { SET_PARALLEL(&$$,$1,$2,$3);
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                          if ($6)
                            $$->st.parallel.Zeile2 = $6->Zeile;
                          if (proc_parall_count == 0)
                          { proc_parall = 0; }
                          else
                          { $$->error = 1; }
                          leeres_statement = 1;
                          selecting_poss = 0;
                        }
                |   propagate '.' IDENT '(' proprest1 p_reduce
                        { fill_propagate($$ = $5,$1,$3,NULL,$6); }
                |   propagate '.' IDENT '.' proprest2 p_reduce
                        { fill_propagate($$ = $5,$1,$3,NULL,$6); }
                |   propagate '.' IDENT '^' intvarConst '(' proprest1 p_reduce
                        { fill_propagate($$ = $7,$1,$3,$5,$8); }
                |   propagate '.' IDENT '^' intvarConst '.' proprest2 p_reduce
                        { fill_propagate($$ = $7,$1,$3,$5,$8); }
                |   send IDENT '.' IDENT '(' expr ')' klammerexpr _TO IDENT '.' IDENT '(' expr ')' klammerexpr p_reduce
                        { SET_PROPAGATE(&$$,$1,$2,$4,(($8) ? $6 : NULL),NULL,
                                        $10,$12,(($16) ? $14 : NULL),
                                        (($8) ? $8 : $6),
                                        (($16) ? $16 : $14),$17);
                          $$->error = statement_error;
                          statement_error = 0;
                          leeres_statement = 1;
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                        }
                |   receive IDENT '.' IDENT '(' expr ')' klammerexpr _FROM IDENT '.' IDENT '(' expr ')' klammerexpr p_reduce
                        { SET_PROPAGATE(&$$,$1,$2,$4,(($8) ? $6 : NULL),NULL,
                                        $10,$12,(($16) ? $14 : NULL),
                                        (($8) ? $8 : $6),
                                        (($16) ? $16 : $14),$17);
                          $$->error = statement_error;
                          statement_error = 0;
                          leeres_statement = 1;
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                        }
                |   load selection '(' designator ',' designator ZusatzIdent klammer_zu
                        { SET_LOAD(&$$,$1,$2,$4,$6,$7);
                          $$->error = statement_error;
                          statement_error = 0;
                          leeres_statement = 1;
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                          selecting_poss = 0;
                        }
                |   store selection '(' designator ',' designator ZusatzIdent klammer_zu
                        { SET_STORE(&$$,$1,$2,$4,$6,$7);
                          $$->error = statement_error;
                          statement_error = 0;
                          leeres_statement = 1;
                          $$->Zeile = $1->Zeile;
                          $$->Posit = $1->Posit;
                          selecting_poss = 0;
                        }
                |   /* nichts */
                        { leeres_statement = 0;
                          $$ = NULL;
                          nur_int_zahl = 0;
                        }
                ;

klammerexpr
                :   '(' expr ')'
                        { $$ = $2; }
                |   /* nichts */
                        { $$ = NULL; }
                ;

proprest1
                :   expr ')' '^' intvarConst '.' proprest2
                        { $$ = $6;
                          $$->st.propagate.senddir->expr = $1;
                          $$->st.propagate.senddir->anzahl = $4;
                        }
                |   expr ')' '.' proprest2
                        { $$ = $4;
                          $$->st.propagate.senddir->expr = $1;
                        }
                |   expr ')' '(' expr ')'
                        { SET_PROPAGATE(&$$,NULL,NULL,NULL,$1,NULL,NULL,NULL,NULL,NULL,$4,NULL); }
                |   expr ')' '(' expr ',' designator ')'
                        { SET_PROPAGATE(&$$,NULL,NULL,NULL,$1,NULL,NULL,NULL,NULL,$4,$6,NULL); }
                |   expr ')'
                        { SET_PROPAGATE(&$$,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,$1,NULL); }
                |   expr ',' designator ')'
                        { SET_PROPAGATE(&$$,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,$1,$3,NULL); }
                ;

proprest2
                :   IDENT '(' expr ')'
                        { SET_PROPAGATE(&$$,NULL,NULL,NULL,NULL,NULL,NULL,$1,NULL,NULL,$3,NULL); }
                |   IDENT '(' expr ')' '(' expr ')'
                        { SET_PROPAGATE(&$$,NULL,NULL,NULL,NULL,NULL,NULL,$1,$3,NULL,$6,NULL); }
                |   IDENT '(' expr ')' '(' expr ',' designator ')'
                        { SET_PROPAGATE(&$$,NULL,NULL,NULL,NULL,NULL,NULL,$1,$3,$6,$8,NULL); }
                |   IDENT '(' expr ',' designator ')'
                        { SET_PROPAGATE(&$$,NULL,NULL,NULL,NULL,NULL,NULL,$1,NULL,$3,$5,NULL); }
                ;

parallel
                :   _PARALLEL
                        { $$ = $1;
                          selecting_poss = 1;
                          parallel++; new_parallel++;
                          proc_mode |= SELEKTION;
                          if (proc_info & PI_VECTOR)
                          { SEMERROR($1->Zeile,$1->Posit,proc_info_zeile,proc_info_posit,
                                     text[144]);
                          }
                          else
                          { if (proc_parall == P_PARAL)
                            { SEMERROR($1->Zeile,$1->Posit,
                                       proc_parall_zeile,proc_parall_posit,
                                       text[145]);
                              proc_parall_count++;
                            }
                            else
                            { proc_parall = P_PARAL;
                              proc_info |= PI_SCALAR | PI_VECTOR;
                              proc_parall_count = 1;
                              if (proc_info_zeile == 0)
                              { proc_info_zeile = $1->Zeile;
                                proc_info_posit = $1->Posit;
                              }
                            }
                          }
                        }
                ;

propagate
                :   _PROPAGATE
                        { $$ = $1;
                          proc_mode |= DATA_EXCHANGE;
                          if (((proc_info & PI_VECTOR) == 0) && no_proz)
                          { SEMERROR($1->Zeile,$1->Posit,proc_info_zeile,proc_info_posit,
                                     text[146]);
                            statement_error = 1;
                          }
                          else
                          { if (proc_info_zeile == 0)
                            { proc_info |= PI_VECTOR;
                              proc_info_zeile = $1->Zeile;
                              proc_info_posit = $1->Posit;
                            }
                          }
                          proc_info |= PI_REDUCE;
                        }
                ;

send
                :   _SEND
                        { $$ = $1;
                          proc_mode |= DATA_EXCHANGE;
                          if (((proc_info & PI_VECTOR) == 0) && no_proz)
                          { SEMERROR($1->Zeile,$1->Posit,proc_info_zeile,proc_info_posit,
                                     text[146]);
                            statement_error = 1;
                          }
                          else
                          { if (proc_info_zeile == 0)
                            { proc_info |= PI_VECTOR;
                              proc_info_zeile = $1->Zeile;
                              proc_info_posit = $1->Posit;
                            }
                          }
                          proc_info |= PI_REDUCE;
                        }
                ;

receive
                :   _RECEIVE
                        { $$ = $1;
                          proc_mode |= DATA_EXCHANGE;
                          if (((proc_info & PI_VECTOR) == 0) && no_proz)
                          { SEMERROR($1->Zeile,$1->Posit,proc_info_zeile,proc_info_posit,
                                     text[146]);
                            statement_error = 1;
                          }
                          else
                          { if (proc_info_zeile == 0)
                            { proc_info |= PI_VECTOR;
                              proc_info_zeile = $1->Zeile;
                              proc_info_posit = $1->Posit;
                            }
                          }
                          proc_info |= PI_REDUCE;
                        }
                ;

reduce
                :   _REDUCE
                        { $$ = $1;
                          selecting_poss = 2;
                          proc_mode |= USES_REDUCE;
                          proc_info |= PI_REDUCE;
                        }
                ;

load
                :   _LOAD
                        { $$ = $1;
                          selecting_poss = 2;
                          proc_mode |= LOAD_STORE;
                          proc_info |= PI_REDUCE;
                        }
                ;

store
                :   _STORE
                        { $$ = $1;
                          selecting_poss = 2;
                          proc_mode |= LOAD_STORE;
                          proc_info |= PI_REDUCE;
                        }
                ;

stateende
                :   Flag
                        { SYNERROR;
                          fehler(text[156]); 
                          leeres_statement = 1;
                        }
                |   ENDEND { ende = 2; } _END
                        { leeres_statement = 1;
                          ende = 0;
                        }
                ;

paraende
                :   Flag
                        { SYNERROR;
                          fehler(text[157]);
                          leeres_statement = 1;
                          if (--proc_parall_count == 0)
                          { proc_info &= ~PI_VECTOR;
                            proc_parall = 0;
                          }
                          new_parallel--;
                          $$ = NULL;
                        }
                |   _ENDPARALLEL
                        { leeres_statement = 1;
                          if (--proc_parall_count == 0)
                          { proc_info &= ~PI_VECTOR; 
                            proc_parall = 0;
                          }
                          $$ = $1;
                        }
                |   ENDEND
                        { SYNERROR;
                          fehler(text[157]);
                          leeres_statement = 1;
                          if (--proc_parall_count == 0)
                          { proc_info &= ~PI_VECTOR;
                            proc_parall = 0;
                          }
                          new_parallel--;
                          $$ = NULL;
                        }
                ;

klammer_zu
                :   ')'
                        { leeres_statement = 1; }
                |   ENDEND
                        { SYNERROR;
                          fehler(text[158]);
                          leeres_statement = 1;
                        }
                |   error
                        { fehler("");
                          leeres_statement = 1;
                        }
                ;

p_reduce
                :   _REDUCE '.' OperatorIdent
                        { $$ = $3; }
                |   /* nichts */
                        { $$ = NULL; }
                ;

ZusatzIdent
                :   ',' designator
                        { $$ = $2; }
                |   /* nichts */
                        { $$ = NULL; }
                ;

selections
                :   selections ',' '[' subranges ']'
                        { SET_SE_SUBRANGE(&$$,$1,$4);
                          $$->count = $1->count + 1;
                        }
                |   selections ',' '[' '*' ']'
                        { MAKE_SELECT(&$$,SE_ALL,$1);
                          $$->count = $1->count + 1;
                        }
                |   '[' subranges ']'
                        { SET_SE_SUBRANGE(&$$,NULL,$2);
                          if (((proc_info & (PI_SELECT | PI_SCALAR)) == 0) &&
                              ((proc_info & (PI_VECTOR | PI_VECTORVAR))))
                          { if (statement_error == 0)
                              SEMERROR($1->Zeile,$1->Posit,0,0,
                                       text[152]);
                            statement_error = 1;
                          }
                          proc_info |= PI_SELECT;
                          $$->count = 1;
                        }
                |   '[' '*' ']'
                        { MAKE_SELECT(&$$,SE_ALL,NULL);
                          if (((proc_info & (PI_SELECT | PI_SCALAR)) == 0) &&
                              ((proc_info & (PI_VECTOR | PI_VECTORVAR))))
                          { if (statement_error == 0)
                              SEMERROR($1->Zeile,$1->Posit,0,0,
                                       text[152]);
                            statement_error = 1;
                          }
                          proc_info |= PI_SELECT;
                          $$->count = 1;
                        }
                ;

selection
                :   selections
                        { $$ = $1;
                          proc_mode |= SELEKTION;
                          selecting_poss = 0;
                        }
                |   DOLLAR IDENT selections
                        { $$ = $3;
                          $$->ident = $2;
                          proc_mode |= SELEKTION;
                          selecting_poss = 0;
                        }
                |   DOLLAR IDENT
                        { MAKE_SELECT(&$$,SE_NONE,NULL);
                          $$->ident = $2;
                          proc_mode |= SELEKTION;
                          selecting_poss = 0;
                        }
                |   /* nichts */
                        { selecting_poss = 0;
                          $$ = NULL;
                        }
                ;

subranges
                :   subranges ',' subrange
                        { $$ = $3;
                          $$->link = $1;
                          $$->count = 1 + $1->count;
                        }
                |   subrange
                        { $$ = $1; }
                ;

designator
                :   IDENT designator_rest
                        { MAKE_DESIGN(&$$,$1,$2); }
                ;

designator_rest
                :   designator_rest '[' ExprList ']'
                        { Zeile = $2->Zeile;
                          Posit = $2->Posit;
                          MAKE_DESIGNREST_ARRAY(&$$,$1,$3);
                          $$->Zeile = $2->Zeile;
                          $$->Posit = $2->Posit;
                        }
                |   designator_rest '.' IDENT
                        { Zeile = $2->Zeile;
                          Posit = $2->Posit;
                          MAKE_DESIGNREST_RECORD(&$$,$1,$3);
                          $$->Zeile = $2->Zeile;
                          $$->Posit = $2->Posit;
                        }
                |   designator_rest '^'
                        { Zeile = $2->Zeile;
                          Posit = $2->Posit;
                          MAKE_DESIGNREST_DEREF(&$$,$1,$2);
                          $$->Zeile = $2->Zeile;
                          $$->Posit = $2->Posit;
                        }
                |   /* nichts */ { $$ = NULL; }
                ;


ElsIfSelect
                :   ElsIfSelect elsif_selection StatementSeq
                        { GET_MEM($$,1,T_ELSIF);
                          $$->link = $1;
                          $$->expr = $2;
                          $$->statements = $3;
                        }
                |   /* nichts */
                        { $$ = NULL; }
                ;

elsif_selection
                :   _ELSIF expr _THEN
                        { $$ = $2; }
                |   _ELSIF error _THEN
                        { fehler(text[137]);
                          $$ = NULL;
                        }
                |   _ELSIF error
                        { fehler(text[138]);
                          $$ = NULL;
                        }
                |   _ELSIF expr error
                        { fehler("");
                          $$ = $2;
                        }
                ;

ElseSelect
                :   _ELSE StatementSeq
                        { if ($2)
                          { $$ = $2; }
                          else
			  { T_STATEMENT * s;
                            GET_MEM(s,1,T_STATEMENT);
                            s->select = S_NICHTS;
                            $$ = s;
                          }
                        }
                |   /* nichts */
                        { $$ = NULL; }
                ;

cases
                :   cases '|' case
                        { if ($3)
                          { $$ = $3;
                            $$->link = $1;
                          }
                          else
                            $$ = $1;
                        }
                |   case
                        { $$ = $1; }
                ;

case
                :   caselabellist ':' StatementSeq
                        { GET_MEM($$,1,T_CASES);
                          $$->link = NULL;
                          $$->caselabel = $1;
                          $$->statements = $3;
                        }
                |   error
                        { fehler(text[160]);
                          $$ = NULL;
                        }
                ;

caselabellist
                :   caselabellist ',' caselabel
                        { $$ = $3;
                          $$->link = $1;
                        }
                |   caselabel
                        { $$ = $1; }
                ;

caselabel
                :   expr PP expr
                        { GET_MEM($$,1,T_CASELABEL);
                          $$->von = $1;
                          $$->bis = $3;
                        }
                |   expr
                        { GET_MEM($$,1,T_CASELABEL);
                          $$->von = $1;
                          $$->bis = NULL;
                        }
                ;

Increm
                :   _BY expr
                        { $$ = $2; }
                |   /* nichts */
                        { $$ = NULL; }
                ;

type
                :   SimpleType
                        { $$ = $1; }
                |   _ARRAY SimpleTypes _OF type
                        { MAKE_ARRAY(&$$,$1->Zeile,$1->Posit,$2,$4); }
                |   _RECORD FieldListSeq _END
                        { MAKE_RECORD(&$$,$1->Zeile,$1->Posit,$2); }
                |   _RECORD FieldListSeq Flag
                        { SYNERROR;
                          fehler(text[156]);
                          MAKE_RECORD(&$$,$1->Zeile,$1->Posit,$2);
                        }
                |   _SET _OF SimpleType
                        { MAKE_SET(&$$,$1->Zeile,$1->Posit,$3); }
                |   _POINTER _TO type
                        { MAKE_POINTER(&$$,$1->Zeile,$1->Posit,$3); }
                ;

Flag
                :   ENDSYSTEM
                |   ENDCONST
                |   ENDBEGIN
                |   ENDOFFILE
                ;

SimpleType
                :   IDENT
                        { MAKE_NAME(&$$,$1); }
                |   '(' IdentList ')'
                        { MAKE_ENUM(&$$,$1->Zeile,$1->Posit,$2); }
                |   range
                        { MAKE_RANGE(&$$,$1); }
                ;

SimpleTypes
                :   SimpleTypes ',' SimpleType
                        { $$ = $3;
                          $$->link = $1;
                        }
                |   SimpleType
                        { $$ = $1; }
                ;

FieldListSeq
                :   FieldListSeq ';' FieldList
                        { $$ = $3;
                          $$->link = $1;
                          fieldlistident = 0;
                        }
                |   FieldListSeq error
                        { fehler(""); }
                    FieldList
                        { $$ = $4;
                          $$->link = $1;
                          fieldlistident = 0;
                        }
                |   FieldListSeq error
                        { fehler("");
                          $$ = $1;
                          fieldlistident = 0;
                        }
                |   FieldListSeq ';' error
                        { fehler(text[153]);
                          $$ = $1;
                          fieldlistident = 1;
                        }
                |   FieldList
                        { $$ = $1;
                          fieldlistident = 0;
                        }
                |   /* nichts */
                        { $$ = NULL;
                          fieldlistident = 1;
                        }
                |   FieldListSeq ';'
                        { $$ = $1;
                          fieldlistident = 1;
                        }
                ;

FieldList
                :   VarDef
                        { MAKE_RECDEF_NORM(&$$,$1); }
                |   _CASE opt_ident ':' SimpleType _OF
                    Variants ElseVariant caseend
                        { MAKE_RECDEF_CASE(&$$,$2,$4,$6,$7); }
                ;

opt_ident
                :   IDENT
                        { MAKE_IDENTLIST2(&$$,$1); }
                |   /* nichts */
                        { $$ = NULL; }

Variants
                :   Variants '|' Variant
                        { if ($3)
                          { $$ = $3;
                            $$->link = $1;
                          }
                          else
                            $$ = $1;
                        }
                |   Variant
                        { $$ = $1; }
                ;

Variant
                :   caselabellist ':' FieldListSeq
                        { MAKE_VARIANT(&$$,$1,$3); }
                |   error
                        { $$ = NULL; }
                ;

ElseVariant
                :   _ELSE FieldListSeq
                        { $$ = $2; }
                |   /* nichts */
                        { $$ = NULL; }
                ;

caseend
                :   _END
                |   ENDSYSTEM caseendfehler
                |   ENDCONST caseendfehler
                |   ENDBEGIN caseendfehler
                |   ENDOFFILE caseendfehler
                ;

caseendfehler
                :       { SYNERROR;
                          fehler(text[156]);
                        }

relation
                :   '='
                        { $$ = $1; }
                |   '<'
                        { $$ = $1; }
                |   '>'
                        { $$ = $1; }
                |   UNEQ
                        { $$ = $1;
                          $$->Art = UNEQ;
                        }
                |   '#'
                        { $$ = $1;
                          $$->Art = UNEQ;
                        }
                |   LEEQ
                        { $$ = $1;
                          $$->Art = LEEQ;
                        }
                |   GREQ
                        { $$ = $1;
                          $$->Art = GREQ;
                        }
                |   _IN
                        { $$ = $1;
                          $$->Art = _IN;
                        }
                ;

SimpleExpr
                :   SimpleExpr AddOperator term
                        { MAKE_BINOP(&$$,$1,$2,$3); }
                |   sign term
                        { MAKE_SINOP(&$$,$1,$2); }
                |   term
                        { $$ = $1; }
                ;

AddOperator
                :   sign
                        { $$ = $1; }
                |   _OR
                        { $$ = $1;
                          $$->Art = _OR;
                        }
                ;

sign
                :   '+'
                        { $$ = $1; }
                |   '-'
                        { $$ = $1; }
                ;

term
                :   term MulOperator power
                        { MAKE_BINOP(&$$,$1,$2,$3); }
                |   power
                        { $$ = $1; }
                ;

MulOperator
                :   '*'
                        { $$ = $1; }
                |   '/'
                        { $$ = $1; }
                |   _DIV
                        { $$ = $1;
                          $$->Art = _DIV;
                        }
                |   _MOD
                        { $$ = $1;
                          $$->Art = _MOD;
                        }
                |   _AND
                        { $$ = $1;
                          $$->Art = _AND;
                        }
                |   '&'
                        { $$ = $1;
                          $$->Art = _AND;
                        }
                ;

power
                :   factor POWER power
                        { MAKE_BINOP(&$$,$1,$2,$3); }
                |   factor
                        { $$ = $1; }
                ;

factor
                :   IDENT '(' ')'
                        { MAKE_FUNC(&$$,$1,NULL); }
                |   IDENT '(' ExprList ')'
                        { MAKE_FUNC(&$$,$1,$3); }
                |   INTCONSTANT
                        { MAKE_CONST(&$$,$1); }
                |   CHARCONSTANT
                        { MAKE_CONST(&$$,$1); }
                |   REALCONSTANT
                        { MAKE_CONST(&$$,$1); }
                |   STRINGCONSTANT
                        { MAKE_CONST(&$$,$1); }
                |   set
                        { $$ = $1; }
                |   designator
                        { $$ = $1; $$->select = E_DESIGNAT; }
                |   '(' expr ')'
                        { Zeile = $1->Zeile;
                          Posit = $1->Posit;
                          MAKE_KLEXPR(&$$,$2);
                        }
                |   _NOT 
                        { Zeile = yylineno;
                          Posit = sp_pos;
                        }
                    factor
                        { MAKE_NOTEXPR(&$$,$3); }
                |   '~' 
                        { Zeile = yylineno;
                          Posit = sp_pos;
                        }
                    factor
                        { MAKE_NOTEXPR(&$$,$3); }
                |  reduce
                        { Zeile = yylineno;
                          Posit = sp_pos;
                        }
                    '.' OperatorIdent selection '(' expr ')'
                        { MAKE_REDUCE(&$$,$4,$5,$7);
                          $$->error = statement_error;
                          statement_error = 0;
                          selecting_poss = 0;
                        }
                ;

OperatorIdent
                :   IDENT
                        { $$ = $1;
                          selecting_poss = 1;
                        }
                |   _AND
                        { $$ = $1;
                          $$->Art = _AND;
                          selecting_poss = 1;
                        }
                |   _OR 
                        { $$ = $1;
                          $$->Art = _OR;
                          selecting_poss = 1;
                        }
                ;

set
                :   IDENT '{' subranges '}'
                        { MAKE_E_SET(&$$,$1,$3,$1->Zeile,$1->Posit); }
                |   '{' subranges '}'
                        { MAKE_E_SET(&$$,NULL,$2,$1->Zeile,$1->Posit); }
                |   IDENT '{' '}'
                        { MAKE_E_SET(&$$,$1,NULL,$1->Zeile,$1->Posit); }
                |   '{' '}'
                        { MAKE_E_SET(&$$,NULL,NULL,$1->Zeile,$1->Posit); }
                ;

ExprList
                :   ExprList ',' expr
                        { $$ = $3;
                          $$->link = $1;
                          $$->count = $1->count + 1;
                        }
                |   expr
                        { $$ = $1;
                          $$->count = 1;
                        }
                ;

expr
                :   expr relation SimpleExpr
                        { MAKE_BINOP(&$$,$1,$2,$3);
                          if ($2->Art != _IN)
                          { if ($1->select == E_BINOP)
                            { switch ($1->factors.binop.operator->Art)
                              { case '=' :
                                case '<' :
                                case '>' :
                                case UNEQ :
                                case LEEQ :
                                case GREQ :
                                  $$->factors.binop.twice = EX_DOPP;
                                  break;
                              }
                            }
                          }
                        }
                |   SimpleExpr
                        { $$ = $1; }
                ;

accENDOFFILE
                :   ENDSYSTEM { key_nr = 3; } accENDOFFILE
                |   ENDCONST { key_nr = 3; } accENDOFFILE
                |   ENDBEGIN { key_nr = 3; } accENDOFFILE
                |   ENDOFFILE { key_nr = 4; }
                ;

accENDBEGIN
                :   ENDSYSTEM { key_nr = 2; } accENDBEGIN
                |   ENDCONST { key_nr = 2; } accENDBEGIN
                |   ENDBEGIN { key_nr = 3; }
                ;
%%

extern int yynerrs; /* Fehleranzahl */

