h03021
s 00316/00000/00000
d D 1.1 93/06/23 17:22:09 kehrmann 1 0
c date and time created 93/06/23 17:22:09 by kehrmann
e
u
U
f e 0
t
T
I 1
#define GLOBAL extern

#include	<XSachen.h>
#include	<globals.h>

#include <string.h>


/* ZeichneGrafikNeu
 *
 * In dieser Funktion sind die Sachen zusammengefasst, die ausgefuehrt werden
 * muessen, wenn eine Grafik ausgegeben werden soll.
 *
 * IN:	index	Nummer des Grafikwidgets, in das die Ausgabe erfolgen soll
 *
*/
void ZeichneGrafikNeu(index)
short	index;
{
	void	ClearPixmap();
	void	GibPixelaus();
	void	MaleAchsen();
	void	ZeigePixmap();

	ClearPixmap(index);
	SetPixelWerte(index, Bilder[index].Malbereich.x);
	GibPixelaus(index, Bilder[index].PixelWerte.aktAusgabe);
	MaleAchsen(index);
	ZeigePixmap(index);
} /* ZeichneGrafikNeu */



/* GibPixelaus
 * Gibt die Werte aus, die fuer die Pixel berechnet wurden. Die Werte werden
 * noch so skaliert, dass sie in den Malbereich des Fensters passen.
 *
 * IN:  index	Index des Grafikfensters
 *	art   	MINIMA, MAXIMA oder AVERAGE
*/
void GibPixelaus(index, art)
short	index;
short	art;
{
	short		i;
	extrema		*ExtremWerte;
	int		SkalierteNull = SkaliereYWert(index, 0);
	stat_typ	AnzahlBefehle;

	/* Nur eine Abkuerzung */
	ExtremWerte = Bilder[index].PixelWerte.Werte;

	AnzahlBefehle = 
		Bilder[index].letzterBefehl[Bilder[index].anzAusschnitte]
                - Bilder[index].ersterBefehl[Bilder[index].anzAusschnitte];

	/* in y-Richtung skalieren */
	Bilder[index].YskalFaktor = (float)Bilder[index].Malbereich.y 
					/ (float)inp.maxProzessoren;
	Bilder[index].XskalFaktor = (float)Bilder[index].Malbereich.x 
			/ (float)(AnzahlBefehle + 1);

	switch (art) {
	case MINIMA:  	
		for (i=0; i<Bilder[index].PixelWerte.anz; i++) {
			XDrawLine(display, Bilder[index].DrawPixmap, 
				Bilder[index].DrawGC,
				i + Bilder[index].Rand.Links, SkalierteNull,
				i + Bilder[index].Rand.Links, 
				SkaliereYWert(index, ExtremWerte[i].min));
		}
		break;
	case AVERAGE:  	
		for (i=0; i<Bilder[index].PixelWerte.anz; i++) {
			XDrawLine(display, Bilder[index].DrawPixmap,
				Bilder[index].DrawGC,
				i + Bilder[index].Rand.Links, SkalierteNull,
				i + Bilder[index].Rand.Links, 
				SkaliereYWert(index, (int)ExtremWerte[i].avg));
		}
		break;
	case MAXIMA:  	
		for (i=0; i<Bilder[index].PixelWerte.anz; i++) {
			XDrawLine(display, Bilder[index].DrawPixmap,
				Bilder[index].DrawGC,
				i + Bilder[index].Rand.Links, SkalierteNull,
				i + Bilder[index].Rand.Links, 
				SkaliereYWert(index, ExtremWerte[i].max));
		}
		break;
	default:
		break;
	}
	
        Bilder[index].PixelWerte.aktAusgabe = art;
	
} /* GibPixelaus */



/*
 * MaleAchsen
 * Gibt die x- und y-Achse in die Pixmap aus, inclusive Beschriftung.
 *
 * IN:	index	Index des Grafikfensters
*/
void MaleAchsen(index)
short	index;
{
	proc_typ	ySchritt;
	proc_typ	ydiff;
	stat_typ	xSchritt;
	stat_typ	xdiff;
	stat_typ	wievieleBef;
	stat_typ	ersterBef;
	stat_typ	letzterBef;
	char		tmp_string[10];

	long		BerechneSchrittWeite();

	/* Y-Achse malen */
	XDrawLine(display, Bilder[index].DrawPixmap, Bilder[index].DrawGC,
		  Bilder[index].Rand.Links - 1, Bilder[index].Rand.Oben,
		  Bilder[index].Rand.Links - 1, 
		  Bilder[index].Rand.Oben+Bilder[index].Malbereich.y+1);

	/* Bemassungen an die Y-Achse */
	/* Laenge der y-Achse: Malbereich.y  */
	/* Max. Beschriftung:  inp.maxProzessoren */

	/* Abstand der Beschriftungen */
	ySchritt = (proc_typ)BerechneSchrittWeite((long)inp.maxProzessoren);

	/* Abschnitte malen */
	for (ydiff=0; ydiff<=inp.maxProzessoren ; ydiff+=ySchritt) {
		XDrawLine(display, Bilder[index].DrawPixmap, 
			  Bilder[index].DrawGC,
			  Bilder[index].Rand.Links - 6, 
			  SkaliereYWert(index, ydiff), 
			  Bilder[index].Rand.Links - 1, 
			  SkaliereYWert(index, ydiff));

		/* Beschriftung der Abschnitte */
		sprintf(tmp_string, "%5d", ydiff);
		XDrawString(display, Bilder[index].DrawPixmap, 
			    Bilder[index].DrawGC,
			    10, SkaliereYWert(index, ydiff) + 6,
			    tmp_string, strlen(tmp_string));
	}


	/* X-Achse malen */
	XDrawLine(display, Bilder[index].DrawPixmap, 
			   Bilder[index].DrawGC,
		  Bilder[index].Rand.Links - 1,
		  Bilder[index].Rand.Oben+Bilder[index].Malbereich.y+1,
		  Bilder[index].Rand.Links+Bilder[index].Malbereich.x,
		  Bilder[index].Rand.Oben+Bilder[index].Malbereich.y+1);

	/* Bemassungen an die X-Achse */
	/* Laenge der x-Achse : Malbereich.x */
	/* Max Beschriftung:	inp.anzBefehle */

	ersterBef = Bilder[index].ersterBefehl[Bilder[index].anzAusschnitte];
	letzterBef = Bilder[index].letzterBefehl[Bilder[index].anzAusschnitte];
	wievieleBef = letzterBef - ersterBef + 1;
	/* Abstand der Beschriftungen */
	xSchritt = (stat_typ)BerechneSchrittWeite((long)wievieleBef);

        /* Abschnitte malen */
	for (xdiff=0; xdiff<=wievieleBef; xdiff += xSchritt) {
                XDrawLine(display, Bilder[index].DrawPixmap, 
			  Bilder[index].DrawGC,
			  Bilder[index].Rand.Links 
					+ SkaliereXWert(index, xdiff), 
			  Bilder[index].Rand.Oben 
					+ Bilder[index].Malbereich.y + 1,
			  Bilder[index].Rand.Links 
					+ SkaliereXWert(index, xdiff), 
			  Bilder[index].Rand.Oben 
					+ Bilder[index].Malbereich.y + 6);

		sprintf(tmp_string, "%d", xdiff+ersterBef-1);
		XDrawString(display, Bilder[index].DrawPixmap, 
			    Bilder[index].DrawGC,
			    Bilder[index].Rand.Links 
					+ SkaliereXWert(index, xdiff) - 6,
			    Bilder[index].Rand.Oben 
					+ Bilder[index].Malbereich.y + 20,
			    tmp_string, strlen(tmp_string));
        }

} /* MaleAchsen */



/* BerechneSchrittWeite
 *
 * berechnet die Abstaende zwischen den einzelnen Bemassungsmarkierungen
 *
 * IN:	anzahl		Wertebereich
 * OUT:	Fkt.erg.	Abstand zwischen 2 Markierungen
 *
*/
long BerechneSchrittWeite(anzahl)
long	anzahl;
{
	if (anzahl <= 10 )
		return((long)1);
	if (anzahl <= 30 )
		return((long)5);
	if (anzahl <= 200 )
		return((long)10);
	if (anzahl <= 500 )
		return((long)50);
	if (anzahl <= 2000 )
		return((long)100);
	if (anzahl <= 20000 )
		return((long)1000);
	if (anzahl <= 200000 )
		return((long)10000);
	if (anzahl <= 2000000)
		return((long)100000);

	return((long)500000);
} /* BerechneSchrittWeite */



/*
 * SkaliereYWert
 * skaliert die Zahl 'wert' mit Hilfe des Skalierungsfaktors.
 * Dann wird der Wert noch so an einer Linie in x-Richtung gespiegelt, dass
 * die '0' am unteren Rand des Malbereichs landet und die groesste Zahl am 
 * oberen Rand.
 * 
 * IN:	index		Index des Grafik-Fensters
 *	wert		zu skalierende Zahl
 * OUT:	FKT.ERG.	skalierte Zahl
 *
*/
static int SkaliereYWert(index, wert)
short	index;
int	wert;
{
	/* 1. skalieren */
	wert *= Bilder[index].YskalFaktor;
	/* 2. spiegeln und returnen */
	return(Bilder[index].Malbereich.y + Bilder[index].Rand.Oben - wert);
} /* SkaliereYWert */




/* SkaliereXWert
 *
 * skaliert die Zahl "wert" mit dem Skalierungsfaktor des Grafik-Fensters mit
 * Index "index".
 *
 * IN:	index		Index des Grafik-Fensters
 *	wert		zu skalierende Zahl
 * OUT:	Fkt.erg.	skalierte Zahl
 *
*/
SkaliereXWert(index, wert)
short	index;
int	wert;
{
	return((int)(wert * Bilder[index].XskalFaktor));
} /* SkaliereXWert */




/* ClearPixmap
 *
 * loescht den Inhalt einer Pixmap.
 *
 * IN:	index	Index des Grafik-Fensters
 *
*/
void ClearPixmap(index)
short	index;
{
	XFillRectangle(display, Bilder[index].DrawPixmap, 
		       Bilder[index].ClearGC, 0, 0, 
		       Bilder[index].Fenstergroesse.x, 
		       Bilder[index].Fenstergroesse.y);
} /* ClearPixmap */



/* ZeigePixmap
 *
 * gibt den Inhalt einer Pixmap im zugehoerigen Fenster aus.
 *
 * IN:	index	Index des Grafik-Fensters und der Pixmap
 *
*/
void ZeigePixmap(index)
short	index;
{
	if (DefaultDepthOfScreen(XtScreen(toplevelWidget)) == 1) {
		XCopyArea(display, Bilder[index].DrawPixmap, 
			  XtWindow(Bilder[index].DrawWidget), 
			  copy_GC, 0, 0, 
			  Bilder[index].Fenstergroesse.x, 
			  Bilder[index].Fenstergroesse.y, 0, 0);
	} else {
		XCopyPlane(display, Bilder[index].DrawPixmap,
			   XtWindow(Bilder[index].DrawWidget), 
			   copy_GC, 0, 0, 
			   Bilder[index].Fenstergroesse.x, 
			   Bilder[index].Fenstergroesse.y, 0, 0, 1);
	}
} /* ZeigePixmap */
E 1
