h28689
s 00374/00000/00000
d D 1.1 93/06/23 17:22:15 kehrmann 1 0
c date and time created 93/06/23 17:22:15 by kehrmann
e
u
U
f e 0
t
T
I 1
/* * Last edited: Aug 19 09:41 1992 (engelhar) */
#define GLOBAL	extern

#include 	<XSachen.h>
#include	<globals.h>

#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/AsciiText.h>

#include <string.h>


#define	TABELLEN_HOEHE	370
#define	TABELLEN_BREITE	180

static Widget		vektorTabelle;
static Widget		skalarTabelle;

/* ErzeugeStatistikWidget
 *
 * erzeugt die Widgets, die das Statistikfenster bilden.
 *
*/
void ErzeugeStatistikWidget()
{
	Widget	statistikFormular;
	Widget	StatistikAbbruch;
	Widget	text1Widget;
	Widget	text2Widget;
	Widget	text3Widget;
	Widget	text4Widget;
	Widget	text5Widget;
	Widget	text6Widget;
	Widget	fooWidget;


	/* Popup-Shell fuer das Statistikfenster */
	Statistik_shell = XtCreatePopupShell("Statistics", 
				topLevelShellWidgetClass,
				toplevelWidget, NULL, 0);

	/* Formular, das die Texte enthaelt */
	statistikFormular = XtCreateManagedWidget("statistikFormular", 
					formWidgetClass,
					Statistik_shell, 
					(Arg *)NULL, 0);


	text1Widget = XtVaCreateManagedWidget("anzbefText", labelWidgetClass,
				statistikFormular,
				XtNlabel, GES_ANZ_BEF_TXT,
				XtNtop, XtChainTop,
				XtNborderWidth, 0,
				NULL);

	text2Widget = XtVaCreateManagedWidget("einaktbefText", labelWidgetClass,
				statistikFormular,
				XtNlabel, ANZ_SKALAR_TXT,
				XtNfromVert, text1Widget,
				XtNborderWidth, 0,
				NULL);

	text3Widget = XtVaCreateManagedWidget("maxaktbefText", labelWidgetClass,
				statistikFormular,
				XtNlabel, MAXAKT_BEF_TXT,
				XtNfromVert, text2Widget,
				XtNborderWidth, 0,
				NULL);

	text4Widget = XtVaCreateManagedWidget("maxaktText", labelWidgetClass,
				statistikFormular,
				XtNlabel, MAXAKT_PE_TXT,
				XtNfromVert, text3Widget,
				XtNborderWidth, 0,
				NULL);

	text5Widget = XtVaCreateManagedWidget("avgaktText", labelWidgetClass,
				statistikFormular,
				XtNlabel, AVGAKT_PE_TXT,
				XtNfromVert, text4Widget,
				XtNborderWidth, 0,
				NULL);

	text6Widget = XtVaCreateManagedWidget("prozentText", labelWidgetClass,
				statistikFormular,
				XtNlabel, PROZENT_TXT,
				XtNfromVert, text5Widget,
				XtNborderWidth, 0,
				NULL);

	/* Die 6 Anzeigefelder */
	anz_bef_Widget = XtVaCreateManagedWidget("anzbefOut", 
				labelWidgetClass,
				statistikFormular,
				XtNlabel, "       ",
				XtNtop, XtChainTop,
				XtNfromHoriz, text1Widget,
				XtNborderWidth, 0,
				NULL);

	bef_ein_proz_Widget = XtVaCreateManagedWidget("einaktbefOut", 
				labelWidgetClass,
				statistikFormular,
				XtNlabel, "       ",
				XtNfromHoriz, text2Widget,
				XtNfromVert, anz_bef_Widget,
				XtNborderWidth, 0,
				NULL);

	bef_max_proz_Widget = XtVaCreateManagedWidget("maxaktbefOut", 
				labelWidgetClass,
				statistikFormular,
				XtNlabel, "       ",
				XtNfromHoriz, text3Widget,
				XtNfromVert, bef_ein_proz_Widget,
				XtNborderWidth, 0,
				NULL);

	max_akt_proz_Widget = XtVaCreateManagedWidget("maxaktOut", 
				labelWidgetClass,
				statistikFormular,
				XtNlabel, "       ",
				XtNfromHoriz, text4Widget,
				XtNfromVert, bef_max_proz_Widget,
				XtNborderWidth, 0,
				NULL);

	avg_akt_proz_Widget = XtVaCreateManagedWidget("avgaktOut", 
				labelWidgetClass,
				statistikFormular,
				XtNlabel, "       ",
				XtNfromHoriz, text5Widget,
				XtNfromVert, max_akt_proz_Widget,
				XtNborderWidth, 0,
				NULL);

	prozent_Widget = XtVaCreateManagedWidget("prozentOut", 
				labelWidgetClass,
				statistikFormular,
				XtNlabel, "       ",
				XtNfromHoriz, text6Widget,
				XtNfromVert, avg_akt_proz_Widget,
				XtNborderWidth, 0,
				NULL);

	fooWidget = XtVaCreateManagedWidget("foo",
			labelWidgetClass,
			statistikFormular,
			XtNlabel, "   ",
			XtNfromVert, text6Widget,
			XtNborderWidth, 0,
			NULL);

	vektorTabelle = XtVaCreateManagedWidget("vektorTabelle",
			asciiTextWidgetClass,
			statistikFormular,
                        XtNwidth, TABELLEN_BREITE,
                        XtNheight, TABELLEN_HOEHE,
			XtNfromVert, fooWidget,
                        XtNtype, XawAsciiString,
                        XtNeditType, XawtextRead,
                        XtNdisplayCaret, False,
                        XtNscrollVertical, XawtextScrollWhenNeeded,
                        NULL);

	skalarTabelle = XtVaCreateManagedWidget("skalarTabelle",
			asciiTextWidgetClass,
			statistikFormular,
                        XtNwidth, TABELLEN_BREITE,
                        XtNheight, TABELLEN_HOEHE,
			XtNfromVert, fooWidget,
			XtNfromHoriz, vektorTabelle,
                        XtNtype, XawAsciiString,
                        XtNeditType, XawtextRead,
                        XtNdisplayCaret, False,
                        XtNscrollVertical, XawtextScrollWhenNeeded,
                        NULL);


	/* Der Ende-Knopf im StatistikFormular */
	StatistikAbbruch = XtVaCreateManagedWidget("statistikAbbruch", 
				commandWidgetClass,
				statistikFormular,
				XtNfromVert, vektorTabelle,
				XtNlabel, OK_TXT,
				NULL);
	XtAddCallback(StatistikAbbruch, 
		XtNcallback, PopUpDialogAbbruchCB,
		NULL);
} /* ErzeugeStatistikWidget */



/* statistikCB
 *
 * wird aufgerufen, wenn der Statistik-Knopf im Haupt-Menue gedrueckt wird.
 * Dann wird das StatistikWidget auf dem Bildschirm dargestellt.
 *
 * IN:	w, client_data, call_data	nicht verwendet
 *
*/
void statistikCB(w, client_data, call_data)
Widget		w;
XtPointer	client_data;
XtPointer	call_data;
{
	Position	x, y;
	Dimension	width, height;

	/* Wenn noch keine Datei eingelesen wurde, dann ist hier 
	   nichts zu tun. */
	if (inp.anzBefehle == 0) {
		meldung(ERR_NO_FILE);
		return;
	}

	/* Statistikfenster darstellen */
	XtVaGetValues(toplevelWidget, 
		      XtNwidth, &width,
		      XtNheight, &height,
		      NULL);
	
	XtTranslateCoords(toplevelWidget, (Position) width, 
			  (Position)height/2,
			  &x, &y);

	XtVaSetValues(Statistik_shell, XtNx, x, XtNy, y, NULL);
	
	XtPopup(Statistik_shell,XtGrabNone);

} /* statistikCB */



/* SetStatistik
 *
 * schreibt die statistischen Werte in die Felder des StatistikWidgets.
 *
*/
void SetStatistik()
{
	char	foo[10];
	char	vektorText[500];
	char	skalarText[500];
	char	tmp_str[80];
	float	V_Proz;
	float	S_Proz;
	float	avg_in_Prozent;
	short	i;

	I_TRACE(1, "SetStatistik");

	/* max. aktive Prozessoren */
	sprintf(foo, "%6d", inp.maxProzessoren);
	XtVaSetValues(max_akt_proz_Widget, 
			XtNlabel, foo,
			NULL);

	/* durchschnittlich aktive Prozessoren */
	sprintf(foo, "%6.1f", inp.avgAktProzessoren);
	XtVaSetValues(avg_akt_proz_Widget, 
			XtNlabel, foo,
			NULL);

	/* Durchschnitt als Prozentwert des Maximums */
	avg_in_Prozent = inp.avgAktProzessoren * 100 / inp.maxProzessoren;
	sprintf(foo, "%6.1f%%", avg_in_Prozent);
	XtVaSetValues(prozent_Widget,
			XtNlabel, foo,
			NULL);
			
	/* Gesamtanzahl Befehle */
	sprintf(foo, "%6d", inp.anzBefehle);
	XtVaSetValues(anz_bef_Widget, 
			XtNlabel, foo,
			NULL);
			
	/* Anzahl Befehle mit max. Prozessoraktivitaet */
	sprintf(foo, "%6d", inp.anzMaxAktBefehle);
	XtVaSetValues(bef_max_proz_Widget, 
			XtNlabel, foo,
			NULL);
			
	/* Befehle mit einem aktiven Prozessor */
	sprintf(foo, "%6d", inp.anzMinAktBefehle);
	XtVaSetValues(bef_ein_proz_Widget, 
			XtNlabel, foo,
			NULL);
			
	vektorText[0] = '\0';
	skalarText[0] = '\0';
	(void)strcat(vektorText, "     Vector\n");
	(void)strcat(vektorText, "           \n");
	(void)strcat(skalarText, "     Scalar\n");
	(void)strcat(skalarText, "           \n");
	for(i=0; i<26; i++) {
		/* Text fuer das linke Textwidget mit den VektorProzenten */
		if (inp.anzVektorBefehle > 0)
		       V_Proz = inp.V_Kommandos[i] * 100.0 / inp.anzVektorBefehle;
		else
			V_Proz = 0.0;
		sprintf(tmp_str, "   %c : %4.1f %%\n", i+'A', V_Proz);

		(void)strcat(vektorText, tmp_str);
		tmp_str[0] = '\0';

		/* Text fuer das rechte Textwidget mit den SkalarProzenten */
		if (inp.anzSkalarBefehle > 0)
		       S_Proz = inp.S_Kommandos[i] * 100.0 / inp.anzSkalarBefehle;
		else
			S_Proz = 0.0;
		sprintf(tmp_str, "   %c : %4.1f %%\n", i+'a', S_Proz);
		(void)strcat(skalarText, tmp_str);
		tmp_str[0] = '\0';
	}
	XtVaSetValues(vektorTabelle, 
                        XtNstring, vektorText,
			NULL);
	XtVaSetValues(skalarTabelle, 
                        XtNstring, skalarText,
			NULL);

	I_TRACE(1, "SetStatistik OK");

	return;
} /* SetStatistik */



/* BerechneStatistik
 *
 * berechnet die statistischen Werte, wird jedesmal aufgerufen, wenn eine Datei
 * eingelesen wurde.
 *
*/
void BerechneStatistik()
{
	long	i;
	long	j;
	long	zaehler = 0;
	float	Mittelwert();

	I_TRACE(1, "BerechneStatistik");

	/* richtige Startwerte setzen */
	inp.anzMinAktBefehle = 0;
	inp.anzMaxAktBefehle = 0;
	inp.avgAktProzessoren = 0;

	
	for (i=0; i<inp.anzElemente; i++) {
		/* ev. Summe der Befehle mit einem aktiven Prozessor erhoehen */
		if (inp.bef_liste[i].beteiligte_prozessoren == 1) {
			inp.anzMinAktBefehle += inp.bef_liste[i].befehls_sum;
		}
		/* ev. Summe der Befehle mirt maximaler Aktivitaet erhoehen */
		if (inp.bef_liste[i].beteiligte_prozessoren 
		    == inp.maxProzessoren) {
			inp.anzMaxAktBefehle += inp.bef_liste[i].befehls_sum;
		}
		/* durchschnittliche Prozessoraktivitaet berechnen */
		for (j=0; j<inp.bef_liste[i].befehls_sum; j++) {
			inp.avgAktProzessoren 
				= Mittelwert(inp.avgAktProzessoren, 
				      zaehler, 
				      inp.bef_liste[i].beteiligte_prozessoren);
			zaehler++;
		}
	}

	I_TRACE(1, "BerechneStatistik OK");
} /* BerechneStatistik */
E 1
