h15424
s 00253/00000/00000
d D 1.1 93/06/23 17:22:00 kehrmann 1 0
c date and time created 93/06/23 17:22:00 by kehrmann
e
u
U
f e 0
t
T
I 1
/* * Last edited: Aug 19 09:54 1992 (engelhar) */
#define GLOBAL	extern

#include	<XSachen.h>
#include	<globals.h>
#include	<X11/Shell.h>

#include <string.h>




/* lies_dateiCB
 *
 * wird aufgerufen, wenn der "OK"-Knopf im Datei-Dialog gedrueckt wird und
 * am Programmanfang, wenn ein Dateiname in der Kommandozeile uebergeben wird.
 * Ueberprueft, ob die Datei lesbar und wenn ja, ob sie eine gueltige 
 * Record-Datei ist. Wenn die Pruefungen positiv verlaufen sind, wird die 
 * Funktion "lies_daten" aufgerufen, die die Datei einliest und die Daten
 * in der Struktur "inp" speichert.
 *
 * IN:	w		Widget-Id des OK-Knopfes bei Aufruf durch Callback oder
 *			"0" beim Aufruf am Programmbeginn
 *	client_data	nicht verwendet
 *	call_data	nicht verwendet
 *
*/
void lies_dateiCB(w, client_data, call_data)
Widget		w;
XtPointer	client_data;
XtPointer	call_data;
{
	char	datname[256];
	char	Meldungstext[300];
	FILE	*fp;
	short	erg;
	short	i;

	char	*XawDialogGetValueString();
	FILE	*IstRecordDatei();
	short	DateiLesbar();
	void	BerechneStatistik();
	void	SetStatistik();
	void	DatNameAusWidget();
	void	ZeichneKuchen();
	void	ZeichneGrafikNeu();
	void	neuesBild();
	short	lies_daten();

	/* W == 0 : Kein Callback aufruf sondern am Prg.beginn */
	if (w == 0) {
		(void)strcpy(datname, Dateiname);
	} else {
		/* normaler Calbbackaufruf */
		DatNameAusWidget(datname);
	}

	/* Testen, ob man die Datei lesen kann */
	if (!DateiLesbar(datname)) {
		(void)sprintf(Meldungstext, "Could not open file: %s\n", datname);
		meldung(Meldungstext);
		return;
	}

	/* Testen , ob es eine Recorddatei mit Mode 1 ist */
	if ((fp = IstRecordDatei(datname)) == NULL) {
		(void)sprintf(Meldungstext, "File %s is no record-file\n", datname);
		meldung(Meldungstext);
		return;
	}

	/* Datei einlesen */
	erg = lies_daten(fp);
	if (erg != OK) {
		(void)sprintf(Meldungstext, 
			"An error occured while scanning file %s.\n", datname);
		meldung(Meldungstext);
		return;
	}

	/* Dateiname global aendern */
	(void)strcpy(Dateiname, datname);

	/* Statistische Werte berechnen ... */
	BerechneStatistik();
	/* ... und ausgeben */
	SetStatistik();

	/* Kuchendiagramme erzeugen  */
	if (XtIsRealized(kuchenDrawWidget))
		ResizeKuchen(kuchenDrawWidget);
	else {
		ZeichneKuchen();
	}

	/* falls kein Graphikfenster geoeffnet ist, das erste oeffnen */
	/* nur bei normalem Callback-Aufruf. Am Programmanfang wird das
	   erste Fenster in main() geoeffnet, da beim Dateilesen noch
	   keine Fenster existieren */
	if ((w != 0) && (anzDrawWidgets == 0)) {
		neuesBild();
	}

	/* schon vorhandene Grafikfenster aendern */
	for (i=0; i<anzDrawWidgets; i++) {
		/* erst die Ueberschrift aendern ... */
		XtVaSetValues(Bilder[i].DrawWidget_shell, 
				XtNtitle, Dateiname,
				NULL);
		/* und dann den Iconnamen */
		XtVaSetValues(Bilder[i].DrawWidget_shell, 
				XtNiconName, Dateiname,
				NULL);

		/* neue Datei ==> alle Befehle darstellen */
		Bilder[i].ersterBefehl[0] = 1;
		Bilder[i].letzterBefehl[0] = inp.anzBefehle;
		Bilder[i].anzAusschnitte = 0;

		/* und alles neu ausgeben */
		ZeichneGrafikNeu(i);
	}

	I_TRACE(1, "am Ende von lies_dateiCB");
	return;

} /* lies_dateiCB */



/* DatNameAusWidget
 *
 * liest die Namen des Pfades und der Datei aus dem DateiDialog-Widget aus.
 *
 * IN/OUT:	PfadUndDatei	String, in dem die Funktion den kompletten
 *				aus Pfad- und Dateinamen zusammengesetzten 
 *				Namen zurueckgibt.
 *		!!!!!!!!!!!!	Der Aufrufer muss fuer ausreichend Speicher
 *		!!!!!!!!!!!!	im String sorgen.
*/
void DatNameAusWidget(PfadUndDatei)
char	*PfadUndDatei;
{
	char	*pfadtxt;
	char	*dateitxt;

	I_TRACE(1, "DatNameAusWidget");

	XtVaGetValues(pfadInput,
			XtNstring, &pfadtxt,
			NULL);

	XtVaGetValues(dateiNameInput,
			XtNstring, &dateitxt,
			NULL);

	(void)strcpy(PfadUndDatei, pfadtxt);
	if (strlen(pfadtxt) != 0)
		(void)strcat(PfadUndDatei, "/");
	(void)strcat(PfadUndDatei, dateitxt);
} /* DatNameAusWidget */



/* DateiLesbar
 *
 * prueft, ob die Datei "name" lesbar ist.
 *
 * IN:	name		Name der Datei, die gelesen werden soll
 * OUT:	Fkt.erg.	TRUE, falls die Datei lesbar ist, FALSE sonst
 *
*/
static short DateiLesbar(name)
char	*name;
{
	FILE	*fp;

	if ((fp = fopen(name, "r")) == NULL) {
		(void)fclose(fp);
		return(FALSE);
	}

	(void)fclose(fp);
	return(TRUE);
} /* DateiLesbar */



/* IstRecordDatei
 *
 * prueft, ob die Datei "name" eine gueltige Recor-Datei ist. Wenn ja, returnt
 * die Funktion den File-Pointer auf den Anfang der Daten in dieser Datei.
 *
 * IN:	name		Name der Datei, die gelesen werden soll
 * OUT:	Fkt.erg.	File-Pointer, wenn es eine Record-Datei ist, 
 *			NULL sonst
 *
*/
static FILE *IstRecordDatei(name)
char	*name;
{

	FILE	*fp;
	char	modestr[20], prgstr[20], prgname[256];
	char	Meldungstext[300];
	int	mode;

	if ((fp = fopen(name, "r")) == NULL) {
		(void)sprintf(Meldungstext, "Could not open file %s.\n", name);
		meldung(Meldungstext);
		(void)fclose(fp);
		return(NULL);
	}

	(void)fscanf(fp, "%s", modestr);
	if (strlen(modestr) == 5)
		(void)fscanf(fp, "%d", &mode);
	else
		(void)fscanf(fp, " : %d", &mode);
		
	if (strncmp(modestr, "mode", 4) != 0) {
		(void)sprintf(Meldungstext, 
			"'mode'-line in file %s is wrong.\n", name);
		meldung(Meldungstext);
		(void)fclose(fp);
		return(NULL);
	}
	if (mode != 1) {
		(void)sprintf(Meldungstext, 
			"File %s is not of format 'short recording'.\n", name);
		meldung(Meldungstext);
		(void)fclose(fp);
		return(NULL);
	}

	(void)fscanf(fp, "%s", prgstr);
	if (strlen(prgstr) == 8)
		(void)fscanf(fp, "%s", prgname);
	else
		(void)fscanf(fp, " : %s", prgname);

	if (strncmp(prgstr, "program", 7) != 0) {
		(void)sprintf(Meldungstext, 
			"'program'-line in file %s is wrong.\n", name);
		meldung(Meldungstext);
		(void)fclose(fp);
		return(NULL);
	}


	return(fp);

} /* IstRecordDatei */
E 1
