/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : General
  Filename     : absoffs.c       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.absoffs.c
  Version      : 1.3 
  Last changed : 9/27/93 at 14:04:40        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : Funktionen zur Berechnung absoluter Offsets fuer PARZ

******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/

static char sccs_id[] = "@(#)absoffs.c	1.3  9/27/93 PARZ - General (Frank Sembach)";


#include "parzdefs.h"
#include "externs.h"

/**************************************************************************
 ***                       Funktion get_absoffs
 ***
 *** ermittelt absoluten Offset einer Variablen vom Typ 't' mit
 *** typinterner Nummer 'roffs' in einem Variablenblock mit Beschreibung '*dl'
 *** Ergebnis = 0 bei Fehler.
 ***
 **************************************************************************/

int get_absoffs(t, roffs, dl)
TYP t;
long roffs;
DECLIST *dl;
{ if (roffs > dl->typ_zahl[t] || roffs < 1)
  { return 0; }
  else
  { int absnum = 0;    /* zaehlt alle Variablen */
    int relnum = 0;    /* zaehlt Typ-t Variablen bis 'roffs' */
    DECL *dptr = dl->darray;

    while (relnum < roffs)
    { switch (DECL_art(*dptr))
      { case FELD :
        { int zahl = DECL_zahl(*dptr);

          if (DECL_t(*dptr) != t)         /* anderer Typ */
          { absnum += zahl; }
          else if (zahl + relnum < roffs) /* zuwenige */
          { absnum += zahl; relnum += zahl; }
          else
          { absnum += roffs - relnum; relnum = roffs; }   /* roffs erreicht */
          dptr++;
        }
        break;
        case KLAM :
        { int tzahl = DECL_typ_anz(*dptr)[t];
          int wied = DECL_wiederh(*dptr);
          int tabs;

          if ((tabs = wied * tzahl) + relnum < roffs)     /* ganze Unterdeklaration ueberlesen */
          { absnum += wied * DECL_typ_anz(*dptr)[SUMM];
            relnum += tabs;
            dptr++;
          }
          else                          /* Unterdeklaration betreten */
          { int div;

            relnum += tzahl * (div = (roffs - 1 - relnum) / tzahl);
            absnum += DECL_typ_anz(*dptr)[SUMM] * div;
            dptr = DECL_klamdecl(*dptr).darray;
          }
        }
        break;
        case UNION :
        { int ulen;

          if ((ulen = DECL_ul(*dptr).utyp_anz[t]) + relnum < roffs)
                                        /* ganze Union-Deklaration ueberlesen */
          { relnum += ulen;
            absnum += DECL_ul(*dptr).utyp_anz[SUMM];
            dptr++;
          }
          else                          /* Union betreten */
          { DECLIST *uptr;
          
            for (uptr = DECL_ul(*dptr).uarray;
                 (ulen = uptr->typ_zahl[t]) + relnum < roffs;
                 relnum += ulen, uptr++);  /* Irrelevante Varianten ueberlesen (nur Relativnummern zaehlen) */
            dptr = uptr->darray;        /* Aktuelle Variante betreten */
          }
        }
      }
    }
    return absnum;
  }
}

/**************************************************************************
 ***                       Funktion set_absoffs
 ***
 *** ermittelt absoluten Offset einer Variablen vom Typ 't' mit
 *** typinterner Nummer 'roffs' in einem Variablenblock mit Beschreibung '*dl'.
 *** Traegt Ergebnis in 'absoffs' von '*a' ein,
 *** traegt 'aproc' in 'gut_proc' von '*a' ein.
 *** Ergebnis = TRUE, wenn Offset gefunden wurde oder aproc schon eingetragen war.
 ***
 **************************************************************************/

int set_absoffs(t, roffs, a, dl, aproc)
TYP t;
int roffs;
ARG *a;
DECLIST *dl;
int aproc;
{ if (ARG_gut_proc(*a) == aproc)
  { return TRUE; }
  if (!(ARG_absoffs(*a) = get_absoffs(t, (long)roffs, dl)))
  { return FALSE; }
  ARG_gut_proc(*a) = aproc;
  return TRUE;
}

