/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : Debugger
  Filename     : debout.c       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.debout.c
  Version      : 1.3 
  Last changed : 9/27/93 at 14:04:43        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : Ausgabefunktionen fuer den symbolischen Debugger von PARZ

******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/

static char sccs_id[] = "@(#)debout.c	1.3  9/27/93 PARZ - Debugger (Frank Sembach)";


#include "parzdefs.h"
#include "komdefs.h"
#include "y_tab.h"
#include "externs.h"
#include "rundefs.h"
#include "runexts.h"
#include "komexts.h"
#include "funcs.h"
#include "debexts.h"

extern char *wert_string();     /* liefert Ausgabestring zu einem ITEM */

struct pe_val_typ
{ int max_len;
  char *pe_name;
  char **val_strings;
} pe_vals[CRTCOLS / 5];

/**************************************************************************
 ***                      Funktion init_pe_vals
 ***
 *** Initialisiert die Ausgabeakkumulatoren 'pe_vals' fuer
 *** 'zeilen' Ausgabezeilen.
 *** Ergebnis : TRUE bei erfolgreicher Initialisierung
 ***
 **************************************************************************/

int init_pe_vals(zeilen)
int zeilen;
{ register int i;
  register struct pe_val_typ *vptr;

  for (i = CRTCOLS / 5, vptr = pe_vals; i; i--, vptr++)
  { vptr->max_len = 5;
    if (!(vptr->pe_name = calloc((size_t)80, (size_t)sizeof(char))))
    { komerr(texte[80],9); loesch_pe_vals(); return FALSE; }
    if (!(vptr->val_strings = (char **)calloc((size_t)zeilen, (size_t)sizeof(char *))))
    { komerr(texte[80],10); loesch_pe_vals(); return FALSE; }
  }
  return TRUE;
}

/**************************************************************************
 ***                      Funktion loesch_pe_vals
 ***
 *** Gibt den in 'init_pe_vals()' allozierten Speicherplatz frei.
 *** zeilen : Zahl der Strings in Komponente 'val_strings'
 ***
 **************************************************************************/

loesch_pe_vals(zeilen)
int zeilen;
{ register int i, j;
  register char **sptr;
  register struct pe_val_typ *vptr;

  for (i = CRTCOLS / 5, vptr = pe_vals; i; i--, vptr++)
  { if (vptr->pe_name)
    { free(vptr->pe_name); vptr->pe_name = NULL; }
    if (vptr->val_strings)
    { for (j = zeilen, sptr = vptr->val_strings; j; j--, sptr++)
      { if (*sptr) free(*sptr); }
      free(vptr->val_strings); vptr->val_strings = NULL;
    }
  }
}

/**************************************************************************
 ***                Funktion printout
 ***
 *** Gibt 's' mit Breite 'b' auf 'f' aus
 ***
 **************************************************************************/

printout(s, b, f)
char *s;
int b;
FILE *f;
{ if (strlen(s) > b)
  { switch (*s)
    { case '"'  :
      case '\'' :
        fprintf(f, "%.*s\n", b - 1, s); ifmore(f);
        if (quitted) return;
        for (s += b - 1; strlen(s) > b - 1; s += b - 2)
        { fprintf(f, "%*s %.*s\n", CRTCOLS - b, " ", b - 2, s); ifmore(f);
          if (quitted) return;
        }
        fprintf(f, "%*s %s", CRTCOLS - b, " ", s);
        break;
      case '{'  :
        { register char *send;

          s++;
          for (send = s + b - 2; send > s && *send != ','; send--);
          if (send == s)
          { for (send = s + b - 2; *send && *send != ','; send++);
            if (*send) send++;
          }
          fprintf(f, "%.*s\n", (int)(send - s + 1), s); ifmore(f);
          if (quitted) return;
          for (s = send + 1; strlen(s) > b - 1; s = send + 1)
          { for (send = s + b - 4; send > s && *send != ','; send--);
            if (send == s)
            { for (send = s + b - 4; *send && *send != ','; send++);
              if (*send) send++;
            }
            fprintf(f, "%*s  %.*s\n", CRTCOLS - b, " ", (int)(send - s + 1), s);
            ifmore(f);
            if (quitted) return;
          }
          fprintf(f, "%*s  %s", CRTCOLS - b, " ", s);
        }
        break;
      default :
        fputs(s, f);
    }
  }
  else
  { fprintf(f, "%-*s", b, *s =='{' ? s + 1 : s); }
}

/**************************************************************************
 ***                Funktion pe_vals_out
 ***
 *** Gibt die ersten 'spalten' Spalten aus 'pe_vals' auf 'f' aus.
 *** pe_flag : Bei TRUE wird der PE-Name ausgegeben.
 *** zeilen : Zahl der Zeilen in pe_vals
 ***
 **************************************************************************/

pe_vals_out(spalten, zeilen, pe_flag, f)
int spalten, zeilen, pe_flag;
FILE *f;
{ register int z, s;
  register struct pe_val_typ *pv;

  if (pe_flag)
  { putc('\n', f); ifmore(f);
    if (quitted) return;
    for (s = spalten, pv = pe_vals; s; s--, pv++)
    { printout(pv->pe_name, pv->max_len + (s > 1), f); }
  }
  for (z = 0; z < zeilen; z++)
  { putc('\n', f); ifmore(f);
    if (quitted) return;
    for (s = spalten, pv = pe_vals; s; s--, pv++)
    { printout(pv->val_strings[z], pv->max_len + (s > 1), f); }
  }
}

static char *pre[2] = {"?", ""}; /* Praefixe fuer Set-Elemente */

/**************************************************************************
 ***         Funktion ex_string (rekursiv bei abgeleiteten Typen)
 ***
 *** Erzeugt einen Ausgabestring fuer '**itpt' vom Typ '*tt'
 *** auf neu alloziertem Platz
 *** '*itpt' wird um die Zahl der ITEMs in '*tt' weitergezaehlt
 *** inc : Laenge eines ITEMs (1 oder pe_anz)
 ***
 **************************************************************************/

char *ex_string(itpt, tt, inc)
ITEM **itpt;
TYPTAB *tt;
int inc;
{ register char *s;

  switch (tt->typ_art)
  { case TYP_UNDEF :
      bug("debug.c/ex_string : TYP_UNDEF auszugeben");
    case TYP_BOOL :
    case TYP_CHA :
    case TYP_INT :
    case TYP_REAL :
      s = wert_string(*itpt, tt->typ_art - TYP_BOOL + BOOL);
      *itpt += inc;
      return s;
    case TYP_STRING :
      s = wert_string(*itpt, ITEM_typ(**itpt));
      *itpt += inc;
      return s;
    case TYP_ARRAY :
      { register int i, len;
        register char *sneu;

        if (tt->parz_decl.typ_zahl[SUMM] == (len = tt->parz_decl.typ_zahl[CHA]))
        { if (!(s = malloc((size_t)(len += 3))))
          { komerr(texte[80],11); return NULL; }
          *s = '"'; s[1] = '\0';
          for (i = len - 3, sneu = s + 1;
               i;
               i--, *itpt += inc)
          { register int kflag;
            register char *ws;

            if (kflag = (ITEM_typ(**itpt) != CHA ||
                         ((*itpt)->datentyp & UNDEF_ERG) ||
                         (*itpt)->inhalt.c_val == EOL_CHAR ||
                         (*itpt)->inhalt.c_val == TERMS_CHAR ||
                         (*itpt)->inhalt.c_val < MIN_PRINTING_CHAR ||
                         (*itpt)->inhalt.c_val > MAX_PRINTING_CHAR)) /* Sonderform */
            { if (!(ws = wert_string(*itpt, CHA)))
              { if (s) free(s); return NULL; }
              if (!(sneu = realloc(s, (size_t)(len += (strlen(ws) + 1)))))
              { komerr(texte[80],12); free(ws);
                if (s) free(s);
                return NULL;
              }
              s = sneu; sneu = s + strlen(s);
              *sneu++ = '<';
            }
            else                        /* ein Buchstabe */
            { beim_listing = FALSE;
              ws = wert_string(*itpt, CHA);
              beim_listing = TRUE;
            }
            if (!ws)
            { if (s) free(s); return NULL; }
            strcpy(sneu, ws); sneu += strlen(ws);
            if (ws) free(ws);
            if (kflag)                          /* Sonderform Ende */
            { *sneu++ = '>'; *sneu = '\0'; }
          }
          *sneu++ = '"'; *sneu = '\0';
        }
        else
        { s = ex_string(itpt, types_table + tt->typ_arg1 - 1, inc); }
      }
      return s;
    case TYP_RECORD :
    case TYP_UNION :
      s = ex_string(itpt,
                    types_table + member_table[tt->typ_arg1 - 1].typ_wert - 1,
                    inc);
      return s;
    case TYP_SET :
      { register char *sadd, *sneu;
        register long von = tt->typ_arg2;
        register long bis = tt->typ_arg3;
        register TYPTAB *te = types_table + tt->typ_arg1 - 1;
        register long last;
        register int echt, eltyp, fertig;
        register char *typnam = (tt - types_table + 1 == bitset_typ)
                                  ? ""
                                  : key_to_name(tt->typ_key);
        ITEM zaehler, *dummy;

#define itop(it,op,tvar) ((tvar == BOOL) ? (it.inhalt.b_val op) : ((tvar == CHA) ? (it.inhalt.c_val op) : ( it.inhalt.i_val op)))

        if (!typnam) typnam = "";
        if (!(s = malloc((size_t)(strlen(typnam) + 4))))
        { komerr(texte[80],13); return NULL; }
        sprintf(s, "{%s", typnam);
        switch (te->typ_art)
        { case TYP_BOOL :
            eltyp = BOOL;
            break;
          case TYP_SUBRANGE :
            eltyp = types_table[te->typ_arg1 - 1].typ_art;
            if (eltyp == TYP_ENUM) eltyp = INT;
            else eltyp = eltyp - TYP_BOOL;
            break;
          case TYP_ENUM :
            eltyp = INT;
        }
        zaehler.datentyp = eltyp | ERLAUBT(eltyp);
        for (itop(zaehler, = von, eltyp), fertig = FALSE;
             !fertig &&
               ITEM_typ(**itpt) == BOOL &&
               !(*itpt)->inhalt.b_val;
             fertig = itop(zaehler, == bis, eltyp),
               itop(zaehler,++, eltyp), *itpt += inc);
        if (fertig)
        { strcat(s, "{}"); }
        else
        { dummy = &zaehler;
          echt = ITEM_typ(**itpt) == BOOL;
          if (!(sadd = ex_string(&dummy, te, 1))) return NULL;
          if (!(sneu = realloc(s, (size_t)(strlen(s) + strlen(sadd) + 4))))
          { komerr(texte[80],14); return NULL; }
          s = sneu;
          sprintf(s + strlen(s), "{%s%s", pre[echt], sadd);
          fertig = itop(zaehler, == bis, eltyp);
          last = itop(zaehler,++,eltyp); *itpt += inc;
          while (!fertig)
          { if (echt)
            { for (; !fertig &&
                       ITEM_typ(**itpt) == BOOL &&
                       (*itpt)->inhalt.b_val;
                     fertig = itop(zaehler, == bis, eltyp),
                       itop(zaehler,++,eltyp), *itpt += inc);
              itop(zaehler,--,eltyp); 
              if (itop(zaehler, > last, eltyp))
              { dummy = &zaehler;
                if (!(sadd = ex_string(&dummy, te, 1))) return NULL;
                if (!(sneu = realloc(s, (size_t)(strlen(s) + strlen(sadd) + 4))))
                { komerr(texte[80],15); if (s) free(s); return NULL; }
                s = sneu;
                sprintf(s + strlen(s), "%s%s",
                          itop(zaehler, > last + 1, eltyp) ? ".." : ",", sadd);
                echt = FALSE;
              }
              last = itop(zaehler,++,eltyp);
            }
            for (; !fertig &&
                     ITEM_typ(**itpt) == BOOL &&
                     !(*itpt)->inhalt.b_val;
                   fertig = itop(zaehler, == bis, eltyp),
                     itop(zaehler,++,eltyp), *itpt += inc);
            if (!fertig)
            { dummy = &zaehler;
              echt = ITEM_typ(**itpt) == BOOL;
              if (!(sadd = ex_string(&dummy, te, 1))) return NULL;
              if (!(sneu = realloc(s, (size_t)(strlen(s) + strlen(sadd) + 4))))
              { komerr(texte[80],16); if (s) free(s); return NULL; }
              s = sneu;
              sprintf(s + strlen(s), ",%s%s", pre[echt], sadd);
              fertig = itop(zaehler, == bis, eltyp);
              last = itop(zaehler,++, eltyp); (*itpt) += inc;
            }
          }
          strcat(s, "}");
        }
      }
      return s;
    case TYP_POINTER :
      if ((*itpt)->inhalt.i_val == 0 && ITEM_typ(**itpt) == INT)
      { if (!(s = malloc((size_t)4)))
        { komerr(texte[80],17); return NULL; }
        strcpy(s, "NIL");
      }
      else
      { s = wert_string(*itpt, INT); }
      *itpt += inc;
      return s;
    case TYP_SUBRANGE :
      { register int aussen = FALSE;

        switch (ITEM_typ(**itpt))
        { case BOOL :
            aussen = tt->typ_arg1 == para_typ[BOOL] &&
                     !((*itpt)->inhalt.b_val >= tt->typ_arg2 &&
                       (*itpt)->inhalt.b_val <= tt->typ_arg3);
            break;
          case CHA :
            aussen = tt->typ_arg1 == para_typ[CHA] &&
                     !((*itpt)->inhalt.c_val >= tt->typ_arg2 &&
                       (*itpt)->inhalt.c_val <= tt->typ_arg3);
            break;
          case INT :
            aussen = tt->typ_arg1 == para_typ[INT] &&
                     !((*itpt)->inhalt.i_val >= tt->typ_arg2 &&
                       (*itpt)->inhalt.i_val <= tt->typ_arg3);
        }
        s = ex_string(itpt, types_table + tt->typ_arg1 - 1, inc);
        if (aussen)
        { register char *sneu;

          if (!(sneu = realloc(s, (size_t)(strlen(s) + 2))))
          { komerr(texte[80],18);
            if (s) free(s);
            return NULL;
          }
          s = sneu; strcat(s, "!");
        }
      }
      return s;
    case TYP_ENUM :
      if (ITEM_typ(**itpt) == INT &&
          (*itpt)->inhalt.i_val >= tt->typ_arg2 &&
          (*itpt)->inhalt.i_val <= tt->typ_arg3)
      { register char *es;

        es = key_to_name(member_table[tt->typ_arg1 - 1 +
                                        (*itpt)->inhalt.i_val -
                                        tt->typ_arg2].mem_key);
        if (!(s = malloc((size_t)(strlen(es) + 1))))
        { komerr(texte[80],19); return NULL; }
        strcpy(s, es);
      }
      else
      { s = wert_string(*itpt, INT);
        if ((*s >= '0' && *s <= '9') || *s == '-')
        { register char *sneu;

          if (!(sneu = realloc(s, (size_t)(strlen(s) + 2))))
          { komerr(texte[80],20);
            if (s) free(s);
            return NULL;
          }
          s = sneu; strcat(s, "!");
        }
      }
      *itpt += inc;
      return s;
    case TYP_PORT :
    case TYP_PORTTYPE :
      bug("debug.c/ex_string : Portnummer");
  }
}

/**************************************************************************
 ***                Funktion rest_name (rekursiv)
 ***
 *** Erzeugt den String mit den Komponentennamen des einzeilig auszugebenden
 *** Typs '*tt' auf neu alloziertem Speicher.
 ***
 **************************************************************************/

char *rest_name(tt)
TYPTAB *tt;
{ register char *s, *mys, *sadd;
  char sl[20];

  switch (tt->typ_art)
  { case TYP_UNDEF : bug("debug.c/rest_name : undefinierter Typ");
    case TYP_ARRAY :
      { register TYPTAB *ti = types_table + tt->typ_arg1 - 1;
        register TYPTAB *te = types_table + tt->typ_arg2 - 1;

        if (te->typ_art != TYP_CHA)
        { switch (ti->typ_art)
          { case TYP_SUBRANGE :
              { register TYPTAB *to = types_table + ti->typ_arg1 - 1;

                if (to->typ_art == TYP_ENUM) 
                { register MITGTAB *mt = member_table + to->typ_arg1 - 1 +
                                           ti->typ_arg2 - to->typ_arg2;

                  mys = key_to_name(mt->mem_key);
                }
                else
                { sprintf(sl, "%ld", ti->typ_arg2);
                  mys = sl;
                }
              }
              break;
            case TYP_ENUM     :
              { register MITGTAB *mt = member_table + ti->typ_arg1 - 1;
  
                mys = key_to_name(mt->mem_key);
              }
              break;
            default : bug("debug.c/rest_name : falscher Indextyp");
          }
          if (!(sadd = rest_name(te))) return NULL;
          if (!(s = malloc((size_t)(strlen(mys) + strlen(sadd) + 3))))
          { komerr(texte[80],21); return NULL; }
          sprintf(s, "[%s]%s", mys, sadd);
          free(sadd);
        }
        else
        { if (!(s = calloc((size_t)1,(size_t)sizeof(char))))
          { komerr(texte[80],22); }
        }
      }
      break;
    case TYP_RECORD :
    case TYP_UNION :
      { register MITGTAB *mt = member_table + tt->typ_arg1 - 1;

        if (mt->mem_key)
        { mys = key_to_name(mt->mem_key);
          if (!(sadd = rest_name(types_table + mt->typ_wert - 1))) return NULL;
          if (!(s = malloc((size_t)(strlen(mys) + strlen(sadd) + 2))))
          { komerr(texte[80],23); return NULL; }
          sprintf(s, ".%s%s", mys, sadd);
          free(sadd);
        }
      }
      break;
    default :
      if (!(s = calloc((size_t)1,(size_t)sizeof(char))))
      { komerr(texte[80],24); }
  }
  return s;
}

/**************************************************************************
 ***                Funktion fill_komp_names (rekursiv)
 ***
 *** Schreibt die Komponentennamen zum Datentyp '*tt' mit dem Praefix
 *** 'prefix' in das Stringfeld '*strings'.
 *** '*strings' wird weitergezaehlt.
 *** Ergebnis : maximale Ausgabelaenge, bei Fehler 0
 ***
 **************************************************************************/

int fill_komp_names(tt, strings, prefix)
TYPTAB *tt;
char ***strings;
char *prefix;
{ register int len;
  register int maxlen = 0;

  if (tt->ausg_zeilen > 1)
  { char s[400], *sneu;

    strcpy(s, prefix); sneu = s + strlen(s);
    switch (tt->typ_art)
    { case TYP_ARRAY  :
        { register TYPTAB *ti = types_table + tt->typ_arg1 - 1;
          register TYPTAB *te = types_table + tt->typ_arg2 - 1;

          switch (ti->typ_art)
          { case TYP_BOOL     :
              strcpy(sneu, "[FALSE]");
              if (!(len = fill_komp_names(te, strings, s))) return 0;
              if (len > maxlen) maxlen = len;
              strcpy(sneu, "[TRUE]");
              if (!(len = fill_komp_names(te, strings, s))) return 0;
              if (len > maxlen) maxlen = len;
              break;
            case TYP_SUBRANGE :
              { register TYPTAB *to = types_table + ti->typ_arg1 - 1;
                register int i;
        
                if (to->typ_art == TYP_ENUM) 
                { register MITGTAB *mt = member_table + to->typ_arg1 - 1 +
                                           ti->typ_arg2 - to->typ_arg2;

                  for (i = ti->typ_arg2; i <= ti->typ_arg3; mt++, i++)
                  { sprintf(sneu, "[%s]", key_to_name(mt->mem_key));
                    if (!(len = fill_komp_names(te, strings, s))) return 0;
                    if (len > maxlen) maxlen = len;
                  }
                }
                else
                { for (i = ti->typ_arg2; i <= ti->typ_arg3; i++)
                  { sprintf(sneu, "[%d]", i);
                    if (!(len = fill_komp_names(te, strings, s))) return 0;
                    if (len > maxlen) maxlen = len;
                  }
                }
              }
              break;
            case TYP_ENUM     :
              { register MITGTAB *mt = member_table + ti->typ_arg1 - 1;
                register int fertig;

                for (fertig = FALSE; !fertig; mt++)
                { sprintf(sneu, "[%s]", key_to_name(mt->mem_key));
                  if (!(len = fill_komp_names(te, strings, s))) return 0;
                  if (len > maxlen) maxlen = len;
                  fertig = mt->flag_last;
                }
              }
              break;
            default : bug("debug.c/fill_komp_names : falscher Indextyp");
          }
        }
        break;
      case TYP_RECORD :
      case TYP_UNION  :
        { register MITGTAB *mt = member_table + tt->typ_arg1 - 1;
          register int fertig;

          for (fertig = FALSE; !fertig; mt++)
          { if (mt->mem_key)
            { sprintf(sneu, ".%s", key_to_name(mt->mem_key)); }
            else
            { *sneu = '\0'; }
            if (!(len = fill_komp_names(types_table + mt->typ_wert - 1, strings, s)))
            { return 0; }
            if (len > maxlen) maxlen = len;
            fertig = mt->flag_last;
          }
        }
        break;
      default         : bug("debug.c/fill_komp_names : kein Strukturierter Typ");
    }
  }
  else
  { register char *sadd = rest_name(tt);

    if (!sadd) return 0;
    if (**strings) free(**strings);
    if (!(**strings = calloc((size_t)(strlen(prefix) + strlen(sadd) + 3),
                             (size_t)sizeof(char))))
    { komerr(texte[80],25); return 0; }
    sprintf(**strings, "%s%s =", prefix, sadd);
    free(sadd);
    maxlen = strlen(*(*strings)++);
  }
  return maxlen;
}

/**************************************************************************
 ***                      Funktion make_komp_names
 ***
 *** Erzeugt in 'pe_vals[0]' die Komponentennamen zum Datentyp '*tt'
 *** Ergebnis : Maximale Stringlaenge, 0 bei Fehler
 ***
 **************************************************************************/

int make_komp_names(tt)
TYPTAB *tt;
{ char **local_ptr = pe_vals[0].val_strings;
  *pe_vals[0].pe_name = '\0';
  return pe_vals[0].max_len = fill_komp_names(tt, &local_ptr, ""); 
}

/**************************************************************************
 ***                Funktion fill_val_strings (rekursiv)
 ***
 *** Schreibt in das Stringfeld '*strings' die Ausgabestrings
 *** der Variablen vom Typ '*tt', die mit '**itpt' anfaengt.
 *** inc : Adressincrement zur jeweils naechsten Komponente (1 oder 'pe_anz')
 *** Ergebnis : Maximale Stringlaenge, 0 bei Fehler
 ***
 **************************************************************************/

fill_val_strings(itpt, tt, strings, inc)
ITEM **itpt;
TYPTAB *tt;
char ***strings;
int inc;
{ register int len;
  register int maxlen = 0;

  if (tt->ausg_zeilen > 1)
  { switch (tt->typ_art)
    { case TYP_ARRAY  :
        { register TYPTAB *ti = types_table + tt->typ_arg1 - 1;
          register TYPTAB *te = types_table + tt->typ_arg2 - 1;

          switch (ti->typ_art)
          { case TYP_BOOL     :
              if (!(len = fill_val_strings(itpt, te, strings, inc))) return 0;
              if (len > maxlen) maxlen = len;
              if (!(len = fill_val_strings(itpt, te, strings, inc))) return 0;
              if (len > maxlen) maxlen = len;
              break;
            case TYP_SUBRANGE :
            case TYP_ENUM     :
              { register int i;
        
                for (i = ti->typ_arg2; i <= ti->typ_arg3; i++)
                { if (!(len = fill_val_strings(itpt, te, strings, inc))) return 0;
                  if (len > maxlen) maxlen = len;
                }
              }
              break;
            default : bug("debug.c/fill_val_strings : falscher Indextyp");
          }
        }
        break;
      case TYP_RECORD :
        { register MITGTAB *mt = member_table + tt->typ_arg1 - 1;
          register int fertig;

          for (fertig = FALSE; !fertig; mt++)
          { if (!(len = fill_val_strings(itpt,
                                         types_table + mt->typ_wert - 1,
                                         strings, inc)))
            { return 0; }
            if (len > maxlen) maxlen = len;
            fertig = mt->flag_last;
          }
        }
        break;
      case TYP_UNION  :
        { register MITGTAB *mt = member_table + tt->typ_arg1 - 1;
          register int fertig;
          register ITEM *startit = *itpt;

          for (fertig = FALSE; !fertig; mt++)
          { if (!(len = fill_val_strings(itpt,
                                         types_table + mt->typ_wert - 1,
                                         strings, inc)))
            { return 0; }
            if (len > maxlen) maxlen = len;
            *itpt = startit;
            fertig = mt->flag_last;
          }
          *itpt += inc * tt->parz_decl.typ_zahl[SUMM];
        }
        break;
      default         : bug("debug.c/fill_val_strings : kein Strukturierter Typ");
    }
  }
  else
  { if (**strings) free(**strings);
    if (!(**strings = ex_string(itpt, tt, inc)))
    { komerr(texte[80],26); return 0; }
    maxlen = strlen(*(*strings)++);
  }
  return maxlen;
}

/**************************************************************************
 ***                      Funktion make_val_strings
 ***
 *** Schreibt in das Stringfeld in 'pe_vals[num]' die Ausgabestrings
 *** der Variablen vom Typ '*tt', die mit '*it' anfaengt.
 *** inc : Adressincrement zur jeweils naechsten Komponente (1 oder 'pe_anz')
 *** Ergebnis : Maximale Stringlaenge, 0 bei Fehler;
 ***
 **************************************************************************/

int make_val_strings(it, tt, num, inc)
ITEM *it;
TYPTAB *tt;
int num, inc;
{ char **local_ptr = pe_vals[num].val_strings;
  register int len = fill_val_strings(&it, tt, &local_ptr, inc);

  if (len > pe_vals[num].max_len) pe_vals[num].max_len = len;
  return pe_vals[num].max_len;
}

/**************************************************************************
 ***                      Funktion examine_scal
 ***
 *** Gibt das skalare PARZ-Argument '*a' vom Typ '*tt' auf 'f' aus.
 *** s : Ausdruck als Text
 ***
 **************************************************************************/

examine_scal(a, tt, s, f)
ARG *a;
TYPTAB *tt;
char *s;
FILE *f;
{ register int zeil;
  ITEM *expit;

  fputs(s, f);
  bicount = -1;
  expit = item_ptr(a, &dummybs, disp)->itps[0];
  if (!err)
  { if ((zeil = tt->ausg_zeilen) > 1)
    { register int klen, vlen;

      if (init_pe_vals(zeil))
      { if (klen = make_komp_names(tt))
        { if (vlen = make_val_strings(expit, tt, 1, 1))
          { if (vlen > CRTCOLS - klen - 1)
            { pe_vals[1].max_len = CRTCOLS - klen - 1; }
            pe_vals_out(2, zeil, FALSE, f);
          }
        }
        loesch_pe_vals(zeil);
      }
    }
    else
    { register char *temps;

      if (temps = ex_string(&expit, tt, 1))
      { printout(temps, CRTCOLS - strlen(s), f);
        free(temps);
      }
      else
      { komerr(texte[80],27); }
    }
  }
}

typedef struct dim_count      /* Zaehler fuer eine Dimension */
{ long von, bis, wert;
  int len;
} DIM_COUNT;

typedef struct conf_count     /* Zaehler fuer Konfiguration */
{ int dim_zahl;                 /* Zahl der Zaehler in 'dim_array' */
  DIM_COUNT *dim_array;         /* Feld von Dimensionszaehlern */
  long pe_num;                  /* zugehoerige PE-Nummer */
} CONF_COUNT;

/**************************************************************************
 ***                      Funktion conf_count_string
 ***
 *** Erzeugt den Ausgabestring zum Zaehlerstand in '*conf_zpt'
 *** in neu alloziertem Platz.
 ***
 **************************************************************************/

char *conf_count_string(conf_zpt)
CONF_COUNT *conf_zpt;
{ char out[200];
  register DIM_COUNT *da = conf_zpt->dim_array;
  register int dz = conf_zpt->dim_zahl;
  register char *erg;

  out[0] = '\0';
  for (; dz; dz--, da++)
  { sprintf(out + strlen(out), "%s[%*ld]", out[0] ? "," : "", da->len, da->wert); }
  if (erg = malloc((size_t)(strlen(out) + 1)))
  { strcpy(erg, out); }
  return erg;
}

/**************************************************************************
 ***                      Funktion inc_conf_count
 ***
 *** Zaehlt '*conf_zpt' zum naechsten PE weiter.
 *** Ergebnis : TRUE, wenn Bereichsende erreicht.
 ***
 **************************************************************************/

int inc_conf_count(conf_zpt)
CONF_COUNT *conf_zpt;
{ register int dz = conf_zpt->dim_zahl;
  register DIM_COUNT *da = conf_zpt->dim_array + dz - 1;

  conf_zpt->pe_num++;
  for (; dz; dz--, da--)
  { if (da->wert == da->bis)
    { da->wert = da->von; }
    else
    { da->wert++; return FALSE; }
  }
  return TRUE;
}

/**************************************************************************
 ***                      Funktion get_conf
 ***
 *** Sucht die gerade aktive CONFIGURATION, liefert deren Namen als Ergebnis.
 *** Initialisiert '*conf_zpt' mit dem Anfang dieser CONFIGURATION
 ***
 **************************************************************************/

char *get_conf(conf_zpt)
CONF_COUNT *conf_zpt;
{ register SCOPETAB *sc = akt_scope;

  conf_zpt->dim_zahl = 0;
  for (; sc && !sc->par_flag; sc = sc->sym_parent);
  if (sc)
  { register SYMTAB *st = look_sym(sc->proc_key, sc);

    if (st)
    { register TYPTAB *tt = types_table + st->sym_type_scope - 1;

      conf_zpt->pe_num = st->sym_spez;
      for (; tt >= types_table; tt = types_table + tt->typ_arg2 - 1)
      { register TYPTAB *ti = types_table + tt->typ_arg1 - 1;
        register DIM_COUNT *neu, *last;
        char temp[20];
        register int l;

        if (!(neu = (DIM_COUNT *)
                      (conf_zpt->dim_zahl++ ?
                        realloc(conf_zpt->dim_array,
                                (size_t)(conf_zpt->dim_zahl * sizeof(DIM_COUNT))) :
                        malloc((size_t)sizeof(DIM_COUNT)))))
        { komerr(texte[80],28);
          if (conf_zpt->dim_array) free(conf_zpt->dim_array);
          conf_zpt->dim_array = NULL;
          return NULL;
        }
        conf_zpt->dim_array = neu;
        last = neu + conf_zpt->dim_zahl - 1;
        last->von = ti->typ_arg2;
        last->wert = ti->typ_arg2;
        last->bis = ti->typ_arg3;
        sprintf(temp, "%ld", last->von);
        last->len = (int)strlen(temp);
        sprintf(temp, "%ld", last->bis);
        if ((l = (int)strlen(temp)) > last->len) last->len = l;
      }
      return key_to_name(sc->proc_key);
    }
    else
    { return NULL; }
  }
  else
  { return NULL; }
}

static int meldung;             /* Fehlermeldung schon ausgegeben */

/**************************************************************************
 ***                      Funktion examine_vec
 ***
 *** Gibt das vektorielle PARZ-Argument '*a' vom Typ '*tt' auf 'f' aus.
 *** sel : Selektion der PEs, fuer die ausgegeben wird.
 *** s   : Ausdruck als Text
 ***
 **************************************************************************/

examine_vec(sel, a, tt, s, f)
SEXPR *sel;
ARG *a;
TYPTAB *tt;
char *s;
FILE *f;
{ register int all_pes = (sel->sexpr_art == EXPR_SEL_LEER);
  register ITPTRS *selits, *exits;
  register ITEM *sit, *ex;
  register char *conf_name;
  register long i;
  register int zeil, outzahl = 0;
  CONF_COUNT conf_z;

  if (!(conf_name = get_conf(&conf_z)))
  { if (!meldung && !conf_z.dim_zahl)
    { komerr(texte[311]);
      meldung = anz_fehler;
    }
    return;
  }
  fputs(s, f);
  bicount = -1;
  exits = item_ptr(a, &dummybs, disp);
  if (!err && !all_pes) selits = item_ptr(&sel->serg, &dummybs, disp);
  if (!err)
  { for (i = conf_z.pe_num - 1; i; i--)
    { (* exits->n_it_func)(exits);
      if (!all_pes) (* selits->n_it_func)(selits);
    }
    if (init_pe_vals(zeil = tt->ausg_zeilen))
    { register int klen, von, conf_end = FALSE, rest = 0;

      if (zeil > 1)
      { if (!(klen = make_komp_names(tt))) goto ret;
        von = 1;
      }
      else
      { von = klen = 0; }
      while (!quitted && (!conf_end || rest))
      { register int s = von, lensum = klen;

        if (rest)
        { register char *swap1, **swap2;

          swap1 = pe_vals[von].pe_name; swap2 = pe_vals[von].val_strings;
          pe_vals[von].pe_name = pe_vals[rest].pe_name;
          pe_vals[von].val_strings = pe_vals[rest].val_strings;
          pe_vals[rest].pe_name = swap1; pe_vals[rest].val_strings = swap2;
          pe_vals[von].max_len = pe_vals[rest].max_len; pe_vals[rest].max_len = 5;
          lensum += pe_vals[von].max_len + (s > 0);
          s++;
          rest = 0;
        }
        while (!conf_end && lensum <= CRTCOLS)
        { register int vlen;
          register char *ps;

          ex = (* exits->n_it_func)(exits);
          if (!all_pes) sit = (* selits->n_it_func)(selits);
          if (aktive_pes[conf_z.pe_num - 1] == '1' &&
              (all_pes || sit->inhalt.b_val))
          { if (pe_vals[s].pe_name) free(pe_vals[s].pe_name);
            if (ps = conf_count_string(&conf_z))
            { if (!(pe_vals[s].pe_name = (char *)malloc((size_t)(strlen(conf_name) +
                                                                   strlen(ps) + 1))))
              { komerr(texte[80],29); goto ret; }
              sprintf(pe_vals[s].pe_name, "%s%s", conf_name, ps);
              free(ps);
              pe_vals[s].max_len = strlen(pe_vals[s].pe_name);
              if (vlen = make_val_strings(ex, tt, s, pe_anz))
              { if (vlen < 5) vlen = pe_vals[s].max_len = 5;
                lensum += vlen + (s > 0);
              }
              else goto ret;
            }
            outzahl++; s++;
          }
          conf_end = inc_conf_count(&conf_z);
        }
        if (lensum > CRTCOLS)
        { if (s == von + 1)
          { pe_vals[von].max_len = CRTCOLS - klen - 1;
            rest = 0;
          }
          else
          { rest = --s; }
        }
        pe_vals_out(s, zeil, TRUE, f);
      }
ret:
      loesch_pe_vals(zeil);
    }
  }
  if (conf_z.dim_array) free(conf_z.dim_array);
  if (!outzahl)
  { fputs(texte[312], f); ifmore(f); }
}

/**************************************************************************
 ***                      Funktion elist_out
 ***
 *** Gibt den Wert der Ausdruckergebnisse in '*elist' auf den durch
 *** die Selektionsvariable in '*sel' ausgewaehlten PEs auf 'f' aus
 *** Ergebnis: gibt an, ob Zeilenvorschub erforderlich ist
 ***
 **************************************************************************/

char elist_out(sel, elist, f)
SEXPR *sel;
EXPRLIST *elist;
FILE *f;
{ register int i;
  register EXPR *ex;
  register char nl_out = FALSE;
  char s[500];

  meldung = 0;
  for (i = elist->expr_count, ex = elist->expr_array;
       i && anz_fehler <= meldung;
       i--, ex++)
  { if (ex->expr_art == EXPR_VAR)
    { register TYPTAB *tt =
        types_table + (ex->typerg ? ex->typerg : ex->typlast) - 1;
      register ARG *a = ex->typerg ? &ex->erg : &ex->lastval;

      if (tt->ausg_zeilen == 1)
      { register char *sadd = rest_name(tt);

        if (!sadd) { return FALSE; }
        sprintf(s, "%s%s = ", ex->expr_str, sadd);
        free(sadd);
      }
      else
      { sprintf(s, "%s : ", ex->expr_str); }
      if (ARG_argsort(*a) & VEC)
      { if (!meldung)
        { if (nl_out)
          { putc('\n', f); ifmore(f);
	    if (quitted) { return FALSE; }
            putc('\n', f); ifmore(f);
	    if (quitted) { return FALSE; }
          }
          examine_vec(sel, a, tt, s, f);
          nl_out = !meldung;
        }
      }
      else
      { if (nl_out)
        { putc('\n', f); ifmore(f);
	  if (quitted) { return FALSE; }
          putc('\n', f); ifmore(f);
	  if (quitted) { return FALSE; }
        }
        examine_scal(a, tt, s, f);
        nl_out = TRUE;
      }
    }
  }
  return nl_out;
}
