/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : Simulation
  Filename     : do_5fu.c       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.do_5fu.c
  Version      : 1.3 
  Last changed : 9/27/93 at 14:04:50        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : Funktionen zur Simulation der PARZ-Befehle

******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/

static char sccs_id[] = "@(#)do_5fu.c	1.3  9/27/93 PARZ - Simulation (Frank Sembach)";


#include "parzdefs.h"
#include "rundefs.h"
#include "komdefs.h"
#include "y_tab.h"
#include "externs.h"
#include "runexts.h"
#include "toup.h"
#include "xgraph.h"

extern FILE *yyerfp;            /* Ausgabedatei fuer Fehlermeldungen */

extern char *wert_string();     /* aus Datei print_fu.c */

extern AKTBLOCK *temp_a_block;  /* Zeiger auf Aktivierungsblock,
                                   der durch CALL erzeugt wurde und
                                   von PROC vervollstaendigt werden muss */

extern int sym_debugging;       /* Flag: symbolisches Debuggen */

extern char *liesstring();
extern unsigned char *hole_string();

/**************************************************************************
 ***                      Funktion do_propagate
 ***
 *** fuehrt Befehl 'PROPAGATE vc1 OUT out_port IN in_port' aus
 ***
 **************************************************************************/

int do_propagate(bef)
STAT *bef;
{ register ITEM *buf, *outp, *inp;
  register int outnum, innum, i;
  register PORT *poptr;
  register long outn, inn;
  register TYP t = ARG_valtyp(STAT_vc1(*bef));

  protokoll('P', aktive_pes);
  if (reducing)
  { runerr(texte[114]); return; }
  outp = item_ptr(&STAT_out_port(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  ini_typ_test(outp->datentyp, INT, 91, 283);
  outnum = (int)(outn = outp->inhalt.i_val);
  if (outn < 1l || outn > (long)port_anz)
  { runerr(texte[64], outnum); return; }
  inp = item_ptr(&STAT_in_port(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  ini_typ_test(inp->datentyp, INT, 91, 283);
  innum = (int)(inn = inp->inhalt.i_val);
  if (inn < 1l || inn > (long)port_anz)
  { runerr(texte[64], innum); return; }
  zielits = item_ptr(&STAT_vc1(*bef), &zielbs, disp);
  if (err) return;

        /* alle Eingangspuffer ungueltig machen */
  for (poptr = &PNR(1, innum), i = 0; i < pe_anz; i++, poptr += port_anz)
  { poptr->inbuf.datentyp = 0; }
  for (poptr = &PNR(1, innum), i = 0; i < pe_anz; i++, poptr += port_anz)
  { poptr->inbuf.datentyp = MARKE * (aktive_pes[i] == '0'); }
  vec_bef = TRUE;

        /* alle aktiven PEs schreiben in Zielpuffer */
  for (pec = 0, poptr = &PNR(1, outnum); pec < last_akt_pe; pec++, poptr += port_anz)
  { register int count;
    register PORT **pzptr;

    buf = (* zielits->n_it_func)(zielits);
    if (aktive_pes[pec] == '1' && (count = poptr->out_count))
    { for (pzptr = poptr->zielarr; count; count--, pzptr++)
      { if ((*pzptr - portarray) % port_anz == innum - 1 &&
            !((*pzptr)->inbuf.datentyp & MARKE))
        { if ((*pzptr)->inbuf.datentyp)
          { runerr(texte[115]); return; }
          else
          { (*pzptr)->inbuf.datentyp = KEINER | ERLAUBT(t);
            set_item(&(*pzptr)->inbuf, buf, t);
            if (err) return;
          }
        }
      }
    }
  }
  zielits->ip_count = 0;

        /* alle aktiven PEs lesen aus Eingangspuffer, falls gueltig */
  for (pec = 0, poptr = &PNR(1, innum); pec < last_akt_pe; pec++, poptr += port_anz)
  { buf = (* zielits->n_it_func)(zielits);
    if (aktive_pes[pec] == '1' && poptr->inbuf.datentyp)
    { set_item(buf, &poptr->inbuf, t);
      if (err) return;
    }
  }
}

/**************************************************************************
 ***                      Funktion to_err
 ***
 *** Fehlerausgabe fuer propagate, send, receive ohne REDUCE
 ***
 **************************************************************************/

int to_err(ziel, quell)
ITEM *ziel,quell;
{ runerr(texte[115]);
}

/**************************************************************************
 ***                      Funktion red_bug
 ***
 *** Bugausgabe fuer propagate, send, receive
 ***
 **************************************************************************/

int red_bug(ziel, quell, uflag)
ITEM *ziel,quell;
int uflag;
{ bug("do_5fu.c/red_bug : unerlaubter Aufruf");
}

/**************************************************************************
 ***                      Funktionen redopx
 ***
 *** Reduktionsoperatoren fuer die Befehle PROPAGATE, SEND und RECEIVE
 *** 'x' bezeichnet Typen fuer die Operatoren sum, prod, max, min
 *** Operatoren werden auf '*ziel' und '*quell' angewandt,
 *** das Ergebnis kommt nach '*ziel'.
 *** Enthaelt 'uflag' 'UNDEF_ERG' wird dies in '*ziel' eingetragen.
 ***
 **************************************************************************/

int redand(ziel,quell,uflag)
ITEM *ziel, *quell;
int uflag;
{ ziel->inhalt.b_val = ziel->inhalt.b_val && quell->inhalt.b_val;
  UNDEF_PUT(ziel->datentyp, quell->datentyp | uflag);
}

int redor(ziel,quell,uflag)
ITEM *ziel, *quell;
int uflag;
{ ziel->inhalt.b_val = ziel->inhalt.b_val || quell->inhalt.b_val;
  UNDEF_PUT(ziel->datentyp, quell->datentyp | uflag);
}

int redfirst(ziel,quell,uflag)
ITEM *ziel, *quell;
int uflag;
{ UNDEF_PUT(ziel->datentyp, quell->datentyp | uflag);
}

int redlast(ziel,quell,uflag)
ITEM *ziel, *quell;
int uflag;
{ ziel->inhalt = quell->inhalt;
  UNDEF_PUT(ziel->datentyp, quell->datentyp | uflag);
}

int redsumi(ziel,quell,uflag)
ITEM *ziel, *quell;
int uflag;
{ ziel->inhalt.i_val += quell->inhalt.i_val;
  UNDEF_PUT(ziel->datentyp, quell->datentyp | uflag);
}

int redsumr(ziel,quell,uflag)
ITEM *ziel, *quell;
int uflag;
{ ziel->inhalt.r_val += quell->inhalt.r_val;
  UNDEF_PUT(ziel->datentyp, quell->datentyp | uflag);
}

int redprodi(ziel,quell,uflag)
ITEM *ziel, *quell;
int uflag;
{ ziel->inhalt.i_val *= quell->inhalt.i_val;
  UNDEF_PUT(ziel->datentyp, quell->datentyp | uflag);
}

int redprodr(ziel,quell,uflag)
ITEM *ziel, *quell;
int uflag;
{ ziel->inhalt.r_val *= quell->inhalt.r_val;
  UNDEF_PUT(ziel->datentyp, quell->datentyp | uflag);
}

int redmaxb(ziel,quell,uflag)
ITEM *ziel, *quell;
int uflag;
{ if (quell->inhalt.b_val) ziel->inhalt.b_val = TRUE;
  UNDEF_PUT(ziel->datentyp, quell->datentyp | uflag);
}

int redmaxc(ziel,quell,uflag)
ITEM *ziel, *quell;
int uflag;
{ if (quell->inhalt.c_val > ziel->inhalt.c_val)
    ziel->inhalt.c_val = quell->inhalt.c_val; 
  UNDEF_PUT(ziel->datentyp, quell->datentyp | uflag);
}

int redmaxi(ziel,quell,uflag)
ITEM *ziel, *quell;
int uflag;
{ if (quell->inhalt.i_val > ziel->inhalt.i_val)
    ziel->inhalt.i_val = quell->inhalt.i_val; 
  UNDEF_PUT(ziel->datentyp, quell->datentyp | uflag);
}

int redmaxr(ziel,quell,uflag)
ITEM *ziel, *quell;
int uflag;
{ if (quell->inhalt.r_val > ziel->inhalt.r_val)
    ziel->inhalt.r_val = quell->inhalt.r_val; 
  UNDEF_PUT(ziel->datentyp, quell->datentyp | uflag);
}

int redminb(ziel,quell,uflag)
ITEM *ziel, *quell;
int uflag;
{ if (!quell->inhalt.b_val) ziel->inhalt.b_val = FALSE; 
  UNDEF_PUT(ziel->datentyp, quell->datentyp | uflag);
}

int redminc(ziel,quell,uflag)
ITEM *ziel, *quell;
int uflag;
{ if (quell->inhalt.c_val < ziel->inhalt.c_val)
    ziel->inhalt.c_val = quell->inhalt.c_val; 
  UNDEF_PUT(ziel->datentyp, quell->datentyp | uflag);
}

int redmini(ziel,quell,uflag)
ITEM *ziel, *quell;
int uflag;
{ if (quell->inhalt.i_val < ziel->inhalt.i_val)
    ziel->inhalt.i_val = quell->inhalt.i_val; 
  UNDEF_PUT(ziel->datentyp, quell->datentyp | uflag);
}

int redminr(ziel,quell,uflag)
ITEM *ziel, *quell;
int uflag;
{ if (quell->inhalt.r_val < ziel->inhalt.r_val)
    ziel->inhalt.r_val = quell->inhalt.r_val; 
  UNDEF_PUT(ziel->datentyp, quell->datentyp | uflag);
}

int (* redop_fu[MIN - AND + 2][REAL + 1])() = /* eigentliche Funktionen */
{ { to_err, to_err, to_err, to_err },
  { redand, red_bug, red_bug, red_bug },
  { redor, red_bug, red_bug, red_bug },
  { redfirst, redfirst, redfirst, redfirst },
  { redlast, redlast, redlast, redlast },
  { red_bug, red_bug, redsumi, redsumr },
  { red_bug, red_bug, redprodi, redprodr },
  { redmaxb, redmaxc, redmaxi, redmaxr },
  { redminb, redminc, redmini, redminr }
};

/**************************************************************************
 ***                      Funktion do_to_propagate
 ***
 *** fuehrt Befehle 'PROPAGATE vc1 TO verg' und
 ***                'PROPAGATE vc1 TO verg REDUCE op' aus
 ***
 **************************************************************************/

int do_to_propagate(bef)
STAT *bef;
{ register ITEM *quellziel;
  register ITPTRS *quellits;
  ITEM popit;
  register int outnum, innum, i;
  register PORT *poptr;
  register long outn, inn;
  register TYP t = ARG_valtyp(STAT_vc1(*bef));
  register int uflag;

  protokoll('P', aktive_pes);
  if (reducing)
  { runerr(texte[114]); return; }
  popit.datentyp = KEINER | INT_ERLAUBT;
  STACK_pop(&popit, &scal_stack, INT);
  if (err) return;
  innum = (int)(inn = popit.inhalt.i_val);
  if (inn < 1l || inn > (long)port_anz)
  { runerr(texte[64], innum); return; }
  STACK_pop(&popit, &scal_stack, INT);
  if (err) return;
  outnum = (int)(outn = popit.inhalt.i_val);
  if (outn < 1l || outn > (long)port_anz)
  { runerr(texte[64], outnum); return; }
  quellits = item_ptr(&STAT_vc1(*bef), &dummybs, disp);
  if (err) return;
  zielits = item_ptr(&STAT_verg(*bef), &zielbs, disp);
  if (err) return;

        /* alle Eingangspuffer ungueltig machen */
  for (poptr = &PNR(1, innum), i = 0; i < pe_anz; i++, poptr += port_anz)
  { poptr->inbuf.datentyp = MARKE * (aktive_pes[i] == '0'); }
  vec_bef = TRUE;

        /* alle aktiven PEs schreiben in Zielpuffer */
  for (pec = 0, poptr = &PNR(1, outnum); pec < last_akt_pe; pec++, poptr += port_anz)
  { register int count;
    register PORT **pzptr;

    quellziel = (* quellits->n_it_func)(quellits);
    if (aktive_pes[pec] == '1' && (count = poptr->out_count))
    { for (pzptr = poptr->zielarr; count; count--, pzptr++)
      { if ((*pzptr - portarray) % port_anz == innum - 1 &&
            !((*pzptr)->inbuf.datentyp & MARKE))
        { if ((*pzptr)->inbuf.datentyp)
          { uflag = ini_typ_test(quellziel->datentyp, t, 91, 283);
            (* redop_fu[STAT_red_fct(*bef) - AND + 1][t])(&(*pzptr)->inbuf, quellziel, uflag);
            if (err || fperror) return;
          }
          else
          { (*pzptr)->inbuf.datentyp = KEINER | ERLAUBT(t);
            set_item(&(*pzptr)->inbuf, quellziel, t);
            if (err || fperror) return;
          }
        }
      }
    }
  }

        /* alle aktiven PEs lesen aus Eingangspuffer, falls gueltig */
  for (pec = 0, poptr = &PNR(1, innum); pec < last_akt_pe; pec++, poptr += port_anz)
  { quellziel = (* zielits->n_it_func)(zielits);
    if (aktive_pes[pec] == '1' && poptr->inbuf.datentyp)
    { set_item(quellziel, &poptr->inbuf, t);
      if (err || fperror) return;
    }
  }
}

/**************************************************************************
 ***                      Funktion do_redproc_propagate
 ***
 *** fuehrt Befehl 'PROPAGATE vc1 TO verg REDUCE label' aus
 ***
 **************************************************************************/

int do_redproc_propagate(bef)
STAT *bef;
{ register ITEM *quellziel;
  register ITPTRS *quellits;
  ITEM popit;
  register int outnum, innum, i;
  register PORT *poptr;
  register long outn, inn;
  register TYP t = ARG_valtyp(STAT_vc1(*bef));
  register int anz_akt_save = anz_akt_pes;
  register int last_akt, last_akt_save = last_akt_pe;
  register char *akt_pes_save = aktive_pes;

  protokoll('P', aktive_pes);
  if (reducing)
  { runerr(texte[114]); return; }
  popit.datentyp = KEINER | INT_ERLAUBT;
  STACK_pop(&popit, &scal_stack, INT);
  if (err) return;
  innum = (int)(inn = popit.inhalt.i_val);
  if (inn < 1l || inn > (long)port_anz)
  { runerr(texte[64], innum); return; }
  STACK_pop(&popit, &scal_stack, INT);
  if (err) return;
  outnum = (int)(outn = popit.inhalt.i_val);
  if (outn < 1l || outn > (long)port_anz)
  { runerr(texte[64], outnum); return; }
  quellits = item_ptr(&STAT_vc1(*bef), &dummybs, disp);
  if (err) return;

        /* alle Eingangspuffer als Zaehler mit 1 belegen */
  for (poptr = &PNR(1, innum), i = 0; i < pe_anz; i++, poptr += port_anz)
  { poptr->inbuf.datentyp = MARKE * (aktive_pes[i] == '0');
    poptr->inbuf.inhalt.i_val = 1;
  }
  vec_bef = TRUE;

        /* alle aktiven PEs schreiben auf Stacks, zaehlen in Zielpuffer */
  for (pec = 0, poptr = &PNR(1, outnum); pec < last_akt_pe; pec++, poptr += port_anz)
  { register int count;
    register PORT **pzptr;

    quellziel = (* quellits->n_it_func)(quellits);
    if (aktive_pes[pec] == '1' && (count = poptr->out_count))
    { for (pzptr = poptr->zielarr; count; count--, pzptr++)
      { if ((*pzptr - portarray) % port_anz == innum - 1 &&
            !((*pzptr)->inbuf.datentyp & MARKE))
        { (*pzptr)->inbuf.inhalt.i_val++;
          STACK_push(quellziel, vec_stacks + (*pzptr - portarray) / port_anz, t);
          if (err || fperror) return;
        }
      }
    }
  }

        /* alle aktiven PEs reduzieren auf Stack, bis nur noch ein Wert auf Stack */
  if (!(aktive_pes = calloc((size_t)(pe_anz + 1), (size_t)sizeof(char))))
  { runerr(texte[232]); return; }
  strcpy(aktive_pes, akt_pes_save);
  do
  { for (pec = last_akt = anz_akt_pes = 0, poptr = &PNR(1, innum);
         pec < last_akt_pe;
         pec++, poptr += port_anz)
    { if (aktive_pes[pec] == '1')
      { if (--(poptr->inbuf.inhalt.i_val) <= 1)
        { aktive_pes[pec] = '0'; }
        else
        { last_akt = pec + 1;
          anz_akt_pes++;
        }
      }
    }
    last_akt_pe = last_akt;
    if (anz_akt_pes == 0) break;
    red_proc_call(bef);
    switch (exit_code)
    { case DO_STOP:
      case DO_LOAD:
      case DO_COMPILE: return;
    }
    if (err || fperror) break;
  } while (1);

  anz_akt_pes = anz_akt_save;
  last_akt_pe = last_akt_save;
  free(aktive_pes);
  aktive_pes = akt_pes_save;
  if (err || fperror) return;

        /* Ziel ermitteln fuer alle aktiven PEs */
  zielits = item_ptr(&STAT_verg(*bef), &zielbs, disp);
  if (err) return;
        /* alle aktiven PEs lesen vom Stack */
  for (pec = 0, poptr = &PNR(1, innum); pec < last_akt_pe; pec++, poptr += port_anz)
  { quellziel = (* zielits->n_it_func)(zielits);
    if (aktive_pes[pec] == '1' && poptr->inbuf.inhalt.i_val)
    { STACK_pop(quellziel, vec_stacks + pec, t);
      if (err || fperror) return;
    }
  }
}

/**************************************************************************
 ***                   Funktion real_vartiefe
 ***
 *** ermittelt die Schachtelungsebene des Arguments 'a', die fuer 
 *** das Ziel von SEND bzw. die Quelle von RECEIVE aktiv sein muss.
 ***
 **************************************************************************/

int real_vartiefe(a)
ARG *a;
{ register ARGART asort = ARG_argsort(*a);

  if (asort & (CON | SPEZ)) return 0;
  if (asort & INDL)
  { register int t = ARG_tiefe(*a);
    register int vt = ARG_vartiefe(*a);

    return (vt > t) ? vt : t;
  }
  return ARG_tiefe(*a);
}

/**************************************************************************
 ***                      Funktion do_send
 ***
 *** fuehrt Befehle 'SEND vc1 TO verg' und
 ***                'SEND vc1 TO verg REDUCE op' aus.
 ***
 **************************************************************************/

int do_send(bef)
STAT *bef;
{ register ITEM *quellziel;
  register ITPTRS *quellits;
  ITEM popit;
  register int outnum, innum, i;
  register PORT *poptr;
  register long outn, inn;
  register TYP t = ARG_valtyp(STAT_vc1(*bef));
  register char *get_akt_pes = disp[real_vartiefe(&STAT_verg(*bef))]->start_aktiv;
  register char *akt_pes_save;
  register int last_akt_save, anz_akt_save;
  register int uflag;

  if (reducing)
  { runerr(texte[114]); return; }
  popit.datentyp = KEINER | INT_ERLAUBT;
  STACK_pop(&popit, &scal_stack, INT);
  if (err) return;
  innum = (int)(inn = popit.inhalt.i_val);
  if (inn < 1l || inn > (long)port_anz)
  { runerr(texte[64], innum); return; }
  STACK_pop(&popit, &scal_stack, INT);
  if (err) return;
  outnum = (int)(outn = popit.inhalt.i_val);
  if (outn < 1l || outn > (long)port_anz)
  { runerr(texte[64], outnum); return; }
  quellits = item_ptr(&STAT_vc1(*bef), &dummybs, disp);
  if (err) return;

        /* alle Eingangspuffer ungueltig machen */
  for (poptr = &PNR(1, innum), i = 0; i < pe_anz; i++, poptr += port_anz)
  { poptr->inbuf.datentyp = MARKE * (get_akt_pes[i] == '0'); }
  vec_bef = TRUE;

        /* alle aktiven PEs schreiben in Zielpuffer */
  for (pec = 0, poptr = &PNR(1, outnum); pec < last_akt_pe; pec++, poptr += port_anz)
  { register int count;
    register PORT **pzptr;

    quellziel = (* quellits->n_it_func)(quellits);
    if (aktive_pes[pec] == '1' && (count = poptr->out_count))
    { for (pzptr = poptr->zielarr; count; count--, pzptr++)
      { if ((*pzptr - portarray) % port_anz == innum - 1 &&
            !((*pzptr)->inbuf.datentyp & MARKE))
        { if ((*pzptr)->inbuf.datentyp)
          { uflag = ini_typ_test(quellziel->datentyp, t, 91, 283);
            (* redop_fu[STAT_red_fct(*bef) - AND + 1][t])(&(*pzptr)->inbuf, quellziel, uflag);
            if (err || fperror) return;
          }
          else
          { (*pzptr)->inbuf.datentyp = KEINER | ERLAUBT(t);
            set_item(&(*pzptr)->inbuf, quellziel, t);
            if (err || fperror) return;
          }
        }
      }
    }
  }

        /* Ziel ermitteln fuer alle PEs, die die Variable kennen */
  akt_pes_save = aktive_pes;
  last_akt_save = last_akt_pe;
  anz_akt_save = anz_akt_pes;
  aktive_pes = get_akt_pes;
  last_akt_pe = last(aktive_pes,&anz_akt_pes);
  protokoll('P', aktive_pes);
  zielits = item_ptr(&STAT_verg(*bef), &zielbs, disp);
  if (err) return;

        /* alle PEs lesen aus Eingangspuffer, falls gueltig */
  for (pec = 0, poptr = &PNR(1, innum); pec < last_akt_pe; pec++, poptr += port_anz)
  { quellziel = (* zielits->n_it_func)(zielits);
    if (aktive_pes[pec] == '1' && poptr->inbuf.datentyp)
    { set_item(quellziel, &poptr->inbuf, t);
      if (err || fperror) break;
    }
  }
  aktive_pes = akt_pes_save;
  last_akt_pe = last_akt_save;
  anz_akt_pes = anz_akt_save;
}

/**************************************************************************
 ***                      Funktion do_redproc_send
 ***
 *** fuehrt Befehl 'SEND vc1 TO verg REDUCE label' aus
 ***
 **************************************************************************/

int do_redproc_send(bef)
STAT *bef;
{ register ITEM *quellziel;
  register ITPTRS *quellits;
  ITEM popit;
  register int outnum, innum, i;
  register PORT *poptr;
  register long outn, inn;
  register TYP t = ARG_valtyp(STAT_vc1(*bef));
  register int anz_akt_save = anz_akt_pes;
  register int last_akt, last_akt_save = last_akt_pe;
  register char *get_akt_pes = disp[real_vartiefe(&STAT_verg(*bef))]->start_aktiv;
  register char *akt_pes_save = aktive_pes;

  if (reducing)
  { runerr(texte[114]); return; }
  popit.datentyp = KEINER | INT_ERLAUBT;
  STACK_pop(&popit, &scal_stack, INT);
  if (err) return;
  innum = (int)(inn = popit.inhalt.i_val);
  if (inn < 1l || inn > (long)port_anz)
  { runerr(texte[64], innum); return; }
  STACK_pop(&popit, &scal_stack, INT);
  if (err) return;
  outnum = (int)(outn = popit.inhalt.i_val);
  if (outn < 1l || outn > (long)port_anz)
  { runerr(texte[64], outnum); return; }
  quellits = item_ptr(&STAT_vc1(*bef), &dummybs, disp);
  if (err) return;

        /* alle Eingangspuffer als Zaehler mit 1 belegen */
  for (poptr = &PNR(1, innum), i = 0; i < pe_anz; i++, poptr += port_anz)
  { poptr->inbuf.datentyp = MARKE * (get_akt_pes[i] == '0');
    poptr->inbuf.inhalt.i_val = 1;
  }
  vec_bef = TRUE;

        /* alle aktiven PEs schreiben auf Stacks, zaehlen in Zielpuffer */
  for (pec = 0, poptr = &PNR(1, outnum); pec < last_akt_pe; pec++, poptr += port_anz)
  { register int count;
    register PORT **pzptr;

    quellziel = (* quellits->n_it_func)(quellits);
    if (aktive_pes[pec] == '1' && (count = poptr->out_count))
    { for (pzptr = poptr->zielarr; count; count--, pzptr++)
      { if ((*pzptr - portarray) % port_anz == innum - 1 &&
            !((*pzptr)->inbuf.datentyp & MARKE))
        { (*pzptr)->inbuf.inhalt.i_val++;
          STACK_push(quellziel, vec_stacks + (*pzptr - portarray) / port_anz, t);
          if (err || fperror) return;
        }
      }
    }
  }

        /* alle PEs reduzieren auf Stack, bis nur noch ein Wert auf Stack */
  aktive_pes = get_akt_pes;
  last_akt_pe = last(aktive_pes, &anz_akt_pes);
  protokoll('P', aktive_pes);
  if (!(aktive_pes = calloc((size_t)(pe_anz + 1), (size_t)sizeof(char))))
  { runerr(texte[232]); return; }
  strcpy(aktive_pes, get_akt_pes);
  do
  { for (pec = last_akt = anz_akt_pes = 0, poptr = &PNR(1, innum);
         pec < last_akt_pe;
         pec++, poptr += port_anz)
    { if (aktive_pes[pec] == '1')
      { if (--(poptr->inbuf.inhalt.i_val) <= 1)
        { aktive_pes[pec] = '0'; }
        else
        { last_akt = pec + 1;
          anz_akt_pes++;
        }
      }
    }
    last_akt_pe = last_akt;
    if (anz_akt_pes == 0) break;
    red_proc_call(bef);
    switch (exit_code)
    { case DO_STOP:
      case DO_LOAD:
      case DO_COMPILE: return;
    }
    if (err || fperror) break;
  } while (1);

  free(aktive_pes);
  aktive_pes = get_akt_pes;
  last_akt_pe = last(aktive_pes, &anz_akt_pes);
  if (err || fperror) return;

        /* Ziel ermitteln fuer alle PEs, die die Variable kennen */
  zielits = item_ptr(&STAT_verg(*bef), &zielbs, disp);
  if (err) return;

        /* alle PEs lesen vom Stack */
  for (pec = 0, poptr = &PNR(1, innum); pec < last_akt_pe; pec++, poptr += port_anz)
  { quellziel = (* zielits->n_it_func)(zielits);
    if (aktive_pes[pec] == '1' && poptr->inbuf.inhalt.i_val)
    { STACK_pop(quellziel, vec_stacks + pec, t);
      if (err || fperror) break;
    }
  }
  aktive_pes = akt_pes_save;
  last_akt_pe = last_akt_save;
  anz_akt_pes = anz_akt_save;
}

/**************************************************************************
 ***                  Funktion do_receive
 ***
 *** fuehrt Befehl 'RECEIVE verg FROM vc1' und
 ***               'RECEIVE verg FROM vc1 REDUCE op' aus.
 ***
 **************************************************************************/

int do_receive(bef)
STAT *bef;
{ register ITEM *quellziel;
  register ITPTRS *quellits;
  ITEM popit;
  register int outnum, innum, i;
  register PORT *poptr;
  register long outn, inn;
  register TYP t = ARG_valtyp(STAT_vc1(*bef));
  register char *akt_pes_save;
  register int last_akt_save, anz_akt_save;
  register int uflag;

  if (reducing)
  { runerr(texte[114]); return; }
  popit.datentyp = KEINER | INT_ERLAUBT;
  STACK_pop(&popit, &scal_stack, INT);
  if (err) return;
  innum = (int)(inn = popit.inhalt.i_val);
  if (inn < 1l || inn > (long)port_anz)
  { runerr(texte[64], innum); return; }
  STACK_pop(&popit, &scal_stack, INT);
  if (err) return;
  outnum = (int)(outn = popit.inhalt.i_val);
  if (outn < 1l || outn > (long)port_anz)
  { runerr(texte[64], outnum); return; }

        /* Quelle ermitteln fuer alle PEs, die die Variable kennen */
  akt_pes_save = aktive_pes;
  last_akt_save = last_akt_pe;
  anz_akt_save = anz_akt_pes;
  aktive_pes = disp[real_vartiefe(&STAT_vc1(*bef))]->start_aktiv;
  last_akt_pe = last(aktive_pes,&anz_akt_pes);
  protokoll('P', aktive_pes);
  quellits = item_ptr(&STAT_vc1(*bef), &dummybs, disp);
  if (err) return;

        /* alle Eingangspuffer ungueltig machen */
  for (poptr = &PNR(1, innum), i = 0; i < pe_anz; i++, poptr += port_anz)
  { poptr->inbuf.datentyp = MARKE * (akt_pes_save[i] == '0'); }
  vec_bef = TRUE;

        /* alle PEs schreiben in Zielpuffer */
  for (pec = 0, poptr = &PNR(1, outnum); pec < last_akt_pe; pec++, poptr += port_anz)
  { register int count;
    register PORT **pzptr;

    quellziel = (* quellits->n_it_func)(quellits);
    if (aktive_pes[pec] == '1' && (count = poptr->out_count))
    { for (pzptr = poptr->zielarr; count; count--, pzptr++)
      { if ((*pzptr - portarray) % port_anz == innum - 1 &&
            !((*pzptr)->inbuf.datentyp & MARKE))
        { if ((*pzptr)->inbuf.datentyp)
          { uflag = ini_typ_test(quellziel->datentyp, t, 91, 283);
            (* redop_fu[STAT_red_fct(*bef) - AND + 1][t])(&(*pzptr)->inbuf, quellziel, uflag);
            if (err || fperror) return;
          }
          else
          { (*pzptr)->inbuf.datentyp = KEINER | ERLAUBT(t);
            set_item(&(*pzptr)->inbuf, quellziel, t);
            if (err || fperror) return;
          }
        }
      }
    }
  }
  aktive_pes = akt_pes_save;
  last_akt_pe = last_akt_save;
  anz_akt_pes = anz_akt_save;

        /* Ziel ermitteln fuer alle aktiven PEs */
  zielits = item_ptr(&STAT_verg(*bef), &zielbs, disp);
  if (err) return;

        /* alle aktiven PEs lesen aus Eingangspuffer, falls gueltig */
  for (pec = 0, poptr = &PNR(1, innum); pec < last_akt_pe; pec++, poptr += port_anz)
  { quellziel = (* zielits->n_it_func)(zielits);
    if (aktive_pes[pec] == '1' && poptr->inbuf.datentyp)
    { set_item(quellziel, &poptr->inbuf, t);
      if (err || fperror) return;
    }
  }
}

/**************************************************************************
 ***                      Funktion do_redproc_receive
 ***
 *** fuehrt Befehl 'RECEIVE verg FROM vc1 REDUCE label' aus
 ***
 **************************************************************************/

int do_redproc_receive(bef)
STAT *bef;
{ register ITEM *quellziel;
  register ITPTRS *quellits;
  ITEM popit;
  register int outnum, innum, i;
  register PORT *poptr;
  register long outn, inn;
  register TYP t = ARG_valtyp(STAT_vc1(*bef));
  register int anz_akt_save = anz_akt_pes;
  register int last_akt, last_akt_save = last_akt_pe;
  register char *akt_pes_save = aktive_pes;

  if (reducing)
  { runerr(texte[114]); return; }
  popit.datentyp = KEINER | INT_ERLAUBT;
  STACK_pop(&popit, &scal_stack, INT);
  if (err) return;
  innum = (int)(inn = popit.inhalt.i_val);
  if (inn < 1l || inn > (long)port_anz)
  { runerr(texte[64], innum); return; }
  STACK_pop(&popit, &scal_stack, INT);
  if (err) return;
  outnum = (int)(outn = popit.inhalt.i_val);
  if (outn < 1l || outn > (long)port_anz)
  { runerr(texte[64], outnum); return; }

        /* Quelle ermitteln fuer alle PEs, die die Variable kennen */
  aktive_pes = disp[real_vartiefe(&STAT_vc1(*bef))]->start_aktiv;
  last_akt_pe = last(aktive_pes,&anz_akt_pes);
  protokoll('P', aktive_pes);
  quellits = item_ptr(&STAT_vc1(*bef), &dummybs, disp);
  if (err) return;

        /* alle Eingangspuffer als Zaehler mit 1 belegen */
  for (poptr = &PNR(1, innum), i = 0; i < pe_anz; i++, poptr += port_anz)
  { poptr->inbuf.datentyp = MARKE * (akt_pes_save[i] == '0');
    poptr->inbuf.inhalt.i_val = 1;
  }
  vec_bef = TRUE;

        /* alle PEs schreiben auf Stacks, zaehlen in Zielpuffer */
  for (pec = 0, poptr = &PNR(1, outnum); pec < last_akt_pe; pec++, poptr += port_anz)
  { register int count;
    register PORT **pzptr;

    quellziel = (* quellits->n_it_func)(quellits);
    if (aktive_pes[pec] == '1' && (count = poptr->out_count))
    { for (pzptr = poptr->zielarr; count; count--, pzptr++)
      { if ((*pzptr - portarray) % port_anz == innum - 1 &&
            !((*pzptr)->inbuf.datentyp & MARKE))
        { (*pzptr)->inbuf.inhalt.i_val++;
          STACK_push(quellziel, vec_stacks + (*pzptr - portarray) / port_anz, t);
          if (err || fperror) return;
        }
      }
    }
  }
  aktive_pes = akt_pes_save;
  last_akt_pe = last_akt_save;
  anz_akt_pes = anz_akt_save;

        /* alle aktiven PEs reduzieren auf Stack, bis nur noch ein Wert auf Stack */
  if (!(aktive_pes = calloc((size_t)(pe_anz + 1), (size_t)sizeof(char))))
  { runerr(texte[232]); return; }
  strcpy(aktive_pes, akt_pes_save);
  do
  { for (pec = last_akt = anz_akt_pes = 0, poptr = &PNR(1, innum);
         pec < last_akt_pe;
         pec++, poptr += port_anz)
    { if (aktive_pes[pec] == '1')
      { if (--(poptr->inbuf.inhalt.i_val) <= 1)
        { aktive_pes[pec] = '0'; }
        else
        { last_akt = pec + 1;
          anz_akt_pes++;
        }
      }
    }
    last_akt_pe = last_akt;
    if (anz_akt_pes == 0) break;
    red_proc_call(bef);
    switch (exit_code)
    { case DO_STOP:
      case DO_LOAD:
      case DO_COMPILE: return;
    }
    if (err || fperror) break;
  } while (1);

  anz_akt_pes = anz_akt_save;
  last_akt_pe = last_akt_save;
  free(aktive_pes);
  aktive_pes = akt_pes_save;
  if (err || fperror) return;

        /* Ziel ermitteln fuer alle aktiven PEs */
  zielits = item_ptr(&STAT_verg(*bef), &zielbs, disp);
  if (err) return;

        /* alle aktiven PEs lesen vom Stack */
  for (pec = 0, poptr = &PNR(1, innum); pec < last_akt_pe; pec++, poptr += port_anz)
  { quellziel = (* zielits->n_it_func)(zielits);
    if (aktive_pes[pec] == '1' && poptr->inbuf.inhalt.i_val)
    { STACK_pop(quellziel, vec_stacks + pec, t);
      if (err || fperror) return;
    }
  }
}


/**************************************************************************
 ***           Funktion do_inconnected
 ***
 *** fuehrt Befehl 'CONNECTED IN cin_port' aus
 ***
 **************************************************************************/

int do_inconnected(bef)
STAT *bef;
{ register PORT *pp, **pz;
  register int i, j;
  register ITEM *inp, *ziel;
  register int innum;
  register PORT *poptr;
  register long inn;
  register int uflag;

  protokoll('Z', aktive_pes);
  inp = item_ptr(&STAT_cin_port(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  uflag = ini_typ_test(inp->datentyp, INT, 91, 283);
  innum = (int)(inn = inp->inhalt.i_val);
  if (inn < 1l || inn > (long)port_anz)
  { runerr(texte[64], innum); return; }
  zielits = item_ptr(&STAT_verg(*bef), &zielbs, disp);
  if (err) return;
  vec_bef = TRUE;
  for (pec = 0; pec < last_akt_pe; PNR(++pec, innum).inbuf.inhalt.i_val = 0l);
  for (pp = portarray, i = pe_anz * port_anz; i; i--, pp++)
  { if (j = pp->out_count)
    { for (pz = pp->zielarr; j; j--, (*pz++)->inbuf.inhalt.i_val++); }
  }
  for (pec = 0, poptr = &PNR(1, innum); pec < last_akt_pe; pec++, poptr += port_anz)
  { ziel = (* zielits->n_it_func)(zielits);
    if (aktive_pes[pec] == '1')
    { set_i_item(ziel, poptr->inbuf.inhalt.i_val, uflag); }
  }
}

/**************************************************************************
 ***          Funktion do_outconnected
 ***
 *** fuehrt Befehl 'CONNECTED OUT out_port' aus
 ***
 **************************************************************************/

int do_outconnected(bef)
STAT *bef;
{ register ITEM *outp, *ziel;
  register int outnum;
  register PORT *poptr;
  register long outn;
  register int uflag;

  protokoll('Z', aktive_pes);
  outp = item_ptr(&STAT_out_port(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  uflag = ini_typ_test(outp->datentyp, INT, 91, 283);
  outnum = (int)(outn = outp->inhalt.i_val);
  if (outn < 1l || outn > (long)port_anz)
  { runerr(texte[64], outnum); return; }
  zielits = item_ptr(&STAT_verg(*bef), &zielbs, disp);
  if (err) return;
  vec_bef = TRUE;
  for (pec = 0, poptr = &PNR(1, outnum); pec < last_akt_pe; pec++, poptr += port_anz)
  { ziel = (* zielits->n_it_func)(zielits);
    if (aktive_pes[pec] == '1')
                  /* Zahl der Ziele fuer poptr */
    { set_i_item(ziel, (long)poptr->out_count, uflag); }
  }
}

/**************************************************************************
 ***              Funktion do_line_inconnected
 ***
 *** fuehrt Befehl 'CONNECTED IN cin_port OUT out_port' aus
 ***
 **************************************************************************/

int do_line_inconnected(bef)
STAT *bef;
{ register ITEM *ziel, *outp, *inp;
  register int outnum, innum;
  register PORT *poptr;
  register long outn, inn;
  register PORT *pp, **pz;
  register int i, j;
  register int uflag;

  protokoll('Z', aktive_pes);
  inp = item_ptr(&STAT_cin_port(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  uflag = ini_typ_test(inp->datentyp, INT, 101, 284);
  innum = (int)(inn = inp->inhalt.i_val);
  if (inn < 1l || inn > (long)port_anz)
  { runerr(texte[64], innum); return; }
  outp = item_ptr(&STAT_out_port(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  uflag |= ini_typ_test(outp->datentyp, INT, 102, 285);
  outnum = (int)(outn = outp->inhalt.i_val);
  if (outn < 1l || outn > (long)port_anz)
  { runerr(texte[64], outnum); return; }
  zielits = item_ptr(&STAT_verg(*bef), &zielbs, disp);
  if (err) return;
  vec_bef = TRUE;
  for (pec = 0; pec < last_akt_pe; PNR(++pec, innum).inbuf.inhalt.i_val = 0l);
  for (pp = &PNR(1,outnum), i = pe_anz; i; i--, pp += port_anz)
  { if (j = pp->out_count)
    { for (pz = pp->zielarr; j; j--, (*pz++)->inbuf.inhalt.i_val++); }
  }
  for (pec = 0, poptr = &PNR(1, innum); pec < last_akt_pe; pec++, poptr += port_anz)
  { ziel = (* zielits->n_it_func)(zielits);
    if (aktive_pes[pec] == '1')
    { set_i_item(ziel, poptr->inbuf.inhalt.i_val, uflag); }
  }
}

/**************************************************************************
 ***                Funktion do_line_outconnected
 ***
 *** fuehrt Befehl 'CONNECTED OUT out_port IN cin_port' aus
 ***
 **************************************************************************/

int do_line_outconnected(bef)
STAT *bef;
{ register ITEM *ziel, *outp, *inp;
  register int outnum, innum, i;
  register PORT *poptr, **poziel;
  register long outn, inn, erg;
  register int uflag;

  protokoll('Z', aktive_pes);
  outp = item_ptr(&STAT_out_port(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  uflag = ini_typ_test(outp->datentyp, INT, 101, 284);
  outnum = (int)(outn = outp->inhalt.i_val);
  if (outn < 1l || outn > (long)port_anz)
  { runerr(texte[64], outnum); return; }
  inp = item_ptr(&STAT_cin_port(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  uflag |= ini_typ_test(inp->datentyp, INT, 102, 285);
  innum = (int)(inn = inp->inhalt.i_val);
  if (inn < 1l || inn > (long)port_anz)
  { runerr(texte[64], innum); return; }
  zielits = item_ptr(&STAT_verg(*bef), &zielbs, disp);
  if (err) return;
  for (pec = 0, poptr = &PNR(1, outnum); pec < last_akt_pe; pec++, poptr += port_anz)
  { ziel = (* zielits->n_it_func)(zielits);
    if (aktive_pes[pec] == '1')
                /* Zahl der Ziele fuer poptr mit Portnr. innum */
    erg = 0;
    if (i = poptr->out_count)
    { for (poziel = poptr->zielarr; i; i--, poziel++)
      { erg += ((*poziel - portarray) % port_anz == innum - 1); }
    }
    { set_i_item(ziel, erg, uflag); }
  }
}

/**************************************************************************
 ***           Funktion ueberlies
 ***
 *** ueberliest Zeilenrest von stdin,
 *** setzt termCH ungueltig, falls runin == stdin
 ***
 **************************************************************************/

ueberlies()
{ if (!zeile_fertig)
  { do {}
    while (getchar() != '\n');
  }
  zeile_fertig = TRUE;
  if (runin == stdin)
  { s_spez_vars[TERMCH_VAR].datentyp = KEINER | CHA_ERLAUBT; }
}

/**************************************************************************
 ***                   Funktion liesname
 ***
 *** liest einen Dateinamen von einer neuen Zeile in stdin nach 's'
 *** liefert 's' bzw. 'NULL' bei Fehler
 ***
 **************************************************************************/

char *liesname()
{ char *erg;

  ueberlies();
  erg = liesstring(stdin, FALSE);
  ueberlies();
  return erg;
}

/**************************************************************************
 ***                      Funktion getname
 ***
 *** gibt 'prompt' auf stdout aus,
 *** ermittelt aus '*argpt' einen Dateinamen,
 *** schreibt ihn nach 's',
 *** liefert 's', wenn erfolgreich, sonst NULL.
 *** Bezeichnet '*argpt' einen nichtleeren String (konstant oder CHAR-Array)
 *** dann wird dieser der Filename, sonst wird ein Filename von stdin gelesen.
 *** Eine CHAR-Konstante wird als String betrachtet, termS als Leerstring.
 ***
 **************************************************************************/

unsigned char *getname(argpt, prompt)
ARG *argpt;
char *prompt;
{ register ITEM *namit = item_ptr(argpt, &dummybs, disp)->itps[0];

  if (ARG_argsort(*argpt) & CON)
  { if (AA_typ(namit->datentyp) == STR)
    { if (*(namit->inhalt.s_val))
      { register unsigned char *s =
          (unsigned char *)malloc((size_t)(strlen((char *)namit->inhalt.s_val) + 1));
        if (!s)
        { runerr(texte[80],37); }
        else
        { strcpy((char *)s, (char *)namit->inhalt.s_val); }
        return s;
      }
      else
      { fputs(prompt, stdout);
        return (unsigned char *)liesname();
      }
    }
    else
    { if (namit->inhalt.c_val)
      { register unsigned char *s =
          (unsigned char *)calloc((size_t)2,(size_t)sizeof(unsigned char));

        if (!s)
        { runerr(texte[80],38); }
        else
        { *s = namit->inhalt.c_val; }
        return s;
      }
      else
      { fputs(prompt, stdout);
        return (unsigned char *)liesname();
      }
    }
  }
  else
  { int dummy;
    register unsigned char *s = hole_string(namit, dummybs->blocks[0], 1, &dummy);

    if (!s || *s) return s;
    else
    { fputs(prompt, stdout);
      return (unsigned char *)liesname();
    }
  }
}

/**************************************************************************
 ***        Funktion do_openinput
 ***
 *** fuehrt Befehl 'OPENINPUT vc1' aus
 *** evtl. offenes File wird geschlossen,
 *** aus 'vc1' wird Filename ermittelt.
 ***
 **************************************************************************/

int do_openinput(bef)
STAT *bef;
{ unsigned char *fn;
  register int done_erg = FALSE;

  protokoll('o', NULL);
  if (err) return;
  if (runin != stdin)
  { fclose(runin);
    runin = stdin;
    s_spez_vars[TERMCH_VAR].datentyp = KEINER | CHA_ERLAUBT;
  }
  else
  { ueberlies(); }
  if (fn = getname(&STAT_vc1(*bef), "in> "))
  { if (runin = fopen((char *)fn, "r"))
    { done_erg = TRUE; }
    free(fn);
  }
  set_b_item(&s_spez_vars[DONE_VAR], done_erg, 0);
  if (!done_erg) runin = stdin;
}

/**************************************************************************
 ***                      Funktion do_openoutput
 ***
 *** fuehrt Befehl 'OPENOUTPUT vc1' aus
 *** evtl. offenes File wird geschlossen,
 *** aus 'vc1' wird Filename ermittelt.
 ***
 **************************************************************************/

int do_openoutput(bef)
STAT *bef;
{ unsigned char *fn;
  register int done_erg = FALSE;

  protokoll('o', NULL);
  if (err) return;
  if (runout != stdout)
  { fclose(runout);
    runout = stdout;
  }
  if (fn = getname(&STAT_vc1(*bef), "out> "))
  { if (runout = fopen((char *)fn, "w"))
    { done_erg = TRUE; }
    free(fn);
  }
  set_b_item(&s_spez_vars[DONE_VAR], done_erg, 0);
  if (!done_erg) runout = stdout;
}

/**************************************************************************
 ***                      Funktion do_errorcall
 ***
 *** fuehrt Befehl 'ERROR vc1' aus
 ***
 **************************************************************************/

int do_errorcall(bef)
STAT *bef;
{ protokoll('e', NULL);
  if (no_linefeed && runout == stdout)
  { putc('\n', runout); no_linefeed = FALSE; }
  fprintf(yyerfp,"[ERROR] %s\n", ARG_con_wert(STAT_vc1(*bef)).inhalt.s_val);
  if (akt_line)
  { register int i, j;

    fprintf(yyerfp, texte[234], i = akt_line->source_line);
    if (j = akt_line->stat_in_line) fprintf(yyerfp, texte[298], j);
    putc('\n', yyerfp);
    source_out(i, yyerfp);
  }
  err = TRUE;
  if (sym_debugging) { anz_fehler++; anz_meldungen++; }
}

/**************************************************************************
 ***                      Funktion do_getpixel
 ***
 *** fuehrt Befehl 'verg := GETPIXEL vc1 vc2' aus
 ***
 **************************************************************************/

int do_getpixel(bef)
STAT *bef;
{ register ITEM *xit, *yit, *rziel, *gziel, *bziel;
  register VARBLOCK *bl;

  protokoll('o', NULL);
  xit = item_ptr(&STAT_vc1(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  ini_typ_test(xit->datentyp, INT, 101, 284);
  yit = item_ptr(&STAT_vc2(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  ini_typ_test(yit->datentyp, INT, 102, 285);
  rziel = (zielits = item_ptr(&STAT_verg(*bef), &zielbs, disp))->itps[0];
  if (err) return;
  bl = zielbs->blocks[0];
  if (((rziel - bl->vars) + bl->von + 2) > bl->bis)
  { runerr(texte[286]); return; }
  gziel = rziel + 1; bziel = gziel + 1;
  if (!((rziel->datentyp & INT_ERLAUBT) &&
        (gziel->datentyp & INT_ERLAUBT) &&
        (bziel->datentyp & INT_ERLAUBT)))
  { runerr(texte[287]); return; }
  set_b_item(&s_spez_vars[DONE_VAR],
             getpixel(xit->inhalt.i_val, yit->inhalt.i_val, rziel, gziel, bziel), 0);
}

/**************************************************************************
 ***                      Funktion do_openw
 ***
 *** fuehrt Befehl 'verg := OPENW vc1 vc2' aus
 ***
 **************************************************************************/

int do_openw(bef)
STAT *bef;
{ register ITEM *xit, *yit, *ziel;

  protokoll('o', NULL);
  xit = item_ptr(&STAT_vc1(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  ini_typ_test(xit->datentyp, REAL, 101, 284);
  yit = item_ptr(&STAT_vc2(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  ini_typ_test(yit->datentyp, REAL, 102, 285);
  ziel = (zielits = item_ptr(&STAT_verg(*bef), &zielbs, disp))->itps[0];
  if (err) return;
  set_b_item(&s_spez_vars[DONE_VAR],
             openw(xit->inhalt.r_val, yit->inhalt.r_val, ziel), 0);
}

/**************************************************************************
 ***                      Funktion do_openabsw
 ***
 *** fuehrt Befehl 'verg := OPENABSW vc1 vc2' aus
 ***
 **************************************************************************/

int do_openabsw(bef)
STAT *bef;
{ register ITEM *xit, *yit, *ziel;

  protokoll('o', NULL);
  xit = item_ptr(&STAT_vc1(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  ini_typ_test(xit->datentyp, INT, 101, 284);
  yit = item_ptr(&STAT_vc2(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  ini_typ_test(yit->datentyp, INT, 102, 285);
  ziel = (zielits = item_ptr(&STAT_verg(*bef), &zielbs, disp))->itps[0];
  if (err) return;
  set_b_item(&s_spez_vars[DONE_VAR],
             openabsw(xit->inhalt.i_val, yit->inhalt.i_val, ziel), 0);
}

/**************************************************************************
 ***                      Funktion do_moveto
 ***
 *** fuehrt Befehl 'MOVETO vc1 vc2' aus
 ***
 **************************************************************************/

int do_moveto(bef)
STAT *bef;
{ register ITEM *xit, *yit;

  protokoll('o', NULL);
  xit = item_ptr(&STAT_vc1(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  ini_typ_test(xit->datentyp, INT, 101, 284);
  yit = item_ptr(&STAT_vc2(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  ini_typ_test(yit->datentyp, INT, 102, 285);
  set_b_item(&s_spez_vars[DONE_VAR],
             MoveTo(xit->inhalt.i_val, yit->inhalt.i_val), 0);
}

/**************************************************************************
 ***                      Funktion do_lineto
 ***
 *** fuehrt Befehl 'LINETO vc1 vc2' aus
 ***
 **************************************************************************/

int do_lineto(bef)
STAT *bef;
{ register ITEM *xit, *yit;

  protokoll('o', NULL);
  xit = item_ptr(&STAT_vc1(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  ini_typ_test(xit->datentyp, INT, 101, 284);
  yit = item_ptr(&STAT_vc2(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  ini_typ_test(yit->datentyp, INT, 102, 285);
  set_b_item(&s_spez_vars[DONE_VAR],
             LineTo(xit->inhalt.i_val, yit->inhalt.i_val), 0);
}

/**************************************************************************
 ***                      Funktion do_t_setpixel
 ***
 *** t=s : Skalarbefehl, t=v : Vektorbefehl
 *** fuehrt Befehl 'SETPIXEL vc1 vc2' aus
 ***
 **************************************************************************/

int do_s_setpixel(bef)
STAT *bef;
{ register ITEM *xit, *yit;

  protokoll('o', NULL);
  xit = item_ptr(&STAT_vc1(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  ini_typ_test(xit->datentyp, INT, 101, 284);
  yit = item_ptr(&STAT_vc2(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  ini_typ_test(yit->datentyp, INT, 102, 285);
  set_b_item(&s_spez_vars[DONE_VAR],
             SetPixel(xit->inhalt.i_val, yit->inhalt.i_val), 0);
}

int do_v_setpixel(bef)
STAT *bef;
{ register ITPTRS *xits, *yits;

  protokoll('O', aktive_pes);
  xits = item_ptr(&STAT_vc1(*bef), &dummybs, disp);
  if (err) return;
  yits = item_ptr(&STAT_vc2(*bef), &dummybs, disp);
  if (err) return;
  vec_bef = TRUE;
  set_b_item(&s_spez_vars[DONE_VAR], VSetPixel(xits, yits), 0);
}

/**************************************************************************
 ***                      Funktion do_wsize
 ***
 *** fuehrt Befehl 'WSIZE vc1 vc2' aus
 ***
 **************************************************************************/

int do_wsize(bef)
STAT *bef;
{ register ITEM *xit, *yit;

  protokoll('o', NULL);
  xit = item_ptr(&STAT_vc1(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  yit = item_ptr(&STAT_vc2(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  set_b_item(&s_spez_vars[DONE_VAR],
             wsize(xit, yit), 0);
}

/**************************************************************************
 ***                      Funktion do_t_setcolor
 ***
 *** t=s : Skalarbefehl, t=v : Vektorbefehl
 *** fuehrt Befehl 'SETCOLOR vc1' aus
 ***
 **************************************************************************/

int do_s_setcolor(bef)
STAT *bef;
{ register ITEM *rit, *git, *bit;
  register VARBLOCK *bl;

  protokoll('o', NULL);
  rit = item_ptr(&STAT_vc1(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  bl = dummybs->blocks[0];
  if (((rit - bl->vars) + bl->von + 2) > bl->bis)
  { runerr(texte[286]); return; }
  git = rit + 1; bit = git + 1;
  ini_typ_test(rit->datentyp, INT, 91, 283);
  ini_typ_test(git->datentyp, INT, 91, 283);
  ini_typ_test(bit->datentyp, INT, 91, 283);
  set_b_item(&s_spez_vars[DONE_VAR],
             setcolor(rit->inhalt.i_val, git->inhalt.i_val, bit->inhalt.i_val), 0);
}

int do_v_setcolor(bef)
STAT *bef;
{ ITPTRS *rits;
  register VARBLOCK **blpt;
  register int len;

  protokoll('O', aktive_pes);
  rits = item_ptr(&STAT_vc1(*bef), &dummybs, disp);
  if (err) return;
  len = rits->n_it_func == gl_item ? 1 : pe_anz;
  blpt = dummybs->blocks;
  vec_bef = TRUE;
  set_b_item(&s_spez_vars[DONE_VAR], VSetColor(rits, blpt, len), 0);
}

/**************************************************************************
 ***                      Funktion do_selectw
 ***
 *** fuehrt Befehl 'SELECTW vc1' aus
 ***
 **************************************************************************/

int do_selectw(bef)
STAT *bef;
{ register ITEM *handle;

  protokoll('o', NULL);
  handle = item_ptr(&STAT_vc1(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  ini_typ_test(handle->datentyp, INT, 91, 283);
  set_b_item(&s_spez_vars[DONE_VAR],
             SelectW(handle->inhalt.i_val), 0);
}

/**************************************************************************
 ***                      Funktion do_closew
 ***
 *** fuehrt Befehl 'CLOSEW vc1' aus
 ***
 **************************************************************************/

int do_closew(bef)
STAT *bef;
{ register ITEM *handle;

  protokoll('o', NULL);
  handle = item_ptr(&STAT_vc1(*bef), &dummybs, disp)->itps[0];
  if (err) return;
  ini_typ_test(handle->datentyp, INT, 91, 283);
  set_b_item(&s_spez_vars[DONE_VAR],
             CloseW(handle->inhalt.i_val), 0);
}

/**************************************************************************
 ***                Funktion do_debug
 ***
 *** fuehrt Befehl 'DEBUG vc2 vc3 AS dblock' aus
 ***
 **************************************************************************/

int do_debug(bef)
STAT *bef;
{ protokoll('d', NULL);
  zielits = item_ptr(&STAT_vc2(*bef), &zielbs, disp);
  if (err) return;
  if (deb_mod && no_linefeed) putc('\n', debugout);
  if (deb_mod) fputs("[DEBUG] ", debugout);
  more_mod = FALSE;
  deb_out(zielits, zielbs,
          ARG_con_wert(STAT_vc3(*bef)).inhalt.s_val,
          STAT_dblock(*bef),
          0,
          debugout);
  more_mod = more_mod_save;
  if (deb_mod) putc('\n', debugout);
}

/**************************************************************************
 ***               Funktion do_trace
 ***
 *** fuehrt Befehl 'TRACE vc2 vc3 AS dblock' aus
 ***
 **************************************************************************/

int do_trace(bef)
STAT *bef;
{ register TRACEVAR *neutr, **trlistpt;
  register VARBLOCK *bl;
  register ITEM *suchit;
  register int v_len = (ARG_argsort(STAT_vc2(*bef)) & VEC) ? pe_anz : 1;
  register int not_on = FALSE;

  protokoll('d', NULL);
  zielits = item_ptr(&STAT_vc2(*bef), &zielbs, disp);
  if (err) return;
  bl = zielbs->blocks[0];
  if ((zielits->itps[0] - bl->vars) / v_len + bl->von +
      STAT_dblock(*bef)->typ_zahl[SUMM] - 1 > bl->bis)
  { runerr(texte[140]); return; }

                /* neue TRACE-Information erzeugen */
  if (!(neutr = (TRACEVAR *)calloc((size_t)1, (size_t)sizeof(TRACEVAR))))
  { runerr(texte[125]); return; }
  neutr->varpts = *zielits;
  neutr->varbls = *zielbs;
  neutr->tdec = STAT_dblock(*bef);
  neutr->t_string = ARG_con_wert(STAT_vc3(*bef)).inhalt.s_val;

                /* TRACE-Information eintragen bei zielbs */
  for (trlistpt = &zielbs->blocks[0]->t_info, suchit = neutr->varpts.itps[0];
       *trlistpt;
       trlistpt = &(*trlistpt)->t_naechst)
  { register ITEM *trit = (*trlistpt)->varpts.itps[0];

    if (trit > suchit)          /* Stelle gefunden : eintragen */
    { neutr->t_naechst = *trlistpt;
      *trlistpt = neutr;
      break;
    }
    else if (trit == suchit &&
             (*trlistpt)->tdec->typ_zahl[SUMM] == neutr->tdec->typ_zahl[SUMM])
                /* gleicher Bereich vorhanden : Warnung, nicht einschalten */
    { runwarn(texte[138]); not_on = TRUE;
      break;
    }
  }
  if (!*trlistpt)       /* am Ende eintragen */
  { neutr->t_naechst = NULL;
    *trlistpt = neutr;
  }

                /* erste Ausgabe des Inhalts */
  if (deb_mod && no_linefeed) putc('\n', debugout);
  if (deb_mod) fputs(not_on ? "[TRACE] " : "[TRACE ON] ", debugout);
  more_mod = FALSE;
  deb_out(zielits, zielbs,
          neutr->t_string,
          neutr->tdec,
          not_on ? 0 : 1,
          debugout);
  more_mod = more_mod_save;
  if (deb_mod) { putc('\n', debugout); no_linefeed = FALSE; }
  if (deb_mod && im_programm) { putc('\n', debugout); }
}

/**************************************************************************
 ***                      Funktion do_notrace
 ***
 *** fuehrt Befehl 'NOTRACE vc1' aus
 ***
 **************************************************************************/

int do_notrace(bef)
STAT *bef;
{ protokoll('d', NULL);
  if (ARG_valtyp(STAT_vc1(*bef)) == KEINER)        /* alle TRACEs loeschen */
  { tr_block_off(s_blocks, 1);
    tr_block_off(s_heap, 1);
    tr_block_off(v_blocks, pe_anz);
    tr_block_off(v_heap, pe_anz);
  }
  else          /* alle TRACEs zu vc1 loeschen */
  { zielits = item_ptr(&STAT_vc1(*bef), &zielbs, disp);
    if (err) return;
    tr_off(zielits, zielbs);
  }
}

/**************************************************************************
 ***                      Funktion do_nop
 ***
 *** fuehrt NOP-Befehl aus,
 ***
 **************************************************************************/

int do_nop(bef)
STAT *bef;
{ protokoll('x', NULL);
}

/**************************************************************************
 ***                      Funktion do_falsch
 ***
 *** darf nie ausgefuehrt werden,
 *** wird bei Semantikfehlern in Programmspeicher eingetragen
 ***
 **************************************************************************/

int do_falsch(bef)
STAT *bef;
{ bug("Aufruf von do_falsch im Befehl #%d", bef - programm);
}
