/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : General
  Filename     : etextepz.c       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.etextepz.c
  Version      : 1.4 
  Last changed : 11/16/93 at 15:31:07        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : Englische Fehlermeldungen fuer PARZ

******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/

static char sccs_id[] = "@(#)etextepz.c	1.4  11/16/93 PARZ - General (Frank Sembach)";


#include "parzdefs.h"
#include "komdefs.h"
#include "y_tab.h"

extern FILE *yyerfp;
extern int bef_tok;

char *ssstr[] = { "off",
                  "Parallaxis",
                  "PARZ"
                };
char *protstr[] = {"off", "short", "long"};
#ifdef MAC
char **texte;
char **help_texte;

init_texte()
{ register char **strptr;

  if (!(texte = (char **)malloc(352 * sizeof(char *))))
  { fatal("not enough memory"); parzexit(1); }
  if (!(help_texte = (char **)malloc(143 * sizeof(char *))))
  { fatal("not enough memory"); parzexit(1); }
  strptr = texte;

*strptr++ = /*  0 */ "unknown command %s";
*strptr++ = /*  1 */ "unknown record mode %d\n";
*strptr++ = /*  2 */ "\b \b";
*strptr++ = /*  3 */ "program is not executable\n";
*strptr++ = /*  4 */ "not enough memory for program execution";
*strptr++ = /*  5 */ "not enough memory for variables";
*strptr++ = /*  6 */ "unknown name";
*strptr++ = /*  7 */ "illegal character %c";
*strptr++ = /*  8 */ "program has to end with STOP";
*strptr++ = /*  9 */ "text following STOP is ignored\n";
*strptr++ = /* 10 */ "program has to begin with START";
*strptr++ = /* 11 */ "number of processors is missing";
*strptr++ = /* 12 */ "could not determine number of processors";
*strptr++ = /* 13 */ "number of ports is missing";
*strptr++ = /* 14 */ "could not determine number of ports";
*strptr++ = /* 15 */ "incorrect connection-list";
*strptr++ = /* 16 */ "incorrect SCALAR-declaration";
*strptr++ = /* 17 */ "SCALAR-declaration is missing";
*strptr++ = /* 18 */ "incorrect VECTOR-declaration";
*strptr++ = /* 19 */ "VECTOR-declaration is missing";
*strptr++ = /* 20 */ "incorrect statement";
*strptr++ = /* 21 */ " ( label : %d )";
*strptr++ = /* 22 */ "labels are not in increasing order\n";
*strptr++ = /* 23 */ "label must not be 0\n";
*strptr++ = /* 24 */ "error in IF - GOTO";
*strptr++ = /* 25 */ "illegal jump to PROC-statement";
*strptr++ = /* 26 */ "error in END";
*strptr++ = /* 27 */ "END must be the last statement";
*strptr++ = /* 28 */ "type error";
*strptr++ = /* 29 */ "address operation has INTEGER result";
*strptr++ = /* 30 */ "a string can only be assigned to a CHAR-array";
*strptr++ = /* 31 */ "error in REDUCE";
*strptr++ = /* 32 */ "destination must be SCALAR";
*strptr++ = /* 33 */ "index variable must be INTEGER";
*strptr++ = /* 34 */ "variable error";
*strptr++ = /* 35 */ "VECTOR-variable may not be index of a SCALAR-variable";
*strptr++ = /* 36 */ "undeclared variable";
*strptr++ = /* 37 */ "read-access to write-only-variable";
*strptr++ = /* 38 */ "write-access to read-only-variable";
*strptr++ = /* 39 */ "error in GOTO";
*strptr++ = /* 40 */ "overflow while reading REAL-constant\n";
*strptr++ = /* 41 */ "error in IF - CALL";
*strptr++ = /* 42 */ "destination has to be PROC-statement";
*strptr++ = /* 43 */ "no VECTOR-variables allowed in IF...GOTO";
*strptr++ = /* 44 */ "no predeclared variable allowed";
*strptr++ = /* 45 */ "incorrect PORT-range %d .. %d";
*strptr++ = /* 46 */ "error in PUSHS";
*strptr++ = /* 47 */ "variable has to be SCALAR";
*strptr++ = /* 48 */ "error in POPV";
*strptr++ = /* 49 */ "argument has to be VECTOR";
*strptr++ = /* 50 */ "error in CALL";
*strptr++ = /* 51 */ "error in PROC";
*strptr++ = /* 52 */ "procedure level has to be >= 1";
*strptr++ = /* 53 */ "indirect access [%ld] to unknown variable";
*strptr++ = /* 54 */ "error in PARALLEL";
*strptr++ = /* 55 */ "wrong length of bit-field";
*strptr++ = /* 56 */ "argument has to be first variable of a scalar array";
*strptr++ = /* 57 */ "error in PROPAGATE";
*strptr++ = /* 58 */ "propagated variable has to be VECTOR";
*strptr++ = /* 59 */ "no TRACE was set on this variable";
*strptr++ = /* 60 */ "not enough memory for program statements!\n";
*strptr++ = /* 61 */ "not enough memory for stacks!\n";
*strptr++ = /* 62 */ "not enough memory for ports!\n";
*strptr++ = /* 63 */ "illegal PE-no %d";
*strptr++ = /* 64 */ "illegal PORT-no %d";
*strptr++ = /* 65 */ "multiple connections leaving %d %d\n";
*strptr++ = /* 66 */ "not enough memory for declarations!\n";
*strptr++ = /* 67 */ "assignment of VECTOR-value to SCALAR-variable is impossible";
*strptr++ = /* 68 */ "illegal type";
*strptr++ = /* 69 */ "incompatible types";
*strptr++ = /* 70 */ "port-number has to be INTEGER";
*strptr++ = /* 71 */ "port-number has to be a constant or a scalar variable";
*strptr++ = /* 72 */ "found at end of program";
*strptr++ = /* 73 */ "illegal jump to label %d in statement %d :";
*strptr++ = /* 74 */ "missing END-statement!\n";
*strptr++ = /* 75 */ "no statements allowed after END-statement";
*strptr++ = /* 76 */ "unknown label %d in statement %d :";
*strptr++ = /* 77 */ "illegal CALL of label %d in statement %d :";
*strptr++ = /* 78 */ "illegal REDUCE-call of label %d in statement %d :";
*strptr++ = /* 79 */ "syntax error";
*strptr++ = /* 80 */ "not enough memory for this function\n";
*strptr++ = /* 81 */ "                        ";
*strptr++ = /* 82 */ "destination must be VECTOR";
*strptr++ = /* 83 */ "filename not terminated by 'termS'";
*strptr++ = /* 84 */ "conflict between scalar and vector types";
*strptr++ = /* 85 */ "error in LOAD";
*strptr++ = /* 86 */ "first argument has to be VECTOR";
*strptr++ = /* 87 */ "second argument has to be SCALAR";
*strptr++ = /* 88 */ "error in STORE";
*strptr++ = /* 89 */ "argument has to be VECTOR-variable";
*strptr++ = /* 90 */ "index variable has no INTEGER-value";
*strptr++ = /* 91 */ "use of a not initialized variable";
*strptr++ = /* 92 */ "use of unknown variable";
*strptr++ = /* 93 */ "RETURN is impossible in main program";
*strptr++ = /* 94 */ "end of program while executing a procedure";
*strptr++ = /* 95 */ "not enough continuous variables in source-block for MOVE";
*strptr++ = /* 96 */ "call of procedure on level %d from level %d";
*strptr++ = /* 97 */ "not enough continuous variables in destination-block for MOVE";
*strptr++ = /* 98 */ "line %d";
*strptr++ = /* 99 */ "assignment of CHAR-value to BOOLEAN-variable";
*strptr++ = /*100 */ "assignment of REAL-value to CHAR-variable";
*strptr++ = /*101 */ "first argument not initialized";
*strptr++ = /*102 */ "second argument not initialized";
*strptr++ = /*103 */ "assignment of CHAR-value to REAL-variable";
*strptr++ = /*104 */ "incompatible types in block operation";
*strptr++ = /*105 */ "not enough continuous variables in first block for EQUAL";
*strptr++ = /*106 */ "not enough continuous variables in second block for EQUAL";
*strptr++ = /*107 */ "processors, inactive at PROC-call, may not get active before RETURN";
*strptr++ = /*108 */ "not enough continuous variables for string-input";
*strptr++ = /*109 */ "not enough continuous CHAR-variables for string-input";
*strptr++ = /*110 */ "not enough continuous scalar variables for LOAD";
*strptr++ = /*111 */ "overflow in floating point operation";
*strptr++ = /*112 */ "not enough continuous scalar variables for STORE";
*strptr++ = /*113 */ "no active processors for REDUCE";
*strptr++ = /*114 */ "illegal statement during REDUCE";
*strptr++ = /*115 */ "multiple values arriving on one port";
*strptr++ = /*116 */ "subsequent errors and warnings are suppressed\n\n";
*strptr++ = /*117 */ "error in TRACE";
*strptr++ = /*118 */ "no indirect vector-address allowed";
*strptr++ = /*119 */ "PROC-statement reached without CALL";
*strptr++ = /*120 */ "error in NOTRACE";
*strptr++ = /*121 */ "not enough memory for procedure-call";
*strptr++ = /*122 */ ""; /* "\n**** function aborted ! ****\n"; */
*strptr++ = /*123 */ "stack-underflow";
*strptr++ = /*124 */ "type conflict in POP-operation";
*strptr++ = /*125 */ "not enough memory for trace informations";
*strptr++ = /*126 */ "not enough continuous variables for PARALLEL";
*strptr++ = /*127 */ "not enough continuous BOOLEAN-variables for PARALLEL";
*strptr++ = /*128 */ "not enough continuous variables for string-assignment";
*strptr++ = /*129 */ "not enough continuous CHAR-variables for string-assignment";
*strptr++ = /*130 */ "error in READ";
*strptr++ = /*131 */ "first argument has to be SCALAR";
*strptr++ = /*132 */ "maximum width has to be a scalar INTEGER-value";
*strptr++ = /*133 */ "error in WRITE";
*strptr++ = /*134 */ "error in DRAW";
*strptr++ = /*135 */ "output width has to be a scalar INTEGER-value";
*strptr++ = /*136 */ "fraction width has to be a scalar INTEGER-value";
*strptr++ = /*137 */ "error in WRITELN";
*strptr++ = /*138 */ "multiple TRACE on the same variable-block";
*strptr++ = /*139 */ "not enough continuous variables";
*strptr++ = /*140 */ "not enough continuous variables for TRACE";
*strptr++ = /*141 */ "declaration and memory-structure are incompatible";
*strptr++ = /*142 */ "STATUS can only be assigned to a BOOLEAN array";
*strptr++ = /*143 */ "error in OPENINPUT";
*strptr++ = /*144 */ "filename has to be a string or a scalar CHAR-array";
*strptr++ = /*145 */ "error in OPENOUTPUT";
*strptr++ = /*146 */ "string is not terminated by termS";
*strptr++ = /*147 */ "negative exponent in INTEGER-power";
*strptr++ = /*148 */ "exponentiation 0 ^ 0";
*strptr++ = /*149 */ "negative base in REAL-exponentiation";
*strptr++ = /*150 */ "exponentiation 0 ^ negative number";
*strptr++ = /*151 */ "division by 0";
*strptr++ = /*152 */ "unknown debug mode %d\n";
*strptr++ = /*153 */ "multiple incoming connections at %d %d\n";
*strptr++ = /*154 */ "multiply defined connection %d %d TO %d %d";
*strptr++ = /*155 */ "unknown compile-flag %d\n";
*strptr++ = /*156 */ "unknown single-step mode %d\n";
*strptr++ = /*157 */ "file %s not found\n";
*strptr++ = /*158 */ "not enough continuous variables for string-output";
*strptr++ = /*159 */ "not enough continuous CHAR-variables for string-output";
*strptr++ = /*160 */ "not enough continuous variables for STATUS-assignment";
*strptr++ = /*161 */ "not enough continuous BOOLEAN-variables for STATUS-assignment";
*strptr++ = /*162 */ "indirect address [%ld] references wrong type";
*strptr++ = /*163 */ "record-file : %s\n";
*strptr++ = /*164 */ "cannot open record-file\n";
*strptr++ = /*165 */ "\ninput-file : %s\n";
*strptr++ = /*166 */ "compiling does not succeed";
*strptr++ = /*167 */ "wrong PE-range %d .. %d";
*strptr++ = /*168 */ "record-mode : %s\n";
*strptr++ = /*169 */ "singlestep-/breakpoint mode : %s\n";
*strptr++ = /*170 */ "debug mode : on\n";
*strptr++ = /*171 */ "debug mode : off\n";
*strptr++ = /*172 */ "incorrect command";
*strptr++ = /*173 */ "unknown label : %d";
*strptr++ = /*174 */ "wrong offset : %d";
*strptr++ = /*175 */ "\ninterrupt at statement :";
*strptr++ = /*176 */ "\nstatement reached :";
*strptr++ = /*177 */ "\nforced break at statement :";
*strptr++ = /*178 */ "\nstep to statement :";
*strptr++ = /*179 */ "active processors : ";
*strptr++ = /*180 */ "program was not interrupted\n";
*strptr++ = /*181 */ "\nPARZ Parallel Simulator, Version 2.08, Univ. Stuttgart, Germany Nov. 1993\n";
*strptr++ = /*182 */ "default-PEs : ";
*strptr++ = /*183 */ "call-stack does not exist";
*strptr++ = /*184 */ "usage of a level %d variable on level %d";
*strptr++ = /*185 */ "subsequent warnings for that statement are suppressed\n\n";
*strptr++ = /*186 */ "warnings : on\n";
*strptr++ = /*187 */ "warnings : off\n";
*strptr++ = /*188 */ "unknown warning-mode %d\n";
*strptr++ = /*189 */ "-- MORE (help with h) --";
*strptr++ = /*190 */ "\r                        \r";
*strptr++ = /*191 */ "       ( type >h< for help )\n";
*strptr++ = /*192 */ "\n\nwrong option\n";
*strptr++ = /*193 */ "\n\nno filename allowed in filter-mode f\n";
*strptr++ = /*194 */ "unable to open temporary file";
*strptr++ = /*195 */ "wrong TEXT-range %d .. %d";
*strptr++ = /*196 */ "no program loaded\n";
*strptr++ = /*197 */ "wrong address-range %d .. %d";
*strptr++ = /*198 */ "address-range %d .. %d does not exist";
*strptr++ = /*199 */ "address-range %d .. %d is not on HEAP";
*strptr++ = /*200 */ "error in CONNECTED";
*strptr++ = /*201 */ "destination must be of type VECTOR INTEGER";
*strptr++ = /*202 */ "mode : %d\n\n";
*strptr++ = /*203 */ "program : %s\n\n";
*strptr++ = /*204 */ " none";
*strptr++ = /*205 */ "procedure %s (%d z), called from line %s (%d z)";
*strptr++ = /*206 */ "   local variables for control-processor :";
*strptr++ = /*207 */ "   local variables for PE-array :";
*strptr++ = /*208 */ "   pushed processor-status : ";
*strptr++ = /*209 */ "activation record is missing !\n\n";
*strptr++ = /*210 */ "main-program %s : ";
*strptr++ = /*211 */ "   global variables for control-processor :";
*strptr++ = /*212 */ "   global variables for PE-array :";
*strptr++ = /*213 */ "activation-record for main-program is missing !\n\n";
*strptr++ = /*214 */ "heap for control-processor :";
*strptr++ = /*215 */ " none";
*strptr++ = /*216 */ "heap for PE-array :";
*strptr++ = /*217 */ "memory of control-processor :";
*strptr++ = /*218 */ "memory of PE-array :";
*strptr++ = /*219 */ "* ToS *";
*strptr++ = /*220 */ "* BoS *";
*strptr++ = /*221 */ "parameter-stack for control-processor :";
*strptr++ = /*222 */ "parameter-stacks for PE-array :";
*strptr++ = /*223 */ "offset to top of call-stack : %d\n";
*strptr++ = /*224 */ "address %d does not exist";
*strptr++ = /*225 */ "  ...  ";
*strptr++ = /*226 */ "address %d is not on the HEAP";
*strptr++ = /*227 */ "at \"%.*s\"";
*strptr++ = /*228 */ "wrong sign '-'";
*strptr++ = /*229 */ "wrong sign NOT";
*strptr++ = /*230 */ "no sign allowed";
*strptr++ = /*231 */ "selected PE is inactive";
*strptr++ = /*232 */ "not enough memory for REDUCE";
*strptr++ = /*233 */ "the variable does not exist on the selected PEs";
*strptr++ = /*234 */ "    in source-line %d";
*strptr++ = /*235 */ "not enough continuous variables in the destination-block for LOAD";
*strptr++ = /*236 */ "not enough continuous variables in the source-block for STORE";
*strptr++ = /*237 */ "unknown source-line %d";
*strptr++ = /*238 */ "no offset allowed in compiler-mode";
*strptr++ = /*239 */ "breakpoint set on statement :\n";
*strptr++ = /*240 */ "breakpoint removed from statement :\n";
*strptr++ = /*241 */ "%*d : %s";
*strptr++ = /*242 */ "[error] ";
*strptr++ = /*243 */ "[error %d] ";
*strptr++ = /*244 */ "\n   in statement :";
*strptr++ = /*245 */ "      on PE no %d\n";
*strptr++ = /*246 */ "\n[runtime error] ";
*strptr++ = /*247 */ "\n[error] ";
*strptr++ = /*248 */ "[warning] ";
*strptr++ = /*249 */ "\n[warning] ";
*strptr++ = /*250 */ "[fatal error] ";
*strptr++ = /*251 */ "[we apologize] ";
*strptr++ = /*252 */ "output width of PE-lists : %d\n";
*strptr++ = /*253 */ "illegal output width 0";
*strptr++ = /*254 */ "pa -pxme%d%s <%s";
*strptr++ = /*255 */ "";
*strptr++ = /*256 */ "expecting: ";
*strptr++ = /*257 */ "function '%s' is undefined for %#g as argument";
*strptr++ = /*258 */ "function 'arctan' is undefined for %#g / %#g as argument";
*strptr++ = /*259 */ "sqrt";
*strptr++ = /*260 */ "exp";
*strptr++ = /*261 */ "ln";
*strptr++ = /*262 */ "sin";
*strptr++ = /*263 */ "cos";
*strptr++ = /*264 */ "tan";
*strptr++ = /*265 */ "arcsin";
*strptr++ = /*266 */ "arccos";
*strptr++ = /*267 */ "arctan";
*strptr++ = /*268 */ "abs";
*strptr++ = /*269 */ "function not implemented\n";
*strptr++ = /*270 */ "not enough memory for parser";
*strptr++ = /*271 */ "error in SEND";
*strptr++ = /*272 */ "error in RECEIVE";
*strptr++ = /*273 */ "error in GETPIXEL";
*strptr++ = /*274 */ "error in OPENW";
*strptr++ = /*275 */ "error in MOVETO";
*strptr++ = /*276 */ "error in LINETO";
*strptr++ = /*277 */ "error in SETPIXEL";
*strptr++ = /*278 */ "error in WSIZE";
*strptr++ = /*279 */ "error in SETCOLOR";
*strptr++ = /*280 */ "error in SELECTW";
*strptr++ = /*281 */ "error in CLOSEW";
*strptr++ = /*282 */ "grafics routines are only defined for scalar data";
*strptr++ = /*283 */ "use of an inactive variant";
*strptr++ = /*284 */ "use of an inactive variant in first argument";
*strptr++ = /*285 */ "use of an inactive variant in second argument";
*strptr++ = /*286 */ "not enough continuous variables for graphic command";
*strptr++ = /*287 */ "not enough continuous INTEGER-variables for graphic command";
*strptr++ = /*288 */ "no connections exist\n";
*strptr++ = /*289 */ "wrong MAGIC-number in xrf-file\n";
*strptr++ = /*290 */ "wrong dictionary in xrf-file\n";
*strptr++ = /*291 */ "wrong symbol table in xrf-file\n";
*strptr++ = /*292 */ "wrong scope table in xrf-file\n";
*strptr++ = /*293 */ "wrong linenumber table in xrf-file\n";
*strptr++ = /*294 */ "wrong types table in xrf-file\n";
*strptr++ = /*295 */ "wrong member table in xrf-file\n";
*strptr++ = /*296 */ "missing end-mark in xrf-file\n";
*strptr++ = /*297 */ "not enough memory for xrf-data\n";
*strptr++ = /*298 */ "+%d";
*strptr++ = /*299 */ "not enough memory for source-file\n";
*strptr++ = /*300 */ "unable to open sopurce-file\n";
*strptr++ = /*301 */ "unknown identifier %s";
*strptr++ = /*302 */ "unknown procedure- or system-name %s";
*strptr++ = /*303 */ "%s is not allowed as REDUCE operator";
*strptr++ = /*304 */ "illegal expression as argument for REDUCE";
*strptr++ = /*305 */ "illegal argument for '%s'";
*strptr++ = /*306 */ "illegal first argument for '%s'";
*strptr++ = /*307 */ "illegal second argument for '%s'";
*strptr++ = /*308 */ "illegal identifier %s";
*strptr++ = /*309 */ "procedure is not on callstack";
*strptr++ = /*310 */ "expression is not assignable";
*strptr++ = /*311 */ "no active configuration";
*strptr++ = /*312 */ "no PEs selected\n";
*strptr++ = /*313 */ "incompatible types for assignment";
*strptr++ = /*314 */ "illegal type combination for operator '%s'";
*strptr++ = /*315 */ "assignment to constant is impossible";
*strptr++ = /*316 */ "error in INITSET";
*strptr++ = /*317 */ "destination has to be BOOLEAN";
*strptr++ = /*318 */ "not enough continuous variables for INITSET";
*strptr++ = /*319 */ "not enough continuous BOOLEAN-variables for INITSET";
*strptr++ = /*320 */ "illegal POINTER-constant";
*strptr++ = /*321 */ "illegal dereferencing '%s'";
*strptr++ = /*322 */ "'%s' is not a RECORD";
*strptr++ = /*323 */ "unknown RECORD-component '%s'";
*strptr++ = /*324 */ "'%s' is not an ARRAY";
*strptr++ = /*325 */ "subscript out of range";
*strptr++ = /*326 */ "subscript '%s' has wrong type";
*strptr++ = /*327 */ "VECTOR subscript for SCALAR array";
*strptr++ = /*328 */ "access to NIL-pointer";
*strptr++ = /*329 */ "selection has too many dimensions";
*strptr++ = /*330 */ "no selection allowed here";
*strptr++ = /*331 */ "illegal expression '%s' in selection";
*strptr++ = /*332 */ "no .xrf file\n";
*strptr++ = /*333 */ ".xrf file older than .z file\n";
*strptr++ = /*334 */ "unable to open .xrf file\n";
*strptr++ = /*335 */ "no source file\n";
*strptr++ = /*336 */ "source file newer than .z file\n";
*strptr++ = /*337 */ "'%s' is not a SET-type";
*strptr++ = /*338 */ "illegal expression '%s' in set";
*strptr++ = /*339 */ "wrong type in SET-constant";
*strptr++ = /*340 */ "value out of set range";
*strptr++ = /*341 */ "%s ist no standard function and no typename";
*strptr++ = /*342 */ "illegal type for constant structure";
*strptr++ = /*343 */ "constant ARRAYs not yet implemented\n";
*strptr++ = /*344 */ "constant RECORDs not yet implemented\n";
*strptr++ = /*345 */ "wrong parametercount for function '%s'";
*strptr++ = /*346 */ "wrong type for function '%s'";
*strptr++ = /*347 */ "port '%s' needs a parameter";
*strptr++ = /*348 */ "port '%s' must not have a parameter";
*strptr++ = /*349 */ "wrong parametercount for port '%s'";
*strptr++ = /*350 */ "wrong type of parameter for port '%s'";
*strptr++ = /*351 */ "function '%s' not yet implemented\n";
*strptr++ = /*352 */ "error in OPENABSW";

strptr = help_texte;
#define LNULL 24
#define SNULL 0
*strptr++ = /*  1 */ "          Simulator Commands :\n";
*strptr++ = /*  2 */ "A(SSIGN)       : set source variable\n";
*strptr++ = /*  3 */ "B(REAKPOINT)   : set / remove breakpoint\n";
*strptr++ = /*  4 */ "C(ALLS)        : show call-stack\n";
*strptr++ = /*  5 */ "CO(NNECTIONS)  : show port connections\n";
*strptr++ = /*  6 */ "D(EBUG)        : set / show debug mode\n";
*strptr++ = /*  7 */ "E(XAMINE)      : display source variable\n";
*strptr++ = /*  8 */ "G(O)           : start / continue program\n";
*strptr++ = /*  9 */ "H(ELP) or ?    : this help\n";
*strptr++ = /* 10 */ "H(ELP) command : help for command\n";
*strptr++ = /* 11 */ "L(OAD)         : load program\n";
*strptr++ = /* 12 */ "LI(ST)         : list program\n";
*strptr++ = /* 13 */ "M(ODE)         : set / show singlestep-/breakpoint mode\n";
*strptr++ = /* 14 */ "N(OTRACE)      : PARZ NOTRACE-command\n";
*strptr++ = /* 15 */ "Q(UIT)         : exit interpreter\n";
*strptr++ = /* 16 */ "R(ECORD)       : set / show record mode\n";
*strptr++ = /* 17 */ "S(HOW)         : show memory and stack contents\n";
*strptr++ = /* 18 */ "SE(T)          : set variable value\n";
*strptr++ = /* 19 */ "ST(EP)         : execute single-step\n";
*strptr++ = /* 20 */ "STO(P)         : stop interrupted program\n";
*strptr++ = /* 21 */ "T(RACE)        : PARZ TRACE-command\n";
*strptr++ = /* 22 */ "W(ARN)         : set / show warning mode\n";
*strptr++ = /* 23 */ "WI(DTH)        : set / show output-width for PE-lists\n";
*strptr++ = /* 24 */ "<RETURN>       : after interrupt and ST(EP) T(O)/A(LL) : single step\n";

#define LLIST 3
#define SLIST (SNULL + LNULL)
*strptr++ = /*  1 */ "LI(ST) [ ( label [ '..' ] ) | ( [ label ] '..' label ) ] \n";
*strptr++ = /*  2 */ "   list selected program lines:\n";
*strptr++ = /*  3 */ "   no lines specified: list whole program\n";

#define LGO 5
#define SGO (SLIST + LLIST)
*strptr++ = /*  1 */ "G(O) [ S(TEP) [ O(VER) ] ] [ T(O) ( label | proc_ident ) ]\n";
*strptr++ = /*  2 */ "   start / continue program execution\n";
*strptr++ = /*  3 */ "   S(TEP) : report each program step, O(VER) : procedure calls as one step\n";
*strptr++ = /*  4 */ "   T(O)   : until statement / sourceline 'label'\n";
*strptr++ = /*  5 */ "                  or procedure 'proc_ident' is reached\n";

#define LSTEP 9
#define SSTEP (SGO + LGO)
*strptr++ = /*  1 */ "ST(EP) [ O(VER) ]\n";
*strptr++ = /*  2 */ "   execute a single program step\n";
*strptr++ = /*  3 */ "ST(EP) [ O(VER) ] T(O) ( label | proc_ident )\n";
*strptr++ = /*  4 */ "   execute program steps until statement / sourceline 'label'\n";
*strptr++ = /*  5 */ "                               or procedure 'proc_ident' is reached\n";
*strptr++ = /*  6 */ "ST(EP) [ O(VER) ] A(LL)\n";
*strptr++ = /*  7 */ "   execute program steps until end of program\n";
*strptr++ = /*  8 */ "      O(VER)      : execute procedure call as one step\n";
*strptr++ = /*  9 */ "      T(O), A(LL) : press <RETURN> to proceed one step\n";

#define LMODE 5
#define SMODE (SSTEP + LSTEP)
*strptr++ = /*  1 */ "M(ODE)        : show singlestep-/breakpoint mode\n";
*strptr++ = /*  2 */ "M(ODE) option : set singlestep-/breakpoint mode\n";
*strptr++ = /*  3 */ "   option :\n";
*strptr++ = /*  4 */ "      C(OMPILER)    : Parallaxis steps\n";
*strptr++ = /*  5 */ "      I(NTERPRETER) : PARZ steps\n";

#define LSTOP 1
#define SSTOP (SMODE + LMODE)
*strptr++ = /*  1 */ "STO(P) : stop interrupted program, set program counter to first statement\n";

#define LLOAD 1
#define SLOAD (SSTOP + LSTOP)
*strptr++ = /*  1 */ "L(OAD) file             : load program from file\n";

#define LBREAKPOINT 6
#define SBREAKPOINT (SLOAD + LLOAD)
*strptr++ = /*  1 */ "B(REAKPOINT) [ [sign] ( label | proc_ident ) [(+|-)offset] ]\n";
*strptr++ = /*  2 */ "   set (if sign = '+' or sign is missing) or\n";
*strptr++ = /*  3 */ "   remove (if sign = '-')\n";
*strptr++ = /*  4 */ "   breakpoint in statement 'label +/- offset' or in sourceline 'label'\n";
*strptr++ = /*  5 */ "              or on entry of procedure 'proc_ident'\n";
*strptr++ = /*  6 */ "   no Arguments : List of all Breakpoints\n";

#define LDEBUG 3
#define SDEBUG (SBREAKPOINT + LBREAKPOINT)
*strptr++ = /*  1 */ "D(EBUG) [ Y(ES) | N(O) | 0 | 1 ] [ P(E) ( ( num [ '..' num ] ),+ | '*' ) ]\n";
*strptr++ = /*  2 */ "   set / show DEBUG/TRACE-mode\n";
*strptr++ = /*  3 */ "   optionally set default PE-list\n";

#define LTRACE 2
#define STRACE (SDEBUG + LDEBUG)
*strptr++ = /*  1 */ "T(RACE) vardesc string AS declaration\n";
*strptr++ = /*  2 */ "   enable TRACE for specified variable block\n";

#define LNOTRACE 2
#define SNOTRACE (STRACE + LTRACE)
*strptr++ = /*  1 */ "N(OTRACE)         : disable TRACE on all variables\n";
*strptr++ = /*  2 */ "N(OTRACE) vardesc : disable TRACE on specific variable\n";

#define LRECORD 4
#define SRECORD (SNOTRACE + LNOTRACE)
*strptr++ = /*  1 */ "R(ECORD) ( O(FF) | N(O) | 0 ) : disable output recording\n";
*strptr++ = /*  2 */ "R(ECORD) ( S(HORT) | 1 )      : record PE-counts\n";
*strptr++ = /*  3 */ "R(ECORD) ( L(ONG) | 2 )       : record statements and PE-lists\n";
*strptr++ = /*  4 */ "R(ECORD)                      : show record-mode\n";

#define LWARN 2
#define SWARN (SRECORD + LRECORD)
*strptr++ = /*  1 */ "W(ARN) ( Y(ES) | N(O) | 0 | 1 ) : set warning-mode\n";
*strptr++ = /*  2 */ "W(ARN)                          : show warning-mode\n";

#define LSET 2
#define SSET (SWARN + LWARN)
*strptr++ = /*  1 */ "SE(T) vardesc [ PE ( ( num [ '..' num ] ),+ | '*' ) ] [ - | NOT ] VarConst\n";
*strptr++ = /*  2 */ "   set vardesc on the PEs specified to [ - | NOT ] VarConst\n";

#define LSHOW 40
#define SSHOW (SSET + LSET)
*strptr++ = /*  1 */ "S(HOW) M(EMORY) [ S ( ( adr [ '..' ] ) | ( [ adr ] '..' adr ) ),* ]\n";
*strptr++ = /*  2 */ "                [ V ( ( adr [ '..' ] ) | ( [ adr ] '..' adr ) ),* ]\n";
*strptr++ = /*  3 */ "                [ PE ( ( num [ '..' num ] ),+ | '*' ) ]\n";
*strptr++ = /*  4 */ "   show contents of specified memory-range :\n";
*strptr++ = /*  5 */ "   adr : integer denoting absolute address\n";
*strptr++ = /*  6 */ "   PE  : list of processors shown\n";
*strptr++ = /*  7 */ "   num : PE-number, '*' : all processors\n";
*strptr++ = /*  8 */ "\n";
*strptr++ = /*  9 */ "S(HOW) H(EAP) ...\n";
*strptr++ = /* 10 */ "   like S(HOW) M(EMORY), negative addresses only\n";
*strptr++ = /* 11 */ "\n";
*strptr++ = /* 12 */ "S(HOW) P(ARSTACK) [ S [ depth ] ]  [ V [ depth ] ]\n";
*strptr++ = /* 13 */ "                  [ PE ( ( num [ '..' num ] ),+ | '*' ) ]\n";
*strptr++ = /* 14 */ "   show contents of parameter-stacks :\n";
*strptr++ = /* 15 */ "   depth : number of stack elements from top of stack\n";
*strptr++ = /* 16 */ "   PE    : list of processors shown\n";
*strptr++ = /* 17 */ "\n";
*strptr++ = /* 18 */ "S(HOW) C(ALLSTACK) [ C(HAIN) [ A(CTIVITY) ] ]\n";
*strptr++ = /* 19 */ "                   [ S [ depth ] ]  [ V [ depth ] ]\n";
*strptr++ = /* 20 */ "                   [ PE ( ( num [ '..' num ] ),+ | '*' ) ]\n";
*strptr++ = /* 21 */ "   show contents of activation-stack :\n";
*strptr++ = /* 22 */ "   C(HAIN)    : show entire call-chain,\n";
*strptr++ = /* 23 */ "   A(CTIVITY) : show pushed PE-lists\n";
*strptr++ = /* 24 */ "   depth      : number of activation records to be shown with variables\n";
*strptr++ = /* 25 */ "   PE         : list of processors shown\n";
*strptr++ = /* 26 */ "\n";
*strptr++ = /* 27 */ "S(HOW) V(ARIABLE) vardesc [ P(ROC) label [ D(EPTH) depth ] ]\n";
*strptr++ = /* 28 */ "                  [ PE ( ( num [ '..' num ] ),+ | '*' ) ] [ AS declaration ]\n";
*strptr++ = /* 29 */ "   show contents of a variable-block :\n";
*strptr++ = /* 30 */ "   vardesc     : first variable in block\n";
*strptr++ = /* 31 */ "   label       : variable from environment of 'PROC label :'\n";
*strptr++ = /* 32 */ "   depth       : number of recursive activations of 'PROC label :' to be shown\n";
*strptr++ = /* 33 */ "   PE          : list of processors shown\n";
*strptr++ = /* 34 */ "   declaration : declaration of variable block\n";
*strptr++ = /* 35 */ "\n";
*strptr++ = /* 36 */ "S(HOW) S(PECIALS) ( MAXTRANS | ACTTRANS | DONE | TERMCH | SRESULT | VRESULT ),*\n";
*strptr++ = /* 37 */ "                  [ PE ( ( num [ '..' num ] ),+ | '*' ) ]\n";
*strptr++ = /* 38 */ "   show contents of specified special variables\n";
*strptr++ = /* 39 */ "   ( show all specials if none is specified )\n";
*strptr++ = /* 40 */ "   PE : list of processors shown\n";

#define LCALLS 2
#define SCALLS (SSHOW + LSHOW)
*strptr++ = /*  1 */ "C(ALLS)            : show dynamic chain\n";
*strptr++ = /*  2 */ "C(ALLS) A(CTIVITY) : show dynamic chain including pushed PE-lists\n";

#define LQUIT 1
#define SQUIT (SCALLS + LCALLS)
*strptr++ = /*  1 */ "Q(UIT) : exit interpreter\n";

#define LHELP 16
#define SHELP (SQUIT + LQUIT)
*strptr++ = /*  1 */ "H(ELP) or ?    : show available commands\n";
*strptr++ = /*  2 */ "H(ELP) command : command description\n";
*strptr++ = /*  3 */ "\n";
*strptr++ = /*  4 */ "syntax of help texts:\n";
*strptr++ = /*  5 */ "   word in capital letters    : Simulator commands (not case-sensitive)\n";
*strptr++ = /*  6 */ "   word in lower case letters : further explained in help text\n";
*strptr++ = /*  7 */ "   X(Y) with X,Y in capital letters\n";
*strptr++ = /*  8 */ "                              : X or longer prefix may be used as abbreviation\n";
*strptr++ = /*  9 */ "   digit   : this digit\n";
*strptr++ = /* 10 */ "   'c'     : the character c\n";
*strptr++ = /* 11 */ "   ( x )   : x\n";
*strptr++ = /* 12 */ "   [ x ]   : optional x\n";
*strptr++ = /* 13 */ "   x | y   : x or y\n";
*strptr++ = /* 14 */ "   x y     : x followed by y\n";
*strptr++ = /* 15 */ "   ( x ),* : possibly empty list of x separated by ','\n";
*strptr++ = /* 16 */ "   ( x ),+ : nonempty list of x separated by ','\n";

#define LWIDTH 1
#define SWIDTH (SHELP + LHELP)
*strptr++ = /*  1 */ "WI(DTH) [ num ] : set / show output-width of PE-lists\n";

#define LCONNECTIONS 4
#define SCONNECTIONS (SWIDTH + LWIDTH)
*strptr++ = /*  1 */ "C(ONNECTIONS) ( enum enum TO enum enum ),*\n";
*strptr++ = /*  2 */ "   enum : ( num [ '..' num ] | '*' )\n";
*strptr++ = /*  3 */ "      list specified port connections :\n";
*strptr++ = /*  4 */ "      no arguments: list all connections\n";

#define LEXAMINE 6
#define SEXAMINE (SCONNECTIONS + LCONNECTIONS)
*strptr++ = /*  1 */ "E(XAMINE) [ ( '!' proc_ident )+ [ '!' depth ] ] [ selection ] expr_list\n";
*strptr++ = /*  2 */ "   Display the values of Parallaxis expressions in 'expr_list'\n";
*strptr++ = /*  3 */ "     proc_ident : 'expr_list' is evaluated from the view of this procedure path\n";
*strptr++ = /*  4 */ "     depth      : Number of examined recursive calls to 'proc_ident'\n";
*strptr++ = /*  5 */ "     selection  : Selected PEs in Parallaxis notation\n";
*strptr++ = /*  6 */ "                  no configuration name, only within parallel block\n";

#define LASSIGN 4
#define SASSIGN (SEXAMINE + LEXAMINE)
*strptr++ = /*  1 */ "A(SSIGN) [ selection ] designator ':=' expr\n";
*strptr++ = /*  2 */ "   Assign the Value of 'expr' to Parallaxis variable defined by 'designator'\n";
*strptr++ = /*  3 */ "     selection : selection of PEs, where assignment takes place\n";
*strptr++ = /*  4 */ "                 no configuration name, only within parallel block\n";

};

#else
char *texte[] =
{
/*  0 */ "unknown command %s",
/*  1 */ "unknown record mode %d\n",
/*  2 */ "\b \b",
/*  3 */ "program is not executable\n",
/*  4 */ "not enough memory for program execution",
/*  5 */ "not enough memory for variables",
/*  6 */ "unknown name",
/*  7 */ "illegal character %c",
/*  8 */ "program has to end with STOP",
/*  9 */ "text following STOP is ignored\n",
/* 10 */ "program has to begin with START",
/* 11 */ "number of processors is missing",
/* 12 */ "could not determine number of processors",
/* 13 */ "number of ports is missing",
/* 14 */ "could not determine number of ports",
/* 15 */ "incorrect connection-list",
/* 16 */ "incorrect SCALAR-declaration",
/* 17 */ "SCALAR-declaration is missing",
/* 18 */ "incorrect VECTOR-declaration",
/* 19 */ "VECTOR-declaration is missing",
/* 20 */ "incorrect statement",
/* 21 */ " ( label : %d )",
/* 22 */ "labels are not in increasing order\n",
/* 23 */ "label must not be 0\n",
/* 24 */ "error in IF - GOTO",
/* 25 */ "illegal jump to PROC-statement",
/* 26 */ "error in END",
/* 27 */ "END must be the last statement",
/* 28 */ "type error",
/* 29 */ "address operation has INTEGER result",
/* 30 */ "a string can only be assigned to a CHAR-array",
/* 31 */ "error in REDUCE",
/* 32 */ "destination must be SCALAR",
/* 33 */ "index variable must be INTEGER",
/* 34 */ "variable error",
/* 35 */ "VECTOR-variable may not be index of a SCALAR-variable",
/* 36 */ "undeclared variable",
/* 37 */ "read-access to write-only-variable",
/* 38 */ "write-access to read-only-variable",
/* 39 */ "error in GOTO",
/* 40 */ "overflow while reading REAL-constant\n",
/* 41 */ "error in IF - CALL",
/* 42 */ "destination has to be PROC-statement",
/* 43 */ "no VECTOR-variables allowed in IF...GOTO",
/* 44 */ "no predeclared variable allowed",
/* 45 */ "incorrect PORT-range %d .. %d",
/* 46 */ "error in PUSHS",
/* 47 */ "variable has to be SCALAR",
/* 48 */ "error in POPV",
/* 49 */ "argument has to be VECTOR",
/* 50 */ "error in CALL",
/* 51 */ "error in PROC",
/* 52 */ "procedure level has to be >= 1",
/* 53 */ "indirect access [%ld] to unknown variable",
/* 54 */ "error in PARALLEL",
/* 55 */ "wrong length of bit-field",
/* 56 */ "argument has to be first variable of a scalar array",
/* 57 */ "error in PROPAGATE",
/* 58 */ "propagated variable has to be VECTOR",
/* 59 */ "no TRACE was set on this variable",
/* 60 */ "not enough memory for program statements!\n",
/* 61 */ "not enough memory for stacks!\n",
/* 62 */ "not enough memory for ports!\n",
/* 63 */ "illegal PE-no %d",
/* 64 */ "illegal PORT-no %d",
/* 65 */ "multiple connections leaving %d %d\n",
/* 66 */ "not enough memory for declarations!\n",
/* 67 */ "assignment of VECTOR-value to SCALAR-variable is impossible",
/* 68 */ "illegal type",
/* 69 */ "incompatible types",
/* 70 */ "port-number has to be INTEGER",
/* 71 */ "port-number has to be a constant or a scalar variable",
/* 72 */ "found at end of program",
/* 73 */ "illegal jump to label %d in statement %d :",
/* 74 */ "missing END-statement!\n",
/* 75 */ "no statements allowed after END-statement",
/* 76 */ "unknown label %d in statement %d :",
/* 77 */ "illegal CALL of label %d in statement %d :",
/* 78 */ "illegal REDUCE-call of label %d in statement %d :",
/* 79 */ "syntax error",
/* 80 */ "not enough memory for this function\n",
/* 81 */ "                        ",
/* 82 */ "destination must be VECTOR",
/* 83 */ "filename not terminated by 'termS'",
/* 84 */ "conflict between scalar and vector types",
/* 85 */ "error in LOAD",
/* 86 */ "first argument has to be VECTOR",
/* 87 */ "second argument has to be SCALAR",
/* 88 */ "error in STORE",
/* 89 */ "argument has to be VECTOR-variable",
/* 90 */ "index variable has no INTEGER-value",
/* 91 */ "use of a not initialized variable",
/* 92 */ "use of unknown variable",
/* 93 */ "RETURN is impossible in main program",
/* 94 */ "end of program while executing a procedure",
/* 95 */ "not enough continuous variables in source-block for MOVE",
/* 96 */ "call of procedure on level %d from level %d",
/* 97 */ "not enough continuous variables in destination-block for MOVE",
/* 98 */ "line %d",
/* 99 */ "assignment of CHAR-value to BOOLEAN-variable",
/*100 */ "assignment of REAL-value to CHAR-variable",
/*101 */ "first argument not initialized",
/*102 */ "second argument not initialized",
/*103 */ "assignment of CHAR-value to REAL-variable",
/*104 */ "incompatible types in block operation",
/*105 */ "not enough continuous variables in first block for EQUAL",
/*106 */ "not enough continuous variables in second block for EQUAL",
/*107 */ "processors, inactive at PROC-call, may not get active before RETURN",
/*108 */ "not enough continuous variables for string-input",
/*109 */ "not enough continuous CHAR-variables for string-input",
/*110 */ "not enough continuous scalar variables for LOAD",
/*111 */ "overflow in floating point operation",
/*112 */ "not enough continuous scalar variables for STORE",
/*113 */ "no active processors for REDUCE",
/*114 */ "illegal statement during REDUCE",
/*115 */ "multiple values arriving on one port",
/*116 */ "subsequent errors and warnings are suppressed\n\n",
/*117 */ "error in TRACE",
/*118 */ "no indirect vector-address allowed",
/*119 */ "PROC-statement reached without CALL",
/*120 */ "error in NOTRACE",
/*121 */ "not enough memory for procedure-call",
/*122 */ "", /* "\n**** function aborted ! ****\n", */
/*123 */ "stack-underflow",
/*124 */ "type conflict in POP-operation",
/*125 */ "not enough memory for trace informations",
/*126 */ "not enough continuous variables for PARALLEL",
/*127 */ "not enough continuous BOOLEAN-variables for PARALLEL",
/*128 */ "not enough continuous variables for string-assignment",
/*129 */ "not enough continuous CHAR-variables for string-assignment",
/*130 */ "error in READ",
/*131 */ "first argument has to be SCALAR",
/*132 */ "maximum width has to be a scalar INTEGER-value",
/*133 */ "error in WRITE",
/*134 */ "error in DRAW",
/*135 */ "output width has to be a scalar INTEGER-value",
/*136 */ "fraction width has to be a scalar INTEGER-value",
/*137 */ "error in WRITELN",
/*138 */ "multiple TRACE on the same variable-block",
/*139 */ "not enough continuous variables",
/*140 */ "not enough continuous variables for TRACE",
/*141 */ "declaration and memory-structure are incompatible",
/*142 */ "STATUS can only be assigned to a BOOLEAN array",
/*143 */ "error in OPENINPUT",
/*144 */ "filename has to be a string or a scalar CHAR-array",
/*145 */ "error in OPENOUTPUT",
/*146 */ "string is not terminated by termS",
/*147 */ "negative exponent in INTEGER-power",
/*148 */ "exponentiation 0 ^ 0",
/*149 */ "negative base in REAL-exponentiation",
/*150 */ "exponentiation 0 ^ negative number",
/*151 */ "division by 0",
/*152 */ "unknown debug mode %d\n",
/*153 */ "multiple incoming connections at %d %d\n",
/*154 */ "multiply defined connection %d %d TO %d %d",
/*155 */ "unknown compile-flag %d\n",
/*156 */ "unknown single-step mode %d\n",
/*157 */ "file %s not found\n",
/*158 */ "not enough continuous variables for string-output",
/*159 */ "not enough continuous CHAR-variables for string-output",
/*160 */ "not enough continuous variables for STATUS-assignment",
/*161 */ "not enough continuous BOOLEAN-variables for STATUS-assignment",
/*162 */ "indirect address [%ld] references wrong type",
/*163 */ "record-file : %s\n",
/*164 */ "cannot open record-file\n",
/*165 */ "\ninput-file : %s\n",
/*166 */ "compiling does not succeed",
/*167 */ "wrong PE-range %d .. %d",
/*168 */ "record-mode : %s\n",
/*169 */ "singlestep-/breakpoint mode : %s\n",
/*170 */ "debug mode : on\n",
/*171 */ "debug mode : off\n",
/*172 */ "incorrect command",
/*173 */ "unknown label : %d",
/*174 */ "wrong offset : %d",
/*175 */ "\ninterrupt at statement :",
/*176 */ "\nstatement reached :",
/*177 */ "\nforced break at statement :",
/*178 */ "\nstep to statement :",
/*179 */ "active processors : ",
/*180 */ "program was not interrupted\n",
/*181 */ "\nPARZ Parallel Simulator, Version 2.08, Univ. Stuttgart, Germany Nov. 1993\n",
/*182 */ "default-PEs : ",
/*183 */ "call-stack does not exist",
/*184 */ "usage of a level %d variable on level %d",
/*185 */ "subsequent warnings for that statement are suppressed\n\n",
/*186 */ "warnings : on\n",
/*187 */ "warnings : off\n",
/*188 */ "unknown warning-mode %d\n",
/*189 */ "-- MORE (help with h) --",
/*190 */ "\r                        \r",
/*191 */ "       ( type >h< for help )\n",
/*192 */ "\n\nwrong option\n",
/*193 */ "\n\nno filename allowed in filter-mode f\n",
/*194 */ "unable to open temporary file",
/*195 */ "wrong TEXT-range %d .. %d",
/*196 */ "no program loaded\n",
/*197 */ "wrong address-range %d .. %d",
/*198 */ "address-range %d .. %d does not exist",
/*199 */ "address-range %d .. %d is not on HEAP",
/*200 */ "error in CONNECTED",
/*201 */ "destination must be of type VECTOR INTEGER",
/*202 */ "mode : %d\n\n",
/*203 */ "program : %s\n\n",
/*204 */ " none",
/*205 */ "procedure %s (%d z), called from line %s (%d z)",
/*206 */ "   local variables for control-processor :",
/*207 */ "   local variables for PE-array :",
/*208 */ "   pushed processor-status : ",
/*209 */ "activation record is missing !\n\n",
/*210 */ "main-program %s : ",
/*211 */ "   global variables for control-processor :",
/*212 */ "   global variables for PE-array :",
/*213 */ "activation-record for main-program is missing !\n\n",
/*214 */ "heap for control-processor :",
/*215 */ " none",
/*216 */ "heap for PE-array :",
/*217 */ "memory of control-processor :",
/*218 */ "memory of PE-array :",
/*219 */ "* ToS *",
/*220 */ "* BoS *",
/*221 */ "parameter-stack for control-processor :",
/*222 */ "parameter-stacks for PE-array :",
/*223 */ "offset to top of call-stack : %d\n",
/*224 */ "address %d does not exist",
/*225 */ "  ...  ",
/*226 */ "address %d is not on the HEAP",
/*227 */ "at \"%.*s\"",
/*228 */ "wrong sign '-'",
/*229 */ "wrong sign NOT",
/*230 */ "no sign allowed",
/*231 */ "selected PE is inactive",
/*232 */ "not enough memory for REDUCE",
/*233 */ "the variable does not exist on the selected PEs",
/*234 */ "    in source-line %d",
/*235 */ "not enough continuous variables in the destination-block for LOAD",
/*236 */ "not enough continuous variables in the source-block for STORE",
/*237 */ "unknown source-line %d",
/*238 */ "no offset allowed in compiler-mode",
/*239 */ "breakpoint set on statement :\n",
/*240 */ "breakpoint removed from statement :\n",
/*241 */ "%*d : %s",
/*242 */ "[error] ",
/*243 */ "[error %d] ",
/*244 */ "\n   in statement :",
/*245 */ "      on PE no %d\n",
/*246 */ "\n[runtime error] ",
/*247 */ "\n[error] ",
/*248 */ "[warning] ",
/*249 */ "\n[warning] ",
/*250 */ "[fatal error] ",
/*251 */ "[we apologize] ",
/*252 */ "output width of PE-lists : %d\n",
/*253 */ "illegal output width 0",
/*254 */ "pa -pxme%d%s <%s",
/*255 */ "",
/*256 */ "expecting: ",
/*257 */ "function '%s' is undefined for %#g as argument",
/*258 */ "function 'arctan' is undefined for %#g / %#g as argument",
/*259 */ "sqrt",
/*260 */ "exp",
/*261 */ "ln",
/*262 */ "sin",
/*263 */ "cos",
/*264 */ "tan",
/*265 */ "arcsin",
/*266 */ "arccos",
/*267 */ "arctan",
/*268 */ "abs",
/*269 */ "function not implemented\n",
/*270 */ "not enough memory for parser",
/*271 */ "error in SEND",
/*272 */ "error in RECEIVE",
/*273 */ "error in GETPIXEL",
/*274 */ "error in OPENW",
/*275 */ "error in MOVETO",
/*276 */ "error in LINETO",
/*277 */ "error in SETPIXEL",
/*278 */ "error in WSIZE",
/*279 */ "error in SETCOLOR",
/*280 */ "error in SELECTW",
/*281 */ "error in CLOSEW",
/*282 */ "grafics routines are only defined for scalar data",
/*283 */ "use of an inactive variant",
/*284 */ "use of an inactive variant in first argument",
/*285 */ "use of an inactive variant in second argument",
/*286 */ "not enough continuous variables for graphic command",
/*287 */ "not enough continuous INTEGER-variables for graphic command",
/*288 */ "no connections exist\n",
/*289 */ "wrong MAGIC-number in xrf-file\n",
/*290 */ "wrong dictionary in xrf-file\n",
/*291 */ "wrong symbol table in xrf-file\n",
/*292 */ "wrong scope table in xrf-file\n",
/*293 */ "wrong linenumber table in xrf-file\n",
/*294 */ "wrong types table in xrf-file\n",
/*295 */ "wrong member table in xrf-file\n",
/*296 */ "missing end-mark in xrf-file\n",
/*297 */ "not enough memory for xrf-data\n",
/*298 */ "+%d",
/*299 */ "not enough memory for source-file\n",
/*300 */ "unable to open sopurce-file\n",
/*301 */ "unknown identifier %s",
/*302 */ "unknown procedure- or system-name %s",
/*303 */ "%s is not allowed as REDUCE operator",
/*304 */ "illegal expression as argument for REDUCE",
/*305 */ "illegal argument for '%s'",
/*306 */ "illegal first argument for '%s'",
/*307 */ "illegal second argument for '%s'",
/*308 */ "illegal identifier %s",
/*309 */ "procedure is not on callstack",
/*310 */ "expression is not assignable",
/*311 */ "no active configuration",
/*312 */ "no PEs selected\n",
/*313 */ "incompatible types for assignment",
/*314 */ "illegal type combination for operator '%s'",
/*315 */ "assignment to constant is impossible",
/*316 */ "error in INITSET",
/*317 */ "destination has to be BOOLEAN",
/*318 */ "not enough continuous variables for INITSET",
/*319 */ "not enough continuous BOOLEAN-variables for INITSET",
/*320 */ "illegal POINTER-constant",
/*321 */ "illegal dereferencing '%s'",
/*322 */ "'%s' is not a RECORD",
/*323 */ "unknown RECORD-component '%s'",
/*324 */ "'%s' is not an ARRAY",
/*325 */ "subscript out of range",
/*326 */ "subscript '%s' has wrong type",
/*327 */ "VECTOR subscript for SCALAR array",
/*328 */ "access to NIL-pointer",
/*329 */ "selection has too many dimensions",
/*330 */ "no selection allowed here",
/*331 */ "illegal expression '%s' in selection",
/*332 */ "no .xrf file\n",
/*333 */ ".xrf file older than .z file\n",
/*334 */ "unable to open .xrf file\n",
/*335 */ "no source file\n",
/*336 */ "source file newer than .z file\n",
/*337 */ "'%s' is not a SET-type",
/*338 */ "illegal expression '%s' in set",
/*339 */ "wrong type in SET-constant",
/*340 */ "value out of set range",
/*341 */ "%s ist no standard function and no typename",
/*342 */ "illegal type for constant structure",
/*343 */ "constant ARRAYs not yet implemented\n",
/*344 */ "constant RECORDs not yet implemented\n",
/*345 */ "wrong parametercount for function '%s'",
/*346 */ "wrong type for function '%s'",
/*347 */ "port '%s' needs a parameter",
/*348 */ "port '%s' must not have a parameter",
/*349 */ "wrong parametercount for port '%s'",
/*350 */ "wrong type of parameter for port '%s'",
/*351 */ "function '%s' not yet implemented\n",
/*352 */ "error in OPENABSW",
/* */ ""
};

char *help_texte[] =
{
#define LNULL 24
#define SNULL 0
/*  1 */ "          Simulator Commands :\n",
/*  2 */ "A(SSIGN)       : set source variable\n",
/*  3 */ "B(REAKPOINT)   : set / remove breakpoint\n",
/*  4 */ "C(ALLS)        : show call-stack\n",
/*  5 */ "CO(NNECTIONS)  : show port connections\n",
/*  6 */ "D(EBUG)        : set / show debug mode\n",
/*  7 */ "E(XAMINE)      : display source variable\n",
/*  8 */ "G(O)           : start / continue program\n",
/*  9 */ "H(ELP) or ?    : this help\n",
/* 10 */ "H(ELP) command : help for command\n",
/* 11 */ "L(OAD)         : load program\n",
/* 12 */ "LI(ST)         : list program\n",
/* 13 */ "M(ODE)         : set / show singlestep-/breakpoint mode\n",
/* 14 */ "N(OTRACE)      : PARZ NOTRACE-command\n",
/* 15 */ "Q(UIT)         : exit interpreter\n",
/* 16 */ "R(ECORD)       : set / show record mode\n",
/* 17 */ "S(HOW)         : show memory and stack contents\n",
/* 18 */ "SE(T)          : set variable value\n",
/* 19 */ "ST(EP)         : execute single-step\n",
/* 20 */ "STO(P)         : stop interrupted program\n",
/* 21 */ "T(RACE)        : PARZ TRACE-command\n",
/* 22 */ "W(ARN)         : set / show warning mode\n",
/* 23 */ "WI(DTH)        : set / show output-width for PE-lists\n",
/* 24 */ "<RETURN>       : after interrupt and ST(EP) T(O)/A(LL) : single step\n",

#ifndef PC
#define LLIST 8
#else 
#define LLIST 3
#endif
#define SLIST (SNULL + LNULL)
/*  1 */ "LI(ST) [ ( label [ '..' ] ) | ( [ label ] '..' label ) ] \n",
/*  2 */ "   list selected program lines:\n",
/*  3 */ "   no lines specified: list whole program\n",
#ifndef PC
/*  4 */ "\n",
/*  5 */ "LI(ST) S(TRINGMATCH) \"string\"\n",
/*  6 */ "   list statement lines containing string\n",
/*  7 */ "LI(ST) P(ATTERN) \"reg.expr.\"\n",
/*  8 */ "   list statement lines containing reg.expr. (according to GREP)\n",
#endif

#define LGO 5
#define SGO (SLIST + LLIST)
/*  1 */ "G(O) [ S(TEP) [ O(VER) ] ] [ T(O) ( label | proc_ident ) ]\n",
/*  2 */ "   start / continue program execution\n",
/*  3 */ "   S(TEP) : report each program step, O(VER) : procedure calls as one step\n",
/*  4 */ "   T(O)   : until statement / sourceline 'label'\n",
/*  5 */ "                  or procedure 'proc_ident' is reached\n",

#define LSTEP 9
#define SSTEP (SGO + LGO)
/*  1 */ "ST(EP) [ O(VER) ]\n",
/*  2 */ "   execute a single program step\n",
/*  3 */ "ST(EP) [ O(VER) ] T(O) ( label | proc_ident )\n",
/*  4 */ "   execute program steps until statement / sourceline 'label'\n",
/*  5 */ "                               or procedure 'proc_ident' is reached\n",
/*  6 */ "ST(EP) [ O(VER) ] A(LL)\n",
/*  7 */ "   execute program steps until end of program\n",
/*  8 */ "      O(VER)      : execute procedure call as one step\n",
/*  9 */ "      T(O), A(LL) : press <RETURN> to proceed one step\n",

#define LMODE 5
#define SMODE (SSTEP + LSTEP)
/*  1 */ "M(ODE)        : show singlestep-/breakpoint mode\n",
/*  2 */ "M(ODE) option : set singlestep-/breakpoint mode\n",
/*  3 */ "   option :\n",
/*  4 */ "      C(OMPILER)    : Parallaxis steps\n",
/*  5 */ "      I(NTERPRETER) : PARZ steps\n",

#define LSTOP 1
#define SSTOP (SMODE + LMODE)
/*  1 */ "STO(P) : stop interrupted program, set program counter to first statement\n",

#ifndef PC
#define LLOAD 2
#else 
#define LLOAD 1
#endif
#define SLOAD (SSTOP + LSTOP)
/*  1 */ "L(OAD) file             : load program from file\n",
#ifndef PC
/*  2 */ "L(OAD) file -C(OMPILER) : compile program from file\n",
#endif

#define LBREAKPOINT 6
#define SBREAKPOINT (SLOAD + LLOAD)
/*  1 */ "B(REAKPOINT) [ [sign] ( label | proc_ident ) [(+|-)offset] ]\n",
/*  2 */ "   set (if sign = '+' or sign is missing) or\n",
/*  3 */ "   remove (if sign = '-')\n",
/*  4 */ "   breakpoint in statement 'label +/- offset' or in sourceline 'label'\n",
/*  5 */ "              or on entry of procedure 'proc_ident'\n",
/*  6 */ "   no Arguments : List of all Breakpoints\n",

#define LDEBUG 3
#define SDEBUG (SBREAKPOINT + LBREAKPOINT)
/*  1 */ "D(EBUG) [ Y(ES) | N(O) | 0 | 1 ] [ P(E) ( ( num [ '..' num ] ),+ | '*' ) ]\n",
/*  2 */ "   set / show DEBUG/TRACE-mode\n",
/*  3 */ "   optionally set default PE-list\n",

#define LTRACE 2
#define STRACE (SDEBUG + LDEBUG)
/*  1 */ "T(RACE) vardesc string AS declaration\n",
/*  2 */ "   enable TRACE for specified variable block\n",

#define LNOTRACE 2
#define SNOTRACE (STRACE + LTRACE)
/*  1 */ "N(OTRACE)         : disable TRACE on all variables\n",
/*  2 */ "N(OTRACE) vardesc : disable TRACE on specific variable\n",

#define LRECORD 4
#define SRECORD (SNOTRACE + LNOTRACE)
/*  1 */ "R(ECORD) ( O(FF) | N(O) | 0 ) : disable output recording\n",
/*  2 */ "R(ECORD) ( S(HORT) | 1 )      : record PE-counts\n",
/*  3 */ "R(ECORD) ( L(ONG) | 2 )       : record statements and PE-lists\n",
/*  4 */ "R(ECORD)                      : show record-mode\n",

#define LWARN 2
#define SWARN (SRECORD + LRECORD)
/*  1 */ "W(ARN) ( Y(ES) | N(O) | 0 | 1 ) : set warning-mode\n",
/*  2 */ "W(ARN)                          : show warning-mode\n",

#define LSET 2
#define SSET (SWARN + LWARN)
/*  1 */ "SE(T) vardesc [ PE ( ( num [ '..' num ] ),+ | '*' ) ] [ - | NOT ] VarConst\n",
/*  2 */ "   set vardesc on the PEs specified to [ - | NOT ] VarConst\n",

#define LSHOW 40
#define SSHOW (SSET + LSET)
/*  1 */ "S(HOW) M(EMORY) [ S ( ( adr [ '..' ] ) | ( [ adr ] '..' adr ) ),* ]\n",
/*  2 */ "                [ V ( ( adr [ '..' ] ) | ( [ adr ] '..' adr ) ),* ]\n",
/*  3 */ "                [ PE ( ( num [ '..' num ] ),+ | '*' ) ]\n",
/*  4 */ "   show contents of specified memory-range :\n",
/*  5 */ "   adr : integer denoting absolute address\n",
/*  6 */ "   PE  : list of processors shown\n",
/*  7 */ "   num : PE-number, '*' : all processors\n",
/*  8 */ "\n",
/*  9 */ "S(HOW) H(EAP) ...\n",
/* 10 */ "   like S(HOW) M(EMORY), negative addresses only\n",
/* 11 */ "\n",
/* 12 */ "S(HOW) P(ARSTACK) [ S [ depth ] ]  [ V [ depth ] ]\n",
/* 13 */ "                  [ PE ( ( num [ '..' num ] ),+ | '*' ) ]\n",
/* 14 */ "   show contents of parameter-stacks :\n",
/* 15 */ "   depth : number of stack elements from top of stack\n",
/* 16 */ "   PE    : list of processors shown\n",
/* 17 */ "\n",
/* 18 */ "S(HOW) C(ALLSTACK) [ C(HAIN) [ A(CTIVITY) ] ]\n",
/* 19 */ "                   [ S [ depth ] ]  [ V [ depth ] ]\n",
/* 20 */ "                   [ PE ( ( num [ '..' num ] ),+ | '*' ) ]\n",
/* 21 */ "   show contents of activation-stack :\n",
/* 22 */ "   C(HAIN)    : show entire call-chain,\n",
/* 23 */ "   A(CTIVITY) : show pushed PE-lists\n",
/* 24 */ "   depth      : number of activation records to be shown with variables\n",
/* 25 */ "   PE         : list of processors shown\n",
/* 26 */ "\n",
/* 27 */ "S(HOW) V(ARIABLE) vardesc [ P(ROC) label [ D(EPTH) depth ] ]\n",
/* 28 */ "                  [ PE ( ( num [ '..' num ] ),+ | '*' ) ] [ AS declaration ]\n",
/* 29 */ "   show contents of a variable-block :\n",
/* 30 */ "   vardesc     : first variable in block\n",
/* 31 */ "   label       : variable from environment of 'PROC label :'\n",
/* 32 */ "   depth       : number of recursive activations of 'PROC label :' to be shown\n",
/* 33 */ "   PE          : list of processors shown\n",
/* 34 */ "   declaration : declaration of variable block\n",
/* 35 */ "\n",
/* 36 */ "S(HOW) S(PECIALS) ( MAXTRANS | ACTTRANS | DONE | TERMCH | SRESULT | VRESULT ),*\n",
/* 37 */ "                  [ PE ( ( num [ '..' num ] ),+ | '*' ) ]\n",
/* 38 */ "   show contents of specified special variables\n",
/* 39 */ "   ( show all specials if none is specified )\n",
/* 40 */ "   PE : list of processors shown\n",

#define LCALLS 2
#define SCALLS (SSHOW + LSHOW)
/*  1 */ "C(ALLS)            : show dynamic chain\n",
/*  2 */ "C(ALLS) A(CTIVITY) : show dynamic chain including pushed PE-lists\n",

#define LQUIT 1
#define SQUIT (SCALLS + LCALLS)
/*  1 */ "Q(UIT) : exit interpreter\n",

#define LHELP 16
#define SHELP (SQUIT + LQUIT)
/*  1 */ "H(ELP) or ?    : show available commands\n",
/*  2 */ "H(ELP) command : command description\n",
/*  3 */ "\n",
/*  4 */ "syntax of help texts:\n",
/*  5 */ "   word in capital letters    : Simulator commands (not case-sensitive)\n",
/*  6 */ "   word in lower case letters : further explained in help text\n",
/*  7 */ "   X(Y) with X,Y in capital letters\n",
/*  8 */ "                              : X or longer prefix may be used as abbreviation\n",
/*  9 */ "   digit   : this digit\n",
/* 10 */ "   'c'     : the character c\n",
/* 11 */ "   ( x )   : x\n",
/* 12 */ "   [ x ]   : optional x\n",
/* 13 */ "   x | y   : x or y\n",
/* 14 */ "   x y     : x followed by y\n",
/* 15 */ "   ( x ),* : possibly empty list of x separated by ','\n",
/* 16 */ "   ( x ),+ : nonempty list of x separated by ','\n",

#define LWIDTH 1
#define SWIDTH (SHELP + LHELP)
/*  1 */ "WI(DTH) [ num ] : set / show output-width of PE-lists\n",

#define LCONNECTIONS 4
#define SCONNECTIONS (SWIDTH + LWIDTH)
/*  1 */ "C(ONNECTIONS) ( enum enum TO enum enum ),*\n",
/*  2 */ "   enum : ( num [ '..' num ] | '*' )\n",
/*  3 */ "      list specified port connections :\n",
/*  4 */ "      no arguments: list all connections\n",

#define LEXAMINE 6
#define SEXAMINE (SCONNECTIONS + LCONNECTIONS)
/*  1 */ "E(XAMINE) [ ( '!' proc_ident )+ [ '!' depth ] ] [ selection ] expr_list\n",
/*  2 */ "   Display the values of Parallaxis expressions in 'expr_list'\n",
/*  3 */ "     proc_ident : 'expr_list' is evaluated from the view of this procedure path\n",
/*  4 */ "     depth      : Number of examined recursive calls to 'proc_ident'\n",
/*  5 */ "     selection  : Selected PEs in Parallaxis notation\n",
/*  6 */ "                  no configuration name, only within parallel block\n",

#define LASSIGN 4
#define SASSIGN (SEXAMINE + LEXAMINE)
/*  1 */ "A(SSIGN) [ selection ] designator ':=' expr\n",
/*  2 */ "   Assign the Value of 'expr' to Parallaxis variable defined by 'designator'\n",
/*  3 */ "     selection : selection of PEs, where assignment takes place\n",
/*  4 */ "                 no configuration name, only within parallel block\n"

};

#endif

extern int morelen;
extern char more_mod, quitted;

printhelp(s)
char *s;
{ fputs(s, stderr); putc('\n', stderr);
  fputs("SYNOPSIS : pz { option | file }\n", stderr);
  fputs("Options and files are processed from left to right.\n", stderr);
  fputs("Options switch between internal modes, files are programs.\n", stderr);
  fputs("   Options :\n", stderr);
#ifndef PC
  fputs("   -c[0|1]         : automatic compiling (default off)\n", stderr);
#endif
  fputs("   -d[0|1]         : DEBUG/TRACE-output (default on)\n", stderr);
  fputs("   -e[0-9]+        : set number of reported errors and warnings (default 15)\n", stderr);
  fputs("   -f              : filter : read program from stdin and start it\n", stderr);
#ifndef CRAY
  fputs("   -l              : load file (if any) and enter command level\n", stderr);
  fputs("   -m[0-9]*        : 'MORE'-screensize (0 : off)\n", stderr);
#endif
  fputs("   -r[0|1|2][file] : record-mode (default off), record-file\n", stderr);
  fputs("                     (with filename : may not be merged with other options)\n", stderr);
  fputs("   -s[0|1|2]       : single-step (1 : Parallaxis, 2 : PARZ)\n", stderr);
  fputs("   -w[0|1]         : runtime-warnings (default on)\n", stderr);
  parzexit(1);
}

print_more_help(f)
FILE *f;
{ fputs("------------------------ Help ------------------------\n\r", f);
  fputs("Space     : show next screen\n\r", f);
  fputs("numSpace  : set screen-length to num, show next screen\n\r", f);
  fputs("Return    : show next line\n\r", f);
  fputs("numReturn : show num lines\n\r", f);
  fputs("q         : abort function\n\r", f);
  fputs("h,?       : this help-text\n\r", f);
  fputs("------------------------------------------------------\n\r", f);
}

help_out(von, len)
int von, len;
{ register int moreflag;
  register int bis;

  if (moreflag = (more_mod && morelen < len))
  { more_on(); }
  for (bis = von + len; von < bis; von++)
  { fputs(help_texte[von], yyerfp); 
    if (moreflag && von < bis - 1) ifmore(yyerfp);
    if (quitted) break;
  }
  if (moreflag) more_off();
  if (quitted) putc('\n', yyerfp);
}

help(komm_tok)
int komm_tok;
{ switch (komm_tok)
  { case 0          : help_out(SNULL,LNULL);
                      break;
    case LIST       : help_out(SLIST,LLIST);
                      break;
    case GO         : help_out(SGO,LGO);
                      break;
    case STEP       : help_out(SSTEP,LSTEP);
                      break;
    case MODE       : help_out(SMODE,LMODE);
                      break;
    case STOP       : help_out(SSTOP,LSTOP);
                      break;
    case LOAD       : help_out(SLOAD,LLOAD);
                      break;
    case BREAKPOINT : help_out(SBREAKPOINT,LBREAKPOINT);
                      break;
    case DEBUG      : help_out(SDEBUG,LDEBUG);
                      break;
    case TRACE      : help_out(STRACE,LTRACE);
                      break;
    case NOTRACE    : help_out(SNOTRACE,LNOTRACE);
                      break;
    case RECORD     : help_out(SRECORD,LRECORD);
                      break;
    case WARN       : help_out(SWARN,LWARN);
                      break;
    case SET        : help_out(SSET,LSET);
                      break;
    case SHOW       : help_out(SSHOW,LSHOW);
                      break;
    case CALLS      : help_out(SCALLS,LCALLS);
                      break;
    case QUIT       : help_out(SQUIT,LQUIT);
                      break;
    case HELP       : help_out(SHELP,LHELP);
                      break;
    case WIDTH      : help_out(SWIDTH,LWIDTH);
                      break;
    case CONNECTIONS: help_out(SCONNECTIONS,LCONNECTIONS);
                      break;
    case EXAMINE    : help_out(SEXAMINE,LEXAMINE);
                      break;
    case ASSIGN     : help_out(SASSIGN,LASSIGN);
                      break;
  }
  bef_tok = 0;
}
