/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : General
  Filename     : fehler.c       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.fehler.c
  Version      : 1.3 
  Last changed : 9/27/93 at 14:04:53        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : Fehlermeldungen fuer PARZ

******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/

static char sccs_id[] = "@(#)fehler.c	1.3  9/27/93 PARZ - General (Frank Sembach)";


#include "parzdefs.h"

FILE *yyerfp = stdout;

extern char yytext[];           /* Vom Scanner zuletzt gelieferter Text */
extern int yyleng;              /* Laenge von yytext */
extern int yylineno;            /* Zeilennummer */
extern int yynerrs;             /* Zahl der gefundenen Fehler */
extern int flags;               /* Angaben ueber schon erreichte Teile des 
                                   Programms */
extern char ausgeben;           /* FALSE : Fehlermeldung wird unterdrueckt */
extern char uebersetzen;        /* Programm kommt vom Compiler */
extern
#ifdef RS6000
       signed
#endif
              char parse_start; /* Benutzungsart des Parsers */
extern int fehlermax;           /* Maximalzahl auszugebender Meldungen */
extern int anz_meldungen, anz_fehler; /* globale Zaehler */
extern STAT *stat_ptr;          /* aktueller Befehl */

/**************************************************************************
 ***                      Funktion yywhere
 ***
 *** gibt Position eines Fehlers im Programm aus
 *** Form 'Zeile x bei "string" :'
 *** 'string' ist der Inhalt von 'yytext'
 *** 'Zeile x' nicht im Kommandointerpreter
 *** sem = TRUE : Semantikfehler, keine Ausgabe von 'bei "string"'
 ***
 **************************************************************************/

yywhere(sem)
int sem;
{ register char colon = 0;

  if (yylineno > 0 && parse_start == -1)
  { if (flags != STOP_DA)
    { fprintf(yyerfp, texte[98], yylineno - (*yytext == '\n' || ! *yytext));
      if (stat_ptr && STAT_label(*stat_ptr) > 0)
      { fprintf(yyerfp, texte[21], STAT_label(*stat_ptr)); }
      colon = 1;
    }
  }
  if (*yytext)
  { register int i;

    if (sem == 0 && flags != STOP_DA)
    { for (i = 0; i < 20; i++)
        if (!yytext[i] || yytext[i] == '\n')
          break;
      if (i)
      { if (colon)
          putc(' ',yyerfp);
        fprintf(yyerfp,texte[227], i, yytext);
        colon = 1;
      }
    }
  }
  if (colon)
    fputs(": ", yyerfp);
}

/**************************************************************************
 ***                      Funktion yyerror
 ***
 *** wird vom Parser aufgerufen und gibt die Fehlermeldung 's' aus,
 *** ergaenzt durch Fehlernummer und Angabe der Position im Programm
 ***
 **************************************************************************/

yyerror(s, t)
register char *s, *t;
{ static int list = 0;
  register char *ftext;
  register int fnum;

  if (ausgeben && (parse_start == -2 || parse_start == -3))
                /* Kommandointerpreter ==> keine Fehlernummer */
  { ftext = texte[242]; }
  else if (flags != STOP_DA && (!uebersetzen || flags > 0) && ausgeben)
                /* Meldung soll ausgegeben werden */
  { if (s || !list)
    { if (anz_meldungen == fehlermax)
      { fputs(texte[116], yyerfp);
        anz_meldungen++; anz_fehler++; yynerrs--; list = 2;
      }
      else if (anz_fehler++, anz_meldungen++ >= fehlermax)
      { yynerrs--; list = 2; }
    }
    ftext = texte[243]; fnum = yynerrs + 1;
  }
  else
  { if (s || !list)
    { if (flags > 0) yynerrs--;   /* kein Fehler nach STOP */
      else                        /* keine Meldung bei leerem Programm */
      { anz_fehler++; anz_meldungen++;
      }
    }
    list = 2;
    ausgeben = TRUE;
  }

  if( s || !list )
  { if (list == 2) return;
    fprintf(yyerfp, ftext, fnum);
    yywhere(FALSE);
    if( s )
    { fprintf(yyerfp, "%s\n", s);
      return ;
    }
    if( t ) 
    { fputs(texte[256], yyerfp);
      fputs(t, yyerfp);
      list = 1 ;
      return ;
    }
    fputs(texte[79], yyerfp);
    return ;
  }
  if( t )
  { if (list == 2) return;
    putc(' ', yyerfp);
    fputs(t, yyerfp);
    return ;
  }
  if (list != 2) putc('\n', yyerfp);
  list = 0 ;
}

