/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : Simulation
  Filename     : funcs.h       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.funcs.h
  Version      : 1.2 
  Last changed : 6/2/93 at 20:39:32        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : externe Definition der Funktionen
                 aus do_<i>funcs.c und print_fu.c
******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/


extern int do_return(), print_return(),
           do_halt(), print_halt(),
           do_end(), print_end(),
           do_closeinput(), print_closeinput(),
           do_closeoutput(), print_closeoutput(),
           do_sbb_zuw(), do_sbi_zuw(), do_sbr_zuw(),
           do_scb_zuw(), do_scc_zuw(), do_sci_zuw(), do_scstr_zuw(),
           do_sib_zuw(), do_sic_zuw(), do_sii_zuw(), do_sir_zuw(),
           do_srb_zuw(), do_sri_zuw(), do_srr_zuw(),
           do_vbb_zuw(), do_vbi_zuw(), do_vbr_zuw(),
           do_vcb_zuw(), do_vcc_zuw(), do_vci_zuw(), do_vcstr_zuw(),
           do_vib_zuw(), do_vic_zuw(), do_vii_zuw(), do_vir_zuw(),
           do_vrb_zuw(), do_vri_zuw(), do_vrr_zuw(), print_zuw(),
           do_si_minus(), do_sr_minus(),
           do_vi_minus(), do_vr_minus(), print_minus(),
           do_sb_not(), do_vb_not(), print_not(),
           do_si_new(), do_vi_new(), print_new(),
           do_status(), print_status(),
           do_sb_random(), do_sc_random(), do_si_random(), do_sr_random(),
           do_vb_random(), do_vc_random(), do_vi_random(), do_vr_random(), print_random(),
           do_s_blockmove(), do_v_blockmove(), print_blockmove(),
           do_s_blockequal(), do_v_blockequal(), print_blockequal(),
           do_si_add(), do_sr_add(),
           do_vi_add(), do_vr_add(), print_add(),
           do_si_sub(), do_sr_sub(),
           do_vi_sub(), do_vr_sub(), print_sub(),
           do_si_mul(), do_sr_mul(),
           do_vi_mul(), do_vr_mul(), print_mul(),
           do_si_div(), do_sr_div(),
           do_vi_div(), do_vr_div(), print_div(),
           do_sii_pow(), do_sri_pow(), do_srr_pow(),
           do_vii_pow(), do_vri_pow(), do_vrr_pow(), print_pow(),
           do_si_mod(), do_vi_mod(), print_mod(),
           do_sb_and(), do_vb_and(), print_and(),
           do_sb_or(), do_vb_or(), print_or(),
           do_s_eq(), do_v_eq(), print_eq(),
           do_s_ne(), do_v_ne(), print_ne(),
           do_s_lt(), do_v_lt(), print_lt(),
           do_s_le(), do_v_le(), print_le(),
           do_s_gt(), do_v_gt(), print_gt(),
           do_s_ge(), do_v_ge(), print_ge(),
           do_sr_sqrt(), do_vr_sqrt(), print_sqrt(),
           do_sr_exp(), do_vr_exp(), print_exp(),
           do_sr_ln(), do_vr_ln(), print_ln(),
           do_sr_sin(), do_vr_sin(), print_sin(),
           do_sr_cos(), do_vr_cos(), print_cos(),
           do_sr_tan(), do_vr_tan(), print_tan(),
           do_sr_arcsin(), do_vr_arcsin(), print_arcsin(),
           do_sr_arccos(), do_vr_arccos(), print_arccos(),
           do_sr_arctan(), do_vr_arctan(), print_arctan(),
           do_sr_arctant(), do_vr_arctant(), print_arctant(),
           do_si_abs(), do_sr_abs(),
           do_vi_abs(), do_vr_abs(), print_abs(),
           do_scc_strcmp(), do_scstr_strcmp(),
           do_sstrc_strcmp(), do_sstrstr_strcmp(),
           do_vcc_strcmp(), do_vcstr_strcmp(),
           do_vstrc_strcmp(), do_vstrstr_strcmp(), print_strcmp(),
           do_connect(), print_connect(),
           do_biconnect(), print_biconnect(),
           do_disconnect(), print_disconnect(),
           do_one_disconnect(), print_one_disconnect(),
           do_s_ifcall(), do_s2_ifcall(), do_v_ifcall(), do_v2_ifcall(), print_ifcall(),
           do_ifgoto(), do_2_ifgoto(), print_ifgoto(),
           do_s_whilecall(), do_s2_whilecall(),
           do_v_whilecall(), do_v2_whilecall(), print_whilecall(),
           do_goto(), print_goto(),
           do_sb_read(), do_sc_read(), do_si_read(), do_sr_read(),
           do_vb_read(), do_vc_read(), do_vi_read(), do_vr_read(), print_read(),
           do_sread_string(), do_vread_string(), print_read_string(),
           do_s1_write(), do_v1_write(), print_1_write(),
           do_si2_write(), do_sr2_write(), do_sstr2_write(),
           do_vi2_write(), do_vr2_write(), do_vstr2_write(), print_2_write(),
           do_sr3_write(), do_vr3_write(), print_3_write(),
           do_s1_draw(), print_1_draw(),
           do_si2_draw(), do_sr2_draw(), do_sstr2_draw(), print_2_draw(),
           do_sr3_draw(), print_3_draw(),
           do_s1_writeln(), do_v1_writeln(), print_1_writeln(),
           do_si2_writeln(), do_sr2_writeln(), do_sstr2_writeln(), print_2_writeln(),
           do_sr3_writeln(), print_3_writeln(),
           do_load(), print_load(),
           do_store(), print_store(),
           do_blockload(), print_blockload(),
           do_blockstore(), print_blockstore(),
           do_reduce_first(), do_reduce_last(),
           do_i_reduce_sum(), do_r_reduce_sum(),
           do_i_reduce_prod(), do_r_reduce_prod(),
           do_b_reduce_max(), do_c_reduce_max(), do_i_reduce_max(), do_r_reduce_max(),
           do_b_reduce_min(), do_c_reduce_min(), do_i_reduce_min(), do_r_reduce_min(),
           do_b_reduce_and(), do_b_reduce_or(),
           do_proc_reduce(), print_op_reduce(), print_proc_reduce(),
           do_pushs(), print_pushs(),
           do_s_pushv(), do_v_pushv(), print_pushv(),
           do_s_pops(), do_v_pops(), print_pops(),
           do_popv(), print_popv(),
           do_call(), print_call(),
           do_proc(), print_proc(),
           do_parbit(), print_parbit(),
           do_parvar(), print_parvar(),
           do_s_initset(), do_v_initset(), print_initset(),
           do_propagate(), print_propagate(),
           do_to_propagate(), print_to_propagate(),
           do_redproc_propagate(), print_redproc_propagate(),
           do_send(), print_send(),
           do_redproc_send(), print_redproc_send(),
           do_receive(), print_receive(),
           do_redproc_receive(), print_redproc_receive(),
           do_inconnected(), print_inconnected(),
           do_outconnected(), print_outconnected(),
           do_line_inconnected(), print_line_inconnected(),
           do_line_outconnected(), print_line_outconnected(),
           do_openinput(), print_openinput(),
           do_openoutput(), print_openoutput(),
           do_errorcall(), print_errorcall(),
           do_getpixel(), print_getpixel(),
           do_openw(), print_openw(),
           do_openabsw(), print_openabsw(),
           do_moveto(), print_moveto(),
           do_lineto(), print_lineto(),
           do_s_setpixel(), do_v_setpixel(), print_setpixel(),
           do_wsize(), print_wsize(),
           do_s_setcolor(), do_v_setcolor(), print_setcolor(),
           do_selectw(), print_selectw(),
           do_closew(), print_closew(),
           do_debug(), print_debug(),
           do_trace(), print_trace(),
           do_notrace(), print_notrace(),
           do_nop(), print_nop(),
           do_falsch(), print_falsch();

