/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : Simulation
  Filename     : graphic.c       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.graphic.c
  Version      : 1.3 
  Last changed : 9/27/93 at 14:04:54        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : Graphikfunktionen zum PARZ-Simulator

******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/

static char sccs_id[] = "@(#)graphic.c	1.3  9/27/93 PARZ - Simulation (Frank Sembach)";


#include "parzdefs.h"
#include "externs.h"
#include "xgraph.h"

extern int px_error;

int getpixel(x, y, rerg, gerg, berg)
long x, y;
ITEM *rerg, *gerg, *berg;
{ COLREC rgb_erg;
  int erg;

  if (erg = GetPixel(x, y, &rgb_erg))
    { set_i_item(rerg, rgb_erg.r.i, 0);
      set_i_item(gerg, rgb_erg.g.i, 0);
      set_i_item(berg, rgb_erg.b.i, 0);
    }
  return erg;
}

int openw(x, y, ziel)
float x, y;
ITEM *ziel;
{ int erg;

  erg = OpenW(x, y, pe_anz);
  if (erg >= 0)
    { set_i_item(ziel, erg, 0);
    }
  else
/*    fprintf(stderr, "OpenW --> %d; px_error = %d\n", erg, px_error);*/
  return (erg >= 0);
}

int openabsw(x, y, ziel)
int x, y;
ITEM *ziel;
{ int erg;

  erg = OpenAbsW(x, y, pe_anz);
  if (erg >= 0)
    { set_i_item(ziel, erg, 0);
    }
  else
/*    fprintf(stderr, "OpenAbsW --> %d; px_error = %d\n", erg, px_error);*/
  return (erg >= 0);
}

/*

int moveto(x, y)
long x, y;
{ return MoveTo(x, y);
}

int lineto(x, y)
long x, y;
{ return LineTo(x, y);
}

int setpixel(x, y)
long x, y;
{ return SetPixel(x, y);
}

*/

int wsize(xerg, yerg)
ITEM *xerg, *yerg;
{ int x, y, erg;

  if (erg = WSize(&x, &y))
    { set_i_item(xerg, x, 0);
      set_i_item(yerg, y, 0);
    }
  return erg;
}

int setcolor(r, g, b)
long r, g, b;
{ COLREC rgb;
  int erg;

  rgb.r.i = r;
  rgb.g.i = g;
  rgb.b.i = b;
  return SetColor(&rgb);
}

/*
  
int selectw(handle)
long handle;
{ return SelectW(handle);
}

int closew(handle)
long handle;
{ return CloseW(handle);
}

*/
