/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : Kommandointerpreter
  Filename     : komdefs.h       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.komdefs.h
  Version      : 1.2 
  Last changed : 6/2/93 at 20:39:34        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : globale Definitionen fuer Kommandointerpreter von PARZ

******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/


/* Bits fuer Singlestep-/Breakpoint Modus */
#define STEP_COMP 1
#define STEP_INTER 2
#define STEP_OVER 4

/* Exitcodes fuer Kommandointerpreter */
#define DO_STOP 1
#define DO_LOAD 2
#define DO_COMPILE 3
#define DO_GO 4
#define DO_STEP 5

/* Bits fuer Aktivierungsstack-Optionen */
#define CHAIN_OPT 1
#define ACTIVITY_OPT 2

/* Allozierungsblockgroesse fuer zusaetzliche TRACE-Befehle */
#define TR_STAT_BLOCK 10

/* Bildschirmbreite */
#define CRTCOLS 80

typedef struct range            /* Wertebereich */
{ int von_n, bis_n;
} RANGE;

typedef struct rangelist        /* verkettete Liste von 'range's */
{ RANGE r;
  struct rangelist *next_range;
} RANGELIST;

typedef struct memdeclist       /* RANGELIST-Zeiger plus Zeiger auf letztes Element */
{ RANGELIST *mem_erster, *mem_letzter;
} MEMDECLIST;

typedef struct conlist          /* verkettete Liste aus Verbindungsmustern */
{ RANGE v_pe, v_po, n_pe, n_po; /* Wertebereiche fuer alle Komponenten der Verb. */
  struct conlist *conlist_tail; /* Verkettung */
} CONLIST;

typedef struct optproc          /* Darstellung von '[ PROC label [DEPTH tiefe ]] */
{ int p_lab, p_tief, ab_abstand;
} OPTPROC;

typedef struct zeile            /* Zeilennummer bzw. Liste von Zeilennummern */
{ int list_flag;
  union
  { int znr;
    struct
    { int zcount;
      int *zl;
    } zlist;
  } zval;
} ZEILE;
