
# line 2 "parz.y"
/******* Datei parz.y ******
 *
 *      Parser fuer PARZ V2.x
 *      Frank Sembach
 */

#include "parzdefs.h"
#include "komdefs.h"


# line 13 "parz.y"
typedef union 
 { long int_val;
   float real_val;
   unsigned char char_val;
   char *string_val;
   char *bitstring_val;
   char *comment;
   DECLIST decl_def;
   UNION_LIST union_def;
   TYP typ_def;
   ARG arg_def;
   CONLIST *conlist_ptr;
   RANGE range_val;
   MEMDECLIST memdeclist_val;
   RANGELIST *memlist_val;
   OPTPROC optproc_val;
   SCOPETAB *procidlist_val;
   long ident_key;
   ZEILE zeil_list;
   EXPRLIST exprlist_info;
   EXPR expr_info;
   SEXPR sexpr_info;
   SELECT select_info;
   EXPR_RANGE set_range;
 } YYSTYPE;
# define PLUS 257
# define MINUS 258
# define UMINUS 259
# define MAL 260
# define DURCH 261
# define MOD 262
# define SQRT 263
# define EXP 264
# define LN 265
# define SIN 266
# define COS 267
# define TAN 268
# define ARCSIN 269
# define ARCCOS 270
# define ARCTAN 271
# define ARCTANT 272
# define ABS 273
# define AND 274
# define OR 275
# define FIRST 276
# define LAST 277
# define SUM 278
# define PRODUCT 279
# define MAX 280
# define MIN 281
# define PROGRAMMSTART 282
# define KOMMANDOSTART 283
# define INTNUM 284
# define INTKLAM 285
# define REALNUM 286
# define CHAR 287
# define STRING 288
# define BITSTRING 289
# define EQ 290
# define NE 291
# define LT 292
# define LE 293
# define GT 294
# define GE 295
# define AOP 296
# define NIL 297
# define MYTRUE 298
# define MYFALSE 299
# define TERMS 300
# define EOL 301
# define MAXTRANS 302
# define ACTTRANS 303
# define DONE 304
# define TERMCH 305
# define SRESULT 306
# define ID 307
# define VRESULT 308
# define START 309
# define PE 310
# define PORTS 311
# define STOP 312
# define TO 313
# define SCALAR 314
# define VECTOR 315
# define RETURN 316
# define HALT 317
# define END 318
# define ADDR 319
# define NEW 320
# define NOT 321
# define STATUS 322
# define RANDOM 323
# define MOVE 324
# define EQUAL 325
# define AS 326
# define CONNECT 327
# define BICONNECT 328
# define AT 329
# define DISCONNECT 330
# define STRCMP 331
# define SIZE 332
# define IF 333
# define WHILE 334
# define CALL 335
# define GOTO 336
# define READ 337
# define WRITE 338
# define DRAW 339
# define WRITELN 340
# define LOAD 341
# define WITH 342
# define STORE 343
# define REDUCE 344
# define OF 345
# define PUSHS 346
# define PUSHV 347
# define POPS 348
# define POPV 349
# define PROC 350
# define PARALLEL 351
# define PROPAGATE 352
# define OUT 353
# define IN 354
# define SEND 355
# define RECEIVE 356
# define FROM 357
# define CONNECTED 358
# define NOP 359
# define B 360
# define C 361
# define I 362
# define R 363
# define U 364
# define S 365
# define V 366
# define OPENINPUT 367
# define OPENOUTPUT 368
# define CLOSEINPUT 369
# define CLOSEOUTPUT 370
# define GETPIXEL 371
# define OPENW 372
# define OPENABSW 373
# define MOVETO 374
# define LINETO 375
# define SETPIXEL 376
# define WSIZE 377
# define SETCOLOR 378
# define SELECTW 379
# define CLOSEW 380
# define ERROR 381
# define DEBUG 382
# define TRACE 383
# define NOTRACE 384
# define INITSET 385
# define ZEILEND 386
# define PP 387
# define LIST 388
# define CONNECTIONS 389
# define PATTERN 390
# define STRINGMATCH 391
# define GO 392
# define STEP 393
# define SET 394
# define OVER 395
# define ALL 396
# define COMPILER 397
# define INTERPRETER 398
# define FILENAME 399
# define ASSIGN 400
# define BREAKPOINT 401
# define EXAMINE 402
# define EIN 403
# define AUS 404
# define RECORD 405
# define KURZ 406
# define LANG 407
# define SHOW 408
# define MEMORY 409
# define HEAP 410
# define PARSTACK 411
# define CALLSTACK 412
# define CHAIN 413
# define ACTIVITY 414
# define VARIABLE 415
# define SPECIALS 416
# define DEPTH 417
# define WARN 418
# define CALLS 419
# define MODE 420
# define WIDTH 421
# define QUIT 422
# define HELP 423
# define IDENT 424
# define DIV 425
# define POWER 426

# line 133 "parz.y"
/*********************************************/
#include "externs.h"
#include "rundefs.h"
#include "runexts.h"
#include "komexts.h"
#include "debexts.h"
#include "funcs.h"

/* externs aus parz.l :  */
extern char *lies_comm(), *lies_zend();

extern char ausgeben;       /* Flag : Naechste Fehlermeldung ausgeben */
extern char bef_lesen;      /* Flag : Befehlstoken erwartet (Kommandointerp. ) */

extern FILE *yyin;          /* Eingabefile */
extern FILE *yyerfp;        /* File fuer Fehlermeldungen */
extern int yylineno;        /* Zeilenzaehler */
extern int anz_runwarnings; /* Zahl der ausgegebenen Warnungen zu einem SET-Kommando */

/*********************************************/

extern int yynerrs;         /* Zaehler fuer Fehlermeldungen */
#ifdef YYDEBUG
extern int yydebug;
#endif

char lesend, nospez;        /* Art des naechsten Zugriffs auf eine Variable */

char do_step = FALSE;           /* parser hat "#\n" zurueckgegeben */
char scanner_fehler = FALSE;    /* scanner hat in Zeile Fehler gemeldet */

int flags;                      /* Information ueber gelesene Schluesselworte */
int nach_end;                   /* Zaehlt Befehle nach dem letzten END-Befehl */
int last_label;                 /* letztes gelesenes Label */
int akt_max;                    /* maximale verfuegbare Programmadresse */

#define HEAP_ADRS 1
#define VEC_ADRS 2
char adrsort;                   /* Art der Adressen fuer memel */

STAT *stat_ptr;                 /* Zeiger auf momentan erzeugten Befehl */

struct func_ptrs
{ int (* do_f[2][REAL + 1])();
  int (* print_f)();
} op_funcs[OR - PLUS + 1] =     /* Zeiger auf Funktionen fuer unaere und binaere
                                   Operatoren */
{ { { { do_falsch, do_falsch, do_si_add, do_sr_add },       /* PLUS */
      { do_falsch, do_falsch, do_vi_add, do_vr_add } },
    print_add },
  { { { do_falsch, do_falsch, do_si_sub, do_sr_sub },       /* MINUS */
      { do_falsch, do_falsch, do_vi_sub, do_vr_sub } },
    print_sub },
  { { { do_falsch, do_falsch, do_si_minus, do_sr_minus },   /* UMINUS */
      { do_falsch, do_falsch, do_vi_minus, do_vr_minus } },
    print_minus },
  { { { do_falsch, do_falsch, do_si_mul, do_sr_mul },       /* MAL */
      { do_falsch, do_falsch, do_vi_mul, do_vr_mul } },
    print_mul },
  { { { do_falsch, do_falsch, do_si_div, do_sr_div },       /* DURCH */
      { do_falsch, do_falsch, do_vi_div, do_vr_div } },
    print_div },
  { { { do_falsch, do_falsch, do_si_mod, do_falsch },       /* MOD */
      { do_falsch, do_falsch, do_vi_mod, do_falsch } },
    print_mod },
  { { { do_falsch, do_falsch, do_falsch, do_sr_sqrt },      /* SQRT */
      { do_falsch, do_falsch, do_falsch, do_vr_sqrt } },
    print_sqrt },
  { { { do_falsch, do_falsch, do_falsch, do_sr_exp },       /* EXP */
      { do_falsch, do_falsch, do_falsch, do_vr_exp } },
    print_exp },
  { { { do_falsch, do_falsch, do_falsch, do_sr_ln },        /* LN */
      { do_falsch, do_falsch, do_falsch, do_vr_ln } },
    print_ln },
  { { { do_falsch, do_falsch, do_falsch, do_sr_sin },       /* SIN */
      { do_falsch, do_falsch, do_falsch, do_vr_sin } },
    print_sin },
  { { { do_falsch, do_falsch, do_falsch, do_sr_cos },       /* COS */
      { do_falsch, do_falsch, do_falsch, do_vr_cos } },
    print_cos },
  { { { do_falsch, do_falsch, do_falsch, do_sr_tan },       /* TAN */
      { do_falsch, do_falsch, do_falsch, do_vr_tan } },
    print_tan },
  { { { do_falsch, do_falsch, do_falsch, do_sr_arcsin },    /* ARCSIN */
      { do_falsch, do_falsch, do_falsch, do_vr_arcsin } },
    print_arcsin },
  { { { do_falsch, do_falsch, do_falsch, do_sr_arccos },    /* ARCCOS */
      { do_falsch, do_falsch, do_falsch, do_vr_arccos } },
    print_arccos },
  { { { do_falsch, do_falsch, do_falsch, do_sr_arctan },    /* ARCTAN */
      { do_falsch, do_falsch, do_falsch, do_vr_arctan } },
    print_arctan },
  { { { do_falsch, do_falsch, do_falsch, do_sr_arctant },   /* ARCTANT */
      { do_falsch, do_falsch, do_falsch, do_vr_arctant } },
    print_arctant },
  { { { do_falsch, do_falsch, do_si_abs, do_sr_abs },       /* ABS */
      { do_falsch, do_falsch, do_vi_abs, do_vr_abs } },
    print_abs },
  { { { do_sb_and, do_falsch, do_falsch, do_falsch },       /* AND */
      { do_vb_and, do_falsch, do_falsch, do_falsch } },
    print_and },
  { { { do_sb_or, do_falsch, do_falsch, do_falsch },        /* OR */
      { do_vb_or, do_falsch, do_falsch, do_falsch } },
    print_or }
};

struct
{ int (* do_rf[2])(), (* print_rf)();
} rel_op_funcs[GE - EQ + 1] =           /* Funktionen fuer Vergleichsbefehle */
{ { {do_s_eq, do_v_eq}, print_eq},
  { {do_s_ne, do_v_ne}, print_ne},
  { {do_s_lt, do_v_lt}, print_lt},
  { {do_s_le, do_v_le}, print_le},
  { {do_s_gt, do_v_gt}, print_gt},
  { {do_s_ge, do_v_ge}, print_ge}
};

int (* assign_do_funcs[2][REAL + 1][STR + 1])() =       /* Funktionen fuer Zuweisung */
{ { {do_sbb_zuw, do_falsch, do_sbi_zuw, do_sbr_zuw, do_falsch},
    {do_scb_zuw, do_scc_zuw, do_sci_zuw, do_falsch, do_scstr_zuw},
    {do_sib_zuw, do_sic_zuw, do_sii_zuw, do_sir_zuw, do_falsch},
    {do_srb_zuw, do_falsch, do_sri_zuw, do_srr_zuw, do_falsch}
  },
  { {do_vbb_zuw, do_falsch, do_vbi_zuw, do_vbr_zuw, do_falsch},
    {do_vcb_zuw, do_vcc_zuw, do_vci_zuw, do_falsch, do_vcstr_zuw},
    {do_vib_zuw, do_vic_zuw, do_vii_zuw, do_vir_zuw, do_falsch},
    {do_vrb_zuw, do_falsch, do_vri_zuw, do_vrr_zuw, do_falsch}
  }
};

int (* random_do_funcs[2][STR + 1])() =         /* Funktionen fuer RANDOM */
{ {do_sb_random, do_sc_random, do_si_random, do_sr_random, do_falsch},
  {do_vb_random, do_vc_random, do_vi_random, do_vr_random, do_falsch}
};

int (* strcmp_do_funcs[2][STR + 1][STR + 1])() =        /* Funktionen fuer STRCMP */
{ { {do_falsch, do_falsch, do_falsch, do_falsch, do_falsch},
    {do_falsch, do_scc_strcmp, do_falsch, do_falsch, do_scstr_strcmp},
    {do_falsch, do_falsch, do_falsch, do_falsch, do_falsch},
    {do_falsch, do_falsch, do_falsch, do_falsch, do_falsch},
    {do_falsch, do_sstrc_strcmp, do_falsch, do_falsch, do_sstrstr_strcmp}
  },
  { {do_falsch, do_falsch, do_falsch, do_falsch, do_falsch},
    {do_falsch, do_vcc_strcmp, do_falsch, do_falsch, do_vcstr_strcmp},
    {do_falsch, do_falsch, do_falsch, do_falsch, do_falsch},
    {do_falsch, do_falsch, do_falsch, do_falsch, do_falsch},
    {do_falsch, do_vstrc_strcmp, do_falsch, do_falsch, do_vstrstr_strcmp}
  }
};

int (* red_do_funcs[STR + 1][MIN - AND + 1])() =      /* Funktionen fuer REDUCE */
{ {do_b_reduce_and, do_b_reduce_or, do_reduce_first, do_reduce_last, do_falsch, do_falsch, do_b_reduce_max, do_b_reduce_min},
  {do_falsch, do_falsch, do_reduce_first, do_reduce_last, do_falsch, do_falsch, do_c_reduce_max, do_c_reduce_min},
  {do_falsch, do_falsch, do_reduce_first, do_reduce_last, do_i_reduce_sum, do_i_reduce_prod, do_i_reduce_max, do_i_reduce_min},
  {do_falsch, do_falsch, do_reduce_first, do_reduce_last, do_r_reduce_sum, do_r_reduce_prod, do_r_reduce_max, do_r_reduce_min},
  {do_falsch, do_falsch, do_falsch, do_falsch, do_falsch, do_falsch, do_falsch, do_falsch}
};

int (* read_do_funcs[2][REAL + 1])() =     /* Funktionen fuer READ */
{ { do_sb_read, do_sc_read, do_si_read, do_sr_read },
  { do_vb_read, do_vc_read, do_vi_read, do_vr_read } };

int (* write2_do_funcs[2][STR + 1])() =     /* Funktionen fuer WRITE (2 Argumente) */
{ { do_falsch, do_sstr2_write, do_si2_write, do_sr2_write, do_falsch },
  { do_falsch, do_vstr2_write, do_vi2_write, do_vr2_write, do_falsch } };

int (* draw2_do_funcs[STR + 1])() =        /* Funktionen fuer DRAW (2 Argumente) */
{ do_falsch, do_sstr2_draw, do_si2_draw, do_sr2_draw, do_falsch };

int (* writeln2_do_funcs[2][STR + 1])() =   /* Funktionen fuer WRITELN (2 Argumente) */
{ { do_falsch, do_sstr2_writeln, do_si2_writeln, do_sr2_writeln, do_falsch },
  { do_falsch, do_vstr2_write, do_vi2_write, do_vr2_write, do_falsch } };

int red_typs[MIN - AND + 1] =           /* erlaubte Typen fuer Reduktionsfunktionen : */
{ (1<<BOOL),                              /* AND */
  (1<<BOOL),                              /* OR */
  (1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL),  /* FIRST */
  (1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL),  /* LAST */
  (1<<INT | 1<<REAL),                     /* SUM */
  (1<<INT | 1<<REAL),                     /* PRODUCT */
  (1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL),  /* MAX */
  (1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL),  /* MIN */
};

extern AKTBLOCK *temp_a_block;         /* Zeiger auf Aktivierungsblock,
                                   der bei symbolischem Debuggen erzeugt wird 
                                   und von PROC vervollstaendigt werden muss */

extern char *ssstr[];           /* Texte fuer Singlestep-/Breakpointmodus */
extern char *protstr[];         /* Texte fuer Protokollmodus */

char *promptstr[2] = { "P> ", "P* " };

int graph_bef_exist;

#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
typedef int yytabelem;
# define YYERRCODE 256

# line 4085 "parz.y"


#include "yydispl.h"

extern DECL *neu_decl();
extern DECLIST *dlptr();
yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 261,
	284, 379,
	-2, 364,
-1, 308,
	310, 367,
	386, 367,
	-2, 368,
-1, 390,
	0, 9,
	-2, 37,
-1, 439,
	284, 379,
	-2, 374,
-1, 540,
	256, 129,
	59, 129,
	-2, 240,
-1, 572,
	256, 206,
	59, 206,
	-2, 242,
-1, 624,
	256, 180,
	59, 180,
	-2, 240,
	};
# define YYNPROD 504
# define YYLAST 1043
yytabelem yyact[]={

   364,   167,   846,   765,   795,   774,   231,   825,   726,   725,
   590,   377,   589,   351,   339,   418,   142,   245,    65,    60,
   587,   588,   419,   342,   477,   340,   365,   242,   123,   109,
   427,   399,   303,   472,   289,   253,   490,    75,   473,   135,
   136,   137,   138,   268,   417,   139,   140,   205,   119,   341,
   224,   338,   113,   255,   187,   156,    89,    82,   100,   120,
   121,   439,   350,   297,   194,    76,   406,   407,   408,   409,
   410,   411,   173,   173,   174,   174,   435,   179,   190,   129,
   186,   593,   446,   177,    86,   141,   442,   441,   436,   386,
   360,   159,   165,   162,   353,   344,   318,   306,   171,    96,
   110,   103,   279,    90,   259,   101,    95,   257,   256,    98,
   108,   107,   249,   430,   230,   229,   228,    92,    93,    97,
   227,   199,   105,   223,   197,   106,   196,   191,   188,   117,
   412,   175,   235,   225,   264,   111,    94,   102,   112,   104,
    99,   158,   157,   148,   149,   150,   151,   152,   153,   154,
   198,   124,   122,   185,   308,   596,   203,   512,   502,   503,
   574,   261,   641,   647,   683,   536,   537,   243,   538,   539,
   586,   540,   304,   236,   542,   543,   544,   541,   556,   557,
   559,   558,   554,   236,   555,   460,   226,   546,   547,   548,
   549,   545,   550,   551,   164,   163,   552,   553,   309,   126,
   504,   127,   128,    84,    85,   310,   146,   147,   561,   562,
   526,   528,   161,   160,   837,   563,   564,   565,   566,   567,
   568,   569,   560,   570,   571,   572,   406,   407,   408,   409,
   410,   411,   118,   269,   283,   115,   116,   394,   280,   575,
    20,   833,   406,   407,   408,   409,   410,   411,   218,   219,
   220,   221,   237,   475,   218,   219,   220,   221,   218,   219,
   220,   221,   237,   776,   775,   476,   832,   406,   407,   408,
   409,   410,   411,   737,   421,   363,   423,   422,   424,   217,
   222,   300,   808,   826,   455,   311,   740,    80,   330,   332,
   412,   788,   789,   791,   818,   817,    61,   815,   804,    81,
   803,   206,   847,   323,   785,   325,   412,   489,   328,   390,
   321,   428,   233,   736,   649,   799,    67,   738,   848,   724,
   723,   721,   296,   405,    70,    51,   720,    69,   352,   181,
   387,   412,    17,    16,   429,     7,   358,   393,   463,   601,
   378,   617,   383,   210,   211,   212,   213,   214,   398,   215,
   281,   727,   728,   729,   730,   731,   732,   193,   192,   397,
   352,   247,    82,   335,   850,   391,    47,    62,    54,    15,
    21,   234,    52,    46,    68,   384,    49,    59,    58,   311,
   311,   381,   608,   299,    43,    44,    48,   385,     6,    56,
   382,   612,    57,    11,   753,   276,   447,    14,   462,   236,
   595,    78,    63,    45,    53,    64,    55,    50,   334,   274,
   452,   336,   592,   454,   420,   172,   474,   312,   434,   189,
   374,    10,   375,   373,   281,   176,   494,   493,   445,   440,
   433,   469,   301,   370,   368,   369,   371,   372,   148,   149,
   150,   151,   152,   153,   154,   357,   348,   346,   345,   485,
   492,   481,   465,   480,   468,   367,   266,   285,   470,   258,
   248,   486,   195,   487,   491,     2,     3,   709,   376,   495,
   284,   496,   456,   307,   218,   219,   220,   221,   237,   584,
   710,   236,   577,   168,   426,   535,    79,   578,   209,   263,
   238,   594,   581,   579,   711,   583,   241,   265,   335,   484,
   646,   146,   147,   414,   352,   415,   260,   600,   271,   591,
   599,   478,   450,   451,   403,   461,   202,   646,   273,   466,
   435,   148,   149,   150,   151,   152,   153,   154,   403,   453,
   449,   337,   661,   662,   663,   664,   665,   666,   667,   668,
   669,   655,   660,   334,   343,   240,   336,   607,   598,    12,
   611,   597,   573,   326,   437,   622,   218,   219,   220,   221,
   237,   324,   438,   576,   482,   602,   603,   642,   385,   464,
   435,   173,   628,   174,   382,   615,   616,   402,   356,   618,
   621,   702,   349,   624,   146,   147,   322,   290,   277,   651,
   650,   652,   653,   634,   479,   643,   635,   294,   645,   295,
   639,   640,   275,   246,    81,   672,   673,   674,   591,   395,
   675,   676,   396,   333,   678,   679,   180,   401,   292,   680,
   681,   682,   169,   644,   685,   301,   687,   688,   689,   670,
   671,   432,   692,   693,   694,   431,   448,   697,   698,   287,
   656,   657,   658,   406,   407,   408,   409,   410,   411,   706,
   286,   252,   184,   714,   659,     1,   467,   704,   690,   691,
   291,   695,   696,   400,   244,   699,   700,   701,   483,   457,
   703,   582,   591,   705,    71,   148,   149,   150,   151,   152,
   153,   154,   250,   317,   355,   201,   733,   742,   743,   744,
   745,   746,   747,   748,   749,   750,   735,   272,   722,   766,
   767,   768,   769,   770,   771,   772,   773,   412,   262,   608,
   764,   751,   752,   777,   778,   755,   779,   780,   781,   782,
   783,   267,   200,   288,   786,   787,   134,   790,   406,   407,
   408,   409,   410,   411,   133,   416,   313,   794,   379,   380,
   797,   793,   302,   796,   800,   801,   802,   132,   784,   758,
   756,   305,   757,    73,   759,   805,   806,   316,   216,   580,
   319,   173,   315,   174,   131,   807,   210,   211,   212,   213,
   214,   130,   215,   251,   347,   327,   809,   810,   178,   170,
    42,   811,   812,   813,   814,    41,    40,   816,    39,    38,
    37,    36,   412,    35,   819,   820,    34,   821,    74,   827,
    33,   760,    87,    32,   828,   829,   830,    31,    30,   831,
    29,    28,    27,    26,    25,    24,    23,   834,   835,   836,
    22,    72,   823,   824,   270,    19,   849,   741,   841,   842,
   840,   838,   839,   843,   844,   684,   822,   792,   845,   734,
   604,   605,   606,   677,   609,   610,   708,   707,   613,   614,
   851,   534,   852,   619,   620,   533,   532,   623,   531,   625,
   626,   627,   530,   629,   630,   631,   632,   633,   529,   527,
   636,   637,   638,   374,   525,   375,   373,   281,   524,   523,
   314,   522,   521,   520,   519,   518,   370,   368,   369,   371,
   372,   148,   149,   150,   151,   152,   153,   154,   517,   516,
   515,   514,   513,   648,   511,   510,   509,   508,   367,   507,
   506,   505,   501,   500,   499,   498,   497,   458,   389,   232,
    66,   376,   388,   329,   354,   282,   686,   166,    13,     9,
   359,     5,    18,   361,     8,     4,   239,   425,   183,   182,
   254,   362,   114,    77,   488,   585,   471,   413,   404,   155,
    88,   712,   713,   125,   146,   147,   715,   716,   717,   718,
   719,    83,   208,   207,   298,   204,   444,   320,   293,   761,
    91,   366,   145,   144,   143,   331,   654,   754,   278,   443,
   459,   762,   763,   392,     0,   739,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   727,   728,   729,
   730,   731,   732,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   798 };
yytabelem yypact[]={

   183, -1000,    79, -1000, -1000,   137, -1000, -1000, -1000,   113,
    23,    22,   -16,    60,    16,    13, -1000, -1000,   183, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000,  -349,    15,  -200, -1000,  -337,
  -283,  -347,  -155,  -338,  -234,  -235,  -205,  -370,   219,  -340,
  -244,  -245, -1000,  -191,  -192, -1000,   227, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000,    29, -1000,  -255,    39, -1000, -1000,
 -1000,  -310, -1000,    19, -1000, -1000, -1000,   619,  -233,  -341,
 -1000,  -258, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000,    33,  -259,    70,    69,  -323,   178, -1000,
  -260,  -262, -1000,   219, -1000,  -265, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000,  -209,  -366, -1000,
    41,    19, -1000, -1000, -1000, -1000,  -106,  -106, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000,  -263, -1000, -1000, -1000,   219,
  -266,  -270,  -271, -1000, -1000,  -272,    56,  -112, -1000,   -16,
   454,  -257, -1000, -1000, -1000, -1000, -1000,   320,   319,   176,
  -274, -1000, -1000,   618,  -389, -1000, -1000, -1000, -1000, -1000,
  -344, -1000,  -278,  -279,   175, -1000, -1000, -1000,  -282, -1000,
  -204,  -204,  -232,   172,  -209,  -371,   219,    19,   464, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000,   318, -1000, -1000,
 -1000, -1000,   304, -1000, -1000,  -284,    62, -1000, -1000, -1000,
 -1000, -1000,   214, -1000, -1000,   173,   610,   599,  -390,   543,
   576,   554, -1000, -1000, -1000,     9,  -324, -1000, -1000, -1000,
   341,   454,  -252, -1000,  -257,  -289, -1000, -1000, -1000, -1000,
  -212,    30,  -212,    19,   172, -1000, -1000,  -232, -1000, -1000,
  -290,    41, -1000,   265, -1000,   503, -1000,   495,  -257, -1000,
   -18, -1000, -1000,  -112, -1000, -1000, -1000, -1000,   317, -1000,
   440,   528,   451,  -291,   164,   163, -1000,   162,   538, -1000,
 -1000,  -325,   528, -1000, -1000,  -292, -1000,    19, -1000,   534,
 -1000,   161,   528,    19,  -296, -1000,    19,   -75, -1000, -1000,
   589, -1000, -1000,   373,   290,   373,   284,  -297, -1000,    53,
   196,   568,  -112,   528,   528,  -393, -1000,   575,   484, -1000,
   -64,   460,   -10, -1000, -1000, -1000, -1000,   320, -1000,   148,
   146,    32,   -23, -1000,  -298,    30,    30,  -326,   145,  -299,
 -1000,  -300,    19,   144,  -304, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000,   596, -1000,   437,  -106,
  -106, -1000, -1000,   436, -1000, -1000, -1000,  -102, -1000,   413,
 -1000, -1000, -1000,   152, -1000, -1000, -1000,   -48,   476, -1000,
   528,   426, -1000, -1000,   528,   528, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000,   -10, -1000, -1000, -1000,    -9, -1000,  -402,
   471, -1000, -1000, -1000, -1000, -1000,   452,   528,   -10,   518,
   374,   319, -1000, -1000, -1000,   528, -1000,   534, -1000,   528,
 -1000, -1000, -1000,   -19,  -381, -1000, -1000,   373, -1000, -1000,
   143,   142,   373, -1000,   373, -1000, -1000, -1000,  -159,   494,
  -124, -1000,  -112, -1000, -1000,   470, -1000,   528,   460,   -23,
    -9,   -10, -1000, -1000, -1000, -1000, -1000,   -10,   718,   370,
   438, -1000,  -254,   528, -1000, -1000,   -23,   128,  -305, -1000,
   116, -1000,   114,   493,   490,   417,   414, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000,    43, -1000, -1000, -1000, -1000,
 -1000,    98, -1000, -1000,    98,   107, -1000, -1000,   219,   219,
    52, -1000, -1000,   219,   589, -1000,   219, -1000, -1000, -1000,
    62, -1000, -1000, -1000, -1000, -1000,   219, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000,  -201, -1000, -1000, -1000, -1000, -1000,
 -1000,   526,   528, -1000, -1000,   583, -1000, -1000, -1000,   473,
 -1000,  -224, -1000, -1000,  -112, -1000, -1000,   106,   103, -1000,
 -1000,   269,   219,   219,   589,   589,   589, -1000, -1000,   589,
   589, -1000, -1000,   589,   589, -1000, -1000, -1000,   589,   589,
   589,  -193, -1000,   589, -1000,   589,   589,   589, -1000, -1000,
 -1000,   589,   589,   589,   219,   219,   589,   589,   219,   219,
   219, -1000, -1000,   456,   528, -1000,   528,   528,   136, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,    37,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
     8,   219,     7,     6, -1000,    61,    61,    60, -1000, -1000,
 -1000,   -40,     4, -1000,   -56, -1000,   589,   589,   589,   589,
   589,   589,   589,   589,   589, -1000, -1000, -1000, -1000,    62,
    62, -1000, -1000,   353, -1000,   -23,   707, -1000, -1000,   589,
   425,   -90,   589,   589,  -112,   589,   589,   589,   589,   589,
 -1000,   219,   -22,   589,   589,   -44,   589, -1000, -1000, -1000,
 -1000, -1000, -1000,   -42,    56, -1000,   589, -1000, -1000,   589,
 -1000,     2, -1000,   589,   589,   589, -1000, -1000, -1000, -1000,
 -1000,   -26,   -28, -1000,   589,   589, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000,   589,   -63, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000,   589,   589, -1000, -1000, -1000,
   589,   589,   589,   589,   -29, -1000,   -34,   -35,    98,    98,
 -1000,    98, -1000, -1000, -1000,   219,   219,   -61,   589, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,   589,   -87,
  -113, -1000, -1000, -1000, -1000, -1000,  -112,   589,   589, -1000,
 -1000, -1000,  -140,   -61,   -61, -1000,   425, -1000,   589,  -112,
  -112, -1000,   589,   589,  -112, -1000, -1000,   589, -1000, -1000,
 -1000,    -8, -1000, -1000, -1000, -1000, -1000,    80, -1000,    -8,
 -1000,  -112, -1000 };
yytabelem yypgo[]={

     0,   983,   980,     5,   977,     8,   976,     3,     7,     2,
     1,    18,     6,   975,   132,    26,   974,     0,    16,   973,
   972,   971,    11,   970,   968,   967,    23,   966,   516,   489,
   497,   965,   616,   964,   281,   963,   962,   488,   961,   953,
   950,   949,   948,   947,   946,   945,   944,   943,   486,   942,
   287,    17,   205,   198,   506,   473,   941,   939,   938,   496,
    13,    25,    49,    44,    15,    22,   484,   937,    12,    14,
    51,   490,   936,    10,   655,   935,   934,   549,   932,   931,
   929,   928,   927,   925,   923,   922,   920,   919,   918,   917,
   916,   915,   914,   913,   912,   911,   910,   909,   907,   906,
   905,   904,   902,   901,   900,   899,   898,   885,   884,   883,
   882,   881,   879,   878,   874,   869,   868,   862,   858,   856,
   855,   851,   301,   847,   846,    28,     9,   843,   839,   837,
   836,     4,   835,   828,   827,   826,   825,   821,   820,   816,
   815,   814,   813,   812,   811,   810,   808,   807,   803,   800,
   796,   793,   791,   790,   789,   788,   786,   785,   780,   753,
   779,   778,   774,   773,   771,   764,   747,   734,   726,   722,
   685,   684,   683,   682,   671,   668,   663,   660,   656 };
yytabelem yyr1[]={

     0,    74,    76,    78,    74,    82,    83,    75,    85,    85,
    79,    79,    80,    80,    80,    81,    81,    81,    11,    11,
    11,    86,    12,    12,    12,    87,    10,    10,    10,    10,
    13,    13,    14,    14,    14,    14,    84,    84,    84,    84,
    89,    88,     1,     1,     2,     2,     2,     2,     2,     2,
     3,    90,    90,    90,    90,    90,    90,    90,    90,    90,
    90,    90,    90,    90,    90,    90,    90,    90,    90,    90,
    90,    90,    90,    90,    90,    90,    90,    90,    90,    90,
    90,    90,    90,    90,    90,    90,    90,    90,    91,    91,
    91,    91,    91,    91,    92,    92,    92,    92,    92,    92,
    92,     4,     4,     4,     4,     4,     4,     4,     4,     5,
     5,     5,     5,     5,     5,     6,     6,     6,     6,     6,
     6,     6,     6,     6,     6,    93,    94,    95,    95,    96,
    96,    97,    98,    98,    99,   126,   126,   100,   127,   101,
   128,   128,   129,   129,   102,   102,   103,   103,   104,   104,
   124,   124,   124,   124,   130,   105,   105,   106,   107,     8,
     8,   132,   133,   108,   134,   135,   109,     9,     9,     9,
   123,     7,     7,     7,     7,     7,     7,     7,     7,     7,
   110,   110,   111,   111,   111,   111,   111,   111,   112,   112,
   112,   113,   114,   115,   116,   116,   116,   117,   117,   117,
   117,   117,   117,   117,   118,   119,   120,   120,   121,    17,
    17,    17,    15,    15,    16,    16,    16,    16,    18,    18,
    19,    19,    19,    19,    19,    19,    20,    20,    20,    21,
    21,    21,    21,    21,    21,    21,    21,    21,    21,    22,
   122,   131,   125,    77,   137,    77,    77,    77,   136,   136,
   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,
   136,   136,   136,   136,   136,   136,   136,   136,   136,   160,
   138,   139,   139,    24,    24,    24,    59,    59,   140,   140,
   141,   141,    47,    47,   161,   162,    48,    50,    50,    50,
    51,    51,    51,   142,    38,    38,    38,    38,   163,   143,
    57,    57,    57,    58,    58,   144,   144,    40,    40,    40,
   145,   145,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,   146,   146,   147,   147,   147,    49,    49,
    49,    49,    49,   148,   148,   148,   149,   149,   150,   151,
    39,    39,    39,    39,    39,   152,   164,   164,   164,   164,
   169,   165,   170,   165,    54,    54,    54,    55,   171,    55,
    55,    53,    53,    52,    52,    52,    52,    26,    26,    26,
   166,   167,    28,    28,    29,    29,    30,    30,    31,    31,
    31,   172,   168,   168,    56,    56,    56,    27,    46,    46,
    35,    35,    36,    36,    36,    37,    37,    37,    37,    37,
    37,   153,    25,    25,    25,    32,    32,    32,   173,    33,
    33,    34,    34,   154,   154,   154,   154,    41,    41,   155,
   156,   157,   157,   157,   157,   158,   158,    60,    60,    61,
    61,    42,    42,    42,    42,    42,    42,    42,    62,    62,
    43,    43,    43,    63,    63,    44,    44,    44,    44,    44,
    64,    64,    65,    65,    65,    65,    65,    65,    65,    65,
    65,    65,    65,    45,    45,    45,   174,    67,   175,    67,
    67,    67,    68,    68,    73,    73,    66,    66,    66,    66,
    71,    71,   176,    72,    72,   177,    72,    72,   178,    70,
    70,    69,    69,   159 };
yytabelem yyr2[]={

     0,     4,     1,     1,    10,     1,     1,    18,     3,     3,
     3,     3,     5,     5,     3,     5,     5,     3,     5,     5,
     3,     3,     5,     5,     3,     3,     7,    11,    11,     1,
     7,     3,     3,     3,     3,     3,     7,     5,     7,     1,
     1,     6,     7,     1,     1,     3,     5,     3,     5,     7,
     3,     2,     2,     2,     2,     3,     3,     3,     2,     2,
     2,     2,     2,     2,     2,     3,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     3,
     2,     3,     2,     2,     2,     2,     2,     2,     9,    11,
    11,     9,     7,     7,    13,    13,     9,     9,    11,    13,
    13,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,    15,    13,    15,    15,     3,
     7,     5,    13,    13,    13,     5,     1,     5,     1,    11,
     3,     1,     3,     1,     7,     7,     5,     5,     5,     7,
     7,    11,     7,    11,     1,    17,    15,    15,    13,     5,
     1,     1,     1,    17,     1,     1,    19,     5,     5,     1,
     9,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     5,     9,     7,     9,    11,     7,     9,    11,     7,     9,
    11,     5,     9,     9,    13,    13,    13,     9,     9,     9,
     7,     7,     7,     7,    13,    13,     3,     7,     9,     3,
     3,     7,     3,     3,    13,    13,    17,    17,     3,     3,
    11,     3,     3,     3,     3,     3,    11,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     9,     3,     3,
     1,     1,     1,     5,     1,     8,     5,     0,     2,     2,
     2,     2,     3,     2,     2,     2,     2,     2,     3,     2,
     2,     3,     2,     2,     2,     2,     2,     3,     3,     1,
    17,    13,     7,     5,     5,     1,     3,     3,     5,     7,
     7,     5,     7,     3,     1,     1,    15,     3,     7,     3,
     3,     7,     3,     9,     3,     3,     3,     1,     1,    15,
     7,     3,     1,     7,     5,     7,    13,     1,     3,     5,
     5,     7,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     7,    11,     7,     9,     9,     3,     5,
     7,     5,     1,     4,     7,     7,     5,     9,     5,     7,
     3,     3,     3,     3,     1,     4,     2,     2,     2,     2,
     1,    13,     1,    13,     3,     5,     1,     3,     1,     7,
     1,     7,     3,     5,     7,     7,    11,     3,     3,     1,
    11,    13,     5,     1,     5,     1,     3,     1,     3,     5,
     1,     1,    17,     9,     5,     9,     1,     3,     5,     1,
     3,     1,     7,     5,     3,     3,     3,     3,     3,     3,
     3,    15,     3,     3,     1,     7,     1,     7,     1,     7,
     3,     3,     7,     7,    13,     9,     5,     1,     3,     5,
    15,     7,     7,     7,     4,     4,     7,     7,     3,     7,
     3,     3,     3,     3,     3,     3,     3,     3,     7,     5,
     3,     3,     3,     7,     3,     3,     3,     3,     3,     3,
     7,     3,     7,     9,     3,     3,     3,     3,     3,     3,
     7,     5,    13,     3,     3,     3,     1,    11,     1,     9,
     7,     5,     7,     3,     3,     7,     9,     7,     5,     3,
     3,     1,     1,    13,    11,     1,     9,     7,     1,     9,
     3,     3,     7,     1 };
yytabelem yychk[]={

 -1000,   -74,   282,   283,   -75,   -79,   309,   256,   -76,   -80,
   284,   256,   -77,   -81,   284,   256,   310,   310,   -78,  -136,
   256,   386,  -138,  -139,  -140,  -141,  -142,  -143,  -144,  -145,
  -146,  -147,  -148,  -149,  -150,  -151,  -152,  -153,  -154,  -155,
  -156,  -157,  -158,   400,   401,   419,   389,   382,   402,   392,
   423,   341,   388,   420,   384,   422,   405,   408,   394,   393,
    35,   312,   383,   418,   421,   -11,   -86,   256,   314,   311,
   311,   -74,  -137,  -159,  -159,   386,   414,   -47,   386,   -48,
   -50,   284,    42,   -38,   403,   404,   284,  -159,   -40,   393,
   386,   -23,   400,   401,   419,   389,   382,   402,   392,   423,
   341,   388,   420,   384,   422,   405,   408,   394,   393,   312,
   383,   418,   421,   399,   -49,   390,   391,   284,   387,   386,
   397,   398,   386,  -125,   386,   -39,   404,   406,   407,   284,
  -164,  -165,  -166,  -167,  -168,   409,   410,   411,   412,   415,
   416,   -15,   -18,   -16,   -19,   -20,   365,   366,   302,   303,
   304,   305,   306,   307,   308,   -41,   395,   386,   386,  -125,
   404,   403,   284,   386,   386,   284,   -82,   -10,   256,   -77,
  -160,   -26,   386,    43,    45,   386,   386,    44,  -161,   387,
   -32,   310,   -57,   -58,    33,   386,   313,   395,   386,   386,
    45,   386,   288,   288,   387,   284,   386,   386,   -15,   386,
  -169,  -170,   -28,   365,   -31,   413,  -122,   -35,   -36,   -37,
   302,   303,   304,   305,   306,   308,   -32,   -14,   360,   361,
   362,   363,   -14,   386,   313,   396,   -15,   386,   386,   386,
   386,   -12,   -87,   256,   315,   -14,   285,   364,   -71,   -72,
    91,   -59,   284,   424,   -48,   -51,   284,    42,   284,   386,
  -173,  -163,    33,   424,  -159,   397,   386,   386,   284,   386,
   -54,   365,   -54,   -29,   366,   -30,   284,   -28,   414,   -15,
   -32,    44,   -37,  -122,    91,   284,    91,   284,  -159,   386,
   -22,   288,   -83,   -10,   256,   284,    40,    40,   -66,   424,
    44,  -177,    42,   -24,    43,    45,   313,   387,   -33,    42,
   -34,   284,   -71,   284,   424,   -59,   386,   -55,   366,   -53,
   -52,   -26,   387,   -55,   -32,   -30,   -29,  -172,   386,   -37,
   -25,    45,   321,  -125,    58,  -125,    58,   -59,   326,   -84,
   -10,   -13,   -10,   296,    91,    46,    94,    91,   -70,   -69,
   -61,   -62,   -26,    93,   386,   284,   284,  -162,   284,    44,
   387,   -60,   -61,   386,   -32,  -171,    44,   284,   -26,   -32,
   386,   -32,   -56,   350,   -17,   -15,   -21,   319,   298,   299,
   297,   300,   301,   287,   284,   286,   332,   -22,   -18,   365,
   366,    91,   284,   -18,    91,   284,   386,   -10,   -85,   -88,
   256,   312,    -1,   284,    41,    41,    44,   -61,   -60,   424,
  -176,    42,    93,    44,   -42,   387,   290,   291,   292,   293,
   294,   295,   354,   -43,    43,    45,   275,   -63,   -64,   -65,
   424,   284,   287,   286,   288,   -67,   -66,    40,   321,   344,
   123,   -50,   -34,   284,   386,    44,   386,   -53,   -52,   387,
   284,   386,   386,   -32,   -27,   284,   386,  -125,    40,    93,
   -14,   -14,  -125,    93,  -125,   386,    59,   256,   -89,    -2,
    33,   363,   -10,   386,    93,   -70,    93,  -178,   -62,   -61,
   -63,   -44,    42,    47,   425,   262,   274,   426,    40,   123,
   -61,   -65,    46,  -175,   125,   -51,   -61,   -26,   -46,   326,
   417,   -18,   -10,   284,   284,   -18,   -18,   -90,   -91,   -92,
   -93,   -94,   317,   318,   359,   -95,   -96,   -97,   -98,   -99,
  -100,  -101,   316,  -102,  -103,  -104,  -105,  -106,  -107,  -108,
  -109,  -110,  -111,  -112,  -113,  -114,   369,  -115,   370,  -116,
  -117,  -118,  -119,  -120,  -121,   -15,   324,   325,   327,   328,
   330,   336,   333,   334,   335,   350,   346,   347,   348,   349,
   351,   352,   355,   356,   341,   343,   337,   338,   340,   339,
   381,   367,   368,   374,   375,   376,   377,   378,   379,   380,
   382,   383,   384,    58,   284,   363,    93,   -69,   -64,   -64,
    41,   -60,  -174,   125,    41,   -45,   424,   274,   275,   -68,
   -73,   -61,   284,   386,   -10,   284,    41,    58,    58,    93,
    93,   296,  -125,  -125,  -122,  -122,  -122,    -3,   284,  -122,
  -122,    -3,   284,  -122,  -122,   -15,   -15,   289,  -125,  -122,
  -122,   -15,   -17,  -122,   -15,  -122,  -122,  -122,   -22,  -122,
  -122,  -122,  -122,  -122,   -15,  -125,  -122,  -122,  -122,  -125,
  -125,   363,    41,   -68,    40,   125,    44,   387,  -122,    45,
   321,   320,   322,   323,    -6,   272,   371,   372,   373,   385,
   273,   263,   264,   265,   266,   267,   268,   269,   270,   271,
   -15,   -15,   -17,   -17,   -17,   -17,   -17,  -127,   -17,   -17,
   -17,   -17,   -17,   357,  -132,   -17,  -122,   -17,   -17,   -17,
  -125,  -125,   -17,   -17,   -17,   -15,   -15,   -17,   -17,   -15,
   -15,   -15,   125,   -61,   -73,   -61,   -17,  -123,  -124,   331,
   344,   358,  -122,  -122,   -10,  -122,  -122,  -122,  -122,  -122,
   289,   313,   -15,   313,   313,  -126,    -5,   290,   291,   292,
   293,   294,   295,  -126,  -128,   -11,   353,   313,   313,  -122,
   342,  -134,   -17,   -17,   -17,   -17,   -17,   -17,   -17,   -17,
   -17,   -22,   -22,    41,    -4,    -5,    43,    45,    42,    47,
    94,   262,   274,   275,   -17,    -7,   274,   275,   276,   277,
   278,   279,   280,   281,    -3,   354,   353,   -17,   -17,   -17,
   -17,   -17,   -17,   -17,   -15,   326,   -17,   -17,   335,   336,
   -17,   335,  -129,   -12,   -17,  -131,  -131,   -17,  -122,   313,
   -17,   -17,   -17,   326,   326,   -17,   -17,   -17,   345,   -17,
   -17,   -17,   -17,   -17,   -17,   326,   -10,   329,   329,    -3,
    -3,    -3,  -130,   -15,   -15,    -8,   344,   -17,  -131,   -10,
   -10,   -17,   353,   354,   -10,   -17,   -17,   354,    -8,    -8,
    -7,  -133,   -17,   -17,   -17,   -17,    -9,   310,   326,  -135,
   284,   -10,    -9 };
yytabelem yydef[]={

     0,    -2,     0,     2,     1,     0,    10,    11,   247,     0,
     0,    14,     3,     0,     0,    17,    12,    13,     0,   243,
   244,   246,   248,   249,   250,   251,   252,   253,   254,   255,
   256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
   266,   267,   268,   503,   503,     0,     0,   297,   503,   307,
     0,     0,   342,     0,   242,     0,   354,     0,     0,   427,
     0,     0,   242,     0,     0,     5,    29,    20,    21,    15,
    16,     4,   247,   269,   379,   278,     0,     0,   281,   283,
   284,   287,   289,   416,   294,   295,   296,   302,     0,   308,
   310,     0,   312,   313,   314,   315,   316,   317,   318,   319,
   320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
   330,   331,   332,     0,     0,     0,     0,   338,     0,   343,
     0,     0,   346,     0,   348,     0,   350,   351,   352,   353,
   355,   356,   357,   358,   359,   360,   362,   383,   390,   240,
   401,   416,   212,   213,   218,   219,     0,     0,   221,   222,
   223,   224,   225,   227,   228,     0,   428,   426,   429,     0,
     0,     0,     0,   434,   435,     0,     0,    18,    19,   245,
   491,     0,   272,   377,   378,   279,   280,     0,     0,     0,
     0,   418,   298,   301,     0,   305,   503,   309,   311,   333,
     0,   335,     0,     0,   339,   341,   344,   345,     0,   349,
   366,   366,   385,   387,   383,   388,     0,   416,   400,   404,
   405,   406,   407,   408,   409,   410,   240,     0,    32,    33,
    34,    35,     0,   423,   503,     0,     0,   431,   432,   433,
   436,     6,    29,    24,    25,     0,     0,     0,     0,   490,
   495,   275,   276,   277,   282,     0,   290,   292,   288,   293,
     0,   491,     0,   304,     0,     0,   336,   337,   340,   347,
   370,    -2,   370,   416,   387,   382,   386,   385,   389,   391,
     0,     0,   403,   414,   242,     0,   242,     0,     0,   425,
     0,   239,    39,    22,    23,    26,    29,    29,     0,   489,
     0,   379,     0,     0,     0,     0,   285,     0,   415,   417,
   420,   421,   379,   300,   303,     0,   334,   416,    -2,   365,
   372,     0,   379,   416,     0,   384,   416,   396,   393,   402,
     0,   412,   413,     0,     0,     0,     0,     0,    29,    43,
     0,     0,    31,   379,   379,     0,   488,   492,     0,   500,
   501,   440,     0,   497,   271,   273,   274,     0,   291,     0,
     0,     0,   438,   306,     0,   379,   379,   373,     0,     0,
   380,     0,   416,     0,     0,   209,   210,   242,   229,   230,
   231,   232,   233,   234,   235,   236,     0,   238,     0,     0,
     0,   242,   220,     0,   242,   226,   424,     0,     7,     0,
    -2,     8,    40,    44,    27,    28,    29,     0,     0,   487,
   379,     0,   496,   498,   379,   379,   441,   442,   443,   444,
   445,   446,   447,     0,   450,   451,   452,   449,   454,   461,
   489,   464,   465,   466,   467,   468,   469,   379,     0,     0,
   478,     0,   419,   422,   299,   379,   361,   369,   371,    -2,
   375,   363,   381,   399,   394,   397,   411,     0,    29,   214,
     0,     0,     0,   215,     0,   430,    36,    38,     0,     0,
    45,    47,    30,   270,   486,     0,   494,   379,   439,   502,
   448,     0,   455,   456,   457,   458,   459,     0,   379,   476,
     0,   471,     0,   379,   481,   286,   437,     0,     0,    29,
     0,   211,     0,     0,     0,     0,     0,    41,    51,    52,
    53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
    63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
    73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
    83,    84,    85,    86,    87,     0,   242,   242,   240,   240,
    -2,     0,   240,   240,     0,     0,   240,   240,     0,     0,
   242,   240,   240,     0,     0,   240,     0,   240,   240,   240,
     0,   240,   240,   240,   240,   240,     0,   242,   240,   240,
   240,   242,    -2,    42,    46,    48,   493,   499,   453,   460,
   462,     0,   379,   480,   470,     0,   473,   474,   475,     0,
   483,   484,   376,   392,   398,   395,   237,     0,     0,   216,
   217,   240,     0,     0,     0,     0,     0,   131,    50,     0,
     0,   137,   138,     0,     0,   146,   147,   148,     0,     0,
     0,     0,   161,     0,    -2,     0,     0,     0,   191,   242,
   242,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,    49,   463,     0,   379,   479,   379,   379,     0,   240,
   240,    29,    92,    93,   240,   240,   240,   240,   240,     0,
   115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     0,     0,     0,     0,   130,   136,   136,   141,   144,   145,
   149,     0,     0,   240,     0,   164,     0,   182,   185,   188,
     0,     0,     0,     0,     0,   200,   201,   202,   203,     0,
     0,   207,   477,     0,   482,   485,    88,    96,    97,     0,
     0,     0,     0,     0,    91,     0,     0,     0,     0,     0,
   208,     0,     0,     0,     0,     0,     0,   109,   110,   111,
   112,   113,   114,     0,   143,   140,     0,   241,   241,     0,
   240,     0,   181,   183,   186,   189,   192,   193,   197,   198,
   199,     0,     0,   472,     0,     0,   101,   102,   103,   104,
   105,   106,   107,   108,     0,     0,   171,   172,   173,   174,
   175,   176,   177,   178,   179,     0,     0,    89,    90,    98,
     0,     0,     0,     0,     0,    29,     0,     0,     0,     0,
   135,     0,   139,   142,   154,     0,     0,   160,     0,   241,
   184,   187,   190,    29,    29,    94,    95,   100,     0,   150,
   152,    99,   194,   195,   196,    29,   126,     0,     0,   132,
   133,   134,     0,   160,   160,   158,     0,   162,     0,   204,
   205,   170,     0,     0,   125,   127,   128,     0,   156,   157,
   159,   169,   165,   151,   153,   155,   163,     0,    29,   169,
   167,   168,   166 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"+",	43,
	"PLUS",	257,
	"-",	45,
	"MINUS",	258,
	"UMINUS",	259,
	"*",	42,
	"MAL",	260,
	"/",	47,
	"DURCH",	261,
	"^",	94,
	"MOD",	262,
	"SQRT",	263,
	"EXP",	264,
	"LN",	265,
	"SIN",	266,
	"COS",	267,
	"TAN",	268,
	"ARCSIN",	269,
	"ARCCOS",	270,
	"ARCTAN",	271,
	"ARCTANT",	272,
	"ABS",	273,
	"AND",	274,
	"OR",	275,
	"FIRST",	276,
	"LAST",	277,
	"SUM",	278,
	"PRODUCT",	279,
	"MAX",	280,
	"MIN",	281,
	"PROGRAMMSTART",	282,
	"KOMMANDOSTART",	283,
	"INTNUM",	284,
	"INTKLAM",	285,
	"REALNUM",	286,
	"CHAR",	287,
	"STRING",	288,
	"BITSTRING",	289,
	";",	59,
	"EQ",	290,
	"NE",	291,
	"LT",	292,
	"LE",	293,
	"GT",	294,
	"GE",	295,
	":",	58,
	"!",	33,
	",",	44,
	"[",	91,
	"]",	93,
	"(",	40,
	")",	41,
	"AOP",	296,
	"NIL",	297,
	"MYTRUE",	298,
	"MYFALSE",	299,
	"TERMS",	300,
	"EOL",	301,
	"MAXTRANS",	302,
	"ACTTRANS",	303,
	"DONE",	304,
	"TERMCH",	305,
	"SRESULT",	306,
	"ID",	307,
	"VRESULT",	308,
	"START",	309,
	"PE",	310,
	"PORTS",	311,
	"STOP",	312,
	"TO",	313,
	"SCALAR",	314,
	"VECTOR",	315,
	"RETURN",	316,
	"HALT",	317,
	"END",	318,
	"ADDR",	319,
	"NEW",	320,
	"NOT",	321,
	"STATUS",	322,
	"RANDOM",	323,
	"MOVE",	324,
	"EQUAL",	325,
	"AS",	326,
	"CONNECT",	327,
	"BICONNECT",	328,
	"AT",	329,
	"DISCONNECT",	330,
	"STRCMP",	331,
	"SIZE",	332,
	"IF",	333,
	"WHILE",	334,
	"CALL",	335,
	"GOTO",	336,
	"READ",	337,
	"WRITE",	338,
	"DRAW",	339,
	"WRITELN",	340,
	"LOAD",	341,
	"WITH",	342,
	"STORE",	343,
	"REDUCE",	344,
	"OF",	345,
	"PUSHS",	346,
	"PUSHV",	347,
	"POPS",	348,
	"POPV",	349,
	"PROC",	350,
	"PARALLEL",	351,
	"PROPAGATE",	352,
	"OUT",	353,
	"IN",	354,
	"SEND",	355,
	"RECEIVE",	356,
	"FROM",	357,
	"CONNECTED",	358,
	"NOP",	359,
	"B",	360,
	"C",	361,
	"I",	362,
	"R",	363,
	"U",	364,
	"S",	365,
	"V",	366,
	"OPENINPUT",	367,
	"OPENOUTPUT",	368,
	"CLOSEINPUT",	369,
	"CLOSEOUTPUT",	370,
	"GETPIXEL",	371,
	"OPENW",	372,
	"OPENABSW",	373,
	"MOVETO",	374,
	"LINETO",	375,
	"SETPIXEL",	376,
	"WSIZE",	377,
	"SETCOLOR",	378,
	"SELECTW",	379,
	"CLOSEW",	380,
	"ERROR",	381,
	"DEBUG",	382,
	"TRACE",	383,
	"NOTRACE",	384,
	"INITSET",	385,
	"#",	35,
	"\\",	92,
	"{",	123,
	"}",	125,
	".",	46,
	"ZEILEND",	386,
	"PP",	387,
	"LIST",	388,
	"CONNECTIONS",	389,
	"PATTERN",	390,
	"STRINGMATCH",	391,
	"GO",	392,
	"STEP",	393,
	"SET",	394,
	"OVER",	395,
	"ALL",	396,
	"COMPILER",	397,
	"INTERPRETER",	398,
	"FILENAME",	399,
	"ASSIGN",	400,
	"BREAKPOINT",	401,
	"EXAMINE",	402,
	"EIN",	403,
	"AUS",	404,
	"RECORD",	405,
	"KURZ",	406,
	"LANG",	407,
	"SHOW",	408,
	"MEMORY",	409,
	"HEAP",	410,
	"PARSTACK",	411,
	"CALLSTACK",	412,
	"CHAIN",	413,
	"ACTIVITY",	414,
	"VARIABLE",	415,
	"SPECIALS",	416,
	"DEPTH",	417,
	"WARN",	418,
	"CALLS",	419,
	"MODE",	420,
	"WIDTH",	421,
	"QUIT",	422,
	"HELP",	423,
	"IDENT",	424,
	"DIV",	425,
	"POWER",	426,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"Anfang : PROGRAMMSTART IntermediateProgram",
	"Anfang : KOMMANDOSTART",
	"Anfang : KOMMANDOSTART KommandoList",
	"Anfang : KOMMANDOSTART KommandoList Anfang",
	"IntermediateProgram : start NumPe NumPorts ControlVarDecl",
	"IntermediateProgram : start NumPe NumPorts ControlVarDecl LocalVarDecl",
	"IntermediateProgram : start NumPe NumPorts ControlVarDecl LocalVarDecl StatementList stop",
	"stop : STOP",
	"stop : error",
	"start : START",
	"start : error",
	"NumPe : INTNUM PE",
	"NumPe : error PE",
	"NumPe : error",
	"NumPorts : INTNUM PORTS",
	"NumPorts : error PORTS",
	"NumPorts : error",
	"ControlVarDecl : scalar declaration",
	"ControlVarDecl : scalar error",
	"ControlVarDecl : error",
	"scalar : SCALAR",
	"LocalVarDecl : vector declaration",
	"LocalVarDecl : vector error",
	"LocalVarDecl : error",
	"vector : VECTOR",
	"declaration : declaration type INTNUM",
	"declaration : declaration INTKLAM '(' declaration ')'",
	"declaration : declaration U '(' UnionList ')'",
	"declaration : /* empty */",
	"UnionList : UnionList ',' declaration",
	"UnionList : declaration",
	"type : B",
	"type : C",
	"type : I",
	"type : R",
	"StatementList : StatementList Statement ';'",
	"StatementList : StatementList error",
	"StatementList : StatementList Statement error",
	"StatementList : /* empty */",
	"Statement : labeldef",
	"Statement : labeldef stat",
	"labeldef : INTNUM labqual ':'",
	"labeldef : /* empty */",
	"labqual : /* empty */",
	"labqual : '!'",
	"labqual : '!' INTNUM",
	"labqual : R",
	"labqual : '!' R",
	"labqual : '!' INTNUM R",
	"label : INTNUM",
	"stat : assignment",
	"stat : computation",
	"stat : movestat",
	"stat : equalstat",
	"stat : HALT",
	"stat : END",
	"stat : NOP",
	"stat : connect",
	"stat : disconnect",
	"stat : gotostat",
	"stat : ifstat",
	"stat : whilestat",
	"stat : callstat",
	"stat : proc",
	"stat : RETURN",
	"stat : pushstat",
	"stat : popstat",
	"stat : parallel",
	"stat : propagate",
	"stat : send",
	"stat : receive",
	"stat : load",
	"stat : store",
	"stat : read",
	"stat : write",
	"stat : draw",
	"stat : errorcall",
	"stat : openinput",
	"stat : CLOSEINPUT",
	"stat : openoutput",
	"stat : CLOSEOUTPUT",
	"stat : GraphFunc",
	"stat : GraphProc",
	"stat : debug",
	"stat : trace",
	"stat : notrace",
	"stat : initset",
	"assignment : vardesc AOP les VarConst",
	"assignment : vardesc AOP '-' les VarConst",
	"assignment : vardesc AOP NOT les VarConst",
	"assignment : vardesc AOP NEW declaration",
	"assignment : vardesc AOP STATUS",
	"assignment : vardesc AOP RANDOM",
	"computation : vardesc AOP les VarConst ArithOperator VarConst",
	"computation : vardesc AOP les VarConst RelOperator VarConst",
	"computation : vardesc AOP les reduce",
	"computation : vardesc AOP les connected",
	"computation : vardesc AOP func les VarConst",
	"computation : vardesc AOP ARCTANT les VarConst VarConst",
	"computation : vardesc AOP les STRCMP VarConst VarConst",
	"ArithOperator : '+'",
	"ArithOperator : '-'",
	"ArithOperator : '*'",
	"ArithOperator : '/'",
	"ArithOperator : '^'",
	"ArithOperator : MOD",
	"ArithOperator : AND",
	"ArithOperator : OR",
	"RelOperator : EQ",
	"RelOperator : NE",
	"RelOperator : LT",
	"RelOperator : LE",
	"RelOperator : GT",
	"RelOperator : GE",
	"func : ABS",
	"func : SQRT",
	"func : EXP",
	"func : LN",
	"func : SIN",
	"func : COS",
	"func : TAN",
	"func : ARCSIN",
	"func : ARCCOS",
	"func : ARCTAN",
	"movestat : MOVE nsp vardesc TO vardesc AS declaration",
	"equalstat : EQUAL nsp vardesc vardesc AS declaration",
	"connect : CONNECT les VarConst TO VarConst AT VarConst",
	"connect : BICONNECT les VarConst TO VarConst AT VarConst",
	"disconnect : DISCONNECT",
	"disconnect : DISCONNECT les VarConst",
	"gotostat : GOTO label",
	"ifstat : IF les VarConst OptRel CALL label",
	"ifstat : IF les VarConst OptRel GOTO label",
	"whilestat : WHILE les VarConst OptRel CALL label",
	"OptRel : RelOperator VarConst",
	"OptRel : /* empty */",
	"callstat : CALL label",
	"proc : PROC INTNUM",
	"proc : PROC INTNUM OptControlVarDecl OptLocalVarDecl",
	"OptControlVarDecl : ControlVarDecl",
	"OptControlVarDecl : /* empty */",
	"OptLocalVarDecl : LocalVarDecl",
	"OptLocalVarDecl : /* empty */",
	"pushstat : PUSHS les VarConst",
	"pushstat : PUSHV les VarConst",
	"popstat : POPS vardesc",
	"popstat : POPV vardesc",
	"parallel : PARALLEL BITSTRING",
	"parallel : PARALLEL nsp VarConst",
	"connected : CONNECTED IN VarConst",
	"connected : CONNECTED IN VarConst OUT VarConst",
	"connected : CONNECTED OUT VarConst",
	"connected : CONNECTED OUT VarConst IN VarConst",
	"propagate : PROPAGATE les VarConst OUT VarConst",
	"propagate : PROPAGATE les VarConst OUT VarConst IN VarConst",
	"propagate : PROPAGATE les VarConst TO schreib vardesc OptReduce",
	"send : SEND les VarConst TO schreib vardesc OptReduce",
	"receive : RECEIVE vardesc FROM les VarConst OptReduce",
	"OptReduce : REDUCE Qual",
	"OptReduce : /* empty */",
	"load : LOAD VarConst",
	"load : LOAD VarConst WITH les VarConst",
	"load : LOAD VarConst WITH les VarConst OptPeOrDecl",
	"store : STORE les VarConst",
	"store : STORE les VarConst TO schreib VarConst",
	"store : STORE les VarConst TO schreib VarConst OptPeOrDecl",
	"OptPeOrDecl : PE INTNUM",
	"OptPeOrDecl : AS declaration",
	"OptPeOrDecl : /* empty */",
	"reduce : REDUCE Qual OF VarConst",
	"Qual : AND",
	"Qual : OR",
	"Qual : FIRST",
	"Qual : LAST",
	"Qual : SUM",
	"Qual : PRODUCT",
	"Qual : MAX",
	"Qual : MIN",
	"Qual : label",
	"read : READ vardesc",
	"read : READ vardesc les VarConst",
	"write : WRITE les VarConst",
	"write : WRITE les VarConst VarConst",
	"write : WRITE les VarConst VarConst VarConst",
	"write : WRITELN les VarConst",
	"write : WRITELN les VarConst VarConst",
	"write : WRITELN les VarConst VarConst VarConst",
	"draw : DRAW les VarConst",
	"draw : DRAW les VarConst VarConst",
	"draw : DRAW les VarConst VarConst VarConst",
	"errorcall : ERROR string",
	"openinput : OPENINPUT les nsp VarConst",
	"openoutput : OPENOUTPUT les nsp VarConst",
	"GraphFunc : vardesc AOP GETPIXEL les VarConst VarConst",
	"GraphFunc : vardesc AOP OPENW les VarConst VarConst",
	"GraphFunc : vardesc AOP OPENABSW les VarConst VarConst",
	"GraphProc : MOVETO les VarConst VarConst",
	"GraphProc : LINETO les VarConst VarConst",
	"GraphProc : SETPIXEL les VarConst VarConst",
	"GraphProc : WSIZE vardesc vardesc",
	"GraphProc : SETCOLOR nsp vardesc",
	"GraphProc : SELECTW les VarConst",
	"GraphProc : CLOSEW les VarConst",
	"debug : DEBUG les vardesc string AS declaration",
	"trace : TRACE nsp vardesc string AS declaration",
	"notrace : NOTRACE",
	"notrace : NOTRACE nsp vardesc",
	"initset : vardesc AOP INITSET BITSTRING",
	"VarConst : vardesc",
	"VarConst : constant",
	"VarConst : ADDR nsp variable",
	"vardesc : variable",
	"vardesc : indirect",
	"indirect : S type '[' nsp variable ']'",
	"indirect : V type '[' nsp variable ']'",
	"indirect : S type INTNUM ':' '[' nsp variable ']'",
	"indirect : V type INTNUM ':' '[' nsp variable ']'",
	"variable : SkaVar",
	"variable : VekVar",
	"SkaVar : S type INTNUM ':' INTNUM",
	"SkaVar : MAXTRANS",
	"SkaVar : ACTTRANS",
	"SkaVar : DONE",
	"SkaVar : TERMCH",
	"SkaVar : SRESULT",
	"VekVar : V type INTNUM ':' INTNUM",
	"VekVar : ID",
	"VekVar : VRESULT",
	"constant : MYTRUE",
	"constant : MYFALSE",
	"constant : NIL",
	"constant : TERMS",
	"constant : EOL",
	"constant : CHAR",
	"constant : INTNUM",
	"constant : REALNUM",
	"constant : SIZE '(' declaration ')'",
	"constant : string",
	"string : STRING",
	"les : /* empty */",
	"schreib : /* empty */",
	"nsp : /* empty */",
	"KommandoList : KommandoList Kommando",
	"KommandoList : KommandoList error",
	"KommandoList : KommandoList error KommandoList",
	"KommandoList : KommandoList ZEILEND",
	"KommandoList : /* empty */",
	"Kommando : AssignKomm",
	"Kommando : BreakpointKomm",
	"Kommando : CallsKomm",
	"Kommando : ConnectionsKomm",
	"Kommando : DebugKomm",
	"Kommando : ExamineKomm",
	"Kommando : GoKomm",
	"Kommando : HelpKomm",
	"Kommando : LoadKomm",
	"Kommando : ListKomm",
	"Kommando : ModeKomm",
	"Kommando : NotraceKomm",
	"Kommando : QuitKomm",
	"Kommando : RecordKomm",
	"Kommando : ShowKomm",
	"Kommando : SetKomm",
	"Kommando : StepKomm",
	"Kommando : StopKomm",
	"Kommando : TraceKomm",
	"Kommando : WarnKomm",
	"Kommando : WidthKomm",
	"AssignKomm : ASSIGN para_on",
	"AssignKomm : ASSIGN para_on selection designator AOP expr ZEILEND",
	"BreakpointKomm : BREAKPOINT para_on sign zeile offset ZEILEND",
	"BreakpointKomm : BREAKPOINT para_on ZEILEND",
	"offset : '+' INTNUM",
	"offset : '-' INTNUM",
	"offset : /* empty */",
	"zeile : INTNUM",
	"zeile : IDENT",
	"CallsKomm : CALLS ZEILEND",
	"CallsKomm : CALLS ACTIVITY ZEILEND",
	"ConnectionsKomm : CONNECTIONS conlist ZEILEND",
	"ConnectionsKomm : CONNECTIONS ZEILEND",
	"conlist : conlist ',' conpat",
	"conlist : conpat",
	"conpat : extpenum",
	"conpat : extpenum extportnum TO",
	"conpat : extpenum extportnum TO extpenum extportnum",
	"extpenum : INTNUM",
	"extpenum : INTNUM PP INTNUM",
	"extpenum : '*'",
	"extportnum : INTNUM",
	"extportnum : INTNUM PP INTNUM",
	"extportnum : '*'",
	"DebugKomm : DEBUG debopt OptPeList ZEILEND",
	"debopt : EIN",
	"debopt : AUS",
	"debopt : INTNUM",
	"debopt : /* empty */",
	"ExamineKomm : EXAMINE para_on OptExProc",
	"ExamineKomm : EXAMINE para_on OptExProc selection ExprList ZEILEND",
	"OptExProc : ProcIdList '!' INTNUM",
	"OptExProc : ProcIdList",
	"OptExProc : /* empty */",
	"ProcIdList : ProcIdList '!' IDENT",
	"ProcIdList : '!' IDENT",
	"GoKomm : GO OptGoStep ZEILEND",
	"GoKomm : GO OptGoStep TO para_on zeile ZEILEND",
	"OptGoStep : /* empty */",
	"OptGoStep : STEP",
	"OptGoStep : STEP OVER",
	"HelpKomm : HELP ZEILEND",
	"HelpKomm : HELP KommName ZEILEND",
	"KommName : ASSIGN",
	"KommName : BREAKPOINT",
	"KommName : CALLS",
	"KommName : CONNECTIONS",
	"KommName : DEBUG",
	"KommName : EXAMINE",
	"KommName : GO",
	"KommName : HELP",
	"KommName : LOAD",
	"KommName : LIST",
	"KommName : MODE",
	"KommName : NOTRACE",
	"KommName : QUIT",
	"KommName : RECORD",
	"KommName : SHOW",
	"KommName : SET",
	"KommName : STEP",
	"KommName : STOP",
	"KommName : TRACE",
	"KommName : WARN",
	"KommName : WIDTH",
	"LoadKomm : LOAD FILENAME ZEILEND",
	"LoadKomm : LOAD FILENAME '-' COMPILER ZEILEND",
	"ListKomm : LIST range ZEILEND",
	"ListKomm : LIST PATTERN STRING ZEILEND",
	"ListKomm : LIST STRINGMATCH STRING ZEILEND",
	"range : INTNUM",
	"range : INTNUM PP",
	"range : INTNUM PP INTNUM",
	"range : PP INTNUM",
	"range : /* empty */",
	"ModeKomm : MODE ZEILEND",
	"ModeKomm : MODE COMPILER ZEILEND",
	"ModeKomm : MODE INTERPRETER ZEILEND",
	"NotraceKomm : NOTRACE ZEILEND",
	"NotraceKomm : NOTRACE nsp vardesc ZEILEND",
	"QuitKomm : QUIT ZEILEND",
	"RecordKomm : RECORD protmod ZEILEND",
	"protmod : AUS",
	"protmod : KURZ",
	"protmod : LANG",
	"protmod : INTNUM",
	"protmod : /* empty */",
	"ShowKomm : SHOW showwhat",
	"showwhat : memoryshow",
	"showwhat : paramstackshow",
	"showwhat : callstackshow",
	"showwhat : variableshow",
	"memoryshow : MEMORY",
	"memoryshow : MEMORY scalmemdecl vecmemdecl OptPeList ZEILEND",
	"memoryshow : HEAP",
	"memoryshow : HEAP scalmemdecl vecmemdecl OptPeList ZEILEND",
	"scalmemdecl : S",
	"scalmemdecl : S addrlist",
	"scalmemdecl : /* empty */",
	"vecmemdecl : V",
	"vecmemdecl : V",
	"vecmemdecl : V addrlist",
	"vecmemdecl : /* empty */",
	"addrlist : addrlist ',' memel",
	"addrlist : memel",
	"memel : sign INTNUM",
	"memel : sign INTNUM PP",
	"memel : PP sign INTNUM",
	"memel : sign INTNUM PP sign INTNUM",
	"sign : '+'",
	"sign : '-'",
	"sign : /* empty */",
	"paramstackshow : PARSTACK scalstack vecstack OptPeList ZEILEND",
	"callstackshow : CALLSTACK asoptions scalstack vecstack OptPeList ZEILEND",
	"scalstack : S OptTiefe",
	"scalstack : /* empty */",
	"vecstack : V OptTiefe",
	"vecstack : /* empty */",
	"OptTiefe : INTNUM",
	"OptTiefe : /* empty */",
	"asoptions : CHAIN",
	"asoptions : CHAIN ACTIVITY",
	"asoptions : /* empty */",
	"variableshow : VARIABLE les vardesc",
	"variableshow : VARIABLE les vardesc OptProc OptPeList OptDecl ZEILEND",
	"variableshow : SPECIALS OptSpezList OptPeList ZEILEND",
	"OptProc : PROC komlabel",
	"OptProc : PROC komlabel DEPTH INTNUM",
	"OptProc : /* empty */",
	"komlabel : INTNUM",
	"OptDecl : AS declaration",
	"OptDecl : /* empty */",
	"OptSpezList : spezlist",
	"OptSpezList : /* empty */",
	"spezlist : spezlist ',' spezvar",
	"spezlist : spezlist spezvar",
	"spezlist : spezvar",
	"spezvar : MAXTRANS",
	"spezvar : ACTTRANS",
	"spezvar : DONE",
	"spezvar : TERMCH",
	"spezvar : SRESULT",
	"spezvar : VRESULT",
	"SetKomm : SET vardesc OptPeList les setsign VarConst ZEILEND",
	"setsign : '-'",
	"setsign : NOT",
	"setsign : /* empty */",
	"OptPeList : PE pelistinit pelist",
	"OptPeList : /* empty */",
	"OptPeList : PE pelistinit '*'",
	"pelistinit : /* empty */",
	"pelist : pelist ',' peel",
	"pelist : peel",
	"peel : INTNUM",
	"peel : INTNUM PP INTNUM",
	"StepKomm : STEP OptOver ZEILEND",
	"StepKomm : STEP OptOver TO para_on zeile ZEILEND",
	"StepKomm : STEP OptOver ALL ZEILEND",
	"StepKomm : '#' ZEILEND",
	"OptOver : /* empty */",
	"OptOver : OVER",
	"StopKomm : STOP ZEILEND",
	"TraceKomm : TRACE nsp vardesc string AS declaration ZEILEND",
	"WarnKomm : WARN AUS ZEILEND",
	"WarnKomm : WARN EIN ZEILEND",
	"WarnKomm : WARN INTNUM ZEILEND",
	"WarnKomm : WARN ZEILEND",
	"WidthKomm : WIDTH ZEILEND",
	"WidthKomm : WIDTH INTNUM ZEILEND",
	"ExprList : ExprList ',' expr",
	"ExprList : expr",
	"expr : expr relation SimpleExpr",
	"expr : SimpleExpr",
	"relation : EQ",
	"relation : NE",
	"relation : LT",
	"relation : LE",
	"relation : GT",
	"relation : GE",
	"relation : IN",
	"SimpleExpr : SimpleExpr AddOperator term",
	"SimpleExpr : sign term",
	"AddOperator : '+'",
	"AddOperator : '-'",
	"AddOperator : OR",
	"term : term MulOperator power",
	"term : power",
	"MulOperator : '*'",
	"MulOperator : '/'",
	"MulOperator : DIV",
	"MulOperator : MOD",
	"MulOperator : AND",
	"power : factor POWER power",
	"power : factor",
	"factor : IDENT '(' ')'",
	"factor : IDENT '(' ExprList ')'",
	"factor : INTNUM",
	"factor : CHAR",
	"factor : REALNUM",
	"factor : STRING",
	"factor : set",
	"factor : designator",
	"factor : '(' expr ')'",
	"factor : NOT factor",
	"factor : REDUCE '.' OperatorIdent '(' expr ')'",
	"OperatorIdent : IDENT",
	"OperatorIdent : AND",
	"OperatorIdent : OR",
	"set : IDENT '{'",
	"set : IDENT '{' SetSubranges '}'",
	"set : '{'",
	"set : '{' SetSubranges '}'",
	"set : IDENT '{' '}'",
	"set : '{' '}'",
	"SetSubranges : SetSubranges ',' SetSubrange",
	"SetSubranges : SetSubrange",
	"SetSubrange : expr",
	"SetSubrange : expr PP expr",
	"designator : designator '[' ExprList ']'",
	"designator : designator '.' IDENT",
	"designator : designator '^'",
	"designator : IDENT",
	"selection : selections",
	"selection : /* empty */",
	"selections : selections ',' '['",
	"selections : selections ',' '[' SelectSubranges ']'",
	"selections : selections ',' '[' '*' ']'",
	"selections : '['",
	"selections : '[' SelectSubranges ']'",
	"selections : '[' '*' ']'",
	"SelectSubranges : SelectSubranges ','",
	"SelectSubranges : SelectSubranges ',' SelectSubrange",
	"SelectSubranges : SelectSubrange",
	"SelectSubrange : expr",
	"SelectSubrange : expr PP expr",
	"para_on : /* empty */",
};
#endif /* YYDEBUG */
/* @(#)yaccpar	1.3  com/cmd/lang/yacc,3.1,9021 9/7/89 18:46:37 */
/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#ifdef YYSPLIT
#   define YYERROR	return(-2)
#else
#   define YYERROR	goto yyerrlab
#endif

#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

#ifdef YYSPLIT
#   define YYSCODE { \
			extern int (*yyf[])(); \
			register int yyret; \
			if (yyf[yytmp]) \
			    if ((yyret=(*yyf[yytmp])()) == -2) \
				    goto yyerrlab; \
				else if (yyret>=0) return(yyret); \
		   }
#endif

/*
** global variables used by the parser
*/
YYSTYPE yyv[ YYMAXDEPTH ];	/* value stack */
int yys[ YYMAXDEPTH ];		/* state stack */

YYSTYPE *yypv;			/* top of value stack */
YYSTYPE *yypvt;			/* top of value stack for $vars */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */

extern int yyparse2();

/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ YYMAXDEPTH ] )	/* room on stack? */
		{
			yyerror( "yacc stack overflow" );
			YYABORT;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				if((yy_n=yypact[yystate])>YYFLAG&&yy_n<YYLAST){int x;for(x=yy_n>0?yy_n:0;x<YYLAST;++x)if(yychk[yyact[x]]==x-yy_n&&x-yy_n!=YYERRCODE)yyerror(NULL,yydisplay(x-yy_n));}yyerror(NULL,NULL);
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/

		switch(yytmp){

case 2:
# line 333 "parz.y"
{ show_prompt(); } /*NOTREACHED*/ break;
case 3:
# line 335 "parz.y"
{ komerr(texte[172]);
                  ueberlies_zeile();
                  yyerrok; yyclearin;
                  unputc('$'); parse_start = 2;
                } /*NOTREACHED*/ break;
case 5:
# line 346 "parz.y"
{ flags = SCALAR_DA;
                                  glob_s_decl = yypvt[-0].decl_def;
                                } /*NOTREACHED*/ break;
case 6:
# line 350 "parz.y"
{ flags = VECTOR_DA;
                                  glob_v_decl = yypvt[-0].decl_def;
                                } /*NOTREACHED*/ break;
case 8:
# line 357 "parz.y"
{ yyerrok;
                  flags = STOP_DA;
                  end_test();
                } /*NOTREACHED*/ break;
case 9:
# line 362 "parz.y"
{ fehler(texte[8]);
                  flags = STOP_DA;
                  end_test();
                } /*NOTREACHED*/ break;
case 10:
# line 368 "parz.y"
{ yyerrok;
                  flags = START_DA;
                } /*NOTREACHED*/ break;
case 11:
# line 372 "parz.y"
{ switch (flags)
                  { case STOP_DA :
                      warning(texte[9]);
                      return 0;
                    default :
                      if (!uebersetzen)
                      { fehler(texte[10]); }
                  }
                } /*NOTREACHED*/ break;
case 12:
# line 383 "parz.y"
{ yyerrok;
                  pe_anz = (int)yypvt[-1].int_val;
                  flags = PE_DA;
                } /*NOTREACHED*/ break;
case 13:
# line 388 "parz.y"
{ yyerrok;
                  pe_anz = 0;
                  fehler(texte[11]);
                  flags = PE_DA;
                } /*NOTREACHED*/ break;
case 14:
# line 394 "parz.y"
{ fehler(texte[12]);
                  pe_anz = 0;
                } /*NOTREACHED*/ break;
case 15:
# line 399 "parz.y"
{ yyerrok;
                      port_anz = (int)yypvt[-1].int_val;
                      create_pes();
                      if (abbruch) return 1;
                      flags = PORTS_DA;
                    } /*NOTREACHED*/ break;
case 16:
# line 406 "parz.y"
{ yyerrok;
                      port_anz = 0;
                      fehler(texte[13]);
                      flags = PORTS_DA;
                    } /*NOTREACHED*/ break;
case 17:
# line 412 "parz.y"
{ fehler(texte[14]);
                      port_anz = 0;
                    } /*NOTREACHED*/ break;
case 18:
# line 417 "parz.y"
{ yyval.decl_def = yypvt[-0].decl_def; } /*NOTREACHED*/ break;
case 19:
# line 419 "parz.y"
{ null_dlist(&yyval.decl_def);
                          fehler(texte[16]);
                        } /*NOTREACHED*/ break;
case 20:
# line 423 "parz.y"
{ null_dlist(&yyval.decl_def);
                          fehler(texte[17]);
                        } /*NOTREACHED*/ break;
case 21:
# line 428 "parz.y"
{ yyerrok; } /*NOTREACHED*/ break;
case 22:
# line 431 "parz.y"
{ yyval.decl_def = yypvt[-0].decl_def; } /*NOTREACHED*/ break;
case 23:
# line 433 "parz.y"
{ null_dlist(&yyval.decl_def);
                          fehler(texte[18]);
                        } /*NOTREACHED*/ break;
case 24:
# line 437 "parz.y"
{ null_dlist(&yyval.decl_def);
                          fehler(texte[19]);
                        } /*NOTREACHED*/ break;
case 25:
# line 442 "parz.y"
{ yyerrok; } /*NOTREACHED*/ break;
case 26:
# line 445 "parz.y"
{ DECL *neu;

                      yyval.decl_def = yypvt[-2].decl_def;
                      if (yypvt[-0].int_val)
                      { yyval.decl_def.typ_zahl[yypvt[-1].typ_def] += (int)yypvt[-0].int_val;
                        yyval.decl_def.typ_zahl[SUMM] += (int)yypvt[-0].int_val;
                        neu = neu_decl(&yyval.decl_def,FELD);
                        if (abbruch) return 1;
                        DECL_t(*neu) = yypvt[-1].typ_def;
                        DECL_zahl(*neu) = (int)yypvt[-0].int_val;
                      }
                    } /*NOTREACHED*/ break;
case 27:
# line 458 "parz.y"
{ DECL *neu;
                      register TYP t;

                      yyval.decl_def = yypvt[-4].decl_def;
                      if (yypvt[-3].int_val && yypvt[-1].decl_def.darray)
                      { for (t=BOOL; t<=SUMM; t++)
                        { yyval.decl_def.typ_zahl[t] += (int)yypvt[-3].int_val * yypvt[-1].decl_def.typ_zahl[t];
                        }
                        neu = neu_decl(&yyval.decl_def,KLAM);
                        if (abbruch) return 1;
                        DECL_wiederh(*neu) = (int)yypvt[-3].int_val;
                        DECL_klamdecl(*neu) = yypvt[-1].decl_def;
                      }
                      else if (yypvt[-1].decl_def.darray)
                      { loesch_decl(&yypvt[-1].decl_def); }
                    } /*NOTREACHED*/ break;
case 28:
# line 475 "parz.y"
{ DECL *neu;
                      register TYP t;

                      yyval.decl_def = yypvt[-4].decl_def;
                      for (t=BOOL; t<=SUMM; t++)
                      { yyval.decl_def.typ_zahl[t] += yypvt[-1].union_def.utyp_anz[t];
                      }
                      neu = neu_decl(&yyval.decl_def,UNION);
                      if (abbruch) return 1;
                      DECL_ul(*neu) = yypvt[-1].union_def;
                    } /*NOTREACHED*/ break;
case 29:
# line 487 "parz.y"
{ null_dlist(&yyval.decl_def);
                    } /*NOTREACHED*/ break;
case 30:
# line 491 "parz.y"
{ yyval.union_def = yypvt[-2].union_def;
                      neu_ulist(&yyval.union_def, &yypvt[-0].decl_def);
                      if (abbruch) return 1;
                    } /*NOTREACHED*/ break;
case 31:
# line 496 "parz.y"
{ register TYP t;

                      null_ulist(&yyval.union_def);
                      neu_ulist(&yyval.union_def, &yypvt[-0].decl_def);
                      if (abbruch) return 1;
                    } /*NOTREACHED*/ break;
case 32:
# line 503 "parz.y"
{ yyval.typ_def = BOOL; } /*NOTREACHED*/ break;
case 33:
# line 504 "parz.y"
{ yyval.typ_def = CHA; } /*NOTREACHED*/ break;
case 34:
# line 505 "parz.y"
{ yyval.typ_def = INT; } /*NOTREACHED*/ break;
case 35:
# line 506 "parz.y"
{ yyval.typ_def = REAL; } /*NOTREACHED*/ break;
case 36:
# line 509 "parz.y"
{ yyerrok; ausgeben = TRUE;
                          STAT_comm_text(*stat_ptr) = yypvt[-0].comment;
                          nextstat();
                          if (abbruch) return 1;
                        } /*NOTREACHED*/ break;
case 37:
# line 515 "parz.y"
{ funcs(do_falsch, print_falsch);
                          if (STAT_comm_text(*stat_ptr) = lies_comm())
                          { yyerrok; yyclearin;
                            if (!*STAT_comm_text(*stat_ptr))
                            { STAT_comm_text(*stat_ptr) = NULL; }
                          }
                          fehler(texte[20]);
                          nextstat();
                          if (abbruch) return 1;
                        } /*NOTREACHED*/ break;
case 38:
# line 526 "parz.y"
{ if (STAT_comm_text(*stat_ptr) = lies_zend())
                          { yyclearin; yyerrok;
                            if (!*STAT_comm_text(*stat_ptr))
                            { STAT_comm_text(*stat_ptr) = NULL; }
                          }
                          fehler_zahl++;
                          nextstat();
                          if (abbruch) return 1;
                        } /*NOTREACHED*/ break;
case 39:
# line 536 "parz.y"
{ init_prog();
                          if (abbruch) return 1;
                        } /*NOTREACHED*/ break;
case 40:
# line 541 "parz.y"
{ STAT_label(*stat_ptr) = (int)yypvt[-0].int_val;
                      if ((int)yypvt[-0].int_val > 0)
                      { if ((int)yypvt[-0].int_val <= last_label)
                        { sem_warning(texte[22]); }
                        last_label = (int)yypvt[-0].int_val;
                      }
                      if ((int)yypvt[-0].int_val > max_label) max_label = (int)yypvt[-0].int_val;
                      lesend = nospez = FALSE;
                    } /*NOTREACHED*/ break;
case 42:
# line 553 "parz.y"
{ yyerrok;
                      yyval.int_val = yypvt[-2].int_val;
                      STAT_bpoint(*stat_ptr) = (int)yypvt[-1].int_val;
                      if (yyval.int_val < 1l)
                      { sem_error(texte[23]); fehler_zahl++;
                      }
                    } /*NOTREACHED*/ break;
case 43:
# line 561 "parz.y"
{ yyval.int_val = -1l;
                      STAT_bpoint(*stat_ptr) = 0;
                    } /*NOTREACHED*/ break;
case 44:
# line 565 "parz.y"
{ yyval.int_val = 0l; } /*NOTREACHED*/ break;
case 45:
# line 566 "parz.y"
{ yyval.int_val = (long)COMP_BREAK;
                                  STAT_para_zeile(*stat_ptr) = 0;
                                } /*NOTREACHED*/ break;
case 46:
# line 569 "parz.y"
{ yyval.int_val = (long)COMP_BREAK;
                                  if (yypvt[-0].int_val > (long)max_source_zeile) max_source_zeile = (int)yypvt[-0].int_val;
                                  STAT_para_zeile(*stat_ptr) = (int)yypvt[-0].int_val;
                                } /*NOTREACHED*/ break;
case 47:
# line 573 "parz.y"
{ yyval.int_val = (long)PROT_ON; } /*NOTREACHED*/ break;
case 48:
# line 574 "parz.y"
{ yyval.int_val = (long)(COMP_BREAK | PROT_ON);
                                  STAT_para_zeile(*stat_ptr) = 0;
                                } /*NOTREACHED*/ break;
case 49:
# line 577 "parz.y"
{ yyval.int_val = (long)(COMP_BREAK | PROT_ON);
                                  if (yypvt[-1].int_val > (long)max_source_zeile) max_source_zeile = (int)yypvt[-1].int_val;
                                  STAT_para_zeile(*stat_ptr) = (int)yypvt[-1].int_val;
                                } /*NOTREACHED*/ break;
case 50:
# line 583 "parz.y"
{ yyval.int_val = yypvt[-0].int_val;
                  if ((int)yyval.int_val < 1)
                  { error(texte[23]); fehler_zahl++;
                  }
                } /*NOTREACHED*/ break;
case 55:
# line 594 "parz.y"
{ funcs(do_halt, print_halt);
                } /*NOTREACHED*/ break;
case 56:
# line 597 "parz.y"
{ funcs(do_end, print_end);
                  if (nach_end != stat_anz)
                  { sem_error(texte[26]);
                    fehler(texte[27]);
                    STAT_falsch(*(stat_ptr - nach_end - 1)) = TRUE;
                  }
                  nach_end = -1;
                } /*NOTREACHED*/ break;
case 57:
# line 606 "parz.y"
{ funcs(do_nop, print_nop);
                } /*NOTREACHED*/ break;
case 65:
# line 616 "parz.y"
{ funcs(do_return, print_return);
                } /*NOTREACHED*/ break;
case 79:
# line 632 "parz.y"
{ funcs(do_closeinput, print_closeinput);
                } /*NOTREACHED*/ break;
case 81:
# line 636 "parz.y"
{ funcs(do_closeoutput, print_closeoutput);
                } /*NOTREACHED*/ break;
case 88:
# line 646 "parz.y"
{ register int v_s = sign(ARG_argsort(yypvt[-3].arg_def) & VEC);
                      register TYP tz = ARG_typ(yypvt[-3].arg_def);
                      register TYP tq = ARG_valtyp(yypvt[-0].arg_def);

                      funcs(assign_do_funcs[v_s][tz][tq],
                            print_zuw);
                      ska_vek_test(&yypvt[-3].arg_def,&yypvt[-0].arg_def);
                      if ((ARG_argsort(yypvt[-0].arg_def) & (ADS | ADV)) && (tz != INT))
                      { sem_error(texte[28]);
                        fehler(texte[29]);
                        ARG_argsort(yypvt[-3].arg_def) |= FALSCH;
                      }
                      if (tq == STR && tz != CHA)
                      { sem_error(texte[28]);
                        fehler(texte[30]);
                        ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                      }
                      switch (tz)
                      { case BOOL : if (tq == CHA)
                                    { sem_error(texte[28]);
                                      fehler(texte[99]);
                                      ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                                    }
                                    break;
                        case CHA  : if (tq == REAL)
                                    { sem_error(texte[28]);
                                      fehler(texte[100]);
                                      ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                                    }
                                    break;
                        case REAL : if (tq == CHA)
                                    { sem_error(texte[28]);
                                      fehler(texte[103]);
                                      ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                                    }
                      }
                      STAT_vc1(*stat_ptr) = yypvt[-0].arg_def;
                      STAT_verg(*stat_ptr) = yypvt[-3].arg_def;
                    } /*NOTREACHED*/ break;
case 89:
# line 686 "parz.y"
{ register int v_s = sign(ARG_argsort(yypvt[-4].arg_def) & VEC);

                      funcs(op_funcs[UMINUS-PLUS].do_f[v_s][ARG_typ(yypvt[-4].arg_def)], print_minus);
                      ska_vek_test(&yypvt[-4].arg_def,&yypvt[-0].arg_def);
                      typ2_test(&yypvt[-4].arg_def, &yypvt[-0].arg_def, (1<<INT | 1<<REAL));
                      STAT_vc1(*stat_ptr) = yypvt[-0].arg_def;
                      STAT_verg(*stat_ptr) = yypvt[-4].arg_def;
                    } /*NOTREACHED*/ break;
case 90:
# line 695 "parz.y"
{ funcs((ARG_argsort(yypvt[-4].arg_def) & VEC) ? do_vb_not : do_sb_not,
                            print_not);
                      ska_vek_test(&yypvt[-4].arg_def,&yypvt[-0].arg_def);
                      typ2_test(&yypvt[-4].arg_def, &yypvt[-0].arg_def, (1<<BOOL));
                      STAT_vc1(*stat_ptr) = yypvt[-0].arg_def;
                      STAT_verg(*stat_ptr) = yypvt[-4].arg_def;
                    } /*NOTREACHED*/ break;
case 91:
# line 703 "parz.y"
{ funcs((ARG_argsort(yypvt[-3].arg_def) & VEC)? do_vi_new : do_si_new,
                            print_new);
                      typ1_test(&yypvt[-3].arg_def,(1<<INT));
                      STAT_dnew(*stat_ptr) = dlptr(&yypvt[-0].decl_def);
                      STAT_verg(*stat_ptr) = yypvt[-3].arg_def;
                    } /*NOTREACHED*/ break;
case 92:
# line 710 "parz.y"
{ funcs(do_status, print_status);
                      if (ARG_argsort(yypvt[-2].arg_def) & VEC)
                      { sem_error(texte[142]); fehler_zahl++;
                        ARG_argsort(yypvt[-2].arg_def) |= FALSCH;
                      }
                      else
                      { typ1_test(&yypvt[-2].arg_def, (1<<BOOL)); }
                      STAT_verg(*stat_ptr) = yypvt[-2].arg_def;
                    } /*NOTREACHED*/ break;
case 93:
# line 720 "parz.y"
{ funcs(random_do_funcs[sign(ARG_argsort(yypvt[-2].arg_def) & VEC)][ARG_typ(yypvt[-2].arg_def)],
                            print_random);
                      typ1_test(&yypvt[-2].arg_def, (1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL));
                      STAT_verg(*stat_ptr) = yypvt[-2].arg_def;
                    } /*NOTREACHED*/ break;
case 94:
# line 727 "parz.y"
{ ska_vek_test(&yypvt[-5].arg_def,&yypvt[-2].arg_def);
                      ska_vek_test(&yypvt[-5].arg_def,&yypvt[-0].arg_def);
                      if ((int)yypvt[-1].int_val == '^')
                      { register int weiter_test = TRUE;
                        register int v_s = sign(ARG_argsort(yypvt[-5].arg_def) & VEC);

                        typ1_test(&yypvt[-5].arg_def,(1<<INT | 1<<REAL));
                        weiter_test = weiter_test && !(ARG_argsort(yypvt[-5].arg_def) & FALSCH);
                        typ1_test(&yypvt[-2].arg_def,(1<<INT | 1<<REAL));
                        weiter_test = weiter_test && !(ARG_argsort(yypvt[-2].arg_def) & FALSCH);
                        typ1_test(&yypvt[-0].arg_def,(1<<INT | 1<<REAL));
                        weiter_test = weiter_test && !(ARG_argsort(yypvt[-0].arg_def) & FALSCH);
                        if (weiter_test)
                        { if (ARG_typ(yypvt[-5].arg_def) == INT)
                          { funcs(v_s ? do_vii_pow : do_sii_pow, print_pow);
                            typ3_test(&yypvt[-5].arg_def, &yypvt[-2].arg_def, &yypvt[-0].arg_def, (1<<INT));
                          }
                          else if (ARG_typ(yypvt[-0].arg_def) == INT)
                          { funcs(v_s ? do_vri_pow : do_sri_pow, print_pow);
                            typ2_test(&yypvt[-5].arg_def, &yypvt[-2].arg_def, (1<<REAL));
                          }
                          else
                          { funcs(v_s ? do_vrr_pow : do_srr_pow, print_pow);
                            typ2_test(&yypvt[-5].arg_def, &yypvt[-2].arg_def, (1<<REAL));
                          }
                        }
                        STAT_vc1(*stat_ptr) = yypvt[-2].arg_def;
                        STAT_vc2(*stat_ptr) = yypvt[-0].arg_def;
                        STAT_verg(*stat_ptr) = yypvt[-5].arg_def;
                      }
                      else
                      { typ3_test(&yypvt[-5].arg_def,&yypvt[-2].arg_def,&yypvt[-0].arg_def,
                                  ((int)yypvt[-1].int_val == AND || (int)yypvt[-1].int_val == OR) ? (1<<BOOL)
                                                                    : (1<<INT | 1<<REAL));
                        operation(&yypvt[-5].arg_def,&yypvt[-2].arg_def,(int)yypvt[-1].int_val,&yypvt[-0].arg_def);
                      }
                    } /*NOTREACHED*/ break;
case 95:
# line 765 "parz.y"
{ ska_vek_test(&yypvt[-5].arg_def,&yypvt[-2].arg_def);
                      ska_vek_test(&yypvt[-5].arg_def,&yypvt[-0].arg_def);
                      typ1_test(&yypvt[-5].arg_def,(1<<BOOL));
                      typ2_test(&yypvt[-2].arg_def,&yypvt[-0].arg_def,(1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL));
                      rel_operation(&yypvt[-5].arg_def,&yypvt[-2].arg_def,(int)yypvt[-1].int_val,&yypvt[-0].arg_def);
                    } /*NOTREACHED*/ break;
case 96:
# line 772 "parz.y"
{ if (ARG_argsort(yypvt[-3].arg_def) & VEC)
                      { sem_error(texte[31]);
                        fehler(texte[32]);
                        ARG_argsort(yypvt[-3].arg_def) |= FALSCH;
                      }
                      typ2_test(&yypvt[-3].arg_def,
                                &(STAT_vc1(*stat_ptr)),
                                (STAT_print_func(*stat_ptr) == print_proc_reduce)
                                  ? (1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL)
                                  : red_typs[STAT_red_fct(*stat_ptr) - AND]);
                      STAT_verg(*stat_ptr) = yypvt[-3].arg_def;
                    } /*NOTREACHED*/ break;
case 97:
# line 785 "parz.y"
{ if (!((ARG_argsort(yypvt[-3].arg_def) & VEC) && ARG_typ(yypvt[-3].arg_def) == INT))
                      { sem_error(texte[200]);
                        fehler(texte[201]);
                        ARG_argsort(yypvt[-3].arg_def) |= FALSCH;
                      }
                      STAT_verg(*stat_ptr) = yypvt[-3].arg_def;
                    } /*NOTREACHED*/ break;
case 98:
# line 793 "parz.y"
{ register int v_s = sign(ARG_argsort(yypvt[-4].arg_def) & VEC);

                      funcs(op_funcs[(int)yypvt[-2].int_val-PLUS].do_f[v_s][ARG_typ(yypvt[-4].arg_def)],
                            op_funcs[(int)yypvt[-2].int_val-PLUS].print_f);
                      ska_vek_test(&yypvt[-4].arg_def,&yypvt[-0].arg_def);
                      typ2_test(&yypvt[-4].arg_def,&yypvt[-0].arg_def,(((int)yypvt[-2].int_val == ABS) ? (1<<INT | 1<<REAL)
                                                          : (1<<REAL)));
                      STAT_vc1(*stat_ptr) = yypvt[-0].arg_def;
                      STAT_verg(*stat_ptr) = yypvt[-4].arg_def;
                    } /*NOTREACHED*/ break;
case 99:
# line 804 "parz.y"
{ register int v_s = sign(ARG_argsort(yypvt[-5].arg_def) & VEC);

                      funcs(op_funcs[ARCTANT-PLUS].do_f[v_s][ARG_typ(yypvt[-5].arg_def)], print_arctant);
                      ska_vek_test(&yypvt[-5].arg_def,&yypvt[-1].arg_def);
                      ska_vek_test(&yypvt[-5].arg_def,&yypvt[-0].arg_def);
                      typ3_test(&yypvt[-5].arg_def,&yypvt[-1].arg_def,&yypvt[-0].arg_def,(1<<REAL));
                      STAT_vc1(*stat_ptr) = yypvt[-1].arg_def;
                      STAT_vc2(*stat_ptr) = yypvt[-0].arg_def;
                      STAT_verg(*stat_ptr) = yypvt[-5].arg_def;
                    } /*NOTREACHED*/ break;
case 100:
# line 815 "parz.y"
{ register int v_s = sign(ARG_argsort(yypvt[-5].arg_def) & VEC);

                      funcs(strcmp_do_funcs[v_s][ARG_typ(yypvt[-1].arg_def)][ARG_typ(yypvt[-0].arg_def)],
                            print_strcmp);
                      ska_vek_test(&yypvt[-5].arg_def, &yypvt[-1].arg_def);
                      ska_vek_test(&yypvt[-5].arg_def, &yypvt[-0].arg_def);
                      typ1_test(&yypvt[-5].arg_def, (1<<INT));
                      typ1_test(&yypvt[-1].arg_def, (1<<CHA | 1<<STR));
                      if (ARG_typ(yypvt[-1].arg_def) == CHA && (ARG_argsort(yypvt[-1].arg_def) & CON))
                      { sem_error(texte[28]);
                        fehler(texte[68]);
                        ARG_argsort(yypvt[-1].arg_def) |= FALSCH;
                      }
                      typ1_test(&yypvt[-0].arg_def, (1<<CHA | 1<<STR));
                      if (ARG_typ(yypvt[-0].arg_def) == CHA && (ARG_argsort(yypvt[-0].arg_def) & CON))
                      { sem_error(texte[28]);
                        fehler(texte[68]);
                        ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                      }
                      STAT_verg(*stat_ptr) = yypvt[-5].arg_def;
                      STAT_vc1(*stat_ptr) = yypvt[-1].arg_def;
                      STAT_vc2(*stat_ptr) = yypvt[-0].arg_def;
                    } /*NOTREACHED*/ break;
case 101:
# line 839 "parz.y"
{ yyval.int_val = (long)PLUS;} /*NOTREACHED*/ break;
case 102:
# line 840 "parz.y"
{ yyval.int_val = (long)MINUS;} /*NOTREACHED*/ break;
case 103:
# line 841 "parz.y"
{ yyval.int_val = (long)MAL;} /*NOTREACHED*/ break;
case 104:
# line 842 "parz.y"
{ yyval.int_val = (long)DURCH;} /*NOTREACHED*/ break;
case 105:
# line 843 "parz.y"
{ yyval.int_val = (long)'^';} /*NOTREACHED*/ break;
case 106:
# line 844 "parz.y"
{ yyval.int_val = (long)MOD;} /*NOTREACHED*/ break;
case 107:
# line 845 "parz.y"
{ yyval.int_val = (long)AND;} /*NOTREACHED*/ break;
case 108:
# line 846 "parz.y"
{ yyval.int_val = (long)OR;} /*NOTREACHED*/ break;
case 109:
# line 848 "parz.y"
{ yyval.int_val = (long)EQ;} /*NOTREACHED*/ break;
case 110:
# line 849 "parz.y"
{ yyval.int_val = (long)NE;} /*NOTREACHED*/ break;
case 111:
# line 850 "parz.y"
{ yyval.int_val = (long)LT;} /*NOTREACHED*/ break;
case 112:
# line 851 "parz.y"
{ yyval.int_val = (long)LE;} /*NOTREACHED*/ break;
case 113:
# line 852 "parz.y"
{ yyval.int_val = (long)GT;} /*NOTREACHED*/ break;
case 114:
# line 853 "parz.y"
{ yyval.int_val = (long)GE;} /*NOTREACHED*/ break;
case 115:
# line 855 "parz.y"
{ yyval.int_val = (long)ABS; } /*NOTREACHED*/ break;
case 116:
# line 856 "parz.y"
{ yyval.int_val = (long)SQRT; } /*NOTREACHED*/ break;
case 117:
# line 857 "parz.y"
{ yyval.int_val = (long)EXP; } /*NOTREACHED*/ break;
case 118:
# line 858 "parz.y"
{ yyval.int_val = (long)LN; } /*NOTREACHED*/ break;
case 119:
# line 859 "parz.y"
{ yyval.int_val = (long)SIN; } /*NOTREACHED*/ break;
case 120:
# line 860 "parz.y"
{ yyval.int_val = (long)COS; } /*NOTREACHED*/ break;
case 121:
# line 861 "parz.y"
{ yyval.int_val = (long)TAN; } /*NOTREACHED*/ break;
case 122:
# line 862 "parz.y"
{ yyval.int_val = (long)ARCSIN; } /*NOTREACHED*/ break;
case 123:
# line 863 "parz.y"
{ yyval.int_val = (long)ARCCOS; } /*NOTREACHED*/ break;
case 124:
# line 864 "parz.y"
{ yyval.int_val = (long)ARCTAN; } /*NOTREACHED*/ break;
case 125:
# line 867 "parz.y"
{ funcs((ARG_argsort(yypvt[-2].arg_def) & VEC) ? do_v_blockmove : do_s_blockmove,
                        print_blockmove);
                  ska_vek_test(&yypvt[-2].arg_def, &yypvt[-4].arg_def);
                  STAT_dblock(*stat_ptr) = dlptr(&yypvt[-0].decl_def);
                  STAT_vc2(*stat_ptr) = yypvt[-4].arg_def;
                  STAT_verg(*stat_ptr) = yypvt[-2].arg_def;
                } /*NOTREACHED*/ break;
case 126:
# line 876 "parz.y"
{ funcs(((ARG_argsort(yypvt[-3].arg_def) & VEC) || (ARG_argsort(yypvt[-2].arg_def) & VEC))
                        ? do_v_blockequal : do_s_blockequal,
                        print_blockequal);
                  STAT_dblock(*stat_ptr) = dlptr(&yypvt[-0].decl_def);
                  STAT_vc2(*stat_ptr) = yypvt[-3].arg_def;
                  STAT_vc3(*stat_ptr) = yypvt[-2].arg_def;
                } /*NOTREACHED*/ break;
case 127:
# line 885 "parz.y"
{ funcs(do_connect, print_connect);
                      port_nr_test(&yypvt[-4].arg_def);
                      STAT_out_port(*stat_ptr) = yypvt[-4].arg_def;
                      port_nr_test(&yypvt[-2].arg_def);
                      STAT_in_port(*stat_ptr) = yypvt[-2].arg_def;
                      typ1_test(&yypvt[-0].arg_def, (1<<INT));
                      STAT_vc1(*stat_ptr) = yypvt[-0].arg_def;
                    } /*NOTREACHED*/ break;
case 128:
# line 894 "parz.y"
{ funcs(do_biconnect, print_biconnect);
                      port_nr_test(&yypvt[-4].arg_def);
                      STAT_out_port(*stat_ptr) = yypvt[-4].arg_def;
                      port_nr_test(&yypvt[-2].arg_def);
                      STAT_in_port(*stat_ptr) = yypvt[-2].arg_def;
                      typ1_test(&yypvt[-0].arg_def, (1<<INT));
                      STAT_vc1(*stat_ptr) = yypvt[-0].arg_def;
                    } /*NOTREACHED*/ break;
case 129:
# line 904 "parz.y"
{ funcs(do_disconnect, print_disconnect);
                    } /*NOTREACHED*/ break;
case 130:
# line 907 "parz.y"
{ funcs(do_one_disconnect, print_one_disconnect);
                      port_nr_test(&yypvt[-0].arg_def);
                      STAT_out_port(*stat_ptr) = yypvt[-0].arg_def;
                    } /*NOTREACHED*/ break;
case 131:
# line 913 "parz.y"
{ register int z;

                      funcs(do_goto, print_goto);
                      STAT_spr_ziel(*stat_ptr) = z = ziel(-(int)yypvt[-0].int_val);
                      if (z >= 0)
                      { if (STAT_print_func(programm[z]) == print_proc)
                        { sem_error(texte[39]);
                          fehler(texte[25]);
                        }
                      }
                    } /*NOTREACHED*/ break;
case 132:
# line 926 "parz.y"
{ register int z;
                  register int v_s = (ARG_argsort(yypvt[-3].arg_def) & VEC);

                  if (STAT_rel_tok(*stat_ptr))
                  { v_s |= (ARG_argsort(STAT_vc2(*stat_ptr)) & VEC);
                    typ2_test(&yypvt[-3].arg_def,&(STAT_vc2(*stat_ptr)),(1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL));
                    funcs(v_s ? do_v2_ifcall : do_s2_ifcall, print_ifcall);
                  }
                  else
                  { typ1_test(&yypvt[-3].arg_def,(1<<BOOL));
                    funcs(v_s ? do_v_ifcall : do_s_ifcall, print_ifcall);
                  }
                  STAT_vc1(*stat_ptr) = yypvt[-3].arg_def;
                  STAT_spr_ziel(*stat_ptr) = z = ziel(-(int)yypvt[-0].int_val);
                  if (z >= 0)
                  { if (STAT_print_func(programm[z]) != print_proc)
                    { sem_error(texte[41]);
                      fehler(texte[42]);
                    }
                  }
                } /*NOTREACHED*/ break;
case 133:
# line 948 "parz.y"
{ register int z;

                  if (ARG_argsort(yypvt[-3].arg_def) & VEC)
                  { ARG_argsort(yypvt[-3].arg_def) |= FALSCH;
                    sem_error(texte[34]);
                    fehler(texte[43]);
                  }
                  if (STAT_rel_tok(*stat_ptr) &&
                      (ARG_argsort(STAT_vc2(*stat_ptr)) & VEC))
                  { ARG_argsort(STAT_vc2(*stat_ptr)) |= FALSCH;
                    sem_error(texte[34]);
                    fehler(texte[43]);
                  }
                  if (STAT_rel_tok(*stat_ptr))
                  { typ2_test(&yypvt[-3].arg_def,&(STAT_vc2(*stat_ptr)),(1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL));
                    funcs(do_2_ifgoto, print_ifgoto);
                  }
                  else
                  { typ1_test(&yypvt[-3].arg_def,(1<<BOOL));
                    funcs(do_ifgoto, print_ifgoto);
                  }
                  STAT_vc1(*stat_ptr) = yypvt[-3].arg_def;
                  STAT_spr_ziel(*stat_ptr) = z = ziel(-(int)yypvt[-0].int_val);
                  if (z >= 0)
                  { if (STAT_print_func(programm[z]) == print_proc)
                    { sem_error(texte[24]);
                      fehler(texte[25]);
                    }
                  }
                } /*NOTREACHED*/ break;
case 134:
# line 980 "parz.y"
{ register int z;
                      register int v_s = (ARG_argsort(yypvt[-3].arg_def) & VEC);

                      if (STAT_rel_tok(*stat_ptr))
                      { v_s |= (ARG_argsort(STAT_vc2(*stat_ptr)) & VEC);
                        typ2_test(&yypvt[-3].arg_def,&(STAT_vc2(*stat_ptr)),(1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL));
                        funcs(v_s ? do_v2_whilecall : do_s2_whilecall,
                              print_whilecall);
                      }
                      else
                      { typ1_test(&yypvt[-3].arg_def,(1<<BOOL));
                        funcs(v_s ? do_v_whilecall : do_s_whilecall,
                              print_whilecall);
                      }
                      STAT_vc1(*stat_ptr) = yypvt[-3].arg_def;
                      STAT_spr_ziel(*stat_ptr) = z = ziel(-(int)yypvt[-0].int_val);
                      if (z >= 0)
                      { if (STAT_print_func(programm[z]) != print_proc)
                        { sem_error(texte[41]);
                          fehler(texte[42]);
                        }
                      }
                    } /*NOTREACHED*/ break;
case 135:
# line 1005 "parz.y"
{ STAT_rel_tok(*stat_ptr) = (int)yypvt[-1].int_val;
                  STAT_vc2(*stat_ptr) = yypvt[-0].arg_def;
                } /*NOTREACHED*/ break;
case 136:
# line 1009 "parz.y"
{ STAT_rel_tok(*stat_ptr) = 0;
                } /*NOTREACHED*/ break;
case 137:
# line 1013 "parz.y"
{ register int z;

                      funcs(do_call, print_call);
                      STAT_spr_ziel(*stat_ptr) = z = ziel(-(int)yypvt[-0].int_val);
                      if (z >= 0)
                      { if (STAT_print_func(programm[z]) != print_proc)
                        { sem_error(texte[50]);
                          fehler(texte[42]);
                        }
                      }
                    } /*NOTREACHED*/ break;
case 138:
# line 1026 "parz.y"
{ if (yypvt[-0].int_val < 1l)
                  { error(texte[51]);
                    fehler(texte[52]);
                  }
                } /*NOTREACHED*/ break;
case 139:
# line 1032 "parz.y"
{ funcs(do_proc, print_proc);
                  STAT_proclev(*stat_ptr) = yypvt[-3].int_val;
                  max_lev = (yypvt[-3].int_val > max_lev) ? yypvt[-3].int_val : max_lev;
                } /*NOTREACHED*/ break;
case 305:
# line 2493 "parz.y"
{ ss_mod = (int)yypvt[-1].int_val; ss_fast = TRUE;
                      to_unbreak();
                      if (breaked)
                      { step_over_block = akt_step_block;
                        beende_parser();
                        return DO_GO;
                      }
                      else
                      { beende_parser();
                        return run_prog();
                      }
                    } /*NOTREACHED*/ break;
case 306:
# line 2506 "parz.y"
{ if (yypvt[-1].zeil_list.list_flag >= 0)
                      { ss_mod = (int)yypvt[-4].int_val; ss_fast = TRUE;
                        to_break(&yypvt[-1].zeil_list);
                        if (breaked)
                        { step_over_block = akt_step_block;
                          beende_parser();
                          return DO_GO;
                        }
                        else
                        { beende_parser();
                          return run_prog();
                        }
                      }
                    } /*NOTREACHED*/ break;
case 333:
# line 2558 "parz.y"
{ beende_parser();
                      return(DO_LOAD);
                    } /*NOTREACHED*/ break;
case 334:
# line 2562 "parz.y"
{ beende_parser();
                      return(DO_COMPILE);
                    } /*NOTREACHED*/ break;
case 423:
# line 3040 "parz.y"
{ ss_mod = ss_modus | (int)yypvt[-1].int_val; ss_fast = FALSE;
                      to_unbreak();
                      if (breaked)
                      { step_over_block = akt_step_block;
                        beende_parser();
                        return DO_STEP;
                      }
                      else
                      { beende_parser();
                        return run_prog();
                      }
                    } /*NOTREACHED*/ break;
case 424:
# line 3053 "parz.y"
{ if (yypvt[-1].zeil_list.list_flag >= 0)
                      { ss_mod = ss_modus | (int)yypvt[-4].int_val; ss_fast = FALSE;
                        to_break(&yypvt[-1].zeil_list);
                        if (breaked)
                        { step_over_block = akt_step_block;
                          beende_parser();
                          return DO_STEP;
                        }
                        else
                        { beende_parser();
                          return run_prog();
                        }
                      }
                    } /*NOTREACHED*/ break;
case 425:
# line 3068 "parz.y"
{ ss_mod = ss_modus | (int)yypvt[-2].int_val ; ss_fast = FALSE;
                      to_break(NULL);
                      if (breaked)
                      { step_over_block = akt_step_block;
                        beende_parser();
                        return DO_STEP;
                      }
                      else
                      { beende_parser();
                        return run_prog();
                      }
                    } /*NOTREACHED*/ break;
case 426:
# line 3081 "parz.y"
{ if (!stepping_to)
                      { ss_mod = ss_modus | (ss_mod & STEP_OVER);
                        to_break(NULL);
                      }
                      ss_fast = FALSE;
                      beende_parser();
                      return DO_STEP;
                    } /*NOTREACHED*/ break;
case 429:
# line 3097 "parz.y"
{ if (breaked)
                      { beende_parser();
                        return DO_STOP;
                      }
                      else
                      { fprintf(kommandout, texte[180]); }
                    } /*NOTREACHED*/ break;
default : yyparse2(yytmp,yypvt);
}


	goto yystack;		/* reset registers in driver code */
}
