
# line 2 "parz.y"
/******* Datei parz.y ******
 *
 *      Parser fuer PARZ V2.x
 *      Frank Sembach
 */

#include "parzdefs.h"
#include "komdefs.h"


# line 13 "parz.y"
typedef union 
 { long int_val;
   float real_val;
   unsigned char char_val;
   char *string_val;
   char *bitstring_val;
   char *comment;
   DECLIST decl_def;
   UNION_LIST union_def;
   TYP typ_def;
   ARG arg_def;
   CONLIST *conlist_ptr;
   RANGE range_val;
   MEMDECLIST memdeclist_val;
   RANGELIST *memlist_val;
   OPTPROC optproc_val;
   SCOPETAB *procidlist_val;
   long ident_key;
   ZEILE zeil_list;
   EXPRLIST exprlist_info;
   EXPR expr_info;
   SEXPR sexpr_info;
   SELECT select_info;
   EXPR_RANGE set_range;
 } YYSTYPE;
# define PLUS 257
# define MINUS 258
# define UMINUS 259
# define MAL 260
# define DURCH 261
# define MOD 262
# define SQRT 263
# define EXP 264
# define LN 265
# define SIN 266
# define COS 267
# define TAN 268
# define ARCSIN 269
# define ARCCOS 270
# define ARCTAN 271
# define ARCTANT 272
# define ABS 273
# define AND 274
# define OR 275
# define FIRST 276
# define LAST 277
# define SUM 278
# define PRODUCT 279
# define MAX 280
# define MIN 281
# define PROGRAMMSTART 282
# define KOMMANDOSTART 283
# define INTNUM 284
# define INTKLAM 285
# define REALNUM 286
# define CHAR 287
# define STRING 288
# define BITSTRING 289
# define EQ 290
# define NE 291
# define LT 292
# define LE 293
# define GT 294
# define GE 295
# define AOP 296
# define NIL 297
# define MYTRUE 298
# define MYFALSE 299
# define TERMS 300
# define EOL 301
# define MAXTRANS 302
# define ACTTRANS 303
# define DONE 304
# define TERMCH 305
# define SRESULT 306
# define ID 307
# define VRESULT 308
# define START 309
# define PE 310
# define PORTS 311
# define STOP 312
# define TO 313
# define SCALAR 314
# define VECTOR 315
# define RETURN 316
# define HALT 317
# define END 318
# define ADDR 319
# define NEW 320
# define NOT 321
# define STATUS 322
# define RANDOM 323
# define MOVE 324
# define EQUAL 325
# define AS 326
# define CONNECT 327
# define BICONNECT 328
# define AT 329
# define DISCONNECT 330
# define STRCMP 331
# define SIZE 332
# define IF 333
# define WHILE 334
# define CALL 335
# define GOTO 336
# define READ 337
# define WRITE 338
# define DRAW 339
# define WRITELN 340
# define LOAD 341
# define WITH 342
# define STORE 343
# define REDUCE 344
# define OF 345
# define PUSHS 346
# define PUSHV 347
# define POPS 348
# define POPV 349
# define PROC 350
# define PARALLEL 351
# define PROPAGATE 352
# define OUT 353
# define IN 354
# define SEND 355
# define RECEIVE 356
# define FROM 357
# define CONNECTED 358
# define NOP 359
# define B 360
# define C 361
# define I 362
# define R 363
# define U 364
# define S 365
# define V 366
# define OPENINPUT 367
# define OPENOUTPUT 368
# define CLOSEINPUT 369
# define CLOSEOUTPUT 370
# define GETPIXEL 371
# define OPENW 372
# define OPENABSW 373
# define MOVETO 374
# define LINETO 375
# define SETPIXEL 376
# define WSIZE 377
# define SETCOLOR 378
# define SELECTW 379
# define CLOSEW 380
# define ERROR 381
# define DEBUG 382
# define TRACE 383
# define NOTRACE 384
# define INITSET 385
# define ZEILEND 386
# define PP 387
# define LIST 388
# define CONNECTIONS 389
# define PATTERN 390
# define STRINGMATCH 391
# define GO 392
# define STEP 393
# define SET 394
# define OVER 395
# define ALL 396
# define COMPILER 397
# define INTERPRETER 398
# define FILENAME 399
# define ASSIGN 400
# define BREAKPOINT 401
# define EXAMINE 402
# define EIN 403
# define AUS 404
# define RECORD 405
# define KURZ 406
# define LANG 407
# define SHOW 408
# define MEMORY 409
# define HEAP 410
# define PARSTACK 411
# define CALLSTACK 412
# define CHAIN 413
# define ACTIVITY 414
# define VARIABLE 415
# define SPECIALS 416
# define DEPTH 417
# define WARN 418
# define CALLS 419
# define MODE 420
# define WIDTH 421
# define QUIT 422
# define HELP 423
# define IDENT 424
# define DIV 425
# define POWER 426

# line 133 "parz.y"
/*********************************************/
#include "externs.h"
#include "rundefs.h"
#include "runexts.h"
#include "komexts.h"
#include "debexts.h"
#include "funcs.h"

/* externs aus parz.l :  */
extern char *lies_comm(), *lies_zend();

extern char ausgeben;       /* Flag : Naechste Fehlermeldung ausgeben */
extern char bef_lesen;      /* Flag : Befehlstoken erwartet (Kommandointerp. ) */

extern FILE *yyin;          /* Eingabefile */
extern FILE *yyerfp;        /* File fuer Fehlermeldungen */
extern int yylineno;        /* Zeilenzaehler */
extern int anz_runwarnings; /* Zahl der ausgegebenen Warnungen zu einem SET-Kommando */

/*********************************************/

extern int yynerrs;         /* Zaehler fuer Fehlermeldungen */
#ifdef YYDEBUG
extern int yydebug;
#endif

extern char lesend, nospez;        /* Art des naechsten Zugriffs auf eine Variable */

extern char do_step;           /* parser hat "#\n" zurueckgegeben */
extern char scanner_fehler;    /* scanner hat in Zeile Fehler gemeldet */

extern int flags;                      /* Information ueber gelesene Schluesselworte */
extern int nach_end;                   /* Zaehlt Befehle nach dem letzten END-Befehl */
extern int last_label;                 /* letztes gelesenes Label */
extern int akt_max;                    /* maximale verfuegbare Programmadresse */

#define HEAP_ADRS 1
#define VEC_ADRS 2
extern char adrsort;                   /* Art der Adressen fuer memel */

extern STAT *stat_ptr;                 /* Zeiger auf momentan erzeugten Befehl */

extern struct func_ptrs
{ int (* do_f[2][REAL + 1])();
  int (* print_f)();
} op_funcs[OR - PLUS + 1];

extern struct
{ int (* do_rf[2])(), (* print_rf)();
} rel_op_funcs[GE - EQ + 1];

extern int (* assign_do_funcs[2][REAL + 1][STR + 1])();

extern int (* random_do_funcs[2][STR + 1])();

extern int (* strcmp_do_funcs[2][STR + 1][STR + 1])();

extern int (* red_do_funcs[STR + 1][MIN - AND + 1])();

extern int (* read_do_funcs[2][REAL + 1])();

extern int (* write2_do_funcs[2][STR + 1])();

extern int (* draw2_do_funcs[STR + 1])();

extern int (* writeln2_do_funcs[2][STR + 1])();

extern int red_typs[MIN - AND + 1];

extern AKTBLOCK *temp_a_block;         /* Zeiger auf Aktivierungsblock,
                                   der bei symbolischem Debuggen erzeugt wird 
                                   und von PROC vervollstaendigt werden muss */

extern char *ssstr[];           /* Texte fuer Singlestep-/Breakpointmodus */
extern char *protstr[];         /* Texte fuer Protokollmodus */

extern char *promptstr[2];

extern int graph_bef_exist;

#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
extern YYSTYPE yylval, yyval;
typedef int yytabelem;
# define YYERRCODE 256

# line 4085 "parz.y"

extern char * yydisplay();

extern DECL *neu_decl();
extern DECLIST *dlptr();
extern yytabelem yyexca[];

# define YYNPROD 504
# define YYLAST 1043
extern yytabelem yyact[];

extern yytabelem yypact[];

extern yytabelem yypgo[];

extern yytabelem yyr1[];

extern yytabelem yyr2[];

extern yytabelem yychk[];

extern yytabelem yydef[];

typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

extern yytoktype yytoks[];


extern char * yyreds[];

#endif /* YYDEBUG */
/* @(#)yaccpar	1.3  com/cmd/lang/yacc,3.1,9021 9/7/89 18:46:37 */
/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#ifdef YYSPLIT
#   define YYERROR	return(-2)
#else
#   define YYERROR	goto yyerrlab
#endif

#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
extern int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

#ifdef YYSPLIT
#   define YYSCODE { \
			extern int (*yyf[])(); \
			register int yyret; \
			if (yyf[yytmp]) \
			    if ((yyret=(*yyf[yytmp])()) == -2) \
				    goto yyerrlab; \
				else if (yyret>=0) return(yyret); \
		   }
#endif

/*
** global variables used by the parser
*/
extern YYSTYPE yyv[ YYMAXDEPTH ];	/* value stack */
extern int yys[ YYMAXDEPTH ];		/* state stack */

extern YYSTYPE *yypv;			/* top of value stack */
extern YYSTYPE *yypvt;			/* top of value stack for $vars */
extern int *yyps;			/* top of state stack */

extern int yystate;			/* current state */
extern int yytmp;			/* extra var (lasts between blocks) */

extern int yynerrs;			/* number of errors */
extern int yyerrflag;			/* error recovery flag */
extern int yychar;			/* current input token number */

extern int yyparse4();

/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse3(yytmp,yypvt)

int yytmp;
register YYSTYPE *yypvt;
{

		switch(yytmp){

case 289:
# line 2322 "parz.y"
{ yyval.range_val.von_n = 1; yyval.range_val.bis_n = pe_anz; } /*NOTREACHED*/ break;
case 290:
# line 2325 "parz.y"
{ if (yypvt[-0].int_val < 1l || yypvt[-0].int_val > (long)port_anz)
                      { komerr(texte[64], (int)yypvt[-0].int_val); }
                      else
                      { yyval.range_val.von_n = yyval.range_val.bis_n = (int)yypvt[-0].int_val; }
                    } /*NOTREACHED*/ break;
case 291:
# line 2331 "parz.y"
{ if (yypvt[-2].int_val < 1l || yypvt[-2].int_val > (long)port_anz)
                      { komerr(texte[64], (int)yypvt[-2].int_val); }
                      if (yypvt[-0].int_val < 1l || yypvt[-0].int_val > (long)port_anz)
                      { komerr(texte[64], (int)yypvt[-0].int_val); }
                      if (!anz_fehler)
                      { if (yypvt[-2].int_val > yypvt[-0].int_val)
                        { komerr(texte[45], (int)yypvt[-2].int_val, (int)yypvt[-0].int_val); }
                        else
                        { yyval.range_val.von_n = (int)yypvt[-2].int_val; yyval.range_val.bis_n = (int)yypvt[-0].int_val; }
                      }
                    } /*NOTREACHED*/ break;
case 292:
# line 2343 "parz.y"
{ yyval.range_val.von_n = 1; yyval.range_val.bis_n = port_anz; } /*NOTREACHED*/ break;
case 293:
# line 2347 "parz.y"
{ deb_mod = (int)yypvt[-2].int_val;
                      if ((int)yypvt[-1].int_val > 0)
                      { if (default_pelist) free(default_pelist);
                        default_pelist = pe_list_string;
                        pe_list_string = NULL;
                      }
                    } /*NOTREACHED*/ break;
case 294:
# line 2356 "parz.y"
{ yyval.int_val = (long)TRUE; } /*NOTREACHED*/ break;
case 295:
# line 2358 "parz.y"
{ yyval.int_val = (long)FALSE; } /*NOTREACHED*/ break;
case 296:
# line 2360 "parz.y"
{ yyval.int_val = (long)((int)yypvt[-0].int_val > 0); } /*NOTREACHED*/ break;
case 297:
# line 2362 "parz.y"
{ yyval.int_val = (long)deb_mod; } /*NOTREACHED*/ break;
case 298:
# line 2366 "parz.y"
{ if (yypvt[-0].optproc_val.p_tief)
                      { if (yypvt[-0].optproc_val.p_lab >= 0)
                        { init_debcode(STAT_print_func(programm[yypvt[-0].optproc_val.p_lab]) == print_proc ?
                                         STAT_proclev(programm[yypvt[-0].optproc_val.p_lab]) + 1 :
                                         1,
                                       yypvt[-0].optproc_val.p_lab,
                                       &yypvt[-0].optproc_val.ab_abstand);
                        }
                        else
                        { init_debcode(akt_tiefe + 1, -1, &yypvt[-0].optproc_val.ab_abstand); }
                      }
                    } /*NOTREACHED*/ break;
case 299:
# line 2379 "parz.y"
{ if (sym_debugging)
                      { if (yypvt[-4].optproc_val.p_tief)
                        { end_debcode();
#ifdef DEBDEBUG
                          debcode_out();
                          parz_typs_out(stdout);
#endif
                          if (!anz_fehler)
                          { char *dummyst;
                            int dummy;
			    char nl_out = FALSE;

			    more_on(); beim_listing = TRUE;
                            for (; yypvt[-4].optproc_val.p_tief && akt_tiefe >= 0; yypvt[-4].optproc_val.p_tief--)
                            { if (yypvt[-4].optproc_val.p_lab >= 0)
                              { if (nl_out)
				{ putc('\n', kommandout); ifmore(kommandout); }
				if (quitted) break;
				fprintf(kommandout, texte[223], yypvt[-4].optproc_val.ab_abstand);
                                ifmore(kommandout);
                                if (quitted) break;
                              }
                              temp_a_block = new_aktblock(pc + 1, NULL, TRUE);
                              called = TRUE;
                              warnings_on = FALSE;
                              ended = FALSE;
                              err = FALSE;
                              examining = TRUE;
                              start(debcode_start);
                              examining = FALSE;
                              nl_out = elist_out(&yypvt[-2].sexpr_info, &yypvt[-1].exprlist_info, kommandout);
                              do
                              { akt_return(&dummyst, &dummy);
                                if (dummyst)
                                { free(aktive_pes);
                                  aktive_pes = dummyst;
                                  last_akt_pe = last(aktive_pes,&anz_akt_pes);
                                }
                              } while (akt_tiefe >= debug_lev);
                              if (yypvt[-4].optproc_val.p_lab >= 0)
                              { yypvt[-4].optproc_val.ab_abstand += find_aktblock(yypvt[-4].optproc_val.p_lab, TRUE); }
                            }
			    if (nl_out) { putc('\n', kommandout); }
			    beim_listing = FALSE; more_off();
                          }
                          kill_debcode();
                        }
                      }
                      exprlist_free(&yypvt[-1].exprlist_info);
                    } /*NOTREACHED*/ break;
case 300:
# line 2425 "parz.y"
{ if (yypvt[-2].procidlist_val)
                      { yyval.optproc_val.p_lab = yypvt[-2].procidlist_val->entry_lab;
                        yyval.optproc_val.p_tief = (int)yypvt[-0].int_val;
                      }
                      else
                      { yyval.optproc_val.p_tief = 0; }
                    } /*NOTREACHED*/ break;
case 301:
# line 2433 "parz.y"
{ if (yypvt[-0].procidlist_val)
                      { yyval.optproc_val.p_lab = yypvt[-0].procidlist_val->entry_lab;
                        yyval.optproc_val.p_tief = 1;
                      }
                      else
                      { yyval.optproc_val.p_tief = 0; }
                    } /*NOTREACHED*/ break;
case 302:
# line 2441 "parz.y"
{ yyval.optproc_val.p_lab = -1;
                      yyval.optproc_val.p_tief = 1;
                    } /*NOTREACHED*/ break;
case 303:
# line 2447 "parz.y"
{ if (yypvt[-2].procidlist_val)
                      { register SYMTAB *st;

                        if (st = look_sym(yypvt[-0].ident_key, yypvt[-2].procidlist_val))
                        { switch (st->sym_art)
                          { case SY_SYSNAME  : yyval.procidlist_val = scope_table + geltcount - 1;
                                               break;
                            case SY_PROCNAME : yyval.procidlist_val = scope_table + st->sym_type_scope - 1;
                                               break;
                            default : komerr(texte[302], key_to_name(yypvt[-0].ident_key));
                                      yyval.procidlist_val = NULL;
                          }
                        }
                        else
                        { komerr(texte[302], key_to_name(yypvt[-0].ident_key));
                          yyval.procidlist_val = NULL;
                        }
                      }
                    } /*NOTREACHED*/ break;
case 304:
# line 2467 "parz.y"
{ register SYMTAB *st;

                      if (disp)
                      { if (st = look_sym(yypvt[-0].ident_key, disp[akt_tiefe]->top_scope))
                        { switch (st->sym_art)
                          { case SY_SYSNAME  : yyval.procidlist_val = scope_table + geltcount - 1;
                                               break;
                            case SY_PROCNAME : yyval.procidlist_val = scope_table + st->sym_type_scope - 1;
                                               break;
                            default : komerr(texte[302], key_to_name(yypvt[-0].ident_key));
                                      yyval.procidlist_val = NULL;
                          }
                        }
                        else
                        { komerr(texte[302], key_to_name(yypvt[-0].ident_key));
                          yyval.procidlist_val = NULL;
                        }
                      }
                      else
                      { komerr(texte[183]);
                        yyval.procidlist_val = NULL;
                      }
                    } /*NOTREACHED*/ break;
case 307:
# line 2522 "parz.y"
{ yyval.int_val = 0l; } /*NOTREACHED*/ break;
case 308:
# line 2524 "parz.y"
{ yyval.int_val = (long)ss_modus; } /*NOTREACHED*/ break;
case 309:
# line 2526 "parz.y"
{ yyval.int_val = (long)(ss_modus | STEP_OVER); } /*NOTREACHED*/ break;
case 310:
# line 2530 "parz.y"
{ help(0); } /*NOTREACHED*/ break;
case 311:
# line 2532 "parz.y"
{ help((int)yypvt[-1].int_val); } /*NOTREACHED*/ break;
case 312:
# line 2534 "parz.y"
{ yyval.int_val = (long)ASSIGN; } /*NOTREACHED*/ break;
case 313:
# line 2535 "parz.y"
{ yyval.int_val = (long)BREAKPOINT; } /*NOTREACHED*/ break;
case 314:
# line 2536 "parz.y"
{ yyval.int_val = (long)CALLS; } /*NOTREACHED*/ break;
case 315:
# line 2537 "parz.y"
{ yyval.int_val = (long)CONNECTIONS; } /*NOTREACHED*/ break;
case 316:
# line 2538 "parz.y"
{ yyval.int_val = (long)DEBUG; } /*NOTREACHED*/ break;
case 317:
# line 2539 "parz.y"
{ yyval.int_val = (long)EXAMINE; } /*NOTREACHED*/ break;
case 318:
# line 2540 "parz.y"
{ yyval.int_val = (long)GO; } /*NOTREACHED*/ break;
case 319:
# line 2541 "parz.y"
{ yyval.int_val = (long)HELP; } /*NOTREACHED*/ break;
case 320:
# line 2542 "parz.y"
{ yyval.int_val = (long)LOAD; } /*NOTREACHED*/ break;
case 321:
# line 2543 "parz.y"
{ yyval.int_val = (long)LIST; } /*NOTREACHED*/ break;
case 322:
# line 2544 "parz.y"
{ yyval.int_val = (long)MODE; } /*NOTREACHED*/ break;
case 323:
# line 2545 "parz.y"
{ yyval.int_val = (long)NOTRACE; } /*NOTREACHED*/ break;
case 324:
# line 2546 "parz.y"
{ yyval.int_val = (long)QUIT; } /*NOTREACHED*/ break;
case 325:
# line 2547 "parz.y"
{ yyval.int_val = (long)RECORD; } /*NOTREACHED*/ break;
case 326:
# line 2548 "parz.y"
{ yyval.int_val = (long)SHOW; } /*NOTREACHED*/ break;
case 327:
# line 2549 "parz.y"
{ yyval.int_val = (long)SET; } /*NOTREACHED*/ break;
case 328:
# line 2550 "parz.y"
{ yyval.int_val = (long)STEP; } /*NOTREACHED*/ break;
case 329:
# line 2551 "parz.y"
{ yyval.int_val = (long)STOP; } /*NOTREACHED*/ break;
case 330:
# line 2552 "parz.y"
{ yyval.int_val = (long)TRACE; } /*NOTREACHED*/ break;
case 331:
# line 2553 "parz.y"
{ yyval.int_val = (long)WARN; } /*NOTREACHED*/ break;
case 332:
# line 2554 "parz.y"
{ yyval.int_val = (long)WIDTH; } /*NOTREACHED*/ break;
case 335:
# line 2568 "parz.y"
{ if (!anz_fehler)
                      { more_on();
                        list_prog(listout, &yypvt[-1].range_val);
                        more_off();
                      }
                    } /*NOTREACHED*/ break;
case 336:
# line 2575 "parz.y"
{ if (!anz_fehler)
                      { more_on();
                        list_pat_prog(kommandout, yypvt[-1].string_val, FALSE);
                        more_off();
                      }
                    } /*NOTREACHED*/ break;
case 337:
# line 2582 "parz.y"
{ if (!anz_fehler)
                      { more_on();
                        list_pat_prog(kommandout, yypvt[-1].string_val, TRUE);
                        more_off();
                      }
                    } /*NOTREACHED*/ break;
case 338:
# line 2590 "parz.y"
{ register int z = ziel(-(int)yypvt[-0].int_val);

                      if (z < 0)
                      { komerr(texte[173], (int)yypvt[-0].int_val); }
                      else
                      { yyval.range_val.von_n = yyval.range_val.bis_n = z; }
                    } /*NOTREACHED*/ break;
case 339:
# line 2598 "parz.y"
{ register int z = ziel(-(int)yypvt[-1].int_val);

                      if (z < 0)
                      { komerr(texte[173], (int)yypvt[-1].int_val); }
                      else
                      { yyval.range_val.von_n = z; yyval.range_val.bis_n = stat_anz - 1; }
                    } /*NOTREACHED*/ break;
case 340:
# line 2606 "parz.y"
{ register int z1 = ziel(-(int)yypvt[-2].int_val);
                      register int z2 = ziel(-(int)yypvt[-0].int_val);

                      if (z1 < 0)
                      { komerr(texte[173], (int)yypvt[-2].int_val); }
                      if (z2 < 0)
                      { komerr(texte[173], (int)yypvt[-0].int_val); }
                      if (!anz_fehler)
                      { if (z1 > z2)
                        { komerr(texte[195], (int)yypvt[-2].int_val, (int)yypvt[-0].int_val); }
                        else
                        { yyval.range_val.von_n = z1; yyval.range_val.bis_n = z2; }
                      }
                    } /*NOTREACHED*/ break;
case 341:
# line 2621 "parz.y"
{ register int z = ziel(-(int)yypvt[-0].int_val);

                      if (z < 0)
                      { komerr(texte[173], (int)yypvt[-0].int_val); }
                      else
                      { yyval.range_val.von_n = 0; yyval.range_val.bis_n = z; }
                    } /*NOTREACHED*/ break;
case 342:
# line 2629 "parz.y"
{ yyval.range_val.von_n = 0; yyval.range_val.bis_n = stat_anz - 1; } /*NOTREACHED*/ break;
case 344:
# line 2634 "parz.y"
{ ss_mod = ss_modus = ss_mod_start = STEP_COMP; } /*NOTREACHED*/ break;
case 345:
# line 2636 "parz.y"
{ ss_mod = ss_modus = ss_mod_start = STEP_INTER; } /*NOTREACHED*/ break;
case 346:
# line 2640 "parz.y"
{ parse_start = -2;
                      tr_block_off(s_blocks, 1);
                      tr_block_off(s_heap, 1);
                      tr_block_off(v_blocks, pe_anz);
                      tr_block_off(v_heap, pe_anz);
                    } /*NOTREACHED*/ break;
case 347:
# line 2647 "parz.y"
{ parse_start = -2;
                      if (!anz_fehler)
                      { if ((ARG_argsort(yypvt[-1].arg_def) & (IND | INDL)) &&
                            (ARG_indsort(yypvt[-1].arg_def) & VEC)) 
                        { komerr(texte[118]); }
                        else
                        { zielits = item_ptr(&yypvt[-1].arg_def, &zielbs, disp);
                          if (err) err = FALSE;
                          else tr_off(zielits, zielbs);
                        }
                      }
                    } /*NOTREACHED*/ break;
case 348:
# line 2662 "parz.y"
{ parzexit(0); } /*NOTREACHED*/ break;
case 349:
# line 2666 "parz.y"
{ if (prot != (int)yypvt[-1].int_val)
                      { prot = (int)yypvt[-1].int_val;
                        if (prot) alt_prot = prot;
                        if (prot_offen) fprintf(protokollout, texte[202], prot);
                      }
                    } /*NOTREACHED*/ break;
case 350:
# line 2672 "parz.y"
{ yyval.int_val = 0l; } /*NOTREACHED*/ break;
case 351:
# line 2673 "parz.y"
{ yyval.int_val = 1l; } /*NOTREACHED*/ break;
case 352:
# line 2674 "parz.y"
{ yyval.int_val = 2l; } /*NOTREACHED*/ break;
case 353:
# line 2675 "parz.y"
{ yyval.int_val = (yypvt[-0].int_val <= 2l) ? yypvt[-0].int_val : (long)prot; } /*NOTREACHED*/ break;
case 354:
# line 2676 "parz.y"
{ yyval.int_val = (long)prot; } /*NOTREACHED*/ break;
case 360:
# line 2688 "parz.y"
{ adrsort = 0; } /*NOTREACHED*/ break;
case 361:
# line 2690 "parz.y"
{ parse_start = -2;
                      if (!anz_fehler)
                      { more_on();
                        show_mem(kommandout, yypvt[-3].memlist_val, yypvt[-2].memlist_val, (int)yypvt[-1].int_val);
                        more_off();
                        loesch_rangelist(yypvt[-3].memlist_val);
                        loesch_rangelist(yypvt[-2].memlist_val);
                      }
                    } /*NOTREACHED*/ break;
case 362:
# line 2700 "parz.y"
{ adrsort = HEAP_ADRS; } /*NOTREACHED*/ break;
case 363:
# line 2702 "parz.y"
{ parse_start = -2;
                      if (!anz_fehler)
                      { more_on();
                        show_heap(kommandout, yypvt[-3].memlist_val, yypvt[-2].memlist_val, (int)yypvt[-1].int_val);
                        more_off();
                        loesch_rangelist(yypvt[-3].memlist_val);
                        loesch_rangelist(yypvt[-2].memlist_val);
                      }
                    } /*NOTREACHED*/ break;
case 364:
# line 2713 "parz.y"
{ yyval.memlist_val = NULL; } /*NOTREACHED*/ break;
case 365:
# line 2715 "parz.y"
{ yyval.memlist_val = yypvt[-0].memdeclist_val.mem_erster; } /*NOTREACHED*/ break;
case 366:
# line 2717 "parz.y"
{ yyval.memlist_val = (RANGELIST *)(-1); } /*NOTREACHED*/ break;
case 367:
# line 2720 "parz.y"
{ yyval.memlist_val = NULL; } /*NOTREACHED*/ break;
case 368:
# line 2722 "parz.y"
{ adrsort |= VEC_ADRS; } /*NOTREACHED*/ break;
case 369:
# line 2724 "parz.y"
{ yyval.memlist_val = yypvt[-0].memdeclist_val.mem_erster; } /*NOTREACHED*/ break;
case 370:
# line 2726 "parz.y"
{ yyval.memlist_val = (RANGELIST *)(-1); } /*NOTREACHED*/ break;
case 371:
# line 2729 "parz.y"
{ yyval.memdeclist_val = yypvt[-2].memdeclist_val;
                      if (yyval.memdeclist_val.mem_letzter->next_range = new_rangelist())
                      { yyval.memdeclist_val.mem_letzter = yyval.memdeclist_val.mem_letzter->next_range;
                        yyval.memdeclist_val.mem_letzter->r = yypvt[-0].range_val;
                      }
                    } /*NOTREACHED*/ break;
case 372:
# line 2736 "parz.y"
{ if (yyval.memdeclist_val.mem_erster = yyval.memdeclist_val.mem_letzter = new_rangelist())
                      { yyval.memdeclist_val.mem_erster->r = yypvt[-0].range_val; }
                    } /*NOTREACHED*/ break;
case 373:
# line 2741 "parz.y"
{ yyval.range_val.von_n = yyval.range_val.bis_n = (yypvt[-1].int_val ? (int)yypvt[-1].int_val : 1) * (int)yypvt[-0].int_val; } /*NOTREACHED*/ break;
case 374:
# line 2743 "parz.y"
{ yyval.range_val.von_n = (yypvt[-2].int_val ? (int)yypvt[-2].int_val : 1) * (int)yypvt[-1].int_val;
                  yyval.range_val.bis_n = (adrsort & HEAP_ADRS)
                             ? -1
                             : ((adrsort & VEC_ADRS) ? v_max_b_adr : s_max_b_adr);
                  if (yyval.range_val.von_n > yyval.range_val.bis_n)
                  { komerr(texte[197], yyval.range_val.von_n, yyval.range_val.bis_n); }
                } /*NOTREACHED*/ break;
case 375:
# line 2751 "parz.y"
{ yyval.range_val.von_n = (adrsort & VEC_ADRS) ? v_min_h_adr : s_min_h_adr;
                  yyval.range_val.bis_n = (yypvt[-1].int_val ? (int)yypvt[-1].int_val : 1) * (int)yypvt[-0].int_val;
                  if (yyval.range_val.von_n > yyval.range_val.bis_n)
                  { komerr(texte[197], yyval.range_val.von_n, yyval.range_val.bis_n); }
                } /*NOTREACHED*/ break;
case 376:
# line 2757 "parz.y"
{ yyval.range_val.von_n = (yypvt[-4].int_val ? (int)yypvt[-4].int_val : 1) * (int)yypvt[-3].int_val;
                  yyval.range_val.bis_n = (yypvt[-1].int_val ? (int)yypvt[-1].int_val : 1) * (int)yypvt[-0].int_val;
                  if (yyval.range_val.von_n > yyval.range_val.bis_n)
                  { komerr(texte[197], yyval.range_val.von_n, yyval.range_val.bis_n); }
                } /*NOTREACHED*/ break;
case 377:
# line 2763 "parz.y"
{ yyval.int_val = 1l; } /*NOTREACHED*/ break;
case 378:
# line 2764 "parz.y"
{ yyval.int_val = -1l; } /*NOTREACHED*/ break;
case 379:
# line 2765 "parz.y"
{ yyval.int_val = 0l; } /*NOTREACHED*/ break;
case 380:
# line 2769 "parz.y"
{ parse_start = -2;
                          if (!anz_fehler)
                          { more_on();
                            show_parstack(kommandout, (int)yypvt[-3].int_val, (int)yypvt[-2].int_val, (int)yypvt[-1].int_val);
                            more_off();
                          }
                        } /*NOTREACHED*/ break;
case 381:
# line 2779 "parz.y"
{ parse_start = -2;
                          if (!anz_fehler)
                          { more_on();
                            show_aktstack(kommandout, (int)yypvt[-4].int_val, (int)yypvt[-3].int_val, (int)yypvt[-2].int_val, (int)yypvt[-1].int_val);
                            more_off();
                          }
                        } /*NOTREACHED*/ break;
case 382:
# line 2788 "parz.y"
{ yyval.int_val = yypvt[-0].int_val; } /*NOTREACHED*/ break;
case 383:
# line 2790 "parz.y"
{ yyval.int_val = -2l; } /*NOTREACHED*/ break;
case 384:
# line 2793 "parz.y"
{ yyval.int_val = yypvt[-0].int_val; } /*NOTREACHED*/ break;
case 385:
# line 2795 "parz.y"
{ yyval.int_val = -2l; } /*NOTREACHED*/ break;
case 386:
# line 2798 "parz.y"
{ yyval.int_val = yypvt[-0].int_val; } /*NOTREACHED*/ break;
case 387:
# line 2800 "parz.y"
{ yyval.int_val = -1l; } /*NOTREACHED*/ break;
case 388:
# line 2803 "parz.y"
{ if (yychar > 0) ups();
                      yyclearin;
                      parse_start = -3;
                      yyval.int_val = (long)CHAIN_OPT;
                    } /*NOTREACHED*/ break;
case 389:
# line 2809 "parz.y"
{ if (yychar > 0) ups();
                      yyclearin;
                      parse_start = -3;
                      yyval.int_val = (long)(CHAIN_OPT | ACTIVITY_OPT);
                    } /*NOTREACHED*/ break;
case 390:
# line 2815 "parz.y"
{ if (yychar > 0) ups();
                      yyclearin;
                      parse_start = -3;
                      yyval.int_val = 0l;
                    } /*NOTREACHED*/ break;
case 391:
# line 2823 "parz.y"
{ parse_start = -2; } /*NOTREACHED*/ break;
case 392:
# line 2825 "parz.y"
{ if (!anz_fehler)
                          { more_on();
                            show_var(kommandout, &yypvt[-5].arg_def, &yypvt[-3].optproc_val, (int)yypvt[-2].int_val, &yypvt[-1].decl_def);
                            more_off();
                          }
                        } /*NOTREACHED*/ break;
case 393:
# line 2832 "parz.y"
{ if (!anz_fehler)
                          { more_on();
                            show_spez(kommandout, (int)yypvt[-2].int_val, (int)yypvt[-1].int_val);
                            more_off();
                          }
                        } /*NOTREACHED*/ break;
case 394:
# line 2840 "parz.y"
{ if (yychar > 0) ups();
                      yyclearin;
                      parse_start = -3;
                      yyval.optproc_val.p_lab = (int)yypvt[-0].int_val;
                      yyval.optproc_val.p_tief = 1;
                    } /*NOTREACHED*/ break;
case 395:
# line 2847 "parz.y"
{ if (yychar > 0) ups();
                      yyclearin;
                      parse_start = -3;
                      yyval.optproc_val.p_lab = (int)yypvt[-2].int_val;
                      yyval.optproc_val.p_tief = (int)yypvt[-0].int_val;
                    } /*NOTREACHED*/ break;
case 396:
# line 2854 "parz.y"
{ if (yychar > 0) ups();
                      yyclearin;
                      parse_start = -3;
                      yyval.optproc_val.p_lab = -1;
                    } /*NOTREACHED*/ break;
case 397:
# line 2861 "parz.y"
{ if ((int)yypvt[-0].int_val == 0)
                      { yyval.int_val = -1l;
                        { komerr(texte[173], 0); }
                      }
                      else
                      { yyval.int_val = (long)ziel(-(int)yypvt[-0].int_val);
                        if ((int)yyval.int_val < 0)
                        { komerr(texte[173], (int)yypvt[-0].int_val); }
                      }
                    } /*NOTREACHED*/ break;
case 398:
# line 2873 "parz.y"
{ yyval.decl_def = yypvt[-0].decl_def; } /*NOTREACHED*/ break;
case 399:
# line 2875 "parz.y"
{ null_dlist(&yyval.decl_def);
                } /*NOTREACHED*/ break;
case 400:
# line 2879 "parz.y"
{ yyval.int_val = yypvt[-0].int_val; } /*NOTREACHED*/ break;
case 401:
# line 2881 "parz.y"
{ yyval.int_val = ( (1l << (MAXTRANS - MAXTRANS) ) |
                             (1l << (ACTTRANS - MAXTRANS) ) |
                             (1l << (DONE - MAXTRANS) ) |
                             (1l << (TERMCH - MAXTRANS) ) |
                             (1l << (SRESULT - MAXTRANS) ) |
                             (1l << (VRESULT - MAXTRANS) ) ); 
                    } /*NOTREACHED*/ break;
case 402:
# line 2890 "parz.y"
{ yyval.int_val = yypvt[-2].int_val | (1l << ((int)yypvt[-0].int_val - MAXTRANS)); } /*NOTREACHED*/ break;
case 403:
# line 2892 "parz.y"
{ yyval.int_val = yypvt[-1].int_val | (1l << ((int)yypvt[-0].int_val - MAXTRANS)); } /*NOTREACHED*/ break;
case 404:
# line 2894 "parz.y"
{ yyval.int_val = (1l << ((int)yypvt[-0].int_val - MAXTRANS)); } /*NOTREACHED*/ break;
case 405:
# line 2896 "parz.y"
{ yyval.int_val = (long)MAXTRANS; } /*NOTREACHED*/ break;
case 406:
# line 2897 "parz.y"
{ yyval.int_val = (long)ACTTRANS; } /*NOTREACHED*/ break;
case 407:
# line 2898 "parz.y"
{ yyval.int_val = (long)DONE; } /*NOTREACHED*/ break;
case 408:
# line 2899 "parz.y"
{ yyval.int_val = (long)TERMCH; } /*NOTREACHED*/ break;
case 409:
# line 2900 "parz.y"
{ yyval.int_val = (long)SRESULT; } /*NOTREACHED*/ break;
case 410:
# line 2901 "parz.y"
{ yyval.int_val = (long)VRESULT; } /*NOTREACHED*/ break;
case 411:
# line 2905 "parz.y"
{ register ITEM *ziel;
                      register ITEM *quell;
                      register char *akt_pe_save;
                      register int last_akt_pe_save, anz_akt_save;

                      if (!anz_fehler)
                      { tr_flag = FALSE;
                        akt_pe_save = aktive_pes; last_akt_pe_save = last_akt_pe; anz_akt_save = anz_akt_pes;
                        aktive_pes = (int)yypvt[-4].int_val ? pe_list_string : default_pelist;
                        last_akt_pe = last(aktive_pes,&anz_akt_pes);
                        zielits = item_ptr(&yypvt[-5].arg_def, &zielbs, disp);
                        if (err) err = FALSE;
                        else if (ARG_argsort(yypvt[-5].arg_def) & VEC)
                        { register VARBLOCK **blpt = &zielbs->blocks[0];
                          register ITPTRS *quellits = item_ptr(&yypvt[-1].arg_def, &dummybs, disp);

                          if (err) err = FALSE;
                          else
                          { setvarlen = pe_anz; vec_bef = TRUE; anz_runwarnings = 0;
                            for (pec = 0; pec < last_akt_pe; pec++, blpt += zielbs->inc)
                            { ziel = (* zielits->n_it_func)(zielits);
                              quell = (* quellits->n_it_func)(quellits);
                              if (aktive_pes[pec] == '1')
                              { setbl = *blpt;
                                if (!setbl->max_pes ||
                                    setbl->max_pes[pec] == '1')
                                set_item_cast(ziel,ARG_typ(yypvt[-5].arg_def),quell,ARG_typ(yypvt[-1].arg_def),(int)yypvt[-2].int_val);
                              }
                            }
                          }
                        }
                        else
                        { if (ARG_argsort(yypvt[-1].arg_def) & VEC)
                          { komerr(texte[67]); }
                          else
                          { setbl = zielbs->blocks[0];
                            setvarlen = 1; vec_bef = FALSE; anz_runwarnings = 0;
                            quell = item_ptr(&yypvt[-1].arg_def, &dummybs, disp)->itps[0];
                            if (err) err = FALSE;
                            else
                            { set_item_cast(zielits->itps[0], ARG_typ(yypvt[-5].arg_def), quell, ARG_typ(yypvt[-1].arg_def),(int)yypvt[-2].int_val); }
                          }
                        }
                        if (tr_flag)
                        { more_on();
                          tr_out(debugout);
                          more_off();
                        }
                        aktive_pes = akt_pe_save; last_akt_pe = last_akt_pe_save; anz_akt_pes = anz_akt_save;
                        if (fperror)
                        { komerr(texte[111]); }
                      }
                      parse_start = -2;
                    } /*NOTREACHED*/ break;
case 412:
# line 2960 "parz.y"
{ yyval.int_val = (long)'-'; } /*NOTREACHED*/ break;
case 413:
# line 2961 "parz.y"
{ yyval.int_val = (long)NOT; } /*NOTREACHED*/ break;
case 414:
# line 2962 "parz.y"
{ yyval.int_val = 0l; } /*NOTREACHED*/ break;
case 415:
# line 2966 "parz.y"
{ yyval.int_val = ((int)yypvt[-0].int_val) ? 1l : -1l; } /*NOTREACHED*/ break;
case 416:
# line 2968 "parz.y"
{ yyval.int_val = 0l; } /*NOTREACHED*/ break;
case 417:
# line 2970 "parz.y"
{ register int n;
                      if (pe_list_string)
                      { for (n = 0; n < pe_anz; pe_list_string[n++] = '1');
                        yyval.int_val = 1l;
                      }
                      else yyval.int_val = -1l;
                    } /*NOTREACHED*/ break;
case 418:
# line 2979 "parz.y"
{ register int n;
                      register char *sp;

                      if (pe_list_string) free(pe_list_string);
                      if (!(pe_list_string = calloc((size_t)pe_anz + 1,
                                                    (size_t)sizeof(char))))
                      { komerr(texte[80]); }
                      else
                      { for (n = 1, sp = pe_list_string;
                             n <= pe_anz;
                             n++, *(sp++) = '0');
                        *sp = '\0';
                      }
                    } /*NOTREACHED*/ break;
case 419:
# line 2996 "parz.y"
{ yyval.int_val = yypvt[-2].int_val && yypvt[-0].int_val; } /*NOTREACHED*/ break;
case 420:
# line 2998 "parz.y"
{ yyval.int_val = yypvt[-0].int_val; } /*NOTREACHED*/ break;
case 421:
# line 3001 "parz.y"
{ if (pe_list_string)
                  { if (yypvt[-0].int_val < 1l || yypvt[-0].int_val > (long)pe_anz)
                    { komerr(texte[63], (int)yypvt[-0].int_val); yyval.int_val = (long)FALSE; }
                    else
                    { pe_list_string[yypvt[-0].int_val - 1] = '1';
                      yyval.int_val = (long)TRUE;
                    }
                  }
                  else
                  { yyval.int_val = (long)FALSE; }
                } /*NOTREACHED*/ break;
case 422:
# line 3013 "parz.y"
{ register char *sp;
                  register int n;
                  register int min = (int)yypvt[-2].int_val;
                  register int max = (int)yypvt[-0].int_val;

                  if (pe_list_string)
                  { yyval.int_val = (long)TRUE;
                    if (min < 1 || min > pe_anz)
                    { komerr(texte[63], min); yyval.int_val = (long)FALSE; }
                    if (max < 1 || max > pe_anz)
                    { komerr(texte[63], max); yyval.int_val = (long)FALSE; }
                    if (yyval.int_val)
                    { if (min > max)
                      { komerr(texte[167], min, max); yyval.int_val = (long)FALSE; }
                      else
                      { for (n = min, sp = pe_list_string + min - 1;
                             n <= max;
                             n++, *(sp++) = '1');
                      }
                    }
                  }
                  else
                  { yyval.int_val = (long)FALSE; }
                } /*NOTREACHED*/ break;
case 427:
# line 3091 "parz.y"
{ yyval.int_val = 0l; } /*NOTREACHED*/ break;
case 428:
# line 3093 "parz.y"
{ yyval.int_val = (long)STEP_OVER; } /*NOTREACHED*/ break;
case 430:
# line 3107 "parz.y"
{ parse_start = -2;
                      if (!anz_fehler)
                      { if ((ARG_argsort(yypvt[-4].arg_def) & (IND | INDL)) &&
                            (ARG_indsort(yypvt[-4].arg_def) & VEC)) 
                        { komerr(texte[118]); }
                        else
                        { register STAT *stat_ptr;

                          if (stat_ptr = new_tr_stat())
                          { STAT_dblock(*stat_ptr) = dlptr(&yypvt[-1].decl_def);
                            STAT_vc2(*stat_ptr) = yypvt[-4].arg_def;
                            STAT_vc3(*stat_ptr) = yypvt[-3].arg_def;
                            more_on();
                            do_trace(stat_ptr);
                            more_off();
                          }
                        }
                      }
                    } /*NOTREACHED*/ break;
case 431:
# line 3129 "parz.y"
{ warnings_on = FALSE; } /*NOTREACHED*/ break;
case 432:
# line 3131 "parz.y"
{ warnings_on = TRUE; } /*NOTREACHED*/ break;
case 433:
# line 3133 "parz.y"
{ warnings_on = ((int)yypvt[-1].int_val > 0); } /*NOTREACHED*/ break;
case 436:
# line 3139 "parz.y"
{ if ((int)yypvt[-1].int_val > 0) pe_width = (int)yypvt[-1].int_val;
                      else komerr(texte[253]);
                    } /*NOTREACHED*/ break;
case 437:
# line 3145 "parz.y"
{ register EXPR *neu;

                      yyval.exprlist_info = yypvt[-2].exprlist_info;
                      if (yyval.exprlist_info.expr_array)
                      { if (!(neu =
                              (EXPR *)realloc(yyval.exprlist_info.expr_array,
                                                (size_t)(++yyval.exprlist_info.expr_count * sizeof(EXPR)))))
                        { yyval.exprlist_info.expr_count = 0;
                          free(yyval.exprlist_info.expr_array); yyval.exprlist_info.expr_array = NULL;
                          komerr(texte[80]);
                        }
                        else
                        { neu[yyval.exprlist_info.expr_count - 1] = yypvt[-0].expr_info;
                          yyval.exprlist_info.expr_array = neu;
                        }
                      }
                      akt_index_typ = index_typ1;
                    } /*NOTREACHED*/ break;
case 438:
# line 3164 "parz.y"
{ if (!(yyval.exprlist_info.expr_array = (EXPR *)calloc((size_t)1,
                                                           (size_t)sizeof(EXPR))))
                      { yyval.exprlist_info.expr_count = 0;
                        komerr(texte[80]);
                      }
                      else
                      { yyval.exprlist_info.expr_count = 1;
                        *yyval.exprlist_info.expr_array = yypvt[-0].expr_info;
                      }
                      akt_index_typ = index_typ1;
                    } /*NOTREACHED*/ break;
case 439:
# line 3178 "parz.y"
{ register char *yyd = yydisplay((int)yypvt[-1].int_val);

                      if (yyval.expr_info.expr_art = (yypvt[-2].expr_info.expr_art == EXPR_VAR &&
                                         yypvt[-0].sexpr_info.sexpr_art == EXPR_VAR))
                      { if (yyval.expr_info.expr_art = rel_ok(yypvt[-2].expr_info.typlast, (int)yypvt[-1].int_val, yypvt[-0].sexpr_info.typserg))
                        { if (yyval.expr_info.expr_str =
                                malloc((size_t)(strlen(yypvt[-2].expr_info.expr_str) +
                                                  strlen(yyd) +
                                                  strlen(yypvt[-0].sexpr_info.sexpr_str) + 3)))
                          { sprintf(yyval.expr_info.expr_str, "%s %s %s",
                                    yypvt[-2].expr_info.expr_str, yyd, yypvt[-0].sexpr_info.sexpr_str);
                            yyval.expr_info.expr_art = EXPR_VAR;
                            yyval.expr_info.typerg = para_typ[BOOL];
                            yyval.expr_info.lastval = yypvt[-0].sexpr_info.serg;
                            yyval.expr_info.typlast = obertyp(yypvt[-0].sexpr_info.typserg);
                            if (yypvt[-2].expr_info.typerg)
                            { ARG hvar;

                              para_relop(&hvar, &yypvt[-2].expr_info.lastval, yypvt[-2].expr_info.typlast, (int)yypvt[-1].int_val,
                                                &yypvt[-0].sexpr_info.serg, yyval.expr_info.typlast);
                              para_addop(&yyval.expr_info.erg, &yypvt[-2].expr_info.erg, AND, &hvar, yyval.expr_info.typerg);
                            }
                            else
                            { para_relop(&yyval.expr_info.erg, &yypvt[-2].expr_info.lastval, yypvt[-2].expr_info.typlast, (int)yypvt[-1].int_val,
                                                  &yypvt[-0].sexpr_info.serg, yyval.expr_info.typlast);
                            }
                          }
                          else
                          { yyval.expr_info.expr_art = EXPR_FALSCH;
                            komerr(texte[80]);
                          }
                        }
                        else
                        { komerr(texte[314], yyd); }
                      }
                      else
                      { if (yypvt[-2].expr_info.expr_art && yypvt[-2].expr_info.expr_art != EXPR_VAR)
                        { komerr(texte[306], yyd); }
                        if (yypvt[-0].sexpr_info.sexpr_art && yypvt[-0].sexpr_info.sexpr_art != EXPR_VAR)
                        { komerr(texte[307], yyd); }
                      }
                      akt_index_typ = index_typ1;
                      if (yypvt[-2].expr_info.expr_str) free(yypvt[-2].expr_info.expr_str);
                      if (yypvt[-0].sexpr_info.sexpr_str) free(yypvt[-0].sexpr_info.sexpr_str);
                    } /*NOTREACHED*/ break;
case 440:
# line 3224 "parz.y"
{ yyval.expr_info.expr_art = yypvt[-0].sexpr_info.sexpr_art;
                      yyval.expr_info.lastval = yypvt[-0].sexpr_info.serg;
                      yyval.expr_info.typlast = yypvt[-0].sexpr_info.typserg;
                      yyval.expr_info.typerg = 0;
                      yyval.expr_info.expr_str = yypvt[-0].sexpr_info.sexpr_str;
                    } /*NOTREACHED*/ break;
default : yyparse4(yytmp,yypvt);
}


}
