%{
/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : Parser
  Filename     : parz.y       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.parz.y
  Version      : 1.3 
  Last changed : 9/27/93 at 14:05:10        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : Parser fuer PARZ V2.x

******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/

static char sccs_id[] = "@(#)parz.y	1.3  9/27/93 PARZ - Parser (Frank Sembach)";

#include "parzdefs.h"
#include "komdefs.h"

%}

%union
 { long int_val;
   float real_val;
   unsigned char char_val;
   char *string_val;
   char *bitstring_val;
   char *comment;
   DECLIST decl_def;
   UNION_LIST union_def;
   TYP typ_def;
   ARG arg_def;
   CONLIST *conlist_ptr;
   RANGE range_val;
   MEMDECLIST memdeclist_val;
   RANGELIST *memlist_val;
   OPTPROC optproc_val;
   SCOPETAB *procidlist_val;
   long ident_key;
   ZEILE zeil_list;
   EXPRLIST exprlist_info;
   EXPR expr_info;
   SEXPR sexpr_info;
   SELECT select_info;
   EXPR_RANGE set_range;
 }
%token '+' PLUS '-' MINUS UMINUS '*' MAL '/' DURCH '^' MOD 
%token SQRT EXP LN SIN COS TAN ARCSIN ARCCOS ARCTAN ARCTANT ABS
%token AND OR FIRST LAST SUM PRODUCT MAX MIN
%token PROGRAMMSTART KOMMANDOSTART
%token <int_val> INTNUM INTKLAM
%token <real_val> REALNUM
%token <char_val> CHAR
%token <string_val> STRING
%token <bitstring_val> BITSTRING
%token <comment> ';'
%token EQ NE LT LE GT GE
/*     =  <> <  <= >  >= */
%token ':' '!' ',' '[' ']' '(' ')' AOP /* ':=' */
%token NIL MYTRUE MYFALSE TERMS EOL
%token MAXTRANS ACTTRANS DONE TERMCH SRESULT ID VRESULT
%token START PE PORTS STOP TO SCALAR VECTOR
%token RETURN HALT END ADDR NEW NOT
%token STATUS RANDOM MOVE EQUAL AS CONNECT BICONNECT AT DISCONNECT
%token STRCMP SIZE IF WHILE CALL GOTO READ WRITE DRAW WRITELN
%token LOAD WITH STORE TO REDUCE OF
%token PUSHS PUSHV POPS POPV
%token PROC PARALLEL PROPAGATE OUT IN SEND RECEIVE FROM CONNECTED NOP
%token B C I R U  S V
%token OPENINPUT OPENOUTPUT CLOSEINPUT CLOSEOUTPUT
%token GETPIXEL OPENW OPENABSW MOVETO LINETO SETPIXEL
%token WSIZE SETCOLOR SELECTW CLOSEW 
%token ERROR DEBUG TRACE NOTRACE
%token INITSET

%type <int_val> labeldef labqual label ArithOperator RelOperator func
%type <int_val> Qual OptReduce OptPeOrDecl

%type <decl_def> declaration ControlVarDecl LocalVarDecl

%type <union_def> UnionList

%type <typ_def> type

%type <arg_def> vardesc indirect VarConst variable SkaVar VekVar constant string

/*      Tokens fuer Kommandointerpreter     */
%token ',' '#' '\\' '{' '}' '.'
%token ZEILEND PP
       /* \n   .. */
%token LIST CONNECTIONS PATTERN STRINGMATCH
%token GO STEP SET OVER ALL COMPILER INTERPRETER
%token FILENAME
%token ASSIGN BREAKPOINT EXAMINE
%token EIN AUS RECORD KURZ LANG
%token SHOW MEMORY HEAP PARSTACK CALLSTACK CHAIN ACTIVITY
%token VARIABLE SPECIALS DEPTH
%token WARN CALLS MODE WIDTH QUIT HELP
%token <ident_key> IDENT
%token DIV POWER

%type <int_val> KommName offset setsign sign komlabel
%type <int_val> scalstack vecstack OptTiefe asoptions
%type <int_val> OptPeList pelist peel
%type <int_val> OptSpezList spezlist spezvar
%type <int_val> debopt protmod
%type <int_val> OptGoStep OptOver
%type <int_val> relation AddOperator MulOperator OperatorIdent

%type <decl_def> OptDecl

%type <conlist_ptr> conlist conpat

%type <range_val> range extpenum extportnum
%type <range_val> memel

%type <memdeclist_val> addrlist

%type <memlist_val> scalmemdecl vecmemdecl

%type <optproc_val> OptProc OptExProc

%type <procidlist_val> ProcIdList

%type <zeil_list> zeile

%type <exprlist_info> ExprList

%type <expr_info> expr

%type <sexpr_info> SimpleExpr term power factor designator

%type <sexpr_info> set SetSubranges

%type <sexpr_info> SelectSubrange SelectSubranges selection

%type <select_info> selections

%type <set_range> SetSubrange

%{
/*********************************************/
#include "externs.h"
#include "rundefs.h"
#include "runexts.h"
#include "komexts.h"
#include "debexts.h"
#include "funcs.h"

/* externs aus parz.l :  */
extern char *lies_comm(), *lies_zend();

extern char ausgeben;       /* Flag : Naechste Fehlermeldung ausgeben */
extern char bef_lesen;      /* Flag : Befehlstoken erwartet (Kommandointerp. ) */

extern FILE *yyin;          /* Eingabefile */
extern FILE *yyerfp;        /* File fuer Fehlermeldungen */
extern int yylineno;        /* Zeilenzaehler */
extern int anz_runwarnings; /* Zahl der ausgegebenen Warnungen zu einem SET-Kommando */

/*********************************************/

extern int yynerrs;         /* Zaehler fuer Fehlermeldungen */
#ifdef YYDEBUG
extern int yydebug;
#endif

char lesend, nospez;        /* Art des naechsten Zugriffs auf eine Variable */

char do_step = FALSE;           /* parser hat "#\n" zurueckgegeben */
char scanner_fehler = FALSE;    /* scanner hat in Zeile Fehler gemeldet */

int flags;                      /* Information ueber gelesene Schluesselworte */
int nach_end;                   /* Zaehlt Befehle nach dem letzten END-Befehl */
int last_label;                 /* letztes gelesenes Label */
int akt_max;                    /* maximale verfuegbare Programmadresse */

#define HEAP_ADRS 1
#define VEC_ADRS 2
char adrsort;                   /* Art der Adressen fuer memel */

STAT *stat_ptr;                 /* Zeiger auf momentan erzeugten Befehl */

struct func_ptrs
{ int (* do_f[2][REAL + 1])();
  int (* print_f)();
} op_funcs[OR - PLUS + 1] =     /* Zeiger auf Funktionen fuer unaere und binaere
                                   Operatoren */
{ { { { do_falsch, do_falsch, do_si_add, do_sr_add },       /* PLUS */
      { do_falsch, do_falsch, do_vi_add, do_vr_add } },
    print_add },
  { { { do_falsch, do_falsch, do_si_sub, do_sr_sub },       /* MINUS */
      { do_falsch, do_falsch, do_vi_sub, do_vr_sub } },
    print_sub },
  { { { do_falsch, do_falsch, do_si_minus, do_sr_minus },   /* UMINUS */
      { do_falsch, do_falsch, do_vi_minus, do_vr_minus } },
    print_minus },
  { { { do_falsch, do_falsch, do_si_mul, do_sr_mul },       /* MAL */
      { do_falsch, do_falsch, do_vi_mul, do_vr_mul } },
    print_mul },
  { { { do_falsch, do_falsch, do_si_div, do_sr_div },       /* DURCH */
      { do_falsch, do_falsch, do_vi_div, do_vr_div } },
    print_div },
  { { { do_falsch, do_falsch, do_si_mod, do_falsch },       /* MOD */
      { do_falsch, do_falsch, do_vi_mod, do_falsch } },
    print_mod },
  { { { do_falsch, do_falsch, do_falsch, do_sr_sqrt },      /* SQRT */
      { do_falsch, do_falsch, do_falsch, do_vr_sqrt } },
    print_sqrt },
  { { { do_falsch, do_falsch, do_falsch, do_sr_exp },       /* EXP */
      { do_falsch, do_falsch, do_falsch, do_vr_exp } },
    print_exp },
  { { { do_falsch, do_falsch, do_falsch, do_sr_ln },        /* LN */
      { do_falsch, do_falsch, do_falsch, do_vr_ln } },
    print_ln },
  { { { do_falsch, do_falsch, do_falsch, do_sr_sin },       /* SIN */
      { do_falsch, do_falsch, do_falsch, do_vr_sin } },
    print_sin },
  { { { do_falsch, do_falsch, do_falsch, do_sr_cos },       /* COS */
      { do_falsch, do_falsch, do_falsch, do_vr_cos } },
    print_cos },
  { { { do_falsch, do_falsch, do_falsch, do_sr_tan },       /* TAN */
      { do_falsch, do_falsch, do_falsch, do_vr_tan } },
    print_tan },
  { { { do_falsch, do_falsch, do_falsch, do_sr_arcsin },    /* ARCSIN */
      { do_falsch, do_falsch, do_falsch, do_vr_arcsin } },
    print_arcsin },
  { { { do_falsch, do_falsch, do_falsch, do_sr_arccos },    /* ARCCOS */
      { do_falsch, do_falsch, do_falsch, do_vr_arccos } },
    print_arccos },
  { { { do_falsch, do_falsch, do_falsch, do_sr_arctan },    /* ARCTAN */
      { do_falsch, do_falsch, do_falsch, do_vr_arctan } },
    print_arctan },
  { { { do_falsch, do_falsch, do_falsch, do_sr_arctant },   /* ARCTANT */
      { do_falsch, do_falsch, do_falsch, do_vr_arctant } },
    print_arctant },
  { { { do_falsch, do_falsch, do_si_abs, do_sr_abs },       /* ABS */
      { do_falsch, do_falsch, do_vi_abs, do_vr_abs } },
    print_abs },
  { { { do_sb_and, do_falsch, do_falsch, do_falsch },       /* AND */
      { do_vb_and, do_falsch, do_falsch, do_falsch } },
    print_and },
  { { { do_sb_or, do_falsch, do_falsch, do_falsch },        /* OR */
      { do_vb_or, do_falsch, do_falsch, do_falsch } },
    print_or }
};

struct
{ int (* do_rf[2])(), (* print_rf)();
} rel_op_funcs[GE - EQ + 1] =           /* Funktionen fuer Vergleichsbefehle */
{ { {do_s_eq, do_v_eq}, print_eq},
  { {do_s_ne, do_v_ne}, print_ne},
  { {do_s_lt, do_v_lt}, print_lt},
  { {do_s_le, do_v_le}, print_le},
  { {do_s_gt, do_v_gt}, print_gt},
  { {do_s_ge, do_v_ge}, print_ge}
};

int (* assign_do_funcs[2][REAL + 1][STR + 1])() =       /* Funktionen fuer Zuweisung */
{ { {do_sbb_zuw, do_falsch, do_sbi_zuw, do_sbr_zuw, do_falsch},
    {do_scb_zuw, do_scc_zuw, do_sci_zuw, do_falsch, do_scstr_zuw},
    {do_sib_zuw, do_sic_zuw, do_sii_zuw, do_sir_zuw, do_falsch},
    {do_srb_zuw, do_falsch, do_sri_zuw, do_srr_zuw, do_falsch}
  },
  { {do_vbb_zuw, do_falsch, do_vbi_zuw, do_vbr_zuw, do_falsch},
    {do_vcb_zuw, do_vcc_zuw, do_vci_zuw, do_falsch, do_vcstr_zuw},
    {do_vib_zuw, do_vic_zuw, do_vii_zuw, do_vir_zuw, do_falsch},
    {do_vrb_zuw, do_falsch, do_vri_zuw, do_vrr_zuw, do_falsch}
  }
};

int (* random_do_funcs[2][STR + 1])() =         /* Funktionen fuer RANDOM */
{ {do_sb_random, do_sc_random, do_si_random, do_sr_random, do_falsch},
  {do_vb_random, do_vc_random, do_vi_random, do_vr_random, do_falsch}
};

int (* strcmp_do_funcs[2][STR + 1][STR + 1])() =        /* Funktionen fuer STRCMP */
{ { {do_falsch, do_falsch, do_falsch, do_falsch, do_falsch},
    {do_falsch, do_scc_strcmp, do_falsch, do_falsch, do_scstr_strcmp},
    {do_falsch, do_falsch, do_falsch, do_falsch, do_falsch},
    {do_falsch, do_falsch, do_falsch, do_falsch, do_falsch},
    {do_falsch, do_sstrc_strcmp, do_falsch, do_falsch, do_sstrstr_strcmp}
  },
  { {do_falsch, do_falsch, do_falsch, do_falsch, do_falsch},
    {do_falsch, do_vcc_strcmp, do_falsch, do_falsch, do_vcstr_strcmp},
    {do_falsch, do_falsch, do_falsch, do_falsch, do_falsch},
    {do_falsch, do_falsch, do_falsch, do_falsch, do_falsch},
    {do_falsch, do_vstrc_strcmp, do_falsch, do_falsch, do_vstrstr_strcmp}
  }
};

int (* red_do_funcs[STR + 1][MIN - AND + 1])() =      /* Funktionen fuer REDUCE */
{ {do_b_reduce_and, do_b_reduce_or, do_reduce_first, do_reduce_last, do_falsch, do_falsch, do_b_reduce_max, do_b_reduce_min},
  {do_falsch, do_falsch, do_reduce_first, do_reduce_last, do_falsch, do_falsch, do_c_reduce_max, do_c_reduce_min},
  {do_falsch, do_falsch, do_reduce_first, do_reduce_last, do_i_reduce_sum, do_i_reduce_prod, do_i_reduce_max, do_i_reduce_min},
  {do_falsch, do_falsch, do_reduce_first, do_reduce_last, do_r_reduce_sum, do_r_reduce_prod, do_r_reduce_max, do_r_reduce_min},
  {do_falsch, do_falsch, do_falsch, do_falsch, do_falsch, do_falsch, do_falsch, do_falsch}
};

int (* read_do_funcs[2][REAL + 1])() =     /* Funktionen fuer READ */
{ { do_sb_read, do_sc_read, do_si_read, do_sr_read },
  { do_vb_read, do_vc_read, do_vi_read, do_vr_read } };

int (* write2_do_funcs[2][STR + 1])() =     /* Funktionen fuer WRITE (2 Argumente) */
{ { do_falsch, do_sstr2_write, do_si2_write, do_sr2_write, do_falsch },
  { do_falsch, do_vstr2_write, do_vi2_write, do_vr2_write, do_falsch } };

int (* draw2_do_funcs[STR + 1])() =        /* Funktionen fuer DRAW (2 Argumente) */
{ do_falsch, do_sstr2_draw, do_si2_draw, do_sr2_draw, do_falsch };

int (* writeln2_do_funcs[2][STR + 1])() =   /* Funktionen fuer WRITELN (2 Argumente) */
{ { do_falsch, do_sstr2_writeln, do_si2_writeln, do_sr2_writeln, do_falsch },
  { do_falsch, do_vstr2_write, do_vi2_write, do_vr2_write, do_falsch } };

int red_typs[MIN - AND + 1] =           /* erlaubte Typen fuer Reduktionsfunktionen : */
{ (1<<BOOL),                              /* AND */
  (1<<BOOL),                              /* OR */
  (1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL),  /* FIRST */
  (1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL),  /* LAST */
  (1<<INT | 1<<REAL),                     /* SUM */
  (1<<INT | 1<<REAL),                     /* PRODUCT */
  (1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL),  /* MAX */
  (1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL),  /* MIN */
};

extern AKTBLOCK *temp_a_block;         /* Zeiger auf Aktivierungsblock,
                                   der bei symbolischem Debuggen erzeugt wird 
                                   und von PROC vervollstaendigt werden muss */

extern char *ssstr[];           /* Texte fuer Singlestep-/Breakpointmodus */
extern char *protstr[];         /* Texte fuer Protokollmodus */

char *promptstr[2] = { "P> ", "P* " };

int graph_bef_exist;

%}

%%
Anfang  :   PROGRAMMSTART IntermediateProgram
        |   KOMMANDOSTART
                { show_prompt(); }
            KommandoList
                { komerr(texte[172]);
                  ueberlies_zeile();
                  yyerrok; yyclearin;
                  unputc('$'); parse_start = 2;
                }
            Anfang
        ;
IntermediateProgram     :   start
                              NumPe
                              NumPorts
                              ControlVarDecl
                                { flags = SCALAR_DA;
                                  glob_s_decl = $4;
                                }
                              LocalVarDecl
                                { flags = VECTOR_DA;
                                  glob_v_decl = $6;
                                }
                              StatementList
                            stop
                        ;
stop    :   STOP
                { yyerrok;
                  flags = STOP_DA;
                  end_test();
                }
        |   error
                { fehler(texte[8]);
                  flags = STOP_DA;
                  end_test();
                }
        ;
start   :   START
                { yyerrok;
                  flags = START_DA;
                }
        |   error
                { switch (flags)
                  { case STOP_DA :
                      warning(texte[9]);
                      return 0;
                    default :
                      if (!uebersetzen)
                      { fehler(texte[10]); }
                  }
                }
        ;
NumPe   :   INTNUM PE
                { yyerrok;
                  pe_anz = (int)$1;
                  flags = PE_DA;
                }
        |   error PE
                { yyerrok;
                  pe_anz = 0;
                  fehler(texte[11]);
                  flags = PE_DA;
                }
        |   error
                { fehler(texte[12]);
                  pe_anz = 0;
                }
        ;
NumPorts    :   INTNUM PORTS
                    { yyerrok;
                      port_anz = (int)$1;
                      create_pes();
                      if (abbruch) return 1;
                      flags = PORTS_DA;
                    }
            |   error PORTS
                    { yyerrok;
                      port_anz = 0;
                      fehler(texte[13]);
                      flags = PORTS_DA;
                    }
            |   error
                    { fehler(texte[14]);
                      port_anz = 0;
                    }
            ;
ControlVarDecl  :   scalar declaration
                        { $$ = $2; }
                |   scalar error
                        { null_dlist(&$$);
                          fehler(texte[16]);
                        }
                |   error
                        { null_dlist(&$$);
                          fehler(texte[17]);
                        }
                ;
scalar  :   SCALAR
                { yyerrok; }
        ;
LocalVarDecl    :   vector declaration
                        { $$ = $2; }
                |   vector error
                        { null_dlist(&$$);
                          fehler(texte[18]);
                        }
                |   error
                        { null_dlist(&$$);
                          fehler(texte[19]);
                        }
                ;
vector  :   VECTOR
                { yyerrok; }
        ;
declaration :   declaration type INTNUM
                    { DECL *neu;

                      $$ = $1;
                      if ($3)
                      { $$.typ_zahl[$2] += (int)$3;
                        $$.typ_zahl[SUMM] += (int)$3;
                        neu = neu_decl(&$$,FELD);
                        if (abbruch) return 1;
                        DECL_t(*neu) = $2;
                        DECL_zahl(*neu) = (int)$3;
                      }
                    }
            |   declaration INTKLAM '(' declaration ')'
                    { DECL *neu;
                      register TYP t;

                      $$ = $1;
                      if ($2 && $4.darray)
                      { for (t=BOOL; t<=SUMM; t++)
                        { $$.typ_zahl[t] += (int)$2 * $4.typ_zahl[t];
                        }
                        neu = neu_decl(&$$,KLAM);
                        if (abbruch) return 1;
                        DECL_wiederh(*neu) = (int)$2;
                        DECL_klamdecl(*neu) = $4;
                      }
                      else if ($4.darray)
                      { loesch_decl(&$4); }
                    }
            |   declaration U '(' UnionList ')'
                    { DECL *neu;
                      register TYP t;

                      $$ = $1;
                      for (t=BOOL; t<=SUMM; t++)
                      { $$.typ_zahl[t] += $4.utyp_anz[t];
                      }
                      neu = neu_decl(&$$,UNION);
                      if (abbruch) return 1;
                      DECL_ul(*neu) = $4;
                    }
            |   /* eps */
                    { null_dlist(&$$);
                    }
            ;
UnionList   :   UnionList ',' declaration
                    { $$ = $1;
                      neu_ulist(&$$, &$3);
                      if (abbruch) return 1;
                    }
            |   declaration
                    { register TYP t;

                      null_ulist(&$$);
                      neu_ulist(&$$, &$1);
                      if (abbruch) return 1;
                    }
            ;
type    :   B  { $$ = BOOL; }
        |   C  { $$ = CHA; }
        |   I  { $$ = INT; }
        |   R  { $$ = REAL; }
        ;
StatementList   :   StatementList Statement ';'
                        { yyerrok; ausgeben = TRUE;
                          STAT_comm_text(*stat_ptr) = $3;
                          nextstat();
                          if (abbruch) return 1;
                        }
                |   StatementList error
                        { funcs(do_falsch, print_falsch);
                          if (STAT_comm_text(*stat_ptr) = lies_comm())
                          { yyerrok; yyclearin;
                            if (!*STAT_comm_text(*stat_ptr))
                            { STAT_comm_text(*stat_ptr) = NULL; }
                          }
                          fehler(texte[20]);
                          nextstat();
                          if (abbruch) return 1;
                        }
                |   StatementList Statement error
                        { if (STAT_comm_text(*stat_ptr) = lies_zend())
                          { yyclearin; yyerrok;
                            if (!*STAT_comm_text(*stat_ptr))
                            { STAT_comm_text(*stat_ptr) = NULL; }
                          }
                          fehler_zahl++;
                          nextstat();
                          if (abbruch) return 1;
                        }
                |   /* eps */
                        { init_prog();
                          if (abbruch) return 1;
                        }
                ;
Statement   :   labeldef
                    { STAT_label(*stat_ptr) = (int)$1;
                      if ((int)$1 > 0)
                      { if ((int)$1 <= last_label)
                        { sem_warning(texte[22]); }
                        last_label = (int)$1;
                      }
                      if ((int)$1 > max_label) max_label = (int)$1;
                      lesend = nospez = FALSE;
                    }
                stat
            ;
labeldef    :   INTNUM labqual ':'
                    { yyerrok;
                      $$ = $1;
                      STAT_bpoint(*stat_ptr) = (int)$2;
                      if ($$ < 1l)
                      { sem_error(texte[23]); fehler_zahl++;
                      }
                    }
            |   /* eps */
                    { $$ = -1l;
                      STAT_bpoint(*stat_ptr) = 0;
                    }
            ;
labqual     :   /* eps */       { $$ = 0l; }
            |   '!'             { $$ = (long)COMP_BREAK;
                                  STAT_para_zeile(*stat_ptr) = 0;
                                }
            |   '!' INTNUM      { $$ = (long)COMP_BREAK;
                                  if ($2 > (long)max_source_zeile) max_source_zeile = (int)$2;
                                  STAT_para_zeile(*stat_ptr) = (int)$2;
                                }
            |   R               { $$ = (long)PROT_ON; }
            |   '!' R           { $$ = (long)(COMP_BREAK | PROT_ON);
                                  STAT_para_zeile(*stat_ptr) = 0;
                                }
            |   '!' INTNUM R    { $$ = (long)(COMP_BREAK | PROT_ON);
                                  if ($2 > (long)max_source_zeile) max_source_zeile = (int)$2;
                                  STAT_para_zeile(*stat_ptr) = (int)$2;
                                }
            ;
label   :   INTNUM
                { $$ = $1;
                  if ((int)$$ < 1)
                  { error(texte[23]); fehler_zahl++;
                  }
                }
        ;
stat    :   assignment
        |   computation
        |   movestat
        |   equalstat
        |   HALT
                { funcs(do_halt, print_halt);
                }
        |   END
                { funcs(do_end, print_end);
                  if (nach_end != stat_anz)
                  { sem_error(texte[26]);
                    fehler(texte[27]);
                    STAT_falsch(*(stat_ptr - nach_end - 1)) = TRUE;
                  }
                  nach_end = -1;
                }
        |   NOP
                { funcs(do_nop, print_nop);
                }
        |   connect
        |   disconnect
        |   gotostat
        |   ifstat
        |   whilestat
        |   callstat
        |   proc
        |   RETURN
                { funcs(do_return, print_return);
                }
        |   pushstat
        |   popstat
        |   parallel
        |   propagate
        |   send
        |   receive
        |   load
        |   store
        |   read
        |   write
        |   draw
        |   errorcall
        |   openinput
        |   CLOSEINPUT
                { funcs(do_closeinput, print_closeinput);
                }
        |   openoutput
        |   CLOSEOUTPUT
                { funcs(do_closeoutput, print_closeoutput);
                }
        |   GraphFunc
        |   GraphProc
        |   debug
        |   trace
        |   notrace
        |   initset
        ;
assignment  :   vardesc AOP les VarConst
                    { register int v_s = sign(ARG_argsort($1) & VEC);
                      register TYP tz = ARG_typ($1);
                      register TYP tq = ARG_valtyp($4);

                      funcs(assign_do_funcs[v_s][tz][tq],
                            print_zuw);
                      ska_vek_test(&$1,&$4);
                      if ((ARG_argsort($4) & (ADS | ADV)) && (tz != INT))
                      { sem_error(texte[28]);
                        fehler(texte[29]);
                        ARG_argsort($1) |= FALSCH;
                      }
                      if (tq == STR && tz != CHA)
                      { sem_error(texte[28]);
                        fehler(texte[30]);
                        ARG_argsort($4) |= FALSCH;
                      }
                      switch (tz)
                      { case BOOL : if (tq == CHA)
                                    { sem_error(texte[28]);
                                      fehler(texte[99]);
                                      ARG_argsort($4) |= FALSCH;
                                    }
                                    break;
                        case CHA  : if (tq == REAL)
                                    { sem_error(texte[28]);
                                      fehler(texte[100]);
                                      ARG_argsort($4) |= FALSCH;
                                    }
                                    break;
                        case REAL : if (tq == CHA)
                                    { sem_error(texte[28]);
                                      fehler(texte[103]);
                                      ARG_argsort($4) |= FALSCH;
                                    }
                      }
                      STAT_vc1(*stat_ptr) = $4;
                      STAT_verg(*stat_ptr) = $1;
                    }
            |   vardesc AOP '-' les VarConst
                    { register int v_s = sign(ARG_argsort($1) & VEC);

                      funcs(op_funcs[UMINUS-PLUS].do_f[v_s][ARG_typ($1)], print_minus);
                      ska_vek_test(&$1,&$5);
                      typ2_test(&$1, &$5, (1<<INT | 1<<REAL));
                      STAT_vc1(*stat_ptr) = $5;
                      STAT_verg(*stat_ptr) = $1;
                    }
            |   vardesc AOP NOT les VarConst
                    { funcs((ARG_argsort($1) & VEC) ? do_vb_not : do_sb_not,
                            print_not);
                      ska_vek_test(&$1,&$5);
                      typ2_test(&$1, &$5, (1<<BOOL));
                      STAT_vc1(*stat_ptr) = $5;
                      STAT_verg(*stat_ptr) = $1;
                    }
            |   vardesc AOP NEW declaration
                    { funcs((ARG_argsort($1) & VEC)? do_vi_new : do_si_new,
                            print_new);
                      typ1_test(&$1,(1<<INT));
                      STAT_dnew(*stat_ptr) = dlptr(&$4);
                      STAT_verg(*stat_ptr) = $1;
                    }
            |   vardesc AOP STATUS
                    { funcs(do_status, print_status);
                      if (ARG_argsort($1) & VEC)
                      { sem_error(texte[142]); fehler_zahl++;
                        ARG_argsort($1) |= FALSCH;
                      }
                      else
                      { typ1_test(&$1, (1<<BOOL)); }
                      STAT_verg(*stat_ptr) = $1;
                    }
            |   vardesc AOP RANDOM
                    { funcs(random_do_funcs[sign(ARG_argsort($1) & VEC)][ARG_typ($1)],
                            print_random);
                      typ1_test(&$1, (1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL));
                      STAT_verg(*stat_ptr) = $1;
                    }
            ;
computation :   vardesc AOP les VarConst ArithOperator VarConst
                    { ska_vek_test(&$1,&$4);
                      ska_vek_test(&$1,&$6);
                      if ((int)$5 == '^')
                      { register int weiter_test = TRUE;
                        register int v_s = sign(ARG_argsort($1) & VEC);

                        typ1_test(&$1,(1<<INT | 1<<REAL));
                        weiter_test = weiter_test && !(ARG_argsort($1) & FALSCH);
                        typ1_test(&$4,(1<<INT | 1<<REAL));
                        weiter_test = weiter_test && !(ARG_argsort($4) & FALSCH);
                        typ1_test(&$6,(1<<INT | 1<<REAL));
                        weiter_test = weiter_test && !(ARG_argsort($6) & FALSCH);
                        if (weiter_test)
                        { if (ARG_typ($1) == INT)
                          { funcs(v_s ? do_vii_pow : do_sii_pow, print_pow);
                            typ3_test(&$1, &$4, &$6, (1<<INT));
                          }
                          else if (ARG_typ($6) == INT)
                          { funcs(v_s ? do_vri_pow : do_sri_pow, print_pow);
                            typ2_test(&$1, &$4, (1<<REAL));
                          }
                          else
                          { funcs(v_s ? do_vrr_pow : do_srr_pow, print_pow);
                            typ2_test(&$1, &$4, (1<<REAL));
                          }
                        }
                        STAT_vc1(*stat_ptr) = $4;
                        STAT_vc2(*stat_ptr) = $6;
                        STAT_verg(*stat_ptr) = $1;
                      }
                      else
                      { typ3_test(&$1,&$4,&$6,
                                  ((int)$5 == AND || (int)$5 == OR) ? (1<<BOOL)
                                                                    : (1<<INT | 1<<REAL));
                        operation(&$1,&$4,(int)$5,&$6);
                      }
                    }
            |   vardesc AOP les VarConst RelOperator VarConst
                    { ska_vek_test(&$1,&$4);
                      ska_vek_test(&$1,&$6);
                      typ1_test(&$1,(1<<BOOL));
                      typ2_test(&$4,&$6,(1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL));
                      rel_operation(&$1,&$4,(int)$5,&$6);
                    }
            |   vardesc AOP les reduce
                    { if (ARG_argsort($1) & VEC)
                      { sem_error(texte[31]);
                        fehler(texte[32]);
                        ARG_argsort($1) |= FALSCH;
                      }
                      typ2_test(&$1,
                                &(STAT_vc1(*stat_ptr)),
                                (STAT_print_func(*stat_ptr) == print_proc_reduce)
                                  ? (1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL)
                                  : red_typs[STAT_red_fct(*stat_ptr) - AND]);
                      STAT_verg(*stat_ptr) = $1;
                    }
            |   vardesc AOP les connected
                    { if (!((ARG_argsort($1) & VEC) && ARG_typ($1) == INT))
                      { sem_error(texte[200]);
                        fehler(texte[201]);
                        ARG_argsort($1) |= FALSCH;
                      }
                      STAT_verg(*stat_ptr) = $1;
                    }
            |   vardesc AOP func les VarConst
                    { register int v_s = sign(ARG_argsort($1) & VEC);

                      funcs(op_funcs[(int)$3-PLUS].do_f[v_s][ARG_typ($1)],
                            op_funcs[(int)$3-PLUS].print_f);
                      ska_vek_test(&$1,&$5);
                      typ2_test(&$1,&$5,(((int)$3 == ABS) ? (1<<INT | 1<<REAL)
                                                          : (1<<REAL)));
                      STAT_vc1(*stat_ptr) = $5;
                      STAT_verg(*stat_ptr) = $1;
                    }
            |   vardesc AOP ARCTANT les VarConst VarConst
                    { register int v_s = sign(ARG_argsort($1) & VEC);

                      funcs(op_funcs[ARCTANT-PLUS].do_f[v_s][ARG_typ($1)], print_arctant);
                      ska_vek_test(&$1,&$5);
                      ska_vek_test(&$1,&$6);
                      typ3_test(&$1,&$5,&$6,(1<<REAL));
                      STAT_vc1(*stat_ptr) = $5;
                      STAT_vc2(*stat_ptr) = $6;
                      STAT_verg(*stat_ptr) = $1;
                    }
            |   vardesc AOP les STRCMP VarConst VarConst
                    { register int v_s = sign(ARG_argsort($1) & VEC);

                      funcs(strcmp_do_funcs[v_s][ARG_typ($5)][ARG_typ($6)],
                            print_strcmp);
                      ska_vek_test(&$1, &$5);
                      ska_vek_test(&$1, &$6);
                      typ1_test(&$1, (1<<INT));
                      typ1_test(&$5, (1<<CHA | 1<<STR));
                      if (ARG_typ($5) == CHA && (ARG_argsort($5) & CON))
                      { sem_error(texte[28]);
                        fehler(texte[68]);
                        ARG_argsort($5) |= FALSCH;
                      }
                      typ1_test(&$6, (1<<CHA | 1<<STR));
                      if (ARG_typ($6) == CHA && (ARG_argsort($6) & CON))
                      { sem_error(texte[28]);
                        fehler(texte[68]);
                        ARG_argsort($6) |= FALSCH;
                      }
                      STAT_verg(*stat_ptr) = $1;
                      STAT_vc1(*stat_ptr) = $5;
                      STAT_vc2(*stat_ptr) = $6;
                    }
            ;
ArithOperator   :   '+'  { $$ = (long)PLUS;}
                |   '-'  { $$ = (long)MINUS;}
                |   '*'  { $$ = (long)MAL;}
                |   '/'  { $$ = (long)DURCH;}
                |   '^'  { $$ = (long)'^';}
                |   MOD  { $$ = (long)MOD;}
                |   AND  { $$ = (long)AND;}
                |   OR   { $$ = (long)OR;}
                ;
RelOperator :   EQ  { $$ = (long)EQ;}
            |   NE  { $$ = (long)NE;}
            |   LT  { $$ = (long)LT;}
            |   LE  { $$ = (long)LE;}
            |   GT  { $$ = (long)GT;}
            |   GE  { $$ = (long)GE;}
            ;
func    :   ABS         { $$ = (long)ABS; }
        |   SQRT        { $$ = (long)SQRT; }
        |   EXP         { $$ = (long)EXP; }
        |   LN          { $$ = (long)LN; }
        |   SIN         { $$ = (long)SIN; }
        |   COS         { $$ = (long)COS; }
        |   TAN         { $$ = (long)TAN; }
        |   ARCSIN      { $$ = (long)ARCSIN; }
        |   ARCCOS      { $$ = (long)ARCCOS; }
        |   ARCTAN      { $$ = (long)ARCTAN; }
        ;
movestat    :   MOVE nsp vardesc TO vardesc AS declaration
                { funcs((ARG_argsort($5) & VEC) ? do_v_blockmove : do_s_blockmove,
                        print_blockmove);
                  ska_vek_test(&$5, &$3);
                  STAT_dblock(*stat_ptr) = dlptr(&$7);
                  STAT_vc2(*stat_ptr) = $3;
                  STAT_verg(*stat_ptr) = $5;
                }
            ;
equalstat   :   EQUAL nsp vardesc vardesc AS declaration
                { funcs(((ARG_argsort($3) & VEC) || (ARG_argsort($4) & VEC))
                        ? do_v_blockequal : do_s_blockequal,
                        print_blockequal);
                  STAT_dblock(*stat_ptr) = dlptr(&$6);
                  STAT_vc2(*stat_ptr) = $3;
                  STAT_vc3(*stat_ptr) = $4;
                }
            ;
connect     :   CONNECT les VarConst TO VarConst AT VarConst
                    { funcs(do_connect, print_connect);
                      port_nr_test(&$3);
                      STAT_out_port(*stat_ptr) = $3;
                      port_nr_test(&$5);
                      STAT_in_port(*stat_ptr) = $5;
                      typ1_test(&$7, (1<<INT));
                      STAT_vc1(*stat_ptr) = $7;
                    }
            |   BICONNECT les VarConst TO VarConst AT VarConst
                    { funcs(do_biconnect, print_biconnect);
                      port_nr_test(&$3);
                      STAT_out_port(*stat_ptr) = $3;
                      port_nr_test(&$5);
                      STAT_in_port(*stat_ptr) = $5;
                      typ1_test(&$7, (1<<INT));
                      STAT_vc1(*stat_ptr) = $7;
                    }
            ;
disconnect  :   DISCONNECT
                    { funcs(do_disconnect, print_disconnect);
                    }
            |   DISCONNECT les VarConst
                    { funcs(do_one_disconnect, print_one_disconnect);
                      port_nr_test(&$3);
                      STAT_out_port(*stat_ptr) = $3;
                    }
            ;
gotostat    :   GOTO label
                    { register int z;

                      funcs(do_goto, print_goto);
                      STAT_spr_ziel(*stat_ptr) = z = ziel(-(int)$2);
                      if (z >= 0)
                      { if (STAT_print_func(programm[z]) == print_proc)
                        { sem_error(texte[39]);
                          fehler(texte[25]);
                        }
                      }
                    }
            ;
ifstat  :   IF les VarConst OptRel CALL label
                { register int z;
                  register int v_s = (ARG_argsort($3) & VEC);

                  if (STAT_rel_tok(*stat_ptr))
                  { v_s |= (ARG_argsort(STAT_vc2(*stat_ptr)) & VEC);
                    typ2_test(&$3,&(STAT_vc2(*stat_ptr)),(1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL));
                    funcs(v_s ? do_v2_ifcall : do_s2_ifcall, print_ifcall);
                  }
                  else
                  { typ1_test(&$3,(1<<BOOL));
                    funcs(v_s ? do_v_ifcall : do_s_ifcall, print_ifcall);
                  }
                  STAT_vc1(*stat_ptr) = $3;
                  STAT_spr_ziel(*stat_ptr) = z = ziel(-(int)$6);
                  if (z >= 0)
                  { if (STAT_print_func(programm[z]) != print_proc)
                    { sem_error(texte[41]);
                      fehler(texte[42]);
                    }
                  }
                }
        |   IF les VarConst OptRel GOTO label
                { register int z;

                  if (ARG_argsort($3) & VEC)
                  { ARG_argsort($3) |= FALSCH;
                    sem_error(texte[34]);
                    fehler(texte[43]);
                  }
                  if (STAT_rel_tok(*stat_ptr) &&
                      (ARG_argsort(STAT_vc2(*stat_ptr)) & VEC))
                  { ARG_argsort(STAT_vc2(*stat_ptr)) |= FALSCH;
                    sem_error(texte[34]);
                    fehler(texte[43]);
                  }
                  if (STAT_rel_tok(*stat_ptr))
                  { typ2_test(&$3,&(STAT_vc2(*stat_ptr)),(1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL));
                    funcs(do_2_ifgoto, print_ifgoto);
                  }
                  else
                  { typ1_test(&$3,(1<<BOOL));
                    funcs(do_ifgoto, print_ifgoto);
                  }
                  STAT_vc1(*stat_ptr) = $3;
                  STAT_spr_ziel(*stat_ptr) = z = ziel(-(int)$6);
                  if (z >= 0)
                  { if (STAT_print_func(programm[z]) == print_proc)
                    { sem_error(texte[24]);
                      fehler(texte[25]);
                    }
                  }
                }
        ;
whilestat   :   WHILE les VarConst OptRel CALL label
                    { register int z;
                      register int v_s = (ARG_argsort($3) & VEC);

                      if (STAT_rel_tok(*stat_ptr))
                      { v_s |= (ARG_argsort(STAT_vc2(*stat_ptr)) & VEC);
                        typ2_test(&$3,&(STAT_vc2(*stat_ptr)),(1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL));
                        funcs(v_s ? do_v2_whilecall : do_s2_whilecall,
                              print_whilecall);
                      }
                      else
                      { typ1_test(&$3,(1<<BOOL));
                        funcs(v_s ? do_v_whilecall : do_s_whilecall,
                              print_whilecall);
                      }
                      STAT_vc1(*stat_ptr) = $3;
                      STAT_spr_ziel(*stat_ptr) = z = ziel(-(int)$6);
                      if (z >= 0)
                      { if (STAT_print_func(programm[z]) != print_proc)
                        { sem_error(texte[41]);
                          fehler(texte[42]);
                        }
                      }
                    }
            ;
OptRel  :   RelOperator VarConst
                { STAT_rel_tok(*stat_ptr) = (int)$1;
                  STAT_vc2(*stat_ptr) = $2;
                }
        |   /* eps */
                { STAT_rel_tok(*stat_ptr) = 0;
                }
        ;
callstat    :   CALL label
                    { register int z;

                      funcs(do_call, print_call);
                      STAT_spr_ziel(*stat_ptr) = z = ziel(-(int)$2);
                      if (z >= 0)
                      { if (STAT_print_func(programm[z]) != print_proc)
                        { sem_error(texte[50]);
                          fehler(texte[42]);
                        }
                      }
                    }
            ;
proc    :   PROC INTNUM
                { if ($2 < 1l)
                  { error(texte[51]);
                    fehler(texte[52]);
                  }
                }
            OptControlVarDecl OptLocalVarDecl
                { funcs(do_proc, print_proc);
                  STAT_proclev(*stat_ptr) = $2;
                  max_lev = ($2 > max_lev) ? $2 : max_lev;
                }
        ;
OptControlVarDecl   :   ControlVarDecl
                            { STAT_dscal(*stat_ptr) = dlptr(&$1);
                            }
                    |   /* eps */
                            { STAT_dscal(*stat_ptr) = dlptr(NULL);
                            }
                    ;
OptLocalVarDecl     :   LocalVarDecl
                            { STAT_dvec(*stat_ptr) = dlptr(&$1);
                            }
                    |   /* eps */
                            { STAT_dvec(*stat_ptr) = dlptr(NULL);
                            }
                    ;
pushstat    :   PUSHS les VarConst
                    { funcs(do_pushs, print_pushs);
                      if (ARG_argsort($3) & VEC)
                      { sem_error(texte[46]);
                        fehler(texte[47]);
                        ARG_argsort($3) |= FALSCH;
                      }
                      STAT_vc1(*stat_ptr) = $3;
                    }
            |   PUSHV les VarConst
                    { funcs((ARG_argsort($3) & VEC) ? do_v_pushv : do_s_pushv,
                            print_pushv);
                      STAT_vc1(*stat_ptr) = $3;
                    }
            ;
popstat :   POPS vardesc
                { funcs((ARG_argsort($2) & VEC) ? do_v_pops : do_s_pops,
                        print_pops);
                  STAT_verg(*stat_ptr) = $2;
                }
        |   POPV vardesc
                { funcs(do_popv, print_popv);
                  if (!(ARG_argsort($2) & VEC))
                  { ARG_argsort($2) |= FALSCH;
                    sem_error(texte[48]);
                    fehler(texte[49]);
                  }
                  STAT_verg(*stat_ptr) = $2;
                }
        ;
parallel    :   PARALLEL BITSTRING
                    { funcs(do_parbit, print_parbit);
                      STAT_parbits(*stat_ptr) = $2;
                      if (strlen($2) != pe_anz)
                      { error(texte[54]);
                        fehler(texte[55]);
                      }
                    }
            |   PARALLEL nsp VarConst
                    { if (ARG_argsort($3) & (VEC | ADS | ADV | CON | SPEZ))
                      { error(texte[54]);
                        fehler(texte[56]);
                        ARG_argsort($3) |= FALSCH;
                      }
                      funcs(do_parvar, print_parvar);
                      typ1_test(&$3,(1<<BOOL));
                      STAT_vc1(*stat_ptr) = $3;
                    }
            ;
connected   :   CONNECTED IN VarConst
                    { funcs(do_inconnected, print_inconnected);
                      port_nr_test(&$3);
                      STAT_cin_port(*stat_ptr) = $3;
                    }
            |   CONNECTED IN VarConst OUT VarConst
                    { funcs(do_line_inconnected, print_line_inconnected);
                      port_nr_test(&$3);
                      STAT_cin_port(*stat_ptr) = $3;
                      port_nr_test(&$5);
                      STAT_out_port(*stat_ptr) = $5;
                    }
            |   CONNECTED OUT VarConst
                    { funcs(do_outconnected, print_outconnected);
                      port_nr_test(&$3);
                      STAT_out_port(*stat_ptr) = $3;
                    }
            |   CONNECTED OUT VarConst IN VarConst
                    { funcs(do_line_outconnected, print_line_outconnected);
                      port_nr_test(&$3);
                      STAT_out_port(*stat_ptr) = $3;
                      port_nr_test(&$5);
                      STAT_cin_port(*stat_ptr) = $5;
                    }
            ;
propagate   :   PROPAGATE les VarConst OUT VarConst
                    { funcs(do_propagate, print_propagate);
                      if ( ( ARG_argsort($3) & (ADS | ADV | CON | SPEZ) ) ||
                           !(ARG_argsort($3) & VEC) )
                      { sem_error(texte[57]);
                        fehler(texte[58]);
                        ARG_argsort($3) |= FALSCH;
                      }
                      STAT_vc1(*stat_ptr) = $3;
                      port_nr_test(&$5);
                      STAT_out_port(*stat_ptr) = $5;
                    }
                IN VarConst
                    { port_nr_test(&$8);
                      STAT_in_port(*stat_ptr) = $8;
                    }
            |   PROPAGATE les VarConst TO schreib vardesc OptReduce
                    { if (!(ARG_argsort($6) & VEC))
                      { sem_error(texte[57]);
                        fehler(texte[82]);
                        ARG_argsort($6) |= FALSCH;
                      }
                      typ2_test(&$6, &$3, $7 > 0 ? red_typs[(int)$7 - AND]
                                                 : (1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL));
                      STAT_vc1(*stat_ptr) = $3;
                      STAT_verg(*stat_ptr) = $6;
                      switch ((int)lsign($7))
                      { case -1 :
                          { register int z;

                            STAT_red_fct(*stat_ptr) = z = ziel((int)$7);
                            funcs(do_redproc_propagate, print_redproc_propagate);
                            if (z >= 0)
                            { if (STAT_print_func(programm[z]) != print_proc)
                              { sem_error(texte[31]);
                                fehler(texte[42]);
                              }
                            }
                          }
                          break;
                        case 0  : STAT_red_fct(*stat_ptr) = AND - 1;
                                  funcs(do_to_propagate, print_to_propagate);
                                  break;
                        case 1  : STAT_red_fct(*stat_ptr) = (int)$7;
                                  funcs(do_to_propagate, print_to_propagate);
                                  break;
                      }
                    }
            ;
send    :   SEND les VarConst TO schreib vardesc OptReduce
                { if (!(ARG_argsort($6) & VEC))
                  { sem_error(texte[271]);
                    fehler(texte[82]);
                    ARG_argsort($6) |= FALSCH;
                  }
                  typ2_test(&$6, &$3, $7 > 0 ? red_typs[(int)$7 - AND]
                                             : (1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL));
                  STAT_vc1(*stat_ptr) = $3;
                  STAT_verg(*stat_ptr) = $6;
                  switch ((int)lsign($7))
                  { case -1 :
                      { register int z;

                        STAT_red_fct(*stat_ptr) = z = ziel((int)$7);
                        funcs(do_redproc_send, print_redproc_send);
                        if (z >= 0)
                        { if (STAT_print_func(programm[z]) != print_proc)
                          { sem_error(texte[31]);
                            fehler(texte[42]);
                          }
                        }
                      }
                      break;
                    case 0  : STAT_red_fct(*stat_ptr) = AND - 1;
                              funcs(do_send, print_send);
                              break;
                    case 1  : STAT_red_fct(*stat_ptr) = (int)$7;
                              funcs(do_send, print_send);
                              break;
                  }
                }
        ;
receive :   RECEIVE vardesc FROM les VarConst OptReduce
                { if (!(ARG_argsort($2) & VEC))
                  { sem_error(texte[272]);
                    fehler(texte[82]);
                    ARG_argsort($2) |= FALSCH;
                  }
                  typ2_test(&$2, &$5, $6 > 0 ? red_typs[(int)$6 - AND]
                                             : (1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL));
                  STAT_vc1(*stat_ptr) = $5;
                  STAT_verg(*stat_ptr) = $2;
                  switch ((int)lsign($6))
                  { case -1 :
                      { register int z;

                        STAT_red_fct(*stat_ptr) = z = ziel((int)$6);
                        funcs(do_redproc_receive, print_redproc_receive);
                        if (z >= 0)
                        { if (STAT_print_func(programm[z]) != print_proc)
                          { sem_error(texte[31]);
                            fehler(texte[42]);
                          }
                        }
                      }
                      break;
                    case 0  : STAT_red_fct(*stat_ptr) = AND - 1;
                              funcs(do_receive, print_receive);
                              break;
                    case 1  : STAT_red_fct(*stat_ptr) = (int)$6;
                              funcs(do_receive, print_receive);
                              break;
                  }
                }
        ;
OptReduce   :   REDUCE Qual
                    { $$ = $2; }
            |   /* eps */
                    { $$ = 0l; }
            ;
load    :   LOAD VarConst
                { if ( ( ARG_argsort($2) & (ADS | ADV | CON) ) ||
                       !(ARG_argsort($2) & VEC) )
                  { error(texte[85]);
                    fehler(texte[86]);
                    ARG_argsort($2) |= FALSCH;
                  }
                }
            WITH les VarConst
                { if (ARG_argsort($6) & (VEC | ADS | ADV | CON))
                  { error(texte[85]);
                    fehler(texte[87]);
                    ARG_argsort($6) |= FALSCH;
                  }
                }
            OptPeOrDecl
                { (int)$8 ? funcs(do_blockload, print_blockload)
                          : funcs(do_load, print_load);
                  typ2_test(&$2,&$6,(1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL));
                  STAT_vc1(*stat_ptr) = $6;
                  STAT_verg(*stat_ptr) = $2;
                }
        ;
store   :   STORE les VarConst
                { if ( ( ARG_argsort($3) & (ADS | ADV | CON) ) ||
                       !(ARG_argsort($3) & VEC) )
                  { error(texte[88]);
                    fehler(texte[86]);
                    ARG_argsort($3) |= FALSCH;
                  }
                }
            TO schreib VarConst
                { if (ARG_argsort($7) & (VEC | ADS | ADV | CON))
                  { error(texte[88]);
                    fehler(texte[87]);
                    ARG_argsort($7) |= FALSCH;
                  }
                }
            OptPeOrDecl
                { (int)$9 ? funcs(do_blockstore, print_blockstore)
                          : funcs(do_store, print_store);
                  typ2_test(&$7,&$3,(1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL));
                  STAT_vc1(*stat_ptr) = $3;
                  STAT_verg(*stat_ptr) = $7;
                }
        ;
OptPeOrDecl :   PE INTNUM
                    { $$ = 0l;
                      if ($2 < 1l || $2 > (long)pe_anz)
                      { sem_error(texte[63], (int)$2); fehler_zahl++;
                        STAT_pe_nr(*stat_ptr) = $2 ? -(int)$2 : pe_anz + 1;
                      }
                      else
                      { STAT_pe_nr(*stat_ptr) = (int)$2;
                      }
                    }
            |   AS declaration
                    { $$ = 1l;
                      STAT_dload(*stat_ptr) = dlptr(&$2);
                    }
            |   /* eps */
                    { $$ = 0l;
                      STAT_pe_nr(*stat_ptr) = 0;
                    }
        ;
reduce  :   REDUCE Qual OF VarConst
                { if ( ( ARG_argsort($4) & (ADS | ADV | CON) ) ||
                       !(ARG_argsort($4) & VEC) )
                  { error(texte[31]);
                    fehler(texte[89]);
                    ARG_argsort($4) |= FALSCH;
                  }
                  STAT_vc1(*stat_ptr) = $4;
                  if ((int)$2 > 0)
                  { STAT_red_fct(*stat_ptr) = (int)$2;
                    funcs(red_do_funcs[ARG_typ($4)][(int)$2 - AND], print_op_reduce);
                  }
                  else
                  { register int z;

                    STAT_red_fct(*stat_ptr) = z = ziel((int)$2);
                    funcs(do_proc_reduce, print_proc_reduce);
                    if (z >= 0)
                    { if (STAT_print_func(programm[z]) != print_proc)
                      { sem_error(texte[31]);
                        fehler(texte[42]);
                      }
                    }
                  }
                }
        ;
Qual    :   AND     { $$ = (long)AND; }
        |   OR      { $$ = (long)OR; }
        |   FIRST   { $$ = (long)FIRST; }
        |   LAST    { $$ = (long)LAST; }
        |   SUM     { $$ = (long)SUM; }
        |   PRODUCT { $$ = (long)PRODUCT; }
        |   MAX     { $$ = (long)MAX; }
        |   MIN     { $$ = (long)MIN; }
        |   label   { $$ = -$1; }
        ;
read    :   READ vardesc
                { funcs(read_do_funcs[sign(ARG_argsort($2) & VEC)][ARG_typ($2)],
                        print_read);
                  STAT_verg(*stat_ptr) = $2;
                }
        |   READ vardesc les VarConst
                { funcs(ARG_argsort($2) & VEC ? do_vread_string
                                              : do_sread_string,
                        print_read_string);
                  typ1_test(&$2,(1<<CHA));
                  if (ARG_argsort($4) & VEC)
                  { sem_error(texte[130]);
                    fehler(texte[132]);
                    ARG_argsort($4) |= FALSCH;
                  }
                  typ1_test(&$4,(1<<INT));
                  STAT_verg(*stat_ptr) = $2;
                  STAT_vc1(*stat_ptr) = $4;
                }
        ;
write   :   WRITE les VarConst
                { funcs(ARG_argsort($3) & VEC ? do_v1_write : do_s1_write,
                        print_1_write);
                  STAT_vc1(*stat_ptr) = $3;
                }
        |   WRITE les VarConst VarConst
                { funcs(write2_do_funcs[sign(ARG_argsort($3) & VEC)]
                                       [ARG_typ($3)],
                        print_2_write);
                  typ1_test(&$3,(1<<CHA | 1<<INT | 1<<REAL));
                  if (ARG_argsort($4) & VEC)
                  { sem_error(texte[133]);
                    fehler(texte[135]);
                    ARG_argsort($4) |= FALSCH;
                  }
                  typ1_test(&$4,(1<<INT));
                  STAT_vc1(*stat_ptr) = $3;
                  STAT_vc2(*stat_ptr) = $4;
                }
        |   WRITE les VarConst VarConst VarConst
                { funcs(ARG_argsort($3) & VEC ? do_vr3_write : do_sr3_write,
                        print_3_write);
                  typ1_test(&$3,(1<<REAL));
                  if (ARG_argsort($4) & VEC)
                  { sem_error(texte[133]);
                    fehler(texte[135]);
                    ARG_argsort($4) |= FALSCH;
                  }
                  typ1_test(&$4,(1<<INT));
                  if (ARG_argsort($5) & VEC)
                  { sem_error(texte[133]);
                    fehler(texte[136]);
                    ARG_argsort($5) |= FALSCH;
                  }
                  typ1_test(&$5,(1<<INT));
                  STAT_vc1(*stat_ptr) = $3;
                  STAT_vc2(*stat_ptr) = $4;
                  STAT_vc3(*stat_ptr) = $5;
                }
        |   WRITELN les VarConst
                { funcs(ARG_argsort($3) & VEC ? do_v1_writeln : do_s1_writeln,
                        print_1_writeln);
                  STAT_vc1(*stat_ptr) = $3;
                }
        |   WRITELN les VarConst VarConst
                { funcs(writeln2_do_funcs[sign(ARG_argsort($3) & VEC)]
                                         [ARG_typ($3)],
                        print_2_writeln);
                  typ1_test(&$3,(1<<CHA | 1<<INT | 1<<REAL));
                  if (ARG_argsort($4) & VEC)
                  { sem_error(texte[137]);
                    fehler(texte[135]);
                    ARG_argsort($4) |= FALSCH;
                  }
                  typ1_test(&$4,(1<<INT));
                  STAT_vc1(*stat_ptr) = $3;
                  STAT_vc2(*stat_ptr) = $4;
                }
        |   WRITELN les VarConst VarConst VarConst
                { funcs(ARG_argsort($3) & VEC ? do_vr3_write : do_sr3_writeln,
                        print_3_writeln);
                  typ1_test(&$3,(1<<REAL));
                  if (ARG_argsort($4) & VEC)
                  { sem_error(texte[137]);
                    fehler(texte[135]);
                    ARG_argsort($4) |= FALSCH;
                  }
                  typ1_test(&$4,(1<<INT));
                  if (ARG_argsort($5) & VEC)
                  { sem_error(texte[137]);
                    fehler(texte[136]);
                    ARG_argsort($5) |= FALSCH;
                  }
                  typ1_test(&$5,(1<<INT));
                  STAT_vc1(*stat_ptr) = $3;
                  STAT_vc2(*stat_ptr) = $4;
                  STAT_vc3(*stat_ptr) = $5;
                }
        ;
draw    :   DRAW les VarConst
                { if (ARG_argsort($3) & VEC)
                  { sem_error(texte[134]);
		    fehler(texte[131]);
		    ARG_argsort($3) |= FALSCH;
		  }
		  funcs(do_s1_draw, print_1_draw);
                  STAT_vc1(*stat_ptr) = $3;
                  graph_bef_exist = TRUE;
                }
        |   DRAW les VarConst VarConst
                { if (ARG_argsort($3) & VEC)
                  { sem_error(texte[134]);
		    fehler(texte[131]);
		    ARG_argsort($3) |= FALSCH;
		  }
		  funcs(draw2_do_funcs[ARG_typ($3)], print_2_draw);
                  typ1_test(&$3, (1<<CHA | 1<<INT | 1<<REAL));
                  if (ARG_argsort($4) & VEC)
                  { sem_error(texte[134]);
                    fehler(texte[135]);
                    ARG_argsort($4) |= FALSCH;
                  }
                  typ1_test(&$4,(1<<INT));
                  STAT_vc1(*stat_ptr) = $3;
                  STAT_vc2(*stat_ptr) = $4;
                  graph_bef_exist = TRUE;
                }
        |   DRAW les VarConst VarConst VarConst
                { if (ARG_argsort($3) & VEC)
                  { sem_error(texte[134]);
		    fehler(texte[131]);
		    ARG_argsort($3) |= FALSCH;
		  }
		  funcs(do_sr3_draw, print_3_draw);
                  typ1_test(&$3,(1<<REAL));
                  if (ARG_argsort($4) & VEC)
                  { sem_error(texte[134]);
                    fehler(texte[135]);
                    ARG_argsort($4) |= FALSCH;
                  }
                  typ1_test(&$4,(1<<INT));
                  if (ARG_argsort($5) & VEC)
                  { sem_error(texte[134]);
                    fehler(texte[136]);
                    ARG_argsort($5) |= FALSCH;
                  }
                  typ1_test(&$5,(1<<INT));
                  STAT_vc1(*stat_ptr) = $3;
                  STAT_vc2(*stat_ptr) = $4;
                  STAT_vc3(*stat_ptr) = $5;
                  graph_bef_exist = TRUE;
                }
            ;
errorcall   :   ERROR string
                    { funcs(do_errorcall,print_errorcall);
                      STAT_vc1(*stat_ptr) = $2;
                    }
            ;
openinput   :   OPENINPUT les nsp VarConst
                    { funcs(do_openinput, print_openinput);
                      if ( ( ARG_argsort($4) & VEC ) ||
                           ( ARG_typ($4) == CHA && (ARG_argsort($4) & CON) ) )
                      { sem_error(texte[143]);
                        fehler(texte[144]);
                        ARG_argsort($4) |= FALSCH;
                      }
                      typ1_test(&$4,(1<<CHA | 1<<STR));
                      STAT_vc1(*stat_ptr) = $4;
                    }
            ;
openoutput  :   OPENOUTPUT les nsp VarConst
                    { funcs(do_openoutput, print_openoutput);
                      if ( ( ARG_argsort($4) & VEC ) ||
                           ( ARG_typ($4) == CHA && (ARG_argsort($4) & CON) ) )
                      { sem_error(texte[145]);
                        fehler(texte[144]);
                        ARG_argsort($4) |= FALSCH;
                      }
                      typ1_test(&$4,(1<<CHA | 1<<STR));
                      STAT_vc1(*stat_ptr) = $4;
                    }
            ;
GraphFunc   :   vardesc AOP GETPIXEL les VarConst VarConst
                    { register int flag = FALSE;

                      funcs(do_getpixel, print_getpixel);
                      if (ARG_argsort($1) & VEC)
                      { flag = TRUE;
                        ARG_argsort($1) |= FALSCH;
                      }
                      if (ARG_argsort($5) & VEC)
                      { flag = TRUE;
                        ARG_argsort($5) |= FALSCH;
                      }
                      if (ARG_argsort($6) & VEC)
                      { flag = TRUE;
                        ARG_argsort($6) |= FALSCH;
                      }
                      if (flag)
                      { sem_error(texte[273]);
                        fehler(texte[282]);
                      }
                      typ3_test(&$1, &$5, &$6, (1<<INT));
                      STAT_verg(*stat_ptr) = $1;
                      STAT_vc1(*stat_ptr) = $5;
                      STAT_vc2(*stat_ptr) = $6;
                      graph_bef_exist = TRUE;
                    }
            |   vardesc AOP OPENW les VarConst VarConst
                    { register int flag = FALSE;

                      funcs(do_openw, print_openw);
                      if (ARG_argsort($1) & VEC)
                      { flag = TRUE;
                        ARG_argsort($1) |= FALSCH;
                      }
                      if (ARG_argsort($5) & VEC)
                      { flag = TRUE;
                        ARG_argsort($5) |= FALSCH;
                      }
                      if (ARG_argsort($6) & VEC)
                      { flag = TRUE;
                        ARG_argsort($6) |= FALSCH;
                      }
                      if (flag)
                      { sem_error(texte[274]);
                        fehler(texte[282]);
                      }
                      typ1_test(&$1, (1<<INT));
                      typ2_test(&$5, &$6, (1<<REAL));
                      STAT_verg(*stat_ptr) = $1;
                      STAT_vc1(*stat_ptr) = $5;
                      STAT_vc2(*stat_ptr) = $6;
                      graph_bef_exist = TRUE;
                    }
            |   vardesc AOP OPENABSW les VarConst VarConst
                    { register int flag = FALSE;

                      funcs(do_openabsw, print_openabsw);
                      if (ARG_argsort($1) & VEC)
                      { flag = TRUE;
                        ARG_argsort($1) |= FALSCH;
                      }
                      if (ARG_argsort($5) & VEC)
                      { flag = TRUE;
                        ARG_argsort($5) |= FALSCH;
                      }
                      if (ARG_argsort($6) & VEC)
                      { flag = TRUE;
                        ARG_argsort($6) |= FALSCH;
                      }
                      if (flag)
                      { sem_error(texte[352]);
                        fehler(texte[282]);
                      }
                      typ1_test(&$1, (1<<INT));
                      typ2_test(&$5, &$6, (1<<INT));
                      STAT_verg(*stat_ptr) = $1;
                      STAT_vc1(*stat_ptr) = $5;
                      STAT_vc2(*stat_ptr) = $6;
                      graph_bef_exist = TRUE;
                    }
            ;
GraphProc   :   MOVETO les VarConst VarConst
                    { register int flag = FALSE;

                      funcs(do_moveto, print_moveto);
                      if (ARG_argsort($3) & VEC)
                      { flag = TRUE;
                        ARG_argsort($3) |= FALSCH;
                      }
                      if (ARG_argsort($4) & VEC)
                      { flag = TRUE;
                        ARG_argsort($4) |= FALSCH;
                      }
                      if (flag)
                      { sem_error(texte[275]);
                        fehler(texte[282]);
                      }
                      typ2_test(&$3, &$4, (1<<INT));
                      STAT_vc1(*stat_ptr) = $3;
                      STAT_vc2(*stat_ptr) = $4;
                      graph_bef_exist = TRUE;
                    }
            |   LINETO les VarConst VarConst
                    { register int flag = FALSE;

                      funcs(do_lineto, print_lineto);
                      if (ARG_argsort($3) & VEC)
                      { flag = TRUE;
                        ARG_argsort($3) |= FALSCH;
                      }
                      if (ARG_argsort($4) & VEC)
                      { flag = TRUE;
                        ARG_argsort($4) |= FALSCH;
                      }
                      if (flag)
                      { sem_error(texte[276]);
                        fehler(texte[282]);
                      }
                      typ2_test(&$3, &$4, (1<<INT));
                      STAT_vc1(*stat_ptr) = $3;
                      STAT_vc2(*stat_ptr) = $4;
                      graph_bef_exist = TRUE;
                    }
            |   SETPIXEL les VarConst VarConst
                    { register int flag = FALSE;

                      funcs((ARG_argsort($3) & VEC) ||
			    (ARG_argsort($4) & VEC)   ? do_v_setpixel
			                              : do_s_setpixel,
			    print_setpixel);
                      typ2_test(&$3, &$4, (1<<INT));
                      STAT_vc1(*stat_ptr) = $3;
                      STAT_vc2(*stat_ptr) = $4;
                      graph_bef_exist = TRUE;
                    }
            |   WSIZE vardesc vardesc
                    { register int flag = FALSE;

                      funcs(do_wsize, print_wsize);
                      if (ARG_argsort($2) & VEC)
                      { flag = TRUE;
                        ARG_argsort($2) |= FALSCH;
                      }
                      if (ARG_argsort($3) & VEC)
                      { flag = TRUE;
                        ARG_argsort($3) |= FALSCH;
                      }
                      if (flag)
                      { sem_error(texte[278]);
                        fehler(texte[282]);
                      }
                      typ2_test(&$2, &$3, (1<<INT));
                      STAT_vc1(*stat_ptr) = $2;
                      STAT_vc2(*stat_ptr) = $3;
                      graph_bef_exist = TRUE;
                    }
            |   SETCOLOR nsp vardesc
                    { funcs(ARG_argsort($3) & VEC ? do_v_setcolor : do_s_setcolor,
			    print_setcolor);
                      typ1_test(&$3, (1<<INT));
                      STAT_vc1(*stat_ptr) = $3;
                      graph_bef_exist = TRUE;
                    }
            |   SELECTW les VarConst
                    { funcs(do_selectw, print_selectw);
                      if (ARG_argsort($3) & VEC)
                      { sem_error(texte[280]);
                        fehler(texte[282]);
                        ARG_argsort($3) |= FALSCH;
                      }
                      typ1_test(&$3, (1<<INT));
                      STAT_vc1(*stat_ptr) = $3;
                      graph_bef_exist = TRUE;
                    }
            |   CLOSEW les VarConst
                    { funcs(do_closew, print_closew);
                      if (ARG_argsort($3) & VEC)
                      { sem_error(texte[279]);
                        fehler(texte[282]);
                        ARG_argsort($3) |= FALSCH;
                      }
                      typ1_test(&$3, (1<<INT));
                      STAT_vc1(*stat_ptr) = $3;
                      graph_bef_exist = TRUE;
                    }
            ;
debug   :   DEBUG les vardesc string AS declaration
                    { funcs(do_debug, print_debug);
                      STAT_dblock(*stat_ptr) = dlptr(&$6);
                      STAT_vc2(*stat_ptr) = $3;
                      STAT_vc3(*stat_ptr) = $4;
                    }
        ;
trace   :   TRACE nsp vardesc string AS declaration
                    { funcs(do_trace, print_trace);
                      if ((ARG_argsort($3) & (IND | INDL)) &&
                          (ARG_indsort($3) & VEC)) 
                      { sem_error(texte[117]);
                        fehler(texte[118]);
                        ARG_indsort($3) |= FALSCH;
                      }
                      STAT_dblock(*stat_ptr) = dlptr(&$6);
                      STAT_vc2(*stat_ptr) = $3;
                      STAT_vc3(*stat_ptr) = $4;
                    }
        ;
notrace :   NOTRACE
                    { funcs(do_notrace, print_notrace);
                      ARG_argsort(STAT_vc1(*stat_ptr)) = KEINER;
                    }
        |   NOTRACE nsp vardesc
                    { funcs(do_notrace, print_notrace);
                      if ((ARG_argsort($3) & (IND | INDL)) &&
                          (ARG_indsort($3) & VEC)) 
                      { sem_error(texte[120]);
                        fehler(texte[118]);
                        ARG_indsort($3) |= FALSCH;
                      }
                      STAT_vc1(*stat_ptr) = $3;
                    }
        ;
initset :   vardesc AOP INITSET BITSTRING
                { funcs(ARG_argsort($1) & VEC ? do_v_initset : do_s_initset,
                        print_initset);
                  if (ARG_typ($1) != BOOL)
                  { error(texte[316]);
                    fehler(texte[317]);
                    ARG_argsort($1) |= FALSCH;
                  }
                  STAT_verg(*stat_ptr) = $1;
                  STAT_setbits(*stat_ptr) = $4;
                }
        ;
VarConst    :   vardesc
                    { $$ = $1; }
            |   constant
                    { $$ = $1; }
            |   ADDR nsp variable
                    { $$ = $3;
                      ARG_argsort($$) = (ARG_argsort($3) & ~VEC) |
                                        ((ARG_argsort($3) & VEC) ? ADV : ADS);
                      nospez = FALSE;
                    }
            ;
vardesc :   variable
                { $$ = $1; }
        |   indirect
                { $$ = $1; }
        ;
indirect    :   S type '[' nsp variable ']'
                    { $$ = $5;
                      ARG_indsort($$) = ARG_argsort($$);
                      ARG_argsort($$) = $2 | IND | (ARG_indsort($$) & SPEZ);
                      if (ARG_indsort($$) & VEC)
                      { error(texte[34]);
                        fehler(texte[35]);
                        ARG_indsort($$) |= FALSCH;
                      }
                      if (ARG_indtyp($$) != INT)
                      { error(texte[28]);
                        fehler(texte[33]);
                        ARG_indsort($$) |= FALSCH;
                      }
                      nospez = FALSE;
                    }
            |   V type '[' nsp variable ']'
                    { $$ = $5;
                      ARG_indsort($$) = ARG_argsort($$);
                      ARG_argsort($$) = $2 | VEC | IND | (ARG_indsort($$) & SPEZ);
                      if (ARG_indtyp($$) != INT)
                      { error(texte[28]);
                        fehler(texte[33]);
                        ARG_indsort($$) |= FALSCH;
                      }
                      nospez =  FALSE;
                    }
            |   S type INTNUM ':' '[' nsp variable ']'
                    { $$ = $7;
                      ARG_indsort($$) = ARG_argsort($$);
                      ARG_vartiefe($$) = (int)$3;
                      ARG_argsort($$) = $2 | INDL | (ARG_indsort($$) & SPEZ);
                      if (ARG_indsort($$) & VEC)
                      { error(texte[34]);
                        fehler(texte[35]);
                        ARG_indsort($$) |= FALSCH;
                      }
                      if (ARG_indtyp($$) != INT)
                      { error(texte[28]);
                        fehler(texte[33]);
                        ARG_indsort($$) |= FALSCH;
                      }
                      nospez = FALSE;
                    }
            |   V type INTNUM ':' '[' nsp variable ']'
                    { $$ = $7;
                      ARG_indsort($$) = ARG_argsort($$);
                      ARG_vartiefe($$) = (int)$3;
                      ARG_argsort($$) = $2 | VEC | INDL | (ARG_indsort($$) & SPEZ);
                      if (ARG_indtyp($$) != INT)
                      { error(texte[28]);
                        fehler(texte[33]);
                        ARG_indsort($$) |= FALSCH;
                      }
                      nospez =  FALSE;
                    }
            ;
variable    :   SkaVar
                    { $$ = $1; }
            |   VekVar
                    { $$ = $1; }
            ;
SkaVar  :   S type INTNUM ':' INTNUM
                { ARG_argsort($$) = $2;
                  ARG_tiefe($$) = (int)$3;
                  ARG_num($$) = (int)$5;
                  ARG_gut_proc($$) = -2;
                  if ((int)$3 == 0)
                  { if (!set_absoffs($2, (int)$5, &$$, &glob_s_decl, -1))
                    { error(texte[34]);
                      fehler(texte[36]);
                      ARG_argsort($$) |= FALSCH;
                    }
                  }
                  else
                  { if ((int)$5 == 0)
                    { error(texte[34]);
                      fehler(texte[36]);
                      ARG_argsort($$) |= FALSCH;
                    }
                  }
                }
        |   MAXTRANS
                { ARG_argsort($$) = SPEZ | INT;
                  ARG_vartok($$) = MAXTRANS;
                  if (nospez)
                  { error(texte[34]);
                    fehler(texte[44]);
                    ARG_argsort($$) |= FALSCH;
                  }
                  else if (lesend)
                  { error(texte[34]);
                    fehler(texte[37]);
                    ARG_argsort($$) |= FALSCH;
                  }
                }
        |   ACTTRANS
                { ARG_argsort($$) = SPEZ | INT;
                  ARG_vartok($$) = ACTTRANS;
                  if (nospez)
                  { error(texte[34]);
                    fehler(texte[44]);
                    ARG_argsort($$) |= FALSCH;
                  }
                  else if (!lesend)
                  { error(texte[34]);
                    fehler(texte[38]);
                    ARG_argsort($$) |= FALSCH;
                  }
                }
        |   DONE
                { ARG_argsort($$) = SPEZ | BOOL;
                  ARG_vartok($$) = DONE;
                  if (nospez)
                  { error(texte[34]);
                    fehler(texte[44]);
                    ARG_argsort($$) |= FALSCH;
                  }
                  else if (!lesend)
                  { error(texte[34]);
                    fehler(texte[38]);
                    ARG_argsort($$) |= FALSCH;
                  }
                }
        |   TERMCH
                { ARG_argsort($$) = SPEZ | CHA;
                  ARG_vartok($$) = TERMCH;
                  if (nospez)
                  { error(texte[34]);
                    fehler(texte[44]);
                    ARG_argsort($$) |= FALSCH;
                  }
                  else if (!lesend)
                  { error(texte[34]);
                    fehler(texte[38]);
                    ARG_argsort($$) |= FALSCH;
                  }
                }
        |   SRESULT
                { ARG_argsort($$) = SPEZ | BOOL;
                  ARG_vartok($$) = SRESULT;
                  if (nospez)
                  { error(texte[34]);
                    fehler(texte[44]);
                    ARG_argsort($$) |= FALSCH;
                  }
                  else if (!lesend)
                  { error(texte[34]);
                    fehler(texte[38]);
                    ARG_argsort($$) |= FALSCH;
                  }
                }
        ;
VekVar  :   V type INTNUM ':' INTNUM
                { ARG_argsort($$) = $2 | VEC;
                  ARG_tiefe($$) = (int)$3;
                  ARG_num($$) = (int)$5;
                  ARG_gut_proc($$) = -2;
                  if ((int)$3 == 0)
                  { if (!set_absoffs($2, (int)$5, &$$, &glob_v_decl, -1))
                    { error(texte[34]);
                      fehler(texte[36]);
                      ARG_argsort($$) |= FALSCH;
                    }
                  }
                  else
                  { if ((int)$5 == 0)
                    { error(texte[34]);
                      fehler(texte[36]);
                      ARG_argsort($$) |= FALSCH;
                    }
                  }
                }
        |   ID
                { ARG_argsort($$) = SPEZ | VEC | INT;
                  ARG_vartok($$) = ID;
                  if (nospez)
                  { error(texte[34]);
                    fehler(texte[44]);
                    ARG_argsort($$) |= FALSCH;
                  }
                  else if (!lesend)
                  { error(texte[34]);
                    fehler(texte[38]);
                    ARG_argsort($$) |= FALSCH;
                  }
                }
        |   VRESULT
                { ARG_argsort($$) = SPEZ | VEC | BOOL;
                  ARG_vartok($$) = VRESULT;
                  if (nospez)
                  { error(texte[34]);
                    fehler(texte[44]);
                    ARG_argsort($$) |= FALSCH;
                  }
                  else if (!lesend)
                  { error(texte[34]);
                    fehler(texte[38]);
                    ARG_argsort($$) |= FALSCH;
                  }
                }
        ;
constant    :   MYTRUE
                    { ARG_argsort($$) = CON | BOOL;
                      ARG_con_wert($$).datentyp = BOOL | BOOL_ERLAUBT;
                      ARG_con_wert($$).inhalt.b_val = TRUE;
                    }
            |   MYFALSE
                    { ARG_argsort($$) = CON | BOOL;
                      ARG_con_wert($$).datentyp = BOOL | BOOL_ERLAUBT;
                      ARG_con_wert($$).inhalt.b_val = FALSE;
                    }
            |   NIL
                    { ARG_argsort($$) = CON | INT | SPEZ;
                      ARG_con_wert($$).datentyp = INT | INT_ERLAUBT;
                      ARG_con_wert($$).inhalt.i_val = 0;
                    }
            |   TERMS
                    { ARG_argsort($$) = CON | CHA | SPEZ;
                      ARG_con_wert($$).datentyp = CHA | CHA_ERLAUBT;
                      ARG_con_wert($$).inhalt.c_val = TERMS_CHAR;
                    }
            |   EOL
                    { ARG_argsort($$) = CON | CHA | SPEZ;
                      ARG_con_wert($$).datentyp = CHA | CHA_ERLAUBT;
                      ARG_con_wert($$).inhalt.c_val = EOL_CHAR;
                    }
            |   CHAR
                    { ARG_argsort($$) = CON | CHA;
                      ARG_con_wert($$).datentyp = CHA | CHA_ERLAUBT;
                      ARG_con_wert($$).inhalt.c_val = $1;
                    }
            |   INTNUM
                    { ARG_argsort($$) = CON | INT;
                      ARG_con_wert($$).datentyp = INT | INT_ERLAUBT;
                      ARG_con_wert($$).inhalt.i_val = $1;
                    }
            |   REALNUM
                    { ARG_argsort($$) = CON | REAL;
                      if (fperror)
                      { fperror = FALSE;
                        error(texte[40]);
                        fehler_zahl++;
                        ARG_argsort($$) |= FALSCH;
                      }
                      ARG_con_wert($$).datentyp = REAL | REAL_ERLAUBT;
                      ARG_con_wert($$).inhalt.r_val = $1;
                    }
            |   SIZE '(' declaration ')'
                    { ARG_argsort($$) = INT | CON | SIZ;
                      ARG_sizedec($$) = dlptr(&$3);
                    }
            |   string
                    { $$ = $1; }
            ;
string  :   STRING
                { ARG_argsort($$) = STR | CON;
                  ARG_con_wert($$).datentyp = STR ;
                  ARG_con_wert($$).inhalt.s_val = $1;
                }
        ;
les     :   /* eps */ { lesend = TRUE; }
        ;
schreib :   /* eps */ { lesend = FALSE; }
        ;
nsp     :   /* eps */ { nospez = TRUE; }
        ;

KommandoList    :   /* ***************  Kommandointerpreter  ***************** */
                    KommandoList Kommando
                        { yyerrok;
                          show_prompt();
                        }
                |   KommandoList error
                        { ups();
                          ueberlies_zeile();
                          yyerrok; yyclearin;
                          show_prompt();
                        }
                    KommandoList
                |   KommandoList ZEILEND
                        { if ((forced_break || stepping_to) && !scanner_fehler)
                          { unputc('\n'); unputc('#');
                            do_step = TRUE;
                            yyclearin; yyerrok;
                          }
                          else
                          { show_prompt(); }
                        }
                |   /* eps */
                ;
Kommando    :   AssignKomm
            |   BreakpointKomm
            |   CallsKomm
            |   ConnectionsKomm
            |   DebugKomm
                    { fprintf(kommandout, deb_mod ? texte[170] : texte[171]);
                      if (default_pelist)
                      { more_on();
                        show_pes(default_pelist, texte[182], kommandout);
                        more_off();
                        putc('\n', kommandout);
                      }
                    }
            |   ExamineKomm
            |   GoKomm
            |   HelpKomm
            |   LoadKomm
            |   ListKomm
            |   ModeKomm
                    { fprintf(kommandout, texte[169], ssstr[ss_modus]); }
            |   NotraceKomm
            |   QuitKomm
            |   RecordKomm
                    { fprintf(kommandout, texte[168], protstr[prot]); }
            |   ShowKomm
            |   SetKomm
            |   StepKomm
            |   StopKomm
            |   TraceKomm
            |   WarnKomm
                    { fprintf(kommandout, warnings_on ? texte[186] : texte[187]); }
            |   WidthKomm
                    { fprintf(kommandout, texte[252], pe_width); }
            ;

AssignKomm  :   ASSIGN para_on
                    { int dummy;

                      init_debcode(akt_tiefe + 1, -1, &dummy);
                    }
                selection designator AOP expr ZEILEND
                    { if (sym_debugging && $4.sexpr_art &&
                          $5.sexpr_art && $7.expr_art == EXPR_VAR)
                      { register ARG *exptr = $7.typerg ? &$7.erg : &$7.lastval;
                        register int extyp = $7.typerg ? $7.typerg : $7.typlast;

                        if (zuw_ok($5.typserg, extyp))
                        { if ($4.sexpr_art == EXPR_VAR)
                          { register int goto_l2;

                                  /*      if selection call l1; */
                            funcs(do_v_ifcall, print_ifcall);
                            STAT_vc1(*stat_ptr) = $4.serg;
                            STAT_spr_ziel(*stat_ptr) = stat_ptr - programm + 2;
                            nextstat();
                                  /*      goto l2; */
                            funcs(do_goto, print_goto);
                            goto_l2 = stat_ptr - programm;
                            nextstat();
                                  /* l1 : proc debug_lev + 1; */
                            STAT_label(*stat_ptr) = ++max_label;
                            funcs(do_proc, print_proc);
                            STAT_proclev(*stat_ptr) = debug_lev + 1;
                            STAT_dscal(*stat_ptr) = dlptr(NULL);
                            STAT_dvec(*stat_ptr) = dlptr(NULL);
                            nextstat();
                                  /*      desig := expr; */
                            para_zuw(&$5, exptr, extyp);
                                  /*      return; */
                            funcs(do_return, print_return);
                            nextstat();
                                  /* l2 : ... */
                            STAT_label(*stat_ptr) = ++max_label;
                            STAT_spr_ziel(programm[goto_l2]) = stat_ptr - programm;
                          }
                          else
                          {       /* desig := expr; */
                            para_zuw(&$5, exptr, extyp);
                          }
                          end_debcode();
#ifdef DEBDEBUG
                          debcode_out();
                          parz_typs_out(stdout);
#endif
                          if (!anz_fehler)
                          { char *dummyst;
                            int dummy;

                            temp_a_block = new_aktblock(pc + 1, NULL, TRUE);
                            called = TRUE;
                            warnings_on = FALSE;
                            ended = FALSE;
                            err = FALSE;
                            start(debcode_start);
                            do
                            { akt_return(&dummyst, &dummy);
                              if (dummyst)
                              { free(aktive_pes);
                                aktive_pes = dummyst;
                                last_akt_pe = last(aktive_pes,&anz_akt_pes);
                              }
                            } while (akt_tiefe >= debug_lev);
                          }
                          kill_debcode();
                        }
                        else
                        { komerr(texte[313]); }
                      }
                      else
                      { if ($7.expr_art && $7.expr_art != EXPR_VAR)
                        { komerr(texte[310]); }
                      }
                      if ($5.sexpr_str) free($5.sexpr_str);
                      if ($7.expr_str) free($7.expr_str);
                    }
            ;

BreakpointKomm  :   BREAKPOINT para_on sign zeile offset ZEILEND
                        { if (!file_gelesen)
                          { komerr(texte[3]); }
                          else if ($4.list_flag >= 0)
                          { if ((int)$5 &&
                                ((ss_modus & STEP_COMP) || $4.list_flag))
                            { komerr(texte[238]); }
                            else
                            { more_on();
                              if ($4.list_flag)
                              { set_breakpoints(($3 ? (int)$3 : 1),
                                                $4.zval.zlist.zcount,
                                                $4.zval.zlist.zl,
                                                0, USER_BREAK);
                                free($4.zval.zlist.zl);
                              }
                              else
                              { set_breakpoints(($3 ? (int)$3 : 1), 1,
                                                &$4.zval.znr,
                                                (int)$5, USER_BREAK);
                              }
                              more_off();
                            }
                          }
                        }
                |   BREAKPOINT para_on ZEILEND
                        { more_on();
                          list_breakpoints(kommandout);
                          more_off();
                        }
                ;
offset  :   '+' INTNUM   { $$ = $2; }
        |   '-' INTNUM   { $$ = - $2; }
        |   /* eps */    { $$ = 0l; }
        ;
zeile   :   INTNUM
                { $$.list_flag = 0;
                  if ((int)$1 == 0)
                  { $$.zval.znr = $$.list_flag = -1;
                    { komerr(texte[173], 0); }
                  }
                  else if (ss_modus & STEP_INTER)
                  { $$.zval.znr = ziel(-(int)$1);
                    if ($$.zval.znr < 0)
                    { komerr(texte[173], (int)$1);
                      $$.list_flag = -1;
                    }
                  }
                  else
                  { $$.zval.znr = source_ziel((int)$1);
                    if ($$.zval.znr < 0)
                    { komerr(texte[237], (int)$1);
                      $$.list_flag = -1;
                    }
                  }
                }
        |   IDENT
                { proc_lines($1, &$$);
                }
        ;

CallsKomm   :   CALLS ZEILEND
                    { more_on();
                      show_aktstack(kommandout, CHAIN_OPT, -2, -2, 0);
                      more_off();
                    }
            |   CALLS ACTIVITY ZEILEND
                    { more_on();
                      show_aktstack(kommandout, CHAIN_OPT | ACTIVITY_OPT, -2, -2, 0);
                      more_off();
                    }
            ;

ConnectionsKomm :   CONNECTIONS conlist ZEILEND
                    { more_on();
                      list_connections(kommandout, $2);
                      more_off();
                      loesch_conlist($2);
                    }
                |   CONNECTIONS ZEILEND
                    { more_on();
                      list_connections(kommandout, NULL);
                      more_off();
                    }
                ;
conlist     :   conlist ',' conpat
                    { if ($3)
                      { $$ = $3;
                        $$->conlist_tail = $1;
                      }
                      else
                      { $$ = NULL;
                        loesch_conlist($1);
                      }
                    }
            |   conpat
                    { $$ = $1;
                      if ($$) $$->conlist_tail = NULL;
                    }
            ;
conpat      :   extpenum
                    { parse_start = -3; }
                extportnum TO
                    { parse_start = -2; }
                extpenum extportnum
                    { if (anz_fehler)
                      { $$ = NULL; }
                      else if (!($$ = (CONLIST *)calloc((size_t)1,
                                                        (size_t)sizeof(CONLIST))))
                      { komerr(texte[80]); }
                      else
                      { $$->v_pe = $1;
                        $$->v_po = $3;
                        $$->n_pe = $6;
                        $$->n_po = $7;
                      }
                    }
            ;
extpenum    :   INTNUM
                    { if ($1 < 1l || $1 > (long)pe_anz)
                      { komerr(texte[63], (int)$1); }
                      else
                      { $$.von_n = $$.bis_n = (int)$1; }
                    }
            |   INTNUM PP INTNUM
                    { if ($1 < 1l || $1 > (long)pe_anz)
                      { komerr(texte[63], (int)$1); }
                      if ($3 < 1l || $3 > (long)pe_anz)
                      { komerr(texte[63], (int)$3); }
                      if (!anz_fehler)
                      { if ($1 > $3)
                        { komerr(texte[167], (int)$1, (int)$3); }
                        else
                        { $$.von_n = (int)$1; $$.bis_n = (int)$3; }
                      }
                    }
            |   '*'
                    { $$.von_n = 1; $$.bis_n = pe_anz; }
            ;
extportnum  :   INTNUM
                    { if ($1 < 1l || $1 > (long)port_anz)
                      { komerr(texte[64], (int)$1); }
                      else
                      { $$.von_n = $$.bis_n = (int)$1; }
                    }
            |   INTNUM PP INTNUM
                    { if ($1 < 1l || $1 > (long)port_anz)
                      { komerr(texte[64], (int)$1); }
                      if ($3 < 1l || $3 > (long)port_anz)
                      { komerr(texte[64], (int)$3); }
                      if (!anz_fehler)
                      { if ($1 > $3)
                        { komerr(texte[45], (int)$1, (int)$3); }
                        else
                        { $$.von_n = (int)$1; $$.bis_n = (int)$3; }
                      }
                    }
            |   '*'
                    { $$.von_n = 1; $$.bis_n = port_anz; }
            ;

DebugKomm   :   DEBUG debopt OptPeList ZEILEND
                    { deb_mod = (int)$2;
                      if ((int)$3 > 0)
                      { if (default_pelist) free(default_pelist);
                        default_pelist = pe_list_string;
                        pe_list_string = NULL;
                      }
                    }
            ;
debopt      :   EIN
                    { $$ = (long)TRUE; }
            |   AUS
                    { $$ = (long)FALSE; }
            |   INTNUM
                    { $$ = (long)((int)$1 > 0); }
            |   /* eps */
                    { $$ = (long)deb_mod; }
            ;

ExamineKomm :   EXAMINE para_on OptExProc
                    { if ($3.p_tief)
                      { if ($3.p_lab >= 0)
                        { init_debcode(STAT_print_func(programm[$3.p_lab]) == print_proc ?
                                         STAT_proclev(programm[$3.p_lab]) + 1 :
                                         1,
                                       $3.p_lab,
                                       &$3.ab_abstand);
                        }
                        else
                        { init_debcode(akt_tiefe + 1, -1, &$3.ab_abstand); }
                      }
                    }
                selection ExprList ZEILEND
                    { if (sym_debugging)
                      { if ($3.p_tief)
                        { end_debcode();
#ifdef DEBDEBUG
                          debcode_out();
                          parz_typs_out(stdout);
#endif
                          if (!anz_fehler)
                          { char *dummyst;
                            int dummy;
			    char nl_out = FALSE;

			    more_on(); beim_listing = TRUE;
			    for (; $3.p_tief && akt_tiefe >= 0; $3.p_tief--)
                            { if ($3.p_lab >= 0)
			      { if (nl_out)
				{ putc('\n', kommandout); ifmore(kommandout); }
				if (quitted) break;
				fprintf(kommandout, texte[223], $3.ab_abstand);
                                ifmore(kommandout);
                                if (quitted) break;
                              }
                              temp_a_block = new_aktblock(pc + 1, NULL, TRUE);
                              called = TRUE;
                              warnings_on = FALSE;
                              ended = FALSE;
                              err = FALSE;
                              examining = TRUE;
			      start(debcode_start);
                              examining = FALSE;
			      nl_out = elist_out(&$5, &$6, kommandout);
                              do
                              { akt_return(&dummyst, &dummy);
                                if (dummyst)
                                { free(aktive_pes);
                                  aktive_pes = dummyst;
                                  last_akt_pe = last(aktive_pes,&anz_akt_pes);
                                }
                              } while (akt_tiefe >= debug_lev);
                              if ($3.p_lab >= 0)
                              { $3.ab_abstand += find_aktblock($3.p_lab, TRUE); }
                            }
			    if (nl_out) { putc('\n', kommandout); }
			    beim_listing = FALSE; more_off();
                          }
                          kill_debcode();
                        }
                      }
                      exprlist_free(&$6);
                    }
            ;

OptExProc   :   ProcIdList '!' INTNUM
                    { if ($1)
                      { $$.p_lab = $1->entry_lab;
                        $$.p_tief = (int)$3;
                      }
                      else
                      { $$.p_tief = 0; }
                    }
            |   ProcIdList
                    { if ($1)
                      { $$.p_lab = $1->entry_lab;
                        $$.p_tief = 1;
                      }
                      else
                      { $$.p_tief = 0; }
                    }
            |   /* eps */
                    { $$.p_lab = -1;
                      $$.p_tief = 1;
                    }
            ;
              
ProcIdList  :   ProcIdList '!' IDENT
                    { if ($1)
                      { register SYMTAB *st;

                        if (st = look_sym($3, $1))
                        { switch (st->sym_art)
                          { case SY_SYSNAME  : $$ = scope_table + geltcount - 1;
                                               break;
                            case SY_PROCNAME : $$ = scope_table + st->sym_type_scope - 1;
                                               break;
                            default : komerr(texte[302], key_to_name($3));
                                      $$ = NULL;
                          }
                        }
                        else
                        { komerr(texte[302], key_to_name($3));
                          $$ = NULL;
                        }
                      }
                    }
            |   '!' IDENT
                    { register SYMTAB *st;

                      if (disp)
                      { if (st = look_sym($2, disp[akt_tiefe]->top_scope))
                        { switch (st->sym_art)
                          { case SY_SYSNAME  : $$ = scope_table + geltcount - 1;
                                               break;
                            case SY_PROCNAME : $$ = scope_table + st->sym_type_scope - 1;
                                               break;
                            default : komerr(texte[302], key_to_name($2));
                                      $$ = NULL;
                          }
                        }
                        else
                        { komerr(texte[302], key_to_name($2));
                          $$ = NULL;
                        }
                      }
                      else
                      { komerr(texte[183]);
                        $$ = NULL;
                      }
                    }
            ;

GoKomm      :   GO OptGoStep ZEILEND
                    { ss_mod = (int)$2; ss_fast = TRUE;
                      to_unbreak();
                      if (breaked)
                      { step_over_block = akt_step_block;
                        beende_parser();
                        return DO_GO;
                      }
                      else
                      { beende_parser();
                        return run_prog();
                      }
                    }
            |   GO OptGoStep TO para_on zeile ZEILEND
                    { if ($5.list_flag >= 0)
                      { ss_mod = (int)$2; ss_fast = TRUE;
                        to_break(&$5);
                        if (breaked)
                        { step_over_block = akt_step_block;
                          beende_parser();
                          return DO_GO;
                        }
                        else
                        { beende_parser();
                          return run_prog();
                        }
                      }
                    }
            ;
OptGoStep   :   /* eps */
                    { $$ = 0l; }
            |   STEP
                    { $$ = (long)ss_modus; }
            |   STEP OVER
                    { $$ = (long)(ss_modus | STEP_OVER); }
            ;

HelpKomm    :   HELP ZEILEND
                    { help(0); }
            |   HELP KommName ZEILEND
                    { help((int)$2); }
            ;
KommName    :   ASSIGN      { $$ = (long)ASSIGN; }
            |   BREAKPOINT  { $$ = (long)BREAKPOINT; }
            |   CALLS       { $$ = (long)CALLS; }
            |   CONNECTIONS { $$ = (long)CONNECTIONS; }
            |   DEBUG       { $$ = (long)DEBUG; }
            |   EXAMINE     { $$ = (long)EXAMINE; }
            |   GO          { $$ = (long)GO; }
            |   HELP        { $$ = (long)HELP; }
            |   LOAD        { $$ = (long)LOAD; }
            |   LIST        { $$ = (long)LIST; }
            |   MODE        { $$ = (long)MODE; }
            |   NOTRACE     { $$ = (long)NOTRACE; }
            |   QUIT        { $$ = (long)QUIT; }
            |   RECORD      { $$ = (long)RECORD; }
            |   SHOW        { $$ = (long)SHOW; }
            |   SET         { $$ = (long)SET; }
            |   STEP        { $$ = (long)STEP; }
            |   STOP        { $$ = (long)STOP; }
            |   TRACE       { $$ = (long)TRACE; }
            |   WARN        { $$ = (long)WARN; }
            |   WIDTH       { $$ = (long)WIDTH; }
            ;

LoadKomm    :   LOAD FILENAME ZEILEND
                    { beende_parser();
                      return(DO_LOAD);
                    }
            |   LOAD FILENAME '-' COMPILER ZEILEND
                    { beende_parser();
                      return(DO_COMPILE);
                    }
            ;

ListKomm    :   LIST range ZEILEND
                    { if (!anz_fehler)
                      { more_on();
                        list_prog(listout, &$2);
                        more_off();
                      }
                    }
            |   LIST PATTERN STRING ZEILEND
                    { if (!anz_fehler)
                      { more_on();
                        list_pat_prog(kommandout, $3, FALSE);
                        more_off();
                      }
                    }
            |   LIST STRINGMATCH STRING ZEILEND
                    { if (!anz_fehler)
                      { more_on();
                        list_pat_prog(kommandout, $3, TRUE);
                        more_off();
                      }
                    }
            ;
range       :   INTNUM
                    { register int z = ziel(-(int)$1);

                      if (z < 0)
                      { komerr(texte[173], (int)$1); }
                      else
                      { $$.von_n = $$.bis_n = z; }
                    }
            |   INTNUM PP
                    { register int z = ziel(-(int)$1);

                      if (z < 0)
                      { komerr(texte[173], (int)$1); }
                      else
                      { $$.von_n = z; $$.bis_n = stat_anz - 1; }
                    }
            |   INTNUM PP INTNUM
                    { register int z1 = ziel(-(int)$1);
                      register int z2 = ziel(-(int)$3);

                      if (z1 < 0)
                      { komerr(texte[173], (int)$1); }
                      if (z2 < 0)
                      { komerr(texte[173], (int)$3); }
                      if (!anz_fehler)
                      { if (z1 > z2)
                        { komerr(texte[195], (int)$1, (int)$3); }
                        else
                        { $$.von_n = z1; $$.bis_n = z2; }
                      }
                    }
            |   PP INTNUM
                    { register int z = ziel(-(int)$2);

                      if (z < 0)
                      { komerr(texte[173], (int)$2); }
                      else
                      { $$.von_n = 0; $$.bis_n = z; }
                    }
            |   /* eps */
                    { $$.von_n = 0; $$.bis_n = stat_anz - 1; }
            ;

ModeKomm    :   MODE ZEILEND
            |   MODE COMPILER ZEILEND
                    { ss_mod = ss_modus = ss_mod_start = STEP_COMP; }
            |   MODE INTERPRETER ZEILEND
                    { ss_mod = ss_modus = ss_mod_start = STEP_INTER; }
            ;

NotraceKomm :   NOTRACE ZEILEND
                    { parse_start = -2;
                      tr_block_off(s_blocks, 1);
                      tr_block_off(s_heap, 1);
                      tr_block_off(v_blocks, pe_anz);
                      tr_block_off(v_heap, pe_anz);
                    }
            |   NOTRACE nsp vardesc ZEILEND
                    { parse_start = -2;
                      if (!anz_fehler)
                      { if ((ARG_argsort($3) & (IND | INDL)) &&
                            (ARG_indsort($3) & VEC)) 
                        { komerr(texte[118]); }
                        else
                        { zielits = item_ptr(&$3, &zielbs, disp);
                          if (err) err = FALSE;
                          else tr_off(zielits, zielbs);
                        }
                      }
                    }
            ;

QuitKomm    :   QUIT ZEILEND
                    { parzexit(0); }
            ;

RecordKomm  :   RECORD protmod ZEILEND
                    { if (prot != (int)$2)
                      { prot = (int)$2;
                        if (prot) alt_prot = prot;
                        if (prot_offen) fprintf(protokollout, texte[202], prot);
                      }
                    }
protmod         :   AUS         { $$ = 0l; }
                |   KURZ        { $$ = 1l; }
                |   LANG        { $$ = 2l; }
                |   INTNUM      { $$ = ($1 <= 2l) ? $1 : (long)prot; }
                |   /* eps */   { $$ = (long)prot; }
                ;

ShowKomm    :   SHOW showwhat
            ;
showwhat    :   memoryshow
            |   paramstackshow
            |   callstackshow
            |   variableshow
            ;

memoryshow  :   MEMORY
                { adrsort = 0; }
                scalmemdecl vecmemdecl OptPeList ZEILEND
                    { parse_start = -2;
                      if (!anz_fehler)
                      { more_on();
                        show_mem(kommandout, $3, $4, (int)$5);
                        more_off();
                        loesch_rangelist($3);
                        loesch_rangelist($4);
                      }
                    }
            |   HEAP
                { adrsort = HEAP_ADRS; }
                scalmemdecl vecmemdecl OptPeList ZEILEND
                    { parse_start = -2;
                      if (!anz_fehler)
                      { more_on();
                        show_heap(kommandout, $3, $4, (int)$5);
                        more_off();
                        loesch_rangelist($3);
                        loesch_rangelist($4);
                      }
                    }
            ;
scalmemdecl :   S
                    { $$ = NULL; }
            |   S addrlist
                    { $$ = $2.mem_erster; }
            |   /* eps */
                    { $$ = (RANGELIST *)(-1); }
            ;
vecmemdecl  :   V
                    { $$ = NULL; }
            |   V
                    { adrsort |= VEC_ADRS; }
                addrlist
                    { $$ = $3.mem_erster; }
            |   /* eps */
                    { $$ = (RANGELIST *)(-1); }
            ;
addrlist    :   addrlist ',' memel
                    { $$ = $1;
                      if ($$.mem_letzter->next_range = new_rangelist())
                      { $$.mem_letzter = $$.mem_letzter->next_range;
                        $$.mem_letzter->r = $3;
                      }
                    }
            |   memel
                    { if ($$.mem_erster = $$.mem_letzter = new_rangelist())
                      { $$.mem_erster->r = $1; }
                    }
            ;
memel   :   sign INTNUM
                { $$.von_n = $$.bis_n = ($1 ? (int)$1 : 1) * (int)$2; }
        |   sign INTNUM PP
                { $$.von_n = ($1 ? (int)$1 : 1) * (int)$2;
                  $$.bis_n = (adrsort & HEAP_ADRS)
                             ? -1
                             : ((adrsort & VEC_ADRS) ? v_max_b_adr : s_max_b_adr);
                  if ($$.von_n > $$.bis_n)
                  { komerr(texte[197], $$.von_n, $$.bis_n); }
                }
        |   PP sign INTNUM
                { $$.von_n = (adrsort & VEC_ADRS) ? v_min_h_adr : s_min_h_adr;
                  $$.bis_n = ($2 ? (int)$2 : 1) * (int)$3;
                  if ($$.von_n > $$.bis_n)
                  { komerr(texte[197], $$.von_n, $$.bis_n); }
                }
        |   sign INTNUM PP sign INTNUM
                { $$.von_n = ($1 ? (int)$1 : 1) * (int)$2;
                  $$.bis_n = ($4 ? (int)$4 : 1) * (int)$5;
                  if ($$.von_n > $$.bis_n)
                  { komerr(texte[197], $$.von_n, $$.bis_n); }
                }
        ;
sign    :   '+'         { $$ = 1l; }
        |   '-'         { $$ = -1l; }
        |   /* eps */   { $$ = 0l; }
        ;

paramstackshow  :   PARSTACK scalstack vecstack OptPeList ZEILEND
                        { parse_start = -2;
                          if (!anz_fehler)
                          { more_on();
                            show_parstack(kommandout, (int)$2, (int)$3, (int)$4);
                            more_off();
                          }
                        }
                ;

callstackshow   :   CALLSTACK asoptions scalstack vecstack OptPeList ZEILEND
                        { parse_start = -2;
                          if (!anz_fehler)
                          { more_on();
                            show_aktstack(kommandout, (int)$2, (int)$3, (int)$4, (int)$5);
                            more_off();
                          }
                        }
                ;
scalstack   :   S OptTiefe
                    { $$ = $2; }
            |   /* eps */
                    { $$ = -2l; }
            ;
vecstack    :   V OptTiefe
                    { $$ = $2; }
            |   /* eps */
                    { $$ = -2l; }
            ;
OptTiefe    :   INTNUM
                    { $$ = $1; }
            |   /* eps */
                    { $$ = -1l; }
            ;
asoptions   :   CHAIN
                    { if (yychar > 0) ups();
                      yyclearin;
                      parse_start = -3;
                      $$ = (long)CHAIN_OPT;
                    }
            |   CHAIN ACTIVITY
                    { if (yychar > 0) ups();
                      yyclearin;
                      parse_start = -3;
                      $$ = (long)(CHAIN_OPT | ACTIVITY_OPT);
                    }
            |   /* eps */
                    { if (yychar > 0) ups();
                      yyclearin;
                      parse_start = -3;
                      $$ = 0l;
                    }
            ;

variableshow    :   VARIABLE les vardesc
                        { parse_start = -2; }
                    OptProc OptPeList OptDecl ZEILEND
                        { if (!anz_fehler)
                          { more_on();
                            show_var(kommandout, &$3, &$5, (int)$6, &$7);
                            more_off();
                          }
                        }
                |   SPECIALS OptSpezList OptPeList ZEILEND
                        { if (!anz_fehler)
                          { more_on();
                            show_spez(kommandout, (int)$2, (int)$3);
                            more_off();
                          }
                        }
                ;
OptProc     :   PROC komlabel
                    { if (yychar > 0) ups();
                      yyclearin;
                      parse_start = -3;
                      $$.p_lab = (int)$2;
                      $$.p_tief = 1;
                    }
            |   PROC komlabel DEPTH INTNUM
                    { if (yychar > 0) ups();
                      yyclearin;
                      parse_start = -3;
                      $$.p_lab = (int)$2;
                      $$.p_tief = (int)$4;
                    }
            |   /* eps */
                    { if (yychar > 0) ups();
                      yyclearin;
                      parse_start = -3;
                      $$.p_lab = -1;
                    }
            ;
komlabel    :   INTNUM
                    { if ((int)$1 == 0)
                      { $$ = -1l;
                        { komerr(texte[173], 0); }
                      }
                      else
                      { $$ = (long)ziel(-(int)$1);
                        if ((int)$$ < 0)
                        { komerr(texte[173], (int)$1); }
                      }
                    }
            ;
OptDecl :   AS declaration
                { $$ = $2; }
        |   /* eps */
                { null_dlist(&$$);
                }
        ;
OptSpezList :   spezlist 
                    { $$ = $1; }
            |   /* eps */
                    { $$ = ( (1l << (MAXTRANS - MAXTRANS) ) |
                             (1l << (ACTTRANS - MAXTRANS) ) |
                             (1l << (DONE - MAXTRANS) ) |
                             (1l << (TERMCH - MAXTRANS) ) |
                             (1l << (SRESULT - MAXTRANS) ) |
                             (1l << (VRESULT - MAXTRANS) ) ); 
                    }
            ;
spezlist    :   spezlist ',' spezvar
                    { $$ = $1 | (1l << ((int)$3 - MAXTRANS)); }
            |   spezlist spezvar
                    { $$ = $1 | (1l << ((int)$2 - MAXTRANS)); }
            |   spezvar
                    { $$ = (1l << ((int)$1 - MAXTRANS)); }
            ;
spezvar     :   MAXTRANS        { $$ = (long)MAXTRANS; }
            |   ACTTRANS        { $$ = (long)ACTTRANS; }
            |   DONE            { $$ = (long)DONE; }
            |   TERMCH          { $$ = (long)TERMCH; }
            |   SRESULT         { $$ = (long)SRESULT; }
            |   VRESULT         { $$ = (long)VRESULT; }
            ;

SetKomm     :   SET vardesc OptPeList les setsign VarConst ZEILEND
                    { register ITEM *ziel;
                      register ITEM *quell;
                      register char *akt_pe_save;
                      register int last_akt_pe_save, anz_akt_save;

                      if (!anz_fehler)
                      { tr_flag = FALSE;
                        akt_pe_save = aktive_pes; last_akt_pe_save = last_akt_pe; anz_akt_save = anz_akt_pes;
                        aktive_pes = (int)$3 ? pe_list_string : default_pelist;
                        last_akt_pe = last(aktive_pes,&anz_akt_pes);
                        zielits = item_ptr(&$2, &zielbs, disp);
                        if (err) err = FALSE;
                        else if (ARG_argsort($2) & VEC)
                        { register VARBLOCK **blpt = &zielbs->blocks[0];
                          register ITPTRS *quellits = item_ptr(&$6, &dummybs, disp);

                          if (err) err = FALSE;
                          else
                          { setvarlen = pe_anz; vec_bef = TRUE; anz_runwarnings = 0;
                            for (pec = 0; pec < last_akt_pe; pec++, blpt += zielbs->inc)
                            { ziel = (* zielits->n_it_func)(zielits);
                              quell = (* quellits->n_it_func)(quellits);
                              if (aktive_pes[pec] == '1')
                              { setbl = *blpt;
                                if (!setbl->max_pes ||
                                    setbl->max_pes[pec] == '1')
                                set_item_cast(ziel,ARG_typ($2),quell,ARG_typ($6),(int)$5);
                              }
                            }
                          }
                        }
                        else
                        { if (ARG_argsort($6) & VEC)
                          { komerr(texte[67]); }
                          else
                          { setbl = zielbs->blocks[0];
                            setvarlen = 1; vec_bef = FALSE; anz_runwarnings = 0;
                            quell = item_ptr(&$6, &dummybs, disp)->itps[0];
                            if (err) err = FALSE;
                            else
                            { set_item_cast(zielits->itps[0], ARG_typ($2), quell, ARG_typ($6),(int)$5); }
                          }
                        }
                        if (tr_flag)
                        { more_on();
                          tr_out(debugout);
                          more_off();
                        }
                        aktive_pes = akt_pe_save; last_akt_pe = last_akt_pe_save; anz_akt_pes = anz_akt_save;
                        if (fperror)
                        { komerr(texte[111]); }
                      }
                      parse_start = -2;
                    }
            ;
setsign     :   '-'             { $$ = (long)'-'; }
            |   NOT             { $$ = (long)NOT; }
            |   /* eps */       { $$ = 0l; }
            ;

OptPeList   :   PE pelistinit pelist
                    { $$ = ((int)$3) ? 1l : -1l; }
            |   /* eps */
                    { $$ = 0l; }
            |   PE pelistinit '*'
                    { register int n;
                      if (pe_list_string)
                      { for (n = 0; n < pe_anz; pe_list_string[n++] = '1');
                        $$ = 1l;
                      }
                      else $$ = -1l;
                    }
            ;
pelistinit  :   /* eps */
                    { register int n;
                      register char *sp;

                      if (pe_list_string) free(pe_list_string);
                      if (!(pe_list_string = calloc((size_t)pe_anz + 1,
                                                    (size_t)sizeof(char))))
                      { komerr(texte[80]); }
                      else
                      { for (n = 1, sp = pe_list_string;
                             n <= pe_anz;
                             n++, *(sp++) = '0');
                        *sp = '\0';
                      }
                    }
            ;

pelist  :   pelist ',' peel
                { $$ = $1 && $3; }
        |   peel
                { $$ = $1; }
        ;
peel    :   INTNUM
                { if (pe_list_string)
                  { if ($1 < 1l || $1 > (long)pe_anz)
                    { komerr(texte[63], (int)$1); $$ = (long)FALSE; }
                    else
                    { pe_list_string[$1 - 1] = '1';
                      $$ = (long)TRUE;
                    }
                  }
                  else
                  { $$ = (long)FALSE; }
                }
        |   INTNUM PP INTNUM
                { register char *sp;
                  register int n;
                  register int min = (int)$1;
                  register int max = (int)$3;

                  if (pe_list_string)
                  { $$ = (long)TRUE;
                    if (min < 1 || min > pe_anz)
                    { komerr(texte[63], min); $$ = (long)FALSE; }
                    if (max < 1 || max > pe_anz)
                    { komerr(texte[63], max); $$ = (long)FALSE; }
                    if ($$)
                    { if (min > max)
                      { komerr(texte[167], min, max); $$ = (long)FALSE; }
                      else
                      { for (n = min, sp = pe_list_string + min - 1;
                             n <= max;
                             n++, *(sp++) = '1');
                      }
                    }
                  }
                  else
                  { $$ = (long)FALSE; }
                }
        ;

StepKomm    :   STEP OptOver ZEILEND
                    { ss_mod = ss_modus | (int)$2; ss_fast = FALSE;
                      to_unbreak();
                      if (breaked)
                      { step_over_block = akt_step_block;
                        beende_parser();
                        return DO_STEP;
                      }
                      else
                      { beende_parser();
                        return run_prog();
                      }
                    }
            |   STEP OptOver TO para_on zeile ZEILEND
                    { if ($5.list_flag >= 0)
                      { ss_mod = ss_modus | (int)$2; ss_fast = FALSE;
                        to_break(&$5);
                        if (breaked)
                        { step_over_block = akt_step_block;
                          beende_parser();
                          return DO_STEP;
                        }
                        else
                        { beende_parser();
                          return run_prog();
                        }
                      }
                    }
            |   STEP OptOver ALL ZEILEND
                    { ss_mod = ss_modus | (int)$2 ; ss_fast = FALSE;
                      to_break(NULL);
                      if (breaked)
                      { step_over_block = akt_step_block;
                        beende_parser();
                        return DO_STEP;
                      }
                      else
                      { beende_parser();
                        return run_prog();
                      }
                    }
            |   '#' ZEILEND
                    { if (!stepping_to)
                      { ss_mod = ss_modus | (ss_mod & STEP_OVER);
                        to_break(NULL);
                      }
                      ss_fast = FALSE;
                      beende_parser();
                      return DO_STEP;
                    }
            ;
OptOver     :   /* eps */
                    { $$ = 0l; }
            |   OVER
                    { $$ = (long)STEP_OVER; }
            ;

StopKomm    :   STOP ZEILEND
                    { if (breaked)
                      { beende_parser();
                        return DO_STOP;
                      }
                      else
                      { fprintf(kommandout, texte[180]); }
                    }
            ;

TraceKomm   :   TRACE nsp vardesc string AS declaration ZEILEND
                    { parse_start = -2;
                      if (!anz_fehler)
                      { if ((ARG_argsort($3) & (IND | INDL)) &&
                            (ARG_indsort($3) & VEC)) 
                        { komerr(texte[118]); }
                        else
                        { register STAT *stat_ptr;

                          if (stat_ptr = new_tr_stat())
                          { STAT_dblock(*stat_ptr) = dlptr(&$6);
                            STAT_vc2(*stat_ptr) = $3;
                            STAT_vc3(*stat_ptr) = $4;
                            more_on();
                            do_trace(stat_ptr);
                            more_off();
                          }
                        }
                      }
                    }
            ;

WarnKomm    :   WARN AUS ZEILEND
                    { warnings_on = FALSE; }
            |   WARN EIN ZEILEND
                    { warnings_on = TRUE; }
            |   WARN INTNUM ZEILEND
                    { warnings_on = ((int)$2 > 0); }
            |   WARN ZEILEND
            ;

WidthKomm   :   WIDTH ZEILEND
            |   WIDTH INTNUM ZEILEND
                    { if ((int)$2 > 0) pe_width = (int)$2;
                      else komerr(texte[253]);
                    }
            ;

ExprList    :   ExprList ',' expr
                    { register EXPR *neu;

                      $$ = $1;
                      if ($$.expr_array)
                      { if (!(neu =
                              (EXPR *)realloc($$.expr_array,
                                                (size_t)(++$$.expr_count * sizeof(EXPR)))))
                        { $$.expr_count = 0;
                          free($$.expr_array); $$.expr_array = NULL;
                          komerr(texte[80]);
                        }
                        else
                        { neu[$$.expr_count - 1] = $3;
                          $$.expr_array = neu;
                        }
                      }
                      akt_index_typ = index_typ1;
                    }
            |   expr
                    { if (!($$.expr_array = (EXPR *)calloc((size_t)1,
                                                           (size_t)sizeof(EXPR))))
                      { $$.expr_count = 0;
                        komerr(texte[80]);
                      }
                      else
                      { $$.expr_count = 1;
                        *$$.expr_array = $1;
                      }
                      akt_index_typ = index_typ1;
                    }
            ;

expr        :   expr relation SimpleExpr
                    { register char *yyd = yydisplay((int)$2);

                      if ($$.expr_art = ($1.expr_art == EXPR_VAR &&
                                         $3.sexpr_art == EXPR_VAR))
                      { if ($$.expr_art = rel_ok($1.typlast, (int)$2, $3.typserg))
                        { if ($$.expr_str =
                                malloc((size_t)(strlen($1.expr_str) +
                                                  strlen(yyd) +
                                                  strlen($3.sexpr_str) + 3)))
                          { sprintf($$.expr_str, "%s %s %s",
                                    $1.expr_str, yyd, $3.sexpr_str);
                            $$.expr_art = EXPR_VAR;
                            $$.typerg = para_typ[BOOL];
                            $$.lastval = $3.serg;
                            $$.typlast = obertyp($3.typserg);
                            if ($1.typerg)
                            { ARG hvar;

                              para_relop(&hvar, &$1.lastval, $1.typlast, (int)$2,
                                                &$3.serg, $$.typlast);
                              para_addop(&$$.erg, &$1.erg, AND, &hvar, $$.typerg);
                            }
                            else
                            { para_relop(&$$.erg, &$1.lastval, $1.typlast, (int)$2,
                                                  &$3.serg, $$.typlast);
                            }
                          }
                          else
                          { $$.expr_art = EXPR_FALSCH;
                            komerr(texte[80]);
                          }
                        }
                        else
                        { komerr(texte[314], yyd); }
                      }
                      else
                      { if ($1.expr_art && $1.expr_art != EXPR_VAR)
                        { komerr(texte[306], yyd); }
                        if ($3.sexpr_art && $3.sexpr_art != EXPR_VAR)
                        { komerr(texte[307], yyd); }
                      }
                      akt_index_typ = index_typ1;
                      if ($1.expr_str) free($1.expr_str);
                      if ($3.sexpr_str) free($3.sexpr_str);
                    }
            |   SimpleExpr
                    { $$.expr_art = $1.sexpr_art;
                      $$.lastval = $1.serg;
                      $$.typlast = $1.typserg;
                      $$.typerg = 0;
                      $$.expr_str = $1.sexpr_str;
                    }
            ;

relation    :   EQ { $$ = EQ; }
            |   NE { $$ = NE; }
            |   LT { $$ = LT; }
            |   LE { $$ = LE; }
            |   GT { $$ = GT; }
            |   GE { $$ = GE; }
            |   IN { $$ = IN; }
            ;

SimpleExpr  :   SimpleExpr AddOperator term
                    { register char *yyd = yydisplay((int)$2);

                      if ($$.sexpr_art = $1.sexpr_art == EXPR_VAR && $3.sexpr_art == EXPR_VAR)
                      { if ($$.sexpr_art = add_ok($1.typserg, (int)$2, $3.typserg))
                        { if ($$.sexpr_str =
                                malloc((size_t)(strlen($1.sexpr_str) +
                                                  strlen(yyd) +
                                                  strlen($3.sexpr_str) + 3)))
                          { sprintf($$.sexpr_str, "%s %s %s",
                                    $1.sexpr_str, yyd, $3.sexpr_str);
                            $$.sexpr_art = EXPR_VAR;
                            $$.typserg = obertyp($1.typserg);
                            para_addop(&$$.serg, &$1.serg, (int)$2, &$3.serg, $$.typserg);
                          }
                          else
                          { $$.sexpr_art = EXPR_FALSCH;
                            komerr(texte[80]);
                          }
                        }
                        else
                        { komerr(texte[314], yyd); }
                      }
                      else
                      { if ($1.sexpr_art && $1.sexpr_art != EXPR_VAR)
                        { komerr(texte[306], yyd); }
                        if ($3.sexpr_art && $3.sexpr_art != EXPR_VAR)
                        { komerr(texte[307], yyd); }
                      }
                      akt_index_typ = index_typ1;
                      if ($1.sexpr_str) free($1.sexpr_str);
                      if ($3.sexpr_str) free($3.sexpr_str);
                    }
            |   sign term
                    { if ($1)
                      { register char *tok = yydisplay($1 < 0 ? UMINUS : PLUS);

                        if ($$.sexpr_art = $2.sexpr_art == EXPR_VAR)
                        { if ($$.sexpr_art = sign_ok($2.typserg))
                          { if ($$.sexpr_str =
                                  malloc((size_t)(strlen(tok) +
                                                    strlen($2.sexpr_str) + 2)))
                            { sprintf($$.sexpr_str, "%s %s",
                                      tok, $2.sexpr_str);
                              $$.typserg = obertyp($2.typserg);
                              $$.sexpr_art = EXPR_VAR;
                              if ($1 < 0l)
                              { para_minus(&$$.serg, &$2.serg, $$.typserg); }
                            }
                            else
                            { $$.sexpr_art = EXPR_FALSCH;
                              komerr(texte[80]);
                            }
                          }
                          else
                          { komerr(texte[314], tok); }
                        }
                        else if ($2.sexpr_art)
                        { komerr(texte[305], tok); }
                        if ($2.sexpr_str) free($2.sexpr_str);
                      }
                      else
                      { $$ = $2; }
                    }
            ;

AddOperator :   '+' { $$ = PLUS; }
            |   '-' { $$ = MINUS; }
            |   OR  { $$ = OR; }
            ;

term    :   term MulOperator power
                { register char *yyd = yydisplay((int)$2);

                  if ($$.sexpr_art = $1.sexpr_art == EXPR_VAR && $3.sexpr_art == EXPR_VAR)
                  { if ($$.sexpr_art = mul_ok($1.typserg, (int)$2, $3.typserg))
                    { if ($$.sexpr_str =
                            malloc((size_t)(strlen($1.sexpr_str) +
                                              strlen(yyd) +
                                              strlen($3.sexpr_str) + 3)))
                      { sprintf($$.sexpr_str, "%s %s %s",
                                $1.sexpr_str, yyd, $3.sexpr_str);
                        $$.typserg = obertyp($1.typserg);
                        $$.sexpr_art = EXPR_VAR;
                        para_mulop(&$$.serg, &$1.serg, (int)$2, &$3.serg, $$.typserg);
                      }
                      else
                      { $$.sexpr_art = EXPR_FALSCH;
                        komerr(texte[80]);
                      }
                    }
                    else
                    { komerr(texte[314], yyd); }
                  }
                  else
                  { if ($1.sexpr_art && $1.sexpr_art != EXPR_VAR)
                    { komerr(texte[306], yyd); }
                    if ($3.sexpr_art && $3.sexpr_art != EXPR_VAR)
                    { komerr(texte[307], yyd); }
                  }
                  akt_index_typ = index_typ1;
                  if ($1.sexpr_str) free($1.sexpr_str);
                  if ($3.sexpr_str) free($3.sexpr_str);
                }
        |   power
                { $$ = $1; }
        ;

MulOperator :   '*' { $$ = MAL; }
            |   '/' { $$ = DURCH; }
            |   DIV { $$ = DIV; }
            |   MOD { $$ = MOD; }
            |   AND { $$ = AND; }
            ;

power   :   factor POWER power
                { if ($$.sexpr_art = $1.sexpr_art == EXPR_VAR && $3.sexpr_art == EXPR_VAR)
                  { if ($$.sexpr_art = pow_ok($1.typserg, $3.typserg))
                    { if ($$.sexpr_str =
                            malloc((size_t)(strlen($1.sexpr_str) +
                                              strlen($3.sexpr_str) + 5)))
                      { sprintf($$.sexpr_str, "%s ** %s",
                                $1.sexpr_str, $3.sexpr_str);
                        $$.sexpr_art = EXPR_VAR;
                        $$.typserg = obertyp($1.typserg);
                        para_pow(&$$.serg,
                                 &$1.serg, obertyp($1.typserg),
                                 &$3.serg, obertyp($3.typserg));
                      }
                      else
                      { $$.sexpr_art = EXPR_FALSCH;
                        komerr(texte[80]);
                      }
                    }
                    else
                    { komerr(texte[314], "**"); }
                  }
                  else
                  { if ($1.sexpr_art && $1.sexpr_art != EXPR_VAR)
                    { komerr(texte[306], "**"); }
                    if ($3.sexpr_art && $3.sexpr_art != EXPR_VAR)
                    { komerr(texte[307], "**"); }
                  }
                  akt_index_typ = index_typ1;
                  if ($1.sexpr_str) free($1.sexpr_str);
                  if ($3.sexpr_str) free($3.sexpr_str);
                }
        |   factor
                { $$ = $1; }
        ;

factor  :   IDENT '(' ')'
                { EXPRLIST dummy_el;

                  dummy_el.expr_array = NULL;
                  dummy_el.expr_count = 0;
                  para_stdfkt(&$$, $1, &dummy_el);
                }
        |   IDENT '(' ExprList ')'
                { para_stdfkt(&$$, $1, &$3); }
        |   INTNUM
                { if ($$.sexpr_str = malloc((size_t)20))
                  { sprintf($$.sexpr_str, "%ld", $1);
                    $$.sexpr_art = EXPR_VAR;
                    $$.typserg = para_typ[INT];
                    ARG_argsort($$.serg) = CON | INT;
                    ARG_con_wert($$.serg).datentyp = INT | INT_ERLAUBT;
                    ARG_con_wert($$.serg).inhalt.i_val = $1;
                  }
                  else
                  { $$.sexpr_art = EXPR_FALSCH;
                    komerr(texte[80]);
                  }
                }
        |   CHAR
                { if ($$.sexpr_str = malloc((size_t)4))
                  { sprintf($$.sexpr_str, "'%c'", $1);
                    $$.sexpr_art = EXPR_VAR;
                    $$.typserg = para_typ[CHA];
                    ARG_argsort($$.serg) = CON | CHA;
                    ARG_con_wert($$.serg).datentyp = CHA | CHA_ERLAUBT;
                    ARG_con_wert($$.serg).inhalt.c_val = $1;
                  }
                  else
                  { $$.sexpr_art = EXPR_FALSCH;
                    komerr(texte[80]);
                  }
                }
        |   REALNUM
                { if ($$.sexpr_str = malloc((size_t)20))
                  {
#  ifdef SUN
                    sprintf($$.sexpr_str, $1 ? "%#g" : "%#f", $1);
#  else
                    sprintf($$.sexpr_str, "%#g", $1);
#  endif
                    $$.sexpr_art = EXPR_VAR;
                    $$.typserg = para_typ[REAL];
                    ARG_argsort($$.serg) = CON | REAL;
                    if (fperror)
                    { fperror = FALSE;
                      komerr(texte[40]);
                      $$.sexpr_art = EXPR_FALSCH;
                    }
                    ARG_con_wert($$.serg).datentyp = REAL | REAL_ERLAUBT;
                    ARG_con_wert($$.serg).inhalt.r_val = $1;
                  }
                  else
                  { $$.sexpr_art = EXPR_FALSCH;
                    komerr(texte[80]);
                  }
                }
        |   STRING
                { if ($$.sexpr_str = malloc((size_t)(strlen($1) + 3)))
                  { register TYPTAB *ityp = types_table + akt_index_typ - 1;
                    register DECLIST *dl;

                    sprintf($$.sexpr_str, "\"%s\"", $1);
                    $$.sexpr_art = EXPR_VAR;
                    if (akt_index_typ > index_typ2) bug("parz.y/factor : Strings nicht verbraucht");
                    $$.typserg = akt_index_typ + 1;
                    if ((dl = &ityp[1].parz_decl)->darray) free(dl->darray);
                    dl->darray = NULL; dl->dcount = 0;
                    ityp->typ_arg3 = strlen($1);
                    akt_index_typ += 2;
                    parz_typ($$.typserg);
                    ARG_argsort($$.serg) = STR | CON;
                    ARG_con_wert($$.serg).datentyp = STR ;
                    ARG_con_wert($$.serg).inhalt.s_val = $1;
                  }
                  else
                  { $$.sexpr_art = EXPR_FALSCH;
                    komerr(texte[80]);
                  }
                }
        |   set
                { $$ = $1; }
        |   designator
                { $$ = $1; }
        |   '(' expr ')'
                { if ($$.sexpr_art = $2.expr_art)
                  { if ($$.sexpr_str = malloc((size_t)(strlen($2.expr_str) + 3)))
                    { sprintf($$.sexpr_str, "(%s)", $2.expr_str);
                      if ($2.typerg)
                      { $$.serg = $2.erg;
                        $$.typserg = $2.typerg;
                      }
                      else
                      { $$.serg = $2.lastval;
                        $$.typserg = $2.typlast;
                      }
                    }
                    else
                    { $$.sexpr_art = EXPR_FALSCH;
                      komerr(texte[80]);
                    }
                  }
                  if ($2.expr_str) free($2.expr_str);
                }
        |   NOT factor
                { if ($$.sexpr_art = $2.sexpr_art == EXPR_VAR)
                  { if ($$.sexpr_art = not_ok($2.typserg))
                    { if ($$.sexpr_str = malloc((size_t)(strlen($2.sexpr_str) + 5)))
                      { sprintf($$.sexpr_str, "NOT %s", $2.sexpr_str);
                        $$.typserg = para_typ[BOOL];
                        $$.sexpr_art = EXPR_VAR;
                        para_not(&$$.serg, &$2.serg);
                      }
                      else
                      { $$.sexpr_art = EXPR_FALSCH;
                        komerr(texte[80]);
                      }
                    }
                    else
                    { komerr(texte[314], "NOT");
                    }
                  }
                  else if ($2.sexpr_art)
                  { komerr(texte[305], "NOT");
                  }
                  if ($2.sexpr_str) free($2.sexpr_str);
                }
        |   REDUCE '.' OperatorIdent '(' expr ')'
                { if ($$.sexpr_art = $5.expr_art == EXPR_VAR && $3)
                  { register int etyp = $5.typerg ? $5.typerg : $5.typlast;
                    register char *yyd = yydisplay((int)$3);

                    if ($$.sexpr_art = red_ok((int)$3, etyp))
                    { if ($$.sexpr_str =
                            malloc((size_t)(strlen(yyd) +
                                              strlen($5.expr_str) + 10)))
                      { sprintf($$.sexpr_str, "REDUCE.%s(%s)",
                                yyd, $5.expr_str);
                        $$.typserg = obertyp(etyp);
                        $$.sexpr_art = EXPR_VAR;
                        para_reduce(&$$.serg, (int)$3,
                                    $5.typerg ? &$5.erg : &$5.lastval, $$.typserg);
                      }
                      else
                      { $$.sexpr_art = EXPR_FALSCH;
                        komerr(texte[80]);
                      }
                    }
                    else
                    { komerr(texte[314], yyd); }
                  }
                  else if ($5.expr_art && $5.expr_art != EXPR_VAR)
                  { komerr(texte[304]); }
                  akt_index_typ = index_typ1;
                  if ($5.expr_str) free($5.expr_str);
                }
        ;

OperatorIdent   :   IDENT
                        { register SYMTAB *st;

                          $$ = 0;
                          if (disp &&
                              (st = look_sym($1, disp[akt_tiefe]->top_scope)))
                          { if (st->sym_art == SY_REDOPER || st->sym_art == SY_RED_STDF)
                            { $$ = st->sym_type_scope; }
                          }
                          if (!$$)
                          { komerr(texte[303], key_to_name($1)); }
                        }
                |   AND   { $$ = AND; }
                |   OR    { $$ = OR; }
                ;

set     :   IDENT '{'
                { register SYMTAB *st;
                  register int t;

                  if (st = look_sym($1, akt_scope))
                  { $<int_val>$ = st->sym_type_scope;
                    if (!(st->sym_art == SY_TYPENAME &&
                          types_table[$<int_val>$ - 1].typ_art == TYP_SET))
                    { $<int_val>$ = -337; }
                  }
                  else
                  { $<int_val>$ = -301; }
                }
            SetSubranges '}'
                { register char *tnam = key_to_name($1);

                  if ($<int_val>3 < 0)
                  { komerr(texte[-$<int_val>3], tnam);
                    $$.sexpr_art = EXPR_FALSCH;
                    $$.sexpr_str = NULL;
                  }
                  else
                  { $$ = $4;
                    if ($$.sexpr_art)
                    { if ($$.sexpr_str =
                            malloc((size_t)(strlen(tnam) +
                                              strlen($4.sexpr_str) + 3)))
                      { sprintf($$.sexpr_str, "%s{%s}", tnam, $4.sexpr_str);
                        $$.sexpr_art = EXPR_VAR;
                      }
                      else
                      { $$.sexpr_art = EXPR_FALSCH;
                        komerr(texte[80]);
                      }
                    }
                  }
                  if ($4.sexpr_str) free($4.sexpr_str);
                }
        |   '{'
                { $<int_val>$ = bitset_typ; }
            SetSubranges '}'
                { $$ = $3;
                  if ($$.sexpr_art)
                  { if ($$.sexpr_str = malloc((size_t)(strlen($3.sexpr_str) + 3)))
                    { sprintf($$.sexpr_str, "{%s}", $3.sexpr_str);
                    }
                    else
                    { $$.sexpr_art = EXPR_FALSCH;
                      komerr(texte[80]);
                    }
                    if ($3.sexpr_str) free($3.sexpr_str);
                  }
                }
        |   IDENT '{' '}'
                { register char *tnam = key_to_name($1);
                  register SYMTAB *st;
                  register int t;

                  if ($$.sexpr_art = ((st = look_sym($1, akt_scope)) != NULL))
                  { t = st->sym_type_scope;
                    if (st->sym_art == SY_TYPENAME &&
                        types_table[t - 1].typ_art == TYP_SET)
                    { if ($$.sexpr_str = malloc((size_t)(strlen(tnam) + 3)))
                      { sprintf($$.sexpr_str, "%s{}", tnam);
                        if (para_set_clear(&$$.serg, $$.typserg = t))
                        { $$.sexpr_art = EXPR_VAR; }
                        else
                        { $$.sexpr_art = EXPR_FALSCH;
                          free($$.sexpr_str); $$.sexpr_str = NULL;
                          komerr(texte[80]);
                        }
                      }
                      else
                      { $$.sexpr_art = EXPR_FALSCH;
                        komerr(texte[80]);
                      }
                    }
                    else
                    { $$.sexpr_art = EXPR_FALSCH;
                      $$.sexpr_str = NULL;
                      komerr(texte[337], tnam); } 
                  }
                  else
                  { $$.sexpr_str = NULL;
                    komerr(texte[301], tnam);
                  }
                }
        |   '{' '}'
                { if ($$.sexpr_str = malloc((size_t)3))
                  { strcpy($$.sexpr_str, "{}");
                    new_var(&$$.serg, $$.typserg = bitset_typ, 0);
                    para_const_set(&$$.serg, "00000000000000000000000000000000");
                    $$.sexpr_art = EXPR_VAR;
                    strcpy($$.sexpr_str, "{}");
                  }
                  else
                  { $$.sexpr_art = EXPR_FALSCH;
                    komerr(texte[80]);
                  }
                }
        ;

SetSubranges    :   SetSubranges ',' SetSubrange
                        { register int ok1 = $3.ex1.sexpr_art;
                          register int ok2 = $3.ex2.sexpr_art;

                          $$ = $1;
                          if (ok1 && $1.sexpr_art)
                          { if (rel_ok($3.ex1.typserg, IN, $$.typserg) &&
                                (!ok2 || rel_ok($3.ex2.typserg, IN, $$.typserg)))
                            { if ($$.sexpr_str =
                                    malloc((size_t)(strlen($1.sexpr_str) +
                                                    strlen($3.ex1.sexpr_str) +
                                                    (ok2 ? (strlen($3.ex2.sexpr_str) + 4)
                                                         : 2))))
                              { sprintf($$.sexpr_str, "%s,%s%s%s",
                                        $1.sexpr_str,
                                        $3.ex1.sexpr_str,
                                        ok2 ? ".." : "",
                                        ok2 ? $3.ex2.sexpr_str : "");
                                if (ok2)
                                { para_add_range(&$$, &$3.ex1.serg, &$3.ex2.serg); }
                                else
                                { para_incl_set(&$$, &$3.ex1.serg); }
                                $$.sexpr_art = EXPR_VAR;
                              }
                              else
                              { komerr(texte[80]);
                                $$.sexpr_art = EXPR_FALSCH;
                              }
                            }
                            else
                            { komerr(texte[339]);
                              $$.sexpr_art = EXPR_FALSCH;
                              $$.sexpr_str = NULL;
                            }
                          }
                          else 
                          { $$.sexpr_art = EXPR_FALSCH;
                            $$.sexpr_str = NULL;
                          }
                          if ($1.sexpr_str) free($1.sexpr_str);
                          if ($3.ex1.sexpr_str) free($3.ex1.sexpr_str);
                          if ($3.ex2.sexpr_str) free($3.ex2.sexpr_str);
                        }
                |   SetSubrange
                        { register int ok1 = $1.ex1.sexpr_art;
                          register int ok2 = $1.ex2.sexpr_art;

                          if (ok1 &&
                              para_set_clear(&$$.serg, $$.typserg = (int)$<int_val>0))
                          { if (rel_ok($1.ex1.typserg, IN, $$.typserg) &&
                                (!ok2 || rel_ok($1.ex2.typserg, IN, $$.typserg)))
                            { if ($$.sexpr_str =
                                    malloc((size_t)(strlen($1.ex1.sexpr_str) +
                                                    (ok2 ? (strlen($1.ex2.sexpr_str) + 3)
                                                         : 1))))
                              { sprintf($$.sexpr_str, "%s%s%s",
                                        $1.ex1.sexpr_str,
                                        ok2 ? ".." : "",
                                        ok2 ? $1.ex2.sexpr_str : "");
                                if (ok2)
                                { para_add_range(&$$, &$1.ex1.serg, &$1.ex2.serg); }
                                else
                                { para_incl_set(&$$, &$1.ex1.serg); }
                                $$.sexpr_art = EXPR_VAR;
                              }
                              else
                              { komerr(texte[80]);
                                $$.sexpr_art = EXPR_FALSCH;
                              }
                            }
                            else
                            { komerr(texte[339]);
                              $$.sexpr_art = EXPR_FALSCH;
                              $$.sexpr_str = NULL;
                            }
                          }
                          else 
                          { $$.sexpr_art = EXPR_FALSCH;
                            $$.sexpr_str = NULL;
                          }
                          if ($1.ex1.sexpr_str) free($1.ex1.sexpr_str);
                          if ($1.ex2.sexpr_str) free($1.ex2.sexpr_str);
                        }
                ;

SetSubrange     :   expr
                        { if ($1.expr_art == EXPR_VAR)
                          { $$.ex1.sexpr_art = $1.expr_art;
                            $$.ex1.sexpr_str = $1.expr_str;
                            $$.ex1.serg = $1.typerg ? $1.erg : $1.lastval;
                            $$.ex1.typserg = $1.typerg ? $1.typerg : $1.typlast;
                          }
                          else
                          { $$.ex1.sexpr_art = EXPR_FALSCH;
                            $$.ex1.sexpr_str = NULL;
                            if ($1.expr_art)
                            { komerr(texte[338], $1.expr_str);
                              free($1.expr_str);
                            }
                          }
                          $$.ex2.sexpr_art = EXPR_FALSCH;
                          $$.ex2.sexpr_str = NULL;
                        }
                |   expr PP expr
                        { if ($1.expr_art == EXPR_VAR)
                          { $$.ex1.sexpr_art = $1.expr_art;
                            $$.ex1.sexpr_str = $1.expr_str;
                            $$.ex1.serg = $1.typerg ? $1.erg : $1.lastval;
                            $$.ex1.typserg = $1.typerg ? $1.typerg : $1.typlast;
                          }
                          else
                          { $$.ex1.sexpr_art = EXPR_FALSCH;
                            $$.ex1.sexpr_str = NULL;
                            if ($1.expr_art)
                            { komerr(texte[338], $1.expr_str);
                              free($1.expr_str);
                            }
                          }
                          if ($3.expr_art == EXPR_VAR)
                          { $$.ex2.sexpr_art = $3.expr_art;
                            $$.ex2.sexpr_str = $3.expr_str;
                            $$.ex2.serg = $3.typerg ? $3.erg : $3.lastval;
                            $$.ex2.typserg = $3.typerg ? $3.typerg : $3.typlast;
                          }
                          else
                          { $$.ex2.sexpr_art = $$.ex1.sexpr_art = EXPR_FALSCH;
                            $$.ex2.sexpr_str = NULL;
                            if ($3.expr_art)
                            { komerr(texte[338], $3.expr_str);
                              free($3.expr_str);
                              if ($$.ex1.sexpr_str)
                              { free($$.ex1.sexpr_str);
                                $$.ex1.sexpr_str = NULL;
                              }
                            }
                          }
                        }
                ;

designator  :   designator '[' ExprList ']'
                    { if ($$.sexpr_art = ($1.sexpr_art == EXPR_VAR))
                      { if ($$.sexpr_art = 
                              (types_table[$1.typserg - 1].typ_art == TYP_ARRAY))
                        { register char *elstr = exprlist_string(&$3);

                          if (elstr && ($$.sexpr_str =
                                          malloc((size_t)(strlen($1.sexpr_str) +
                                                            strlen(elstr) + 3))))
                          { $$.sexpr_art = EXPR_VAR;
                            sprintf($$.sexpr_str, "%s[%s]", $1.sexpr_str, elstr);
                            free(elstr);
                            para_arraykomp(&$$, &$1.serg, &$3, $1.typserg);
                            if (!$$.sexpr_art)
                            { free($$.sexpr_str); $$.sexpr_str = NULL; }
                          }
                          else
                          { if (elstr)
                            { komerr(texte[80]);
                              free(elstr);
                            }
                            $$.sexpr_str = NULL;
                            $$.sexpr_art = EXPR_FALSCH;
                          }
                        }
                        else
                        { komerr(texte[324], $1.sexpr_str); }
                      }
                      else if ($1.sexpr_art)
                      { komerr(texte[305], "[]"); }
                      if ($1.sexpr_str) free($1.sexpr_str);
                      exprlist_free(&$3);
                    }
            |   designator '.' IDENT
                    { if ($$.sexpr_art = ($1.sexpr_art == EXPR_VAR))
                      { if ($$.sexpr_art = 
                              (types_table[$1.typserg - 1].typ_art == TYP_RECORD))
                        { register char *memstr = key_to_name($3);

                          if ($$.sexpr_str =
                                malloc((size_t)(strlen($1.sexpr_str) +
                                                  strlen(memstr) + 2)))
                          { sprintf($$.sexpr_str, "%s.%s", $1.sexpr_str, memstr);
                            para_recmem(&$$, &$1.serg, $3, $1.typserg);
                            if (!$$.sexpr_art)
                            { komerr(texte[323], memstr);
                              free($$.sexpr_str); $$.sexpr_str = NULL;
                            }
                          }
                          else
                          { komerr(texte[80]); $$.sexpr_str = NULL;
                            $$.sexpr_art = EXPR_FALSCH;
                          }
                        }
                        else
                        { komerr(texte[322], $1.sexpr_str); }
                      }
                      else if ($1.sexpr_art)
                      { komerr(texte[305], "."); }
                      if ($1.sexpr_str) free($1.sexpr_str);
                    }
            |   designator '^'
                    { if ($$.sexpr_art = ($1.sexpr_art == EXPR_VAR))
                      { if ($$.sexpr_art =
                              ($1.typserg != nil_typ &&
                               !(ARG_argsort($1.serg) & CON) &&
                               types_table[$1.typserg - 1].typ_art == TYP_POINTER))
                        { if ($$.sexpr_str = malloc((size_t)(strlen($1.sexpr_str) + 2)))
                          { sprintf($$.sexpr_str, "%s^", $1.sexpr_str);
                            $$.sexpr_art = EXPR_VAR;
                            para_pointer(&$$, &$1.serg, $1.typserg);
                          }
                          else
                          { komerr(texte[80]); $$.sexpr_str = NULL;
                            $$.sexpr_art = EXPR_FALSCH;
                          }
                        }
                        else
                        { komerr(texte[321], $1.sexpr_str); }
                      }
                      else if ($1.sexpr_art)
                      { komerr(texte[305], "^"); }
                      if ($1.sexpr_str) free($1.sexpr_str);
                    }
            |   IDENT
                    { para_desig_ident(&$$, $1);
                    }
            ;

selection   :   selections
                    { $$ = $1.exp; }
            |   /* eps */
                    { $$.sexpr_art = EXPR_SEL_LEER;
                      $$.sexpr_str = NULL;
                    }
            ;

selections  :   selections ',' '['
                    { char dimnam[20];
                      int dummytok;
                      register long key;

                      sprintf(dimnam, "DIM%d", $1.dimnum + 1);
                      if (!(key = name_to_key(dimnam, &dummytok)) ||
                          !look_sym(key, disp[akt_tiefe]->top_scope))
                      { komerr(texte[329]);
                        $<sexpr_info>$.sexpr_art = EXPR_FALSCH;
                        $<sexpr_info>$.sexpr_str = NULL;
                      }
                      else
                      { para_desig_ident(&$<sexpr_info>$, key); }
                    }
                SelectSubranges ']'
                    { $$ = $1;
                      $$.dimnum++;
                      if ($1.exp.sexpr_art == EXPR_VAR)
                      { if ($5.sexpr_art == EXPR_VAR &&
                            $<sexpr_info>4.sexpr_art == EXPR_VAR)
                        { para_mulop(&$$.exp.serg,
                                     &$1.exp.serg, AND, &$5.serg, para_typ[BOOL]); }
                        else
                        { $$.exp.sexpr_art = EXPR_FALSCH; }
                      }
                      if ($<sexpr_info>4.sexpr_str) free($<sexpr_info>4.sexpr_str);
                      $$.exp.sexpr_str = NULL;
                    }
            |   selections ',' '[' '*' ']'
                    { $$ = $1;
                      $$.dimnum++;
                      if ($$.exp.sexpr_art == EXPR_VAR)
                      { char dimnam[20];
                        int dummytok;
                        register long key;

                        sprintf(dimnam, "DIM%d", $$.dimnum);
                        if (!(key = name_to_key(dimnam, &dummytok)) ||
                            !look_sym(key, disp[akt_tiefe]->top_scope))
                        { komerr(texte[329]);
                          $$.exp.sexpr_art = EXPR_FALSCH;
                        }
                      }
                      $$.exp.sexpr_str = NULL;
                    }
            |   '['
                    { int dummytok;
                      register long key;

                      if (!(key = name_to_key("DIM1", &dummytok)) ||
                          !look_sym(key, disp[akt_tiefe]->top_scope))
                      { komerr(texte[330]);
                        $<sexpr_info>$.sexpr_art = EXPR_FALSCH;
                        $<sexpr_info>$.sexpr_str = NULL;
                      }
                      else
                      { para_desig_ident(&$<sexpr_info>$, key); }
                    }
                SelectSubranges ']'
                    { $$.dimnum = 1;
                      $$.exp = $3;
                      if ($<sexpr_info>2.sexpr_str) free($<sexpr_info>2.sexpr_str);
                    }
            |   '[' '*' ']'
                    { int dummytok;
                      register long key;

                      if (!(key = name_to_key("DIM1", &dummytok)) ||
                          !look_sym(key, disp[akt_tiefe]->top_scope))
                      { komerr(texte[330]);
                        $$.exp.sexpr_art = EXPR_FALSCH;
                      }
                      else
                      { $$.dimnum = 1;
                        new_var(&$$.exp.serg, $$.exp.typserg = para_typ[BOOL], VEC);
                                /* $$ := TRUE; */
                        funcs(do_vbb_zuw, print_zuw);
                        STAT_verg(*stat_ptr) = $$.exp.serg;
                        ARG_argsort(STAT_vc1(*stat_ptr)) = BOOL | CON;
                        ARG_con_wert(STAT_vc1(*stat_ptr)).datentyp = BOOL | BOOL_ERLAUBT;
                        ARG_con_wert(STAT_vc1(*stat_ptr)).inhalt.b_val = TRUE;
                        nextstat();
                        $$.exp.sexpr_art = EXPR_VAR;
                      }
                      $$.exp.sexpr_str = NULL;
                    }
            ;

SelectSubranges     :   SelectSubranges ','
                            { $<sexpr_info>$ = $<sexpr_info>0; }
                        SelectSubrange
                            { $$ = $1;
                              if ($1.sexpr_art == EXPR_VAR &&
                                  $4.sexpr_art == EXPR_VAR)
                              { para_addop(&$$.serg,
                                           &$1.serg, OR, &$4.serg, para_typ[BOOL]);
                              }
                            }
                    |   SelectSubrange
                            { $$ = $1; }
                    ;

SelectSubrange      :   expr
                            { register int etyp =
                                  $1.typerg ? $1.typerg : $1.typlast;
                              register ARG *exp =
                                  $1.typerg ? &$1.erg : &$1.lastval;
                              register int dimtyp = $<sexpr_info>0.typserg;
                              register ARG *dimvar = &$<sexpr_info>0.serg;

                              if ($$.sexpr_art = ($1.expr_art == EXPR_VAR &&
                                                  $<sexpr_info>0.sexpr_art == EXPR_VAR))
                              { if ($$.sexpr_art = zuw_ok(etyp, para_typ[BOOL]))
                                { $$.serg = *exp;
                                  $$.typserg = etyp;
                                  $$.sexpr_art = EXPR_VAR;
                                }
                                else if ($$.sexpr_art =
                                           (zuw_ok(etyp, para_typ[INT]) &&
                                            rel_ok(etyp, EQ, dimtyp)))
                                { para_relop(&$$.serg, dimvar, dimtyp, EQ,
                                                       exp, etyp);
                                  $$.sexpr_art = EXPR_VAR;
                                }
                              }
                              else if ($1.expr_art && $1.expr_art != EXPR_VAR)
                              { komerr(texte[331], $1.expr_str); }
                              if ($1.expr_str) free($1.expr_str);
                              $$.sexpr_str = NULL;
                            }
                    |   expr PP expr
                            { register int etyp1 =
                                  $1.typerg ? $1.typerg : $1.typlast;
                              register ARG *exp1 =
                                  $1.typerg ? &$1.erg : &$1.lastval;
                              register int etyp2 =
                                  $3.typerg ? $3.typerg : $3.typlast;
                              register ARG *exp2 =
                                  $3.typerg ? &$3.erg : &$3.lastval;
                              register int dimtyp = $<sexpr_info>0.typserg;
                              register ARG *dimvar = &$<sexpr_info>0.serg;
                              ARG hilf;

                              if ($$.sexpr_art = ($1.expr_art == EXPR_VAR &&
                                                  $3.expr_art == EXPR_VAR &&
                                                  $<sexpr_info>0.sexpr_art == EXPR_VAR))
                              { if ($$.sexpr_art =
                                      (zuw_ok(etyp1, para_typ[INT]) &&
                                       zuw_ok(etyp2, para_typ[INT]) &&
                                       rel_ok(etyp1, LE, dimtyp) &&
                                       rel_ok(dimtyp, LE, etyp2)))
                                { para_relop(&$$.serg, exp1, etyp1, LE,
                                                       dimvar, dimtyp);
                                  para_relop(&hilf, dimvar, dimtyp, LE,
                                                    exp2, etyp2);
                                  para_mulop(&$$.serg,
                                             &$$.serg, AND, &hilf, para_typ[BOOL]);
                                  $$.sexpr_art = EXPR_VAR;
                                }
                              }
                              else
                              { if ($1.expr_art && $1.expr_art != EXPR_VAR)
                                { komerr(texte[331], $1.expr_str); }
                                if ($3.expr_art && $3.expr_art != EXPR_VAR)
                                { komerr(texte[331], $3.expr_str); }
                              }
                              if ($1.expr_str) free($1.expr_str);
                              if ($3.expr_str) free($3.expr_str);
                              $$.sexpr_str = NULL;
                            }
                    ;

para_on  :  /* eps */
                { unputc('|'); }
         ;

%%

#include "yydispl.h"

extern DECL *neu_decl();
extern DECLIST *dlptr();
