static char sccsid[] = "@(#)psmalloc.c	1.2  com/bossamp,3.1,9021 4/30/90 10:03:13";
/*
 *	    NOTICE TO USERS OF THE SOURCE CODE EXAMPLES
 *
 * THE SOURCE CODE EXAMPLES PROVIDED BY IBM ARE ONLY INTENDED TO ASSIST IN THE
 * DEVELOPMENT OF A WORKING SOFTWARE PROGRAM.  THE SOURCE CODE EXAMPLES DO NOT
 * FUNCTION AS WRITTEN:  ADDITIONAL CODE IS REQUIRED.  IN ADDITION, THE SOURCE
 * CODE EXAMPLES MAY NOT COMPILE AND/OR BIND SUCCESSFULLY AS WRITTEN.
 * 
 * INTERNATIONAL BUSINESS MACHINES CORPORATION PROVIDES THE SOURCE CODE
 * EXAMPLES, BOTH INDIVIDUALLY AND AS ONE OR MORE GROUPS, "AS IS" WITHOUT
 * WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT
 * LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE
 * OF THE SOURCE CODE EXAMPLES, BOTH INDIVIDUALLY AND AS ONE OR MORE GROUPS,
 * IS WITH YOU.  SHOULD ANY PART OF THE SOURCE CODE EXAMPLES PROVE
 * DEFECTIVE, YOU (AND NOT IBM OR AN AUTHORIZED RISC System/6000* WORKSTATION
 * DEALER) ASSUME THE ENTIRE COST OF ALL NECESSARY SERVICING, REPAIR OR
 * CORRECTION.
 *
 * IBM does not warrant that the contents of the source code examples, whether
 * individually or as one or more groups, will meet your requirements or that
 * the source code examples are error-free.
 *
 * IBM may make improvements and/or changes in the source code examples at
 * any time.
 *
 * Changes may be made periodically to the information in the source code
 * examples; these changes may be reported, for the sample device drivers
 * included herein, in new editions of the examples.
 *
 * References in the source code examples to IBM products, programs, or
 * services do not imply that IBM intends to make these available in all
 * countries in which IBM operates.  Any reference to an IBM licensed
 * program in the source code examples is not intended to state or imply
 * that only IBM's licensed program may be used.  Any functionally equivalent
 * program may be used.
 *
 * * RISC System/6000 is a trademark of International Business Machines 
 *   Corporation.
 */

/*
 * COMPONENT_NAME: BOS Sample Programs
 *
 * FUNCTIONS: psmalloc, pscalloc
 *
 * ORIGINS: 27
 *
 */


#include	<sys/types.h>
#include	<sys/shm.h>
#include	<sys/signal.h>
#include	<sys/errno.h>
#include	<setjmp.h>

extern void	*malloc ();
extern void	*calloc ();
extern void	 bzero ();
extern int	 errno;
void		 touch ();
void		*domalloc ();

static jmp_buf	dangerjb;

/*
 * NAME:        psmalloc
 *
 * FUNCTION:    Allocate memory thru malloc and make sure
 *		that paging space is allocated for it.
 *
 * RETURN VALUE DESCRIPTION:
 *		Pointer to the allocated memory.
 *		Or NULL if there was not enough memory or paging
 *		space and errno is set to ENOMEM.
 */
void	*psmalloc (nbytes)
size_t	 nbytes;
{
	return domalloc (nbytes, touch);
}

/*
 * NAME:        pscalloc
 *
 * FUNCTION:    Allocate memory thru malloc using calloc's
 *		parameter conventions and make sure
 *		that paging space is allocated for it.
 *
 * RETURN VALUE DESCRIPTION:
 *		Pointer to the allocated memory.
 *		Or NULL if there was not enough memory or
 *		paging space and errno is set to ENOMEM.
 *		Or NULL if any of the arguments is
 *		zero; or if the multiplication of nmemb
 *		and size overflows.
 */
void	*pscalloc (nmemb, size)
size_t	 nmemb;
size_t	 size;
{
        size_t	nbytes;

        nbytes = nmemb * size;
        if (nbytes == 0 || nbytes / nmemb != size)
                return (void *) 0;

	/*
	 * Bzero touches and clears the pages.
	 */
	return domalloc (nbytes, bzero);
}

/*
 * Catch SIGDANGER and longjmp to domalloc.
 */
static void	danger ()
{
	longjmp (dangerjb, 1);
}

/*
 * Touch the pages that cover [p, p+nbytes-1].
 */
static void	 touch (p, nbytes)
char		*p;
size_t	 nbytes;
{
	char	*endp;
	int	 pgsize;
	volatile char	c;

	/*
	 * A load is enough to cause the
	 * allocation of the paging space
	 */
	pgsize = getpagesize ();
	endp = p + nbytes;
	while (p < endp) {
		c = * (volatile char *) p;
		p += pgsize;
	}
	* (volatile char *) endp;
}

/*
 * Allocate memory and ensure that paging space is allocated for it.
 * If there is no memory or paging space return NULL, in both cases
 * set errno to ENOMEM.
 */
static void	 *domalloc (nbytes, touchfp)
size_t		  nbytes;
void		(*touchfp)();
{
	int	  pgsize;
	int	  pgmask;
	void	(*oldsig)();
	char	 *p;
	char	 *pg;

	/*
	 * If the number of paging space blocks available is not
	 * enough to cover nbytes then don't bother trying.
	 * The pages that malloc would have returned could already
	 * have paging space allocated.
	 */
	pgsize = getpagesize ();
	if (psdanger (SIGDANGER) * pgsize < (int) nbytes) {
		errno = ENOMEM;
		return (void *) 0;
	}

	oldsig = signal (SIGDANGER, danger);
	if (! setjmp (dangerjb)) {
		/*
		 * Touch the pages.
		 */
		if (p = (char *) malloc (nbytes))
			(*touchfp) (p, nbytes);
	} else {
		/*
		 * If we got SIGDANGER while touching the pages,
		 * then disclaim them. Take care not to disclaim
		 * the first and/or last pages if parts of them 
		 * don't belong to the memory allocated by malloc.
		 */
		if (nbytes >= pgsize) {
			pgmask = pgsize - 1;
			pg = (char *) ((int) (p + pgmask) & ~pgmask);
			nbytes -= pg - p + ((int)(p + nbytes) & pgmask);
			if (nbytes != 0)
				(void) disclaim (pg, nbytes, ZERO_MEM);
		}
		free (p);
		p = 0;
		errno = ENOMEM;
	}

	(void) signal (SIGDANGER, oldsig);
	return (void *) p;
}

