/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : Simulation
  Filename     : runexts.h       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.runexts.h
  Version      : 1.2 
  Last changed : 6/2/93 at 20:39:39        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : externe Variablen und Funktionen fuer Simulationsteil
                 von PARZ aus run.c
******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/


extern int pc;                 /* Programmzaehler */
extern int pec;                /* Prozessorzaehler */
extern int akt_tiefe;          /* momentane Prozedurebene */
extern int call_count;         /* zaehlt Zahl der aktiven CALL-Aufrufe */
extern long ausgefuehrt;       /* Zahl der ausgefuehrten Befehle */
extern SCOPETAB *newest_scope; /* neuester Geltungsbereich */
extern SCOPETAB *akt_scope;    /* aktueller Geltungsbereich*/
extern ZEILTAB *akt_line;      /* aktueller Quellzeileneintrag */
extern char called;            /* Flag : Befehl erreicht durch CALL */
extern char reducing;          /* Flag : REDUCE wird gerade ausgefuehrt */
extern char ended;             /* Flag : Programm fertig */
extern char err;               /* Flag : Fehler ist aufgetreten */
extern char vec_bef;           /* Flag : Vektorbefehl wird ausgefuehrt */
extern char zeile_fertig;      /* Flag : Zeile von stdin fertiggelesen */
extern char forced_break;      /* Flag : gewaltsamer Programmabbruch */
extern char no_linefeed;       /* Flag : Ausgabezeile noch nicht fertig */

extern char im_programm;       /* Flag : Simulation laeuft ab */

extern DISPLAY *disp;          /* Stack-Display */

extern VARBLOCK *s_blocks,
                *v_blocks,     /* Listen der fuer lokale Variablen allozierten Bloecke */
                *s_heap,
                *v_heap;       /* Listen der mit NEW allozierten Bloecke */

extern int s_max_b_adr, v_max_b_adr; /* bisher maximal verwendete Adressen in lok. Var. */
extern int s_min_h_adr, v_min_h_adr; /* bisher minimal verwendete Adressen in Heap */

extern ITEM s_spez_vars[5];    /* Variablen MAXTRANS, ACTTRANS, DONE, TERMCH, SRESULT */
extern VARBLOCK s_spez_block;  /* Pseudo-Variablenblock fuer Spezialvariablen */
extern ITEM *v_spez_vars;      /* Variablen ID, VRESULT */
extern VARBLOCK v_spez_block;  /* Pseudo-Variablenblock fuer Vektor-Spezialvariablen */

extern int bicount;            /* Zaehler fuer Aufrufe von 'item_ptr()' in einem Befehl */

extern char *aktive_pes;       /* Bitstring : gibt momentan aktive PEs an */
extern char *dummy_aktive_pes; /* Prozessoraktivierung fuer LOAD und STORE mit einem PE */
extern int last_akt_pe;        /* Nummer des letzten aktiven PEs */
extern int anz_akt_pes;        /* Zahl der momentan aktiven PEs */

extern AKTBLOCK *step_over_block;      /* Aktivierungsblock in dem gesteppt wird */
extern AKTBLOCK *akt_step_block;       /* Aktueller echter Aktivierungsblock */

extern int tr_flag;            /* Flag : In Befehl wurde TRACE-Variable veraendert */

extern ITPTRS *zielits;        /* Beschreibung der Zielvariable des aktuellen Befehls */
extern VBLOCKS *zielbs, *dummybs; /* Blockbeschreibungen fuer ziel und quelle */

extern int exit_code;          /* Rueckgabewert eines 'start()'-Aufrufs in REDUCE */

extern AKTBLOCK *new_aktblock();
extern int akt_return();
extern ITPTRS *item_ptr();
extern ITEM *gl_item(), *n_item(), *n_item_ptr();
extern VARBLOCK *make_vars();
