letter [a-zA-Z]
space  [\t ]
frei   [\n\t ]
digit  [0-9]

%{
#include <ctype.h>

# ifdef SUN
# define mytoupper(x) (islower(x) ? toupper(x) : (x))
# else
# define mytoupper toupper
# endif

char  s[200][20];
int   b[200],
      i,
      j,
      y = 0,
      max_len = 0;

%}
%%
#{space}*define          s[y][0] = '\"';
{letter}+                { for (i = 1; i <= yyleng; i++)
                           { s[y][i] = mytoupper(yytext[i - 1]);
                           }
                           max_len = (yyleng > max_len)? yyleng : max_len;
                           s[y][i++] = '\"';
                           s[y][i] = 0;
                         }
"-"*{digit}+             y++;
{frei}*                  ;
.                        putc(yytext[0], stderr);

%%

yywrap()
{   int i;
    j = 0;
    umrechnen(1);
    printf("    {\" \",0,\n");
    for (i = 1; i <= y; i++)
    {
        printf("        %20s,",s[b[i]]);
        s[b[i]][0] = '(';
        s[b[i]][strlen(s[b[i]]) - 1] = ')';
        printf(" token%s",s[b[i]]);
        if (i == y) { printf("\n};\n"); }
        else printf(",\n");
    }
    printf("#\tdefine  MAX_KEYWORDS  %d\n\n",y);
    printf("#\tdefine  MAX_LENG %d\n\n",max_len + 2);
    return(1);
}

umrechnen(i)
int i;
{
    if (i > y) return;
    umrechnen(2 * i);
    b[i] = j++;
    umrechnen(2 * i + 1);
}
