/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : General
  Filename     : terminal.c       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.terminal.c
  Version      : 1.3 
  Last changed : 9/27/93 at 14:05:05        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : Terminalumschaltungen fuer PARZ

******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/

static char sccs_id[] = "@(#)terminal.c	1.3  9/27/93 PARZ - General (Frank Sembach)";


#ifdef APOLLO

#include <curses.h>

#include "/sys/ins/base.ins.c"
#include "/sys/ins/pad.ins.c"

more_on()               /* raw- bzw. cbreak-Modus einschalten */
{ status_$t status;

  fflush(stdout);
  if (strcmp(ttyname(fileno(stdin)), "/dev/tty"))
  { savetty(); crmode(); noecho(); }
  else
  { pad_$raw(stream_$stdin, status); }
}

more_off()              /* raw- bzw. cbreak-Modus ausschalten */
{ status_$t status;

  kill_input();
  if (strcmp(ttyname(fileno(stdin)), "/dev/tty"))
  { echo(); nocrmode(); resetty(); }
  else
  { pad_$cooked(stream_$stdin, status); }
  kill_input();
}

#endif


#ifdef SUN

#include <curses.h>

# ifdef MIPS

init_term()
{ filter(); initscr(); endwin(); }

end_term()
{ /* endwin(); */ }

more_on()               /* raw- bzw. cbreak-Modus einschalten */
{ fflush(stdout);
  refresh();
  cbreak(); noecho(); nonl();
}

more_off()              /* raw- bzw. cbreak-Modus ausschalten */
{ kill_input();
  echo(); nocbreak(); nl();
  endwin(); 
  kill_input();
}

# else
#  ifdef HP_UX
extern char *getenv();

char defterm[] = "TERM=vt100";

init_term()
{ register char *termenv = getenv("TERM");

  if (!termenv || strcmp(termenv, "unknown") == 0)
  { putenv(defterm); }
}

end_term()
{ resetterm(); }

more_on()               /* raw- bzw. cbreak-Modus einschalten */
{ fflush(stdout);
  initscr();
  cbreak(); noecho(); nonl();
}

more_off()              /* raw- bzw. cbreak-Modus ausschalten */
{ kill_input();
  nl(); echo(); nocbreak();
  endwin(); resetterm();
  kill_input();
}

#  else
#   ifdef RS6000

init_term()
{ /*initscr(); echo();*/ }

end_term()
{ resetterm(); }

more_on()               /* raw- bzw. cbreak-Modus einschalten */
{ fflush(stdout);
  initscr();
  cbreak(); noecho(); nonl();
}

more_off()              /* raw- bzw. cbreak-Modus ausschalten */
{ kill_input();
  echo(); nocbreak(); nl();
  endwin(); resetterm();
  kill_input();
}

#   else

more_on()               /* raw- bzw. cbreak-Modus einschalten */
{ fflush(stdout);
  savetty(); crmode(); noecho();
}

more_off()              /* raw- bzw. cbreak-Modus ausschalten */
{ kill_input();
  echo(); nocrmode(); resetty();
  kill_input();
}

#   endif
#  endif
# endif
#endif

#ifdef PC
#  include <stdlib.h>

#  ifdef MAC
#  include <console.h>
extern int cmode;
more_on()
{ fflush(stdout);
  csetmode(C_RAW, stdin);
  cmode = C_RAW;
}

more_off()
{ kill_input();
  csetmode(C_ECHO, stdin);
  cmode = C_ECHO;
}

#  else

more_on(){}
more_off(){}

#  endif
#endif

