SYSTEM StochasticHull;
(*
	This program fits a stochastic convex hull TO a set of data 
	points
*)
CONST
	precision	= 1.11e-16;            (* smallest no difference: *)
	pi 		= 3.141592653589793238462643;
	MaxDimension 	= 5; (*of vector space we are examining*)
	MaxObs		= 1000;
	SmallNo 	= -744.0; (*FOR exponential PROCEDURE*)
	maxcc 		= 20;
	maxt 		= maxcc;
	maxVertices 	= 10; (*maximum number of vertex/faces*)
TYPE

	short = [-128..127];
	medium = [-32768..32767];
(*	shortFile = FILE OF short;*)

	AVLRange = (L, R, B);

	order = (lessThan, equal, greaterThan);
	
	vectr = ARRAY[1..MaxDimension] OF REAL;
	ivectr = ARRAY[1..MaxDimension] OF medium;
	ssqsVectr	= ARRAY[1..maxcc] OF REAL;
	matrx 		= ARRAY[0..MaxDimension],[0..MaxDimension] OF REAL ;
	vectrAll = vectr;
	sqrMatrx = ARRAY[1..MaxDimension] OF  vectr;
	ConstMatrx = ARRAY[1..MaxDimension] ,[1..maxcc] OF REAL;
	symmat 		= RECORD             (* upper triangle of symmetric, with inverse in row 2 of vector *)
(*                      stored so that can be viewded as either
                            1. upper triangle, row by row
                                          or
                            2. lower triangle, column by column
*)
          			size 	: INTEGER ;
          			det 	: REAL ;
          			data1, data2 : ssqsVectr ;
          			END ;
 
	vectorPtr =  POINTER TO vector;
	vector = RECORD
			x: REAL;
			next: vectorPtr;
			END ;

	listVectorPtr =  POINTER TO listVector;
	listVector = RECORD
			values: vectorPtr;
			nextVector: listVectorPtr;
			END;

	MatrixVector = ARRAY[1..MaxObs] OF vectorPtr;

	listPtrs =  POINTER TO listPtr;
	listPtr = RECORD
			Ptr: listVectorPtr;
			nextPtr: listPtrs;
			END;

	simplex = RECORD
			probability, volume: REAL;
			midpoint: vectorPtr;
			vertices: listPtrs;
			END;

	simplexPtr =  POINTER TO simplices;
	simplices = RECORD
			Ptr: simplex;
			nextPtr: simplexPtr;
			END;


	sqrMatrix = ARRAY[1..MaxDimension], [1..MaxDimension] OF REAL;


	keyType = RECORD
		normal: vectorPtr;
		vertices: listPtrs;
		AVLBalance: AVLRange;
		END;

	AVLTree = POINTER TO treeEdges;

	treeEdges = RECORD
			edge: keyType;
			left: AVLTree;
			right: AVLTree;
			END;

	vertex		=	(a,b,c,d,e,f,g,h,i,j);
	point		= 	SET OF vertex;
	face		=	[1..maxVertices];
	face0 		=	[0..maxVertices];
	faceSet 	= 	SET OF face;

	setPtr		=	 POINTER TO listSets;
	listSets	=	RECORD
					vertices: faceSet;
					nextFaceSet: setPtr;
					END;
SCALAR
	debug: BOOLEAN;
	ii, Dimension, NoOfEndmembers, noParams, noVectors, kept, LevelSubdivision: INTEGER;
	Log2PI: REAL;
	nextRay, SetOfPropns: listVectorPtr;
	SetOfPoints: MatrixVector;
	Simplex: simplex;
	PartitionedSimplex: simplexPtr;
	last: listPtrs;
	GenericPartition: setPtr;
	EndMembers: sqrMatrx;
	ssp: symmat;

PROCEDURE sqr(SCALAR a: REAL): SCALAR REAL;
BEGIN
RETURN(a * a);
END sqr;

PROCEDURE SVD (SCALAR VAR a: sqrMatrix; SCALAR m,n: INTEGER; SCALAR VAR w: vectr; SCALAR VAR v: sqrMatrix);
(* programs using routine svdcmp must define the TYPEs*)
CONST
   nmax=100;
SCALAR
   goto2: BOOLEAN;
   nm,l,k,j,its,i: INTEGER;
   z,y,x,scale,s,h,g,f,c,anorm: REAL;
   rv1: ARRAY [1..nmax] OF REAL;
PROCEDURE sign(SCALAR a,b: REAL): SCALAR REAL;
   BEGIN
      IF (b >= 0.0) THEN RETURN(ABS(a)) ELSE RETURN(-ABS(a)) END;
   END sign;

PROCEDURE max(SCALAR a,b: REAL): SCALAR REAL;
   BEGIN
      IF (a > b) THEN RETURN(a) ELSE RETURN(b) END;
   END max;

BEGIN
   g := 0.0;
   scale := 0.0;
   anorm := 0.0;
   FOR i := 1 TO n DO 
      l := i+1;
      rv1[i] := scale*g;
      g := 0.0;
      s := 0.0;
      scale := 0.0;
      IF (i <= m) THEN      
         FOR k := i TO m DO      
            scale := scale+ABS(a[k,i])
         END;
         IF (scale <> 0.0) THEN      
            FOR k := i TO m DO      
               a[k,i] := a[k,i]/scale;
               s := s+a[k,i]*a[k,i]
            END;
            f := a[i,i];
            g := -sign(Sqrt(s),f);
            h := f*g-s;
            a[i,i] := f-g;
            IF (i <> n) THEN      
               FOR j := l TO n DO      
                  s := 0.0;
                  FOR k := i TO m DO      
                     s := s+a[k,i]*a[k,j]
                  END;
                  f := s/h;
                  FOR k := i TO m DO      
                     a[k,j] := a[k,j]+
                        f*a[k,i]
                  END
               END
            END;
            FOR k := i TO m DO      
               a[k,i] := scale*a[k,i]
            END
         END
      END;
      w[i] := scale*g;
      g := 0.0;
      s := 0.0;
      scale := 0.0;
      IF ((i <= m) AND (i <> n)) THEN      
         FOR k := l TO n DO      
            scale := scale+ABS(a[i,k])
         END;
         IF (scale <> 0.0) THEN      
            FOR k := l TO n DO      
               a[i,k] := a[i,k]/scale;
               s := s+a[i,k]*a[i,k]
            END;
            f := a[i,l];
            g := -sign(Sqrt(s),f);
            h := f*g-s;
            a[i,l] := f-g;
            FOR k := l TO n DO      
               rv1[k] := a[i,k]/h
            END;
            IF (i <> m) THEN      
               FOR j := l TO m DO      
                  s := 0.0;
                  FOR k := l TO n DO      
                     s := s+a[j,k]*a[i,k]
                  END;
                  FOR k := l TO n DO      
                     a[j,k] := a[j,k]
                        +s*rv1[k]
                  END
               END
            END;
            FOR k := l TO n DO      
               a[i,k] := scale*a[i,k]
            END
         END
      END;
      anorm := max(anorm,(ABS(w[i])+ABS(rv1[i])))
   END;
   FOR i := n TO 1 BY -1 DO      
      IF (i < n) THEN      
         IF (g <> 0.0) THEN      
            FOR j := l TO n DO      
               v[j,i] := (a[i,j]/a[i,l])/g
            END;
            FOR j := l TO n DO      
               s := 0.0;
               FOR k := l TO n DO      
                  s := s+a[i,k]*v[k,j]
               END;
               FOR k := l TO n DO      
                  v[k,j] := v[k,j]+s*v[k,i]
               END
            END
         END;
         FOR j := l TO n DO
            v[i,j] := 0.0;
            v[j,i] := 0.0
         END
      END;
      v[i,i] := 1.0;
      g := rv1[i];
      l := i
   END;
   FOR i := n TO 1 BY -1 DO
      l := i+1;
      g := w[i];
      IF (i < n) THEN
         FOR j := l TO n DO
            a[i,j] := 0.0
         END
      END;
      IF (g <> 0.0) THEN
         g := 1.0/g;
         IF (i <> n) THEN
            FOR j := l TO n DO
               s := 0.0;
               FOR k := l TO m DO
                  s := s+a[k,i]*a[k,j]
               END;
               f := (s/a[i,i])*g;
               FOR k := i TO m DO
                  a[k,j] := a[k,j]+f*a[k,i]
               END
            END
         END;
         FOR j := i TO m DO
            a[j,i] := a[j,i]*g
         END
      ELSE
         FOR j := i TO m DO
            a[j,i] := 0.0
         END
      END;
      a[i,i] := a[i,i]+1.0
   END;
  	k := n;
   	LOOP
		its := 0;
		LOOP
			INC(its);
			goto2 := FALSE;
			l := k;
			LOOP
            			nm := l-1;
            			IF ((ABS(rv1[l])+anorm) = anorm) THEN 	
					goto2 := TRUE;
					EXIT;
					END;
            			IF ((ABS(w[nm])+anorm) = anorm) THEN  
					EXIT;
					END;
				IF l = 1 THEN
					EXIT;
					END;
				DEC(l);
				END;
			IF NOT goto2 THEN 
		       		c := 0.0;
         			s := 1.0;
         			FOR i := l TO k DO
            				f := s*rv1[i];
            				IF ((ABS(f)+anorm) <> anorm) THEN
               					g := w[i];
               					h := Sqrt(f*f+g*g);
               					w[i] := h;
               					h := 1.0/h;
               					c := (g*h);
               					s := -(f*h);
               					FOR j := 1 TO m DO
                  					y := a[j,nm];
                  					z := a[j,i];
                  					a[j,nm] := (y*c)+(z*s);
                  					a[j,i] := -(y*s)+(z*c)
               						END;
            					END;
					END;
         			END;
			z := w[k];
         		IF (l = k) THEN
            			IF (z < 0.0) THEN
               				w[k] := -z;
               				FOR j := 1 TO n DO
               					v[j,k] := -v[j,k]
            					END
         				END;
        			EXIT; 
         			END;
         		IF (its = 30) THEN
         			WriteString ('no convergence in 30 svdcmp iterations');
				WriteLn;
         			END;
        	 	x := w[l];
         		nm := k-1;
         		y := w[nm];
         		g := rv1[nm];
         		h := rv1[k];
         		f := ((y-z)*(y+z)+(g-h)*(g+h))/(2.0*h*y);
         		g := Sqrt(f*f+1.0);
         		f := ((x-z)*(x+z)+h*((y/(f+sign(g,f)))-h))/x;
         		c := 1.0;
         		s := 1.0;
         		FOR j := l TO nm DO
            			i := j+1;
            			g := rv1[i];
            			y := w[i];
            			h := s*g;
            			g := c*g;
            			z := Sqrt(f*f+h*h);
            			rv1[j] := z;
            			c := f/z;
            			s := h/z;
            			f := (x*c)+(g*s);
            			g := -(x*s)+(g*c);
            			h := y*s;
            			y := y*c;
            			FOR nm := 1 TO n DO
               				x := v[nm,j];
               				z := v[nm,i];
               				v[nm,j] := (x*c)+(z*s);
               				v[nm,i] := -(x*s)+(z*c)
            				END;
            			z := Sqrt(f*f+h*h);
            			w[j] := z;
            			IF (z <> 0.0) THEN
               				z := 1.0/z;
               				c := f*z;
               				s := h*z
            				END;
            			f := (c*g)+(s*y);
            			x := -(s*g)+(c*y);
            			FOR nm := 1 TO m DO
               				y := a[nm,j];
               				z := a[nm,i];
               				a[nm,j] := (y*c)+(z*s);
               				a[nm,i] := -(y*s)+(z*c)
            				END
         			END;
         		rv1[l] := 0.0;
         		rv1[k] := f;
         		w[k] := x;
	 		IF its = 30 THEN 
				EXIT;
				END;
			END;
		IF i = 1 THEN
			EXIT;
			END;
		DEC(i);
  		END;
END SVD;

PROCEDURE invert(SCALAR VAR m : symmat; SCALAR inverse : BOOLEAN) ;
(*
        this works on a symmetric matrix which is stored so that it can be viewed as
         1. upper triangle, stored row by row
                    or
         2. lower triangle, stored column by column
           
         if the value of the BOOLEAN is false, the matrix is not inverted, but
         its triangular (cholesky) decomposition is returned. In this case
         the matrix operated on is in m.data2 and the result is returned
         in m.data1 stored as above.
	

	Modifications:-
	 
	 Matrices with negative matrices have some sort of g-inverse returned
	 through the diagonal element being put TO zero, see trltmd

*)
SCALAR
      t : ssqsVectr;
      nd : INTEGER ;
      nzp : ARRAY[1..10] OF INTEGER ;

PROCEDURE trltm(SCALAR n : INTEGER ; SCALAR  a : ssqsVectr ; SCALAR VAR t : ssqsVectr ; SCALAR VAR dt : REAL ) ;
CONST
      c=precision ;
SCALAR
      i,ii,ij,is,j,k,ki,kj,ks,l : INTEGER ;
      fctr,zij : REAL ;
BEGIN
nd:= 0 ;
FOR i:=1 TO n DO
    is:=i*(i-1) DIV 2 ; ii:=(i-1)*n+i-is ;
    FOR j:=i TO n DO
      	  ij:=(i-1)*n+j-is ; l:=i-1 ; zij:=0.0 ;
          IF i=1 THEN  
		fctr:=a[ij]
          ELSE
                FOR k:=1 TO l DO
                       ks:=k*(k-1) DIV 2 ; ki:=(k-1)*n+i-ks ; kj:=(k-1)*n+j-ks ;
                       zij:=zij+t[ki]*t[kj] ;
                       END ;
                fctr:=a[ij]-zij ;
                END ;
          IF j>= i THEN
                 IF j=i THEN
       		        IF (ABS(fctr) > ABS(c * a[ii])) AND (fctr >= 0.0) THEN
				t[ij]:= Sqrt(fctr)
                        ELSE
                                t[ij]:=0.0 ;
                                nd:=nd+1 ;
                                nzp[nd]:=i ;
                                WriteString(' g inverse used diagonal element ');
				WriteInt(i, 3);
				WriteString(' zeroised' ) ;
				END;
		       IF fctr < 0.0 THEN 
				WriteString(' fctr negative')
                       ELSE	
				IF t[ii] > 0.0  THEN 
					t[ij]:=fctr/t[ii]
                                ELSE 
					t[ij]:=0.0 ;
					END;
				END;
                	END ;
           	END ;
	END ;
END;
dt:=1.0 ;
FOR i:=1 TO n DO
    is:=i*(i-1) DIV 2 ;
    ii:=(i-1)*n+i-is ;
    dt:=dt*t[ii] ;
    END ;
dt:=sqr(dt) ;
END trltm;

PROCEDURE inwtg(SCALAR n: INTEGER ; SCALAR u : ssqsVectr ; SCALAR VAR a : ssqsVectr) ;
SCALAR
      i,id,ii,ij,il,is,i1,j,jj,jl,jm,js,j1,l,lj,ls,nn,nr : INTEGER ;
      fctor,fctr : REAL ;
PROCEDURE mtincr(SCALAR nv : INTEGER ; SCALAR VAR a : ssqsVectr ; SCALAR nr : INTEGER ) ;
(*
increases the matrix a; stored in 1d FORm; by adding zeros TO the nr th row
*)
SCALAR
      i,ib,ij,ir,is,i1,j,jb,nj : INTEGER ;
BEGIN
nj:=nv ;
FOR ib:= 1 TO nv DO
      i:=nv-ib+1 ; is:=i*(i-1) DIV 2 ; i1:=(i-1)*nv-is ;
      FOR jb:=i TO nv DO
            j:=nv-jb+i ; ij:=i1+j ;
            IF i< nr THEN
                     IF j=nr THEN
                           nj:=nj-1 ; a[ij]:=0.0 ;
                          ELSE
                           ir:=ij-nj ; a[ij]:=a[ir]
                          END ;
                     ELSE
                      IF i=nr THEN
                           nj:=nj-1 ; a[ij]:=0.0 ;
                          ELSE
                           ir:=ij-nj ; a[ij]:=a[ir] ;
                          END ;
                    END ;
		END;
           END ;
END mtincr;

PROCEDURE mtrdce(SCALAR nv : INTEGER ; SCALAR VAR a : ssqsVectr ; SCALAR nr : INTEGER ) ;
(*
  reduces a matrix a, eliminating the nr th row and column from a
 matrix stored in upper diagonal
*)
SCALAR
      i,ij,ir,is,i1,j,nj : INTEGER ;
BEGIN
nj:=0 ;
FOR i:=1 TO nv DO
     is:=i*(i-1) DIV 2 ; i1:=(i-1)*nv-is ;
     FOR j:=i TO nv DO
          ij:=i1+j ;
          IF i<nr THEN
                  IF j=nr THEN
                     nj:=nj+1 ;
                   ELSE
                     ir:=ij-nj ;
                     a[ir]:=a[ij] ;
                   END ;
                 ELSE IF i=nr THEN
                      nj:=nj+1 ;
                    ELSE
                      ir:=ij-nj ;
                      a[ir]:=a[ij] ;
                     END ;
                    END ;
     END ;
   END ;
END mtrdce;

BEGIN
IF nd<>0 THEN
       FOR id:=1 TO nd DO
             nr:=nzp[id]-id+1 ;
             mtrdce(n,u,nr) ;
             n:=n-1 ;
           END ;
     END ;
nn:=n*(n+1) DIV 2 ;
a[nn]:=1.0/sqr(u[nn]) ;
FOR j1:=1 TO n DO
      j:=n+1-j1 ; js:=j*(j-1) DIV 2 ; jj:=(j-1)*n+j-js ;
      FOR i1:=j1 TO n DO
            i:=n+1-i1 ; is:=i*(i-1) DIV 2 ; ij:=(i-1)*n+j-is ; ii:=(i-1)*n+i-is ;
           IF i<> n THEN jm:=i+1 ;
            IF i<>j THEN
                 fctr:=0.0 ;
                 FOR l:=jm TO n DO
                      il:=(i-1)*n+l-is ; ls:=l*(l-1) DIV 2 ; jl:=(j-1)*n+l-js ; lj:=(l-1)*n+j-ls ;
                      IF j<l THEN lj:=jl END;
                      fctr:=fctr-u[il]*a[lj] ;
                   END ;
                 a[ij]:=fctr/u[ii] ;
               ELSE
                 fctor:=0.0 ;
                 FOR l:=jm TO n DO
                      jl:=(j-1)*n+l-js ;
                      fctor:=fctor+u[jl]*a[jl] ;
                     END ;
                 a[jj]:=1.0/sqr(u[ii]) -fctor/u[ii] ;
                 END ;
                END ;
           END ;
END ;
IF nd<>0 THEN
       FOR id:=1 TO nd DO
             nr:=nzp[id] ; n:=n+1 ;
             mtincr(n,u,nr) ; mtincr(n,a,nr) ;
           END ;
   END ;
END inwtg;

BEGIN
IF (m.size < 1) OR (m.size > maxt)
	THEN WriteString('faulty dimension FOR symmetric matrix in "inverse"')
ELSE
	IF inverse=TRUE THEN
        	trltm(m.size,m.data1,t,m.det) ;
       		inwtg(m.size,t,m.data2)
	ELSE trltm(m.size,m.data2,m.data1,m.det) END;
    END;
END invert;
   
PROCEDURE rsymrt( VECTOR x : vectr ; SCALAR a : symmat ; SCALAR row : INTEGER ) : VECTOR REAL ;
SCALAR
      i,j,ij,nv : INTEGER ;

VECTOR
      dc,d : REAL ;
BEGIN
nv:=a.size ;
d:=0.0 ;
ij:=0 ;
FOR i:=1 TO nv DO 
	FOR j:=i TO nv DO
		ij:=ij+1 ;
       		IF row = 1 THEN 
			dc:=x[i]*a.data1[ij]*x[j] 
        	ELSE 
			dc:=x[i]*a.data2[ij]*x[j] ;
			END;
       		IF i<j THEN  
			dc:=2.0*dc ;
			END;
       		d:=d+dc ;
		END;
	END;
RETURN(d) ;
END rsymrt;



  PROCEDURE rotate(SCALAR j, k, m, t: INTEGER; SCALAR s, c: REAL; SCALAR VAR w: ConstMatrx);

  (*
          this PROCEDURE perFORms a plane rotation of w, rows j and k
          (j < k normally) from column m TO column t.  The angle of rotation has
 	  sine s and cosine c.
  *)
  SCALAR
          i : INTEGER;
          r : REAL;
  BEGIN
  FOR i := m TO t DO
           r := w[j][i];
           w[j][i] := r * c + s * w[k][i];
           w[k][i] := - r * s + c * w[k][i];
  	END; (*FOR*)
  END rotate;

  PROCEDURE backsubstitute(SCALAR n, g: INTEGER; SCALAR VAR a: sqrMatrx);
  (*
            This algorithm is designed TO follow Gauss elimination, but can also
            be applied TO systems of equations which are already trianglur, or
            which have been brought TO triangular FORm by other methods e.g.
            Givens reduction.

            based on Nash "Compact numerical methods FOR computers"
  *)
  SCALAR
            i, j, k: INTEGER;
            s: REAL;
  BEGIN
  (*
         A, the working ARRAY which is n by (n+g) and contains the triangular
  matrix R and the g right hand sides f. the triangular part 'R' is contained
  in the first n by n rows by cols of a
  *)
  FOR i := n+1 TO n+g DO
           a[n][i] := a[n][i] / a[n][n]; (*to determine last element of solution*)
           FOR j := n - 1 TO 1 BY -1 DO
                   s := a[j][i];
                   FOR k := j + 1 TO n DO 
			s := s - a[j][k] * a[k][i];
			END;
                   (* TO subtract contributions from solution which have
                     already been determined *)
                   a[j][i] := s / a[j][j] (*fix solution element j *)
                   END; (*solution vector i now determined *)
            END; (* FOR on i *)
  (*
            the solutions are contained in columns n+1, n+2,...,n+g of the working
            ARRAY 
  *)
  END backsubstitute;

PROCEDURE givens(SCALAR position, n, g, nobs: INTEGER; SCALAR VAR w: ConstMatrx);
  (*
         This PROCEDURE does a Given's reduction based on
         Nash "Compact numerical methods FOR computers"

	This is used FOR solving least squares problems without
	FORming sums of squares matrices.

	Input is a matrix a (design matrix), also expects TO find
	cols of y VARiates concatenated with it, making 'a' actually
	larger than it nominally is
  *)
  (*CONST
         g = 1; 
      
         g is the number of dependent variables that we are considering,
         FOR my initial situation it is set TO 1, but written for
         general g.  Thus the matrix a that we are triangularing is
         concatenated with the vectors 'b' that are the dependent
         variables thus eliminating the need TO also multiply
         them (ie TO rotate them separately)
  *)
  SCALAR
         i, j, t, k, m: INTEGER;
         b, c, s, p, tol, dummy: REAL;

BEGIN
IF position = 1 THEN 
	FOR i := 1 TO n DO 
		FOR j := 1 TO n + g DO 
			w[i][j] := 0.0;
			END;
		END;
	END;
tol := sqr(FLOAT(n) * precision); (*precision = machine precision *)
t := n + g;
k := n + 1;
FOR j := 1 TO n DO
         m := j;
         s := w[k][j];
         c := w[j][j];
         b := ABS(c);
         IF ABS(s) > b THEN 
		b := ABS(s);
		END;
         IF b > 0.0 THEN (*rotation needed *)
                c := c / b;
                s := s / b; (* normalizations TO avoid over(under)flow *)
                p := Sqrt(sqr(c) + sqr(s));
                s := s / p;
                IF ABS(s) > tol THEN (* rotation needed *)
                            c := c / p;
                            rotate(j, k, m, t, s, c, w);
                            END;
                END;
	END;
(*IF position = nobs THEN backsubstitute(n, g, w);*)
END givens;

PROCEDURE rowOrthogonalisation(SCALAR n, t: INTEGER; SCALAR VAR w: ConstMatrx);
SCALAR
	i, j, k, m, count: INTEGER;
	p, q, r, c, s, tol: REAL;
BEGIN
tol := sqr(FLOAT(n) * precision); (*precision = machine precision *)
m := 1;
REPEAT 
	count := n * (n - 1) DIV 2;
	FOR j := 1 TO n - 1 DO
		FOR k := j + 1 TO n DO
			p := 0.0;
			q := 0.0;
			r := 0.0;
			FOR i := 1 TO n DO
				p := p + w[j][i] * w[k][i];
				q := q + sqr(w[j][i]);
				r := r + sqr(w[k][i]);
				END; (*i*)
			IF q < r THEN
				c := 0.0;
				s := 1.0;
				rotate(j, k, m, t, s, c, w);
			ELSE
				IF  (q * r = 0.0) OR (sqr(p) / ( q * r) < tol) THEN count := count - 1
				ELSE
					q := q - r;
					r := Sqrt(4.0 *sqr(p) + sqr(q));
					c := Sqrt((r + q) / (2.0 * r));
					s := p / (r * c);
					rotate(j, k, m, t, s, c, w);
					END;
				END;
			END; (*k*)
		END; (*j*)
UNTIL count = 0;
END rowOrthogonalisation;

PROCEDURE singularValues(SCALAR n: INTEGER; SCALAR VAR w: ConstMatrx; SCALAR VAR z: vectrAll);
SCALAR
	i, j: INTEGER;
	s, tol: REAL;
BEGIN
tol := sqr(FLOAT(n) * precision); (*precision = machine precision *)
FOR j := 1 TO n DO
	s := 0.0;
	FOR i := 1 TO n DO 
		s := s + sqr(w[j][i]);
		END;
	s := Sqrt(s);
	z[j] := s;
	IF s >= tol THEN 
		FOR i := 1 TO n DO 
			w[j][i] := w[j][i] / s;
			END;
		END;
	END; (*j*)
END singularValues;

PROCEDURE leastSqSn(SCALAR n, g: INTEGER; SCALAR w: ConstMatrx; SCALAR z: vectrAll; SCALAR VAR x: ConstMatrx);
(*
	q is a tolerance value. All singular values smaller than this
	tolerance will be presumed zero. This permits principal components
	solutions TO be found.
*)
CONST
	q = 0.0;
SCALAR
	i, j, k: INTEGER;
	p: REAL;
BEGIN
FOR i := 1 TO g DO
	FOR j := 1 TO n DO
		p := 0.0;
		FOR k := 1 TO n DO 
			IF z[k] > q THEN 
				p := p + w[k][j] * w[k][n + i] / z[k];
				END;
			END;
		x[j][i] := p;
		END; (*j*)
	END; (*i*)
END leastSqSn;
	
PROCEDURE solveLinearEquations(SCALAR n, p, k: INTEGER; SCALAR old, new: sqrMatrx; SCALAR VAR answer: ConstMatrx; SCALAR VAR values: vectrAll);
(*
	solves old * answer = new;
	where old (n, p)
	      new (n, k)
	      answer (p, k)
*)
SCALAR
	i, j, position: INTEGER;
BEGIN
position := 0;
FOR i := 1 TO n DO
	position := position + 1;
	FOR j := 1 TO p DO 
		answer[p + 1][j] := old[i][j];
		END;
	FOR j := p + 1 TO p + k DO 
		answer[p + 1][j] := new[i][j - p];
		END;
	givens(position, p, k, n, answer);
        END;
rowOrthogonalisation(p, p + k, answer);
singularValues(p, answer, values);
leastSqSn(p, k, answer, values, answer);
END solveLinearEquations;

PROCEDURE product(SCALAR a:ssqsVectr; SCALAR b: sqrMatrx; SCALAR VAR c:sqrMatrx;SCALAR  n, p: INTEGER);
(*
	products a*b TO give c
*)
SCALAR
	i, j, k, ij: INTEGER;
	sum: REAL;
	d: sqrMatrx;
BEGIN
ij := 0;
FOR i := 1 TO n DO
	FOR j := i TO n DO
		ij := ij + 1;
		IF (i = j) THEN 
			d[i, j] := a[ij]
		ELSE
			d[i, j] := a[ij];
			d[j, i] := a[ij];
			END;
		END;
	END;
FOR i := 1 TO n DO
	FOR j := 1 TO p DO
		sum := 0.0;
		FOR k := 1 TO n DO 
			sum := sum + d[i, k] * b[k, j];
			END;
		c[i, j] := sum;
		END;
	END;
END product;

PROCEDURE Volume(SCALAR NoOfVertices: INTEGER; SCALAR Vertices: listPtrs): SCALAR REAL;
SCALAR
	i, k: INTEGER;
	det: REAL;
	evalues: vectr;
	Parallelotope: sqrMatrix;
	Vector: vectorPtr;
BEGIN
FOR k := 1 TO NoOfVertices DO
	Vector := Vertices^.Ptr^.values;
	FOR i := 1 TO Dimension DO
		Parallelotope[i, k] := Vector^.x;
		Vector := Vector^.next;
		END;
	Vertices := Vertices^.nextPtr;
	Parallelotope[NoOfVertices, k] := 1.0;
	END;
(*calculate volume of Simplex with these END points*)
SVD(Parallelotope, NoOfVertices, NoOfVertices, evalues, Parallelotope);
det := 1.0;
FOR i := 1 TO NoOfVertices DO
	det := det * evalues[i];
	IF i < NoOfVertices THEN 
		det := det / FLOAT(i);
		END;
	END;
RETURN(det);
END Volume;

PROCEDURE PrintVectorPtr(SCALAR startVector: vectorPtr);
BEGIN
IF startVector = NIL THEN 
	WriteString('nil vector')
ELSE
	WHILE startVector <> NIL  DO
		WriteReal(startVector^.x, 12);
		WriteString('  ');
		startVector := startVector^.next;
		END;
	WriteLn;
	END;
END PrintVectorPtr;

PROCEDURE PrintListVectors(SCALAR startList: listVectorPtr);

BEGIN
IF startList = NIL  THEN WriteString('nil list vector')
ELSE
	WHILE startList <> NIL  DO
		PrintVectorPtr(startList^.values);
		startList := startList^.nextVector;
		END;
	END;
END PrintListVectors;

PROCEDURE PrintPtrList(SCALAR startList: listPtrs);
BEGIN
IF startList = NIL  THEN WriteString('nil list vector in printListPtrs')
ELSE
	WHILE startList <> NIL  DO
		PrintVectorPtr(startList^.Ptr^.values);
		startList := startList^.nextPtr;
		END;
	END;
END PrintPtrList;

PROCEDURE PrintSet(SCALAR NoOfVertices: INTEGER; SCALAR s: faceSet);
SCALAR
	j:face;
	point: vertex;
	count: face0;

BEGIN
count := 0;
FOR j := 1 TO NoOfVertices DO 
	IF j IN s THEN 
		count := count + 1;
		END;
	END;
point := a;
IF count > 1 THEN
	FOR j := 1 TO NoOfVertices DO
		IF j IN s THEN 
			WriteInt(j, 3) 
		ELSE 
			WriteString('  ');
			Write(CHR(ORD('a') + ORD(point)));
			END;
		IF j < maxVertices THEN 
			INC(point);
			END;
		END;
	WriteLn;
	END;
END PrintSet;

PROCEDURE PrintSetPtrList(SCALAR NoOfVertices: INTEGER; SCALAR startList: setPtr);
BEGIN
IF startList = NIL  THEN 
	WriteString('nil list vector in PrintSetPtrList');
	WriteLn;
ELSE
	WHILE startList <> NIL  DO
		PrintSet(NoOfVertices, startList^.vertices);
		startList := startList^.nextFaceSet;
		END;
	END;
END PrintSetPtrList;

PROCEDURE PrintSimplex(SCALAR Simplex: simplex);
BEGIN
WriteString('Simplex'); WriteLn;
WriteString('Probability '); WriteReal(Simplex.probability, 10);
WriteString('Volume '); WriteReal(Simplex.volume, 10); WriteLn;
WriteString('Vertices'); WriteLn;
PrintPtrList(Simplex.vertices);
WriteString('Midpoint'); WriteLn;
PrintVectorPtr(Simplex.midpoint);
END PrintSimplex;

PROCEDURE PrintSimplexList(SCALAR Simplices: simplexPtr);
SCALAR
	totalVolume, totalProbability: REAL;
BEGIN
totalVolume := 0.0;
totalProbability := 0.0;
WHILE Simplices <> NIL  DO
	PrintSimplex(Simplices^.Ptr);
	totalVolume := totalVolume + Simplices^.Ptr.volume;
	totalProbability := totalProbability + Simplices^.Ptr.probability;
	Simplices := Simplices^.nextPtr;
	END;
WriteString('Total Probability of Simplex = '); WriteReal(totalProbability, 6); WriteLn;
WriteString('Total Volume of Simplex = '); WriteReal(totalVolume, 8); WriteLn;
END PrintSimplexList;


PROCEDURE LengthVectorList(SCALAR start:listVectorPtr): SCALAR INTEGER;
SCALAR
	count: INTEGER;
BEGIN
count := 0;
WHILE start <> NIL  DO
	count := count + 1;
	start := start^.nextVector;
	END;
RETURN(count);
END LengthVectorList;


PROCEDURE  LengthPtrList(SCALAR startList: listPtrs): SCALAR INTEGER;
SCALAR
	count: INTEGER;
BEGIN
count := 0;
WHILE startList <> NIL  DO
	count := count + 1;
	startList := startList^.nextPtr;
	END;
RETURN(count);
END LengthPtrList;

PROCEDURE  LengthSimplexPtrList(SCALAR startList: simplexPtr): SCALAR INTEGER;
SCALAR
	count: INTEGER;
BEGIN
count := 0;
WHILE startList <> NIL  DO
	count := count + 1;
	startList := startList^.nextPtr;
	END;
RETURN(count);
END LengthSimplexPtrList;

PROCEDURE copyPtr(SCALAR oldPtr: vectorPtr): SCALAR vectorPtr;
SCALAR
	newPtr, savePtr: vectorPtr;
BEGIN
IF oldPtr = NIL  THEN
	WriteString('vector pointer is NIL  in copyPtr');
	RETURN(NIL) ;
ELSE
	NEW(newPtr);
	savePtr := newPtr;
	WHILE oldPtr <> NIL  DO
		newPtr^.x := oldPtr^.x;
		oldPtr := oldPtr^.next;
		IF oldPtr = NIL  THEN newPtr^.next := NIL 
		ELSE
			NEW(newPtr^.next);
			newPtr:= newPtr^.next;
			END;
		END;
	RETURN(savePtr);
	END;
END copyPtr;

PROCEDURE copyVector(SCALAR oldPtr: listVectorPtr): SCALAR listVectorPtr;
SCALAR
	newVector, saveVector: listVectorPtr;
BEGIN
IF oldPtr = NIL  THEN
	WriteString(' vector ptr is NIL  in copyVectors');
	RETURN(NIL);
ELSE
	NEW(newVector);
	saveVector := newVector;
	newVector^.values := copyPtr(oldPtr^.values);
	newVector^.nextVector := NIL ;
	RETURN(saveVector);
	END;
END copyVector;

PROCEDURE copyPtrList(SCALAR list, test: listPtrs): SCALAR listPtrs;
(*
	copies all elements over TO output, except FOR the
	element 'test'
*)
SCALAR
	newList, saveList: listPtrs;
BEGIN
IF list = NIL  THEN RETURN(NIL) 
ELSE
	IF list <> test THEN
		NEW(newList);
		newList^.Ptr := list^.Ptr;
		newList^.nextPtr := copyPtrList(list^.nextPtr, test);
		RETURN(newList);
	ELSE 
		RETURN(copyPtrList(list^.nextPtr, test));
		END;
	END;
END copyPtrList;

PROCEDURE copySimplex(SCALAR old: simplex; SCALAR VAR new: simplex);
BEGIN
new.probability := old.probability;
new.midpoint := copyPtr(old.midpoint);
new.volume := old.volume;
new.vertices := copyPtrList(old.vertices, NIL );
END copySimplex;

PROCEDURE AddToEnd(SCALAR VAR old: listPtrs; SCALAR new: listPtrs);
BEGIN
IF old = NIL  THEN 
	old := new
ELSE 
	AddToEnd(old^.nextPtr, new);
	END;
END AddToEnd;

PROCEDURE AddSimplexToEnd(SCALAR VAR old: simplexPtr; SCALAR news: simplex);
BEGIN
IF old = NIL  THEN
	NEW(old);
WriteString('new done');
PrintSimplex(news);
	old^.Ptr := news;
WriteLn; WriteString(' 1 done');
	old^.nextPtr := NIL ;
WriteLn; WriteString('niled');
ELSE 
	AddSimplexToEnd(old^.nextPtr, news);
	END;
END AddSimplexToEnd;

PROCEDURE CreateVector(): SCALAR vectorPtr;

SCALAR
	i: INTEGER;
	save, normal: vectorPtr;
BEGIN
NEW(normal);
save := normal;
FOR i := 1 TO Dimension DO
	normal^.x := 0.0;
	IF i < Dimension THEN
		NEW(normal^.next);
		normal := normal^.next;
	ELSE 
		normal^.next := NIL ;
		END;
	END;	
RETURN(save);
END CreateVector;

PROCEDURE NormalVector(SCALAR normal: vectorPtr; SCALAR position: INTEGER);
(*
	puts a 1 in location position of the vector,
	a zero everywhere ELSE
*)
SCALAR
	i: INTEGER;
BEGIN
i := 0;
WHILE normal <> NIL  DO
	i := i + 1;
	IF i = position THEN 
		normal^.x := 1.0
	ELSE 
		normal^.x := 0.0;
		END;
	normal := normal^.next;
	END;
END NormalVector;

PROCEDURE CentrePtr(SCALAR newEdge: listPtrs): SCALAR vectorPtr;
(*
	returns the mean vector from the list of vectors
*)
SCALAR
	n: INTEGER;
	start, marker, result: vectorPtr;
BEGIN
result := CreateVector();
start := result;
n := 0;
(*	sum over each vector		*)
WHILE newEdge <> NIL  DO
	marker := newEdge^.Ptr^.values;
	n := n + 1;
(*	sum over each coord		*)
	WHILE marker <> NIL  DO
		result^.x := result^.x + marker^.x;
		result := result^.next;
		marker := marker^.next;
		END;
	newEdge := newEdge^.nextPtr;
	result := start;
	END;
(*now mean it*)
WHILE result <> NIL  DO
	result^.x := result^.x / FLOAT(n);
	result := result^.next;
	END;
RETURN(start);
END CentrePtr;

PROCEDURE  Subset(SCALAR n: face): SCALAR setPtr;
(*
	This is an algorithm FOR dividing up an nD simplex into
	subsimplices, that is based on using the midpoint of the face
	opposite an existing vertex

	The basic rule is that each sub-simplex must have at least
	two midpoints in it and the midpoints that are not
	there must be replaced by their opposite vertices

	The vertices and midpoints of opposite faces are put into
	a 1-1 correspondence by the ordering a...j and 1..10
	respectively; in the case that max vertices = 10.
*)
SCALAR
	b: faceSet;
	endResult : setPtr;


PROCEDURE Choose(SCALAR lower:face; SCALAR s: faceSet);
SCALAR
	i: face;

PROCEDURE Process(SCALAR s: faceSet);
SCALAR
	j:face;
	count: face0;
	result: setPtr;

BEGIN
count := 0;
FOR j := 1 TO n DO 
	IF j IN s THEN 
		count := count + 1;
		END;
	END;
IF count > 1 THEN (*add TO list of sets*)
	NEW(result);
	result^.vertices := s;
	result^.nextFaceSet := endResult;
	endResult := result;
	END;
END Process;

BEGIN
FOR i := lower TO n DO
	INCL(s, i);
	Process(s);
	IF lower <> n THEN 
		Choose(i + 1, s);
		END;
	EXCL(s, i);
	END; (*loop on i*)
END Choose;

BEGIN
endResult := NIL ;
IF n < maxVertices THEN 
	b := faceSet{};
	Choose(1, b)
ELSE 
	WriteString('too many vertices FOR algorithm, change and recompile');
	END;
RETURN(endResult);
END Subset;

PROCEDURE CentreSimplex(SCALAR Simplex: simplex): SCALAR vectorPtr;
(*
	returns the midpoint of the simplex
*)
BEGIN
RETURN(CentrePtr(Simplex.vertices));
END CentreSimplex;

		
PROCEDURE SetUpSimplex(SCALAR NoEndMembers: INTEGER): SCALAR simplex;
(*
	given the number of endmembers this PROCEDURE returns a
	standard simplex FOR this dimension, notice that the last coord
	will be the origin because 'i' is greater than the length of the
	vector at this point! too clever!!
*)
SCALAR
	result: listPtrs;
	Simplex: simplex;
BEGIN
Simplex.probability := 1.0;
NEW(result);
Simplex. vertices := result;
FOR ii := 1 TO NoEndMembers DO
	NEW(result^.Ptr);
	result^.Ptr^.values := CreateVector();
	NormalVector(result^.Ptr^.values, ii);
	IF ii = NoEndMembers THEN 
		result^.nextPtr := NIL 
	ELSE
		NEW(result^.nextPtr);
		result := result^.nextPtr;
		END;
	END;
NEW(Simplex.midpoint);
Simplex.midpoint := CentreSimplex(Simplex);
Simplex.volume := Volume(NoEndMembers, Simplex.vertices);
RETURN(Simplex);
END SetUpSimplex;

PROCEDURE FindCommonVertices(SCALAR First, Second, Vertices: listPtrs): SCALAR listPtrs;
(*
	given a list of vertices in 'Vertices' this should
	return a list of vertices excluding First and Second
*)
SCALAR
	first: BOOLEAN;
	Find, result: listPtrs;
BEGIN
Find := NIL ;
first := TRUE;
WHILE Vertices <> NIL  DO
	IF (First <> Vertices) AND (Second <> Vertices) THEN
		IF first THEN
			NEW(result);
			first := FALSE;
			Find := result;
		ELSE
			NEW(result^.nextPtr);
			result := result^.nextPtr;
			END;
		result^.Ptr := copyVector(Vertices^.Ptr);
		result^.nextPtr := NIL ;
		END;
	Vertices := Vertices^.nextPtr;
	END;
RETURN(Find);
END FindCommonVertices;


PROCEDURE SubDivideSimplex(SCALAR NoOfVertices, stopDepth: INTEGER; SCALAR Simplex: simplex; SCALAR VAR Simplices: simplexPtr; SCALAR SetNodes: setPtr) ;
(*
	This PROCEDURE recursively subdivides a n-dimensional simplex
	into smaller n-dimensional simplices until a depth of 0 is reached
*)
SCALAR
	i: face;
	Original, MidPoints, MidPointsList, newEdge, newVertices: listPtrs;
	SubSimplex: simplex;
	Nodes: setPtr;
	faces: faceSet;
BEGIN
IF stopDepth = 0 THEN 
	AddSimplexToEnd(Simplices, Simplex)
ELSE
	Original := Simplex.vertices;
	NEW(MidPointsList);
	newVertices := MidPointsList;

(*	find list of midpoints of each face of the simplex, 
	this new list FORms the centre simplex of the subdivided simplex


	This list of midpoints must be set up so that the vertices of the old
	incoming list are in a 1-1 correspondence with the new list. This 
	that a vertex and its opposite face are aligned in the lists
*)

	WHILE Original <> NIL  DO(*drop out a vertex at a time, and work on opp face*)
		newEdge := copyPtrList(Simplex.vertices, Original);
		NEW(MidPointsList^.Ptr);
		MidPointsList^.Ptr^.values := CentrePtr(newEdge);
		IF Original^.nextPtr <> NIL  THEN
			NEW(MidPointsList^.nextPtr);
			MidPointsList := MidPointsList^.nextPtr;
		ELSE 
			MidPointsList ^.nextPtr := NIL ;
			END;
		Original := Original^.nextPtr;
		END;
	MidPointsList := newVertices;

	(*now work through the list of nodes that define the new simplex,
	in parallel with the midpoints and old simplex*)

	Nodes := SetNodes;
	WHILE Nodes <> NIL  DO
		Original 	:= Simplex.vertices;
		MidPoints 	:= MidPointsList;
		faces 		:= Nodes^.vertices;
		NEW(SubSimplex.vertices);
		newVertices 	:= SubSimplex.vertices;
		FOR i := 1 TO NoOfVertices DO
			NEW(newVertices^.Ptr);
			IF i IN faces THEN (*add midpoints in*)
				newVertices^.Ptr^.values := copyPtr(MidPoints^.Ptr^.values)
			ELSE (*add old vertices*)
				newVertices^.Ptr^.values := copyPtr(Original^.Ptr^.values);
				END;
			IF i < NoOfVertices THEN
				NEW(newVertices^.nextPtr);
				newVertices 	:= newVertices^.nextPtr;
				Original 	:= Original^.nextPtr;
				MidPoints 	:= MidPoints^.nextPtr;
			ELSE 
				newVertices^.nextPtr := NIL ;
				END;
			END;
		SubSimplex.midpoint 	:= CentrePtr(SubSimplex.vertices);
		SubSimplex.volume 	:= Volume(NoOfVertices, SubSimplex.vertices);
		SubSimplex.probability 	:= Simplex.probability * SubSimplex.volume / Simplex.volume;
		SubDivideSimplex(NoOfVertices, stopDepth - 1, SubSimplex, Simplices, SetNodes);
		Nodes := Nodes^.nextFaceSet;
		END;
	END;
END SubDivideSimplex;
		

PROCEDURE ReadInitialEstimates(SCALAR NoOfEndMembers, dimension: INTEGER; SCALAR VAR coefs: sqrMatrx);
(*
	reads in the initial estimates of the endmembers, these
	are stored in a matrix where each hyperplane is a row.
	Across the rows the coefficients of p bands are stored,
	the nth position is taken by the CONSTant and by default
	the coefficient of the last band is taken as one
*)
SCALAR
	i, j, ij: INTEGER;
BEGIN
ij := 0;
FOR i := 1 TO NoOfEndMembers DO
	FOR j := 1 TO dimension DO
		ij := ij + 1;
		ReadReal(coefs[i, j]);
		END;
(*	readln *)
	END;
END ReadInitialEstimates;

PROCEDURE readVector(SCALAR VAR vctr: vectorPtr; SCALAR dimension: INTEGER);
SCALAR
	vec: vectorPtr;
	i: INTEGER;
BEGIN
ReadReal(vctr^.x);
NEW(vctr^.next);
vec := vctr^.next;
FOR i := 2 TO dimension DO
	ReadReal(vec^.x);
	IF i < dimension THEN
		NEW(vec^.next);
		vec := vec^.next;
	ELSE 
		vec^.next := NIL ;
		END;
	END;
END readVector;

PROCEDURE FindEndMembers(SCALAR NoOfEndMembers, Dimension: INTEGER; SCALAR VAR EndMembers: sqrMatrx; SCALAR SetOfPropns: simplexPtr; SCALAR VAR ssp: symmat);
(*
	given the n+1 points that define the  endpoints
	of a region in n-space, THEN this PROCEDURE integrates over
	the (0-1) Simplpx of compositions (i.e because the REAL ones
	are unknown. 

	We can find a set of residuals since every point is take
	to be a convex (i.e. the proportions) linear model
	of the endpoints
	i.e. a vector p x 1 of residuals; and using the given
	dispersion matrix find the likelihood of these  residuals.

	The residuals are defined as in the technical report
	on endmembers (M.J. Palmer 1990)
*)
(*
CONST
	Update being true means that the estimate of the non-parametric 
	distribution  of the proportions is updated each iteration
	Update = FALSE;
	Update = TRUE;
*)

CONFIGURATION LINE [1..MaxObs];
CONNECTION (* none *);

SCALAR
	Update: BOOLEAN;
	iteration, i, j, ij: INTEGER;
	Constant, OldLikelihood, LogLikelihood: REAL;
	Dispersion: symmat;

VECTOR
	Obs: vectorPtr;

PROCEDURE Log_Likelihood():SCALAR  REAL;
SCALAR

	pixel, Nodes, Count, i, j, ij, k: INTEGER;
	prop, LogAnswer, LogSum: REAL;
	Prob, RRho: vectr;
	rho: vectorPtr;
	Cells: simplex;
	StartPoints, MidPoints: simplexPtr;
	B: sqrMatrx;
	R: symmat;
VECTOR
	LnSum, Sum, small, predicted, eij: REAL;
	band, res: vectr;
	PI: vectr;
	obs: vectorPtr;
	bij: sqrMatrix;
	rij, covariance: symmat;
BEGIN
(*zeroize everything*)
R.size := NoOfEndMembers;
Dispersion.size := Dimension;
Nodes := LengthSimplexPtrList(SetOfPropns);
LogLikelihood := 0.0;
ij := 0;
WriteInt(NoOfEndMembers, 6);
FOR i := 1 TO NoOfEndMembers DO
	FOR j := i TO NoOfEndMembers DO
		ij := ij + 1;
WriteInt(ij, 6); WriteLn;
		R.data1[ij] := 0.0;
		END;
	END;
ij := 0;
FOR i := 1 TO Dimension DO
	FOR j := i TO Dimension DO
		ij := ij + 1;
		Dispersion.data1[ij] := 0.0;
		END;
	END;
FOR i := 1 TO NoOfEndMembers DO
	FOR j := 1 TO Dimension DO
		B[i, j] := 0.0;
		END;
	END;
(*
	now looping over all observations find the predicted position
	FOR each band measurement on the hyperplanes
	and store all these in a matrix 
*)
LogSum := 0.0;
FOR i := 1 TO Nodes DO 
	Prob[i] := 0.0;
	END;
PARALLEL LINE [1..noVectors]
	Count := 0;
	rij.size := NoOfEndMembers;
(*
		now initialise that which is integrated over FOR each
		individual
*)
	MidPoints := SetOfPropns;
	Sum := 0.0;
	ij := 0;
	FOR i := 1 TO NoOfEndMembers DO
		FOR j := i TO NoOfEndMembers DO
			ij := ij + 1;
			rij.data1[ij] := 0.0;
			END;
		END;
	ij := 0;
	FOR i := 1 TO Dimension DO
		FOR j := i TO Dimension DO
			ij := ij + 1;
			covariance.data1[ij] := 0.0;
			END;
		END;
	FOR i := 1 TO NoOfEndMembers DO
		FOR j := 1 TO Dimension DO
			bij[i, j] := 0.0;
			END;
		END;	
	FOR i := 1 TO Nodes DO 
		PI[i] := 0.0;
		END;

(* 	now BEGIN the integration*)

	WHILE MidPoints <> NIL  DO
		Count := Count + 1;
		Cells := MidPoints^.Ptr;
		obs := Obs;
		FOR i := 1 TO Dimension  DO
			predicted := 0.0;
			band[i] := obs^.x;
			prop := 0.0;
			rho := Cells.midpoint;
(*
		predict the bands FOR the integration node at which we now are
*)
			FOR k := 1 TO NoOfEndMembers DO
				IF k = NoOfEndMembers THEN
					prop := 1.0 - prop;
					predicted := predicted + prop * EndMembers[k, i];
					RRho[k] := prop;
				ELSE
					IF i = 1 THEN 
						RRho[k] := rho^.x;
						END;
					predicted := predicted + rho^.x * EndMembers[k, i];
					prop := prop + rho^.x;
					rho := rho^.next
					END;
				END;
(*		now find the residuals*)
			res[i] := obs^.x - predicted;

			obs := obs^.next;
			END;
(*	mahalanobis' distance *)

		small := -0.5 * rsymrt(res, ssp, 2);
		IF small < SmallNo THEN 
			eij := 0.0
		ELSE 
			eij := Cells.volume * Cells.probability * Exp(small);
			END;

(*		weighted by probability sum *)

		FOR i := 1 TO NoOfEndMembers DO
			FOR j := 1 TO Dimension DO
				bij[i, j] := bij[i, j] + eij * RRho[i] * band[j];
				END;
			END;
		ij := 0;
		FOR i := 1 TO NoOfEndMembers DO
			FOR j := i TO NoOfEndMembers DO
				ij := ij + 1;
				rij.data1[ij] := rij.data1[ij] + eij * RRho[i] * RRho[j];
				END;
			END;
		ij := 0;
		FOR i := 1 TO Dimension DO
			FOR j := i TO Dimension DO
				ij := ij + 1;
				covariance.data1[ij] := covariance.data1[ij] + eij * res[i] * res[j];
				END;
			END;
		Sum := Sum + eij;
		PI[Count] := PI[Count] + eij;
		MidPoints:= MidPoints^.nextPtr;
		END;
	IF Sum > 0.0 THEN (*This is a bit of a kludge*)
		LnSum := Ln(Sum);
		LogSum := REDUCE.SUM(LnSum);
		FOR i := 1 TO Nodes DO 
			Prob[i] := REDUCE.SUM(PI[i] / Sum);
			END;
		ij := 0;
		FOR i := 1 TO NoOfEndMembers DO
			FOR j := i TO NoOfEndMembers DO
				ij := ij + 1;
				R.data1[ij] := REDUCE.SUM(rij.data1[ij] / Sum);
				END;
			END;	
		ij := 0;
		FOR i := 1 TO Dimension DO
			FOR j := i TO Dimension DO
				ij := ij + 1;
				Dispersion.data1[ij] := REDUCE.SUM(covariance.data1[ij] / Sum);
				END;
			END;
		FOR i := 1 TO NoOfEndMembers DO
			FOR j := 1 TO Dimension DO
				B[i, j] := REDUCE.SUM(bij[i, j] / Sum);
				END;
			END;
	ELSE 
		WriteString('fudge time FOR pixel ');
		WriteInt(id_no, 6);
		END;
	ENDPARALLEL;

invert(R, TRUE);

(*solve equation*)
product(R.data2, B, EndMembers, NoOfEndMembers, Dimension);

(*Expectation step:- update non-parametric distribution*)
FOR i := 1 TO Nodes DO 
	Prob[i] := Prob[i] / FLOAT(noVectors);
	END;
Update := TRUE;
IF Update THEN
	StartPoints := SetOfPropns;
	i := 1;
	WHILE StartPoints <> NIL  DO
		StartPoints^.Ptr.probability := Prob[i];
		StartPoints := StartPoints^.nextPtr;
		i := i + 1;
		END;
	END;
ij := 0;
FOR i := 1 TO Dimension DO
	FOR j := i TO Dimension DO
		ij := ij + 1;
		Dispersion.data1[ij] := Dispersion.data1[ij]  / FLOAT(noVectors);
		END;
	END;
LogAnswer := LogSum -  Constant - 0.5 * FLOAT(noVectors) * Ln(ssp.det);
ssp := Dispersion;
invert(ssp, TRUE);
RETURN(LogAnswer);
END Log_Likelihood;

BEGIN

(*set up dispersion matrix*)

ssp.size := Dimension;
ij := 0;
FOR i := 1 TO Dimension DO
	FOR j := i TO Dimension DO
		ij := ij + 1;
		(*IF i = j THEN ssp.data1[ij] := 2.5
		IF i = j THEN ssp.data1[ij] := 6.5*)
		IF i = j THEN 
			ssp.data1[ij] := 2.0
		ELSE 
			ssp.data1[ij] := 0.0;
			END;	
		END;
	END;
invert(ssp, TRUE);
Constant := 0.5 * FLOAT(noVectors * Dimension) * Log2PI;
LOAD LINE[1..noVectors]  (Obs, SetOfPoints);
LogLikelihood := Log_Likelihood();
iteration := 1;
OpenOutput('likelihood');
REPEAT
	WriteString('Iteration ');
	WriteInt(iteration, 5);
	WriteString('Log Likelihood : ');
	WriteReal(LogLikelihood, 10);
	WriteLn;
	OldLikelihood := LogLikelihood;
	LogLikelihood := Log_Likelihood();
	WriteInt(iteration, 5);
	WriteString('LogLikelihood'); WriteLn;
	FOR i := 1 TO NoOfEndMembers DO
		FOR j := 1 TO Dimension DO 
			WriteReal(EndMembers[i, j], 5);
			END;
		WriteLn;
		END;
	ij := 0;
	WriteString( ' Dispersion matrix ');
	FOR i := 1 TO Dimension DO
		FOR j := i TO Dimension DO
			ij := ij + 1;
			WriteReal(Dispersion.data1[ij], 8);
			END;
		WriteLn;
		END;
	iteration := iteration + 1;
UNTIL (ABS(LogLikelihood - OldLikelihood) < 0.1) (*or (iteration = 5)*);
FOR i := 1 TO NoOfEndMembers DO
	FOR j := 1 TO Dimension DO 
		WriteReal(EndMembers[i, j], 8);
		END;
	WriteLn;
	END;
ij := 0;
FOR i := 1 TO Dimension DO
	FOR j := i TO Dimension DO
		ij := ij + 1;
		WriteReal(Dispersion.data1[ij], 8);
		WriteString(' ');
		END;
	WriteLn;
	END;
END FindEndMembers;

PROCEDURE checkSign(SCALAR a: short): SCALAR INTEGER;
SCALAR
	check: INTEGER;
BEGIN
check := a;
IF a < 0 THEN 
	check := a + 256;
	END;
RETURN(check);
END checkSign;

PROCEDURE checkMagnitude(SCALAR a: medium): SCALAR short;
SCALAR
	check: short;
BEGIN
IF a > 127 THEN 
	check := a - 256
ELSE 
	check := a;
	END;
RETURN(check);
END checkMagnitude;

PROCEDURE ReadHeader(SCALAR VAR Bands, Width, Length: INTEGER);
(* reads in an Aimage file header and translates TO correct numbers*)
SCALAR
	a, b: short;
	ch: CHAR;
	i, NoBytes: INTEGER;

PROCEDURE translate(SCALAR a, b: short): SCALAR INTEGER;
SCALAR
	a1, b1: medium;
	check: INTEGER;
BEGIN
a1 := checkSign(a);
b1 := checkSign(b);
check := 256 * ORD(a1) + ORD(b1);
RETURN(check);
END translate;

BEGIN
Read(ch);
Read(ch);
Bands := ORD(ch);

Read(ch);
Read(ch);
NoBytes := ORD(ch);

Read(ch); a := ORD(ch);
Read(ch); b := ORD(ch);
Length := translate(a, b);
Read(ch); a := ORD(ch);
Read(ch); b := ORD(ch);
Width := translate(a, b);

Read(ch); a := ORD(ch);
Read(ch); b := ORD(ch);
Length :=  translate(a, b) - Length + 1;

Read(ch); a := ORD(ch);
Read(ch); b := ORD(ch);
Width := translate(a, b) - Width + 1;

WriteString('This image has ');
WriteInt(Bands, 4);
WriteString(' bands and is ');
WriteInt(Width, 5);
WriteString(' pixels wide and has ');
WriteInt(Length, 5);
WriteString(' lines');
WriteLn;
FOR i := 1 TO 40 DO
	Read(ch);
	Write(ch);
	END;
WriteLn;
END ReadHeader;

PROCEDURE decode(SCALAR VAR a,b: CHAR; SCALAR n: INTEGER);
SCALAR
	a1, b1: medium;
BEGIN
a1 := n DIV 256;
b1 := n MOD 256;
a := CHR(checkMagnitude(a1));
b := CHR(checkMagnitude(b1));
END decode;
  
PROCEDURE writeHeader(SCALAR NoBands, Width, Length: INTEGER);
SCALAR
	a, b: CHAR;
	i: INTEGER;
BEGIN
decode(a, b, NoBands);
Write(a);
Write(b);

a := (CHR(0));
b :=(CHR(1));
Write(a);
Write(b);

Write(a);
Write(b);
Write(a);
Write(b);

decode(a, b, Length);
Write(a);
Write(b);

decode(a, b, Width);
Write(a);
Write(b);

a := (CHR(0));
FOR i := 1 TO 40 DO 
	Write(a);
	END;
END writeHeader;

BEGIN
OpenInput("austral.in");
debug := TRUE;
debug := FALSE;
Log2PI := Ln(2.0 * pi);
WriteString(' dimension of vectors? '); 
	ReadInt(Dimension); 
	WriteInt(Dimension,6);
	WriteLn;
WriteString(' No of endmembers? '); 
	ReadInt(NoOfEndmembers); 
	WriteInt(NoOfEndmembers,6);
	WriteLn;
WriteString(' Level of subdivision of simplex required:- '); 
	ReadInt(LevelSubdivision);
	WriteLn;
WriteInt(LevelSubdivision, 4); WriteLn;
Simplex := SetUpSimplex(NoOfEndmembers);
WriteString('Initial Simplex'); WriteLn;
PrintSimplex(Simplex);
PartitionedSimplex := NIL ;
GenericPartition := Subset(NoOfEndmembers);
WriteString('Generic set of subdivisions'); WriteLn;
PrintSetPtrList(NoOfEndmembers, GenericPartition);
SubDivideSimplex(NoOfEndmembers, LevelSubdivision, Simplex, PartitionedSimplex, GenericPartition);
WriteString('Partitioned simplex');
	PrintSimplexList(PartitionedSimplex);
ReadInitialEstimates(NoOfEndmembers, Dimension, EndMembers);
noParams := Dimension * NoOfEndmembers;
WriteString('Number of Parameters to be minimized '); WriteLn;
WriteString('	End Members');
WriteInt( noParams,5); WriteLn;
WriteString('	Dispersion Matrix');
WriteInt( Dimension * (Dimension + 1) DIV 2,5); WriteLn;
WriteString('	Parameters of NonParametric Distribution ');
WriteInt( LengthSimplexPtrList(PartitionedSimplex), 5); WriteLn;
NEW(SetOfPoints[1]);
readVector(SetOfPoints[1], Dimension);
noVectors := 1;
WHILE Done DO
	noVectors := noVectors + 1;
	NEW(SetOfPoints[noVectors]);
	readVector(SetOfPoints[noVectors], Dimension);
	END;
WriteInt(noVectors,5);
WriteString(' vectors read in'); WriteLn;
FindEndMembers(NoOfEndmembers, Dimension, EndMembers, PartitionedSimplex, ssp);
(*
PredictPropnsTrainSet(NoOfEndmembers, ssp, PartitionedSimplex);
PredictPropnsData(NoOfEndmembers, ssp, PartitionedSimplex);
*)
END StochasticHull.
