(* *********************************************************************

   Ein Programm, das in einem Feld aus erlaubten und verbotenen Feldern
   die Groesse des maximalen Quadrats aus erlaubten Feldern bestimmt.
   
   ********************************************************************* *)

SYSTEM maxfeld;

(* Dimensionen des Feldes : Nx, Ny *)
CONST Nx = 4;
      Ny = 4;

(*
   Das PE-Feld bildet das Feld ab, Verbindungen existieren
   nach links und unten
*)
CONFIGURATION feld[1..Ny],[1..Nx];
CONNECTION links : feld[i, j] -> feld[i  , j-1].rechts;
           unten : feld[i, j] -> feld[i+1, j  ].oben;

(*
   Zwischenergebnis : 
   max_quad ist auf jedem PE die Groesse des maximalen Quadrats
   mit diesem PE als linker unterer Ecke
   Ergebnis :
   max_groesse ist die Groesse des maximalen Quadrats
*)
VECTOR max_quad     : INTEGER;
SCALAR max_groesse  : INTEGER;

(* *********************************************************************

   erlaubt liefert den Wert TRUE fuer die PEs auf erlaubten Feldern
   
   ********************************************************************* *)

PROCEDURE erlaubt() : VECTOR BOOLEAN;

BEGIN
(*  RETURN VIRandom() MOD 10 # 0;*)
  return (id_no # 6) and (id_no # 15)
END erlaubt;

(* *********************************************************************

   suche_block_frei liefert auf jedem PE die Groesse des maximalen
   Quadrats in Richtung rechts oben
   feld_frei ist anfangs TRUE fuer erlaubte Felder

   ********************************************************************* *)

PROCEDURE suche_block_frei(VECTOR feld_frei : BOOLEAN) : VECTOR INTEGER;

VECTOR hoehe,
       max_block,
       max_block_oben : INTEGER;
       empfange       : BOOLEAN;

  (* *******************************************************************

     suche_rechts_frei liefert auf jedem PE die Zahl der erlaubten
     Felder rechts vom eigenen, das eigene inklusive.
     Auf verbotenen Feldern ist das Ergebnis 0.
     schiebe ist anfangs TRUE auf erlaubten Feldern

     ******************************************************************* *)

  PROCEDURE suche_rechts_frei(VECTOR schiebe : BOOLEAN) : VECTOR INTEGER;

  VECTOR empfange    : BOOLEAN;
         rechts_frei : INTEGER;

  BEGIN
    rechts_frei := 0;
    WHILE schiebe DO
      INC(rechts_frei);
      empfange := FALSE;
      RECEIVE feld.rechts(empfange) FROM feld.links(schiebe);
      schiebe := empfange;
    END; (* WHILE *)
    RETURN rechts_frei;
  END suche_rechts_frei;

BEGIN    (* suche_block_frei *)
  max_block := suche_rechts_frei(feld_frei);
  hoehe := 0;
  WHILE feld_frei DO
    INC(hoehe);
    empfange := FALSE;
    max_block_oben := 0;
    RECEIVE feld.oben(empfange)       FROM feld.unten(feld_frei);
    RECEIVE feld.oben(max_block_oben) FROM feld.unten(max_block);
    IF max_block_oben < max_block THEN
      IF max_block_oben < hoehe THEN
        feld_frei := FALSE
      ELSE
        max_block := max_block_oben;
        feld_frei := empfange;
      END;  (* IF *)
    ELSE
      feld_frei := empfange;
    END;  (* IF *)
  END;  (* WHILE *)

  IF hoehe < max_block THEN
    max_block := hoehe
  END;  (* IF *)
  RETURN max_block;
END suche_block_frei;

(* *********************************************************************

   ausgabe stellt die Lage aller gefundenen Quadrate maximaler
   Seitenlaenge dar

   ********************************************************************* *)

PROCEDURE ausgabe;

SCALAR loesung,
       zeile,
       anzahl     : INTEGER;
       dimx_feld,
       dimy_feld  : ARRAY [1 .. Ny * Nx] OF INTEGER;
       carray     : ARRAY [1..Ny],[1..Nx] OF CHAR;

VECTOR c          : CHAR;
       transfer   : INTEGER;

BEGIN
  anzahl := Nx * Ny;
  IF max_quad = max_groesse THEN
    transfer := DIM1;
    STORE(transfer, dimy_feld);
    transfer := DIM2;
    STORE(transfer, dimx_feld, anzahl);
  END;  (* IF *)
    
  FOR loesung := 1 TO anzahl DO
    IF max_quad = 0
      THEN c := '#'
    ELSIF (DIM1 <= dimy_feld[loesung]               ) &
          (  DIM1 > dimy_feld[loesung] - max_groesse) &
          (DIM2 >= dimx_feld[loesung]               ) &
          (  DIM2 < dimx_feld[loesung] + max_groesse)
      THEN c := 'o'
    ELSE
      c := '-'
    END;  (* IF *)
    STORE (c, carray);

    FOR zeile := 1 TO Ny DO
      WriteString(carray[zeile]); WriteLn;
    END;  (* FOR *)
    WriteLn;
  END;  (* FOR *)
END ausgabe;

BEGIN
  PARALLEL
    max_quad := suche_block_frei(erlaubt());
    max_groesse := REDUCE.MAX(max_quad);
    ausgabe;
  ENDPARALLEL
END maxfeld.
