SYSTEM routing;


(* Suche Wege im Labyrinth *)

CONST dim_x = 30;
      dim_y = 30;

TYPE FELD = ARRAY [dim_y],[dim_x] OF CHAR;

CONFIGURATION laby[dim_x],[dim_y];
CONNECTION links : laby[i,j] -> laby[i,j-1].rechts;
           rechts : laby[i,j] -> laby[i,j+1].links;
           oben : laby[i,j] -> laby[i-1,j].unten;
           unten : laby[i,j] -> laby[i+1,j].oben;

SCALAR ein_aus : FELD;
          (* Ein- und Ausgabe des Labyrinths *)
       i,j,k,l : INTEGER;
       c : CHAR;
       dimx, dimy : INTEGER;
       count,pfad : INTEGER;

VECTOR buch : CHAR; (* Buchstabe jedes Feldes *)

(*$400*)
PROCEDURE ariadne(SCALAR c : CHAR);

TYPE MARKEN = (NULL, EINS, ZWEI, DREI, VIER, FUENF, SECHS, START, STOP, RAND, WEG);
     (* NULL Feld ist unberuehrt *)
     (* EINS .. DREI (VIER .. SECHS) bilden den Faden *)
     (* START, STOP geben Anfangs- und Endpunkt an *)
     (* RAND signalisiert eine Wand *)

SCALAR fertig, fertig2, found : BOOLEAN;
          (* kein neuerPunkt gefunden oder
             Endpunkt entdeckt *)
       nexte_marke, marke : MARKEN;
          (* Fadenmarken *)

VECTOR m, shift, shift2,
       receive1, receive2,
       receive3, receive4 : MARKEN;
          (* Fadenmarke jedes Punktes,
             Hilfsmarken fuer PROPAGATE *)
       flag, zu_start : BOOLEAN;
          (* von diesen Punkten aus weitersuchen *)
(*$48*)

  PROCEDURE next (SCALAR m : MARKEN) : SCALAR MARKEN;
  (* naechste Marke ermitteln (vorwaerts) *)

  BEGIN
    CASE m OF
      EINS : RETURN ZWEI; |
      ZWEI : RETURN DREI; |
      DREI : RETURN EINS;
    END;
  END next;
  
  PROCEDURE prev (SCALAR m : MARKEN) : SCALAR MARKEN;
  (* naechste Marke ermitteln (rueckwaerts) *)
  
  BEGIN
    CASE m OF
      EINS : RETURN DREI; |
      ZWEI : RETURN EINS; |
      DREI : RETURN ZWEI;
    END;
  END prev;

BEGIN
  LOAD (buch,ein_aus);
  found := FALSE;
  PARALLEL
    (* Suche Anfangs- und Endpunkt *)
    flag := FALSE;
    CASE buch OF
      '+' : m := RAND; |
      ' ' : m := NULL;
      ELSE
        IF buch = c
        THEN
          IF id_no = REDUCE.FIRST(id_no)
          THEN
            m := START;
          ELSE
            m := STOP;
          END;
          flag := TRUE;
        ELSE
          m := RAND;
        END;
    END;
    marke := EINS;
    IF 2 # REDUCE.SUM(ORD(flag)) THEN RETURN END;
    (* genau ein Start und ein Endpunkt *)
    REPEAT
      INC(count); (* zaehle Schleifendurchlaeufe *)
      nexte_marke := next(marke);
      fertig := FALSE;
      receive1 := NULL;
      receive2 := NULL;
      receive3 := NULL;
      receive4 := NULL;
      shift := NULL;
      IF flag  (* bestimme zu verschickende Marke *)
      THEN
        IF (m = START) OR (EINS <= m <= DREI)
        THEN
          shift := nexte_marke;
        ELSE
          shift := VAL(MARKEN,ORD(nexte_marke) + 3);
        END;
      END;                                              
      flag := FALSE;
      (* verschicke Marken und markiere Felder, die
         zwei verschiedene Werte erhalten haben, bzw. ob
         Anfangs- und Endpunkt markiert werden sollen *)
      PROPAGATE.links (shift,receive1);
      PROPAGATE.rechts (shift,receive2);
      IF receive1 = NULL
      THEN
        receive1 := receive2;
        IF (receive1 # NULL) AND
           (((m = STOP) AND (receive1 <= VIER)) OR
            ((m = START) AND (receive1 >= VIER)))
        THEN
          flag := TRUE
        END
      ELSIF (receive1 <> receive2) AND (receive2 <> NULL) AND
            ((m = NULL) OR (START = m) OR (STOP = m))
      THEN
        flag := TRUE
      END;        
      PROPAGATE.oben (shift,receive2);
      IF receive1 = NULL
      THEN
        receive1 := receive2;
        IF (receive1 <> NULL) AND
           (((m = STOP) AND (receive1 <= VIER)) OR
            ((m = START) AND (receive1 >= VIER)))
        THEN
          flag := TRUE
        END
      ELSIF (receive1 <> receive2) AND (receive2 <> NULL) AND
            ((m = NULL) OR (START = m) OR (STOP = m))
      THEN
        flag := TRUE
      END;        
      PROPAGATE.unten (shift,receive2);
      IF receive1 = NULL
      THEN
        receive1 := receive2;
        IF (receive1 <> NULL) AND
           (((m = STOP) AND (receive1 <= VIER)) OR
            ((m = START) AND (receive1 >= VIER)))
        THEN
          flag := TRUE
        END
      ELSIF (receive1 <> receive2) AND (receive2 <> NULL) AND
            ((m = NULL) OR (START = m) OR (STOP = m)) 
      THEN
        flag := TRUE
      END;        
      IF NOT REDUCE.MAX(flag) (* Kein Feld markiert *)
      THEN
        IF ((EINS <= receive1 <= DREI) AND (VIER <= m <= SECHS)) OR
              ((VIER <= receive1 <= SECHS) AND (EINS <= m <= DREI))
        THEN (* Wellen haben uebereinandergegriffen *)
          fertig := TRUE;
          found := TRUE;
          flag := id_no = REDUCE.FIRST(id_no);
          dimx := REDUCE.FIRST(dim1);
          dimy := REDUCE.FIRST(dim2);
          IF ((dim1 = dimx) AND (ABS(dim2 - dimy) = 1)) OR
             ((dim2 = dimy) AND (ABS(dim1 - dimx) = 1))
          THEN (* bestimme ein Paar von benachbarten Feldern *)
            flag := id_no = REDUCE.FIRST(id_no);
          END;
          IF flag THEN buch := c END;
          nexte_marke := marke; (* Die neue Marke wurde nicht
                                   eingetragen *)
        ELSIF NOT fertig AND (receive1 <> NULL) AND (m = NULL)
        THEN (* Weg noch nicht gefunden *)
          IF (REDUCE.SUM(ORD(EINS <= receive1 <= DREI)) = 0) OR
             (REDUCE.SUM(ORD(VIER <= receive1 <= SECHS)) = 0)
          THEN (* eine Welle kann nicht mehr fortgesetzt werden *)
            fertig := TRUE;
            found := FALSE;
          ELSE (* beide Wellen sind noch OK *)
            m := receive1;
            flag := TRUE;
          END;
        END;
      ELSE (* ein Feld hat verschiedene Marken erhalten oder
              Anfangs- und Endpunkt wurden markiert *)
        fertig := TRUE;
        found := TRUE;
        IF flag
        THEN
          flag := FALSE; (* Startpunkt fuer Weg festlegen *)
          IF NOT REDUCE.MAX((STOP = m) OR (m = START))
          THEN (* Anfangs- und Endpunkt wurden nicht markiert *)
            IF id_no = REDUCE.FIRST(id_no) (* erstes Feld auswaehlen *)
            THEN
              flag := TRUE; (* markieren und Weg eintragen *)
              buch := c
            END;
          END;
        END;
      END;
      marke := nexte_marke;
    UNTIL fertig OR NOT REDUCE.MAX (flag);
    IF found
    THEN (* Wellen haben sich getroffen oder geschnitten *)
      IF 0 = REDUCE.SUM(ORD(flag))
      THEN (* Start und Endpunkt liegen nebeneinander *)
        RETURN (* nichts hat sich veraendert *)
      END;
      (* rueckverfolgen *)
      REPEAT
        INC(count); (* Schleifendurchlaeufe zaehlen *)
        nexte_marke := prev(marke);
        fertig2 := FALSE;
        shift := NULL;
        shift2 := NULL;
        receive1 := NULL;
        IF flag
        THEN (* zu verschickende Marken vergeben *)
          IF REDUCE.SUM(1) = 1
          THEN (* Wellen haben sich getroffen
                  d.h. ein Feld verschickt beide Marken *)
            shift := nexte_marke;
            shift2 := VAL(MARKEN,ORD(nexte_marke) + 3);
          ELSIF EINS <= m <= DREI
          THEN (* jedes Feld verschickt nur seine Marke *)
            shift := nexte_marke;
          ELSE
            shift2 := VAL(MARKEN,ORD(nexte_marke) + 3);
          END;
        END;                                              
        fertig := FALSE;
        flag := FALSE;
        (* verschicke die Marken nacheinander *)
        PROPAGATE.links (shift,receive1);
        IF (NULL <> receive1 = m) OR ((receive1 <> NULL) AND (m = START))
        THEN (* Weg markieren *)
          flag := TRUE;
          zu_start := TRUE;
        END;
        PROPAGATE.rechts (shift,receive1);
        IF (NULL <> m = receive1) OR ((receive1 <> NULL) AND (m = START))
        THEN (* Weg markieren *)
          flag := TRUE;
          zu_start := TRUE;
        END;
        PROPAGATE.oben (shift,receive1);
        IF (NULL <> m = receive1) OR ((receive1 <> NULL) AND (m = START))
        THEN (* Weg markieren *)
          flag := TRUE;
          zu_start := TRUE;
        END;
        PROPAGATE.unten (shift,receive1);
        IF (NULL <> m = receive1) OR ((receive1 <> NULL) AND (m = START))
        THEN (* Weg markieren *)
          flag := TRUE;
          zu_start := TRUE;
        END;
        PROPAGATE.links (shift2,receive1);
        IF (NULL <> m = receive1) OR ((receive1 <> NULL) AND (m = STOP))
        THEN (* Weg markieren *)
          flag := TRUE;
          zu_start := FALSE;
        END;
        PROPAGATE.rechts (shift2,receive1);
        IF (NULL <> m = receive1) OR ((receive1 <> NULL) AND (m = STOP))
        THEN (* Weg markieren *)
          flag := TRUE;
          zu_start := FALSE;
        END;
        PROPAGATE.oben (shift2,receive1);
        IF (NULL <> m = receive1) OR ((receive1 <> NULL) AND (m = STOP))
        THEN (* Weg markieren *)
          flag := TRUE;
          zu_start := FALSE;
        END;
        PROPAGATE.unten (shift2,receive1);
        IF (NULL <> m = receive1) OR ((receive1 <> NULL) AND (m = STOP))
        THEN (* Weg markieren *)
          flag := TRUE;
          zu_start := FALSE;
        END;
        IF flag
        THEN (* Weg eintragen *)
          flag := FALSE;
          IF m = STOP
          THEN
            fertig2 := TRUE
          ELSIF m = START
          THEN
            fertig := TRUE;
          ELSIF NOT fertig AND zu_start
          THEN (* erstes Feld markieren und den Weg eintragen *)
            flag := id_no = REDUCE.FIRST(id_no);
            IF flag THEN buch := c END;
          ELSIF NOT fertig2
          THEN (* erstes Feld markieren und den Weg eintragen *)
            flag := id_no = REDUCE.FIRST(id_no);
            IF flag THEN buch := c END;
          END;
        END;
        marke := nexte_marke;
      UNTIL NOT REDUCE.MAX(flag); (* Weg schon komplett ? *)
    ELSE
      WriteString("Kein Weg gefunden ");
      Write(c);
      WriteLn;
    END;
  ENDPARALLEL;
  STORE (buch,ein_aus);
  pfad := REDUCE.SUM(ORD(buch = c)) - 2; (* Anzahl der vergebenen
                                            Wegkennzeichner *)
END ariadne;


PROCEDURE Einlesen() : SCALAR INTEGER;

SCALAR i, vx,vy,nx,ny : INTEGER;
BEGIN
  i := 0;
  WriteString("Feldgroesse X : ");
  WriteInt(dim_x,5);
  WriteString("  Feldgroesse Y : ");
  WriteInt(dim_y,5);
  WriteLn;
  WriteString("Werte von 0 bis Feldgroesse - 1");
  WriteLn;
  REPEAT
    WriteString("Start X (Ende < 0) :");
    ReadInt(vx);
    IF vx < 0 THEN RETURN i END;
    WriteString("START Y :");
    ReadInt(vy);
    WriteString("END X :");
    ReadInt(nx);
    WriteString("END Y :");
    ReadInt(ny);
    IF (vx < dim_x) AND (0 <= vy < dim_y) AND (0 <= nx < dim_x) AND (0 <= ny < dim_y)
    THEN
      IF (ein_aus[vy,vx] = ' ') AND (ein_aus[ny,nx] = ' ')
      THEN
        ein_aus[vy,vx] := CHR(i + ORD('a'));
        ein_aus[ny,nx] := CHR(i + ORD('a'));
        i := i + 1;
      ELSE
        WriteString("Doppelte Besetzung eines Punktes");
        WriteLn;
      END      (*$d = (*$p = ariadne *)(*
routing prev *)*)
    ELSE
      WriteString("Fehlerhafte Punktangabe");
      WriteLn
    END
  UNTIL i = 26;
  RETURN i;
END Einlesen;

BEGIN
  PARALLEL
    buch := " ";
  ENDPARALLEL;
  STORE (buch,ein_aus);
  (* Einlesen *)
  l := Einlesen() - 1;
  WriteString("   ");
  FOR i := 0 TO dim_y - 1 DO
    WriteInt(i DIV 10,1);
  END;
  WriteLn;
  WriteString("   ");
  FOR i := 0 TO dim_y - 1 DO
    WriteInt(i MOD 10, 1);
  END;
  WriteLn;
  FOR i := 0 TO dim_y - 1 DO
    WriteInt(i DIV 10,1); WriteInt(i MOD 10,1); Write(' ');
    FOR j := 0 TO dim_x - 1 DO
      Write(ein_aus[i][j]);
    END;
    WriteLn;
  END;
  WriteLn;
  FOR k := 0 TO l DO
    pfad := 0;
    count := 0;
    ariadne(CHR(k + ORD('a')));
    (* ausgeben *)
    WriteString("   ");
    FOR i := 0 TO dim_y - 1 DO
      WriteInt(i DIV 10,1);
    END;
    WriteLn;
    WriteString("   ");
    FOR i := 0 TO dim_y - 1 DO
      WriteInt(i MOD 10, 1);
    END;
    WriteLn;
    FOR i := 0 TO dim_y - 1 DO
      WriteInt(i DIV 10,1); WriteInt(i MOD 10,1); Write(' ');
      FOR j := 0 TO dim_x - 1 DO
        Write(ein_aus[i][j]);
      END;
      WriteLn;
    END;
    WriteLn;
    WriteString("Zahl der Durchlaeufe durch die REPEAT-Schleifen : ");
    WriteInt(count,5);
    WriteLn;
    WriteString("Pfadlaenge : ");
    WriteInt(pfad,5);
    WriteLn;
  END;
END routing.
