SYSTEM main;  

CONST xsize1 = 125;
      ysize1 = 112;
      zsize1 = 87;
      small = 0.000001;
CONST max = 255;
TYPE mat = ARRAY [0..max] OF REAL;
	  mat1 = ARRAY [0..2] OF INTEGER;
     mat2 = ARRAY [0..2] OF REAL;
	  mat3 = ARRAY [1..10] OF REAL;
	  mat4 = ARRAY [1..10] OF INTEGER;
	  matri = ARRAY [1..4],[1..4] OF REAL;
	  STRING = ARRAY [1..30] OF CHAR; 
     aPoint = RECORD
						x : REAL;
						y : REAL;
						z : REAL;
              END;

     colorpix = RECORD
						Red : REAL; 
						Green : REAL;
                  Blue  : REAL;
             END;
     anImage = POINTER TO Image;
     Image = RECORD
						xcoor : REAL;  
						ycoor : REAL;
					   point : INTEGER;	
						PixColor : colorpix;
						link  : anImage;
             END;

(*CONFIGURATION grid [1..4],[1..4];
CONNECTION	      left : grid[i,j] -> grid[i, (j-1) MOD 4].left;
						up   : grid[i,j] -> grid[(i-1) MOD 4, j].up;
				     shiftA: grid[i,j] -> grid[i, (j-1) MOD 4].shiftA;
					  shiftB: grid[i,j] -> grid[(i-j) MOD 4, j].shiftB;
VECTOR ra,rb,rc : REAL;
*)

CONFIGURATION tree[1..39];
CONNECTION       right :  tree[i] ->{1<=i<=3} tree[i+3].right,
(* across2 : tree[5] ->*)            {5<i<7} tree[7].right,
(* across3 : tree[6] ->*)            {4<i<6} tree[8..9].right,
(* across1 : tree[4] ->*)            {3<i<5} tree[10..13].right,
(*  down : tree[14] ->*)             {i=14}  tree[14..15].right,
(* link : tree[15] ->*)              {i=15}  tree[16..18].right,
(* across2a *)(*rightx:tree[i] ->*)  {5<i<7} tree[19].right,
(* across3 : tree[6] ->*)            {4<i<6} tree[20..21].right,
(* across1 : tree[4] ->*)            {3<i<5} tree[22..25].right,
(* across2a *)(*righty:tree[i] ->*)  {5<i<7} tree[26].right,
(* across3 : tree[6] ->*)            {4<i<6} tree[27..28].right,
(* across1 : tree[4] ->*)            {3<i<5} tree[29..32].right,
(* across2b *) (*rightz:tree[i]->*)  {5<i<7} tree[33].right,
(* across3 : tree[6] ->*)            {4<i<6} tree[34..35].right,
(* across1 : tree[4] ->*)            {3<i<5} tree[36..39].right;

(*interpolate    son_l :  tree[i] -> {7<=i<=13} tree[2*i-6].father;
   density *)    son_r :  tree[i] -> {7<=i<=13} tree[2*i-5].father;
                father :  tree[i] -> {even(i)} tree[(i+6) div 2].son_l,
                                     {odd(i)} tree[(i+5) div 2].son_r;
(*interpolate  son_lx :  tree[i] -> {19<=i<= 25} tree[2*i-18].fatherx;
  gradient x *)son_rx :  tree[i] -> {19<=i<=25} tree[2*i-17].fatherx;
              fatherx :  tree[i] -> {even(i)} tree[(i+18) div 2].son_lx,
                                    {odd(i) } tree[(i+17) div 2].son_rx;
(*interpolate  son_ly :  tree[i] -> {26<=i<= 32} tree[2*i-25].fathery;
  gradient y *)son_ry :  tree[i] -> {26<=i<=32} tree[2*i-24].fathery;
              fathery :  tree[i] -> {even(i)} tree[(i+25) div 2].son_ly,
                                   {odd(i) } tree[(i+24) div 2].son_ry;

(*interpolate  son_lz :  tree[i] -> {33<= i <= 39} tree[2*i-32].fatherz;
 gradient z *)son_rz :  tree[i] -> {33<=i<=39} tree[2*i-31].fatherz;
              fatherz :  tree[i] -> {even(i)} tree[(i+32) div 2].son_lz,
                                   {odd(i) } tree[(i+31) div 2].son_rz;

VECTOR a,b,c,d,e,c1,c2,c3 : REAL;
SCALAR x,y,z, gCell_Size : REAL;
       xlim,ylim,zlim,X0,y0,z0, lamda, lamdamin, lamdamax, step_size : REAL;   
       N1, N2, N3, N4, N5: mat1;
      (* color,*) ColRes : mat2; 
       col : color; 
		 CR, CG, CB, OP : REAL;
       f : ARRAY [1..4] OF  REAL  ;
       f1, index, counter1,counter, handle, xres, yres, zres : INTEGER; 
		 OpacityMap : mat;
       ColorRed, ColorGreen, ColorBlue   : mat;  
       voxel : ARRAY [0..xsize1],[0..ysize1],[0..zsize1] OF REAL;
       ptr, start1, start2, PtrToFirst, PtrToLast : anImage;
       ptr1, PtrToFirst1, PtrToLast1 : anImage; 
		 jj,kk : INTEGER;
       buffer1, buffer2 : REAL;
       samplept,pixel,CSize, gVdir : aPoint;
       bound,empty,empty1,empty2 : BOOLEAN;
      (* below are global constant *)
		 pathname : STRING;
		 bgcol,amatcol,dmatcol,galigcol,aligcol,dligcol,dligdir,gdligdir,rot,
       scale,xrange,yrange,zrange,oldpt,newpt : mat2;   
       dist,xshift,yshift,start,stop : REAL;
       rcol,gcol,bcol,opa,alopa : mat3;
       fa,fb,fc : mat4;
       xsize,ysize,count1,count2,count3 : INTEGER;
       crmap,cgmap,cbmap,PriOpMap,AltOpMap : mat;
       transM : matri;
(*--------------------------------------------------------------------
  PROCEDURE TO READ IN THE GLOBAL CONSTANT FROM 
  PROCEDURE fread
  -------------------------------------------------------------------*)
  PROCEDURE fread;
  SCALAR fname,str : STRING;
			i : INTEGER;
			check,err : BOOLEAN;
  BEGIN
	 WriteString ('Please enter the parameter filename to visualize');
	 WriteLn;
	 ReadString (fname);
	 OpenInput (fname);
	 ReadString (str);
	 IF STRCMP (str,'volume_name') = 0 THEN

	 (* background colour       *)
		 ReadString (pathname);
		 ReadString (str);
		 FOR i := 0 TO 2 DO
			  ReadReal (bgcol[i]);
       END;
	  (* ambient material colour *) 
		 ReadString (str);
       FOR i := 0 TO 2 DO
			ReadReal (amatcol[i]);     (* ambient material colour *)
       END;
     (* diffuse material colour *)
       ReadString (str);
		 FOR i := 0 TO 2 DO
		 ReadReal (dmatcol[i]);
		 END;
     (* ambient light colour    *)
		 ReadString (str);
		 FOR i := 0 TO 2 DO
			ReadReal (aligcol[i]);
       END;
     (* direct light colour     *)
   	 ReadString (str);
       FOR i := 0 TO 2 DO
			 ReadReal (dligcol[i]);    
       END;
     (* direct light direction  *)
		 ReadString (str);
		 FOR i := 0 TO 2 DO
			ReadReal (dligdir[i]);
       END;
     (* angle of rotation       *)
		 ReadString (str);
		 FOR i := 0 TO 2 DO
			ReadReal (rot[i]);
       END;
     (*  distance between image plane and volume     *)
		 ReadString (str);
		 ReadReal (dist);
     (*  x and y direction shifts   *)
		 ReadString (str); 
		 ReadReal (xshift);
		 ReadReal (yshift);
     (*     image plane size        *)
       ReadString (str);
		 ReadInt (xsize);
		 ReadInt (ysize);
     (* x,y,z direction cell scale  *)
		 ReadString (str);
		 FOR i := 0 TO 2 DO
			ReadReal (scale[i]);
       END;
     (*  start and stop square size              *)
		 ReadString (str);
		 ReadReal (start);
		 ReadString (str);
		 ReadReal (stop);
     (*  x,y,z direction ranges                  *)
		 ReadString (str);
		 ReadReal (xrange[1]);
	    ReadReal (xrange[2]);
       ReadString (str);
		 ReadReal (yrange[1]);
		 ReadReal (yrange[2]);
	    ReadString (str);
		 ReadReal (zrange[1]);
		 ReadReal (zrange[2]);
     (*to read in the RGB colour values for a particular density*)
		 ReadString (str);
       check := TRUE;
		 count1 := 1;
	    WHILE check DO
				 ReadInt (fa[count1]);
				 ReadReal (rcol[count1]);
				 ReadReal (gcol[count1]);
				 ReadReal (bcol[count1]);
				 IF fa[count1] = 255 THEN
					check := FALSE;
             ELSE
					count1 := count1 + 1;
             END;
       END;
     (*to read in the primary opacity value for a particular density*)
		 ReadString (str);
		 check := TRUE;
		 count2 := 1;
       WHILE check DO
			    ReadInt (fb[count2]);
             ReadReal (opa[count2]);
				 IF fb[count2] = 255 THEN
					check := FALSE;
             ELSE
					count2 := count2 + 1;
             END;
       END;
     (*to read in the alternate opacity value for a particular density*)
		 ReadString (str);
		 check := TRUE;
		 count3 := 1;
       WHILE check DO
			    ReadInt (fc[count3]); 
				 ReadReal (alopa[count3]);
             IF fc[count3] = 255 THEN
					check := FALSE;
             ELSE
					count3 := count3 + 1;
             END;
       END;
     ELSE
		 WriteString ('There are errors in reading the parameter file!');
		 err := FALSE;
	  END;
	  CloseInput;
  END fread;

(*--------------------------------------------------------------------
  PROCEDURE TO PERFORM INTERPOLATION TO OBTAIN RGB COLOR AND OPACITY
  MAPS
  PROCEDURE map
  --------------------------------------------------------------------*)

  PROCEDURE map;
  SCALAR rratio,gratio,bratio,opratio : REAL;
			i,j : INTEGER;
  BEGIN
	 FOR i := 1 TO count1-1 DO  (* RGB colour map *)
		  rratio := (rcol[i+1] - rcol[i])/FLOAT(fa[i+1] - fa[i]);
		  gratio := (gcol[i+1] - gcol[i])/FLOAT(fa[i+1] - fa[i]);
		  bratio := (bcol[i+1] - bcol[i])/FLOAT(fa[i+1] - fa[i]);
		  FOR j := fa[i] TO fa[i+1] DO
    colorred[j] (*crmap[j]*) := rcol[i] + FLOAT(j - fa[i]) * rratio;
    colorgreen[j](*cgmap[j]*) := gcol[i] + FLOAT(j - fa[i]) * gratio;
    colorblue[j](*cbmap[j]*) := bcol[i] + FLOAT(j - fa[i]) * bratio;
        END;
    END;
	 FOR i := 1 TO count2-1 DO   (* Primary Opacity Map *)
		  opratio := (opa[i+1] - opa[i])/FLOAT(fb[i+1] - fb[i]);
		  FOR j := fb[i] TO fb[i+1] DO
		  OpacityMap[j](*PriOpMap[j]*):= opa[i] + FLOAT(j - fb[i]) * opratio;
        END;
    END;
	 FOR i := 1 TO count3-1 DO   (* Alternate Opacity Map *)
		  opratio := (alopa[i+1] - alopa[i])/FLOAT(fc[i+1] - fc[i]);
		  FOR j := fc[i] TO fc[i+1] DO
				AltOpMap[j] := alopa[i] + FLOAT(j - fc[i]) * opratio;
        END;
    END;
  END map;



 (*------------------------------------------------------------
  PROCEDURE TO READ IN TEST DATA OF VOXEL VALUE
  PROCEDURE voxel   
  -------------------------------------------------------------*)

  PROCEDURE voxelget(SCALAR xsize,ysize,zsize : INTEGER);

  SCALAR i,j,k : INTEGER;
             ch: CHAR;
  BEGIN
	  OpenInput ( 'testinga' );
	 (* ReadInt(xres);
	  ReadInt(yres);
	  ReadInt(zres);
	 *)
	 FOR i := 0 TO xres-1 DO 
		  FOR j  := 0 TO yres-1 DO
			  FOR k := 0 TO zres-1 DO
	      		 Read (ch); 
					 voxel[i,j,k] := FLOAT(ORD(ch)) ;
		  	  END;
		  END;
	  END;
     CloseInput;

  (*  OpenInput ('fmh17a');
	 FOR i := 0 TO xres-1 DO 
		  FOR j  := 0 TO yres-1 DO
			  FOR k := 5 TO 9 DO
	      		 Read (ch); 
					 voxel[i,j,k] := FLOAT(ORD(ch));
		  	  END;
		  END;
	  END;
     CloseInput;
*)(*
    OpenInput ('fmh4');
	 FOR i := 0 TO xres-1 DO 
		  FOR j  := 0 TO yres-1 DO
			  FOR k := 10 TO 14 DO
	      		 ReadReal (voxel[i,j,k]);
		  	  END;
		  END;
	  END;
     CloseInput;
    OpenInput ('fmh5');
	 FOR i := 0 TO xres-1 DO 
		  FOR j  := 0 TO yres-1 DO
			  FOR k := 15 TO 19 DO
	      		 ReadReal (voxel[i,j,k]);
		  	  END;
		  END;
	  END;
     CloseInput;
    OpenInput ('fmh6');
	 FOR i := 0 TO xres-1 DO 
		  FOR j  := 0 TO yres-1 DO
			  FOR k := 20 TO 24 DO
	      		 ReadReal (voxel[i,j,k]);
		  	  END;
		  END;
	  END;
     CloseInput;
    OpenInput ('fmh7');
	 FOR i := 0 TO xres-1 DO 
		  FOR j  := 0 TO yres-1 DO
			  FOR k := 25 TO 29 DO
	      		 ReadReal (voxel[i,j,k]);
		  	  END;
		  END;
	  END;
     CloseInput;
    OpenInput ('fmh8');
	 FOR i := 0 TO xres-1 DO 
		  FOR j  := 0 TO yres-1 DO
			  FOR k := 30 TO 34 DO
	      		 ReadReal (voxel[i,j,k]);
		  	  END;
		  END;
	  END;
     CloseInput;
    OpenInput ('fmh9');
	 FOR i := 0 TO xres-1 DO 
		  FOR j  := 0 TO yres-1 DO
			  FOR k := 35 TO 39 DO
	      		 ReadReal (voxel[i,j,k]);
		  	  END;
		  END;
	  END;
     CloseInput;
    OpenInput ('fmh10');
	 FOR i := 0 TO xres-1 DO 
		  FOR j  := 0 TO yres-1 DO
			  FOR k := 40 TO 44 DO
	      		 ReadReal (voxel[i,j,k]);
		  	  END;
		  END;
	  END;
     CloseInput;
    OpenInput ('fmh11');
	 FOR i := 0 TO xres-1 DO 
		  FOR j  := 0 TO yres-1 DO
			  FOR k := 45 TO 49 DO
	      		 ReadReal (voxel[i,j,k]);
		  	  END;
		  END;
	  END;
     CloseInput;
 *)  (* OpenInput ('fmh11');
	 FOR i := 0 TO xres-1 DO 
		  FOR j  := 0 TO yres-1 DO
			  FOR k := 50 TO 54 DO
	      		 ReadReal (voxel[i,j,k]);
		  	  END;
		  END;
	  END;
     CloseInput;
*)
(*    OpenInput ( 'testing5a'); 
      FOR i := 0 TO 90 DO
		  FOR j := 0 TO  90 DO
			 FOR k := 11 TO 20 DO
			  ReadReal (voxel[i,j,k]);
			 END;
		END;
	  END;
   CloseInput;

	 OpenInput ( 'testing5b');
	 FOR i := 0 TO 90 DO
	FOR j := 0 TO 90 DO
		 FOR k := 21 TO 30 DO
			ReadReal (voxel[i,j,k]);
		 END;
	 END;
	END;

CloseInput;


 OpenInput ( 'testing5c');
 FOR i := 0 TO 90 DO
FOR j := 0 TO 90 DO
 FOR k := 31 TO 40 DO
		ReadReal (voxel[i,j,k]);
 END;
 END;
END;

CloseInput;


 OpenInput ( 'testing5d');
  FOR i := 0 TO 90 DO
  FOR j := 0 TO 90 DO
	FOR k := 41 TO 50 DO
			ReadReal (voxel[i,j,k]);
			 END;
			  END;
			  END;

			  CloseInput;
*)
  END voxelget;
(*----------------------------------------------------------------- 
  to obtain the x,y,z direction gradient for a particular point 
-----------------------------------------------------------------*) 
 PROCEDURE gradient (SCALAR VAR normal:aPoint; SCALAR i,j,k:INTEGER);
 SCALAR norm ,normal1: mat2;
 BEGIN
   IF NOT((i=0) OR (i=xres-1)) THEN 	
	   norm[0] := (voxel[i-1,j,k] - voxel[i+1,j,k])/2.0;
   ELSIF i=0 THEN
	   norm[0] := (voxel[i,j,k] - voxel[i+1,j,k]);
   ELSIF i=xres-1 THEN
		norm[0] := (voxel[i-1,j,k] - voxel[i,j,k]);
   END;
		
   IF NOT((j=0) OR (j=yres-1)) THEN	
	   norm[1] := (voxel[i,j-1,k] - voxel[i,j+1,k])/2.0;
   ELSIF j=0 THEN	
	   norm[1] := (voxel[i,j,k] - voxel[i,j+1,k]);
   ELSIF j=yres-1 THEN	
	   norm[1] := (voxel[i,j-1,k] - voxel[i,j,k]);
	END;
    
   IF NOT((k=0) OR (k=zres-1)) THEN
		norm[2] := (voxel[i,j,k-1] - voxel[i,j,k+1])/2.0;
   ELSIF k=0 THEN
		norm[2] := (voxel[i,j,k] - voxel[i,j,k+1]);
   ELSIF k=zres-1 THEN
		norm[2] := (voxel[i,j,k-1] - voxel[i,j,k]);
   END;
	veNor (norm,normal1);
   normal.x := normal1[0];
	normal.y := normal1[1];
	normal.z := normal1[2];
 END gradient;

(*------------------------------------------------------------
  PROCEDURE TO CALCULATE MAGNITUDE OF A VECTOR
  PROCEDURE veMag (SCALAR vec:mat2) : SCALAR REAL
  -----------------------------------------------------------*)
 PROCEDURE veMag (SCALAR vec:mat2) : SCALAR REAL;
 SCALAR sun : REAL;
 BEGIN
 PARALLEL tree[1..3]  
      LOAD (c1,vec); 
		c2 := c1*c1;
      sun := SQRT (REDUCE.SUM (c2));
 ENDPARALLEL;  
 RETURN sun; 
 END veMag;

(*------------------------------------------------------------
  PROCEDURE TO NORMALIZE A VECTOR => UNIT VECTOR
 PROCEDURE veNor (SCALAR VAR vec,vect:mat2)
-----------------------------------------------------------*)

 PROCEDURE veNor (SCALAR VAR vec,vect:mat2);
 SCALAR ma : REAL;
 BEGIN
   ma := veMag (vec);
   
   PARALLEL tree[1..3]	
      LOAD (c1,vec);
		IF ma=0.0 THEN
			c2 := 0.0;
      ELSE
			c2 := c1/ma;
	   END; 
		STORE  (c2,vect);
   ENDPARALLEL; 
 END veNor;

 (*----------------------------------------------------------
   PROCEDURE TO PERFORM VECTOR DOT PRODUCT
	ROCEDURE veDot (SCALAR vec1,vec2:mat) : SCALAR REAL
	----------------------------------------------------------*)

	PROCEDURE veDot (SCALAR vec1,vec2:mat2) : SCALAR REAL;
	SCALAR sun : REAL;
	BEGIN
	  PARALLEL tree[1..3]
	    LOAD  (c1,vec1);
	    LOAD  (c2,vec2);
		 c3 := c1*c2;
		 sun := REDUCE.SUM (c3);
     ENDPARALLEL;
     RETURN sun; 
	END veDot;

(*------------------------------------------------------------
  PROCEDURE TO MOVE DATAS FROM MATRIX TEMP TO MATRIX TRANS
  PROCEDURE maMv (SCALAR VAR temp,trans : matri)
  ------------------------------------------------------------*)
  PROCEDURE maMv (SCALAR VAR temp,trans : matri);
  BEGIN
	 PARALLEL tree[1..16]
	   LOAD (a,temp);
		STORE (a,trans);
      Write("a");
		WriteReal(a,3); 
	 ENDPARALLEL;
  END maMv;

  (*-----------------------------------------------------------
	 PROCEDURE TO PERFORM MATRIX MULTIPLICATION
	 PROCEDURE maMul (SCALAR VAR ma,mb,mc : matri)
	 ----------------------------------------------------------*)

	 PROCEDURE maMul (SCALAR VAR ma,mb,mc : matri);
	 
	 SCALAR i,j,k : INTEGER;
			  sum : REAL;

(*SCALAR i : INTEGER;
	 BEGIN
		PARALLEL grid[1..4],[1..4]   
		  LOAD (ra,ma);
		  LOAD (rb,mb);
		  WriteString("ra");
		  WriteReal(ra,3);
		  WriteString("rb");
		  WriteReal(rb,3);
		  PROPAGATE.shiftA(ra);
		  PROPAGATE.shiftB(rb);
		  rc := ra * rb;
		  FOR i := 2 TO 4 DO
				PROPAGATE.left(ra);
				PROPAGATE.up(rb);
				rc := rc + ra * rb;
        END;
	     WriteString("rc");
		  WriteReal(rc,3);
		  STORE(rc,mc);
		ENDPARALLEL;
*)
	 BEGIN
		 FOR i := 1 TO 4 DO
			  FOR j := 1 TO 4 DO
					sum := 0.0;
					FOR k := 1 TO 4 DO
						 sum := sum + ma[i,k] * mb[k,j];
					END;
               mc[i,j] := sum;
           END;
       END;

 END maMul;
  (*-------------------------------------------------------------
	 PROCEDURE TO OBTAIN AN IDENTITY MATRIX
	 PROCEDURE maId (SCALAR VAR matris:matri)
    ------------------------------------------------------------*)

	 PROCEDURE maId (SCALAR VAR matris:matri);
	 BEGIN
		matris[1,1] := 1.0; matris[1,2] := 0.0;
		matris[1,3] := 0.0; matris[1,4] := 0.0;
		matris[2,1] := 0.0; matris[2,2] := 1.0;
		matris[2,3] := 0.0; matris[2,4] := 0.0;
		matris[3,1] := 0.0; matris[3,2] := 0.0;
	   matris[3,3] := 1.0; matris[3,4] := 0.0;
		matris[4,1] := 0.0; matris[4,2] := 0.0;
		matris[4,3] := 0.0; matris[4,4] := 1.0;
    END maId;

  (*--------------------------------------------------------------
	 PROCEDURE TO TRANSFORM THE IMAGE PLANE COORDINATES TO WORLD
	 COORDINATES USING TRANSFORMATION MATRIX
	 PROCEDURE maTrans (SCALAR trans:matri; SCALAR VAR oldpt,newpt:mat)
    ---------------------------------------------------------------*)

	 PROCEDURE maTrans (SCALAR trans:matri; SCALAR VAR oldpt,newpt:mat2);
	 SCALAR i,j : INTEGER;
			  new,old : ARRAY [1..4] OF REAL;
    BEGIN
		old[1] := oldpt[0];     old[2] := oldpt[1];
		old[3] := oldpt[2];     old[4] := 1.0;
      FOR i := 1 TO 4 DO
		    new[i] := 0.0;
		    FOR j := 1 TO 4 DO
			     new[i] := new[i] + trans[i,j]*old[j];
          END;
      END;
	   WriteReal(new[1],3);
		WriteReal(new[2],3);
		WriteReal(new[3],3);
		WriteReal(new[4],3);
		WriteLn;
		newpt[0] := new[1]/new[4];
		newpt[1] := new[2]/new[4];
		newpt[2] := new[3]/new[4];
    END maTrans;
 
   (*---------------------------------------------------------------
	  PROCEDURE TO SET THE ENVIRONMENT
	  PROCEDURE setEnv
     --------------------------------------------------------------*)
	  PROCEDURE setEnv;
	  SCALAR
	  BEGIN
       veNor (dligdir,gdligdir);(*normalize direct light direction *)
	  END setEnv;

   (*---------------------------------------------------------------
	  PROCEDURE TO SET THE PROJECTION OF THE PLANE BEFORE DOING RAY
	  CASTING
	  PROCEDURE setProj
     ---------------------------------------------------------------*)
	  PROCEDURE setProj;
	  SCALAR action,rotate,trans,temp,temp1 : matri;
				rad : REAL; tVdir,gVdir1,Vdir1 : mat2;
				i,j : INTEGER;
     BEGIN
		  rad := rot[0]/10.0 * pi/180.0;
		  maId (rotate);
		  rotate[2,2] := COS(rad);    rotate[2,3] := -SIN(rad);
		  rotate[3,2] := SIN(rad);    rotate[3,3] := COS(rad);
		  rad := rot[1]/10.0 * pi/180.0;
		  maId (action);
		  action[1,1] := COS(rad);    action[1,3] := -SIN(rad);
		  action[3,1] := SIN(rad);    action[3,3] := COS(rad);
		  maMul (action,rotate,temp);
		  maMv (temp,rotate);
		  rad := rot[2]/10.0 * pi/180.0;
		  maId (action);
		  action[1,1] := COS(rad);    action[1,2] := -SIN(rad);
		  action[2,1] := SIN(rad);    action[2,2] := COS(rad);
		  maMul (action,rotate,temp);
		  maMv (temp,rotate);
		  tVdir[0] := 0.0;
		  tVdir[1] := 0.0;
		  tVdir[2] := -1.0;
		  WriteString("yes"); 
		  maTrans (rotate,tVdir,Vdir1);
		  WriteString("Direc");
		  WriteReal(Vdir1[0],3);
		  WriteReal(Vdir1[1],3);
		  WriteReal(Vdir1[2],3);
		  WriteLn;
		  veNor (Vdir1,gVdir1);
		  gVdir.x := gVdir1[0];
		  gVdir.y := gVdir1[1];
		  gVdir.z := gVdir1[2];
		  maId (trans);
		  trans[3,4] := dist;
		  trans[1,4] := -FLOAT(xsize)/2.0 + xshift;
		  trans[2,4] := -FLOAT(ysize)/2.0 + yshift; 
		  maMul (rotate,trans,transM);
	  END setProj;

 (*----------------------------------------------------------------
   PROCEDURE TO INPUT DATA TO PEs IN PIPE 1,5
   PROCEDURE ArrayPE1 (SCALAR VAR x,y,z : REAL )
  ----------------------------------------------------------------*)
  
  PROCEDURE ArrayPE1 (SCALAR VAR x,y,z : REAL );

  SCALAR ra : ARRAY [1..19] OF REAL;
			rb : ARRAY [1..16] OF REAL;
          i : INTEGER;
       grad : ARRAY [0..7] OF aPoint; 
  BEGIN

(*  Write("N");       
  WriteLn; 
  FOR i:= 0 TO 2 DO
  WriteInt(N[i],3);   
  WriteLn;
  END;
*) 
  gradient(grad[0],N4[0],N4[1],N4[2]);
  gradient(grad[1],N4[0]+1,N4[1],N4[2]);
  gradient(grad[2],N4[0],N4[1]+1,N4[2]);
  gradient(grad[3],N4[0]+1,N4[1]+1,N4[2]);
  gradient(grad[4],N4[0],N4[1],N4[2]+1);
  gradient(grad[5],N4[0]+1,N4[1],N4[2]+1);
  gradient(grad[6],N4[0],N4[1]+1,N4[2]+1);
  gradient(grad[7],N4[0]+1,N4[1]+1,N4[2]+1);
	
  
  ra[1] := x;
  ra[2] := y;
  ra[3] := z;
  ra[4] := voxel [ N4[0]+1,N4[1],N4[2] ];
  ra[5] := voxel [ N4[0]+1,N4[1]+1,N4[2] ];
  ra[6] := voxel [ N4[0]+1,N4[1],N4[2]+1 ];
  ra[7] := voxel [ N4[0]+1,N4[1]+1,N4[2]+1 ];
  ra[8] := grad[1].x;
  ra[9] := grad[3].x;
  ra[10] := grad[5].x;
  ra[11] := grad[7].x;
  ra[12] := grad[1].y;
  ra[13] := grad[3].y;
  ra[14] := grad[5].y;
  ra[15] := grad[7].y;
  ra[16] := grad[1].z;
  ra[17] := grad[3].z;
  ra[18] := grad[5].z;
  ra[19] := grad[7].z;


  rb[1] := voxel [ N4[0],N4[1],N4[2] ];
  rb[2] := voxel [ N4[0],N4[1]+1,N4[2]];
  rb[3] := voxel [ N4[0],N4[1],N4[2]+1 ];
  rb[4] := voxel [ N4[0],N4[1]+1,N4[2]+1 ];
  rb[5] := grad[0].x;
  rb[6] := grad[2].x;
  rb[7] := grad[4].x;
  rb[8] := grad[6].x;
  rb[9] := grad[0].y;  
  rb[10] := grad[2].y;
  rb[11] := grad[4].y;
  rb[12] := grad[6].y;
  rb[13] := grad[0].z;
  rb[14] := grad[2].z;
  rb[15] := grad[4].z;
  rb[16] := grad[6].z;


  PARALLEL tree[1..3,10..13,22..25,29..32,36..39] 
	 LOAD (a,ra);
  ENDPARALLEL; 
  PARALLEL tree[10..13,22..25,29..32,36..39] 
	 LOAD (b,rb);
  ENDPARALLEL; 
  
  
  FOR i := 0 TO 2 DO
      N1[i] := N2[i];
      N2[i] := N3[i];
      N3[i] := N4[i];
      N4[i] := N5[i];
  END;
  END ArrayPE1;






(*----------------------------------------------------------------------------*)
(*  PROCEDURE TO GENERATE AND PUT IN GENERAL CONSTANT                         *)
(*  PROCEDURE Constant (SCALAR cell_size : REAL)                              *)
(*  PASS IN THE CELL SIZE TO CAL. SX,SY,SZ                                    *)
(*----------------------------------------------------------------------------*)
PROCEDURE Constant (SCALAR cell_size : REAL);
SCALAR rc : ARRAY [1..3] OF REAL;

BEGIN
(* INITIALIZE ARRAY TO PUT IN SX, SY, SZ *)
rc[1] := 1.0 / scale[0];
rc[2] := 1.0 / scale[1];
rc[3] := 1.0 / scale[2];
PARALLEL tree[1..3]
LOAD(c,rc)
ENDPARALLEL;
PARALLEL tree[14..15]
a := 1.0 
ENDPARALLEL;
PARALLEL tree[4..6]

c := 1.0
ENDPARALLEL;


 



END Constant;



(*----------------------------------------------------------------------------*)
(* PROCEDURE TO CAL. VALUE OF X,Y,Z OF A SAMPLE OF A RAY                      *)
(* PROCEDURE sample(SCALAR x,y,z,x0,y0,z0,lamda : REAL)         *)
(* x,y,z = coordinate of the sample returned                       *)
(* x0,y0,z0 = coordinate of the reference point of the ray(pt. on image
              plane)
   lamda    = parameter of the ray, in this case the length of the ray
	           from the reference point
   Equation of a line :
   x = aa * lamda + x0,
	y = bb * lamda + y0,
	z = cc * lamda + zo.                        
	 
   
--------------------------------------------------------------------------*)
 
 
PROCEDURE sample (SCALAR x0,y0,z0,lamda : REAL );                   


BEGIN

samplept.x := gVdir.x * lamda + x0;
samplept.y := gVdir.y * lamda + y0;
samplept.z := gVdir.z * lamda + z0;

IF samplept.x >= xlim THEN
	samplept.x := xlim - step_size/4.0;
END;
IF samplept.y >= ylim THEN
	samplept.y := ylim - step_size/4.0;
END;
IF samplept.z >= zlim THEN
	samplept.z := zlim - step_size/4.0;

END;
(*WriteReal(x,3);
WriteReal(y,3);
WriteReal(z,3); *)
END sample;

(*---------------------------------------------------------------------
 PROCEDURE TO ALLOCATE X,Y,Z INTO PIPE 1                            
 -----------------------------------------------------------------------*)
 PROCEDURE allocate_pipe1 (SCALAR x,y,z : REAL); 
 SCALAR ra : ARRAY [1..3] OF REAL;

 BEGIN
 ra[1] := x;
 ra[2] := y;
 ra[3] := z;

 PARALLEL tree[1..3]
 LOAD(a,ra)
 ENDPARALLEL;
 END allocate_pipe1;
  

(*-------------------------------------------------------------------  
 PROCEDURE TO DO PIPE 2(A)
 PROCEDURE pipe2 ()
 An array N[3] is declared here to store the i,j,k value of the 
 voxel.
 ------------------------------------------------------------------------*)

 PROCEDURE pipe2;
 VECTOR buf : INTEGER;
 SCALAR i   : INTEGER;
 BEGIN


 PARALLEL tree[4..6]
 RECEIVE tree.right(a) FROM tree.right(e);
 buf := TRUNC(a);
 
b := FLOAT(buf); 
  IF index=0 THEN 
     STORE (buf,N4);  
  END; 
  IF index > 0 THEN 
	  STORE (buf,N5);
  END;         
 ENDPARALLEL; 

  END pipe2;  

(*-------------------------------------------------------------------------

  PROCEDURE TO COMBINE THE PIPE 2 & 6 OPERATION
	 PROCEDURE Serial;

----------------------------------------------------------------------*)


	 PROCEDURE Serial;

	  BEGIN

	  Pipe2;
	  ColorOp(f1);

	  END Serial;



(*---------------------------------------------------------------------------
  PROCEDURE TO ASSIGN VALUE TO CR,CG,CB,OP ( PIPE 6 )
	 PROCEDURE ColorOp

	 ---------------------------------------------------------------------------*)

	  PROCEDURE ColorOp( Scalar f1 : INTEGER);
     SCALAR grad : mat2;
		BEGIN
    (*		 CR := ColorRed[f1] ;
		    CG := ColorGreen[f1](*/255.0*);
			 CB := ColorBlue[f1](*/255.0*);
			 OP := OpacityMap[f1](*/255.0*); 
     *)
    (* IF OP=0.0 THEN
				 empty := TRUE;
          END;
          WriteString("Density");
			 WriteLn;
			 WriteInt(f1,3);
          WriteLn; 
			 WriteString("CR");
			 WriteReal(CR,3);
          WriteReal(CG,3);
			 WriteReal(CB,3);
			 WriteReal(OP,3);
*)
          grad[0] := f[2];
			 grad[1] := f[3];
			 grad[2] := f[4];
			 detOpa (f1,OP,N1[0],N1[1],N1[2]);
			 detcol (f1,grad);
			  END ColorOp;


(*------------------------------------------------------------
 to obtain the opacity of a particular point either from the
   Alternate Opacity Map or the Primary Opacity Map         
PROCEDURE detOpa (SCALAR f:INTEGER; SCALAR VAR op:REAL);  
--------------------------------------------------------------*)
PROCEDURE detOpa (SCALAR f:INTEGER;SCALAR VAR op:REAL;
                  SCALAR i,j,k:INTEGER);
SCALAR
BEGIN
  IF (xrange[1]<=FLOAT(i)) & (FLOAT(i)<=xrange[2])
   & (yrange[1]<=FLOAT(j)) & (FLOAT(j)<=yrange[2])
   & (zrange[1]<=FLOAT(k)) & (FLOAT(k)<=zrange[2]) THEN
     OP := AltOpMap[f];
  ELSE
     OP := OpacityMap[f];
  END;
END detOpa;

(*--------------------------------------------------------------
 to obtain RGB colours from the RGB colour maps 
PROCEDURE detCol (SCALAR f:INTEGER; SCALAR grad:mat);
---------------------------------------------------------------*)
PROCEDURE detCol (SCALAR f:INTEGER; SCALAR grad:mat2);
SCALAR dotprod : REAL;
       grad1 : mat2;
BEGIN
  veNor (grad,grad1); 
  CR := ColorRed[f] *  aligcol[0];
  CG := ColorGreen[f] * aligcol[1];
  CB := ColorBlue[f] * aligcol[2];
  dotprod := veDot (grad1,gdligdir);
  IF dotprod > 0.0 THEN
    CR := CR + ColorRed[f]*dligcol[0]*dotprod;
    CG := CG + ColorGreen[f]*dligcol[1]*dotprod;
    CB := CB + ColorBlue[f]*dligcol[2]*dotprod;
  END;
END detCol;

(*---------------------------------------------------------------------
PROCEDURE TO ALLOCATE C (CR, CG, CB, OP) TO PIPE7 /INCLUDE 8 IN PIPE 
HALF FILLED CASE 
PROCEDURE nArrayPE2(SCALAR CR,CG,CB : REAL)
-----------------------------------------------------------------------*)

PROCEDURE nArrayPE2 (SCALAR CR,CG,CB,OP : REAL);
SCALAR rc : ARRAY [1..5] OF REAL;

BEGIN


rc[1] := OP;
rc[2] := OP;
rc[3] := CR;
rc[4] := CG;
rc[5] := CB;  

PARALLEL tree[14..18]
LOAD(c,rc);
ENDPARALLEL;

END nArrayPE2;

(*---------------------------------------------------------------------
PROCEDURE TO ALLOCATE c (CR, CG,CB, OP) TO PIPE7/8 IN PIPE FULL CASE
PROCEDURE ArrayPE2 (SCALAR CR, CG, CB, OP : REAL)
-----------------------------------------------------------------------*)

PROCEDURE ArrayPE2 (SCALAR CR, CG, CB, OP : REAL);
SCALAR rc : ARRAY [1..3] OF REAL;

BEGIN

rc[1] := CR;
rc[2] := CG;
rc[3] := CB;

PARALLEL tree[16..18]
LOAD(c1,rc);
ENDPARALLEL;

PARALLEL tree[14..15]
c := OP;
ENDPARALLEL;

END ArrayPE2;

(*-----------------------------------------------------------------------------
  PROCEDURE TO LOAD IN VALUE ( VOXEL DENSITY) TO PIPE 3
  PROCEDURE ArrayPE3( SCALAR N: mat1)
 -----------------------------------------------------------------------------*)   

  PROCEDURE ArrayPE3;

  SCALAR ra : ARRAY [1..16] OF REAL;
    		rb : ARRAY [1..16] OF REAL;
			i : INTEGER;
       grad : ARRAY [0..7] OF aPoint; 
  BEGIN
  
  
  gradient(grad[0],N4[0],N4[1],N4[2]);
  gradient(grad[1],N4[0]+1,N4[1],N4[2]);
  gradient(grad[2],N4[0],N4[1]+1,N4[2]);
  gradient(grad[3],N4[0]+1,N4[1]+1,N4[2]);
  gradient(grad[4],N4[0],N4[1],N4[2]+1);
  gradient(grad[5],N4[0]+1,N4[1],N4[2]+1);
  gradient(grad[6],N4[0],N4[1]+1,N4[2]+1);
  gradient(grad[7],N4[0]+1,N4[1]+1,N4[2]+1);

  
  
  ra[1]  := voxel [ N4[0]+1,N4[1],N4[2] ];
  ra[2] := voxel [ N4[0]+1,N4[1]+1,N4[2] ];
  ra[3] := voxel [ N4[0]+1,N4[1],N4[2]+1 ];
  ra[4] := voxel [ N4[0]+1,N4[1]+1,N4[2]+1 ];
  ra[5] := grad[1].x;
  ra[6] := grad[3].x;
  ra[7] := grad[5].x;
  ra[8] := grad[7].x;
  ra[9] := grad[1].y;
  ra[10] := grad[3].y;
  ra[11] := grad[5].y;
  ra[12] := grad[7].y;
  ra[13] := grad[1].z;
  ra[14] := grad[3].z;
  ra[15] := grad[5].z;
  ra[16] := grad[7].z;


  rb[1] := voxel [ N4[0],N4[1],N4[2] ];
  rb[2] := voxel [ N4[0],N4[1]+1,N4[2]];
  rb[3] := voxel [ N4[0],N4[1],N4[2]+1 ];
  rb[4] := voxel [ N4[0],N4[1]+1,N4[2]+1 ];
  rb[5] := grad[0].x;
  rb[6] := grad[2].x;
  rb[7] := grad[4].x;
  rb[8] := grad[6].x;
  rb[9] := grad[0].y;
  rb[10] := grad[2].y;
  rb[11] := grad[4].y;
  rb[12] := grad[6].y;
  rb[13] := grad[0].z;
  rb[14] := grad[2].z;
  rb[15] := grad[4].z;
  rb[16] := grad[6].z;
 
  PARALLEL tree[10..13](*,22..25,29..32,36..39]*)
  LOAD (a,ra);
  LOAD (b,rb);
  ENDPARALLEL; 

  FOR i:= 0 TO 2 DO 
  N1[i] := N2[i];
  N2[i] := N3[i];
  N3[i] := N4[i];
  N4[i] := N5[i];
  END;


  END ArrayPE3;




(*------------------------------------------------------------------------
PROCEDURE TO DO PROPAGATE.father IN GENERAL CASE
PROCEDURE Pro_F 
-------------------------------------------------------------------------*)

PROCEDURE Pro_F;

BEGIN


PARALLEL tree[8..13]
(*   IF even(id_no) THEN
		PROPAGATE.father(e,b);
   END;
	IF odd(id_no) THEN
		PROPAGATe.father(e,a);
   END; *) 
    

		SEND tree.father(e) TO tree.son_l(b);   
		SEND tree.father(e) TO tree.son_r(a);  
ENDPARALLEL;

PARALLEL tree[ 20..25] 

		SEND tree.fatherx(e) TO tree.son_lx(b);   
		SEND tree.fatherx(e) TO tree.son_rx(a);  
ENDPARALLEL;

PARALLEL tree[ 27..32] 

		SEND tree.fathery(e) TO tree.son_ly(b);   
		SEND tree.fathery(e) TO tree.son_ry(a);  
ENDPARALLEL;

PARALLEL tree[34..39] 

		SEND tree.fatherz(e) TO tree.son_lz(b);   
		SEND tree.fatherz(e) TO tree.son_rz(a);  
ENDPARALLEL;

END Pro_F; 

(*-------------------------------------------------------------------------
  PROCEDURE TO DO PROPAGATE ACROSS 1,2 & 3
  PROCEDURE across
---------------------------------------------------------------------------*)

PROCEDURE across;

BEGIN

PARALLEL tree[4] 
SEND tree.right(e) TO tree.right(c);
ENDPARALLEL;

PARALLEL tree[5] 
SEND tree.right(e) TO tree.right(c1);
ENDPARALLEL;

PARALLEL tree[6]
SEND tree.right(e) TO tree.right(c2);
ENDPARALLEL;

END across;

(*-----------------------------------------------------------------------
  PROCEDURE TO PERFORM PE OPERATION
  PROCEDURE PE (VECTOR a,b,c,d : REAL)
 ------------------------------------------------------------------------*)

 PROCEDURE PE (VECTOR a,b,c,d : REAL; VECTOR VAR e : REAL);
 
 BEGIN

 e := (a-b)*c + d;

 END PE;




(*--------------------------------------------------------------------------
  PROCEDURE TO PERFORM STEP1 OF FILLING OF PIPE
  PROCEDURE step1 
 --------------------------------------------------------------------------*)

 PROCEDURE step1;

 BEGIN

 allocate_pipe1 (samplept.x,samplept.y,samplept.z);
 
PARALLEL tree[1..3] 
PE(a,b,c,d,e);
ENDPARALLEL;

 END step1;  

(*--------------------------------------------------------------------------
  PROCEDURE TO PERFORM STEP3 OF FILLING UP OF PIPE
  PROCEDURE  step3
 ----------------------------------------------------------------------------*)

PROCEDURE step3;

BEGIN

allocate_pipe1 (samplept.x,samplept.y,samplept.z);

PARALLEL tree[1..6]
PE(a,b,c,d,e);
ENDPARALLEL;

END step3;

(*-----------------------------------------------------------------------------
  PROCEDURE TO PERFORM STEP5 OF FILLEING UP THE PIPE
  PROCEDURE step5
 ------------------------------------------------------------------------------*)

PROCEDURE step5;

BEGIN

 ArrayPE1(samplept.x,samplept.y,samplept.z); 
(* pipe 3*)
(*IF (10 <= id_no <= 13) OR (20 <= id_no <= 25) OR (27 <= id_no <= 32)
OR (34 <= id_no <= 39) THEN
*)
PARALLEL tree[10..13,20..25,27..32,34..39]
d := b;
ENDPARALLEL;

(* propagate across 1,2 & 3 *)
PARALLEL tree[4..6]
SEND tree.right(e) TO tree.right(c);
ENDPARALLEL;


(* pipe 1,2,3 *)
(*IF (1 <= id_no <= 6) OR (10 <= id_no <= 13) OR (20 <= id_no <= 25) OR 
(27 <= id_no <= 32) OR (34 <= id_no <= 39) THEN
*)
PARALLEL tree[1..6,10..13,20..25,27..32,34..39]
PE(a,b,c,d,e);
ENDPARALLEL;

END step5;

(*---------------------------------------------------------------------------------
  PROCEDURE TO PERFORM STEP 7 OF FILLING UP THE PIPE
  PROCEDURE step7
 -----------------------------------------------------------------------------------*)

 PROCEDURE step7;

 BEGIN

 ArrayPE1(samplept.x,samplept.y,samplept.z);
 (* propagate across1 *)

PARALLEL tree[4] 
SEND tree.right(e) TO tree.right(c);
 ENDPARALLEL;

 (* propagate across2 &3 *)

 
PARALLEL tree[5..6] 
SEND  tree.right(e) TO tree.right(c1);
  ENDPARALLEL;


 (* propagate father for pipe 3 *)
 (*IF (10 <= id_no <= 13) OR (20 <= id_no <= 25) OR
 (27 <= id_no <= 32) OR (34 <= id_no <= 39) THEN
*) 
(*PARALLEL [10..13,20..25,27..32,34..39] 
 Pro_F;
ENDPARALLEL;
*)

PARALLEL tree[10..13]
		SEND tree.father(e) TO tree.son_l(b);
		SEND tree.father(e) TO tree.son_r(a);
ENDPARALLEL;

PARALLEL tree[22..25]
		SEND tree.fatherx(e) TO tree.son_lx(b);
		SEND tree.fatherx(e) TO tree.son_rx(a);
ENDPARALLEL;

PARALLEL tree[29..32]
      SEND tree.fathery(e) TO tree.son_ly(b);
		SEND tree.fathery(e) TO tree.son_ry(a);
ENDPARALLEL;

PARALLEL tree[36..39]
		SEND tree.fatherz(e) TO tree.son_lz(b);
		SEND tree.fatherz(e) TO tree.son_rz(a);
ENDPARALLEL;

(* pipe 3 & 4 *)
(*IF (8 <= id_no <= 13) OR (20 <= id_no <= 25) OR (27 <= id_no <= 32)
OR (34 <= id_no <= 39) THEN
*)
PARALLEL tree[8..13,20..25,27..32,34..39]
d := b;
ENDPARALLEL;

 (* pipe 1,2,3,4 *) 
(*IF (1 <= id_no <= 6) OR (8 <= id_no <= 13) OR (20 <= id_no <= 25) 
Or (27 <= id_no <= 32) OR (34 <= id_no <= 39) THEN
*)
PARALLEL tree[1..6,8..13,20..25,27..32,34..39]
PE(a,b,c,d,e);
ENDPARALLEL;

(* pipe 4 *)
(*IF (8 <= id_no <= 9) OR (20 <= id_no <= 21) OR (27 <= id_no <= 28)
OR (34 <= id_no <= 35) THEN
*)
PARALLEL tree[8..9,20..21,27..28,34..35]
c := c1;
ENDPARALLEL;

END step7;

(*-----------------------------------------------------------------------------
 PROCEDURE TO PERFORM STEP 9 OF FILLING UP THE PIPE
 PROCEDURE step9
 ------------------------------------------------------------------------------*)

 PROCEDURE step9;

 BEGIN;

 ArrayPE1(samplept.x,samplept.y,samplept.z);

 across;
 Pro_F;
 
 (* pipe 3,4,5 *)
 
 (*IF (7 <= id_no <= 13) OR (19 <= id_no <= 39) THEN
 *)
 PARALLEL tree[7..13,19..39]
 d := b;
 ENDPARALLEL;
 (* pipe 1,2,3,4,5 *)
 (*IF (1 <= id_no <= 13) OR (19 <= id_no <= 39) THEN
 *)
 PARALLEL tree[1..13,19..39]
 PE(a,b,c,d,e);
 ENDPARALLEL;

 (* pipe 4,5 *)
 (*IF (7 <= id_no <= 9) OR (19 <= id_no <= 21) OR (26 <= id_no <= 28)
 OR (33 <= id_no <= 35) THEN
 *)
 PARALLEL tree[7..9,19..21,26..28,33..35]
 c := c1;
 ENDPARALLEL;

 (* pipe 5 *)
 (*IF (id_no = 7) OR (id_no = 19) OR (id_no = 26) OR (id_no = 33) THEN
 *) 
 PARALLEL tree[7,19,26,33] 
 c1 := c2;
 STORE(e,f);
 f1 := TRUNC(f[1]);
ENDPARALLEL;

 END step9;

(*------------------------------------------------------------------------------
 PROCEDURE TO PERFORM STEP 11 OF FILLING UP THE PIPE
 PROCEDURE step11  
 ------------------------------------------------------------------------------*)

 PROCEDURE step11;

 BEGIN

 ArrayPE1(samplept.x,samplept.y,samplept.z) ; 

 across;
 Pro_F;
 nArrayPE2(CR,CG,CB,OP);

 (* pipe 7, propagate.down *)
 PARALLEL tree[14] 
 SEND tree.right(e) TO tree.right(b);
 ENDPARALLEL;

 (* pipe 3,4,5 *)
 (*IF (7 <= id_no <= 14) OR (19 <= id_no <= 39) THEN
 *)
 PARALLEL tree[7..14,19..39]
 d := b;
 ENDPARALLEL;

 (* pipe 1,2,3,4,5,6,7 *)
 (*IF (1 <= id_no <= 15) OR (19 <= id_no <= 39) THEN
 *)
 PARALLEL tree[1..15,19..39] 
 PE(a,b,c,d,e);
 ENDPARALLEL;
 
 (* pipe 4,5 *)
 (*IF (7 <= id_no <= 9) OR (19 <= id_no <= 21) OR (26 <= id_no <= 28)
 OR (33 <= id_no <= 35) THEN
 *)
 PARALLEL tree[7..9,19..21,26..28,33..35] 
 c := c1;
 ENDPARALLEL;
 (* pipe 5 *)
 (*IF (id_no = 7) OR (id_no = 19) OR (id_no = 26) OR (id_no = 33) THEN
 *)
 PARALLEL tree[7,19,26,33] 
 c1 := c2;
 STORE(e,f);
 f1 := TRUNC(f[1]);
ENDPARALLEL;

 END step11;

(*-----------------------------------------------------------------------------------
 PROCEDURE TO PERFORM STEP 13 OF FILLING UP THE PIPE
 PROCEDURE step13
 -----------------------------------------------------------------------------------*)
 PROCEDURE step13;

 BEGIN

 ArrayPE1(samplept.x,samplept.y,samplept.z);

 across;
 Pro_F;
 ArrayPE2(CR,CG,CB,OP);

 (* pipe 7, propagate.down *)
 PARALLEL [14]
 SEND tree.right(e) TO tree.right(b);
 ENDPARALLEL;

 (* pipe 3,4,5 *)
 (*IF (7 <= id_no <= 14) OR (19 <= id_no <= 39) THEN
 *)
 PARALLEL [7..14,19..39]
 d := b;
 ENDPARALLEL;

 (* pipe 15, propagate.link *)
 PARALLEL [15]
(* IF e=0.0 THEN
    empty1 := TRUE;
 ELSE
 *)   SEND tree.right(e) TO tree.right(a);
 (*END; *)
 ENDPARALLEL;

 (* pipe 8 *)
 PARALLEL [16..18]
 d := e;
 ENDPARALLEL;

 (* PE all pipe *)
(* empty2 := empty1 AND empty;
 IF NOT((empty) OR (empty1)) THEN
    *)
    PARALLEL
    PE(a,b,c,d,e);
    ENDPARALLEL;
(* ELSIF empty2 THEN
       IF (1 <= id_no <= 13) OR (19 <= id_no <= 39) THEN
          PE(a,b,c,d,e);
       END;
       empty2 := FALSE;
 ELSIF empty THEN
       WriteString("empty");
       WriteLn;
       IF (1 <= id_no <= 13) OR (16 <= id_no <= 39) THEN
          PE(a,b,c,d,e);
       END;
       empty := FALSE;
 ELSIF empty1 THEN
       WriteString("empty1");
       WriteLn;
       IF (1 <= id_no <= 15) OR (19 <= id_no <= 39) THEN
          PE(a,b,c,d,e);
       END;
       empty1 := FALSE;

 END;
*)
 (* pipe 4,5,8 *)
 (*IF (7 <= id_no <= 9) OR (16 <= id_no <= 21) OR (26 <= id_no <= 28)
 OR (33 <= id_no <= 35) THEN
 *)
 PARALLEL [7..9,16..21,26..28,33..35]
 c := c1;
 ENDPARALLEL;

 (* pipe 5 *)
 (*IF (id_no = 7) OR (id_no = 19) OR (id_no = 26) OR (id_no = 33) THEN
 *)
 PARALLEL [7,19,26,33]
 C1 := c2;
 STORE(e,f);
 f1 := TRUNC(f[1]);
 ENDPARALLEL;

 END step13;



(*--------------------------------------------------------------------
 PROCEDURE TO PERFORM FILLING UP OF PIPE
 PROCEDURE Fill_Pipe  
 -------------------------------------------------------------------*)

 PROCEDURE Fill_Pipe;

 BEGIN

 LOOP

 IF index=0 THEN
 sample (pixel.x,pixel.y,pixel.z,lamda);
 step1;
 pipe2;
 lamda := lamda + step_size;
 index := index + 1; 
(*  WriteString("index");
	WriteInt(index,3);
	Write("a");
	WriteLn;
	WriteReal(a,3);
	Write("b");
	WriteLn;
	WriteReal(b,3);
	Write("c");
	WriteLn;
	WriteReal(c,3);
	Write("d");
	WriteLn;
	WriteReal(d,3);
	Write("e");
	WriteLn;
	WriteReal(e,3);
	WriteString("c1");
	WriteLn;
	WriteReal(c1,3);
	WriteString("c2");
	WriteLn;
	WriteReal(c2,3);
*)
 END;

 IF index=1 THEN
    IF lamda <= lamdamax THEN 
       sample (pixel.x,pixel.y,pixel.z,lamda);
       step3;
       pipe2;
       lamda := lamda + step_size;
       index := index + 1;
(*	    WriteString("index");
		 WriteInt(index,3);

		 Write("a");
		 WriteLn;
		 WriteReal(a,3);
		 Write("b");
		 WriteLn;
		 WriteReal(b,3);
		 Write("c");
		 WriteLn;
		 WriteReal(c,3);
		 Write("d");
		 WriteLn;
		 WriteReal(d,3);
		 Write("e");
		 WriteLn;
		 WriteReal(e,3);
		 WriteString("c1");
		 WriteLn;
		 WriteReal(c1,3);
		 WriteString("c2");
		 WriteLn;
		 WriteReal(c2,3);
*)
ELSE 
		 exit;
    END;
 END;

 IF index=2 THEN
    IF lamda <= lamdamax THEN 
 sample (pixel.x,pixel.y,pixel.z,lamda);
 step5;
 pipe2;
 lamda := lamda + step_size;
 index := index + 1;
(*	 WriteString("index");
	 WriteInt(index,3);

	 Write("a");
	 WriteLn;
	 WriteReal(a,3);
	 Write("b");
	 WriteLn;
	 WriteReal(b,3);
	 Write("c");
	 WriteLn;
	 WriteReal(c,3);
	 Write("d");
	 WriteLn;
	 WriteReal(d,3);
	 Write("e");
	 WriteLn;
	 WriteReal(e,3);
	 WriteString("c1");
	 WriteLn;
	 WriteReal(c1,3);
	 WriteString("c2");
	 WriteLn;
	 WriteReal(c2,3);
*)	 
ELSE
		 exit;
    END; 
 END;

 IF index=3 THEN
    IF lamda <= lamdamax THEN 
 sample (pixel.x,pixel.y,pixel.z,lamda);
 step7;
 pipe2;
 lamda := lamda + step_size;
 index := index + 1;
(*	 WriteString("index");
	 WriteInt(index,3);

	 Write("a");
	 WriteLn;
	 WriteReal(a,3);
	 Write("b");
	 WriteLn;
	 WriteReal(b,3);
	 Write("c");
	 WriteLn;
	 WriteReal(c,3);
	 Write("d");
	 WriteLn;
	 WriteReal(d,3);
	 Write("e");
	 WriteLn;
	 WriteReal(e,3);
	 WriteString("c1");
	 WriteLn;
	 WriteReal(c1,3);
	 WriteString("c2");
	 WriteLn;
	 WriteReal(c2,3);
*)
	 ELSE
		 exit;
    END; 
 END;

 IF index=4 THEN
    IF lamda <= lamdamax THEN 
 sample (pixel.x,pixel.y,pixel.z,lamda);
 step9;
 serial;
 lamda := lamda + step_size;
 index := index + 1;
  (*  WriteString("index");
	 WriteInt(index,3);

	 Write("a");
	 WriteLn;
	 WriteReal(a,3);
	 Write("b");
	 WriteLn;
	 WriteReal(b,3);
	 Write("c");
	 WriteLn;
	 WriteReal(c,3);
	 Write("d");
	 WriteLn;
	 WriteReal(d,3);
	 Write("e");
	 WriteLn;
	 WriteReal(e,3);
	 WriteString("c1");
	 WriteLn;
	 WriteReal(c1,3);
	 WriteString("c2");
	 WriteLn;
	 WriteReal(c2,3); *)
	 ELSE
		 exit;
    END;
 END;

 IF index=5 THEN
    IF lamda <= lamdamax THEN 
 sample (pixel.x,pixel.y,pixel.z,lamda);
 step11;
 serial;
 lamda := lamda + step_size;
 index := index + 1;
       IF (index - start1^.point = 5) THEN
		    PARALLEL tree[14] 
		   	 STORE(e,buffer1); 
		   (*	 WriteString("Aout");
				 WriteReal(e,3); *)  
				 e := 0.0;
          ENDPARALLEL;
        start1 := start1^.link; 
		(* ELSE 
			 PARALLEL  tree[14] 
				 IF e > 0.98 THEN
				 lamda := lamdamax + 1.0;
				 counter1 := 0;
				 END;
          ENDPARALLEL;
		 *)
		 END;
   


  (*  WriteString("index");
    WriteInt(index,3);

	 Write("a");
	 WriteLn;
	 WriteReal(a,3);
	 Write("b");
	 WriteLn;
	 WriteReal(b,3);
	 Write("c");
	 WriteLn;
	 WriteReal(c,3);
	 Write("d");
	 WriteLn;
	 WriteReal(d,3);
	 Write("e");
	 WriteLn;
	 WriteReal(e,3);
	 WriteString("c1");
	 WriteLn;
	 WriteReal(c1,3);
	 WriteString("c2");
	 WriteLn;
	 WriteReal(c2,3); *) 
	 exit; 
	 ELSE
		 exit;
    END;
 END;

END;


END Fill_Pipe;   

(*-------------------------------------------------------------------
 PROCEDURE TO PERFORM PIPELINING WHEN THE PIPE IS FULL
 PROCEDURE Full_Pipe
 --------------------------------------------------------------------*)

 PROCEDURE Full_Pipe;

 
 BEGIN 
	
 sample (pixel.x,pixel.y,pixel.z,lamda);
 step13;
 serial;
 lamda := lamda+ step_size;
 index := index + 1;

 buffer2 := buffer1;
 IF (index-start1^.point=5) THEN
	 PARALLEL tree[14]
		 STORE(e,buffer1); 
(*		 WriteString("Aout");
		 WriteLn;
		 WriteReal(e,3);
		 WriteLn;*) 
		 e := 0.0;
    ENDPARALLEL; 
  start1 := start1^.link; 
 ELSIF (index-start1^.point > 5) THEN   
	 IF counter1 = 4 THEN
		 PARALLEL tree[14] 
	      IF e > 0.98 THEN
	         lamda := lamdamax + 1.0;
	         counter1 := 0; 
			END;
	    ENDPARALLEL;
     ELSE
		 counter1 := counter1 + 1;
     END; 
 END;

 IF (index-start2^.point=6) THEN
	 PARALLEL tree[16..18] 
		 STORE(e,ColRes);
(*		 WriteString("Cout");
		 WriteLn;
		 WriteReal(e,3);
		 WriteLn;*) 
		 e := 0.0;
	 ENDPARALLEL;
    IF buffer2 < small THEN
		 buffer2 := small;
	 END;

	 start2^.PixColor.Red := ColRes[0](*/buffer2*); 
	 start2^.PixColor.Green := ColRes[1](*/buffer2*); 
    start2^.PixColor.Blue := ColRes[2]; 

    start2 := start2^.Link;
 END;

 (*WriteString("index");
 WriteInt(index,3);
 Write("a");
 WriteLn;
 WriteReal(a,3);
 Write("b");
 WriteLn;
 WriteReal(b,3);
 Write("c");
 WriteLn;
 WriteReal(c,3);
 Write("d");
 WriteLn;
 WriteReal(d,3);
 Write("e");
 WriteLn;
 WriteReal(e,3);
 WriteString("c1");
 WriteLn;
 WriteReal(c1,3);
 WriteString("c2");
 WriteLn;
 WriteReal(c2,3);

*)
 END Full_Pipe;



(*-----------------------------------------------------------------------
  PROCEDURE TO INITIALIZE THE FIRST POINTER TO THE LINKLIST OF IMAGE
  PROCEDURE InitializeList
 ---------------------------------------------------------------------*)

  PROCEDURE InitializeList;

  BEGIN
  PtrToFirst1 := NIL;
  PtrToLast1 := NIL; 

  PtrToFirst := NIL;
  PtrToLast  := NIL;

  END InitializeList;



(*--------------------------------------------------------------------
 The procedures below are for the clearing of pipe when the last 
 sample of the last ray of the image plane enter the first pipe
 --------------------------------------------------------------------*)

(*-------------------------------------------------------------------
 PROCEDURE WHERE PIPE 1 IS CLEARED
 PROCEDURE Clear1
 -------------------------------------------------------------------*)

 PROCEDURE Clear1;

 BEGIN

 ArrayPE3; 
 
 across;
 Pro_F;
 ArrayPE2(CR,CG,CB,OP);

 (* pipe 7, propagate.down *)
 PARALLEL tree[14] 
 SEND tree.right(e) TO tree.right(b);
 ENDPARALLEL;

 (* pipe 3,4,5,7(i) *)
 (*IF (7 <= id_no <= 14) OR (19 <= id_no <= 39) THEN
 *)
 PARALLEL tree[7..14,19..39] 
 d := b;
 ENDPARALLEL;

 (* pipe 7, propagate.link *)
 PARALLEL tree[15] 
 SEND tree.right(e) TO tree.right(a);
 ENDPARALLEL;

 (* pipe 8 *)
 PARALLEL tree[16..18]
 d := e;
 ENDPARALLEL;

 (* PE all excluding pipe 1 *)
 PARALLEL tree[4..39] 
 PE(a,b,c,d,e);
 ENDPARALLEL;


 (* pipe 4,5,8 *)
 (*IF (7 <= id_no <= 9) OR (16 <= id_no <= 21) OR (26 <= id_no <= 28)
 OR (33 <= id_no <= 35) THEN
 *)
 PARALLEL tree[7..9,16..21,26..28,33..35] 
 c := c1;
 ENDPARALLEL;

 (* pipe 5 *)
 (*IF (id_no = 7) OR (id_no = 19) OR (id_no = 26) OR (id_no = 33) THEN
 *)
 PARALLEL tree[7,19,26,33] 
 c1 := c2;
 STORE(e,f);
 f1 := TRUNC(f[1]); 
 ENDPARALLEL;

 END Clear1;

 (*-----------------------------------------------------------------------
  PROCEDURE WHERE PIPE 1 & 2 ARE CLEARED
  PROCEDURE Clear12
  -----------------------------------------------------------------------*)

  PROCEDURE Clear12;

  BEGIN


  ArrayPE3; 
  across;
  Pro_F;
  ArrayPE2(CR,CG,CB,OP);

  (* pipe 7, propagate.down *)
  PARALLEL tree[14] 
  SEND tree.right(e) TO tree.right(b);
  ENDPARALLEL;

  (* pipe 3,4,5,7(i) *)
  (*IF (7 <= id_no <= 14) OR (19 <= id_no <= 39) THEN
  *)
  PARALLEL tree[7..14,19..39] 
  d := b;
  ENDPARALLEL;

  (* pipe 7, propagate.link *)
  PARALLEL tree[15] 
  SEND tree.right(e) TO tree.right(a);
  ENDPARALLEL;

  (* pipe 8 *)
  PARALLEL tree[16..18] 
  d := e;
  ENDPARALLEL;

  (* PE all excluding pipe 1 & 2 *)
  PARALLEL tree[7..39] 
  PE(a,b,c,d,e);
  ENDPARALLEL;

  (* pipe 4,5,8 *)
  (*IF (7 <= id_no <= 9) OR (16 <= id_no <= 21) OR (26 <= id_no <= 28)
  OR (33 <= id_no <= 35) THEN
  *)
  PARALLEL tree[7..9,16..21,26..28,33..35] 
  c := c1;
  ENDPARALLEL;

  (* pipe 5 *)
  (*IF (id_no = 7) OR (id_no = 19) OR (id_no = 26) OR (id_no = 33) THEN
  *)
  PARALLEL tree[7,19,26,33] 
  c1 := c2;
  STORE(e,f);
  f1 := TRUNC(f[1]);
  ENDPARALLEL;

  END Clear12;

 (*---------------------------------------------------------------------
  PROCEDURE WHERE PIPE 1,2,& 3 ARE CLEARED
  PROCEDURE Clear123
  ----------------------------------------------------------------------*)

   PROCEDURE Clear123;

	BEGIN

	Pro_F;

	ArrayPE2  (CR,CG,CB,OP);
	(* pipe 7, propagate.down *)
	PARALLEL tree[14]
	SEND tree.right(e) TO tree.right(b);
	ENDPARALLEL;

	(* pipe 4,5,7(i) *)
	(*IF (7 <= id_no <= 9) OR (id_no = 14) OR (19 <= id_no <= 21) 
   OR (26 <= id_no <= 28) OR (33 <= id_no <= 35) THEN
	*)
   PARALLEL tree[7..9,14,19..21,26..28,33..35]	
	d := b;
	ENDPARALLEL;

	(* pipe 7, propagate.link *)
	PARALLEL tree[15] 
	SEND tree.right(e) TO tree.right(a);
	ENDPARALLEL;

	(* pipe 8 *)
	PARALLEL tree[16..18] 
	d := e;
	ENDPARALLEL;

	(* PE all excluding pipe 1, 2 & 3*)
	(*IF (7 <= id_no <= 9) OR (14 <= id_no <= 21) OR (26 <= id_no <= 28)
   OR (33 <= id_no <= 35) THEN	
	*)
   PARALLEL tree[7..9,14..21,26..28,33..35]	
	PE(a,b,c,d,e);
	ENDPARALLEL;

	(* pipe 5,8 *)
	(*IF ( id_no = 7) OR (16 <= id_no <= 19) OR (id_no = 26)
	OR (id_no = 33) THEN 
	*)
   PARALLEL tree[7,16..19,26,33]	
	c := c1;
	ENDPARALLEL;

	(* pipe 5 *)
	(*IF (id_no = 7)  OR (id_no = 19) OR (id_no = 26) OR (id_no = 33) THEN
	*)
   PARALLEL tree[7,19,26,33]	
	STORE(e,f);
   f1 := TRUNC(f[1]);

   ENDPARALLEL;

	END Clear123;  


(*----------------------------------------------------------------------------
   PROCEDURE TO CLEAR PIPE 1,2,3 & 4
   PROCEDURE Clear1234
 -----------------------------------------------------*)   

   PROCEDURE Clear1234;

   BEGIN

   (* pipe 4 *)
	(*IF (7 <= id_no <= 9) OR (19 <= id_no <= 21) OR (26 <= id_no <= 28)
	OR (33 <= id_no <= 35) THEN
   *)
   (*PARALLEL [7..9,19..21,26..28,33..35]	
	Pro_F;
   ENDPARALLEL;
*)
	PARALLEL tree[8..9]
			SEND tree.father(e) TO tree.son_l(b);
			SEND tree.father(e) TO tree.son_r(a);
   ENDPARALLEL;

   PARALLEL tree[20..21]
			SEND tree.fatherx(e) TO tree.son_lx(b);
			SEND tree.fatherx(e) TO tree.son_rx(a);
   ENDPARALLEL;

	PARALLEL tree[27..28]
			SEND tree.fathery(e) TO tree.son_ly(b);
			SEND tree.fathery(e) TO tree.son_ry(a);
   ENDPARALLEL;

	PARALLEL tree[34..35]
			SEND tree.fatherz(e) TO tree.son_lz(b);
			SEND tree.fatherz(e) TO tree.son_rz(a);
	ENDPARALLEL;

	ArrayPE2  (CR,CG,CB,OP);
	(* pipe 7, propagate.down *)
	PARALLEL tree[14]
	SEND tree.right(e) TO tree.right(b);
	ENDPARALLEL;

	(* pipe 5,7(i) *)
	(*IF (id_no = 7) OR (id_no = 14) OR  (id_no = 19) OR (id_no = 26) 
	OR (id_no = 33) THEN
	*)
   PARALLEL tree[7,14,19,26,33]	
	d := b;
	ENDPARALLEL;

	(* pipe 7, propagate.link *)
	PARALLEL tree[15]
	SEND tree.right(e) TO tree.right(a);
	ENDPARALLEL;

	(* pipe 8 *)
	PARALLEL tree[16..18]
	d := e;
	ENDPARALLEL;  

	(* PE all excluding pipe 1, 2, 3 & 4 *)  
	(*IF (id_no = 7) OR (14 <= id_no <= 19) OR (id_no = 26) OR (id_no = 33)
	THEN  
	*)
   PARALLEL tree[7,14..19,26,33]	
	PE(a,b,c,d,e);
	ENDPARALLEL;

	 (* pipe 8 *)
   PARALLEL tree[16..18]    
	c := c1;
	ENDPARALLEL;

	(* pipe5  *)  
  (*IF (id_no = 7) OR (id_no = 19) OR (id_no = 26) OR (id_no = 33) THEN
  *)
  PARALLEL tree[7,19,26,33] 
  STORE(e,f);
  f1 := TRUNC(f[1]);

  ENDPARALLEL;

  END Clear1234;


(*------------------------------------------------------------------------------
  PROCEDURE TO CLEAR PIPE 1,2,3,4 & 5
  PROCEDURE Clear12345
		----------------------------------------------------------*)  

  PROCEDURE Clear12345;

  BEGIN

  ArrayPE2  (CR,CG,CB,OP);
  (* pipe 7, propagate.down *)
  PARALLEL tree[14]
  SEND tree.right(e) TO tree.right(b);
  ENDPARALLEL;

 (* pipe 7(i) *)
  PARALLEL tree[14]
  d := b;
  ENDPARALLEL;

(*   pipe 7, propagate.link *)
  PARALLEL tree[15] 
  SEND tree.right(e) TO tree.right(a);
  ENDPARALLEL;

  (* pipe 8 *)
 PARALLEL tree[16..18]
d := e;
  ENDPARALLEL;

(* PE all excluding pipe 1, 2, 3, 4 & 5 *)
	PARALLEL tree[14..18] 
  PE(a,b,c,d,e);
 ENDPARALLEL;

(* pipe 8 *)
 PARALLEL tree[16..18] 
 c := c1;
ENDPARALLEL;

 END Clear12345;


 (*--------------------------------------------------------------------------
  PROCEDURE TO CLEAR PIPE 1,2,3,4,5,6 & 7
  ( NO MAP BEFORE THAT )
  PROCEDURE Clear1234567
 -------------------------------------------------------------*)  

	PROCEDURE Clear1234567;

	BEGIN

	(*   pipe 7, propagate.link *)
	PARALLEL tree[15] 
	SEND tree.right(e) TO tree.right(a);
	ENDPARALLEL;

	(* pipe 8 *)
	 PARALLEL tree[16..18] 
	 d := e;
	 (* PE 8 only *)
	 PE(a,b,c,d,e);
	 STORE(e,ColRes);
	 ENDPARALLEL;

	 END Clear1234567;


 (*------------------------------------------------------------
	Below are the procedures for setting up the environment
	-----------------------------------------------------------*)

 (*-----------------------------------------------------------
	PROCEDURE TO OBTAIN THE INRERSECTION OF RAYS WITH THE VOLUME
   PROCEDURE pBound (SCALAR pixel:aPoint) : SCALAR BOOLEAN;
-----------------------------------------------------------*)

   PROCEDURE pBound (SCALAR pixel:aPoint;SCALAR xlim,ylim,zlim:REAL) : SCALAR BOOLEAN;
	SCALAR trmin,trmax,tmp : REAL;
			 Vdir : aPoint;
BEGIN

  IF (pixel.x = xlim) AND (gVdir.x = 0.0) THEN
	  pixel.x := pixel.x - step_size/10.0;
  END;
  	IF (pixel.y = ylim)  AND (gVdir.y = 0.0) THEN
	   pixel.y := pixel.y - step_size/10.0;
	END;
   IF (pixel.z = zlim) AND (gVdir.z = 0.0) THEN
		pixel.z := pixel.z - step_size/10.0;
	END;
	
  IF ABS(gVdir.x) < small THEN
	  Vdir.x := small;
  ELSE
	  Vdir.x := gVdir.x;
  END;
  IF ABS(gVdir.y) < small THEN
     Vdir.y := small;
  ELSE
	  Vdir.y := gVdir.y;
  END;
  IF ABS(gVdir.z) < small THEN
 	  Vdir.z := small;
  ELSE
     Vdir.z := gVdir.z;
  END;
  lamdamin := -pixel.x/Vdir.x;
  lamdamax := (xlim - pixel.x)/Vdir.x;
  IF lamdamin > lamdamax THEN
     tmp := lamdamin; lamdamin := lamdamax; lamdamax := tmp;
  END;
  trmin := -pixel.y/Vdir.y;
  trmax := (ylim - pixel.y)/Vdir.y;
  IF trmin > trmax THEN
  	  tmp := trmin; trmin := trmax; trmax := tmp;
  END;
	 IF NOT((lamdamin > trmax) OR (lamdamax < trmin)) THEN
		 IF lamdamin < trmin THEN
          lamdamin := trmin;
		 END;
		 IF lamdamax > trmax THEN
          lamdamax := trmax;
		 END;
		 trmin := -pixel.z/Vdir.z;
       trmax := (zlim - pixel.z)/Vdir.z;
		 IF trmin > trmax THEN
			 tmp := trmin; trmin := trmax; trmax := tmp;
       END;
		 IF NOT ((lamdamin > trmax) OR (lamdamax < trmin)) THEN
			 IF (lamdamin < trmin) THEN
             lamdamin := trmin;
			 END;
		    IF (lamdamax > trmax) THEN
             lamdamax := trmax;
		    END;
		    RETURN (TRUE);
       ELSE
			 WriteString("no1"); 
			 RETURN (FALSE);
		 END;
    ELSE
       WriteString("no2"); 
		 RETURN (FALSE);
	 END;
END pBound;





BEGIN



(*PARALLEL tree  
*)
xres := 126;
yres := 113;
zres := 88;
fread;
map;
setEnv;
setProj;
voxelget(xsize1,ysize1,zsize1);
(*read(max);
*)
index := 0;	
counter := 0;
counter1 := 4 ;
N1[0] := 0 ;
N1[1] := 0;
N1[2] := 0;
N2[0] := 0;
N2[1] := 0;
N2[2] := 0;
N3[0] := 0;
N3[1] := 0;
N3[2] := 0;
N4[0] := 0;
N4[1] := 0;
N4[2] := 0;
N5[0] := 0;
N5[1] := 0;
N5[2] := 0;
PARALLEL tree
e := 0.0;
a := 0.0;
b := 0.0;
c := 0.0;
d := 0.0;
c1 := 0.0;
c2 := 0.0;
ENDPARALLEL;
(*empty := FALSE;
empty1 := FALSE;
empty2 := FALSE; *)
(*xres := 11;
yres := 11;
zres := 11; *)  
buffer1 := 0.0;
buffer2 := 0.0;
step_size := 1.0;
gCell_Size := 1.5 ;
(*CSize.x := gCell_Size;
CSize.y := gCell_Size;
CSize.z := gCell_Size (* InterSlice_factor *);
*)
xlim := FLOAT(xres - 1) (* CSize.x;*) * scale[0];
ylim := FLOAT(yres - 1) (* CSize.y; *) * scale[1];
zlim := FLOAT(zres - 1) (* CSize.z; *) * scale[2];
WriteReal(xlim,3);
WriteLn;
WriteReal(ylim,3);
WriteLn;  
WriteReal(zlim,3);
WriteLn;
WriteString("direction");
WriteReal(gVdir.x,3);
WriteReal(gVdir.y,3);
WriteReal(gVdir.z,3);
lamdamin := 0.0;
(*lamdamax := gCell_size * 10.0;  
*)
x0 := 16.0;
y0 := 10.0;
z0 := 16.0;
pixel.x := x0;
pixel.y := y0;
pixel.z := z0 ;
lamda := lamdamin + 2.0;
Constant (gCell_Size);
InitializeList;
FOR kk := 0 TO xsize-1  DO   
    FOR jj := 0 TO ysize-1 DO 
(*calculate x0,y0,z0,lamdamin,lamdamax*)
(*x0 := FLOAT(jj);
z0 := FLOAT(kk);
y0 := 0.0;
*)
oldpt[0] := FLOAT(kk);
oldpt[1] := FLOAT(jj);
oldpt[2] := 0.0;
maTrans(transM,oldpt,newpt);
WriteString("x-");
WriteReal(newpt[0],3);
WriteString("y-");
WriteReal(newpt[1],3);
WriteString("z-");
WriteReal(newpt[2],3);
WriteLn;
pixel.x := newpt[0];
pixel.y := newpt[1];
pixel.z := newpt[2];
bound := pBound(pixel,xlim,ylim,zlim);
IF bound THEN
NEW(ptr);
ptr^.xcoor := oldpt[0];
ptr^.ycoor := oldpt[1];
ptr^.point := -1;
ptr^.link  := NIL;
IF PtrToFirst = NIL THEN
	PtrToFirst := ptr;
	start1 := ptr;
   start2 := ptr;
ELSE
	PtrToLast^.link := ptr;
END;
PtrToLast := ptr;
(* maTransform *)
WriteReal(oldpt[0],3);
WriteReal(oldpt[1],3);
WriteLn;
lamda := lamdamin;
IF 0 <= index <= 5 THEN
Fill_Pipe;
END;

WHILE (index > 5) & (lamda <= lamdamax) DO
Full_Pipe;
counter := counter + 1;
END;
WriteInt(counter,3);
counter := 0;
ptr^.point := index;

(*x0 := x0 + 1.0;
y0 := y0 + 1.0;
z0 := 0.0;
*)

ELSE
  NEW(ptr1);
  ptr1^.xcoor := oldpt[0];
  ptr1^.ycoor := oldpt[1];
  ptr1^.point := -1;
  ptr1^.link  := NIL;
  IF PtrToFirst1 = NIL THEN
	  PtrToFirst1 := ptr1;
  ELSE
	  PtrToLast1^.link := ptr1;
  END;
  PtrToLast1 := ptr1;

  WriteString("yes");  
  ptr1^.PixColor.Red := 0.0;
  ptr1^.PixColor.Green := 0.0;
  ptr1^.PixColor.Blue := 0.0;
END;

END; 
END; 
(*sample (x0,y0,z0,lamda);
step1;
pipe2;
index := index + 1;
lamda := lamda + step_size;
sample (x0,y0,z0,lamda);
step3;
pipe2;
lamda := lamda + step_size;
sample (x0,y0,z0,lamda);
step5;
Pipe2;
lamda := lamda + step_size;
sample (x0,y0,z0,lamda);

step7;
pipe2;
lamda := lamda + step_size;
sample (x0,y0,z0,lamda);
step9;
serial;
lamda := lamda + step_size;
sample (x0,y0,z0,lamda);
step11;
serial;  
lamda := lamda+ step_size;
sample (x0,y0,z0,lamda);
step13;
serial;
lamda := lamda+ step_size;
sample (x0,y0,z0,lamda);
step13;
serial;   
lamda := lamda+ step_size;
WHILE (lamda <= lamdamax) DO   
sample (x0,y0,z0,lamda);
step13;
serial;
lamda := lamda+ step_size;
END;*)   
(* call clearing pipe *)
Clear1;
colorOp(f1);
index := index + 1;

buffer2 := buffer1;
IF (index-start1^.point=5) THEN
	PARALLEL tree[14] 
		STORE(e,buffer1);
	(*	WriteString("Aout");
		WriteLn;
		WriteReal(e,3);
		WriteLn; *) 
		e := 0.0;
	ENDPARALLEL;
	start1 := start1^.link;  
END;

IF  (index-start2^.point=6) THEN  
	 PARALLEL tree[16..18]   
	    STORE(e,ColRes);
	(*	 WriteString("Cout");
		 WriteLn;
		 WriteReal(e,3);
		 WriteLn;
*)	
e := 0.0;
    ENDPARALLEL;
    IF buffer2 < small THEN
   	 buffer2 := small;
	 END;


	 start2^.PixColor.Red := ColRes[0](*/buffer2*);

	 start2^.PixColor.Green := ColRes[1](*/buffer2*);

	 start2^.PixColor.Blue := ColRes[2](*/buffer2*);

	 start2 :=  start2^.Link; 
END;

(*WriteString("index");
WriteInt(index,3);
Write("a");
WriteLn;
WriteReal(a,3);
Write("b");
WriteLn;
WriteReal(b,3);
Write("c");
WriteLn;
WriteReal(c,3);
Write("d");
WriteLn;
WriteReal(d,3);
Write("e");
WriteLn;
WriteReal(e,3);
WriteString("c1");
WriteLn;
WriteReal(c1,3);
WriteString("c2");
WriteLn;
WriteReal(c2,3);
*)
Clear12;
ColorOp(f1);  
index := index + 1;

buffer2 := buffer1;
IF (index-start1^.point=5) THEN
	PARALLEL tree[14] 
		STORE(e,buffer1);
(*		WriteString("Aout");
		WriteLn;
		WriteReal(e,3);
		WriteLn;
*)
e := 0.0;
	ENDPARALLEL;
	start1 := start1^.link;
END;

	IF  (index-start2^.point=6) THEN
		 PARALLEL tree[16..18]   
			 STORE(e,ColRes);
(*			 WriteString("Cout");
			 WriteLn;
		 	 WriteReal(e,3);
		    WriteLn;
*)		
e := 0.0;		
		 ENDPARALLEL;
       IF buffer2 < small THEN
			buffer2 := small;
		 END;


	    start2^.PixColor.Red := ColRes[0](*/buffer2*);
    start2^.PixColor.Green := ColRes[1](*/buffer2*);
      start2^.PixColor.Blue := ColRes[2](*/buffer2*);
	    start2 := start2^.link;               
   END;
(* WriteString("index");
 WriteInt(index,3);
Write("a");
WriteLn;
WriteReal(a,3);
Write("b");
WriteLn;
WriteReal(b,3);
Write("c");
WriteLn;
WriteReal(c,3);
Write("d");
WriteLn;
WriteReal(d,3);
Write("e");
WriteLn;
WriteReal(e,3);
WriteString("c1");
WriteLn;
WriteReal(c1,3);
WriteString("c2");
WriteLn;
WriteReal(c2,3);

*)
Clear123;
ColorOp(f1);
index := index + 1;
buffer2 := buffer1;
IF (index-start1^.point=5) THEN
	PARALLEL tree[14] 
      STORE(e,buffer1);
(*		WriteString("Aout");
		WriteLn;
	   WriteReal(e,3);
	   WriteLn;
*)	
e := 0.0;
	 ENDPARALLEL;
    start1 := start1^.link;
	 END;

IF (index-start2^.point=6) THEN
   PARALLEL tree[16..18] 
		STORE(e,ColRes);
(*		WriteString("Cout");
		WriteLn;
		WriteReal(e,3);
		WriteLn;
*)	
e := 0.0;
	ENDPARALLEL;
   IF buffer2 < small THEN
	  buffer2 := small;
	END;

	start2^.PixColor.Red := ColRes[0](*/buffer2*);
	start2^.PixColor.Green := ColRes[1](*/buffer2*);
	start2^.PixColor.Blue := ColRes[2](*/buffer2*);
	start2 := start2^.Link;
END;

(*WriteString("index");
WriteInt(index,3);
Write("a");
WriteLn;
WriteReal(a,3);
Write("b");
WriteLn;
WriteReal(b,3);
Write("c");
WriteLn;
WriteReal(c,3);
Write("d");
WriteLn;
WriteReal(d,3);
Write("e");
WriteLn;
WriteReal(e,3);
WriteString("c1");
WriteLn;
WriteReal(c1,3);
WriteString("c2");
WriteLn;
WriteReal(c2,3);
*)

Clear1234;
ColorOp(f1);
index := index + 1;
buffer2 := buffer1;
IF (index-start1^.point=5) THEN
	PARALLEL tree[14] 
	   STORE(e,buffer1);
 (*     WriteString("Aout");
		WriteLn;
		WriteReal(e,3);
		WriteLn;
*)	
e := 0.0;
    ENDPARALLEL;
	 start1 := start1^.link;
END;
 IF (index-start2^.point=6) THEN
	 PARALLEL tree[16..18] 
	    STORE(e,ColRes);
(*		 WriteString("Cout");
       WriteLn;
		 WriteReal(e,3);
		 WriteLn;
*)	
e := 0.0;
	 ENDPARALLEL;
    IF buffer2 < small THEN
	  buffer2 := small;
	END;

	 start2^.PixColor.Red := ColRes[0](*/buffer2*);
	 start2^.PixColor.Green := ColRes[1](*/buffer2*);
	 start2^.PixColor.Blue := ColRes[2](*/buffer2*);
	 start2 := start2^.Link;
END;

(*WriteString("index");
WriteInt(index,3);
Write("a");
WriteLn;
WriteReal(a,3);
Write("b");
WriteLn;
WriteReal(b,3);
Write("c");
WriteLn;
WriteReal(c,3);
Write("d");
WriteLn;
WriteReal(d,3);
Write("e");
WriteLn;
WriteReal(e,3);
WriteString("c1");
WriteLn;
WriteReal(c1,3);
WriteString("c2");
WriteLn;
WriteReal(c2,3);
*)



Clear12345;
index := index + 1;
buffer2 := buffer1;
IF (index-start1^.point=5) THEN
  PARALLEL tree[14] 
	  STORE(e,buffer1);
(*	  WriteString("Aout");
     WriteLn;
	  WriteReal(e,3);
	  WriteLn;
*)	
e := 0.0;
   ENDPARALLEL;
    start1 := start1^.link;
END;
IF (index-start2^.point=6) THEN
	PARALLEL tree[16..18] 
		STORE(e,ColRes);
   (*  WriteString("Cout");
		WriteLn;
		WriteReal(e,3);
		WriteLn;
   *) 
	e := 0.0;
   ENDPARALLEL;
   IF buffer2 < small THEN
	  buffer2 := small;
	END;

	start2^.PixColor.Red := ColRes[0](*/buffer2*);
	start2^.PixColor.Green := ColRes[1](*/buffer2*);
   start2^.PixColor.Blue := ColRes[2](*/buffer2*);
	start2 := start2^.Link;
END;

(*WriteString("index");
WriteInt(index,3);
Write("a"); 
WriteLn;
WriteReal(a,3);
Write("b");
WriteLn;
WriteReal(b,3);
Write("c");
WriteLn;
WriteReal(c,3);
Write("d");
WriteLn;
WriteReal(d,3);
Write("e");
WriteLn;
WriteReal(e,3);
WriteString("c1");
WriteLn;
WriteReal(c1,3);
WriteString("c2");
WriteLn;
WriteReal(c2,3);

*)


Clear1234567;
index := index + 1;
buffer2 := buffer1;
PARALLEL tree[16..18]
	STORE(e,ColRes);
(*	WriteString("Cout");
	WriteLn;
   WriteReal(e,3);
	WriteLn;
 *) 
 e := 0.0;
ENDPARALLEL;
IF buffer2 < small THEN
  buffer2 := small;
END;

start2^.PixColor.Red := ColRes[0](*/buffer2*);
start2^.PixColor.Green := ColRes[1](*/buffer2*);
start2^.PixColor.Blue := ColRes[2](*/buffer2*);
start2 := start2^.Link;


(*ArrayPE2 (CR,CG,CB,OP);*) 
(*Pro_F;  
across;   
step1; *)  
(*Write("a");  
WriteLn;
WriteReal(a,3); 
Write("b");  
WriteLn;
WriteReal(b,3);  
Write("c");
WriteLn;
WriteReal(c,3);
Write("d");
WriteLn;
WriteReal(d,3);  
Write("e");
WriteLn;
WriteReal(e,3);   
WriteString("c1");
WriteLn;
WriteReal(c1,3);
WriteString("c2");
WriteLn;
WriteReal(c2,3);

*)

(* print out the color stored *)
(*index := 0;
ptr := PtrToFirst;
REPEAT
WriteString("RED");
WriteReal(ptr^.PixColor.red,3);
WriteLn;
WriteString("GREEN");
WriteReal(ptr^.PixColor.Green,3);
WriteLn;
WriteString("BLUE");
WriteReal(ptr^.PixColor.Blue,3);
WriteLn;
WriteString("index"); 
WriteInt(index,3);
index := index + 1;
ptr := ptr^.link;
UNTIL ptr = NIL;
*)
OpenOutput('Molecule');
ptr := PtrToFirst; 
(*handle := OpenWindow ( 0.5,0.5);
IF done THEN
SelectWindow (handle); *)
REPEAT
WriteReal(ptr^.xcoor,3);
Write(" ");
WriteReal(ptr^.ycoor,3);
Write(" ");
IF ptr^.PixColor.red = 0.0 THEN
	ptr^.PixColor.red := small;
END;
col.red := TRUNC (  ptr^.PixColor.red*256.0 );  
WriteInt(col.red,3);
Write(" ");
IF ptr^.PixColor.green = 0.0 THEN
	ptr^.PixColor.green := small;
END;
col.green := TRUNC (ptr^.PixColor.Green*256.0  );
WriteInt(col.green,3);
Write(" ");
IF ptr^.PixColor.blue = 0.0 THEN
	ptr^.PixColor.blue := small;
END;
col.blue := TRUNC ( ptr^.PixColor.Blue*256.0 );
WriteInt(col.blue,3);
Write(" ");
WriteLn;	
(*SetColor (col);
SetPixel (TRUNC(ptr^.xcoor) ,TRUNC( ptr^.ycoor)); *) 
ptr := ptr^.link;
UNTIL ptr = NIL;

ptr := PtrToFirst1;
REPEAT
WriteReal(ptr^.xcoor,3);
Write(" ");
WriteReal(ptr^.ycoor,3);
Write(" ");
IF ptr^.PixColor.red = 0.0 THEN
	ptr^.PixColor.red := small;
END;
col.red := TRUNC ((1.0 / ptr^.PixColor.red)*30.0 );
WriteInt(col.red,3);
Write(" ");
IF ptr^.PixColor.green = 0.0 THEN
	ptr^.PixColor.green := small;
END;
col.green := TRUNC ((1.0/ptr^.PixColor.Green)*30.0  );
WriteInt(col.green,3);
Write(" ");
IF ptr^.PixColor.blue = 0.0 THEN
ptr^.PixColor.blue := small;
END;
col.blue := TRUNC ((1.0 / ptr^.PixColor.Blue)*30.0 );
WriteInt(col.blue,3);
Write(" ");
WriteLn;
(*SetColor (col);
SetPixel (TRUNC(ptr^.xcoor) ,TRUNC( ptr^.ycoor)); *)
ptr := ptr^.link;
UNTIL ptr = NIL;

(*END;*) 
CloseOutput; 
(*ENDPARALLEL;
*)
END main.


