SYSTEM beuys;
CONST maxnode = 100;
      length  = maxnode * 3;
      part    = length div 2;

TYPE  field   = ARRAY [0..8] OF INTEGER;

SCALAR   ch : CHAR;
       	 win : CARDINAL;
      	 xa,ya : field;

CONFIGURATION line [maxnode];
CONNECTION    left  : line[i]  -> line[i-1].right;

VECTOR   x1,x2,x3,x4,y1,y2,y3,y4 : INTEGER;

PROCEDURE VLine(VECTOR x0, y0, x1, y1 : integer);
VECTOR dx, dy,
       von, bis, dlauf, dabh, startabh, plauf, pabh,
       i, m, t, kl : INTEGER;
       koord : ARRAY [0..1] OF INTEGER;

   PROCEDURE VSIGN(VECTOR i : integer) : VECTOR integer;
   VECTOR erg : integer;
   BEGIN
         IF i = 0 THEN erg := 0 ELSE erg := i div ABS(i) END;
         RETURN (erg);
   END VSIGN;

BEGIN
   dx := x1 - x0;
   dy := y1 - y0;
   IF ABS(dx) < ABS(dy) THEN
      von := y0; bis := y1; dlauf := dy; dabh := dx; startabh := x0;
      plauf := 1; pabh := 0;
   ELSE
      von := x0; bis := x1; dlauf := dx; dabh := dy; startabh := y0;
      plauf := 0; pabh := 1;
   END;
   IF dlauf < 0 THEN
      inc(startabh,dabh); dabh := -dabh;
      dec(bis,dlauf); inc(von,dlauf); dlauf := -dlauf;
   END;
   koord[pabh] := startabh; i := VSIGN(dabh); dabh := ABS(dabh);
   m := 0; t := dlauf div 2;

   FOR kl := von TO bis DO
      koord[plauf] := kl;
      SetPixel(koord[0],koord[1]);
      inc(m,dabh);
      IF m > t THEN inc(t,dlauf); inc(koord[pabh],i); END;
   END;

END VLine;

PROCEDURE plot(VECTOR x, y : integer; SCALAR c: COLOR);
VECTOR xnext, ynext : INTEGER;
BEGIN
   Setcolor(c);
   PROPAGATE.left(x,xnext);
   PROPAGATE.left(y,ynext);
   IF DIM1 # REDUCE.max(DIM1) THEN
      VLine(x, y, xnext, ynext);
   END;
END plot;

BEGIN (* main *)
   win := OpenAbsWindow(length,length);

   PARALLEL
      IF EVEN(DIM1) THEN
      	 x1 := VIRandom() MOD part;
      	 y1 := VIRandom() MOD part;
      	 x2 := VIRandom() MOD part;
      	 y2 := length - VIRandom() MOD part;
      	 x3 := VIRandom() MOD part;
      	 y3 := part div 2 + VIRandom() MOD part;
      	 x4 := part div 2 + VIRandom() MOD part;
      	 y4 := VIRandom() MOD part;
      ELSE
      	 x1 := length - VIRandom() MOD part;
      	 y1 := length - VIRandom() MOD part;
      	 x2 := length - VIRandom() MOD part;
      	 y2 := VIRandom() MOD part;
      	 x3 := length - VIRandom() MOD part;
      	 y3 := part div 2 + VIRandom() MOD part;
      	 x4 := part div 2 + VIRandom() MOD part;
      	 y4 := length - VIRandom() MOD part;
      END;
      plot(x1, y1, COLOR(0,0,0));
      plot(x2, y2, COLOR(200,200,200));
      plot(x3, y3, COLOR(120,120,120));
      plot(x4, y4, COLOR(170,170,170));
   ENDPARALLEL;
   WriteString("Press RETURN for termination"); WriteLn;
   Read(ch);
   CloseWindow(win);
END beuys.
