SYSTEM line_bench;
CONST qlen    = 10;
      length  = qlen * qlen * 3;
      part    = length div 2;

SCALAR   ch : CHAR;
       	 win : CARDINAL;
      	 col : integer;

CONFIGURATION grid [qlen],[qlen];

VECTOR   x0, y0, x1, y1 : INTEGER;

PROCEDURE VLine(VECTOR x0, y0, x1, y1 : integer);
VECTOR dx, dy,
       px, py, sw,
       i, m, t, kl : INTEGER;
       koord : ARRAY [0..1] OF INTEGER;

   PROCEDURE VSIGN(VECTOR i : integer) : VECTOR integer;
   VECTOR erg : integer;
   BEGIN
         IF i = 0 THEN erg := 0 ELSE erg := i div ABS(i) END;
         RETURN (erg);
   END VSIGN;

   PROCEDURE VSwap(VECTOR VAR a, b : INTEGER);
   VECTOR sw : INTEGER;
   BEGIN
      sw := a; a := b; b := sw;
   END VSwap;

BEGIN
   dx := x1 - x0;
   dy := y1 - y0;
   IF ABS(dx) < ABS(dy) THEN
      VSwap(x0,y0);
      x1 := y1;
      VSwap(dx,dy);
      px := 1; py := 0;
   ELSE
      px := 0; py := 1;
   END;
   IF dx < 0 THEN
      inc(y0,dy); dy := -dy;
      VSwap(x0, x1); dx := -dx;
   END;
   koord[1] := y0; i := VSIGN(dy); dy := ABS(dy);
   m := 0; t := dx div 2;

   FOR kl := x0 TO x1 DO
      koord[0] := kl;
      SetPixel(koord[px],koord[py]);
      inc(m,dy);
      IF m > t THEN inc(t,dx); inc(koord[1],i); END;
   END;

END VLine;

BEGIN (* main *)
   win := OpenAbsWindow(length,length);

   PARALLEL grid
      x0 := DIM1 * qlen;
      y0 := DIM2 * qlen;
      x1 := length - x0;
      y1 := length - y0;
      FOR col := 200 TO 0 BY -50 DO
      	 SETCOLOR(COLOR(col,col,col));
      	 VLine(x0, y0, x1, y1);
      	 y0 := length - y0; y1 := length - y1
      END;
   ENDPARALLEL;

   WriteString("Press RETURN for termination"); WriteLn;
   Read(ch);
   CloseWindow(win);
END line_bench.
