package sim;

import java.awt.*;

public abstract class ModulePanel extends Panel
{
	public ModulePanel()
	{
		super();
		
		this.setLayout(new FlowLayout(FlowLayout.LEFT, 0, 0));
		this.setBackground(MainWindow.BACKGROUND);
	}
	
	protected void add(ModuleButton mb)
	{
		mb.setListener(WestPanel.MODE_CONTROL);
		super.add(mb);
	}
	
	protected void initializeListeners(ModuleButton mb)
	{
		mb.setListener(WestPanel.MODE_CONTROL);
	}
	
	public void addNotify()
	{
		super.addNotify();
		this.initialize();
	}
	
	public void setEnabled(boolean b)
	{
		for(int i = 0; i < this.getComponentCount(); i++)
			((ModuleButton)this.getComponent(i)).setEnabled(b);
	}
	
	protected abstract void initialize();
}