package sim.lib.functions;

import java.awt.*;

import sim.*;
import sim.engine.*;

import sim.lib.wires.Junction;

public class Equal extends Function2in1thinOut
{
/* ==================================================================
	Creation Part
	================================================================= */
	private static Image ICON = GuiFileLink.getImage("sim/lib/functions/EqualUnitIcon.gif");
	
	public Image getIcon()
	{
		return Equal.ICON;
	}
	
	public String getBubbleHelp()
	{
		return "Equal unit";
	}
	
/* ==================================================================
	GUI part
	================================================================= */
	public Equal()
	{
		super();
	}
	
	protected Wrapper getCopy()
	{
		Equal result = new Equal();
		result.changeDelay(this.delay);
		result.setBusSize(this.busSize);
		return result;
	}
	
	public void paint(Graphics g)
	{
		// draw if visible
		if(this.isVisible())
		{
			int gridGap = CentralPanel.ACTIVE_GRID.getCurrentGridGap();
			int increment = gridGap / 4;
			int tripple = 3 * gridGap;
			
			g.setColor(this.brush);
			
			g.drawLine(gridGap + increment, gridGap, 10 * increment, gridGap);
			g.drawLine(14 * increment, gridGap, 19 * increment, gridGap);
			
			g.drawLine(10 * increment, gridGap, tripple, 6 * increment);
			g.drawLine(14 * increment, gridGap, tripple, 6 * increment);
			
			g.drawLine(gridGap + increment, tripple, 19 * increment, tripple);
			
			g.drawLine(gridGap + increment, gridGap, gridGap + increment, tripple);
			g.drawLine(19 * increment, gridGap, 19 * increment, tripple);
			
			g.fillRect(2 * gridGap - 1, 0, 3, gridGap);
			g.fillRect(4 * gridGap - 1, 0, 3, gridGap);
			g.drawLine(tripple, tripple, tripple, tripple + gridGap);
			
			g.setFont(new Font(Wrapper.FONT_NAME, Font.PLAIN, 3 * increment));
			
			FontMetrics fm = g.getFontMetrics(g.getFont());
			g.drawString("=", tripple - fm.stringWidth("=") / 2, 10 * increment);
		}
	}
	
/* ==================================================================
	Simulation part
	================================================================= */
	public void evaluateOutput(double currentTime, Data[] currentInputs, EnginePeer peer)
	{
		double time = this.delay + currentTime;
		
		boolean foundUndefined = false;
		boolean equal = true;
		
		for(int loop = 0; (loop < this.busSize) && (!foundUndefined) && equal; loop++)
		{
			if(currentInputs[loop].isUndefined() || currentInputs[loop + this.busSize].isUndefined())
				foundUndefined = true;
			else
				equal = !(currentInputs[loop].getValue() ^ currentInputs[loop + this.busSize].getValue());
		}
		
		if(foundUndefined)
			peer.setOutputPinUndefined(0, time);
		else
			peer.setOutputPinValue(0, equal, time);
	}
}