package sim.util;

import java.awt.*;

public class StatusBox extends Label
{
	private boolean highlight;
	private String description;
	private String comment;
	
	public StatusBox(String title, String value, boolean etched)
	{
		super();
		
		this.description = title;
		this.comment = value;
		this.highlight = etched;
		
		this.setAlignment(Label.LEFT);
		
		if(this.comment != null)
			this.setText(" " + this.description + " : " + this.comment);
		else
			this.setText(" " + this.description);
	}
	
	public void setComment(String value, boolean paint)
	{
		this.comment = value;
		this.setText(" " + this.description + " : " + this.comment);
		
		if(paint)
			this.update(this.getGraphics());
	}
	
	public void setComment(String value)
	{
		this.setComment(value, true);
	}
	
	public void setTitle(String title, boolean paint)
	{
		this.description = title;
		this.comment = null;
		this.setText(" " + this.description);
		
		if(paint)
			this.update(this.getGraphics());
	}
	
	public void setTitle(String title)
	{
		this.setTitle(title, true);
	}
	
	public void setParameters(String title, String value, boolean paint)
	{
		this.description = title;
		this.comment = value;
		this.setText(" " + this.description + " : " + this.comment);
		
		if(paint)
			this.update(this.getGraphics());
	}
	
	public void setParameters(String title, String value)
	{
		this.setParameters(title, value, true);
	}
	
	public void resetComment()
	{
		this.comment = null;

		this.setText(" " + this.description);
		
		this.update(this.getGraphics());
	}
	
	public void update(Graphics g)
	{
		this.paint(g);
	}
	
	public void paint(Graphics g)
	{
		super.paint(g);
		
		if(this.highlight)
		{
			g.setColor(this.getBackground().darker());
			g.drawLine(0, 0, 0, this.getSize().height);
			g.drawLine(0, 0, this.getSize().width, 0);
			
			g.setColor(Color.white);
			g.drawLine(this.getSize().width - 1, this.getSize().height - 1, 0, this.getSize().height - 1);
			g.drawLine(this.getSize().width - 1, this.getSize().height - 1, this.getSize().width - 1, 0);
		}
	}
}