package sim;

import java.awt.*;

import gjt.Separator;
import gjt.Etching;

import sim.util.StatusBox;

public class CentralPanel extends Panel
{
	public static Grid ACTIVE_GRID;
	public static WrapperMenu WRAPPER_POPUP;
	
	private ScrollCanvas active;
	
	public CentralPanel()
	{
		super(new BorderLayout());
		
		CentralPanel.WRAPPER_POPUP = new WrapperMenu();
		
		this.setBackground(MainWindow.BACKGROUND);
		
		this.createGrid("Untitled.toy");
		this.add(CentralPanel.WRAPPER_POPUP);
	}
	
	public void createGrid(String fileName)
	{
		if(this.active != null)
		{
			WestPanel.MODE_CONTROL.removeListeners();
			this.remove(this.active);
		}
		
		this.active = new ScrollCanvas(fileName);
		this.add(BorderLayout.CENTER, this.active);
		
		this.validateTree();
		WestPanel.MODE_CONTROL.initialiseListeners();
		MainWindow.MAIN_WINDOW.setTitle(MainWindow.PROGRAM_NAME + " - " + fileName);
		
		System.gc();
	}
}