package sim.engine;

import java.util.Vector;

public class EnginePeerList extends Vector
{
	public EnginePeerList(int size)
	{
		super(size);
		
		this.setSize(size);
	}
	
	public EnginePeerList()
	{
		super();
	}
		
	public int getSize()
	{
		return super.size();
	}
	
	public EnginePeer getItemAt(int index)
	{		
		return (EnginePeer)super.elementAt(index);
	}
	
	public void removeItemAt(int index)
	{
		super.removeElementAt(index);
	}
	
	public void removeItem(EnginePeer oldValue)
	{
		super.removeElement(oldValue);
	}
	
	public void removeAll()
	{
		super.removeAllElements();
	}
	
	public void changeItem(int index, EnginePeer newValue)
	{
		super.setElementAt(newValue, index);
	}
	
	public void resetItem(int index)
	{
		super.setElementAt(null, index);
	}
	
	public void insertItem(EnginePeer newValue)
	{
		super.addElement(newValue);
	}
	
	public void insertItemAt(int index, EnginePeer newValue)
	{
		super.insertElementAt(newValue, index);
	}
	
	public boolean contains(EnginePeer value)
	{
		return super.contains(value);
	}
	
	public void insertDistinctItem(EnginePeer newValue)
	{	
		if(!this.contains(newValue))
			this.insertItem(newValue);
	}
}
