package sim.engine;

import java.util.Vector;

public class SignalList extends Vector
{
	public SignalList(int size)
	{
		super(size);
		
		this.setSize(size);
	}
	
	public SignalList()
	{
		super();
	}
		
	public int getSize()
	{
		return super.size();
	}
	
	public Signal getItemAt(int index)
	{		
		return (Signal)super.elementAt(index);
	}
	
	public void removeItemAt(int index)
	{
		super.removeElementAt(index);
	}
	
	public void removeItem(Signal oldValue)
	{
		super.removeElement(oldValue);
	}
	
	public void removeAll()
	{
		super.removeAllElements();
	}
	
	public void changeItem(int index, Signal newValue)
	{
		super.setElementAt(newValue, index);
	}
	
	public void resetItem(int index)
	{
		super.setElementAt(null, index);
	}
	
	public void insertItem(Signal newValue)
	{
		super.addElement(newValue);
	}
	
	public void insertItemAt(int index, Signal newValue)
	{
		super.insertElementAt(newValue, index);
	}
	
	public boolean contains(Signal value)
	{
		return super.contains(value);
	}
	
	public void sortedInsert(Signal newValue)
	{
		boolean completed = false;
		
		if(this.getSize() == 0)
		{
			this.insertItem(newValue);
		}
		else
		{
			for(int loop = 0; (loop < this.getSize()) && (!completed); loop++)
				if(this.getItemAt(loop).getTime() > newValue.getTime())
				{
					// insert data
					completed = true;
					this.insertItemAt(loop, newValue);
				}
			
			if(!completed)
				this.insertItem(newValue);
		}
	}
	
	public void clearAfterInsert(Signal newValue)	// insert Signal and removes any uncompleted
	{
		boolean completed = false;
		
		if(this.getSize() == 0)
		{
			this.insertItem(newValue);
		}
		else
		{
			for(int loop = 0; (loop < this.getSize()) && (!completed); loop++)
				if(this.getItemAt(loop).getTime() > newValue.getTime())
				{
					// insert data
					completed = true;
					this.insertItemAt(loop, newValue);
					
					// remove data that were generated afterwords by this source
					for(int index = loop + 1; index < this.getSize(); index++)
					{
						if((this.getItemAt(index).getSource() == newValue.getSource()) && (this.getItemAt(index).getPin() == newValue.getPin()))
						{
							this.removeItemAt(index);
							index--;
						}
					}
				}
			
			if(!completed)
				this.insertItem(newValue);
		}
	}
	
	public void destructiveInsert(Signal newValue)	// insert Signal and removes any others
	{
		boolean completed = false;
		
		if(this.getSize() == 0)
		{
			this.insertItem(newValue);
		}
		else
		{
			// delete all signal previosly inserted by source
			for(int loop = 0; loop < this.getSize(); loop++)
				if((this.getItemAt(loop).getSource() == newValue.getSource()) && (this.getItemAt(loop).getPin() == newValue.getPin()))
				{
					this.removeItemAt(loop);
					loop--;
				}
			
			
			for(int loop = 0; (loop < this.getSize()) && (!completed); loop++)
				if(this.getItemAt(loop).getTime() > newValue.getTime())
				{
					// insert data
					completed = true;
					this.insertItemAt(loop, newValue);
				}
			
			if(!completed)
				this.insertItem(newValue);
		}
	}
}