package sim;

import java.awt.*;
import java.awt.event.*;

import sim.util.SimButton;
import sim.util.SimButtonListener;
import sim.engine.*;

public class EditShortcut extends Panel
{	
	private EditShortcutListener listener;
	
	public EditShortcut()
	{
		super();
		
		this.setLayout(new FlowLayout(FlowLayout.LEFT, 8, 0));
	}
	
	public void addNotify()
	{
		super.addNotify();
		this.listener = new EditShortcutListener(this);
	}
/* ==================================================================
	Services provided to Menu
	================================================================ */
	public void deleteSelected()
	{
		this.listener.deleteSelected();
	}
	
		
	public void rotateRight()
	{
		this.listener.rotateRight();
	}
	
	public void rotateLeft()
	{
		this.listener.rotateLeft();
	}
	
	public void rotateTo(int angles)
	{
		this.listener.rotateTo(angles);
	}
	
	public void flipHorizontal()
	{
		this.listener.flipHorizontal();
	}
	
	public void flipVertical()
	{
		this.listener.flipVertical();
	}
	
	public void showProperties()
	{
		this.listener.showProperties();
	}
	
/* ==================================================================
	Services provided to EditListener
	================================================================ */
	public void selected(WrapperList wrappers)
	{	
		this.listener.selected(wrappers);
	}
	
	public void deselect()
	{
		this.listener.deselect();
	}
	
/* ==================================================================
	Listener to handle mouse events
	================================================================= */
	private class EditShortcutListener extends SimButtonListener
	{
		private SimButton delete;
		
		private SimButton rotateRight;
		private SimButton rotateLeft;
		private SimButton flipHorisontal;
		private SimButton flipVertical;
		
		private boolean buttonUpOnLastMouseDown;
		
		public EditShortcutListener(EditShortcut parent)
		{
			this.buttonUpOnLastMouseDown = true;
			
			Panel p = new Panel(new FlowLayout(FlowLayout.LEFT, 0, 0));
			parent.add(p);
			
			this.delete = new SimButton("sim/images/Delete.gif", "Delete", NorthPanel.BUBBLE_WAIT);
			this.delete.setListener(this);
			p.add(this.delete);
			
			this.delete.setEnabled(false);
			
			p = new Panel(new FlowLayout(FlowLayout.LEFT, 0, 0));
			parent.add(p);
			
			this.rotateLeft = new SimButton("sim/images/RotateLeft.gif", "Rotate Left", NorthPanel.BUBBLE_WAIT);
			this.rotateLeft.setListener(this);
			p.add(this.rotateLeft);
			
			this.rotateRight = new SimButton("sim/images/RotateRight.gif", "Rotate Right", NorthPanel.BUBBLE_WAIT);
			this.rotateRight.setListener(this);
			p.add(this.rotateRight);
			
			this.flipHorisontal = new SimButton("sim/images/FlipHorizontal.gif", "Flip Horizontal", NorthPanel.BUBBLE_WAIT);
			this.flipHorisontal.setListener(this);
			p.add(this.flipHorisontal);
			
			this.flipVertical = new SimButton("sim/images/FlipVertical.gif", "Flip Vertical", NorthPanel.BUBBLE_WAIT);
			this.flipVertical.setListener(this);
			p.add(this.flipVertical);
			
			this.rotateLeft.setEnabled(false);
			this.rotateRight.setEnabled(false);
			this.flipHorisontal.setEnabled(false);
			this.flipVertical.setEnabled(false);
			
		}
		
		public void actionPerformed(ActionEvent e)
		{
			SimButton ib = (SimButton)e.getSource();
			ib.paintRaised();
			if(ib == this.delete)
			{
				this.deleteSelected();
			}
			else if(ib == this.rotateRight)
			{
				this.rotateRight();
			}
			else if(ib == this.rotateLeft)
			{
				this.rotateLeft();
			}
			else if(ib == this.flipHorisontal)
			{
				this.flipHorizontal();
			}
			else if(ib == this.flipVertical)
			{
				this.flipVertical();
			}
		}
		
		public void activate(SimButton ib)
		{
			ib.processActionEvent();
			ib.setArmed(false);
		}
		
		public void arm(SimButton ib)
		{
			ib.setArmed(true);
		}
		
		public void disarm(SimButton ib)
		{
			ib.setArmed(false);
		}
		
		public void mousePressed(MouseEvent event)
		{
			SimButton ib = (SimButton)event.getSource();
			if(ib.isEnabled())
				if(ib.isRaised())
				{
					ib.paintInset();
					this.buttonUpOnLastMouseDown = ib.isRaised();
					this.arm(ib);
				}
		}
	
		public void mouseClicked(MouseEvent event)
		{
			SimButton ib = (SimButton)event.getSource();
			if(ib.isEnabled() && ib.isArmed())
				this.activate(ib);
		}
		
		public void mouseReleased(MouseEvent event)
		{
			SimButton ib = (SimButton)event.getSource();
			Point pt = event.getPoint();
			
			if(ib.contains(pt.x, pt.y))
				this.mouseClicked(event);
		}
		
		public void mouseDragged(MouseEvent event)
		{
			SimButton ib = (SimButton)event.getSource();
			if(ib.isEnabled() && ib.isArmed())
			{
				Point loc = event.getPoint();
				
				if(ib.contains(loc.x,loc.y))
				{
					if(buttonUpOnLastMouseDown)
					{
						if( ! ib.isRaised()) 
							ib.paintRaised();
					}
					else
						if(ib.isRaised())
							ib.paintInset();
				}
				else
				{
					if(this.buttonUpOnLastMouseDown)
						{
						if(ib.isRaised())
							ib.paintInset();
					}
					else
						if(!ib.isRaised())
							ib.paintRaised();
				}
			}
		}
		
	/* ==================================================================
		Services provided to EditShortcut
		================================================================ */
		private boolean rotatale = false;
		private boolean flippable = false;
		private boolean editMode = false;
		private Wrapper toEdit = null;
		
		public void deselect()
		{
			if(this.editMode)
			{
				this.editMode = false;
				this.delete.setEnabled(false);
				SimMenuBar.DELETE.setEnabled(false);
			}
			
			if(this.rotatale)
			{
				this.rotatale = false;
				this.rotateRight.setEnabled(false);
				this.rotateLeft.setEnabled(false);
				SimMenuBar.ANGLES.setEnabled(false);
				SimMenuBar.ROTATE_LEFT.setEnabled(false);
				SimMenuBar.ROTATE_RIGHT.setEnabled(false);
			}
			
			if(this.flippable)
			{
				this.flippable = false;
				this.flipHorisontal.setEnabled(false);
				this.flipVertical.setEnabled(false);
				SimMenuBar.FLIP_HORIZONTAL.setEnabled(false);
				SimMenuBar.FLIP_VERTICAL.setEnabled(false);
			}
			
			this.toEdit = null;
		}
		
		public void selected(WrapperList wrappers)
		{
			if(!wrappers.isEmpty() && !this.editMode)
			{
				this.editMode = true;
				this.delete.setEnabled(true);
				
				SimMenuBar.DELETE.setEnabled(true);
			}
			else if(wrappers.isEmpty() && this.editMode)
			{
				this.editMode = false;
				this.delete.setEnabled(false);
				SimMenuBar.DELETE.setEnabled(false);
			}
			
			if(wrappers.getSize() == 1)
			{	
				this.toEdit = wrappers.getItemAt(0);
				
				if(this.toEdit.canRotate() && (!this.rotatale))
				{
					this.rotatale = true;
					this.rotateRight.setEnabled(true);
					this.rotateLeft.setEnabled(true);
					
					SimMenuBar.ANGLES.setEnabled(true);
					SimMenuBar.ROTATE_LEFT.setEnabled(true);
					SimMenuBar.ROTATE_RIGHT.setEnabled(true);
				}
				else if((!this.toEdit.canRotate()) && this.rotatale)
				{
					this.rotatale = false;
					this.rotateRight.setEnabled(false);
					this.rotateLeft.setEnabled(false);
					
					SimMenuBar.ANGLES.setEnabled(false);
					SimMenuBar.ROTATE_LEFT.setEnabled(false);
					SimMenuBar.ROTATE_RIGHT.setEnabled(false);
				}
				
				if(this.toEdit.canFlip() && (!this.flippable))
				{
					this.flippable = true;
					this.flipHorisontal.setEnabled(true);
					this.flipVertical.setEnabled(true);
					
					SimMenuBar.FLIP_HORIZONTAL.setEnabled(true);
					SimMenuBar.FLIP_VERTICAL.setEnabled(true);
				}
				else if((!this.toEdit.canFlip()) && this.flippable)
				{
					this.flippable = false;
					this.flipHorisontal.setEnabled(false);
					this.flipVertical.setEnabled(false);
					
					SimMenuBar.FLIP_HORIZONTAL.setEnabled(false);
					SimMenuBar.FLIP_VERTICAL.setEnabled(false);
				}
				
				SimMenuBar.PROPERTY.setEnabled(this.toEdit.hasProperties());
			}
			else
			{
				if(this.rotatale)
				{
					this.rotatale = false;
					this.rotateRight.setEnabled(false);
					this.rotateLeft.setEnabled(false);
					
					SimMenuBar.ANGLES.setEnabled(false);
					SimMenuBar.ROTATE_LEFT.setEnabled(false);
					SimMenuBar.ROTATE_RIGHT.setEnabled(false);
					
				}
				
				if(this.flippable)
				{
					this.flippable = false;
					this.flipHorisontal.setEnabled(false);
					this.flipVertical.setEnabled(false);
					
					SimMenuBar.FLIP_HORIZONTAL.setEnabled(false);
					SimMenuBar.FLIP_VERTICAL.setEnabled(false);
				}
				
				this.toEdit = null;
				SimMenuBar.PROPERTY.setEnabled(false);
	
			}
		}
		
		public void deleteSelected()
		{
			WestPanel.MODE_CONTROL.getEditHandler().deleteSelected();
			
			this.editMode = false;
			this.delete.setEnabled(false);
			SimMenuBar.DELETE.setEnabled(false);
			
			if(this.rotatale)
			{
				this.rotatale = false;
				this.rotateRight.setEnabled(false);
				this.rotateLeft.setEnabled(false);
				
				SimMenuBar.ANGLES.setEnabled(false);
				SimMenuBar.ROTATE_LEFT.setEnabled(false);
				SimMenuBar.ROTATE_RIGHT.setEnabled(false);
			}
			
			if(this.flippable)
			{
				this.flippable = false;
				this.flipHorisontal.setEnabled(false);
				this.flipVertical.setEnabled(false);
				
				SimMenuBar.FLIP_HORIZONTAL.setEnabled(false);
				SimMenuBar.FLIP_VERTICAL.setEnabled(false);
			}
		}
		
		public void rotateRight()
		{
			CentralPanel.ACTIVE_GRID.eraseComponent(this.toEdit);
			this.toEdit.rotateRight();
			CentralPanel.ACTIVE_GRID.paintComponent(this.toEdit);
		}
		
		public void rotateLeft()
		{
			CentralPanel.ACTIVE_GRID.eraseComponent(this.toEdit);
			this.toEdit.rotateLeft();
			CentralPanel.ACTIVE_GRID.paintComponent(this.toEdit);
		}
		
		public void rotateTo(int angles)
		{
			CentralPanel.ACTIVE_GRID.eraseComponent(this.toEdit);
			this.toEdit.setAngle(angles);
			CentralPanel.ACTIVE_GRID.paintComponent(this.toEdit);
		}
	
		
		public void flipHorizontal()
		{
			CentralPanel.ACTIVE_GRID.eraseComponent(this.toEdit);
			this.toEdit.flipHorizontal();
			CentralPanel.ACTIVE_GRID.paintComponent(this.toEdit);
		}
		
		public void flipVertical()
		{
			CentralPanel.ACTIVE_GRID.eraseComponent(this.toEdit);
			this.toEdit.flipVertical();
			CentralPanel.ACTIVE_GRID.paintComponent(this.toEdit);
		}
		
		public void showProperties()
		{
			WrapperMenu.PROPERTY_DIALOG.activate(this.toEdit);
		}
	}
}

