package sim;

import java.awt.*;
import java.awt.event.*;

import sim.util.DialogButton;
import sim.util.ImagePanel;

public class PropertyDialog extends Dialog implements ActionListener
{
	private Wrapper target;
	private Component properties = null;
	private ImagePanel icon = new ImagePanel();
	private Label name = new Label();
	
	public PropertyDialog()
	{
		super(MainWindow.MAIN_WINDOW, "Properties");
		
		this.setLayout(new GridBagLayout());
		this.setModal(true);
		this.setResizable(false);
		
		Panel p = new Panel(new FlowLayout(FlowLayout.RIGHT, 10, 10));
		
		DialogButton b = new DialogButton("OK");
		b.addActionListener(this);
		p.add(b);
		b = new DialogButton("Cancel");
		b.addActionListener(this);
		p.add(b);
		
		GridBagConstraints c = new GridBagConstraints();
		c.gridx = 0;
		c.gridy = 2;
		c.gridwidth = 2;
		c.gridheight = 1;
		c.anchor = GridBagConstraints.EAST;
		c.fill = GridBagConstraints.NONE;
		
		this.add(p, c);
		
		c.gridy = 0;
		c.gridwidth = 1;
		c.insets = new Insets(10, 10, 10, 0);
		c.anchor = GridBagConstraints.CENTER;
		
		this.add(this.icon, c);
		
		c.gridx = 1;
		c.insets = new Insets(0, 10, 0, 0);
		c.anchor = GridBagConstraints.WEST;
		
		this.add(this.name, c);
		
		this.addWindowListener(new WindowAdapter()
		{
			public void windowClosing(WindowEvent e)
			{
				hide();
				remove(properties);
				properties = null;
				target = null;
			}
		});
	}
	
	public void show()
	{
		int width = 40 + this.properties.getSize().width + this.getInsets().left + this.getInsets().right;
		int height = 80 + this.properties.getSize().height + this.icon.getSize().height + DialogButton.HEIGHT + this.getInsets().top + this.getInsets().bottom;
		this.setSize(width, height);
		this.doLayout();
		
		this.setLocation(MainWindow.getMiddleOfScreen(this));
		
		super.show();
	}
	
	public void addNotify()
	{
		super.addNotify();
		
		int width = 40 + this.properties.getSize().width + this.getInsets().left + this.getInsets().right;
		int height = 80 + this.properties.getSize().height + this.icon.getSize().height + DialogButton.HEIGHT + this.getInsets().top + this.getInsets().bottom;
		this.setSize(width, height);
		this.doLayout();
		
		this.setLocation(MainWindow.getMiddleOfScreen(this));
	}
	
	public void activate(Wrapper w)
	{
		this.target = w;
		this.properties = w.getPropertyWindow();
		
		this.icon.setImage(w.getIcon());
		this.name.setText(w.getBubbleHelp());
		this.name.invalidate();
		
		GridBagConstraints c = new GridBagConstraints();
		c.gridx = 0;
		c.gridy = 1;
		c.gridwidth = 2;
		c.gridheight = 1;
		c.insets = new Insets(0, 20, 40, 20);
		c.anchor = GridBagConstraints.CENTER;
		c.fill = GridBagConstraints.NONE;
		
		this.add(this.properties, c);
		this.show();
	}
	
	public void actionPerformed(ActionEvent e)
	{
		this.hide();
		
		if(((DialogButton)e.getSource()).getLabel().equals("OK"))
			this.target.respondToChanges(this.properties);
		
		this.remove(this.properties);
		
		this.properties = null;
		this.target = null;
	}
	
	public void paint(Graphics g)
	{	
		super.paint(g);
	
		Rectangle r = this.properties.getBounds();
		
		r.x = r.x - 10;
		r.y = r.y - 5;
		
		r.width = r.width + 20;
		r.height = r.height + 40;
			
		g.setColor(Color.white);
		g.drawLine(r.x, r.y, r.x + r.width - 2, r.y);
		g.drawLine(r.x, r.y, r.x, r.y + r.height - 2);
		
		g.setColor(Color.black);
		g.drawLine(r.x + r.width - 1, r.y, r.x + r.width - 1, r.y + r.height - 1);
		g.drawLine(r.x, r.y + r.height - 1, r.x + r.width - 1, r.y + r.height - 1);
		
		g.setColor(this.getBackground().darker());
		g.drawLine(r.x + r.width - 2, r.y + 1, r.x + r.width - 2, r.y + r.height - 2);
		g.drawLine(r.x + 1, r.y + r.height - 2, r.x + r.width - 2, r.y + r.height - 2);
	}
}
