package sim.lib.wires;

import java.awt.*;
import java.util.Vector;

import sim.*;
import sim.engine.*;

public class JunctionList extends Vector
{
	public JunctionList(int size)
	{
		super(size);
		
		this.setSize(size);
	}
	
	public JunctionList()
	{
		super();
	}
		
	public int getSize()
	{
		return super.size();
	}
	
	public Junction getItemAt(int index)
	{		
		return (Junction)super.elementAt(index);
	}
	
	public void removeItemAt(int index)
	{
		super.removeElementAt(index);
	}
	
	public void removeItem(Junction oldValue)
	{
		super.removeElement(oldValue);
	}
	
	public void removeAll()
	{
		super.removeAllElements();
	}
	
	public void changeItem(int index, Junction newValue)
	{
		super.setElementAt(newValue, index);
	}
	
	public void resetItem(int index)
	{
		super.setElementAt(null, index);
	}
	
	public void insertItem(Junction newValue)
	{
		super.addElement(newValue);
	}
	
	public void insertItemAt(int index, Junction newValue)
	{
		super.insertElementAt(newValue, index);
	}
	
	public boolean contains(Junction value)
	{
		return super.contains(value);
	}
	
	public int indexOf(Junction value)
	{
		return super.indexOf(value);
	}
}

