package sim;

import java.awt.*;
import java.awt.event.*;
import java.applet.Applet;

import sim.util.BubbleListener;
import sim.util.BubbleWaitThread;
import sim.util.SimBubble;

public class MainWindow extends Frame
{
	public static final String PROGRAM_NAME = "ReTrO";
	public static final String VERSION = "HS V1.0";
	
	public static MainWindow MAIN_WINDOW;
	public static WestPanel WEST_PANEL;
	public static CentralPanel CENTRAL_PANEL;
	public static SouthPanel SOUTH_PANEL;
	public static NorthPanel NORTH_PANEL;
	
	public static SimMenuBar MENU;
 	public static Applet MASTER;
	public static OkWindow OK_WINDOW;
	
	public static Color BACKGROUND;
	
	public static Point getMiddleOfScreen(Component c)
	{
		Dimension screen = MainWindow.MAIN_WINDOW.getToolkit().getScreenSize();
		Dimension size = c.getSize();
		
		return (new Point((screen.width - size.width) / 2, (screen.height - size.height) / 2));
	}
	
	public MainWindow(Applet master)
	{
		super();
		
		MainWindow.MASTER = master;
		MainWindow.MAIN_WINDOW = this;
		
		// show splash screen
		SplashWindow splash = new SplashWindow(this);
		long startSplash = System.currentTimeMillis();
		
		BubbleListener.WAIT_THREAD = new BubbleWaitThread();
		BubbleListener.WAIT_THREAD.start();
		BubbleWaitThread.BUBBLE_WINDOW = new SimBubble(this);
		
		// initialise frames components
		this.setLayout(new BorderLayout(2, 2));
		
		MainWindow.BACKGROUND = SystemColor.control;
		this.setBackground(MainWindow.BACKGROUND);
		
		MainWindow.SOUTH_PANEL = new SouthPanel();
		MainWindow.WEST_PANEL = new WestPanel();
		MainWindow.CENTRAL_PANEL = new CentralPanel();
		MainWindow.NORTH_PANEL = new NorthPanel();
		
		this.add(MainWindow.SOUTH_PANEL, BorderLayout.SOUTH);
		this.add(MainWindow.WEST_PANEL, BorderLayout.WEST);
		this.add(MainWindow.CENTRAL_PANEL, BorderLayout.CENTER);
		this.add(MainWindow.NORTH_PANEL, BorderLayout.NORTH);
		
		// initialise frame
		this.setSize(MainWindow.MAIN_WINDOW.getToolkit().getScreenSize());
		this.setLocation(MainWindow.getMiddleOfScreen(this));
		
		MainWindow.MENU = new SimMenuBar();
		MainWindow.OK_WINDOW = new OkWindow(this);
		MainWindow.OK_WINDOW.setTitle(MainWindow.PROGRAM_NAME);
		
		this.setMenuBar(MENU);
		
		this.addWindowListener(new WindowAdapter()
		{
			public void windowClosing(WindowEvent event)
			{
				exit();
			}
			
			public void windowActivated(WindowEvent e)
			{
				if(!SimMenuBar.STOP.isEnabled())
					MainWindow.WEST_PANEL.realSetEnabled(true);
				
				MainWindow.NORTH_PANEL.setEnabled(true);
			}
			
			public void windowDeactivated(WindowEvent e)
			{
				MainWindow.WEST_PANEL.realSetEnabled(false);
				MainWindow.NORTH_PANEL.setEnabled(false);
			}
		});
		
		while(System.currentTimeMillis() - startSplash < 5000)
		{
			// wait for 5 seconds for splash screen
		}
		
		splash.dispose();
		this.setVisible(true);
	}
	
	public void exit()
	{
		BubbleListener.WAIT_THREAD.stop();
		
		if(RunShortcut.PLAY_THREAD != null)
			if(RunShortcut.PLAY_THREAD.isAlive())
			{
				RunShortcut.PLAY_THREAD.stop();
				
				while(RunShortcut.PLAY_THREAD.isAlive())
				{
				}
			}
		
		this.dispose();
		
		if(MainWindow.MASTER != null)
			MainWindow.MASTER.destroy();
		else
			System.exit(0);
	}
}