package sim;

import java.awt.*;

import sim.util.SimSeparator;
import sim.lib.RtlModulePanel;

public class WestPanel extends Panel
{
	public static ToolbarListener MODE_CONTROL;
	
	public static final long BUBBLE_WAIT = 500;
	public static final int ICON_SIZE = 32;
	
	private RtlModulePanel gates;
	private EssentialModulePanel essential;

	public WestPanel()
	{
		super();
			
		WestPanel.MODE_CONTROL = new ToolbarListener();
		
		this.setBackground(MainWindow.BACKGROUND);
		
		this.setLayout(new BorderLayout(0, 4));
		Panel p = new Panel(new BorderLayout(0, 4));
		
		this.gates = new RtlModulePanel();
		this.essential = new EssentialModulePanel();
		
		p.add(BorderLayout.NORTH, this.essential);
		p.add(BorderLayout.CENTER, this.gates);
		
		this.add(BorderLayout.NORTH, new SimSeparator());		
		this.add(BorderLayout.CENTER, p);
	}
	
	public void setEnabled(boolean b)
	{
		super.setEnabled(b);
	//	this.gates.setEnabled(b);
	//	this.essential.setEnabled(b);
		
		if(b)
			WestPanel.MODE_CONTROL.initialiseListeners();
		else
			WestPanel.MODE_CONTROL.removeListeners();
	}
	
	public void realSetEnabled(boolean b)
	{
		super.setEnabled(b);
	}
	
	public Dimension getPreferredSize()
	{
		return (new Dimension(150,1));		
	}
	
	public void addNotify()
	{
		super.addNotify();
		WestPanel.MODE_CONTROL.getCurrnetActive().paintInset();
	}
}
