package sim.lib.functions;

import java.awt.*;

import sim.*;
import sim.engine.*;

import sim.lib.wires.Junction;

public class Add extends Function2in1fat1thinOut
{
/* ==================================================================
	Creation Part
	================================================================= */
	private static Image ICON = GuiFileLink.getImage("sim/lib/functions/AddUnitIcon.gif");
	
	public Image getIcon()
	{
		return Add.ICON;
	}
	
	public String getBubbleHelp()
	{
		return "Add unit";
	}
	
/* ==================================================================
	GUI part
	================================================================= */
	public Add()
	{
		super();
	}
	
	protected Wrapper getCopy()
	{
		Add result = new Add();
		result.changeDelay(this.delay);
		result.setBusSize(this.busSize);
		return result;
	}
	
	public void paint(Graphics g)
	{
		// draw if visible
		if(this.isVisible())
		{
			int gridGap = CentralPanel.ACTIVE_GRID.getCurrentGridGap();
			int increment = gridGap / 4;
			int tripple = 3 * gridGap;
			
			g.setColor(this.brush);
			
			g.drawLine(gridGap + increment, gridGap, 10 * increment, gridGap);
			g.drawLine(14 * increment, gridGap, 19 * increment, gridGap);
			
			g.drawLine(10 * increment, gridGap, tripple, 6 * increment);
			g.drawLine(14 * increment, gridGap, tripple, 6 * increment);
			
			g.drawLine(gridGap + increment, tripple, 19 * increment, tripple);
			
			g.drawLine(gridGap + increment, gridGap, gridGap + increment, tripple);
			g.drawLine(19 * increment, gridGap, 19 * increment, tripple);
			
			
			g.drawLine(0, 2 * gridGap, gridGap + increment, 2 * gridGap);
			g.fillRect(2 * gridGap - 1, 0, 3, gridGap);
			g.fillRect(4 * gridGap - 1, 0, 3, gridGap);
			g.fillRect(tripple - 1, tripple, 3, gridGap);
			
			g.setFont(new Font(Wrapper.FONT_NAME, Font.PLAIN, 3 * increment));
			
			FontMetrics fm = g.getFontMetrics(g.getFont());
			g.drawString("+", tripple - fm.stringWidth("+") / 2, 10 * increment);
		}
	}
	
/* ==================================================================
	Simulation part
	================================================================= */
	public void evaluateOutput(double currentTime, Data[] currentInputs, EnginePeer peer)
	{
		double time = this.delay + currentTime;
		
		int loop;
		int x = 0;
		int y = 0;
		int base = 1;
		boolean foundUndefined = false;
		String bitValue;
		
		for(loop = 0; (loop < this.busSize) && (!foundUndefined); loop++)
		{
			if(currentInputs[loop].isUndefined() || currentInputs[loop + this.busSize].isUndefined())
				foundUndefined = true;
			else
			{
				if(currentInputs[loop].getValue())
					x = x + base;
				
				if(currentInputs[loop + this.busSize].getValue())
					y = y + base;
			}
			
			base = 2 * base;
		}
		
		if(foundUndefined)
		{
			for(loop = 0; loop <= this.busSize;loop++)
				peer.setOutputPinUndefined(loop, time);
		}
		else
		{
			x = x + y;
			bitValue = Integer.toBinaryString(x);
			
			peer.setOutputPinValue(this.busSize, bitValue.length() > this.busSize, time);
			
			for(loop = bitValue.length(); loop < this.busSize; loop ++)
				bitValue = "0" + bitValue;
			
			for(loop = 0; loop < this.busSize; loop++)
				peer.setOutputPinValue(loop, bitValue.charAt(bitValue.length() - 1 - loop) == '1', time);
		}
	}
}