package sim.lib.others;

import java.awt.*;
import java.awt.event.*;

import sim.util.SimSeparator;

public class MuxProperties extends Container implements ActionListener, FocusListener
{
	private TextField editBus = new TextField(5);
	private TextField editSelectSize = new TextField(5);
	private TextField editDelay = new TextField(10);
	private double oldDelay;
	private int oldBus;
	private int oldSize;
	
	private Label pins = new Label("Pins");
	private Label simulation = new Label("Simulation");
	
	public MuxProperties(int bus, int size, double delay)
	{
		super();
		this.setLayout(new BorderLayout(0, 15));
		
		this.oldBus = bus;
		this.editBus.addActionListener(this);
		this.editBus.addFocusListener(this);
		this.editBus.setText(Integer.toString(bus));
		
		this.oldDelay = delay;
		this.editDelay.addActionListener(this);
		this.editDelay.addFocusListener(this);
		this.editDelay.setText(Double.toString(delay));
		
		this.oldSize = size;
		this.editSelectSize.addActionListener(this);
		this.editSelectSize.addFocusListener(this);
		this.editSelectSize.setText(Integer.toString(size));
		
		// pins
		Panel big = new Panel(new BorderLayout(0, 15));
		Panel p = new Panel(new BorderLayout());
		p.add(this.pins, BorderLayout.WEST);
		p.add(new SimSeparator(), BorderLayout.CENTER);
		big.add(p, BorderLayout.NORTH);
		
		Panel p2 = new Panel(new GridBagLayout());
		
		p = new Panel(new FlowLayout(FlowLayout.LEFT, 0, 0));
		p.add(new Label("Bus Size"));
		p.add(this.editBus);
		GridBagConstraints c = new GridBagConstraints();
		c.gridx = 0;
		c.gridy = 0;
		c.gridwidth = 1;
		c.gridheight = 1;
		c.fill = GridBagConstraints.NONE;
		c.anchor = GridBagConstraints.WEST;
		c.weightx = 1;
		c.weighty = 0;
		p2.add(p, c);
		
		p = new Panel(new FlowLayout(FlowLayout.LEFT, 0, 0));
		p.add(new Label("Select Lines"));
		p.add(this.editSelectSize);
		c.gridx = 1;
		c.anchor = GridBagConstraints.EAST;
		p2.add(p, c);
		big.add(p2, BorderLayout.CENTER);
		this.add(big, BorderLayout.NORTH);
		
		// simulation
		big = new Panel(new BorderLayout(0, 15));
		p = new Panel(new BorderLayout());
		p.add(this.simulation, BorderLayout.WEST);
		p.add(new SimSeparator(), BorderLayout.CENTER);
		big.add(p, BorderLayout.NORTH);
		
		p = new Panel(new FlowLayout(FlowLayout.LEFT, 0, 0));
		p.add(new Label("Propagation Delay"));
		p.add(this.editDelay);
		big.add(p, BorderLayout.CENTER);
		
		this.add(big, BorderLayout.CENTER);
	}
	
	public void addNotify()
	{
		super.addNotify();
		this.setSize(290, this.editDelay.getPreferredSize().height * 2 + this.pins.getPreferredSize().height * 2 + 45);
	}
	
	public void actionPerformed(ActionEvent e)
	{
		TextField source = (TextField)e.getSource();
		
		if(source == this.editDelay)
			this.getDelay();
		else if(source == this.editBus)
			this.getBusSize();
		else if(source == this.editSelectSize)
			this.getInputSize();
	}
	
	public void focusGained(FocusEvent e)
	{
	}
	
	public void focusLost(FocusEvent e)
	{
		TextField source = (TextField)e.getSource();
		
		if(source == this.editDelay)
			this.getDelay();
		else if(source == this.editBus)
			this.getBusSize();
		else if(source == this.editSelectSize)
			this.getInputSize();
		
		source.setText(source.getText());
	}
	
	public int getBusSize()
	{
		int newBus;
		
		try
		{
			newBus = Integer.valueOf(this.editBus.getText()).intValue();
			
			if(newBus > 0)
				this.oldBus = newBus;
			else
				this.editBus.setText(Integer.toString(this.oldBus));
		}
		catch(NumberFormatException nfe)
		{
			this.editBus.setText(Integer.toString(this.oldBus));
		}
		
		return this.oldBus;
	}
	
	public int getInputSize()
	{
		int newSize;
		
		try
		{
			newSize = Integer.valueOf(this.editSelectSize.getText()).intValue();
			
			if((newSize > 0) && (newSize < 7))
				this.oldSize = newSize;
			else
				this.editSelectSize.setText(Integer.toString(this.oldSize));
		}
		catch(NumberFormatException nfe)
		{
			this.editSelectSize.setText(Integer.toString(this.oldSize));
		}
		
		return this.oldSize;
	}
	
	public double getDelay()
	{
		double newDelay;
		
		try
		{
			newDelay = Double.valueOf(this.editDelay.getText()).doubleValue();
			
			if(newDelay >= 0)
				this.oldDelay = newDelay;
			else
				this.editDelay.setText(Double.toString(this.oldBus));
		}
		catch(NumberFormatException nfe)
		{
			this.editDelay.setText(Double.toString(this.oldBus));
		}
		
		return this.oldDelay;
	}
	
	public Dimension getPreferredSize()
	{
		return this.getSize();
	}
	
	public Dimension getMinimumSize()
	{
		return this.getSize();
	}

	public Dimension getMaximumSize()
	{
		return this.getSize();
	}
}
